﻿within ;
package Physiomodel "Mammalian physiology model"
  extends Physiolibrary.Icons.GolemLib;


  package CardioVascular "Blood and Cardio-Vascular System"
    extends Physiolibrary.Icons.CardioVascularLib;
    class References "References"
      extends Modelica.Icons.References;

      annotation (Documentation(info="<html>
<table>

        <tr>
                <td>[Alfie1999]</td>
                <td>J. Alfie, G. D. Waisman, C. R. Galarza, and M. I. Cámera, \"Contribution of Stroke Volume to the Change in Pulse Pressure Pattern With Age,\" Hypertension, vol. 34, pp. 808-812, October 1, 1999 1999. </td>
        </tr>
        <tr>
                <td>[Alsberge1988]</td>
                <td>M. Alsberge, M. Magno, and M. Lipschutz, Carotid body control of bronchial circulation in sheep vol. 65, 1988. </td>
        </tr>
        <tr>
                <td>[Archer2002]</td>
                <td>S. Archer and E. Michelakis, The Mechanism(s) of Hypoxic Pulmonary Vasoconstriction: Potassium Channels, Redox O2 Sensors, and Controversies vol. 17, 2002. </td>
        </tr>
        <tr>
                <td>[Archer1996]</td>
                <td>S. L. Archer, J. M. C. Huang, H. L. Reeve, V. Hampl, S. Tolarová, E. Michelakis, et al., \"Differential Distribution of Electrophysiologically Distinct Myocytes in Conduit and Resistance Arteries Determines Their Response to Nitric Oxide and Hypoxia,\" Circulation Research, vol. 78, pp. 431-442, March 1, 1996 1996. </td>
        </tr>
        <tr>
                <td>[Armstrong1985]</td>
                <td>R. Armstrong, C. Vandenakker, and M. Laughlin, \"Muscle blood flow patterns during exercise in partially curarized rats,\" Journal of Applied Physiology, vol. 58, pp. 698-701, 1985. </td>
        </tr>
        <tr>
                <td>[Ashley1992]</td>
                <td>K. D. Ashley, D. N. Herndon, L. D. Traber, D. L. Traber, K. Deubel-Ashley, J. Stothert, et al., \"Systemic blood flow to sheep lung: comparison of flow probes and microspheres,\" Journal of Applied Physiology, vol. 73, pp. 1996-1996, 1992. </td>
        </tr>
        <tr>
                <td>[Aukland1989]</td>
                <td>K. Aukland, \"Myogenic mechanisms in the kidney,\" Journal of hypertension. Supplement: official journal of the International Society of Hypertension, vol. 7, pp. S71-6; discussion S77, 1989. </td>
        </tr>
        <tr>
                <td>[Bangsbo1997]</td>
                <td>J. Bangsbo, C. Juel, Y. Hellsten, and B. Saltin, \"Dissociation between lactate and proton exchange in muscle during intense exercise in man,\" The Journal of Physiology, vol. 504, pp. 489-499, October 15, 1997 1997. </td>
        </tr>
        <tr>
                <td>[Bazett1997]</td>
                <td>H. C. Bazett, \"AN ANALYSIS OF THE TIME-RELATIONS OF ELECTROCARDIOGRAMS,\" Annals of Noninvasive Electrocardiology, vol. 2, pp. 177-194, 1997. </td>
        </tr>
        <tr>
                <td>[Begg1966]</td>
                <td>T. Begg and J. Hearns, \"Components in blood viscosity. The relative contribution of haematocrit, plasma fibrinogen and other proteins,\" Clinical science, vol. 31, pp. 87-93, 1966. </td>
        </tr>
        <tr>
                <td>[Berg1997]</td>
                <td>B. R. Berg, K. D. Cohen, and I. H. Sarelius, \"Direct coupling between blood flow and metabolism at the capillary level in striated muscle,\" American Journal of Physiology-Heart and Circulatory Physiology, vol. 41, p. H2693, 1997. </td>
        </tr>
        <tr>
                <td>[Bevegärd1962]</td>
                <td>S. Bevegärd and A. Lodin, \"Postural Circulatory Changes at Rest and during Exercise in five Patients with Congenital Absence of Valves in the Deep Veins of the Legs,\" Acta Medica Scandinavica, vol. 172, pp. 21-29, 1962. </td>
        </tr>
        <tr>
                <td>[Bock1930]</td>
                <td>A. V. Bock, D. B. Dill, and H. T. Edwards, \"ON THE RELATION OF CHANGES IN BLOOD VELOCITY AND VOLUME FLOW OF BLOOD TO CHANGE OF POSTURE,\" The Journal of Clinical Investigation, vol. 8, pp. 533-544, 1930. </td>
        </tr>
        <tr>
                <td>[Bootsma1994]</td>
                <td>M. Bootsma, C. A. Swenne, H. H. Van Bolhuis, P. C. Chang, V. M. Cats, and A. Bruschke, \"Heart rate and heart rate variability as indexes of sympathovagal balance,\" American Journal of Physiology, vol. 266, pp. H1565-H1565, 1994. </td>
        </tr>
        <tr>
                <td>[Borgström1975]</td>
                <td>L. Borgström, H. Jóhannsson, and B. K. Siesjö, \"The Relationship between Arterial PO2 and Cerebral Blood Flow in Hypoxic Hypoxia,\" Acta Physiologica Scandinavica, vol. 93, pp. 423-432, 1975. </td>
        </tr>
        <tr>
                <td>[BRADLEY1952]</td>
                <td>S. E. BRADLEY, F. J. INGELFINGER, and G. P. BRADLEY, \"Hepatic Circulation in Cirrhosis of the Liver,\" Circulation, vol. 5, pp. 419-429, March 1, 1952 1952. </td>
        </tr>
        <tr>
                <td>[Bradley1953]</td>
                <td>S. E. Bradley, P. A. Marks, P. C. Reynell, and J. Meltzer, \"The circulating splanchnic blood volume in dog and man,\" Trans Assoc Am Physicians, vol. 66, pp. 294-302, 1953. </td>
        </tr>
        <tr>
                <td>[Braunwald1976]</td>
                <td>E. Braunwald, J. Ross, and E. H. Sonnenblick, Mechanisms of contraction of the normal and failing heart: Little, Brown Boston, 1976. </td>
        </tr>
        <tr>
                <td>[Breslow1993]</td>
                <td>M. J. Breslow, J. R. Tobin, D. S. Bredt, C. D. Ferris, S. H. Snyder, and R. J. Traystman, Nitric oxide as a regulator of adrenal blood flow vol. 264, 1993. </td>
        </tr>
        <tr>
                <td>[Brezis1995]</td>
                <td>M. Brezis and S. Rosen, \"Hypoxia of the Renal Medulla — Its Implications for Disease,\" New England Journal of Medicine, vol. 332, pp. 647-655, 1995. </td>
        </tr>
        <tr>
                <td>[Burattini1994]</td>
                <td>R. Burattini, P. Borgdorff, and N. Westerhof, \"Relationship between strength of short-term systemic autoregulation and initial resistance,\" American Journal of Physiology-Regulatory Integrative and Comparative Physiology, vol. 36, p. R1182, 1994. </td>
        </tr>
        <tr>
                <td>[Carter1998]</td>
                <td>Y. M. Carter, C. X. Jia, P. F. Soto, J. P. Starr, D. G. Rabkin, D. T. Hsu, et al., \"Diastolic properties, myocardial water content, and histologic condition of the rat left ventricle: effect of varied osmolarity of a coronary perfusate,\" The Journal of heart and lung transplantation : the official publication of the International Society for Heart Transplantation, vol. 17, pp. 140-149, 1998/02// 1998. </td>
        </tr>
        <tr>
                <td>[Coleman1972]</td>
                <td>T. G. Coleman, R. D. Manning, Jr., R. A. Norman, Jr., and A. C. Guyton, \"Dynamics of water-isotope distribution,\" Am J Physiol, vol. 223, pp. 1371-5, Dec 1972. </td>
        </tr>
        <tr>
                <td>[Collins-Nakai1994]</td>
                <td>R. L. Collins-Nakai, D. Noseworthy, and G. D. Lopaschuk, \"Epinephrine increases ATP production in hearts by preferentially increasing glucose metabolism,\" Am J Physiol, vol. 267, pp. H1862-71, Nov 1994. </td>
        </tr>
        <tr>
                <td>[Davidson1986]</td>
                <td>D. Davidson, S. A. Stalcup, and R. B. Mellins, Systemic hemodynamics affecting cardiac output during hypocapnic and hypercapnic hypoxia vol. 60, 1986. </td>
        </tr>
        <tr>
                <td>[Drummond2008]</td>
                <td>H. A. Drummond, S. C. Grifoni, and N. L. Jernigan, \"A new trick for an old dogma: ENaC proteins as mechanotransducers in vascular smooth muscle,\" Physiology, vol. 23, pp. 23-31, 2008. </td>
        </tr>
        <tr>
                <td>[Drury1927]</td>
                <td>A. Drury and N. Jones, \"Observations upon the rate at which oedema forms when the veins of the human limb are congested,\" Heart, vol. 14, p. 8, 1927. </td>
        </tr>
        <tr>
                <td>[Dunbar2001]</td>
                <td>S. L. Dunbar, L. Tamhidi, D. E. Berkowitz, and A. A. Shoukas, Hindlimb unweighting affects rat vascular capacitance function vol. 281, 2001. </td>
        </tr>
        <tr>
                <td>[ECHT1974]</td>
                <td>M. ECHT, J. DÜWELING, O. H. GAUER, and L. LANGE, \"Effective Compliance of the Total Vascular Bed and the Intrathoracic Compartment Derived from Changes in Central Venous Pressure Induced by Volume Changes in Man,\" Circulation Research, vol. 34, pp. 61-68, January 1, 1974 1974. </td>
        </tr>
        <tr>
                <td>[Fan1980]</td>
                <td>F. C. Fan, R. Y. Chen, G. B. Schuessler, and S. Chien, Effects of hematocrit variations on regional hemodynamics and oxygen transport in the dog vol. 238, 1980. </td>
        </tr>
        <tr>
                <td>[Fatema2002]</td>
                <td>K. Fatema, O. Hirono, Y. Takeishi, J. Nitobe, K. Kaneko, M. Ito, et al., \"Hemodialysis improves myocardial interstitial edema and left ventricular diastolic function in patients with end-stage renal disease: noninvasive assessment by ultrasonic tissue characterization,\" Heart and vessels, vol. 16, pp. 227-231, 2002. </td>
        </tr>
        <tr>
                <td>[Ferguson1985]</td>
                <td>D. W. Ferguson, F. M. Abboud, and A. L. Mark, \"Relative contribution of aortic and carotid baroreflexes to heart rate control in man during steady state and dynamic increases in arterial pressure,\" The Journal of Clinical Investigation, vol. 76, pp. 2265-2274, 1985. </td>
        </tr>
        <tr>
                <td>[Fitzgerald1980]</td>
                <td>G. A. Fitzgerald, P. Barnes, C. A. Hamilton, and C. T. Dollery, \"Circulating adrenaline and blood pressure: the metabolic effects and kinetics of infused adrenaline in man,\" European Journal of Clinical Investigation, vol. 10, pp. 401-406, 1980. </td>
        </tr>
        <tr>
                <td>[Frisbee2000]</td>
                <td>J. C. Frisbee and J. H. Lombard, \"Increased Intravascular Pressure Does Not Enhance Skeletal Muscle Arteriolar Constriction to Oxygen or Angiotensin II,\" Microvascular Research, vol. 59, pp. 176-180, 1// 2000. </td>
        </tr>
        <tr>
                <td>[Frisbee2000]</td>
                <td>J. C. Frisbee and J. H. Lombard, \"Short-term angiotensin converting enzyme inhibition reduces basal tone and dilator reactivity in skeletal muscle arterioles*,\" American Journal of Hypertension, vol. 13, pp. 389-395, April 1, 2000 2000. </td>
        </tr>
        <tr>
                <td>[Gaasch1975]</td>
                <td>W. H. Gaasch, J. S. Cole, M. A. Quinones, and J. Alexander, \"Dynamic determinants of letf ventricular diastolic pressure-volume relations in man,\" Circulation, vol. 51, pp. 317-323, 1975. </td>
        </tr>
        <tr>
                <td>[GAUER1956]</td>
                <td>O. H. GAUER, J. P. HENRY, and H. O. SIEKER, \"Changes in Central Venous Pressure after Moderate Hemorrhage and Transfusion in Man,\" Circulation Research, vol. 4, pp. 79-84, January 1, 1956 1956. </td>
        </tr>
        <tr>
                <td>[Gibbs1942]</td>
                <td>E. L. Gibbs, F. A. Gibbs, W. G. Lennox, and L. F. Nims, \"REgulation of cerebral carbon dioxide,\" Archives of Neurology & Psychiatry, vol. 47, pp. 879-889, 1942. </td>
        </tr>
        <tr>
                <td>[Goodman1978]</td>
                <td>A. H. Goodman, R. Einstein, and H. J. Granger, \"Effect of changing metabolic rate on local blood flow control in the canine hindlimb,\" Circulation Research, vol. 43, pp. 769-76, November 1, 1978 1978. </td>
        </tr>
        <tr>
                <td>[Granger1969]</td>
                <td>H. J. Granger and A. C. Guyton, \"Autoregulation of the Total Systemic Circulation Following Destruction of the Central Nervous System in the Dog,\" Circulation Research, vol. 25, pp. 379-388, October 1, 1969 1969. </td>
        </tr>
        <tr>
                <td>[Granger1976]</td>
                <td>H. J. Granger, A. H. Goodman, and D. N. Granger, \"Role of resistance and exchange vessels in local microvascular control of skeletal muscle oxygenation in the dog,\" Circulation Research, vol. 38, pp. 379-85, May 1, 1976 1976. </td>
        </tr>
        <tr>
                <td>[Greenway1973]</td>
                <td>C. Greenway and G. Oshiro, \"Effects of histamine on hepatic volume (outflow block) in anaesthetized dogs,\" British journal of pharmacology, vol. 47, pp. 282-290, 1973. </td>
        </tr>
        <tr>
                <td>[Greenway1974]</td>
                <td>C. V. Greenway and G. E. Lister, \"Capacitance effects and blood reservoir function in the splanchnic vascular bed during non-hypotensive haemorrhage and blood volume expansion in anaesthetized cats,\" The Journal of Physiology, vol. 237, pp. 279-294, March 1, 1974 1974. </td>
        </tr>
        <tr>
                <td>[Greenway1985]</td>
                <td>C. V. Greenway, K. L. Seaman, and I. R. Innes, Norepinephrine on venous compliance and unstressed volume in cat liver vol. 248, 1985. </td>
        </tr>
        <tr>
                <td>[Gutsche1980]</td>
                <td>H. U. Gutsche, R. Müller-Suur, U. Hegel, and K. Hierholzer, \"Electrical conductivity of tubular fluid of the rat nephron,\" Pflügers Archiv, vol. 383, pp. 113-121, 1980/01/01 1980. </td>
        </tr>
        <tr>
                <td>[Guyton1961]</td>
                <td>A. C. Guyton and K. Sagawa, \"Compensations of cardiac output and other circulatory functions in areflex dogs with large AV fistulas,\" The American journal of physiology, vol. 200, p. 1157, 1961. </td>
        </tr>
        <tr>
                <td>[Harder1996]</td>
                <td>D. R. Harder, J. Narayanan, E. K. Birks, J. F. Liard, J. D. Imig, J. H. Lombard, et al., \"Identification of a Putative Microvascular Oxygen Sensor,\" Circulation Research, vol. 79, pp. 54-61, July 1, 1996 1996. </td>
        </tr>
        <tr>
                <td>[Harder1996]</td>
                <td>D. R. Harder, J. Narayanan, E. K. Birks, J. F. Liard, J. D. Imig, J. H. Lombard, et al., \"Identification of a Putative Microvascular Oxygen Sensor,\" Circulation Research, vol. 79, pp. 54-61, July 1, 1996 1996. </td>
        </tr>
        <tr>
                <td>[Hennessy1993]</td>
                <td>E. Hennessy, S. White, T. Van der Touw, A. Quail, W. Porges, and P. Glenfield, \"Control of resting bronchial hemodynamics in the awake dog,\" American Journal of Physiology, vol. 265, pp. H649-H649, 1993. </td>
        </tr>
        <tr>
                <td>[Henry1950]</td>
                <td>J. P. Henry and O. H. Gauer, \"THE INFLUENCE OF TEMPERATURE UPON VENOUS PRESSURE IN THE FOOT,\" The Journal of Clinical Investigation, vol. 29, pp. 855-861, 1950. </td>
        </tr>
        <tr>
                <td>[Heyeraas1987]</td>
                <td>K. J. Heyeraas and K. Aukland, \"Interlobular arterial resistance: Influence of renal arterial pressure and angiotensin II,\" Kidney Int, vol. 31, pp. 1291-1298, 06//print 1987. </td>
        </tr>
        <tr>
                <td>[Hogan1990]</td>
                <td>M. C. Hogan, D. E. Bebout, A. T. Gray, P. D. Wagner, J. B. West, and P. E. Haab, Muscle maximal O2 uptake at constant O2 delivery with and without CO in the blood vol. 69, 1990. </td>
        </tr>
        <tr>
                <td>[Charan1984]</td>
                <td>N. B. Charan, G. M. Turk, and R. Dhand, \"Gross and subgross anatomy of bronchial circulation in sheep,\" J Appl Physiol, vol. 57, pp. 658-664, 1984. </td>
        </tr>
        <tr>
                <td>[Charles1994]</td>
                <td>J. B. Charles and C. M. Lathers, \"Summary of Lower Body Negative Pressure Experiments During Space Flight,\" The Journal of Clinical Pharmacology, vol. 34, pp. 571-583, 1994. </td>
        </tr>
        <tr>
                <td>[Ito1990]</td>
                <td>S. Ito and O. A. Carretero, \"An in vitro approach to the study of macula densa-mediated glomerular hemodynamics,\" Kidney Int, vol. 38, pp. 1206-10, Dec 1990. </td>
        </tr>
        <tr>
                <td>[Ito1992]</td>
                <td>S. Ito, O. A. Carretero, K. Abe, L. A. Juncos, and K. Yoshinaga, \"Macula Densa Control of Renin Release and Glomerular Hemodynamics,\" The Tohoku Journal of Experimental Medicine, vol. 166, pp. 27-39, 1992. </td>
        </tr>
        <tr>
                <td>[Itoh1985]</td>
                <td>S. Itoh and O. A. Carretero, \"Role of the macula densa in renin release,\" Hypertension, vol. 7, p. I49, 1985. </td>
        </tr>
        <tr>
                <td>[Jan1977]</td>
                <td>K. M. Jan and S. Chien, Effect of hematocrit variations on coronary hemodynamics and oxygen utilization vol. 233, 1977. </td>
        </tr>
        <tr>
                <td>[Joseph1952]</td>
                <td>J. Joseph and A. Nightingale, \"Electromyography of muscles of posture: leg muscles in males,\" The Journal of Physiology, vol. 117, pp. 484-491, August 28, 1952 1952. </td>
        </tr>
        <tr>
                <td>[Katkov1980]</td>
                <td>V. E. Katkov and V. V. Chestukhin, \"Blood pressure and oxygenation in different cardiovascular compartments of a normal man during postural exposures,\" Aviat Space Environ Med, vol. 51, pp. 1234-42, Nov 1980. </td>
        </tr>
        <tr>
                <td>[Kety1948]</td>
                <td>S. S. Kety and C. F. Schmidt, \"THE EFFECTS OF ALTERED ARTERIAL TENSIONS OF CARBON DIOXIDE AND OXYGEN ON CEREBRAL BLOOD FLOW AND CEREBRAL OXYGEN CONSUMPTION OF NORMAL YOUNG MEN 1,\" The Journal of Clinical Investigation, vol. 27, pp. 484-492, 1948. </td>
        </tr>
        <tr>
                <td>[Kumagai1994]</td>
                <td>K. Kumagai and I. A. Reid, \"Angiotensin II exerts differential actions on renal nerve activity and heart rate,\" Hypertension, vol. 24, pp. 451-456, 1994. </td>
        </tr>
        <tr>
                <td>[Kunert1996]</td>
                <td>M. P. Kunert, J. F. Liard, D. J. Abraham, and J. H. Lombard, \"Low-Affinity Hemoglobin Increases Tissue PO2and Decreases Arteriolar Diameter and Flow in the Rat Cremaster Muscle,\" Microvascular Research, vol. 52, pp. 58-68, 7// 1996. </td>
        </tr>
        <tr>
                <td>[Kuwahira1993]</td>
                <td>I. Kuwahira, N. Heisler, J. Piiper, and N. C. Gonzalez, \"Effect of chronic hypoxia on hemodynamics, organ blood flow and O2 supply in rats,\" Respiration Physiology, vol. 92, pp. 227-238, 5// 1993. </td>
        </tr>
        <tr>
                <td>[Laine1979]</td>
                <td>G. A. Laine, J. T. Hall, S. H. Laine, and J. Granger, \"Transsinusoidal fluid dynamics in canine liver during venous hypertension,\" Circulation Research, vol. 45, pp. 317-23, September 1, 1979 1979. </td>
        </tr>
        <tr>
                <td>[Landis1933]</td>
                <td>E. M. Landis and J. H. Gibbon, Jr., \"THE EFFECTS OF TEMPERATURE AND OF TISSUE PRESSURE ON THE MOVEMENT OF FLUID THROUGH THE HUMAN CAPILLARY WALL,\" The Journal of Clinical Investigation, vol. 12, pp. 105-138, 1933. </td>
        </tr>
        <tr>
                <td>[Langer1997]</td>
                <td>G. A. Langer, The myocardium: Academic Press, 1997. </td>
        </tr>
        <tr>
                <td>[Lash1987]</td>
                <td>J. M. Lash and H. G. Bohlen, Perivascular and tissue PO2 in contracting rat spinotrapezius muscle vol. 252, 1987. </td>
        </tr>
        <tr>
                <td>[Lassen1959]</td>
                <td>N. A. Lassen, Cerebral blood flow and oxygen consumption in man: Am Physiological Soc, 1959. </td>
        </tr>
        <tr>
                <td>[LAUGHLIN1987]</td>
                <td>M. H. LAUGHLIN, \"Skeletal muscle blood flow capacity: role of muscle pump in exercise hyperemia,\" Am J Physiol, vol. 253, p. 1004, 1987. </td>
        </tr>
        <tr>
                <td>[Laughlin1983]</td>
                <td>M. H. Laughlin and R. Armstrong, \"Rat muscle blood flows as a function of time during prolonged slow treadmill exercise,\" Am J Physiol Heart Circ Physiol, vol. 244, pp. H814-H824, 1983. </td>
        </tr>
        <tr>
                <td>[Lautt1987]</td>
                <td>W. W. Lautt, C. V. Greenway, and D. J. Legare, \"Effect of hepatic nerves, norepinephrine, angiotensin, and elevated central venous pressure on postsinusoidal resistance sites and intrahepatic pressures in cats,\" Microvascular Research, vol. 33, pp. 50-61, 1// 1987. </td>
        </tr>
        <tr>
                <td>[Little1993]</td>
                <td>W. C. Little and C. P. Cheng, \"Effect of exercise on left ventricular-arterial coupling assessed in the pressure-volume plane,\" AMERICAN JOURNAL OF PHYSIOLOGY, vol. 264, pp. H1629-H1629, 1993. </td>
        </tr>
        <tr>
                <td>[Maass-Moreno1992]</td>
                <td>R. Maass-Moreno and C. F. Rothe, \"Contribution of the large hepatic veins to postsinusoidal vascular resistance,\" Am J Physiol Gastrointest Liver Physiol, vol. 262, pp. G14-G22, 1992. </td>
        </tr>
        <tr>
                <td>[Malo1984]</td>
                <td>J. Malo, H. Goldberg, R. Graham, H. Unruh, and C. Skoog, Effect of hypoxic hypoxia on systemic vasculature vol. 56, 1984. </td>
        </tr>
        <tr>
                <td>[Manning1987]</td>
                <td>R. D. Manning, Renal hemodynamic, fluid volume, and arterial pressure changes during hyperproteinemia vol. 252, 1987. </td>
        </tr>
        <tr>
                <td>[Manning1990]</td>
                <td>R. D. Manning, Effects of hypoproteinemia on blood volume and arterial pressure of volume-loaded dogs vol. 259, 1990. </td>
        </tr>
        <tr>
                <td>[Manning1983]</td>
                <td>R. D. Manning and A. C. Guyton, Effects of hypoproteinemia on fluid volumes and arterial pressure vol. 245, 1983. </td>
        </tr>
        <tr>
                <td>[Marshall1995]</td>
                <td>J. Marshall, Skeletal Muscle Vasculature and Systemic Hypoxia vol. 10, 1995. </td>
        </tr>
        <tr>
                <td>[Marshall1988]</td>
                <td>J. M. Marshall and J. D. Metcalfe, \"Analysis of the cardiovascular changes induced in the rat by graded levels of systemic hypoxia,\" The Journal of Physiology, vol. 407, pp. 385-403, December 1, 1988 1988. </td>
        </tr>
        <tr>
                <td>[Mayerson1939]</td>
                <td>H. S. Mayerson, H. M. Sweeney, and L. A. Toth, THE INFLUENCE OF POSTURE ON CIRCULATION TIME vol. 125, 1939. </td>
        </tr>
        <tr>
                <td>[McKeever1958]</td>
                <td>W. McKeever, D. Gregg, and P. Canney, \"Oxygen uptake of the nonworking left ventricle,\" Circulation research, vol. 6, pp. 612-623, 1958. </td>
        </tr>
        <tr>
                <td>[MCKEEVER1958]</td>
                <td>W. P. MCKEEVER, D. E. GREGG, and P. C. CANNEY, \"Oxygen Uptake of the Nonworking Left Ventricle,\" Circulation Research, vol. 6, pp. 612-623, September 1, 1958 1958. </td>
        </tr>
        <tr>
                <td>[Mellander1992]</td>
                <td>S. Mellander and J. Bjornberg, Regulation of Vascular Smooth Muscle Tone and Capillary Pressure vol. 7, 1992. </td>
        </tr>
        <tr>
                <td>[Metting1988]</td>
                <td>P. J. Metting, J. R. Strader, and S. L. Britton, Evaluation of whole body autoregulation in conscious dogs vol. 255, 1988. </td>
        </tr>
        <tr>
                <td>[Metting1989]</td>
                <td>P. J. Metting, P. M. Stein, B. A. Stoos, K. A. Kostrzewski, and S. L. Britton, Systemic vascular autoregulation amplifies pressor responses to vasoconstrictor agents vol. 256, 1989. </td>
        </tr>
        <tr>
                <td>[Mitzner1974]</td>
                <td>W. Mitzner, Hepatic outflow resistance, sinusoid pressure, and the vascular waterfall vol. 227, 1974. </td>
        </tr>
        <tr>
                <td>[Monos2001]</td>
                <td>E. Monos, M. Lóránt, and E. Fehér, Influence of long-term experimental orthostatic body position on innervation density in extremity vessels vol. 281, 2001. </td>
        </tr>
        <tr>
                <td>[Monos2003]</td>
                <td>E. Monos, M. Lóránt, G. Dörnyei, V. Bérczi, and G. Nádasy, Long-Term Adaptation Mechanisms in Extremity Veins Supporting Orthostatic Tolerance vol. 18, 2003. </td>
        </tr>
        <tr>
                <td>[MONROE1960]</td>
                <td>R. G. MONROE and G. FRENCH, \"Ventricular Pressure-Volume Relationships and Oxygen Consumption in Fibrillation and Arrest,\" Circulation Research, vol. 8, pp. 260-266, January 1, 1960 1960. </td>
        </tr>
        <tr>
                <td>[MONROE1961]</td>
                <td>R. G. MONROE and G. N. FRENCH, \"Left ventricular pressure-volume relationships and myocardial oxygen consumption in the isolated heart,\" Circulation research, vol. 9, pp. 362-373, 1961. </td>
        </tr>
        <tr>
                <td>[Moore1990]</td>
                <td>L. C. Moore and D. Casellas, \"Tubuloglomerular feedback dependence of autoregulation in rat juxtamedullary afferent arterioles,\" Kidney Int, vol. 37, pp. 1402-1408, 06//print 1990. </td>
        </tr>
        <tr>
                <td>[Murphy2008]</td>
                <td>E. Murphy and C. Steenbergen, \"Ion transport and energetics during cell death and protection,\" Physiology (Bethesda), vol. 23, pp. 115-23, Apr 2008. </td>
        </tr>
        <tr>
                <td>[NODA1993]</td>
                <td>T. NODA, C.-P. CHENG, P. P. DE TOMBE, and W. C. LITTLE, \"Curvilinearity of LV end-systolic pressure-volume and dP/dt,-end-diastolic volume relations,\" 1993. </td>
        </tr>
        <tr>
                <td>[O’ROURKE1990]</td>
                <td>S. T. O’ROURKE and P. M. VANHOUTTE, \"Adrenergic and cholinergic responsiveness of isolated canine bronchial arteries,\" Organ, vol. 6, p. 2, 1990. </td>
        </tr>
        <tr>
                <td>[OCHSNER1951]</td>
                <td>A. OCHSNER, R. COLP, and G. E. BURCH, \"Normal Blood Pressure in the Superficial Venous System of Man at Rest in the Supine Position,\" Circulation, vol. 3, pp. 674-680, May 1, 1951 1951. </td>
        </tr>
        <tr>
                <td>[Pogátsa1982]</td>
                <td>G. Pogátsa, M. Z. Koltai, and G. Grósz, \"The role of the myocardial water content in heart function,\" Acta physiologica Academiae Scientiarum Hungaricae, vol. 59, pp. 305-309, 1982 1982. </td>
        </tr>
        <tr>
                <td>[POHOST1976]</td>
                <td>G. M. POHOST, J. B. NEWELL, N. P. HAMLIN, and W. J. POWELL, \"Observations on autoregulation in skeletal muscle: the effects of arterial hypoxia,\" Cardiovascular Research, vol. 10, pp. 405-412, July 1, 1976 1976. </td>
        </tr>
        <tr>
                <td>[Pollack1949]</td>
                <td>A. A. Pollack and E. H. Wood, Venous Pressure in the Saphenous Vein at the Ankle in Man during Exercise and Changes in Posture vol. 1, 1949. </td>
        </tr>
        <tr>
                <td>[Prabhu1993]</td>
                <td>S. D. Prabhu and G. L. Freeman, \"Left ventricular energetics in closed-chest dogs,\" Am J Physiol, vol. 265, pp. H1048-55, Oct 1993. </td>
        </tr>
        <tr>
                <td>[Prewitt1976]</td>
                <td>R. L. Prewitt and P. C. Johnson, \"The effect of oxygen on arteriolar red cell velocity and capillary density in the rat cremaster muscle,\" Microvascular Research, vol. 12, pp. 59-70, 7// 1976. </td>
        </tr>
        <tr>
                <td>[Pruett2013]</td>
                <td>W. A. Pruett, L. D. Husband, G. Husband, M. Dakhlalla, K. Bellamy, T. G. Coleman, et al., \"A Population Model of Integrative Cardiovascular Physiology,\" PloS one, vol. 8, p. e74329, 2013. </td>
        </tr>
        <tr>
                <td>[Raeder1995]</td>
                <td>E. A. Raeder, P. Albrecht, M. Perrott, and R. J. Cohen, \"Kinetics of Cycle Length Dependence of Ventricular Repolarization,\" Journal of Cardiovascular Electrophysiology, vol. 6, pp. 163-169, 1995. </td>
        </tr>
        <tr>
                <td>[Raven1984]</td>
                <td>P. B. Raven, D. Rohm-Young, and C. G. Blomqvist, Physical fitness and cardiovascular response to lower body negative pressure vol. 56, 1984. </td>
        </tr>
        <tr>
                <td>[Reivich1964]</td>
                <td>M. Reivich, Arterial Pco2 and cerebral hemodynamics vol. 206, 1964. </td>
        </tr>
        <tr>
                <td>[Roach1957]</td>
                <td>M. R. Roach and A. C. Burton, \"THE REASON FOR THE SHAPE OF THE DISTENSIBILITY CURVES OF ARTERIES,\" Canadian Journal of Biochemistry and Physiology, vol. 35, pp. 681-690, 1957/08/01 1957. </td>
        </tr>
        <tr>
                <td>[ROSS1965]</td>
                <td>J. ROSS, J. W. LINHART, and E. BRAUNWALD, \"Effects of Changing Heart Rate in Man by Electrical Stimulation of the Right Atrium: Studies at Rest, during Exercise, and with Isoproterenol,\" Circulation, vol. 32, pp. 549-558, October 1, 1965 1965. </td>
        </tr>
        <tr>
                <td>[Sagawa1988]</td>
                <td>K. Sagawa, L. Maughan, H. Suga, and K. Sunagawa, Cardiac contraction and the pressure-volume relationship vol. 480: Oxford University Press New York, 1988. </td>
        </tr>
        <tr>
                <td>[Sage1981]</td>
                <td>J. I. Sage, R. L. Van Uitert, and T. E. Duffy, \"Simultaneous Measurement of Cerebral Blood Flow and Unidirectional Movement of Substances Across the Blood-Brain Barrier: Theory, Method, and Application to Leucine,\" Journal of Neurochemistry, vol. 36, pp. 1731-1738, 1981. </td>
        </tr>
        <tr>
                <td>[Shigemi1994]</td>
                <td>K. Shigemi, M. J. Brunner, and A. A. Shoukas, \"-and -Adrenergic mechanisms in the control of vascular capacitance by the carotid sinus baroreflex system,\" AMERICAN JOURNAL OF PHYSIOLOGY, vol. 267, pp. H201-H201, 1994. </td>
        </tr>
        <tr>
                <td>[Schrier1970]</td>
                <td>R. W. Schrier, K. M. McDonald, R. Wells, and D. P. Lauler, \"Influence of hematocrit and colloid on whole blood viscosity during volume expansion,\" Am. J. Physiol, vol. 218, p. 77, 1970. </td>
        </tr>
        <tr>
                <td>[Skarlatos1993]</td>
                <td>S. Skarlatos, N. DiPaola, R. A. Frankel, R. W. Pomerantz, P. H. Brand, P. J. Metting, et al., \"Spontaneous pressure-flow relationships in renal circulation of conscious dogs,\" Am J Physiol, vol. 264, pp. H1517-27, May 1993. </td>
        </tr>
        <tr>
                <td>[Skov1996]</td>
                <td>K. Skov, J. Fenger-Gron, and M. J. Mulvany, \"Effects of an angiotensin-converting enzyme inhibitor, a calcium antagonist, and an endothelin receptor antagonist on renal afferent arteriolar structure,\" Hypertension, vol. 28, pp. 464-471, 1996. </td>
        </tr>
        <tr>
                <td>[Stainsby1973]</td>
                <td>W. N. Stainsby, \"Local Control of Regional Blood Flow,\" Annual Review of Physiology, vol. 35, pp. 151-168, 1973. </td>
        </tr>
        <tr>
		<td>[Stevens]</td>
		<td>StevensP. M. Stevens and L. E. Lamb, \"Effects of lower body negative pressure on the cardiovascular system,\" American Journal of Cardiology, vol. 16, pp. 506-515. </td>
        <tr>
                <td>[Stick1992]</td>
                <td>C. Stick, H. Jaeger, and E. Witzleb, Measurements of volume changes and venous pressure in the human lower leg during walking and running vol. 72, 1992. </td>
        </tr>
        <tr>
                <td>[Stone1968]</td>
                <td>H. Stone, Thompson HK, and K. Schmidt-Nielsen, Influence of erythrocytes on blood viscosity vol. 214, 1968. </td>
        </tr>
        <tr>
                <td>[Stonestreet1998]</td>
                <td>B. S. Stonestreet, S. S. Ocampo, and W. Oh, Reductions in cardiac output in hypoxic young pigs: systemic and regional perfusion and oxygen metabolism vol. 85, 1998. </td>
        </tr>
        <tr>
                <td>[Stothert1992]</td>
                <td>J. C. Stothert, J. O. Basadre, G. B. Gbaanador, J. T. Flynn, L. Traber, and D. Traber, \"Bronchial blood flow during changes in inhaled oxygen and carbon dioxide concentrations in conscious sheep,\" Circulatory shock, vol. 36, pp. 120-126, 1992/02// 1992. </td>
        </tr>
        <tr>
                <td>[Suga1979]</td>
                <td>H. Suga, Total mechanical energy of a ventricle model and cardiac oxygen consumption vol. 236, 1979. </td>
        </tr>
        <tr>
                <td>[SUGA1974]</td>
                <td>H. SUGA and K. SAGAWA, \"Instantaneous Pressure-Volume Relationships and Their Ratio in the Excised, Supported Canine Left Ventricle,\" Circulation Research, vol. 35, pp. 117-126, July 1, 1974 1974. </td>
        </tr>
        <tr>
                <td>[SUGA1976]</td>
                <td>H. SUGA, K. SAGAWA, and D. P. KOSTIUK, \"Controls of ventricular contractility assessed by pressure-volume ratio, Emax,\" Cardiovascular Research, vol. 10, pp. 582-592, September 1, 1976 1976. </td>
        </tr>
        <tr>
                <td>[Sugimoto1966]</td>
                <td>T. Sugimoto, K. Sagawa, and A. Guyton, Effect of tachycardia on cardiac output during normal and increased venous return vol. 211, 1966. </td>
        </tr>
        <tr>
		<td>[Schumacker]</td>   
		<td>SchumackerS. P. T. and C. S. M., \"The concept of a critical oxygen delivery,\" Intensive Care Medicine, vol. 13, pp. 223-229, January 1, 0001.</td>
        <tr>
                <td>[Takeshita1979]</td>
                <td>A. Takeshita, A. L. Mark, D. L. Eckberg, and F. M. Abboud, Effect of central venous pressure on arterial baroreflex control of heart rate vol. 236, 1979. </td>
        </tr>
        <tr>
                <td>[Thompson1928]</td>
                <td>W. O. Thompson, P. K. Thompson, and M. E. Dailey, \"THE EFFECT OF POSTURE UPON THE COMPOSITION AND VOLUME OF THE BLOOD IN MAN 1,\" The Journal of Clinical Investigation, vol. 5, pp. 573-604, 1928. </td>
        </tr>
        <tr>
                <td>[Wagner1988]</td>
                <td>E. M. Wagner and W. A. Mitzner, \"Effect of hypoxia on bronchial circulation,\" J. Appl. Physiol, vol. 65, pp. 1627-1633, 1988. </td>
        </tr>
        <tr>
                <td>[Wagner1990]</td>
                <td>E. M. Wagner and W. A. Mitzner, \"Effect of left atrial pressure on bronchial vascular hemodynamics,\" J Appl Physiol, vol. 69, pp. 837-842, 1990. </td>
        </tr>
        <tr>
                <td>[Warner1962]</td>
                <td>H. R. Warner and A. Cox, A mathematical model of heart rate control by sympathetic and vagus efferent information vol. 17, 1962. </td>
        </tr>
        <tr>
                <td>[Weber1977]</td>
                <td>K. T. Weber and J. S. Janicki, Myocardial oxygen consumption: the role of wall force and shortening vol. 233, 1977. </td>
        </tr>
        <tr>
                <td>[Weber2000]</td>
                <td>D. S. Weber and J. H. Lombard, Elevated salt intake impairs dilation of rat skeletal muscle resistance arteries via ANG II suppression vol. 278, 2000. </td>
        </tr>
        <tr>
                <td>[Wells1938]</td>
                <td>H. S. Wells, J. B. Youmans, and D. G. Miller, Jr., \"TISSUE PRESSURE (INTRACUTANEOUS, SUBCUTANEOUS, AND INTRAMUSCULAR) AS RELATED TO VENOUS PRESSURE, CAPILLARY FILTRATION, AND OTHER FACTORS 12,\" The Journal of Clinical Investigation, vol. 17, pp. 489-499, 1938. </td>
        </t"
      + "r>
        <tr>
                <td>[Whalen1974]</td>
                <td>W. Whalen, P. Nair, D. Buerk, and C. Thuning, \"Tissue PO2 in normal and denervated cat skeletal muscle,\" Am J Physiol, vol. 227, pp. 1221-1225, 1974. </td>
        </tr>
        <tr>
                <td>[Whittaker1933]</td>
                <td>S. R. F. Whittaker and F. R. Winton, \"The apparent viscosity of blood flowing in the isolated hindlimb of the dog, and its variation with corpuscular concentration,\" The Journal of Physiology, vol. 78, pp. 339-369, July 10, 1933 1933. </td>
        </tr>
        <tr>
                <td>[L.1989]</td>
                <td>L. R. Williams and R. W. Leggett, \"Reference values for resting blood flow to organs of man,\" Clinical Physics and Physiological Measurement, vol. 10, p. 187, 1989. </td>
        </tr>
        <tr>
                <td>[Woo1972]</td>
                <td>S. L. Y. Woo, A. S. Kobayashi, C. Lawrence, and W. A. Schlegel, \"Mathematical model of the corneo-scleral shell as applied to intraocular pressure-volume relations and applanation tonometry,\" Annals of Biomedical Engineering, vol. 1, pp. 87-98, 1972/09/01 1972. </td>
        </tr>
        <tr>
                <td>[Xenopoulos1994]</td>
                <td>N. P. Xenopoulos and R. J. Applegate, \"The effect of vagal stimulation on left ventricular systolic and diastolic performance,\" American Journal of Physiology-Heart and Circulatory Physiology, vol. 35, p. H2167, 1994.  </td>
        </tr>

</table>
</html>"));
    end References;

    package Heart "Heart Components"

      class References "References"
        extends Modelica.Icons.References;

        annotation (Documentation(info="<html>
<table>

	<tr>
		<td>[Bazett1997]</td>
		<td>H. C. Bazett, \"AN ANALYSIS OF THE TIME-RELATIONS OF ELECTROCARDIOGRAMS,\" Annals of Noninvasive Electrocardiology, vol. 2, pp. 177-194, 1997. </td>
	</tr>
	<tr>
		<td>[Bootsma1994]</td>
		<td>M. Bootsma, C. A. Swenne, H. H. Van Bolhuis, P. C. Chang, V. M. Cats, and A. Bruschke, \"Heart rate and heart rate variability as indexes of sympathovagal balance,\" American Journal of Physiology, vol. 266, pp. H1565-H1565, 1994. </td>
	</tr>
	<tr>
		<td>[Braunwald1976]</td>
		<td>E. Braunwald, J. Ross, and E. H. Sonnenblick, Mechanisms of contraction of the normal and failing heart: Little, Brown Boston, 1976. </td>
	</tr>
	<tr>
		<td>[Carter1998]</td>
		<td>Y. M. Carter, C. X. Jia, P. F. Soto, J. P. Starr, D. G. Rabkin, D. T. Hsu, et al., \"Diastolic properties, myocardial water content, and histologic condition of the rat left ventricle: effect of varied osmolarity of a coronary perfusate,\" The Journal of heart and lung transplantation : the official publication of the International Society for Heart Transplantation, vol. 17, pp. 140-149, 1998/02// 1998. </td>
	</tr>
	<tr>
		<td>[Collins-Nakai1994]</td>
		<td>R. L. Collins-Nakai, D. Noseworthy, and G. D. Lopaschuk, \"Epinephrine increases ATP production in hearts by preferentially increasing glucose metabolism,\" Am J Physiol, vol. 267, pp. H1862-71, Nov 1994. </td>
	</tr>
	<tr>
		<td>[Fatema2002]</td>
		<td>K. Fatema, O. Hirono, Y. Takeishi, J. Nitobe, K. Kaneko, M. Ito, et al., \"Hemodialysis improves myocardial interstitial edema and left ventricular diastolic function in patients with end-stage renal disease: noninvasive assessment by ultrasonic tissue characterization,\" Heart and vessels, vol. 16, pp. 227-231, 2002. </td>
	</tr>
	<tr>
		<td>[Ferguson1985]</td>
		<td>D. W. Ferguson, F. M. Abboud, and A. L. Mark, \"Relative contribution of aortic and carotid baroreflexes to heart rate control in man during steady state and dynamic increases in arterial pressure,\" The Journal of Clinical Investigation, vol. 76, pp. 2265-2274, 1985. </td>
	</tr>
	<tr>
		<td>[Gaasch1975]</td>
		<td>W. H. Gaasch, J. S. Cole, M. A. Quinones, and J. Alexander, \"Dynamic determinants of letf ventricular diastolic pressure-volume relations in man,\" Circulation, vol. 51, pp. 317-323, 1975. </td>
	</tr>
	<tr>
		<td>[Guyton1961]</td>
		<td>A. C. Guyton and K. Sagawa, \"Compensations of cardiac output and other circulatory functions in areflex dogs with large AV fistulas,\" The American journal of physiology, vol. 200, p. 1157, 1961. </td>
	</tr>
	<tr>
		<td>[Kumagai1994]</td>
		<td>K. Kumagai and I. A. Reid, \"Angiotensin II exerts differential actions on renal nerve activity and heart rate,\" Hypertension, vol. 24, pp. 451-456, 1994. </td>
	</tr>
	<tr>
		<td>[Langer1997]</td>
		<td>G. A. Langer, The myocardium: Academic Press, 1997. </td>
	</tr>
	<tr>
		<td>[Little1993]</td>
		<td>W. C. Little and C. P. Cheng, \"Effect of exercise on left ventricular-arterial coupling assessed in the pressure-volume plane,\" AMERICAN JOURNAL OF PHYSIOLOGY, vol. 264, pp. H1629-H1629, 1993. </td>
	</tr>
	<tr>
		<td>[McKeever1958]</td>
		<td>W. McKeever, D. Gregg, and P. Canney, \"Oxygen uptake of the nonworking left ventricle,\" Circulation research, vol. 6, pp. 612-623, 1958. </td>
	</tr>
	<tr>
		<td>[MCKEEVER1958]</td>
		<td>W. P. MCKEEVER, D. E. GREGG, and P. C. CANNEY, \"Oxygen Uptake of the Nonworking Left Ventricle,\" Circulation Research, vol. 6, pp. 612-623, September 1, 1958 1958. </td>
	</tr>
	<tr>
		<td>[MONROE1960]</td>
		<td>R. G. MONROE and G. FRENCH, \"Ventricular Pressure-Volume Relationships and Oxygen Consumption in Fibrillation and Arrest,\" Circulation Research, vol. 8, pp. 260-266, January 1, 1960 1960. </td>
	</tr>
	<tr>
		<td>[MONROE1961]</td>
		<td>R. G. MONROE and G. N. FRENCH, \"Left ventricular pressure-volume relationships and myocardial oxygen consumption in the isolated heart,\" Circulation research, vol. 9, pp. 362-373, 1961. </td>
	</tr>
	<tr>
		<td>[Murphy2008]</td>
		<td>E. Murphy and C. Steenbergen, \"Ion transport and energetics during cell death and protection,\" Physiology (Bethesda), vol. 23, pp. 115-23, Apr 2008. </td>
	</tr>
	<tr>
		<td>[NODA1993]</td>
		<td>T. NODA, C.-P. CHENG, P. P. DE TOMBE, and W. C. LITTLE, \"Curvilinearity of LV end-systolic pressure-volume and dP/dt,-end-diastolic volume relations,\" 1993. </td>
	</tr>
	<tr>
		<td>[Pogátsa1982]</td>
		<td>G. Pogátsa, M. Z. Koltai, and G. Grósz, \"The role of the myocardial water content in heart function,\" Acta physiologica Academiae Scientiarum Hungaricae, vol. 59, pp. 305-309, 1982 1982. </td>
	</tr>
	<tr>
		<td>[Prabhu1993]</td>
		<td>S. D. Prabhu and G. L. Freeman, \"Left ventricular energetics in closed-chest dogs,\" Am J Physiol, vol. 265, pp. H1048-55, Oct 1993. </td>
	</tr>
	<tr>
		<td>[Raeder1995]</td>
		<td>E. A. Raeder, P. Albrecht, M. Perrott, and R. J. Cohen, \"Kinetics of Cycle Length Dependence of Ventricular Repolarization,\" Journal of Cardiovascular Electrophysiology, vol. 6, pp. 163-169, 1995. </td>
	</tr>
	<tr>
		<td>[ROSS1965]</td>
		<td>J. ROSS, J. W. LINHART, and E. BRAUNWALD, \"Effects of Changing Heart Rate in Man by Electrical Stimulation of the Right Atrium: Studies at Rest, during Exercise, and with Isoproterenol,\" Circulation, vol. 32, pp. 549-558, October 1, 1965 1965. </td>
	</tr>
	<tr>
		<td>[Sagawa1988]</td>
		<td>K. Sagawa, L. Maughan, H. Suga, and K. Sunagawa, Cardiac contraction and the pressure-volume relationship vol. 480: Oxford University Press New York, 1988. </td>
	</tr>
	<tr>
		<td>[Suga1979]</td>
		<td>H. Suga, Total mechanical energy of a ventricle model and cardiac oxygen consumption vol. 236, 1979. </td>
	</tr>
	<tr>
		<td>[SUGA1974]</td>
		<td>H. SUGA and K. SAGAWA, \"Instantaneous Pressure-Volume Relationships and Their Ratio in the Excised, Supported Canine Left Ventricle,\" Circulation Research, vol. 35, pp. 117-126, July 1, 1974 1974. </td>
	</tr>
	<tr>
		<td>[SUGA1976]</td>
		<td>H. SUGA, K. SAGAWA, and D. P. KOSTIUK, \"Controls of ventricular contractility assessed by pressure-volume ratio, Emax,\" Cardiovascular Research, vol. 10, pp. 582-592, September 1, 1976 1976. </td>
	</tr>
	<tr>
		<td>[Sugimoto1966]</td>
		<td>T. Sugimoto, K. Sagawa, and A. Guyton, Effect of tachycardia on cardiac output during normal and increased venous return vol. 211, 1966. </td>
	</tr>
	<tr>
		<td>[Takeshita1979]</td>
		<td>A. Takeshita, A. L. Mark, D. L. Eckberg, and F. M. Abboud, Effect of central venous pressure on arterial baroreflex control of heart rate vol. 236, 1979. </td>
	</tr>
	<tr>
		<td>[Warner1962]</td>
		<td>H. R. Warner and A. Cox, A mathematical model of heart rate control by sympathetic and vagus efferent information vol. 17, 1962. </td>
	</tr>
	<tr>
		<td>[Weber1977]</td>
		<td>K. T. Weber and J. S. Janicki, Myocardial oxygen consumption: the role of wall force and shortening vol. 233, 1977. </td>
	</tr>
	<tr>
		<td>[Woo1972]</td>
		<td>S. L. Y. Woo, A. S. Kobayashi, C. Lawrence, and W. A. Schlegel, \"Mathematical model of the corneo-scleral shell as applied to intraocular pressure-volume relations and applanation tonometry,\" Annals of Biomedical Engineering, vol. 1, pp. 87-98, 1972/09/01 1972. </td>
	</tr>
	<tr>
		<td>[Xenopoulos1994]</td>
		<td>N. P. Xenopoulos and R. J. Applegate, \"The effect of vagal stimulation on left ventricular systolic and diastolic performance,\" American Journal of Physiology-Heart and Circulatory Physiology, vol. 35, p. H2167, 1994.  </td>
	</tr>

</table>
</html>"));
      end References;

      package Interfaces
        partial model IVentricle
          extends Physiolibrary.Icons.HeartVentricle;
          parameter Physiolibrary.Types.Volume initialVol = 90e-6
          "Initial blood volume in ventricle";
        //  parameter Physiolibrary.Types.Volume initialESV = 50e-6;

        parameter Physiolibrary.Types.Volume NormalEndDiastolicVolume = 70e-6
          "Typical value of blood volume in ventricle after filling"
            annotation (Dialog(group="Diastole"));
        parameter Physiolibrary.Types.Pressure NormalFillingPressure = (0.00051*101325/760)*(NormalEndDiastolicVolume^(1/n_Diastole))
          "Typical value of filling pressure relative to pericardium pressure"
            annotation (Dialog(group="Diastole"));
        parameter Physiolibrary.Types.Fraction stiffnes = 1
          "Relative stiffnes (1 if normal)"
            annotation (Dialog(group="Diastole"));
        parameter Physiolibrary.Types.Fraction n_Diastole(displayUnit="1") = 2
          "Exponent of P-V characteristic of EDV curve on filling pressure"
            annotation (Dialog(group="Diastole"));
        //parameter Real Abasic_Diastole = 0.00051
        //    "parametrization of end diastolic volume curve"
        //    annotation (Dialog(group="Diastole"));

        parameter Physiolibrary.Types.Pressure NormalSystolicPressure = 15998.684210526315789473684210526
          "Typical value of systolic pressure relative to pericardium pressure"
            annotation (Dialog(group="Systole"));
        parameter Physiolibrary.Types.Volume NormalEndSystolicVolume = (NormalSystolicPressure/(17.39*101325/760))^(n_Systole)
          "Typical value of blood volume in ventricle after ejection"
            annotation (Dialog(group="Systole"));
        //parameter Real Abasic_Systole = 17.39
        //    "parametrization of end systolic volume curve";
        parameter Physiolibrary.Types.Pressure additionalPressure_Systolic
          "Pressure difference between mean and systolic pressure"
            annotation (Dialog(group="Systole"));     //= 24
        parameter Physiolibrary.Types.Fraction contractilityBasic
          "Relative contractility (1 if normal)"
             annotation (Dialog(group="Systole"));       //= 1
        parameter Physiolibrary.Types.Fraction n_Systole(displayUnit="1")=0.5
          "Exponent of P-V characteristic of ESV curve on systolic pressure"
            annotation (Dialog(group="Systole"));

        parameter Physiolibrary.Types.Frequency K
          "time adaptation coeficient of average ventricle blood volume";
                                                      // = 1
        parameter Physiolibrary.Types.HydraulicCompliance BasicCompliance; //(final quantity="Compliance", final displayUnit="ml/mmHg") = 1;

        parameter Physiolibrary.Types.Pressure NormalExternalPressure = -446
          "Typical value of pericardium cavity pressure (relative to environment ambient pressure)";
                                                                                 //-446 Pa = -3.34522 mmHg

        //parameter Physiolibrary.Types.HydraulicCompliance MaxContractionCompliance; //=1;
        //parameter Physiolibrary.Types.HydraulicConductance Cond1;//=1;
        //parameter Physiolibrary.Types.HydraulicConductance Cond2;//=1;

        Physiolibrary.Hydraulic.Interfaces.HydraulicPort_a q_in annotation (
            extent=[-10,-110; 10,-90], Placement(transformation(extent={{-10,
                  -110},{10,-90}}, rotation=0),
                             iconTransformation(extent={{10,70},{30,90}})));
        Physiolibrary.Hydraulic.Interfaces.HydraulicPort_b q_out annotation (
            extent=[-10,-110; 10,-90], Placement(transformation(extent={{-10,
                  -110},{10,-90}}, rotation=0),
                               iconTransformation(extent={{-30,90},{-10,110}})));

        Physiolibrary.Types.BusConnector busConnector annotation (Placement(
              transformation(extent={{12,-8},{32,12}}), iconTransformation(
                extent={{-10,-64},{10,-44}})));

          Physiolibrary.Types.RealIO.VolumeOutput Vol
                                              annotation (Placement(transformation(
                  extent={{70,30},{76,36}}),    iconTransformation(
                extent={{-20,-20},{20,20}},
                rotation=270,
                origin={40,-40})));

         annotation (
            Documentation(info="<html>
<pre>Heart ventricle interface.</pre>
</html>",revisions="<html>
<ul>
<li><i>january 2009 </i><br>by Marek Matejak in Modelica initially implemented (consulted with Jiri Kofranek), Charles University, Prague<br>orginaly described by Tom Coleman in QHP 2008 beta 3, University of Mississippi Medical Center </li>
<li><i>2014</i><br>Marek Matejak - update to Physiolibrary 2.3.0</li>
</ul>
</html>"),  Icon(coordinateSystem(preserveAspectRatio=false,extent={{-100,-100},
                  {100,100}}),   graphics={Text(
                  extent={{-100,-126},{100,-92}},
                  textString="%name",
                  lineColor={0,0,255})}));
        end IVentricle;
      end Interfaces;

      model Heart
      import Physiomodel;
         extends Physiolibrary.Icons.Heart;
      Physiolibrary.Hydraulic.Components.ElasticVessel RightAtrium(
        stateName="RightAtrium.Vol",
        useExternalPressureInput=true,
        useV0Input=true,
        useComplianceInput=false,
        volume_start=5.16454e-05,
        Compliance=9.3757696980707e-08) "right atrium"
        annotation (Placement(transformation(extent={{-75,-1},{-55,19}})));
      Physiolibrary.Types.Constants.VolumeConst RightAtriumV0(k=0)
        annotation (Placement(transformation(extent={{-84,20},{-76,28}})));
      Physiomodel.CardioVascular.Heart.Ventricle rightVentricle(
        n_Diastole=2.0,
        n_Systole=0.5,
        stateName="RightVentricle.Vol",
        BasicCompliance(displayUnit="ml/mmHg") = 2.1901798014693e-07,
        additionalPressure_Systolic(displayUnit="mmHg") = 1199.901486735,
        initialVol=8.75e-05,
        NormalEndDiastolicVolume=0.000125,
        NormalFillingPressure=95.9921189388,
        stiffnes=1,
        NormalSystolicPressure=1666.5298426875,
        NormalEndSystolicVolume=5.122e-05,
        contractilityBasic=1,
        K=1) annotation (Placement(transformation(extent={{-6,-46},{-50,-2}})));
      //    Abasic_Diastole=0.00026,
      //    Abasic_Systole=3.53,
      //    MaxContractionCompliance(displayUnit="ml/mmHg") = 1.5001231516913e-08,
      //    Cond1=60000000,
      //    Cond2=60000000,
      Physiolibrary.Hydraulic.Components.ElasticVessel LeftAtrium(
        stateName="LeftAtrium.Vol",
        useExternalPressureInput=true,
        useV0Input=true,
        volume_start=5.05035e-05,
        useComplianceInput=false,
        Compliance=4.6878848490354e-08) "left atrium"
        annotation (Placement(transformation(extent={{68,-8},{88,12}})));
      Physiolibrary.Types.Constants.VolumeConst LeftAtriumV0(k=0)
        annotation (Placement(transformation(extent={{60,12},{68,20}})));
      Physiomodel.CardioVascular.Heart.Ventricle leftVentricle(
        n_Diastole=2,
        n_Systole=0.5,
        stateName="LeftVentricle.Vol",
        BasicCompliance(displayUnit="ml/mmHg") = 1.0950899007347e-07,
        initialVol=8.75e-05,
        NormalEndDiastolicVolume=0.000125,
        NormalFillingPressure=615.9494298573,
        stiffnes=1,
        NormalSystolicPressure=12665.626804425,
        NormalEndSystolicVolume=5.087e-05,
        additionalPressure_Systolic=3199.73729796,
        contractilityBasic=1,
        K=0.016666666666667)
        annotation (Placement(transformation(extent={{26,-46},{70,-2}})));
       //   MaxContractionCompliance(displayUnit="ml/mmHg") = 3.0002463033826e-09,
         // Abasic_Diastole=0.00051,
      //    Cond1(displayUnit="ml/(mmHg.min)") = 0.0075006157584566,
      //    Cond2(displayUnit="ml/(mmHg.min)") = 0.0075006157584566,
      Physiolibrary.Types.BusConnector busConnector
        "signals of organ bood flow resistence" annotation (Placement(
            transformation(extent={{-4,32},{16,52}}), iconTransformation(extent=
               {{-108,-38},{-92,-22}})));
      Physiolibrary.Hydraulic.Interfaces.HydraulicPort_a rightAtrium
        "blood inflow to right atrium" annotation (Placement(transformation(
              extent={{-102,-24},{-82,-4}}), iconTransformation(extent={{-66,30},
                {-46,50}})));
      Physiolibrary.Hydraulic.Interfaces.HydraulicPort_b fromRightVentricle
        "blood outflow to pulmonary circulation" annotation (Placement(
            transformation(extent={{-20,-12},{0,8}}), iconTransformation(extent=
               {{-48,-38},{-28,-18}})));
      Physiolibrary.Hydraulic.Interfaces.HydraulicPort_b fromLeftVentricle
        "blood outflow to aorta" annotation (Placement(transformation(extent={{2,0},{
                22,20}}),        iconTransformation(extent={{14,-38},{34,-18}})));
      Physiolibrary.Hydraulic.Interfaces.HydraulicPort_a leftAtrium
        "blood inflow to left atrium" annotation (Placement(transformation(
              extent={{84,-38},{104,-18}}),
                                          iconTransformation(extent={{34,32},{
                54,52}})));
        Modelica.Blocks.Math.Sum sum1(nin=2)
          annotation (Placement(transformation(extent={{-18,-70},{-10,-62}})));
        Modelica.Blocks.Math.Sum sum3(nin=2)
          annotation (Placement(transformation(extent={{-60,-78},{-52,-70}})));
        Modelica.Blocks.Math.Sum sum2(nin=2)
          annotation (Placement(transformation(extent={{-4,-4},{4,4}},
              rotation=180,
              origin={66,-74})));
      Physiomodel.Nerves.SA_Node SA_node
        annotation (Placement(transformation(extent={{-58,76},{-38,96}})));
        Hormones.ANP atriopeptin
          annotation (Placement(transformation(extent={{72,76},{92,96}})));
      Physiolibrary.Hydraulic.Sensors.PressureMeasure pressureMeasure
        annotation (Placement(transformation(extent={{-98,-90},{-78,-70}})));
      Physiolibrary.Hydraulic.Sensors.PressureMeasure pressureMeasure1
        annotation (Placement(transformation(extent={{100,-88},{80,-68}})));
      Physiolibrary.Hydraulic.Sensors.FlowMeasure flowMeasure
        annotation (Placement(transformation(extent={{40,0},{20,20}})));
        Modelica.Blocks.Math.Add avePressure(k1=0.5, k2=0.5)
          annotation (Placement(transformation(extent={{-68,48},{-56,60}})));
        Physiomodel.Nerves.BaroReceptorAdaptation
                                     lowPressureReceptors(
          PressureChangeOnNA={{-4.0,0.0,0},{0.0,1.0,0.3},{12.0,4.0,0}},
        AdaptivePressure(displayUnit="mmHg") = 799.93432449,
        Tau(displayUnit="d") = 2592000)
          annotation (Placement(transformation(
              extent={{-10,-10},{10,10}},
              origin={-40,54})));
        Modelica.Blocks.Math.Feedback rightAtrium_TMP
          annotation (Placement(transformation(extent={{-38,-100},{-22,-84}})));
        Modelica.Blocks.Math.Feedback leftAtrium_TMP
        annotation (Placement(transformation(extent={{52,-98},{36,-82}})));
      equation
      connect(RightAtrium.zeroPressureVolume, RightAtriumV0.y) annotation (Line(
          points={{-73,17},{-73,24},{-75,24}},
          color={0,0,127},
          smooth=Smooth.None));
      connect(RightAtrium.q_in, rightVentricle.q_in) annotation (Line(
          points={{-65,9},{-66,8},{-32,8},{-32,-6.4},{-32.4,-6.4}},
          color={0,0,0},
          smooth=Smooth.None,
          thickness=1));
        connect(busConnector.Pericardium_Pressure,RightAtrium.externalPressure)
          annotation (Line(
            points={{6,42},{6,24},{-57,24},{-57,17}},
            color={0,0,255},
            thickness=0.1,
            smooth=Smooth.None), Text(
            string="%first",
            index=-1,
            extent={{110,10},{110,10}}));
        connect(busConnector,rightVentricle. busConnector)          annotation (
            Line(
            points={{6,42},{6,-37},{-28,-37},{-28,-35.88}},
            color={0,0,255},
            thickness=0.5,
            smooth=Smooth.None));
      connect(LeftAtrium.zeroPressureVolume, LeftAtriumV0.y) annotation (Line(
          points={{70,10},{70,16},{69,16}},
          color={0,0,127},
          smooth=Smooth.None));
      connect(LeftAtrium.q_in, leftVentricle.q_in) annotation (Line(
          points={{78,2},{52,2},{52,-6.4},{52.4,-6.4}},
          color={0,0,0},
          smooth=Smooth.None,
          thickness=1));
        connect(busConnector,leftVentricle. busConnector)          annotation (
            Line(
            points={{6,42},{6,-37},{48,-37},{48,-35.88}},
            color={0,0,255},
            thickness=0.5,
            smooth=Smooth.None));
        connect(busConnector.Pericardium_Pressure,LeftAtrium.externalPressure)
          annotation (Line(
            points={{6,42},{6,24},{86,24},{86,10}},
            color={0,0,255},
            thickness=0.1,
            smooth=Smooth.None));
      connect(rightAtrium, RightAtrium.q_in) annotation (Line(
          points={{-92,-14},{-92,9},{-65,9}},
          color={0,0,0},
          thickness=1,
          smooth=Smooth.None));
        connect(rightVentricle.q_out, fromRightVentricle) annotation (Line(
            points={{-23.6,-2},{-10,-2}},
            color={0,0,0},
            thickness=1,
            smooth=Smooth.None));
      connect(LeftAtrium.q_in, leftAtrium) annotation (Line(
          points={{78,2},{94,2},{94,-28}},
          color={0,0,0},
          thickness=1,
          smooth=Smooth.None));
        connect(RightAtriumV0.y, sum1.u[1])
                                     annotation (Line(
            points={{-75,24},{-72,24},{-72,-66},{-38,-66},{-38,-66.4},{-18.8,
              -66.4}},
            color={0,0,127},
            smooth=Smooth.None));
        connect(LeftAtriumV0.y, sum1.u[2])
                                     annotation (Line(
            points={{69,16},{70,16},{70,-58},{-28,-58},{-28,-65.6},{-18.8,-65.6}},
            color={0,0,127},
            smooth=Smooth.None));
      connect(RightAtrium.volume, sum3.u[1]) annotation (Line(
          points={{-59,-1},{-59,-74.4},{-60.8,-74.4}},
          color={0,0,127},
          smooth=Smooth.None));
        connect(rightVentricle.Vol, sum3.u[2]) annotation (Line(
            points={{-36.8,-32.8},{-66,-32.8},{-66,-73.6},{-60.8,-73.6}},
            color={0,0,127},
            smooth=Smooth.None));
      connect(LeftAtrium.volume, sum2.u[1]) annotation (Line(
          points={{84,-8},{84,-73.6},{70.8,-73.6}},
          color={0,0,127},
          smooth=Smooth.None));
        connect(leftVentricle.Vol, sum2.u[2]) annotation (Line(
            points={{56.8,-32.8},{56.8,-32},{76,-32},{76,-74.4},{70.8,-74.4}},
            color={0,0,127},
            smooth=Smooth.None));
        connect(sum3.y, busConnector.Heart_DeoxygenatedBloodVolume) annotation (
           Line(
            points={{-51.6,-74},{6,-74},{6,42}},
            color={0,0,127},
            smooth=Smooth.None), Text(
            string="%second",
            index=1,
            extent={{6,3},{6,3}}));
        connect(busConnector.Heart_OxygenatedBloodVolume, sum2.y) annotation (
            Line(
            points={{6,42},{6,-74},{61.6,-74}},
            color={0,0,255},
            thickness=0.5,
            smooth=Smooth.None), Text(
            string="%first",
            index=-1,
            extent={{-6,3},{-6,3}}));
        connect(sum1.y, busConnector.Heart_V0) annotation (Line(
            points={{-9.6,-66},{6,-66},{6,42}},
            color={0,0,127},
            smooth=Smooth.None), Text(
            string="%second",
            index=1,
            extent={{6,3},{6,3}}));
        connect(SA_node.Rate, busConnector.HeartVentricleRate) annotation (Line(
            points={{-38.2,86},{6,86},{6,44},{6,44},{6,42},{6,42}},
            color={0,0,127},
            smooth=Smooth.None), Text(
            string="%second",
            index=1,
            extent={{6,3},{6,3}}));
        connect(busConnector.BetaPool_Effect,SA_node. BetaPool_Effect)
          annotation (Line(
            points={{6,42},{6,76},{-96,76},{-96,92},{-58,92}},
            color={0,0,255},
            thickness=0.5,
            smooth=Smooth.None), Text(
            string="%first",
            index=-1,
            extent={{-6,3},{-6,3}}));
        connect(busConnector.BetaBlocade_Effect,SA_node. BetaBlockade_Effect)
          annotation (Line(
            points={{6,42},{6,76},{-96,76},{-96,88},{-58,88}},
            color={0,0,255},
            thickness=0.5,
            smooth=Smooth.None), Text(
            string="%first",
            index=-1,
            extent={{-6,3},{-6,3}}));
        connect(busConnector.VagusNerve_NA_Hz, SA_node.VagusNerve_NA_Hz)
          annotation (Line(
            points={{6,42},{6,76},{-96,76},{-96,80},{-58,80}},
            color={0,0,255},
            thickness=0.5,
            smooth=Smooth.None), Text(
            string="%first",
            index=-1,
            extent={{-6,3},{-6,3}}));
        connect(busConnector.GangliaGeneral_NA, SA_node.GangliaGeneral_NA)
          annotation (Line(
            points={{6,42},{6,76},{-96,76},{-96,84},{-58,84}},
            color={0,0,255},
            thickness=0.5,
            smooth=Smooth.None), Text(
            string="%first",
            index=-1,
            extent={{-6,3},{-6,3}}));
        connect(busConnector,atriopeptin. busConnector)
                                                annotation (Line(
            points={{6,42},{6,76},{74,76},{74,80}},
            color={0,0,255},
            thickness=0.5,
            smooth=Smooth.None));
      connect(RightAtrium.q_in, pressureMeasure.q_in) annotation (Line(
          points={{-65,9},{-92,9},{-92,-86}},
          color={0,0,0},
          thickness=1,
          smooth=Smooth.None));
      connect(pressureMeasure.pressure, busConnector.RightAtrium_Pressure)
        annotation (Line(
          points={{-82,-84},{6,-84},{6,42}},
          color={0,0,127},
          smooth=Smooth.None), Text(
          string="%second",
          index=1,
          extent={{6,3},{6,3}}));
      connect(LeftAtrium.q_in, pressureMeasure1.q_in) annotation (Line(
          points={{78,2},{94,2},{94,-84}},
          color={0,0,0},
          thickness=1,
          smooth=Smooth.None));
      connect(pressureMeasure1.pressure, busConnector.LeftAtrium_Pressure)
        annotation (Line(
          points={{84,-82},{6,-82},{6,42}},
          color={0,0,127},
          smooth=Smooth.None), Text(
          string="%second",
          index=1,
          extent={{6,3},{6,3}}));
      connect(flowMeasure.q_out, fromLeftVentricle) annotation (Line(
          points={{20,10},{12,10}},
          color={0,0,0},
          thickness=1,
          smooth=Smooth.None));
      connect(leftVentricle.q_out, flowMeasure.q_in) annotation (Line(
          points={{43.6,-2},{43.6,10},{40,10}},
          color={0,0,0},
          thickness=1,
          smooth=Smooth.None));
      connect(flowMeasure.volumeFlow, busConnector.CardiacOutput) annotation (
          Line(
          points={{30,22},{30,2},{6,2},{6,42}},
          color={0,0,127},
          smooth=Smooth.None), Text(
          string="%second",
          index=1,
          extent={{6,3},{6,3}}));
        connect(avePressure.y,lowPressureReceptors. pressure) annotation (Line(
            points={{-55.4,54},{-50,54}},
            color={0,0,127},
            smooth=Smooth.None));
        connect(busConnector.rightAtrium_TMP,avePressure. u1) annotation (Line(
            points={{6,42},{-98,42},{-98,57.6},{-69.2,57.6}},
            color={0,0,255},
            thickness=0.5,
            smooth=Smooth.None), Text(
            string="%first",
            index=-1,
            extent={{-6,3},{-6,3}}));
        connect(busConnector.leftAtrium_TMP,avePressure. u2) annotation (Line(
            points={{6,42},{-98,42},{-98,50.4},{-69.2,50.4}},
            color={0,0,255},
            thickness=0.5,
            smooth=Smooth.None), Text(
            string="%first",
            index=-1,
            extent={{-6,3},{-6,3}}));
      connect(lowPressureReceptors.NA, busConnector.AtrialLowPressureReceptors_NA)
        annotation (Line(
          points={{-30,54},{6,54},{6,42}},
          color={0,0,127},
          smooth=Smooth.None), Text(
          string="%second",
          index=1,
          extent={{6,3},{6,3}}));
      connect(rightAtrium_TMP.y, busConnector.rightAtrium_TMP) annotation (Line(
          points={{-22.8,-92},{6,-92},{6,42},{6,42}},
          color={0,0,127},
          smooth=Smooth.None), Text(
          string="%second",
          index=1,
          extent={{6,3},{6,3}}));
      connect(RightAtrium.externalPressure, rightAtrium_TMP.u2) annotation (
          Line(
          points={{-57,17},{-57,-98.4},{-30,-98.4}},
          color={0,0,127},
          smooth=Smooth.None));
      connect(pressureMeasure.pressure, rightAtrium_TMP.u1) annotation (Line(
          points={{-82,-84},{-64,-84},{-64,-92},{-36.4,-92}},
          color={0,0,127},
          smooth=Smooth.None));
      connect(pressureMeasure1.pressure, leftAtrium_TMP.u1) annotation (Line(
          points={{84,-82},{68,-82},{68,-90},{50.4,-90}},
          color={0,0,127},
          smooth=Smooth.None));
      connect(LeftAtrium.externalPressure, leftAtrium_TMP.u2) annotation (Line(
          points={{86,10},{86,-98},{44,-98},{44,-96.4}},
          color={0,0,127},
          smooth=Smooth.None));
      connect(busConnector.leftAtrium_TMP, leftAtrium_TMP.y) annotation (Line(
          points={{6,42},{6,-90},{36.8,-90}},
          color={0,0,255},
          thickness=0.5,
          smooth=Smooth.None), Text(
          string="%first",
          index=-1,
          extent={{-6,3},{-6,3}}));
        annotation ( Icon(coordinateSystem(
                preserveAspectRatio=true, extent={{-100,-100},{100,100}}),
              graphics={                Text(
                extent={{-164,-60},{156,-88}},
                lineColor={0,0,255},
                textString="%name")}),
          Documentation(info="<html>
<p>Calculates hearth pumping (left and right atria and ventricles, as wel as coronary circulation). By pressure-flow connectors communicate with pulmonary and systemic circulation.</p>
<p>Blood volume (and pressure) distributions between </p>
<p><ul>
<li>right/left atrium and</li>
<li>right/left ventricle.</li>
</ul></p>
<p>Generate average blood flow throught ventricles.</p>
<p>On the contrary of Tom Coleman models: coronary circulation outflows to right atrium, average blood volume in the hearth are calculated more simple (with the same results in steady state).</p>
</html>", revisions="<html>

<table cellspacing=\"2\" cellpadding=\"0\" border=\"0\"><tr>
<td><p>Author:</p></td>
<td><p>Marek Matejak</p></td>
</tr>
<tr>
<td><p>Design:</p></td>
<td><p>Zuzana Rubaninska</p></td>
</tr>
<tr>
<td><p>License:</p></td>
<td><p><a href=\"http://www.physiomodel.org/license.html\">Physiomodel License 1.0</a> </p></td>
</tr>

<tr>
<td><p>Date of:</p></td>
<td><p>january 2009, August 2010</p></td>
</tr>
<tr>
<td><p>References:</p></td>
<td><p>Tom Coleman: QHP 2008 beta 3,, Physiomodel 2010, University of Mississippi Medical Center</p></td>
</tr>
</table>
<br/><p>Copyright &copy; 2014 Marek Matejak, Charles University in Prague.</p><br/>

</html>"));
      end Heart;

      model Ventricle
        import Physiomodel;
       extends Physiomodel.CardioVascular.Heart.Interfaces.IVentricle;

       parameter String stateName;

      Physiolibrary.Types.Constants.FractionConst
        basicContractility(k=contractilityBasic)
        annotation (Placement(transformation(extent={{60,6},{68,14}})));

        Physiomodel.Nerves.BetaReceptorsActivityFactor betaReceptorsActivityFactor
          annotation (Placement(transformation(extent={{64,-20},{84,0}})));

        Modelica.Blocks.Math.Add Vol_SteadyState(k1=0.5, k2=0.5)
                                                   annotation (Placement(
              transformation(
              extent={{10,-10},{-10,10}},
              rotation=270,
              origin={-34,18})));

      Physiomodel.CardioVascular.Heart.Diastole diastole(
        stiffnes=stiffnes,
        n_Diastole=n_Diastole,
        NormalFillingPressure=NormalFillingPressure,
        NormalEndDiastolicVolume=NormalEndDiastolicVolume,
        NormalExternalPressure(displayUnit="Pa") = NormalExternalPressure)
        annotation (Placement(transformation(extent={{-76,-44},{-56,-24}})));
      //    ,Abasic_Diastole=Abasic_Diastole

        Systole systole(
          n_Systole=n_Systole,
          additionalPressure_Systolic=additionalPressure_Systolic,
          NormalSystolicPressure=NormalSystolicPressure,
          NormalEndSystolicVolume=NormalEndSystolicVolume,
        NormalExternalPressure=NormalExternalPressure)
          annotation (Placement(transformation(extent={{52,-44},{72,-24}})));
       //   Abasic_Systole=Abasic_Systole,

        Modelica.Blocks.Math.Feedback StrokeVolume
          annotation (Placement(transformation(extent={{-10,-10},{10,10}},
              origin={-8,-6})));

        VentricleVolumeAndPumping2 ventricle(
          initialVolume=initialVol,
          K=K,
          BasicCompliance=BasicCompliance,
          stateName=stateName)
                 annotation (Placement(transformation(extent={{-8,70},{12,90}})));

        Modelica.Blocks.Math.Product BloodFlow     annotation (Placement(
              transformation(
              extent={{-10,-10},{10,10}},
              rotation=90,
              origin={16,40})));

      equation
        connect(basicContractility.y, betaReceptorsActivityFactor.yBase)
                                                               annotation (Line(
            points={{69,10},{74,10},{74,-3}},
            color={0,0,127},
            smooth=Smooth.None));
        connect(busConnector.BetaPool_Effect, betaReceptorsActivityFactor.BetaPool_Effect)
          annotation (Line(
            points={{22,2},{22,-4},{64.2,-4}},
            color={0,0,255},
            thickness=0.5,
            smooth=Smooth.None), Text(
            string="%first",
            index=-1,
            extent={{-6,3},{-6,3}}));
        connect(busConnector.BetaBlocade_Effect, betaReceptorsActivityFactor.BetaBlockade_Effect)
          annotation (Line(
            points={{22,2},{22,-10},{64.2,-10}},
            color={0,0,255},
            thickness=0.5,
            smooth=Smooth.None), Text(
            string="%first",
            index=-1,
            extent={{-6,3},{-6,3}}));
        connect(busConnector.GangliaGeneral_NA, betaReceptorsActivityFactor.GangliaGeneral_NA)
          annotation (Line(
            points={{22,2},{22,-16},{64.2,-16}},
            color={0,0,255},
            thickness=0.5,
            smooth=Smooth.None), Text(
            string="%first",
            index=-1,
            extent={{-6,3},{-6,3}}));
        connect(diastole.externalPressure, busConnector.Pericardium_Pressure)
          annotation (Line(
            points={{-56,-40},{22,-40},{22,2}},
            color={0,0,127},
            smooth=Smooth.None), Text(
            string="%second",
            index=1,
            extent={{6,3},{6,3}}));
        connect(busConnector.Pericardium_Pressure, systole.externalPressure)
          annotation (Line(
            points={{22,2},{22,-40},{52,-40}},
            color={0,0,255},
            thickness=0.5,
            smooth=Smooth.None), Text(
            string="%first",
            index=-1,
            extent={{-6,3},{-6,3}}));
        connect(betaReceptorsActivityFactor.y, systole.contractility)
          annotation (Line(
            points={{74,-17},{74,-24},{70,-24}},
            color={0,0,127},
            smooth=Smooth.None));
        connect(diastole.EDV,StrokeVolume. u1) annotation (Line(
            points={{-56,-26},{-40,-26},{-40,-6},{-16,-6}},
            color={0,0,127},
            smooth=Smooth.None));
        connect(Vol_SteadyState.u2, diastole.EDV) annotation (Line(
            points={{-40,6},{-40,-26},{-56,-26}},
            color={0,0,127},
            smooth=Smooth.None));
        connect(systole.outflow, q_out) annotation (Line(
            points={{72,-30},{86,-30},{86,-100},{0,-100}},
            color={0,0,0},
            smooth=Smooth.None));
        connect(q_in, diastole.inflow) annotation (Line(
            points={{0,-100},{-82,-100},{-82,-30},{-76,-30}},
            color={0,0,0},
            smooth=Smooth.None));
        connect(systole.ESV, Vol_SteadyState.u1) annotation (Line(
            points={{52,-26},{-28,-26},{-28,6}},
            color={0,0,127},
            smooth=Smooth.None));
        connect(systole.ESV,StrokeVolume. u2) annotation (Line(
            points={{52,-26},{-8,-26},{-8,-14}},
            color={0,0,127},
            smooth=Smooth.None));
        connect(Vol_SteadyState.y, ventricle.VentricleSteadyStateVolume)
          annotation (Line(
            points={{-34,29},{-34,58},{-6,58},{-6,70}},
            color={0,0,127},
            smooth=Smooth.None));
        connect(q_in, ventricle.q_in)                 annotation (Line(
            points={{0,-100},{-4,-100},{-4,80},{-8,80}},
            color={0,0,0},
            smooth=Smooth.None));
        connect(ventricle.q_out, q_out)                 annotation (Line(
            points={{12,80},{6,80},{6,-100},{0,-100}},
            color={0,0,0},
            smooth=Smooth.None));
        connect(StrokeVolume.y, BloodFlow.u1)     annotation (Line(
            points={{1,-6},{10,-6},{10,28}},
            color={0,0,127},
            smooth=Smooth.None));
        connect(BloodFlow.y, ventricle.BloodFlow)                 annotation (Line(
            points={{16,51},{16,58},{10,58},{10,70}},
            color={0,0,127},
            smooth=Smooth.None));
        connect(ventricle.Volume, Vol)                 annotation (Line(
            points={{12.4,75},{62,75},{62,33},{73,33}},
            color={0,0,127},
            smooth=Smooth.None));
        connect(BloodFlow.u2, busConnector.HeartVentricleRate)
          annotation (Line(
            points={{22,28},{22,2}},
            color={0,0,127},
            smooth=Smooth.None), Text(
            string="%second",
            index=1,
            extent={{6,3},{6,3}}));

       annotation (
          Documentation(info="<HTML>
<PRE>
Heart ventricle.

like
QHP 2008 / VascularCompartments/LeftVentricle/*



The pressure-volume characteristics of both ventricles in diastole
and systole will be described using a power function.

  P = A * (V ^ n)

P = Pressure
V = Volume
A = Scale Factor
n = curvature

The function is invertable.

  V = (P/A) ^ (1/n)

Some typical values

                                 Right                 Left
                           ---------------------- ------------------------
Nominal Vol                     87.5                  87.5
Nominal TMP                      3.0                   6.0
Compliance                      29.2                  14.6
Pericardial P                   -3.0                  -3.0

DIASTOLE
  EDP                            1.0                   5.0
  EDV                          125.0                 125.0
  TMP                            4.0                   8.0
  n                              2.0                   2.0
  V^n                        15625.0               15625.0
  A                              0.00026               0.00051

SYSTOLE
  ESP                           22.0                 120.0
  ESV                           50.0                  50.0
  TMP                           25.0                 123.0
  n                              0.5                   0.5
  V^n                            7.07                  7.07
  A                              3.53                 17.39
</PRE>
</HTML>
",     revisions="<html>

<table>
<tr>
<td>Author:</td>
<td>Marek Matejak</td>
</tr>
<tr>
<td>License:</td>
<td><a href=\"http://www.physiomodel.org/license.html\">Physiomodel License 1.0</a> </td>
</tr>
<tr>
<td>By:</td>
<td>Charles University, Prague</td>
</tr>
<tr>
<td>Date of:</td>
<td>january 2009</td>
</tr>
<tr>
<td>References:</td>
<td>Tom Coleman: QHP 2008 beta 3, University of Mississippi Medical Center</td>
</tr>
</table>
<br/><p>Copyright &copy; 2014 Marek Matejak, Charles University in Prague. </p><br/>

</html>"),                                        Diagram(coordinateSystem(preserveAspectRatio=false,
                         extent={{-100,-100},{100,100}}), graphics={Text(
                extent={{-32,62},{-8,60}},
                lineColor={0,0,0},
                textString="Volume_SteadyState"), Text(
                extent={{8,62},{32,60}},
                lineColor={0,0,0},
                textString="Blood_Inflow")}));
      end Ventricle;

      model Systole

      //  Real iconPoint[20,2](each final displayUnit="mm");
      //  Real iconActualPoint[2,2](each final displayUnit="mm");

      Physiolibrary.Hydraulic.Interfaces.HydraulicPort_b outflow annotation (
          Placement(transformation(extent={{80,20},{120,60}}),
            iconTransformation(extent={{80,20},{120,60}})));

        Physiolibrary.Types.RealIO.FractionInput contractility
        "heart muscle contractility"   annotation ( extent = [70,90;90,110], rotation = -90,
        Placement(transformation(
            origin={80,100},
            extent={{-10,-10},{10,10}},
            rotation=270)));

      parameter Physiolibrary.Types.Fraction n_Systole(displayUnit="1")
        "parametrization of end diastolic volume curve";
      //parameter Real Abasic_Systole "parametrization of end systolic volume curve";
      parameter Physiolibrary.Types.Pressure NormalSystolicPressure
        "Typical value of mean arterial pressure (relative to environment ambient pressure)";
          parameter Physiolibrary.Types.Pressure NormalExternalPressure = -446
        "Typical value of pericardium cavity pressure (relative to environment ambient pressure)";
                                                                               //-446 Pa = -3.34522 mmHg
      parameter Physiolibrary.Types.Volume NormalEndSystolicVolume
        "= 2.64 ml for left ventricle, parametrization of end systolic volume curve";
      parameter Physiolibrary.Types.Pressure additionalPressure_Systolic
        "parametrization of end systolic volume curve";

        Physiolibrary.Types.RealIO.VolumeOutput
                                            ESV   annotation (Placement(transformation(extent={{-74,-74},
                  {-34,-34}}), iconTransformation(
              extent={{-10,-10},{10,10}},
              rotation=180,
              origin={-100,80})));

        Physiolibrary.Types.RealIO.PressureInput externalPressure
        "pressure around ventricle"                                             annotation (
      Placement(transformation(extent={{-110,-70},{-90,-50}}), iconTransformation(
                extent={{-110,-70},{-90,-50}})));
      equation
        outflow.q = 0;
      //  P=outflow.pressure;
      //  ESV = ((outflow.pressure+additionalPressure_Systolic-externalPressure)/(contractility*Abasic_Systole))^(1/n_Systole);
        ESV = NormalEndSystolicVolume*((outflow.pressure+additionalPressure_Systolic-externalPressure)/(contractility*(NormalSystolicPressure+additionalPressure_Systolic-NormalExternalPressure)))^(1/n_Systole);

      // drawing icon
      /*  for i in 1:size(iconPoint,1) loop
    iconPoint[i,1]=((i-1)/(size(iconPoint,1)))*180 - 90;
    (iconPoint[i,1]+90)*200/180= ((((iconPoint[i,2]+40)*200/130)+additionalPressure_Systolic-externalPressure)/(contractility*Abasic_Systole))^(1/n_Systole);
  end for;
  iconActualPoint[1,1]=ESV*180/200-90 -2;
  iconActualPoint[1,2]=outflow.pressure*130/200-40 -2;
  iconActualPoint[2,1]=iconActualPoint[1,1]+4;
  iconActualPoint[2,2]=iconActualPoint[1,2]+4;*/
                                   /*,
        Line(
          points=DynamicSelect({{-100,0},{100,0}}, iconPoint),
          color={0,0,255},
          smooth=Smooth.None),
        Ellipse(
          extent=DynamicSelect({{0,0},{0,0}}, iconActualPoint),
          lineColor={0,0,0},
          fillColor={255,0,0},
          fillPattern=FillPattern.Solid)*/
        annotation (Icon(coordinateSystem(preserveAspectRatio=true, extent={{-100,
                  -100},{100,100}}), graphics={
              Rectangle(
                extent={{-100,100},{100,-60}},
                lineColor={255,0,0},
                fillPattern=FillPattern.HorizontalCylinder,
                fillColor={255,255,255}),
              Text(
                extent={{-100,-60},{100,-100}},
                lineColor={0,0,255},
                textString="%name")}));
      end Systole;

      model Diastole
      /*  Real iconPoint[20,2](final displayUnit="mm");
  Real iconActualPoint[2,2](final displayUnit="mm");
*/
      Physiolibrary.Hydraulic.Interfaces.HydraulicPort_a inflow annotation (
          Placement(transformation(extent={{-122,-24},{-82,16}}),
            iconTransformation(extent={{-120,20},{-80,60}})));

        Physiolibrary.Types.RealIO.PressureInput externalPressure
        "pericardium pressure around ventricle"
                                       annotation ( Placement(transformation(extent={{94,-58},
                  {114,-38}}), iconTransformation(
              extent={{-10,-10},{10,10}},
              rotation=180,
              origin={100,-60})));

      parameter Physiolibrary.Types.Fraction stiffnes
        "parametrization of end diastolic volume curve";
      parameter Physiolibrary.Types.Fraction n_Diastole(displayUnit="1")
        "parametrization of end systolic volume curve";
      //parameter Real Abasic_Diastole "parametrization of end diastolic volume curve";
      parameter Physiolibrary.Types.Pressure NormalFillingPressure
        "Typicall value of mean arterial filling pressure (relative to environment ambient pressure)";
      parameter Physiolibrary.Types.Pressure NormalExternalPressure = -446
        "Typical value of pericardium cavity pressure (relative to environment ambient pressure)";
      parameter Physiolibrary.Types.Volume NormalEndDiastolicVolume
        "= (NormalDiastolicPressure/Abasic_Diastole)^n_Diastole";
      //Abasic_Diastole "parametrization of end diastolic volume curve";

        Physiolibrary.Types.RealIO.VolumeOutput
                                            EDV   annotation (Placement(transformation(extent={{-74,-74},
                  {-34,-34}}), iconTransformation(
              extent={{-10,-10},{10,10}},
              origin={100,80})));

      equation
        inflow.q = 0;
      //  P = inflow.pressure;
      //  EDV = ((inflow.pressure-externalPressure)/(stiffnes*Abasic_Diastole))^(1/n_Diastole);
        EDV = NormalEndDiastolicVolume*((inflow.pressure-externalPressure)/(stiffnes*(NormalFillingPressure-NormalExternalPressure)))^(1/n_Diastole);

        //  Stiffness = stiffnes;

      // drawing icon
      /*  for i in 1:size(iconPoint,1) loop
    iconPoint[i,1]=((i-1)/(size(iconPoint,1)))*180 - 90;
    (iconPoint[i,1]+90)*200/180 = ( ( ( (iconPoint[i,2]+40)*200/130)-externalPressure)/(stiffnes*Abasic_Diastole))^(1/n_Diastole);
  end for;
  iconActualPoint[1,1]=EDV*180/200-90 -2;
  iconActualPoint[1,2]=inflow.pressure*130/200-40 -2;
  iconActualPoint[2,1]=iconActualPoint[1,1]+4;
  iconActualPoint[2,2]=iconActualPoint[1,2]+4;*/
                                   /*,
        Line(
          points=DynamicSelect({{-100,0},{100,0}}, iconPoint),
          color={0,0,255},
          smooth=Smooth.None),
        Ellipse(
          extent=DynamicSelect({{0,0},{0,0}}, iconActualPoint),
          lineColor={0,0,0},
          fillColor={255,0,0},
          fillPattern=FillPattern.Solid)*/
        annotation (Icon(coordinateSystem(preserveAspectRatio=true, extent={{-100,
                  -100},{100,100}}), graphics={
              Rectangle(
                extent={{-100,100},{100,-60}},
                lineColor={255,0,0},
                fillPattern=FillPattern.HorizontalCylinder,
                fillColor={255,255,255}),
              Text(
                extent={{-100,-60},{100,-100}},
                lineColor={0,0,255},
                textString="%name")}));
      end Diastole;

        model VentricleVolumeAndPumping2
      "Multiple PressureFlow connector with pressures from multiple inputs"
                   extends Physiolibrary.SteadyStates.Interfaces.SteadyState(state_start=initialVolume, state(nominal=1e-4));

                    Physiolibrary.Types.RealIO.VolumeFlowRateInput BloodFlow( displayUnit=
                         "ml/min") "heart cardiac output"
                      annotation (Placement(transformation(extent={{-140,-20},{-100,20}}), iconTransformation(extent={{-20,-20},{20,20}},
                        rotation=90,
                        origin={80,-100})));
                    Physiolibrary.Hydraulic.Interfaces.HydraulicPort_a q_in annotation (
                    Placement(transformation(extent={{100,-20},{140,20}}),
                      iconTransformation(extent={{-110,-10},{-90,10}})));

                    parameter Physiolibrary.Types.Volume initialVolume(displayUnit="ml");

                    Physiolibrary.Hydraulic.Interfaces.HydraulicPort_b q_out annotation (
                    extent=[-10,-110; 10,-90], Placement(transformation(extent={{-10,
                -110},{10,-90}}, rotation=0),
                                      iconTransformation(extent={{90,-10},{110,10}})));

                    Physiolibrary.Types.VolumeFlowRate delta(displayUnit="ml/min");

                     Physiolibrary.Types.RealIO.VolumeInput VentricleSteadyStateVolume(
                                                                             displayUnit="ml")
        "heart ventricle steady state volume"
                      annotation (Placement(transformation(extent={{-140,-20},{-100,20}}), iconTransformation(extent={{-20,-20},{20,20}},
                        rotation=90,
                        origin={-80,-100})));

                    parameter Physiolibrary.Types.Frequency K( displayUnit="1/min") = 0.01666666666666666666666666666667;
                    parameter Physiolibrary.Types.Volume V0( displayUnit="ml") = 0;
                    parameter Physiolibrary.Types.HydraulicCompliance BasicCompliance(displayUnit="ml/mmHg");
                    Physiolibrary.Types.RealIO.VolumeOutput Volume(
                                                          start=initialVolume, displayUnit="ml") annotation (Placement(transformation(
                            extent={{84,-70},{124,-30}}), iconTransformation(extent={{84,-70},{
                              124,-30}})));

                  //  Real Compliance(final quantity="Compliance", final displayUnit="ml/mmHg");
                  //  Real StressedVol(final quantity="Volume", final displayUnit="ml");
                  //  Real Pressure(final quantity="Pressure", final displayUnit="mmHg");
                  //initial equation
                  //  Volume = initialVolume;
                    //der(Volume) = 0;
        equation

                    delta = (VentricleSteadyStateVolume - Volume)*K;
                  /*  if STEADY then
    der(Volume) = 0;
  else
    der(Volume) = delta / Library.SecPerMin;
  end if;
*/
                    q_in.q + q_out.q = delta;

                  if Simulation == Physiolibrary.Types.SimulationType.SteadyState then //Physiolibrary.SimulationType.STEADY then
                    q_in.q = BloodFlow;
                  else
                    q_in.q = if (delta<0) then BloodFlow else BloodFlow+delta;
                  end if;

                    //increase (delta>0) average ventricle volume means flow delta from q_in (veins)
                    //decrease (delta<0) average ventricle volume means flow delta to q_to (atrys)

                   // StressedVol  =  max( Volume - V0,  0.0);
                   // Compliance  =  BasicCompliance / VentricleDiastole_Stiffness;
                   // Pressure  =  ( StressedVol / Compliance)  + ExternalPressure;

                    state = Volume;
                    change = delta;
                    annotation (Documentation(info="<HTML>
<p>
Model has a vector of continuous Real input signals as pressures for
vector of pressure-flow connectors.
</p>
</HTML>
"));
        end VentricleVolumeAndPumping2;

      package develop
      extends Modelica.Icons.UnderConstruction;
        model Ventricle4
         extends Physiomodel.CardioVascular.Heart.Interfaces.IVentricle;

         parameter String stateName;

        Physiolibrary.Types.Constants.DeprecatedUntypedConstant
          basicContractility(k=contractilityBasic)
          annotation (Placement(transformation(extent={{60,2},{68,10}})));

          Physiomodel.Nerves.BetaReceptorsActivityFactor betaReceptorsActivityFactor
            annotation (Placement(transformation(extent={{64,-20},{84,0}})));

          Modelica.Blocks.Math.Add Vol_SteadyState(k1=0.5, k2=0.5)
                                                     annotation (Placement(
                transformation(
                extent={{10,-10},{-10,10}},
                rotation=270,
                origin={-34,18})));

        Diastole4 diastole(
          stiffnes=stiffnes,
          n_Diastole=n_Diastole,
          Abasic_Diastole=Abasic_Diastole) annotation (Placement(
              transformation(extent={{-76,-44},{-56,-24}})));

          Systole systole(
            n_Systole=n_Systole,
            Abasic_Systole=Abasic_Systole,
            additionalPressure_Systolic=additionalPressure_Systolic)
            annotation (Placement(transformation(extent={{56,-44},{76,-24}})));

          Modelica.Blocks.Math.Feedback StrokeVolume
            annotation (Placement(transformation(extent={{-10,-10},{10,10}},
                origin={-8,-6})));

          VentricleVolumeAndPumping2 ventricle(
            initialVolume=initialVol,
            K=K,
            BasicCompliance=BasicCompliance,
            stateName=stateName)
                   annotation (Placement(transformation(extent={{-8,66},{12,86}})));

          Modelica.Blocks.Math.Product BloodFlow     annotation (Placement(
                transformation(
                extent={{-10,-10},{10,10}},
                rotation=90,
                origin={16,40})));

        equation
          connect(basicContractility.y, betaReceptorsActivityFactor.yBase)
                                                                 annotation (Line(
              points={{69,6},{74,6},{74,-3}},
              color={0,0,127},
              smooth=Smooth.None));
          connect(busConnector.BetaPool_Effect, betaReceptorsActivityFactor.BetaPool_Effect)
            annotation (Line(
              points={{22,2},{22,-4},{64.2,-4}},
              color={0,0,255},
              thickness=0.5,
              smooth=Smooth.None), Text(
              string="%first",
              index=-1,
              extent={{-6,3},{-6,3}}));
          connect(busConnector.BetaBlocade_Effect, betaReceptorsActivityFactor.BetaBlockade_Effect)
            annotation (Line(
              points={{22,2},{22,-10},{64.2,-10}},
              color={0,0,255},
              thickness=0.5,
              smooth=Smooth.None), Text(
              string="%first",
              index=-1,
              extent={{-6,3},{-6,3}}));
          connect(busConnector.GangliaGeneral_NA, betaReceptorsActivityFactor.GangliaGeneral_NA)
            annotation (Line(
              points={{22,2},{22,-16},{64.2,-16}},
              color={0,0,255},
              thickness=0.5,
              smooth=Smooth.None), Text(
              string="%first",
              index=-1,
              extent={{-6,3},{-6,3}}));
          connect(diastole.externalPressure, busConnector.Pericardium_Pressure)
            annotation (Line(
              points={{-56,-40},{22,-40},{22,2}},
              color={0,0,127},
              smooth=Smooth.None), Text(
              string="%second",
              index=1,
              extent={{6,3},{6,3}}));
          connect(busConnector.Pericardium_Pressure, systole.externalPressure)
            annotation (Line(
              points={{22,2},{22,-40},{56,-40}},
              color={0,0,255},
              thickness=0.5,
              smooth=Smooth.None), Text(
              string="%first",
              index=-1,
              extent={{-6,3},{-6,3}}));
          connect(betaReceptorsActivityFactor.y, systole.contractility)
            annotation (Line(
              points={{74,-17},{74,-24}},
              color={0,0,127},
              smooth=Smooth.None));
          connect(diastole.EDV,StrokeVolume. u1) annotation (Line(
              points={{-56,-26},{-40,-26},{-40,-6},{-16,-6}},
              color={0,0,127},
              smooth=Smooth.None));
          connect(Vol_SteadyState.u2, diastole.EDV) annotation (Line(
              points={{-40,6},{-40,-26},{-56,-26}},
              color={0,0,127},
              smooth=Smooth.None));
          connect(systole.outflow, q_out) annotation (Line(
              points={{76,-30},{86,-30},{86,80},{80,80}},
              color={0,0,0},
              smooth=Smooth.None));
          connect(q_in, diastole.inflow) annotation (Line(
              points={{-80,80},{-82,80},{-82,-30},{-76,-30}},
              color={0,0,0},
              smooth=Smooth.None));
          connect(systole.ESV, Vol_SteadyState.u1) annotation (Line(
              points={{56,-26},{-28,-26},{-28,6}},
              color={0,0,127},
              smooth=Smooth.None));
          connect(systole.ESV,StrokeVolume. u2) annotation (Line(
              points={{56,-26},{-8,-26},{-8,-14}},
              color={0,0,127},
              smooth=Smooth.None));
          connect(Vol_SteadyState.y, ventricle.VentricleSteadyStateVolume)
            annotation (Line(
              points={{-34,29},{-34,58},{-6,58},{-6,66}},
              color={0,0,127},
              smooth=Smooth.None));
          connect(q_in, ventricle.q_in)                 annotation (Line(
              points={{-80,80},{-54,80},{-54,76},{-8,76}},
              color={0,0,0},
              smooth=Smooth.None));
          connect(ventricle.q_out, q_out)                 annotation (Line(
              points={{12,76},{56,76},{56,80},{80,80}},
              color={0,0,0},
              smooth=Smooth.None));
          connect(StrokeVolume.y, BloodFlow.u1)     annotation (Line(
              points={{1,-6},{10,-6},{10,28}},
              color={0,0,127},
              smooth=Smooth.None));
          connect(BloodFlow.y, ventricle.BloodFlow)                 annotation (Line(
              points={{16,51},{16,58},{10,58},{10,66}},
              color={0,0,127},
              smooth=Smooth.None));
          connect(ventricle.Volume, Vol)                 annotation (Line(
              points={{12.4,71},{14.7,71},{14.7,33},{73,33}},
              color={0,0,127},
              smooth=Smooth.None));
          connect(BloodFlow.u2, busConnector.HeartVentricleRate)
            annotation (Line(
              points={{22,28},{22,2}},
              color={0,0,127},
              smooth=Smooth.None), Text(
              string="%second",
              index=1,
              extent={{6,3},{6,3}}));
          connect(BloodFlow.y, CO) annotation (Line(
              points={{16,51},{16,59},{77,59}},
              color={0,0,127},
              smooth=Smooth.None));

          connect(diastole.HR, busConnector.HeartVentricleRate) annotation (
              Line(
              points={{-56,-33.2},{22,-33.2},{22,2}},
              color={0,0,127},
              smooth=Smooth.None), Text(
              string="%second",
              index=1,
              extent={{6,3},{6,3}}));
          connect(systole.ESV, diastole.preESV) annotation (Line(
              points={{56,-26},{-28,-26},{-28,-29.2},{-56,-29.2}},
              color={0,0,127},
              smooth=Smooth.None));
         annotation (
            Documentation(info="<HTML>
<PRE>
Heart ventricle.

like
QHP 2008 / VascularCompartments/LeftVentricle/*


The pressure-volume characteristics of both ventricles in diastole
and systole will be described using a power function.

  P = A * (V ^ n)

P = Pressure
V = Volume
A = Scale Factor
n = curvature

The function is invertable.

  V = (P/A) ^ (1/n)

Some typical values

                                 Right                 Left
                           ---------------------- ------------------------
Nominal Vol                     87.5                  87.5
Nominal TMP                      3.0                   6.0
Compliance                      29.2                  14.6
Pericardial P                   -3.0                  -3.0

DIASTOLE
  EDP                            1.0                   5.0
  EDV                          125.0                 125.0
  TMP                            4.0                   8.0
  n                              2.0                   2.0
  V^n                        15625.0               15625.0
  A                              0.00026               0.00051

SYSTOLE
  ESP                           22.0                 120.0
  ESV                           50.0                  50.0
  TMP                           25.0                 123.0
  n                              0.5                   0.5
  V^n                            7.07                  7.07
  A                              3.53                 17.39
</PRE>
</HTML>
",       revisions="<html>

<table>
<tr>
<td>Author:</td>
<td>Marek Matejak</td>
</tr>
<tr>
<td>License:</td>
<td><a href=\"http://www.physiomodel.org/license.html\">Physiomodel License 1.0</a> </td>
</tr>
<tr>
<td>By:</td>
<td>Charles University, Prague</td>
</tr>
<tr>
<td>Date of:</td>
<td>january 2009</td>
</tr>
<tr>
<td>References:</td>
<td>Tom Coleman: QHP 2008 beta 3, University of Mississippi Medical Center</td>
</tr>
</table>
<br/><p>Copyright &copy; 2014 Marek Matejak, Charles University in Prague.</p><br/>

</html>"),  Icon(coordinateSystem(preserveAspectRatio=true, extent={{-100,-100},
                    {100,100}}), graphics={Text(
                  extent={{-82,6},{76,-8}},
                  lineColor={0,0,255},
                  textString="(initial %initialVol ml)")}),
                                          Diagram(coordinateSystem(preserveAspectRatio=true,
                           extent={{-100,-100},{100,100}}), graphics={Text(
                  extent={{-32,62},{-8,60}},
                  lineColor={0,0,0},
                  textString="Volume_SteadyState"), Text(
                  extent={{8,62},{32,60}},
                  lineColor={0,0,0},
                  textString="Blood_Inflow")}));
        end Ventricle4;

        model Diastole4
          Real iconPoint[20,2](final displayUnit="mm");
          Real iconActualPoint[2,2](final displayUnit="mm");

        Physiolibrary.Hydraulic.Interfaces.HydraulicPort_a inflow annotation (
            Placement(transformation(extent={{-122,-24},{-82,16}}),
              iconTransformation(extent={{-120,20},{-80,60}})));

          Modelica.Blocks.Interfaces.RealInput externalPressure(final quantity=
                "Pressure", final displayUnit="mmHg")
          "pericardium pressure around ventricle"
                                         annotation ( Placement(transformation(extent={{94,-58},
                    {114,-38}}), iconTransformation(
                extent={{-10,-10},{10,10}},
                rotation=180,
                origin={100,-60})));

        parameter Real stiffnes "parametrization of end diastolic volume curve";
        parameter Real n_Diastole
          "parametrization of end systolic volume curve";
        parameter Real Abasic_Diastole
          "parametrization of end diastolic volume curve";

          Modelica.Blocks.Interfaces.RealOutput
                                              EDV( final quantity="Volume",
              final displayUnit="ml")   annotation (Placement(transformation(extent={{-74,-74},
                    {-34,-34}}), iconTransformation(
                extent={{-10,-10},{10,10}},
                origin={100,80})));

          Modelica.Blocks.Interfaces.RealOutput P(final quantity="Pressure",
              final displayUnit="mmHg") annotation (Placement(transformation(extent={{-74,-74},
                    {-34,-34}}), iconTransformation(
                extent={{-10,-10},{10,10}},
                rotation=270,
                origin={60,-60})));
          Modelica.Blocks.Interfaces.RealOutput Stiffness
                                 annotation (Placement(transformation(extent={{-74,-74},
                    {-34,-34}}), iconTransformation(
                extent={{-10,-10},{10,10}},
                rotation=90,
                origin={-68,100})));
          Modelica.Blocks.Interfaces.RealInput HR(final quantity="Frequency", final displayUnit=
                   "1/min") "heart rate" annotation ( Placement(transformation(extent={{94,-58},
                    {114,-38}}), iconTransformation(
                extent={{-10,-10},{10,10}},
                rotation=180,
                origin={100,8})));
          Real HR_effect;
          Real EDV_withoutHReffect;

          Modelica.Blocks.Interfaces.RealInput preESV(final quantity="Volume", final displayUnit=
                   "ml") "previous end systolic volume"
                                         annotation ( Placement(transformation(extent={{94,-58},
                    {114,-38}}), iconTransformation(
                extent={{-10,-10},{10,10}},
                rotation=180,
                origin={100,48})));
        equation
          inflow.q = 0;
          P = inflow.pressure;
          //linearna zavislost na HR - vid. mathematica/Efect_EDVonHR.nb
          HR_effect = -0.00247654 * HR + 1.18574; //  1 = a*75+b;

          EDV_withoutHReffect = (((inflow.pressure-externalPressure)/(stiffnes*Abasic_Diastole))^(1/n_Diastole));
          EDV = HR_effect * (EDV_withoutHReffect-preESV) + preESV;
          Stiffness = stiffnes;

        // drawing icon
          for i in 1:size(iconPoint,1) loop
            iconPoint[i,1]=((i-1)/(size(iconPoint,1)))*180 - 90;
            (iconPoint[i,1]+90)*200/180 = ( ( ( (iconPoint[i,2]+40)*200/130)-externalPressure)/(stiffnes*Abasic_Diastole))^(1/n_Diastole);
          end for;
          iconActualPoint[1,1]=EDV*180/200-90 -2;
          iconActualPoint[1,2]=inflow.pressure*130/200-40 -2;
          iconActualPoint[2,1]=iconActualPoint[1,1]+4;
          iconActualPoint[2,2]=iconActualPoint[1,2]+4;
          annotation (Icon(coordinateSystem(preserveAspectRatio=true, extent={{-100,
                    -100},{100,100}}), graphics={
                Rectangle(
                  extent={{-100,100},{100,-60}},
                  lineColor={255,0,0},
                  fillPattern=FillPattern.HorizontalCylinder,
                  fillColor={255,255,255}),
                Text(
                  extent={{-100,-60},{100,-100}},
                  lineColor={0,0,255},
                  textString="%name"),
                Line(
                  points=DynamicSelect({{-100,0},{100,0}}, iconPoint),
                  color={0,0,255},
                  smooth=Smooth.None),
                Ellipse(
                  extent=DynamicSelect({{0,0},{0,0}}, iconActualPoint),
                  lineColor={0,0,0},
                  fillColor={255,0,0},
                  fillPattern=FillPattern.Solid)}),
            Documentation(info="<html>
<p>The relationship heart rate(HR)-end diastolic volume(EDV) is represented by linear function -0.00247654 HR + 1.18574.</p>
<p>The coeficients was choosen to solve normal state and critical zero state: (Solve[{a*75 + b == 1, a*HR + b == 0, diastoleTime[HR] == 0}, {a, b}]).</p>
<p>It means the next ventricle filling model:</p>
<p>cardiac cycle time (T) = (60/HR) [s]</p>
<p>systolic contraction time (Ts) = (0.3*T^0.5) [s]</p>
<p>diastolic filling time (Tdf) = T - Ts - 0.18*Ts [s]</p>
<p>steady-state filling curve:</p>
<p><img src=\"C:/Users/oto/Desktop/Physiomodel/mathematicaGUI/Effect_EDVonHR.png\"/></p>
<p>axes x .. filling time = Tdf [s]</p>
<p>axes y .. entered volume part = stroke volume (SV)/normal_SV [x 100 &percnt;]</p>
<p><br/>EDV = SV + pre(ESV) = effect(HR) * ((EDV_without_HR_effect - pre(ESV)) + pre(ESV)</p>
</html>"));
        end Diastole4;

        model Ventricle2
         extends Physiomodel.CardioVascular.Heart.Interfaces.IVentricle;

         extends Physiolibrary.SteadyStates.Interfaces.SteadyState;

        type VentriclePhase = enumeration(
            ISOVOLUMIC_CONTRACTION,
            EJECTION,
            ISOVOLUMIC_RELAXATION,
            FILLING);
          VentriclePhase state(start=VentriclePhase.ISOVOLUMIC_CONTRACTION);
        //  Real Power;
          Real P(start=80,fixed=true);
          Real V(start=126,fixed=true);
          Boolean b(start=false); //b[VentriclePhase](start={false,false,false,false});
          Boolean c;
        /*  Library.PressureFlow.PositivePressureFlow q_in annotation (Placement(transformation(
          extent={{-106,-30},{-86,-10}}), iconTransformation(extent={{-27,58},{-7,
            78}})));
  Library.PressureFlow.NegativePressureFlow q_out annotation (Placement(transformation(
          extent={{86,-30},{106,-10}}), iconTransformation(extent={{10,72},{30,92}})));
*/
            Modelica.Blocks.Interfaces.RealInput
                                               PrevCirculationPower
                                             annotation (Placement(transformation(
                extent={{-20,-20},{20,20}},
                rotation=270,
                origin={-10,80}), iconTransformation(extent={{-100,50},{-80,70}})));
          //Library.Interfaces.RealInput
          Modelica.Blocks.Interfaces.RealOutput
                                              HeartMusclePower
                           annotation (Placement(transformation(
                extent={{-20,-20},{20,20}},
                rotation=270,
                origin={-10,80}), iconTransformation(extent={{-100,70},{-80,90}})));
          Modelica.Blocks.Interfaces.RealInput
                                             NextCirculationPower
                                             annotation (Placement(transformation(
                extent={{-20,-20},{20,20}},
                rotation=270,
                origin={-10,80}), iconTransformation(extent={{-100,30},{-80,50}})));
          Modelica.Blocks.Interfaces.RealInput
                                             Power     annotation (Placement(transformation(
                extent={{-20,-20},{20,20}},
                rotation=270,
                origin={-10,80}), iconTransformation(extent={{-100,10},{-80,30}})));
        equation
        /*
  b[VentriclePhase.ISOVOLUMIC_CONTRACTION]= P>=q_out.pressure; //reach true when ventricle outflow valve open
  b[VentriclePhase.EJECTION]= q_out.q>=0; //reach true when ventricle outflow valve close
  b[VentriclePhase.ISOVOLUMIC_RELAXATION]= P<=q_in.pressure; //reach true when atrium-ventricle valve open
  b[VentriclePhase.FILLING]= q_in.q<=0; //reach true when atrium-ventricle valve close

  when edge(b[pre(state)]) then
    */
          c = pre(b);
          when edge(c) then
            state=mod(pre(state)+1,4);
          end when;

          Power=der(P)*V + der(V)*P;  //=der(V*P)

        //  der(V)= q_out.q + q_in.q;
        state = V;
          changePerMin = q_out.q + q_in.q;

          if state==VentriclePhase.ISOVOLUMIC_CONTRACTION then
            Power=HeartMusclePower;
            q_in.q=0;
            q_out.q=0;
            b = P>=q_out.pressure; //reach true when ventricle outflow valve open
          elseif state==VentriclePhase.EJECTION then
            Power=HeartMusclePower;//-NextCirculationPower;
            q_in.q=0;
            P=q_out.pressure;
            b = q_out.q>=0; //reach true when ventricle outflow valve close
          elseif state==VentriclePhase.ISOVOLUMIC_RELAXATION then
            Power=HeartMusclePower;
            q_in.q=0;
            q_out.q=0;
            b = P<=q_in.pressure; //reach true when atrium-ventricle valve open
          else //filling
            Power=HeartMusclePower; //-PrevCirculationPower;
            P=q_in.pressure;
            q_out.q=0;
            b = q_in.q<=0; //reach true when atrium-ventricle valve close
          end if;

          CO=-q_out.q;
          Vol = V;

        end Ventricle2;

        model Diastole3
        /*  Real iconPoint[20,2](each final displayUnit="mm");
  Real iconActualPoint[2,2](each final displayUnit="mm");
  */

        Physiolibrary.Hydraulic.Interfaces.HydraulicPort_a inflow annotation (
            Placement(transformation(extent={{-122,-24},{-82,16}}),
              iconTransformation(extent={{-120,20},{-80,60}})));

          Physiolibrary.Types.RealIO.PressureInput externalPressure
          "pericardium pressure around ventricle"
                                         annotation ( Placement(transformation(extent={{94,-58},
                    {114,-38}}), iconTransformation(
                extent={{-10,-10},{10,10}},
                rotation=180,
                origin={100,-60})));

        parameter Physiolibrary.Types.Fraction stiffnes
          "parametrization of end diastolic volume curve";
        parameter Physiolibrary.Types.Fraction n_Diastole
          "parametrization of end systolic volume curve";
        parameter Real Abasic_Diastole
          "parametrization of end diastolic volume curve";

          Physiolibrary.Types.RealIO.VolumeOutput
                                              EDV   annotation (Placement(transformation(extent={{-74,-74},
                    {-34,-34}}), iconTransformation(
                extent={{-10,-10},{10,10}},
                origin={100,80})));

          Physiolibrary.Types.RealIO.PressureOutput P annotation (Placement(transformation(extent={{-74,-74},
                    {-34,-34}}), iconTransformation(
                extent={{-10,-10},{10,10}},
                rotation=270,
                origin={60,-60})));
          Physiolibrary.Types.RealIO.FractionOutput Stiffness
                                 annotation (Placement(transformation(extent={{-74,-74},
                    {-34,-34}}), iconTransformation(
                extent={{-10,-10},{10,10}},
                rotation=90,
                origin={-68,100})));
          Physiolibrary.Types.RealIO.FrequencyInput HR "heart rate" annotation ( Placement(transformation(extent={{94,-58},
                    {114,-38}}), iconTransformation(
                extent={{-10,-10},{10,10}},
                rotation=180,
                origin={100,8})));
          Physiolibrary.Types.Fraction HR_effect;
          Physiolibrary.Types.Time a;
          Physiolibrary.Types.Fraction  b;
        equation
          inflow.q = 0;
          P = inflow.pressure;
          //linearna zavislost na HR - vid. mathematica/Efect_EDVonHR.nb
          HR_effect = a*HR+b;
          1 = a*75+b;
          0.52 = a*200+b;

          EDV = (((inflow.pressure-externalPressure)/(stiffnes*Abasic_Diastole))^(1/n_Diastole))*HR_effect;
          Stiffness = stiffnes;

        // drawing icon
        /*  for i in 1:size(iconPoint,1) loop
    iconPoint[i,1]=((i-1)/(size(iconPoint,1)))*180 - 90;
    (iconPoint[i,1]+90)*200/180 = ( ( ( (iconPoint[i,2]+40)*200/130)-externalPressure)/(stiffnes*Abasic_Diastole))^(1/n_Diastole);
  end for;
  iconActualPoint[1,1]=EDV*180/200-90 -2;
  iconActualPoint[1,2]=inflow.pressure*130/200-40 -2;
  iconActualPoint[2,1]=iconActualPoint[1,1]+4;
  iconActualPoint[2,2]=iconActualPoint[1,2]+4;*/
                                     /*,
        Line(
          points=DynamicSelect({{-100,0},{100,0}}, iconPoint),
          color={0,0,255},
          smooth=Smooth.None),
        Ellipse(
          extent=DynamicSelect({{0,0},{0,0}}, iconActualPoint),
          lineColor={0,0,0},
          fillColor={255,0,0},
          fillPattern=FillPattern.Solid)*/
          annotation (Icon(coordinateSystem(preserveAspectRatio=true, extent={{-100,
                    -100},{100,100}}), graphics={
                Rectangle(
                  extent={{-100,100},{100,-60}},
                  lineColor={255,0,0},
                  fillPattern=FillPattern.HorizontalCylinder,
                  fillColor={255,255,255}),
                Text(
                  extent={{-100,-60},{100,-100}},
                  lineColor={0,0,255},
                  textString="%name")}),            Documentation(info="<html>
<p>The relationship heart rate(HR)-end diastolic volume(EDV) is represented by linear function -0.00247654 HR + 1.18574.</p>
<p>The coeficients was choosen to solve normal state and critical zero state: (Solve[{a*75 + b == 1, a*HR + b == 0, diastoleTime[HR] == 0}, {a, b}]).</p>
<p>It means the next ventricle filling model:</p>
<p>cardiac cycle time (T) = (60/HR) [s]</p>
<p>systolic contraction time (Ts) = (0.3*T^0.5) [s]</p>
<p>diastolic filling time (Tdf) = T - Ts - 0.18*Ts [s]</p>
<p>steady-state filling curve:</p>
<p><img src=\"C:/Users/oto/Desktop/Physiomodel/mathematicaGUI/Effect_EDVonHR.png\"/></p>
<p>axes x .. filling time = Tdf [s]</p>
<p>axes y .. entered volume part = stroke volume (SV)/normal_SV [x 100 &percnt;]</p>
<p><br/>EDV = SV + pre(ESV) = effect(HR) * ((EDV_without_HR_effect - pre(ESV)) + pre(ESV)</p>
</html>"));
        end Diastole3;

        model Ventricle3
         extends Physiomodel.CardioVascular.Heart.Interfaces.IVentricle;

         parameter String stateName;

        Physiolibrary.Types.Constants.FractionConst
          basicContractility(k=contractilityBasic)
          annotation (Placement(transformation(extent={{60,2},{68,10}})));

          Physiomodel.Nerves.BetaReceptorsActivityFactor betaReceptorsActivityFactor
            annotation (Placement(transformation(extent={{64,-20},{84,0}})));

          Modelica.Blocks.Math.Add Vol_SteadyState(k1=0.5, k2=0.5)
                                                     annotation (Placement(
                transformation(
                extent={{10,-10},{-10,10}},
                rotation=270,
                origin={-34,18})));

        develop.Diastole3 diastole(
          stiffnes=stiffnes,
          n_Diastole=n_Diastole,
          Abasic_Diastole=Abasic_Diastole) annotation (Placement(
              transformation(extent={{-76,-44},{-56,-24}})));

          Systole systole(
            n_Systole=n_Systole,
            Abasic_Systole=Abasic_Systole,
            additionalPressure_Systolic=additionalPressure_Systolic,
          NormalSystolicPressure=NormalSystolicPressure,
          NormalEndSystolicVolume=NormalEndSystolicVolume)
            annotation (Placement(transformation(extent={{56,-44},{76,-24}})));

          Modelica.Blocks.Math.Feedback StrokeVolume
            annotation (Placement(transformation(extent={{-10,-10},{10,10}},
                origin={-8,-6})));

          VentricleVolumeAndPumping2 ventricle(
            initialVolume=initialVol,
            K=K,
            BasicCompliance=BasicCompliance,
            stateName=stateName)
                   annotation (Placement(transformation(extent={{-8,66},{12,86}})));

          Modelica.Blocks.Math.Product BloodFlow     annotation (Placement(
                transformation(
                extent={{-10,-10},{10,10}},
                rotation=90,
                origin={16,40})));

        equation
          connect(basicContractility.y, betaReceptorsActivityFactor.yBase)
                                                                 annotation (Line(
              points={{69,6},{74,6},{74,-3}},
              color={0,0,127},
              smooth=Smooth.None));
          connect(busConnector.BetaPool_Effect, betaReceptorsActivityFactor.BetaPool_Effect)
            annotation (Line(
              points={{22,2},{22,-4},{64.2,-4}},
              color={0,0,255},
              thickness=0.5,
              smooth=Smooth.None), Text(
              string="%first",
              index=-1,
              extent={{-6,3},{-6,3}}));
          connect(busConnector.BetaBlocade_Effect, betaReceptorsActivityFactor.BetaBlockade_Effect)
            annotation (Line(
              points={{22,2},{22,-10},{64.2,-10}},
              color={0,0,255},
              thickness=0.5,
              smooth=Smooth.None), Text(
              string="%first",
              index=-1,
              extent={{-6,3},{-6,3}}));
          connect(busConnector.GangliaGeneral_NA, betaReceptorsActivityFactor.GangliaGeneral_NA)
            annotation (Line(
              points={{22,2},{22,-16},{64.2,-16}},
              color={0,0,255},
              thickness=0.5,
              smooth=Smooth.None), Text(
              string="%first",
              index=-1,
              extent={{-6,3},{-6,3}}));
          connect(diastole.externalPressure, busConnector.Pericardium_Pressure)
            annotation (Line(
              points={{-56,-40},{22,-40},{22,2}},
              color={0,0,127},
              smooth=Smooth.None), Text(
              string="%second",
              index=1,
              extent={{6,3},{6,3}}));
          connect(busConnector.Pericardium_Pressure, systole.externalPressure)
            annotation (Line(
              points={{22,2},{22,-40},{56,-40}},
              color={0,0,255},
              thickness=0.5,
              smooth=Smooth.None), Text(
              string="%first",
              index=-1,
              extent={{-6,3},{-6,3}}));
          connect(betaReceptorsActivityFactor.y, systole.contractility)
            annotation (Line(
              points={{74,-17},{74,-24}},
              color={0,0,127},
              smooth=Smooth.None));
          connect(diastole.EDV,StrokeVolume. u1) annotation (Line(
              points={{-56,-26},{-40,-26},{-40,-6},{-16,-6}},
              color={0,0,127},
              smooth=Smooth.None));
          connect(Vol_SteadyState.u2, diastole.EDV) annotation (Line(
              points={{-40,6},{-40,-26},{-56,-26}},
              color={0,0,127},
              smooth=Smooth.None));
          connect(systole.outflow, q_out) annotation (Line(
              points={{76,-30},{86,-30},{86,80},{80,80}},
              color={0,0,0},
              smooth=Smooth.None));
          connect(q_in, diastole.inflow) annotation (Line(
              points={{-80,80},{-82,80},{-82,-30},{-76,-30}},
              color={0,0,0},
              smooth=Smooth.None));
          connect(systole.ESV, Vol_SteadyState.u1) annotation (Line(
              points={{56,-26},{-28,-26},{-28,6}},
              color={0,0,127},
              smooth=Smooth.None));
          connect(systole.ESV,StrokeVolume. u2) annotation (Line(
              points={{56,-26},{-8,-26},{-8,-14}},
              color={0,0,127},
              smooth=Smooth.None));
          connect(Vol_SteadyState.y, ventricle.VentricleSteadyStateVolume)
            annotation (Line(
              points={{-34,29},{-34,58},{-6,58},{-6,66}},
              color={0,0,127},
              smooth=Smooth.None));
          connect(q_in, ventricle.q_in)                 annotation (Line(
              points={{-80,80},{-54,80},{-54,76},{-8,76}},
              color={0,0,0},
              smooth=Smooth.None));
          connect(ventricle.q_out, q_out)                 annotation (Line(
              points={{12,76},{56,76},{56,80},{80,80}},
              color={0,0,0},
              smooth=Smooth.None));
          connect(StrokeVolume.y, BloodFlow.u1)     annotation (Line(
              points={{1,-6},{10,-6},{10,28}},
              color={0,0,127},
              smooth=Smooth.None));
          connect(BloodFlow.y, ventricle.BloodFlow)                 annotation (Line(
              points={{16,51},{16,58},{10,58},{10,66}},
              color={0,0,127},
              smooth=Smooth.None));
          connect(ventricle.Volume, Vol)                 annotation (Line(
              points={{12.4,71},{14.7,71},{14.7,33},{73,33}},
              color={0,0,127},
              smooth=Smooth.None));
          connect(BloodFlow.u2, busConnector.HeartVentricleRate)
            annotation (Line(
              points={{22,28},{22,2}},
              color={0,0,127},
              smooth=Smooth.None), Text(
              string="%second",
              index=1,
              extent={{6,3},{6,3}}));
          connect(BloodFlow.y, CO) annotation (Line(
              points={{16,51},{16,59},{77,59}},
              color={0,0,127},
              smooth=Smooth.None));

          connect(diastole.HR, busConnector.HeartVentricleRate) annotation (
              Line(
              points={{-56,-33.2},{22,-33.2},{22,2}},
              color={0,0,127},
              smooth=Smooth.None), Text(
              string="%second",
              index=1,
              extent={{6,3},{6,3}}));
         annotation (
            Documentation(info="<HTML>
<PRE>
Heart ventricle.

like
QHP 2008 / VascularCompartments/LeftVentricle/*



The pressure-volume characteristics of both ventricles in diastole
and systole will be described using a power function.

  P = A * (V ^ n)

P = Pressure
V = Volume
A = Scale Factor
n = curvature

The function is invertable.

  V = (P/A) ^ (1/n)

Some typical values

                                 Right                 Left
                           ---------------------- ------------------------
Nominal Vol                     87.5                  87.5
Nominal TMP                      3.0                   6.0
Compliance                      29.2                  14.6
Pericardial P                   -3.0                  -3.0

DIASTOLE
  EDP                            1.0                   5.0
  EDV                          125.0                 125.0
  TMP                            4.0                   8.0
  n                              2.0                   2.0
  V^n                        15625.0               15625.0
  A                              0.00026               0.00051

SYSTOLE
  ESP                           22.0                 120.0
  ESV                           50.0                  50.0
  TMP                           25.0                 123.0
  n                              0.5                   0.5
  V^n                            7.07                  7.07
  A                              3.53                 17.39
</PRE>
</HTML>
",       revisions="<html>

<table>
<tr>
<td>Author:</td>
<td>Marek Matejak</td>
</tr>
<tr>
<td>License:</td>
<td><a href=\"http://www.physiomodel.org/license.html\">Physiomodel License 1.0</a> </td>
</tr>
<tr>
<td>By:</td>
<td>Charles University, Prague</td>
</tr>
<tr>
<td>Date of:</td>
<td>january 2009</td>
</tr>
<tr>
<td>References:</td>
<td>Tom Coleman: QHP 2008 beta 3, University of Mississippi Medical Center</td>
</tr>
</table>
<br/><p>Copyright &copy; 2014 Marek Matejak, Charles University in Prague.</p><br/>

</html>"),  Icon(coordinateSystem(preserveAspectRatio=true, extent={{-100,-100},
                    {100,100}}), graphics={Text(
                  extent={{-78,26},{80,12}},
                  lineColor={0,0,0},
                  textString="contractilityBasic = %contractilityBasic")}),
                                          Diagram(coordinateSystem(preserveAspectRatio=true,
                           extent={{-100,-100},{100,100}}), graphics={Text(
                  extent={{-32,62},{-8,60}},
                  lineColor={0,0,0},
                  textString="Volume_SteadyState"), Text(
                  extent={{8,62},{32,60}},
                  lineColor={0,0,0},
                  textString="Blood_Inflow")}));
        end Ventricle3;
      end develop;
    end Heart;

    package Circulation "Blood Cardio-Vascular Distribution"
      class References "References"
        extends Modelica.Icons.References;

        annotation (Documentation(info="<html>
<table>

	<tr>
		<td>[Alfie1999]</td>
		<td>J. Alfie, G. D. Waisman, C. R. Galarza, and M. I. Cámera, \"Contribution of Stroke Volume to the Change in Pulse Pressure Pattern With Age,\" Hypertension, vol. 34, pp. 808-812, October 1, 1999 1999. </td>
	</tr>
	<tr>
		<td>[Alsberge1988]</td>
		<td>M. Alsberge, M. Magno, and M. Lipschutz, Carotid body control of bronchial circulation in sheep vol. 65, 1988. </td>
	</tr>
	<tr>
		<td>[Archer2002]</td>
		<td>S. Archer and E. Michelakis, The Mechanism(s) of Hypoxic Pulmonary Vasoconstriction: Potassium Channels, Redox O2 Sensors, and Controversies vol. 17, 2002. </td>
	</tr>
	<tr>
		<td>[Archer1996]</td>
		<td>S. L. Archer, J. M. C. Huang, H. L. Reeve, V. Hampl, S. Tolarová, E. Michelakis, et al., \"Differential Distribution of Electrophysiologically Distinct Myocytes in Conduit and Resistance Arteries Determines Their Response to Nitric Oxide and Hypoxia,\" Circulation Research, vol. 78, pp. 431-442, March 1, 1996 1996. </td>
	</tr>
	<tr>
		<td>[Armstrong1985]</td>
		<td>R. Armstrong, C. Vandenakker, and M. Laughlin, \"Muscle blood flow patterns during exercise in partially curarized rats,\" Journal of Applied Physiology, vol. 58, pp. 698-701, 1985. </td>
	</tr>
	<tr>
		<td>[Ashley1992]</td>
		<td>K. D. Ashley, D. N. Herndon, L. D. Traber, D. L. Traber, K. Deubel-Ashley, J. Stothert, et al., \"Systemic blood flow to sheep lung: comparison of flow probes and microspheres,\" Journal of Applied Physiology, vol. 73, pp. 1996-1996, 1992. </td>
	</tr>
	<tr>
		<td>[Bangsbo1997]</td>
		<td>J. Bangsbo, C. Juel, Y. Hellsten, and B. Saltin, \"Dissociation between lactate and proton exchange in muscle during intense exercise in man,\" The Journal of Physiology, vol. 504, pp. 489-499, October 15, 1997 1997. </td>
	</tr>
	<tr>
		<td>[Berg1997]</td>
		<td>B. R. Berg, K. D. Cohen, and I. H. Sarelius, \"Direct coupling between blood flow and metabolism at the capillary level in striated muscle,\" American Journal of Physiology-Heart and Circulatory Physiology, vol. 41, p. H2693, 1997. </td>
	</tr>
	<tr>
		<td>[Bevegärd1962]</td>
		<td>S. Bevegärd and A. Lodin, \"Postural Circulatory Changes at Rest and during Exercise in five Patients with Congenital Absence of Valves in the Deep Veins of the Legs,\" Acta Medica Scandinavica, vol. 172, pp. 21-29, 1962. </td>
	</tr>
	<tr>
		<td>[Bock1930]</td>
		<td>A. V. Bock, D. B. Dill, and H. T. Edwards, \"ON THE RELATION OF CHANGES IN BLOOD VELOCITY AND VOLUME FLOW OF BLOOD TO CHANGE OF POSTURE,\" The Journal of Clinical Investigation, vol. 8, pp. 533-544, 1930. </td>
	</tr>
	<tr>
		<td>[Borgström1975]</td>
		<td>L. Borgström, H. Jóhannsson, and B. K. Siesjö, \"The Relationship between Arterial PO2 and Cerebral Blood Flow in Hypoxic Hypoxia,\" Acta Physiologica Scandinavica, vol. 93, pp. 423-432, 1975. </td>
	</tr>
	<tr>
		<td>[Burattini1994]</td>
		<td>R. Burattini, P. Borgdorff, and N. Westerhof, \"Relationship between strength of short-term systemic autoregulation and initial resistance,\" American Journal of Physiology-Regulatory Integrative and Comparative Physiology, vol. 36, p. R1182, 1994. </td>
	</tr>
	<tr>
		<td>[Davidson1986]</td>
		<td>D. Davidson, S. A. Stalcup, and R. B. Mellins, Systemic hemodynamics affecting cardiac output during hypocapnic and hypercapnic hypoxia vol. 60, 1986. </td>
	</tr>
	<tr>
		<td>[Drury1927]</td>
		<td>A. Drury and N. Jones, \"Observations upon the rate at which oedema forms when the veins of the human limb are congested,\" Heart, vol. 14, p. 8, 1927. </td>
	</tr>
	<tr>
		<td>[Dunbar2001]</td>
		<td>S. L. Dunbar, L. Tamhidi, D. E. Berkowitz, and A. A. Shoukas, Hindlimb unweighting affects rat vascular capacitance function vol. 281, 2001. </td>
	</tr>
	<tr>
		<td>[Frisbee2000]</td>
		<td>J. C. Frisbee and J. H. Lombard, \"Increased Intravascular Pressure Does Not Enhance Skeletal Muscle Arteriolar Constriction to Oxygen or Angiotensin II,\" Microvascular Research, vol. 59, pp. 176-180, 1// 2000. </td>
	</tr>
	<tr>
		<td>[Frisbee2000]</td>
		<td>J. C. Frisbee and J. H. Lombard, \"Short-term angiotensin converting enzyme inhibition reduces basal tone and dilator reactivity in skeletal muscle arterioles*,\" American Journal of Hypertension, vol. 13, pp. 389-395, April 1, 2000 2000. </td>
	</tr>
	<tr>
		<td>[Goodman1978]</td>
		<td>A. H. Goodman, R. Einstein, and H. J. Granger, \"Effect of changing metabolic rate on local blood flow control in the canine hindlimb,\" Circulation Research, vol. 43, pp. 769-76, November 1, 1978 1978. </td>
	</tr>
	<tr>
		<td>[Granger1969]</td>
		<td>H. J. Granger and A. C. Guyton, \"Autoregulation of the Total Systemic Circulation Following Destruction of the Central Nervous System in the Dog,\" Circulation Research, vol. 25, pp. 379-388, October 1, 1969 1969. </td>
	</tr>
	<tr>
		<td>[Granger1976]</td>
		<td>H. J. Granger, A. H. Goodman, and D. N. Granger, \"Role of resistance and exchange vessels in local microvascular control of skeletal muscle oxygenation in the dog,\" Circulation Research, vol. 38, pp. 379-85, May 1, 1976 1976. </td>
	</tr>
	<tr>
		<td>[Harder1996]</td>
		<td>D. R. Harder, J. Narayanan, E. K. Birks, J. F. Liard, J. D. Imig, J. H. Lombard, et al., \"Identification of a Putative Microvascular Oxygen Sensor,\" Circulation Research, vol. 79, pp. 54-61, July 1, 1996 1996. </td>
	</tr>
	<tr>
		<td>[Hennessy1993]</td>
		<td>E. Hennessy, S. White, T. Van der Touw, A. Quail, W. Porges, and P. Glenfield, \"Control of resting bronchial hemodynamics in the awake dog,\" American Journal of Physiology, vol. 265, pp. H649-H649, 1993. </td>
	</tr>
	<tr>
		<td>[Henry1950]</td>
		<td>J. P. Henry and O. H. Gauer, \"THE INFLUENCE OF TEMPERATURE UPON VENOUS PRESSURE IN THE FOOT,\" The Journal of Clinical Investigation, vol. 29, pp. 855-861, 1950. </td>
	</tr>
	<tr>
		<td>[Hogan1990]</td>
		<td>M. C. Hogan, D. E. Bebout, A. T. Gray, P. D. Wagner, J. B. West, and P. E. Haab, Muscle maximal O2 uptake at constant O2 delivery with and without CO in the blood vol. 69, 1990. </td>
	</tr>
	<tr>
		<td>[Charan1984]</td>
		<td>N. B. Charan, G. M. Turk, and R. Dhand, \"Gross and subgross anatomy of bronchial circulation in sheep,\" J Appl Physiol, vol. 57, pp. 658-664, 1984. </td>
	</tr>
	<tr>
		<td>[Charles1994]</td>
		<td>J. B. Charles and C. M. Lathers, \"Summary of Lower Body Negative Pressure Experiments During Space Flight,\" The Journal of Clinical Pharmacology, vol. 34, pp. 571-583, 1994. </td>
	</tr>
	<tr>
		<td>[Joseph1952]</td>
		<td>J. Joseph and A. Nightingale, \"Electromyography of muscles of posture: leg muscles in males,\" The Journal of Physiology, vol. 117, pp. 484-491, August 28, 1952 1952. </td>
	</tr>
	<tr>
		<td>[Katkov1980]</td>
		<td>V. E. Katkov and V. V. Chestukhin, \"Blood pressure and oxygenation in different cardiovascular compartments of a normal man during postural exposures,\" Aviat Space Environ Med, vol. 51, pp. 1234-42, Nov 1980. </td>
	</tr>
	<tr>
		<td>[Kunert1996]</td>
		<td>M. P. Kunert, J. F. Liard, D. J. Abraham, and J. H. Lombard, \"Low-Affinity Hemoglobin Increases Tissue PO2and Decreases Arteriolar Diameter and Flow in the Rat Cremaster Muscle,\" Microvascular Research, vol. 52, pp. 58-68, 7// 1996. </td>
	</tr>
	<tr>
		<td>[Kuwahira1993]</td>
		<td>I. Kuwahira, N. Heisler, J. Piiper, and N. C. Gonzalez, \"Effect of chronic hypoxia on hemodynamics, organ blood flow and O2 supply in rats,\" Respiration Physiology, vol. 92, pp. 227-238, 5// 1993. </td>
	</tr>
	<tr>
		<td>[Landis1933]</td>
		<td>E. M. Landis and J. H. Gibbon, Jr., \"THE EFFECTS OF TEMPERATURE AND OF TISSUE PRESSURE ON THE MOVEMENT OF FLUID THROUGH THE HUMAN CAPILLARY WALL,\" The Journal of Clinical Investigation, vol. 12, pp. 105-138, 1933. </td>
	</tr>
	<tr>
		<td>[Lash1987]</td>
		<td>J. M. Lash and H. G. Bohlen, Perivascular and tissue PO2 in contracting rat spinotrapezius muscle vol. 252, 1987. </td>
	</tr>
	<tr>
		<td>[LAUGHLIN1987]</td>
		<td>M. H. LAUGHLIN, \"Skeletal muscle blood flow capacity: role of muscle pump in exercise hyperemia,\" Am J Physiol, vol. 253, p. 1004, 1987. </td>
	</tr>
	<tr>
		<td>[Laughlin1983]</td>
		<td>M. H. Laughlin and R. Armstrong, \"Rat muscle blood flows as a function of time during prolonged slow treadmill exercise,\" Am J Physiol Heart Circ Physiol, vol. 244, pp. H814-H824, 1983. </td>
	</tr>
	<tr>
		<td>[Malo1984]</td>
		<td>J. Malo, H. Goldberg, R. Graham, H. Unruh, and C. Skoog, Effect of hypoxic hypoxia on systemic vasculature vol. 56, 1984. </td>
	</tr>
	<tr>
		<td>[Marshall1995]</td>
		<td>J. Marshall, Skeletal Muscle Vasculature and Systemic Hypoxia vol. 10, 1995. </td>
	</tr>
	<tr>
		<td>[Marshall1988]</td>
		<td>J. M. Marshall and J. D. Metcalfe, \"Analysis of the cardiovascular changes induced in the rat by graded levels of systemic hypoxia,\" The Journal of Physiology, vol. 407, pp. 385-403, December 1, 1988 1988. </td>
	</tr>
	<tr>
		<td>[Mayerson1939]</td>
		<td>H. S. Mayerson, H. M. Sweeney, and L. A. Toth, THE INFLUENCE OF POSTURE ON CIRCULATION TIME vol. 125, 1939. </td>
	</tr>
	<tr>
		<td>[Metting1988]</td>
		<td>P. J. Metting, J. R. Strader, and S. L. Britton, Evaluation of whole body autoregulation in conscious dogs vol. 255, 1988. </td>
	</tr>
	<tr>
		<td>[Metting1989]</td>
		<td>P. J. Metting, P. M. Stein, B. A. Stoos, K. A. Kostrzewski, and S. L. Britton, Systemic vascular autoregulation amplifies pressor responses to vasoconstrictor agents vol. 256, 1989. </td>
	</tr>
	<tr>
		<td>[Monos2001]</td>
		<td>E. Monos, M. Lóránt, and E. Fehér, Influence of long-term experimental orthostatic body position on innervation density in extremity vessels vol. 281, 2001. </td>
	</tr>
	<tr>
		<td>[Monos2003]</td>
		<td>E. Monos, M. Lóránt, G. Dörnyei, V. Bérczi, and G. Nádasy, Long-Term Adaptation Mechanisms in Extremity Veins Supporting Orthostatic Tolerance vol. 18, 2003. </td>
	</tr>
	<tr>
		<td>[O’ROURKE1990]</td>
		<td>S. T. O’ROURKE and P. M. VANHOUTTE, \"Adrenergic and cholinergic responsiveness of isolated canine bronchial arteries,\" Organ, vol. 6, p. 2, 1990. </td>
	</tr>
	<tr>
		<td>[OCHSNER1951]</td>
		<td>A. OCHSNER, R. COLP, and G. E. BURCH, \"Normal Blood Pressure in the Superficial Venous System of Man at Rest in the Supine Position,\" Circulation, vol. 3, pp. 674-680, May 1, 1951 1951. </td>
	</tr>
	<tr>
		<td>[POHOST1976]</td>
		<td>G. M. POHOST, J. B. NEWELL, N. P. HAMLIN, and W. J. POWELL, \"Observations on autoregulation in skeletal muscle: the effects of arterial hypoxia,\" Cardiovascular Research, vol. 10, pp. 405-412, July 1, 1976 1976. </td>
	</tr>
	<tr>
		<td>[Pollack1949]</td>
		<td>A. A. Pollack and E. H. Wood, Venous Pressure in the Saphenous Vein at the Ankle in Man during Exercise and Changes in Posture vol. 1, 1949. </td>
	</tr>
	<tr>
		<td>[Prewitt1976]</td>
		<td>R. L. Prewitt and P. C. Johnson, \"The effect of oxygen on arteriolar red cell velocity and capillary density in the rat cremaster muscle,\" Microvascular Research, vol. 12, pp. 59-70, 7// 1976. </td>
	</tr>
	<tr>
		<td>[Raven1984]</td>
		<td>P. B. Raven, D. Rohm-Young, and C. G. Blomqvist, Physical fitness and cardiovascular response to lower body negative pressure vol. 56, 1984. </td>
	</tr>
	<tr>
		<td>[Roach1957]</td>
		<td>M. R. Roach and A. C. Burton, \"THE REASON FOR THE SHAPE OF THE DISTENSIBILITY CURVES OF ARTERIES,\" Canadian Journal of Biochemistry and Physiology, vol. 35, pp. 681-690, 1957/08/01 1957. </td>
	</tr>
	<tr>
		<td>[Stevens]</td>
		<td>StevensP. M. Stevens and L. E. Lamb, \"Effects of lower body negative pressure on the cardiovascular system,\" American Journal of Cardiology, vol. 16, pp. 506-515.</td>
	<tr>
		<td>[Stick1992]</td>
		<td>C. Stick, H. Jaeger, and E. Witzleb, Measurements of volume changes and venous pressure in the human lower leg during walking and running vol. 72, 1992. </td>
	</tr>
	<tr>
		<td>[Stonestreet1998]</td>
		<td>B. S. Stonestreet, S. S. Ocampo, and W. Oh, Reductions in cardiac output in hypoxic young pigs: systemic and regional perfusion and oxygen metabolism vol. 85, 1998. </td>
	</tr>
	<tr>
		<td>[Stothert1992]</td>
		<td>J. C. Stothert, J. O. Basadre, G. B. Gbaanador, J. T. Flynn, L. Traber, and D. Traber, \"Bronchial blood flow during changes in inhaled oxygen and carbon dioxide concentrations in conscious sheep,\" Circulatory shock, vol. 36, pp. 120-126, 1992/02// 1992. </td>
	</tr>
	<tr>
		<td>[Schumacker]</td>
		<td>SchumackerS. P. T. and C. S. M., \"The concept of a critical oxygen delivery,\" Intensive Care Medicine, vol. 13, pp. 223-229, January 1, 0001.</td>
	<tr>
		<td>[Thompson1928]</td>
		<td>W. O. Thompson, P. K. Thompson, and M. E. Dailey, \"THE EFFECT OF POSTURE UPON THE COMPOSITION AND VOLUME OF THE BLOOD IN MAN 1,\" The Journal of Clinical Investigation, vol. 5, pp. 573-604, 1928. </td>
	</tr>
	<tr>
		<td>[Wagner1988]</td>
		<td>E. M. Wagner and W. A. Mitzner, \"Effect of hypoxia on bronchial circulation,\" J. Appl. Physiol, vol. 65, pp. 1627-1633, 1988. </td>
	</tr>
	<tr>
		<td>[Wagner1990]</td>
		<td>E. M. Wagner and W. A. Mitzner, \"Effect of left atrial pressure on bronchial vascular hemodynamics,\" J Appl Physiol, vol. 69, pp. 837-842, 1990. </td>
	</tr>
	<tr>
		<td>[Weber2000]</td>
		<td>D. S. Weber and J. H. Lombard, Elevated salt intake impairs dilation of rat skeletal muscle resistance arteries via ANG II suppression vol. 278, 2000. </td>
	</tr>
	<tr>
		<td>[Wells1938]</td>
		<td>H. S. Wells, J. B. Youmans, and D. G. Miller, Jr., \"TISSUE PRESSURE (INTRACUTANEOUS, SUBCUTANEOUS, AND INTRAMUSCULAR) AS RELATED TO VENOUS PRESSURE, CAPILLARY FILTRATION, AND OTHER FACTORS 12,\" The Journal of Clinical Investigation, vol. 17, pp. 489-499, 1938. </td>
	</tr>
	<tr>
		<td>[Whalen1974]</td>
		<td>W. Whalen, P. Nair, D. Buerk, and C. Thuning, \"Tissue PO2 in normal and denervated cat skeletal muscle,\" Am J Physiol, vol. 227, pp. 1221-1225, 1974.  </td>
	</tr>


</table>
</html>"));
      end References;

      package Interfaces "Abstract Interfaces"

        partial model IVascularElasticBloodCompartment
          extends Physiolibrary.Icons.ElasticBalloon;

        Physiolibrary.Hydraulic.Interfaces.HydraulicPort_a referencePoint
          annotation (extent=[-10,-110; 10,-90], Placement(transformation(
                extent={{-10,-110},{10,-90}}, rotation=0),
                                               iconTransformation(extent={{-10,
                  -10},{10,10}})));
          Modelica.Blocks.Interfaces.RealInput V0(
                                               final quantity="Volume", final displayUnit="ml")
          "maximal nonstressed volume"                                                                                annotation (extent = [-70,90;-50,110], rotation = -90,
          Placement(transformation(
              origin={-60,100},
              extent={{-10,-10},{10,10}},
              rotation=270)));
          Modelica.Blocks.Interfaces.RealInput ExternalPressure(
                                                            final quantity="Pressure", final displayUnit="mmHg")
          "external pressure around the compartment"                              annotation (extent = [-10,90;10,110], rotation = -90,
          Placement(transformation(
              origin={0,100},
              extent={{-10,-10},{10,10}},
              rotation=270)));
          Modelica.Blocks.Interfaces.RealInput Compliance(
                                                        final quantity="Compliance", final displayUnit="ml/mmHg")
          "elasticity of the stressed walls"                               annotation (extent = [50,90;70,110], rotation = -90,
          Placement(transformation(
              origin={60,100},
              extent={{-10,-10},{10,10}},
              rotation=270)));

          Modelica.Blocks.Interfaces.RealOutput Pressure(  final quantity="Pressure", final displayUnit="mmHg")
          "blod pressure in compartment"
            annotation (Placement(transformation(extent={{30,-110},{50,-90}}, rotation=-90)));
         // Real Vol "blood volume in compartment";

          parameter Real initialVol = 0;
          Modelica.Blocks.Interfaces.RealOutput Vol(start=initialVol, final
              quantity =                                                             "Volume", final displayUnit=
               "ml") "blood volume in compartment"
            annotation (Placement(transformation(extent={{-10,-10},{10,10}},
                rotation=270,
                origin={-40,-100})));

         // parameter Real initialVol = 0;
         annotation (
            preferredView = text,
            Documentation(info="<HTML>

</HTML>
"));
        end IVascularElasticBloodCompartment;

        model ISequesteredBlood
         extends Physiolibrary.Icons.BloodSequesteredCompartment;

        Physiolibrary.Hydraulic.Interfaces.HydraulicPort_a referencePoint
          annotation (extent=[-10,-110; 10,-90], Placement(transformation(
                extent={{-10,-110},{10,-90}}, rotation=0),
                                               iconTransformation(extent={{-10,
                  -10},{10,10}})));
          Physiolibrary.Types.RealIO.PressureInput ExternalPressure
          "external pressure around the compartment"                              annotation (extent = [-100,90;-80,110], rotation = -90,
          Placement(transformation(
              origin={-90,100},
              extent={{-10,-10},{10,10}},
              rotation=270)));

          Physiolibrary.Types.RealIO.PressureOutput Pressure
          "blod pressure in compartment"
            annotation (Placement(transformation(extent={{30,-110},{50,-90}}, rotation=-90)));
          Physiolibrary.Types.RealIO.VolumeOutput Vol
          "blood volume in compartment"
            annotation (Placement(transformation(extent={{-50,-110},{-30,-90}}, rotation=-90)));

         annotation (
            Documentation(info="<HTML>
</HTML>
"));
        end ISequesteredBlood;

      end Interfaces;

      model PulmonaryCirculation

         extends Physiolibrary.Icons.PulmonaryCirculation;

        //Can not be one port, because for example whole periferal resistance is taken as ResistorBases, but blood can accumulate inside

      Physiolibrary.Hydraulic.Interfaces.HydraulicPort_a q_in "Blood inflow"
        annotation (extent=[-10,-110; 10,-90], Placement(transformation(extent={{-10,
                -110},{10,-90}}, rotation=0),
                                        iconTransformation(extent={{-112,-10},{
                -92,10}})));
      Physiolibrary.Hydraulic.Interfaces.HydraulicPort_b q_out "Blood outflow"
        annotation (extent=[-10,-110; 10,-90], Placement(transformation(extent={{-10,
                -110},{10,-90}}, rotation=0),
                                      iconTransformation(extent={{90,-10},{110,
                10}})));

      Physiolibrary.Hydraulic.Components.ElasticVessel pulmCapys(
        stateName="PulmCapys.Vol",
        useComplianceInput=true,
        useExternalPressureInput=true,
        useV0Input=true,
        volume_start=0.000200141) "pulmonary capilaries"
        annotation (Placement(transformation(extent={{-22,-10},{-2,10}})));
      Physiolibrary.Hydraulic.Components.ElasticVessel pulmArty(
        stateName="PulmArty.Vol",
        useComplianceInput=true,
        useExternalPressureInput=true,
        useV0Input=true,
        volume_start=0.000200488)
        annotation (Placement(transformation(extent={{-86,-10},{-66,10}})));
      Physiolibrary.Hydraulic.Components.ElasticVessel pulmVeins(
        stateName="PulmVeins.Vol",
        useComplianceInput=true,
        useExternalPressureInput=true,
        useV0Input=true,
        volume_start=0.000210463) "pulmonary veins"
        annotation (Placement(transformation(extent={{38,-10},{58,10}})));
      Physiolibrary.Hydraulic.Components.Conductor pulmArtyConductance(
          Conductance=1.6876385456527e-07)
        annotation (Placement(transformation(extent={{-61,-11},{-39,11}})));
      Physiolibrary.Types.Constants.VolumeConst ArtysV0(k=0.00011)
        annotation (Placement(transformation(extent={{-94,16},{-86,24}})));
      Physiolibrary.Types.Constants.HydraulicComplianceConst ArtysCompliance(k=
            3.975326351982e-08)
        annotation (Placement(transformation(extent={{-54,16},{-62,24}})));
      Physiolibrary.Types.Constants.VolumeConst               CapysV0(k=0.00014)
        annotation (Placement(transformation(extent={{-28,16},{-20,24}})));
      Physiolibrary.Types.Constants.HydraulicComplianceConst CapysCompliance(k=
            3.450283248890036e-008)
        annotation (Placement(transformation(extent={{4,16},{-4,24}})));
      Physiolibrary.Hydraulic.Components.Conductor pulmCapysConductance(
          Conductance=2.250184727537e-07)
        annotation (Placement(transformation(extent={{2,-11},{24,11}})));
      Physiolibrary.Types.Constants.VolumeConst               VeinsV0(k=0.00015)
        annotation (Placement(transformation(extent={{30,16},{38,24}})));
      Physiolibrary.Types.Constants.HydraulicComplianceConst VeinsCompliance(k=
            4.50036945507396e-008)
        annotation (Placement(transformation(extent={{66,14},{58,22}})));
      Physiolibrary.Hydraulic.Components.Conductor pulmVeinsConductance(
          Conductance=6.7505541826109e-07)
        annotation (Placement(transformation(extent={{62,-11},{84,11}})));
      Physiolibrary.Types.BusConnector busConnector
        "signals of organ bood flow resistence" annotation (Placement(
            transformation(extent={{18,66},{38,86}}), iconTransformation(extent=
               {{-108,42},{-92,58}})));
        LungBloodFlow lungBloodFlow
          annotation (Placement(transformation(extent={{-26,74},{-6,94}})));
      Physiolibrary.Hydraulic.Sensors.FlowMeasure flowMeasure
        annotation (Placement(transformation(extent={{-42,-10},{-22,10}})));
        Modelica.Blocks.Math.Sum sum1(nin=3)
          annotation (Placement(transformation(extent={{-28,28},{-20,36}})));
        Modelica.Blocks.Math.Sum sum2(nin=2)
          annotation (Placement(transformation(extent={{50,-38},{42,-30}})));
      Physiolibrary.Hydraulic.Sensors.PressureMeasure pressureMeasure
        annotation (Placement(transformation(extent={{-8,-26},{12,-6}})));
      equation
      connect(pulmArty.q_in, pulmArtyConductance.q_in) annotation (Line(
          points={{-76,0},{-61,0}},
          color={0,0,0},
          smooth=Smooth.None,
          thickness=1));
        connect(pulmArty.externalPressure,busConnector. Thorax_AvePressure) annotation (Line(
            points={{-68,8},{-68,14},{28,14},{28,76}},
            color={0,0,127},
            smooth=Smooth.None));
        connect(pulmCapys.externalPressure,busConnector. Thorax_AvePressure) annotation (Line(
            points={{-4,8},{-4,14},{28,14},{28,76}},
            color={0,0,127},
            smooth=Smooth.None));
        connect(pulmVeins.externalPressure,busConnector. Thorax_AvePressure) annotation (Line(
            points={{56,8},{56,14},{28,14},{28,76}},
            color={0,0,127},
            smooth=Smooth.None));
      connect(pulmArty.zeroPressureVolume, ArtysV0.y) annotation (Line(
          points={{-84,8},{-84,20},{-85,20}},
          color={0,0,127},
          smooth=Smooth.None));
        connect(pulmArty.compliance, ArtysCompliance.y)
                                                annotation (Line(
            points={{-76,8},{-76,20},{-63,20}},
            color={0,0,127},
            smooth=Smooth.None));
      connect(CapysV0.y, pulmCapys.zeroPressureVolume) annotation (Line(
          points={{-19,20},{-20,20},{-20,8}},
          color={0,0,127},
          smooth=Smooth.None));
        connect(CapysCompliance.y,pulmCapys.compliance)
                                                 annotation (Line(
            points={{-5,20},{-12,20},{-12,8}},
            color={0,0,127},
            smooth=Smooth.None));
      connect(pulmCapys.q_in, pulmCapysConductance.q_in) annotation (Line(
          points={{-12,0},{2,0}},
          color={0,0,0},
          smooth=Smooth.None,
          thickness=1));
      connect(pulmCapysConductance.q_out, pulmVeins.q_in) annotation (Line(
          points={{24,0},{48,0}},
          color={0,0,0},
          smooth=Smooth.None,
          thickness=1));
      connect(pulmVeins.zeroPressureVolume, VeinsV0.y) annotation (Line(
          points={{40,8},{40,20},{39,20}},
          color={0,0,127},
          smooth=Smooth.None));
        connect(VeinsCompliance.y,pulmVeins.compliance)
                                                 annotation (Line(
            points={{57,18},{48,18},{48,8}},
            color={0,0,127},
            smooth=Smooth.None));
      connect(pulmVeins.q_in, pulmVeinsConductance.q_in) annotation (Line(
          points={{48,0},{62,0}},
          color={0,0,0},
          smooth=Smooth.None,
          thickness=1));
        connect(lungBloodFlow.AlveolarVentilated, busConnector.AlveolarVentilated_BloodFlow)
          annotation (Line(
            points={{-6,90},{28,90},{28,76}},
            color={0,0,127},
            smooth=Smooth.None), Text(
            string="%second",
            index=1,
            extent={{6,3},{6,3}}));

        connect(pulmArtyConductance.q_out, flowMeasure.q_in) annotation (Line(
            points={{-39,0},{-42,0}},
            color={0,0,0},
            thickness=1,
            smooth=Smooth.None));
      connect(flowMeasure.q_out, pulmCapys.q_in) annotation (Line(
          points={{-22,0},{-12,0}},
          color={0,0,0},
          thickness=1,
          smooth=Smooth.None));
        connect(flowMeasure.volumeFlow, lungBloodFlow.CardiacOutput)
          annotation (Line(
            points={{-32,12},{-32,90},{-26,90}},
            color={0,0,127},
            smooth=Smooth.None));
        connect(ArtysV0.y, sum1.u[1]) annotation (Line(
            points={{-85,20},{-82,20},{-82,32},{-28,32},{-28,31.4667},{-28.8,
              31.4667}},
            color={0,0,127},
            smooth=Smooth.None));

        connect(CapysV0.y, sum1.u[2]) annotation (Line(
            points={{-19,20},{-18,20},{-18,26},{-80,26},{-80,32},{-28.8,32}},
            color={0,0,127},
            smooth=Smooth.None));
        connect(VeinsV0.y, sum1.u[3]) annotation (Line(
            points={{39,20},{42,20},{42,26},{-78,26},{-78,32.5333},{-28.8,
              32.5333}},
            color={0,0,127},
            smooth=Smooth.None));
      connect(pulmCapys.volume, sum2.u[1]) annotation (Line(
          points={{-6,-10},{-6,-42},{54,-42},{54,-34.4},{50.8,-34.4}},
          color={0,0,127},
          smooth=Smooth.None));
      connect(pulmVeins.volume, sum2.u[2]) annotation (Line(
          points={{54,-10},{54,-33.6},{50.8,-33.6}},
          color={0,0,127},
          smooth=Smooth.None));
        connect(sum1.y, busConnector.PulmonaryCirculation_V0) annotation (Line(
            points={{-19.6,32},{28,32},{28,76}},
            color={0,0,127},
            smooth=Smooth.None), Text(
            string="%second",
            index=1,
            extent={{6,3},{6,3}}));
      connect(pulmArty.volume, busConnector.PulmonaryCirculation_DeoxygenatedBloodVolume)
        annotation (Line(
          points={{-70,-10},{-70,-28},{28,-28},{28,76}},
          color={0,0,127},
          smooth=Smooth.None), Text(
          string="%second",
          index=1,
          extent={{6,-16},{6,-16}}));
        connect(busConnector.PulmonaryCirculation_OxygenatedBloodVolume, sum2.y)
          annotation (Line(
            points={{28,76},{28,-34},{41.6,-34}},
            color={0,0,255},
            thickness=0.5,
            smooth=Smooth.None), Text(
            string="%first",
            index=-1,
            extent={{-6,3},{-6,3}}));
      connect(q_in, pulmArty.q_in) annotation (Line(
          points={{0,-100},{-38,-100},{-38,0},{-76,0}},
          color={0,0,0},
          thickness=1,
          smooth=Smooth.None));
        connect(pulmVeinsConductance.q_out, q_out) annotation (Line(
            points={{84,0},{42,0},{42,-100},{0,-100}},
            color={0,0,0},
            thickness=1,
            smooth=Smooth.None));
      connect(pulmCapys.q_in, pressureMeasure.q_in) annotation (Line(
          points={{-12,0},{-8,0},{-8,-22},{-2,-22}},
          color={0,0,0},
          thickness=1,
          smooth=Smooth.None));
      connect(pressureMeasure.pressure, busConnector.PulmCapys_Pressure)
        annotation (Line(
          points={{8,-20},{28,-20},{28,76}},
          color={0,0,127},
          smooth=Smooth.None), Text(
          string="%second",
          index=1,
          extent={{6,3},{6,3}}));
        annotation ( Icon(coordinateSystem(
                preserveAspectRatio=true, extent={{-100,-100},{100,100}}),
              graphics={
              Text(
                extent={{-108,-48},{106,-70}},
                lineColor={0,0,255},
                textString="%name")}),
        Documentation(revisions="<html>

<table>
<tr>
<td>Author:</td>
<td>Marek Matejak</td>
</tr>

<tr>
<td>License:</td>
<td><a href=\"http://www.physiomodel.org/license.html\">Physiomodel License 1.0</a> </td>
</tr>
<tr>
<td>By:</td>
<td>Charles University, Prague</td>
</tr>
<tr>
<td>Date of:</td>
<td>january 2009</td>
</tr>
<tr>
<td>References:</td>
<td>Tom Coleman: QHP 2008 beta 3, University of Mississippi Medical Center</td>
</tr>
</table>
<br/><p>Copyright &copy; 2014 Marek Matejak, Charles University in Prague.</p><br/>

</html>", info="<html>
<p>Blood volume (and pressures) distribution between </p>
<p><ul>
<li>pulmonary arteries, </li>
<li>pulmonary veins and </li>
<li>pulmonary capilaries.</li>
</ul></p>
<p>Blood flow through ventilated alveoli.</p>
</html>"));
      end PulmonaryCirculation;

      model SystemicCirculationFullDynamic
        extends Physiolibrary.Icons.SystemicCirculation;

      Physiolibrary.Hydraulic.Interfaces.HydraulicPort_a q_in "Blood inflow"
        annotation (extent=[-10,-110; 10,-90], Placement(transformation(extent={{-10,
                -110},{10,-90}}, rotation=0),
                                      iconTransformation(extent={{90,-10},{110,
                10}})));
      Physiolibrary.Hydraulic.Interfaces.HydraulicPort_b q_out "Blood outflow"
        annotation (extent=[-10,-110; 10,-90], Placement(transformation(extent={{-10,
                -110},{10,-90}}, rotation=0),
                                        iconTransformation(extent={{-110,-10},{
                -90,10}})));

        /*
  Library.PressureFlow.NegativePressureFlow fromSystemicVeins annotation (
      Placement(transformation(extent={{-110,-10},{-90,10}}),iconTransformation(
          extent={{-112,44},{-92,64}})));
  Library.PressureFlow.PositivePressureFlow systemicArteries
    annotation (Placement(transformation(extent={{88,-10},{108,10}}),
        iconTransformation(extent={{90,46},{110,66}})));
*/

      Physiolibrary.Hydraulic.Components.ElasticVessel systemicArtys(
        stateName="SystemicArtys.Vol",
        useV0Input=true,
        useComplianceInput=false,
        volume_start=0.00100036,
        Compliance=1.1625954425608e-08,
        useExternalPressureInput=false,
        ExternalPressure=0)
        annotation (Placement(transformation(extent={{65,-10},{86,11}})));
      Physiolibrary.Types.Constants.VolumeConst               V0_artys(k=0.00085)
        annotation (Placement(transformation(extent={{98,18},{88,28}})));
      Physiolibrary.Types.Constants.HydraulicComplianceConst
        SystemicVeinsCompliance(k=6.645545561992547e-007)
        annotation (Placement(transformation(extent={{-27,10},{-35,18}})));
      PeripheralCirculation peripheral
        annotation (Placement(transformation(extent={{-2,0},{26,28}})));
      Physiolibrary.Hydraulic.Sources.UnlimitedPump volumeCorrections(
          useSolutionFlowInput=true)
        annotation (Placement(transformation(extent={{-28,24},{-42,38}})));
      SystemicVeins veins(BaseConductance(displayUnit="ml/(mmHg.min)")=
          1.2000985213531e-07) "scaled to coronary vessels reorganisation"
        annotation (Placement(transformation(extent={{-72,-8},{-56,8}})));
        SystemicVeinsElacticBloodCompartment
          systemicVeinsElacticBloodCompartment
          annotation (Placement(transformation(extent={{-54,-10},{-34,10}})));
      Physiolibrary.Types.Constants.PressureConst SystemicVeinsExternalPressure(
          k=0)
        annotation (Placement(transformation(extent={{-36,16},{-43,23}})));
      Physiolibrary.Types.BusConnector busConnector
        "signals of organ bood flow resistence" annotation (Placement(
            transformation(extent={{36,40},{56,60}}), iconTransformation(extent=
               {{-110,32},{-94,48}})));
      CollapsingVeins collapsedVeins annotation (Placement(transformation(
            extent={{10,10.5},{-10,-10.5}},
            rotation=180,
            origin={-84.5,0})));
      Physiolibrary.Hydraulic.Components.HydrostaticColumn
        gravityHydrostaticDifference(useExternalG=true, useHeightInput=true)
        annotation (Placement(transformation(
            extent={{-10,-10},{10,10}},
            origin={61,35})));
      Physiolibrary.Hydraulic.Sensors.PressureMeasure pressureMeasure
        annotation (Placement(transformation(
            extent={{8.5,-8.5},{-8.5,8.5}},
            origin={78.5,45.5})));
        Modelica.Blocks.Math.Gain G(k=9.81) annotation (Placement(transformation(
              extent={{4,-4},{-4,4}},
              rotation=90,
              origin={34,26})));
      Microcirculation.LeftHeart leftCororaryCirculation(
          BasicLargeVeselsConductance(displayUnit="ml/(mmHg.min)")=
          5.0004105056377e-09, BasicSmallVeselsConductance(displayUnit=
              "ml/(mmHg.min)") = 3.1252565660236e-10)
        "scaled to normal pressure gradient 94 mmHg"
        annotation (Placement(transformation(extent={{-10,76},{10,96}})));
      Microcirculation.RightHeart rightCororaryCirculation(
          BasicLargeVeselsConductance(displayUnit="ml/(mmHg.min)")=
          1.2501026264094e-09, BasicSmallVeselsConductance(displayUnit=
              "ml/(mmHg.min)") = 6.2505131320471e-11)
        "scaled to normal pressure gradient 94 mmHg"
        annotation (Placement(transformation(extent={{-42,62},{-22,82}})));
      SplanchnicCirculation splanchnicCirculation
        annotation (Placement(transformation(extent={{-6,-44},{32,-6}})));
      Physiolibrary.Hydraulic.Components.Conductor legsArtys(Conductance=
            5.0004105056377e-09)
        annotation (Placement(transformation(extent={{80,-86},{64,-70}})));
      Physiolibrary.Types.Constants.PressureConst const8(k=0)
        annotation (Placement(transformation(extent={{93,-68},{86,-61}})));
      Physiolibrary.Hydraulic.Components.HydrostaticColumn
        hydrostaticDifference(useExternalG=true, useHeightInput=true)
        annotation (Placement(transformation(
            extent={{-10,-10},{10,10}},
            origin={54,-72})));
        SequesteredBlood sequesteredBlood(data={{0,0,10^(-10)},{50,97,1.0},{200,150,0.5}},
          pressureControledCompartment(stateName="BVSeqArtys.Vol"),
        initialVol=5.00044e-05)
          annotation (Placement(transformation(extent={{80,-88},{100,-68}})));
        SequesteredBlood sequesteredBlood1(                data={{0,-100,2.00},{150,11,
              0.11},{600,50,0.15}},
          pressureControledCompartment(stateName="BVSeqVeins.Vol"),
        initialVol=0.000120691)
          annotation (Placement(transformation(extent={{-62,-82},{-44,-64}})));
      Physiolibrary.Hydraulic.Components.Conductor legsVeins(Conductance=
            1.2501026264094e-08)
        annotation (Placement(transformation(extent={{-42,-80},{-28,-66}})));
      Physiolibrary.Hydraulic.Components.HydrostaticColumn
        hydrostaticDifference1(
        useExternalG=true,
        useHeightInput=true,
        usePumpEffect=true)
        annotation (Placement(transformation(extent={{-5,-78},{-25,-58}})));
      Physiolibrary.Types.Constants.PressureConst             const12(k=0)
        annotation (Placement(transformation(extent={{-52,-60},{-59,-53}})));
      Physiolibrary.Hydraulic.Sensors.PressureMeasure pressureMeasure1
        annotation (Placement(transformation(extent={{76,-38},{96,-18}})));
      equation
      connect(systemicArtys.zeroPressureVolume, V0_artys.y) annotation (Line(
          points={{67.1,8.9},{67.1,23},{86.75,23}},
          color={0,0,127},
          smooth=Smooth.None));
        connect(busConnector, peripheral.busConnector)          annotation (
            Line(
            points={{46,50},{46,16.66},{21.66,16.66}},
            color={0,0,255},
            thickness=0.5,
            smooth=Smooth.None));
        connect(veins.busConnector,busConnector)           annotation (
           Line(
            points={{-58.48,1.52},{-60,1.52},{-60,50},{46,50}},
            color={0,0,255},
            thickness=0.5,
            smooth=Smooth.None));
        connect(SystemicVeinsCompliance.y, systemicVeinsElacticBloodCompartment.Compliance)
          annotation (Line(
            points={{-36,14},{-38.2,14},{-38.2,10},{-38,10}},
            color={0,0,127},
            smooth=Smooth.None));
        connect(busConnector,systemicVeinsElacticBloodCompartment. busConnector)
          annotation (Line(
            points={{46,50},{-26,50},{-26,6.1},{-34.2,6.1}},
            color={0,0,255},
            thickness=0.5,
            smooth=Smooth.None));
        connect(systemicVeinsElacticBloodCompartment.referencePoint,volumeCorrections. q_out)
          annotation (Line(
            points={{-44,0},{-46,0},{-46,31},{-42,31}},
            color={0,0,0},
            smooth=Smooth.None,
            thickness=1));
        connect(systemicVeinsElacticBloodCompartment.ExternalPressure,
          SystemicVeinsExternalPressure.y)
          annotation (Line(
            points={{-44,10},{-44,19.5},{-43.875,19.5}},
            color={0,0,127},
            smooth=Smooth.None));
      connect(busConnector.BloodVolume_change, volumeCorrections.solutionFlow)
        annotation (Line(
          points={{46,50},{-35,50},{-35,35.9}},
          color={0,0,255},
          thickness=0.5,
          smooth=Smooth.None));
        connect(collapsedVeins.ExternalPressure, busConnector.Thorax_AvePressure)
          annotation (Line(
            points={{-78.5,2.1},{-80,2.1},{-80,50},{46,50}},
            color={0,0,127},
            smooth=Smooth.None));
      connect(pressureMeasure.pressure, busConnector.CarotidSinus_Pressure)
        annotation (Line(
          points={{73.4,42.1},{46,42.1},{46,50}},
          color={0,0,127},
          smooth=Smooth.None));
        connect(gravityHydrostaticDifference.height, busConnector.CarotidSinusHeight)
          annotation (Line(
            points={{55,35},{46,35},{46,50}},
            color={0,0,127},
            smooth=Smooth.None));
      connect(gravityHydrostaticDifference.q_down, systemicArtys.q_in)
        annotation (Line(
          points={{69,29},{69,0.5},{75.5,0.5}},
          color={0,0,0},
          thickness=1,
          smooth=Smooth.None));

        connect(gravityHydrostaticDifference.q_up, pressureMeasure.q_in)
          annotation (Line(
            points={{69,39},{80,39},{80,40.4},{81.9,40.4}},
            color={0,0,0},
            thickness=1,
            smooth=Smooth.None));
      connect(pressureMeasure.pressure, busConnector.CarotidSinusArteryPressure)
        annotation (Line(
          points={{73.4,42.1},{46,42.1},{46,50}},
          color={0,0,127},
          smooth=Smooth.None));
        connect(systemicVeinsElacticBloodCompartment.Pressure, busConnector.SystemicVeins_Pressure)
          annotation (Line(
            points={{-40,-10},{-40,-28},{46,-28},{46,50}},
            color={0,0,127},
            smooth=Smooth.None), Text(
            string="%second",
            index=1,
            extent={{6,3},{6,3}}));
        connect(systemicVeinsElacticBloodCompartment.V0, busConnector.SystemicVeins_V0)
          annotation (Line(
            points={{-50.8,10},{-50.8,50},{46,50}},
            color={0,0,127},
            smooth=Smooth.None));
        connect(V0_artys.y, busConnector.SystemicArtys_V0) annotation (Line(
            points={{86.75,23},{70,23},{70,22},{46,22},{46,50}},
            color={0,0,127},
            smooth=Smooth.None));
      connect(q_in, systemicArtys.q_in) annotation (Line(
          points={{100,0},{99.75,0},{99.75,0.5},{75.5,0.5}},
          color={0,0,0},
          thickness=1,
          smooth=Smooth.None));
        connect(collapsedVeins.q_out, q_out) annotation (Line(
            points={{-94.5,-1.22465e-015},{-96.25,-1.22465e-015},{-96.25,0},{
              -100,0}},
            color={0,0,0},
            thickness=1,
            smooth=Smooth.None));
        connect(busConnector.Gravity_Gz, G.u) annotation (Line(
            points={{46,50},{46,38},{34,38},{34,30.8}},
            color={0,0,255},
            thickness=0.5,
            smooth=Smooth.None), Text(
            string="%first",
            index=-1,
            extent={{-6,3},{-6,3}}));
        connect(G.y, gravityHydrostaticDifference.G) annotation (Line(
            points={{34,21.6},{34,16},{61,16},{61,25}},
            color={0,0,127},
            smooth=Smooth.None));
        connect(rightCororaryCirculation.busConnector, busConnector)
                                                                annotation (
            Line(
            points={{-25.1,73.9},{46,73.9},{46,50}},
            color={0,0,255},
            thickness=0.5,
            smooth=Smooth.None));
        connect(leftCororaryCirculation.busConnector, busConnector)
                                                               annotation (Line(
            points={{6.9,87.9},{46,87.9},{46,50}},
            color={0,0,255},
            thickness=0.5,
            smooth=Smooth.None));
        connect(leftCororaryCirculation.BloodFlow, busConnector.leftHeart_BloodFlow)
          annotation (Line(
            points={{7,81},{46,81},{46,50}},
            color={0,0,127},
            smooth=Smooth.None));
        connect(rightCororaryCirculation.BloodFlow, busConnector.rightHeart_BloodFlow)
          annotation (Line(
            points={{-25,67},{22,67},{22,50},{46,50}},
            color={0,0,127},
            smooth=Smooth.None));
        connect(leftCororaryCirculation.BloodFlow, busConnector.LeftHeart_BloodFlow)
          annotation (Line(
            points={{7,81},{46,81},{46,50}},
            color={0,0,127},
            smooth=Smooth.None), Text(
            string="%second",
            index=1,
            extent={{6,3},{6,3}}));
        connect(rightCororaryCirculation.BloodFlow, busConnector.RightHeart_BloodFlow)
          annotation (Line(
            points={{-25,67},{22,67},{22,50},{46,50}},
            color={0,0,127},
            smooth=Smooth.None));
        connect(splanchnicCirculation.busConnector, busConnector) annotation (
            Line(
            points={{-6,-15.5},{-6,50},{46,50}},
            color={0,0,255},
            thickness=0.5,
            smooth=Smooth.None));
      connect(splanchnicCirculation.q_in, systemicArtys.q_in) annotation (Line(
          points={{32,-25},{62,-25},{62,0.5},{75.5,0.5}},
          color={0,0,0},
          thickness=1,
          smooth=Smooth.None));
      connect(peripheral.q_in, systemicArtys.q_in) annotation (Line(
          points={{26,14},{52,14},{52,0.5},{75.5,0.5}},
          color={0,0,0},
          thickness=1,
          smooth=Smooth.None));
        connect(peripheral.q_out, systemicVeinsElacticBloodCompartment.referencePoint)
          annotation (Line(
            points={{-2,14},{-24,14},{-24,0},{-44,0}},
            color={0,0,0},
            thickness=1,
            smooth=Smooth.None));
        connect(rightCororaryCirculation.q_out, q_out) annotation (Line(
            points={{-42,72},{-60,72},{-60,86},{-100,86},{-100,0}},
            color={0,0,0},
            thickness=1,
            smooth=Smooth.None));
        connect(leftCororaryCirculation.q_out, q_out) annotation (Line(
            points={{-10,86},{-100,86},{-100,0}},
            color={0,0,0},
            thickness=1,
            smooth=Smooth.None));
        connect(leftCororaryCirculation.q_in, q_in) annotation (Line(
            points={{10,86},{100,86},{100,0}},
            color={0,0,0},
            thickness=1,
            smooth=Smooth.None));
        connect(systemicVeinsElacticBloodCompartment.referencePoint, veins.q_in)
          annotation (Line(
            points={{-44,0},{-56,0}},
            color={0,0,0},
            thickness=1,
            smooth=Smooth.None));
        connect(veins.q_out, collapsedVeins.q_in) annotation (Line(
            points={{-72,0},{-73.25,0},{-73.25,1.22465e-015},{-74.5,
              1.22465e-015}},
            color={0,0,0},
            thickness=1,
            smooth=Smooth.None));

        connect(rightCororaryCirculation.q_in, q_in) annotation (Line(
            points={{-22,72},{36,72},{36,86},{100,86},{100,0}},
            color={0,0,0},
            thickness=1,
            smooth=Smooth.None));
        connect(legsArtys.q_in,sequesteredBlood. referencePoint) annotation (Line(
            points={{80,-78},{90,-78}},
            color={0,0,0},
            thickness=1,
            smooth=Smooth.None));
        connect(sequesteredBlood.ExternalPressure,const8. y) annotation (Line(
            points={{81,-68},{81,-64.5},{85.125,-64.5}},
            color={0,0,127},
            smooth=Smooth.None));
        connect(legsArtys.q_out,hydrostaticDifference. q_down) annotation (Line(
            points={{64,-78},{62,-78}},
            color={0,0,0},
            thickness=1,
            smooth=Smooth.None));
      connect(hydrostaticDifference.q_up, systemicArtys.q_in) annotation (Line(
          points={{62,-68},{62,0},{75.5,0},{75.5,0.5}},
          color={0,0,0},
          thickness=1,
          smooth=Smooth.None));
        connect(sequesteredBlood1.ExternalPressure,const12. y) annotation (Line(
            points={{-61.1,-64},{-61.1,-56.5},{-59.875,-56.5}},
            color={0,0,127},
            smooth=Smooth.None));
        connect(sequesteredBlood1.referencePoint,legsVeins. q_in) annotation (
            Line(
            points={{-53,-73},{-42,-73}},
            color={0,0,0},
            thickness=1,
            smooth=Smooth.None));
        connect(legsVeins.q_out,hydrostaticDifference1. q_down) annotation (
            Line(
            points={{-28,-73},{-28,-74},{-23,-74}},
            color={0,0,0},
            thickness=1,
            smooth=Smooth.None));
        connect(hydrostaticDifference1.q_up,
          systemicVeinsElacticBloodCompartment.referencePoint) annotation (Line(
            points={{-23,-64},{-23,0},{-44,0}},
            color={0,0,0},
            thickness=1,
            smooth=Smooth.None));
        connect(hydrostaticDifference1.height, busConnector.LowerTorsoVeinHeight)
          annotation (Line(
            points={{-9,-68},{46,-68},{46,50}},
            color={0,0,127},
            smooth=Smooth.None), Text(
            string="%second",
            index=1,
            extent={{6,3},{6,3}}));
        connect(hydrostaticDifference1.pumpEffect, busConnector.Exercise_MusclePump_Effect)
          annotation (Line(
            points={{-15,-58},{46,-58},{46,50}},
            color={0,0,127},
            smooth=Smooth.None), Text(
            string="%second",
            index=1,
            extent={{6,3},{6,3}}));
        connect(hydrostaticDifference.height, busConnector.LowerTorsoArtyHeight)
          annotation (Line(
            points={{48,-72},{46,-72},{46,50}},
            color={0,0,127},
            smooth=Smooth.None));
        connect(sequesteredBlood1.Vol, busConnector.LegVeins_DeoxygenatedBloodVolume)
          annotation (Line(
            points={{-56.6,-82},{-58,-82},{-58,-90},{46,-90},{46,50}},
            color={0,0,127},
            smooth=Smooth.None));
        connect(sequesteredBlood.Vol, busConnector.LegArtys_OxygenatedBloodVolume)
          annotation (Line(
            points={{86,-88},{86,-90},{46,-90},{46,50}},
            color={0,0,127},
            smooth=Smooth.None));
        connect(G.y,hydrostaticDifference1. G) annotation (Line(
            points={{34,21.6},{34,-90},{-15,-90},{-15,-78}},
            color={0,0,127},
            smooth=Smooth.None));
        connect(G.y,hydrostaticDifference. G) annotation (Line(
            points={{34,21.6},{34,-90},{54,-90},{54,-82}},
            color={0,0,127},
            smooth=Smooth.None));
      connect(systemicArtys.volume, busConnector.SystemicArtys_OxygenatedBloodVolume)
        annotation (Line(
          points={{81.8,-10},{72,-10},{72,-28},{46,-28},{46,50}},
          color={0,0,127},
          smooth=Smooth.None), Text(
          string="%second",
          index=1,
          extent={{6,3},{6,3}}));
      connect(systemicVeinsElacticBloodCompartment.Vol, busConnector.SystemicVeins_DeoxygenatedBloodVolume)
        annotation (Line(
          points={{-48,-10},{-48,-28},{46,-28},{46,50}},
          color={0,0,127},
          smooth=Smooth.None), Text(
          string="%second",
          index=1,
          extent={{6,3},{6,3}}));
      connect(systemicArtys.q_in, pressureMeasure1.q_in) annotation (Line(
          points={{75.5,0.5},{82,0.5},{82,-34}},
          color={0,0,0},
          thickness=1,
          smooth=Smooth.None));
      connect(pressureMeasure1.pressure, busConnector.SystemicArtys_Pressure)
        annotation (Line(
          points={{92,-32},{98,-32},{98,-42},{46,-42},{46,50}},
          color={0,0,127},
          smooth=Smooth.None), Text(
          string="%second",
          index=1,
          extent={{6,3},{6,3}}));
      connect(splanchnicCirculation.q_out, veins.q_out) annotation (Line(
          points={{-6,-25},{-72,-25},{-72,0}},
          color={0,0,0},
          thickness=1,
          smooth=Smooth.None));
       annotation (Diagram(coordinateSystem(preserveAspectRatio=false,extent={{-100,
                -100},{100,100}}),   graphics={Text(
                extent={{42,46},{74,46}},
                lineColor={0,0,255},
                textString="Carotid Artery Pressure")}),
                                       Icon(coordinateSystem(
                preserveAspectRatio=true, extent={{-100,-100},{100,100}}),
              graphics={
              Text(
                extent={{-104,-54},{110,-76}},
                lineColor={0,0,255},
                textString="%name")}),
        Documentation(revisions="<html>

<table>
<tr>
<td>Author:</td>
<td>Marek Matejak</td>
</tr>
<tr>
<td>License:</td>
<td><a href=\"http://www.physiomodel.org/license.html\">Physiomodel License 1.0</a> </td>
</tr>
<tr>
<td>By:</td>
<td>Charles University, Prague</td>
</tr>
<tr>
<td>Date of:</td>
<td>january 2009</td>
</tr>
<tr>
<td>References:</td>
<td>Tom Coleman: QHP 2008 beta 3, University of Mississippi Medical Center</td>
</tr>
</table>
<br/><p>Copyright &copy; 2014 Marek Matejak, Charles University in Prague.</p><br/>

</html>", info="<html>
<p>Blood volume (and pressure) distributions between </p>
<p><ul>
<li>systemic arteries, </li>
<li>systemic veins and</li>
<li>portal (splanchnic) vein.</li>
</ul></p>
<p>Blood flow throught: </p>
<p><ul>
<li>GIT, hepatic artery, liver</li>
<li>Kidney</li>
<li>CNS</li>
<li>Skeletal muscle</li>
<li>Respiratory muscle</li>
<li>Skin</li>
<li>Bones</li>
<li>Adipose tissue</li>
<li>Other tissue</li>
</ul></p>
</html>"));
      end SystemicCirculationFullDynamic;

      model PeripheralCirculation
        import QHP = Physiomodel;
        extends Physiomodel.CardioVascular.Microcirculation.Interfaces.BaseDO;
        extends Physiolibrary.Icons.PeripheralCirculation;

        QHP.CardioVascular.Microcirculation.TissueBloodFlow
                                                         bone(Cond=
            4.536109889163e-10)
          annotation (Placement(transformation(extent={{-38,62},{-12,88}})));
        QHP.CardioVascular.Microcirculation.TissueBloodFlow
                                                          brain(
        onAnesthesia=false,
        onAngiotensinII=false,
        onVasopressin=false,
        onCatecholamines=false,
        onOxygenAndCarbonDioxide=true,
          VasculatureConductanceOnPO2={{27,1.2,0},{37,1.0,-0.03},{47,0.8,0}},
          onOxygenOnly=false,
        Cond=1.1375933900326e-09)
          annotation (Placement(transformation(extent={{12,44},{38,70}})));
        QHP.CardioVascular.Microcirculation.TissueBloodFlow
                                                        fat(Cond=
            3.3752770913055e-10)
          annotation (Placement(transformation(extent={{-38,26},{-12,52}})));
        Physiomodel.CardioVascular.Microcirculation.Kidney kidney
          annotation (Placement(transformation(extent={{18,8},{44,34}})));
        Physiomodel.CardioVascular.Microcirculation.Skin skin
          annotation (Placement(transformation(extent={{22,-34},{46,-10}})));
        QHP.CardioVascular.Microcirculation.TissueBloodFlow     otherTissue(Cond=
            5.2504310309196e-10)
          annotation (Placement(transformation(extent={{-36,-98},{-10,-72}})));
        QHP.CardioVascular.Microcirculation.TissueBloodFlow        skeletalMuscle(
        Cond=9.0007389101479e-10,
        onOxygenNeed=true,
        onExercise=true)
          annotation (Placement(transformation(extent={{-34,-54},{-8,-28}})));
        QHP.CardioVascular.Microcirculation.TissueBloodFlow
          respiratoryMuscle(Cond=1.3751128890504e-10, onOxygenNeed=true)
          annotation (Placement(transformation(extent={{20,-78},{46,-52}})));
      Physiolibrary.Types.BusConnector busConnector
        "signals of organ bood flow resistence" annotation (Placement(
            transformation(extent={{-100,80},{-80,100}}), iconTransformation(
              extent={{60,10},{78,28}})));
      equation

        connect(bone.q_in, flowMeasure.q_out) annotation (Line(
            points={{-12,75},{68,75},{68,0},{78,0}},
            color={0,0,0},
            smooth=Smooth.None,
            thickness=1));
        connect(brain.q_in, flowMeasure.q_out) annotation (Line(
            points={{38,57},{68,57},{68,0},{78,0}},
            color={0,0,0},
            smooth=Smooth.None,
            thickness=1));
        connect(fat.q_in, flowMeasure.q_out) annotation (Line(
            points={{-12,39},{68,39},{68,0},{78,0}},
            color={0,0,0},
            smooth=Smooth.None,
            thickness=1));
        connect(skin.q_in, flowMeasure.q_out) annotation (Line(
            points={{46,-22},{68,-22},{68,0},{78,0}},
            color={0,0,0},
            smooth=Smooth.None,
            thickness=1));
        connect(otherTissue.q_in, flowMeasure.q_out)  annotation (Line(
            points={{-10,-85},{68,-85},{68,0},{78,0}},
            color={0,0,0},
            smooth=Smooth.None,
            thickness=1));
        connect(skeletalMuscle.q_in, flowMeasure.q_out)  annotation (Line(
            points={{-8,-41},{68,-41},{68,0},{78,0}},
            color={0,0,0},
            smooth=Smooth.None,
            thickness=1));
        connect(respiratoryMuscle.q_in, flowMeasure.q_out) annotation (Line(
            points={{46,-65},{68,-65},{68,0},{78,0}},
            color={0,0,0},
            smooth=Smooth.None,
            thickness=1));
        connect(respiratoryMuscle.q_out,q_out) annotation (Line(
            points={{20,-65},{-84,-65},{-84,0},{-100,0}},
            color={0,0,0},
            smooth=Smooth.None,
            thickness=1));
        connect(skeletalMuscle.q_out,q_out)  annotation (Line(
            points={{-34,-41},{-84,-41},{-84,0},{-100,0}},
            color={0,0,0},
            smooth=Smooth.None,
            thickness=1));
        connect(otherTissue.q_out,q_out)  annotation (Line(
            points={{-36,-85},{-84,-85},{-84,0},{-100,0}},
            color={0,0,0},
            smooth=Smooth.None,
            thickness=1));
        connect(skin.q_out,q_out) annotation (Line(
            points={{22,-22},{-84,-22},{-84,0},{-100,0}},
            color={0,0,0},
            smooth=Smooth.None,
            thickness=1));
        connect(fat.q_out,q_out) annotation (Line(
            points={{-38,39},{-84,39},{-84,0},{-100,0}},
            color={0,0,0},
            smooth=Smooth.None,
            thickness=1));
        connect(brain.q_out,q_out) annotation (Line(
            points={{12,57},{-84,57},{-84,0},{-100,0}},
            color={0,0,0},
            smooth=Smooth.None,
            thickness=1));
        connect(bone.q_out,q_out) annotation (Line(
            points={{-38,75},{-84,75},{-84,0},{-100,0}},
            color={0,0,0},
            smooth=Smooth.None,
            thickness=1));
        connect(busConnector, otherTissue.busConnector)  annotation (Line(
            points={{-90,90},{52,90},{52,-77.2},{-12.6,-77.2}},
            color={0,0,255},
            thickness=0.5,
            smooth=Smooth.None));
        connect(busConnector, skin.busConnector) annotation (Line(
            points={{-90,90},{52,90},{52,-19.72},{42.28,-19.72}},
            color={0,0,255},
            thickness=0.5,
            smooth=Smooth.None));
        connect(busConnector, kidney.busConnector) annotation (Line(
            points={{-90,90},{52,90},{52,23.47},{39.97,23.47}},
            color={0,0,255},
            thickness=0.5,
            smooth=Smooth.None));
        connect(busConnector, fat.busConnector) annotation (Line(
            points={{-90,90},{52,90},{52,46.8},{-14.6,46.8}},
            color={0,0,255},
            thickness=0.5,
            smooth=Smooth.None));
        connect(busConnector, brain.busConnector) annotation (Line(
            points={{-90,90},{52,90},{52,64.8},{35.4,64.8}},
            color={0,0,255},
            thickness=0.5,
            smooth=Smooth.None));
        connect(busConnector, bone.busConnector) annotation (Line(
            points={{-90,90},{52,90},{52,82.8},{-14.6,82.8}},
            color={0,0,255},
            thickness=0.5,
            smooth=Smooth.None));
        connect(busConnector, skeletalMuscle.busConnector)  annotation (Line(
            points={{-90,90},{-48,90},{-48,-33.2},{-10.6,-33.2}},
            color={0,0,255},
            thickness=0.5,
            smooth=Smooth.None));
        connect(busConnector, respiratoryMuscle.busConnector) annotation (
            Line(
            points={{-90,90},{52,90},{52,-57.2},{43.4,-57.2}},
            color={0,0,255},
            thickness=0.5,
            smooth=Smooth.None));
        connect(bone.BloodFlow, busConnector.bone_BloodFlow)
          annotation (Line(
            points={{-15.9,68.5},{52,68.5},{52,90},{-90,90}},
            color={0,0,127},
            smooth=Smooth.None));
        connect(brain.BloodFlow, busConnector.brain_BloodFlow)
          annotation (Line(
            points={{34.1,50.5},{52,50.5},{52,90},{-90,90}},
            color={0,0,127},
            smooth=Smooth.None));
        connect(fat.BloodFlow, busConnector.fat_BloodFlow) annotation (
           Line(
            points={{-15.9,32.5},{52,32.5},{52,90},{-90,90}},
            color={0,0,127},
            smooth=Smooth.None));
        connect(kidney.BloodFlow, busConnector.kidney_BloodFlow)
          annotation (Line(
            points={{40.1,14.5},{52,14.5},{52,90},{-90,90}},
            color={0,0,127},
            smooth=Smooth.None));
        connect(skin.BloodFlow, busConnector.skin_BloodFlow)
          annotation (Line(
            points={{42.4,-28},{52,-28},{52,90},{-90,90}},
            color={0,0,127},
            smooth=Smooth.None));
        connect(skeletalMuscle.BloodFlow, busConnector.skeletalMuscle_BloodFlow)
          annotation (Line(
            points={{-11.9,-47.5},{52,-47.5},{52,90},{-90,90}},
            color={0,0,127},
            smooth=Smooth.None));
        connect(respiratoryMuscle.BloodFlow, busConnector.respiratoryMuscle_BloodFlow)
          annotation (Line(
            points={{42.1,-71.5},{52,-71.5},{52,90},{-90,90}},
            color={0,0,127},
            smooth=Smooth.None));
        connect(otherTissue.BloodFlow, busConnector.otherTissue_BloodFlow)
          annotation (Line(
            points={{-13.9,-91.5},{52,-91.5},{52,90},{-90,90}},
            color={0,0,127},
            smooth=Smooth.None));

          connect(bone.BloodFlow, busConnector.Bone_BloodFlow)
          annotation (Line(
            points={{-15.9,68.5},{52,68.5},{52,90},{-90,90}},
            color={0,0,127},
            smooth=Smooth.None));
        connect(brain.BloodFlow, busConnector.Brain_BloodFlow)
          annotation (Line(
            points={{34.1,50.5},{52,50.5},{52,90},{-90,90}},
            color={0,0,127},
            smooth=Smooth.None));
        connect(fat.BloodFlow, busConnector.Fat_BloodFlow) annotation (
           Line(
            points={{-15.9,32.5},{52,32.5},{52,90},{-90,90}},
            color={0,0,127},
            smooth=Smooth.None));
        connect(kidney.BloodFlow, busConnector.Kidney_BloodFlow)
          annotation (Line(
            points={{40.1,14.5},{52,14.5},{52,90},{-90,90}},
            color={0,0,127},
            smooth=Smooth.None));
        connect(skin.BloodFlow, busConnector.Skin_BloodFlow)
          annotation (Line(
            points={{42.4,-28},{52,-28},{52,90},{-90,90}},
            color={0,0,127},
            smooth=Smooth.None));
        connect(skeletalMuscle.BloodFlow, busConnector.SkeletalMuscle_BloodFlow)
          annotation (Line(
            points={{-11.9,-47.5},{52,-47.5},{52,90},{-90,90}},
            color={0,0,127},
            smooth=Smooth.None));
        connect(respiratoryMuscle.BloodFlow, busConnector.RespiratoryMuscle_BloodFlow)
          annotation (Line(
            points={{42.1,-71.5},{52,-71.5},{52,90},{-90,90}},
            color={0,0,127},
            smooth=Smooth.None));
        connect(otherTissue.BloodFlow, busConnector.OtherTissue_BloodFlow)
          annotation (Line(
            points={{-13.9,-91.5},{52,-91.5},{52,90},{-90,90}},
            color={0,0,127},
            smooth=Smooth.None));

        connect(kidney.q_out,q_out) annotation (Line(
            points={{18,21},{-84,21},{-84,0},{-100,0}},
            color={0,0,0},
            thickness=1,
            smooth=Smooth.None));
        connect(kidney.q_in, flowMeasure.q_out) annotation (Line(
            points={{44,21},{68,21},{68,0},{78,0}},
            color={0,0,0},
            smooth=Smooth.None,
            thickness=1));

      connect(bone.tissueConnector, busConnector.bone) annotation (Line(
          points={{-25,85.4},{-24.5,85.4},{-24.5,90},{-90,90}},
          color={127,0,0},
          thickness=0.5,
          smooth=Smooth.None));
      connect(fat.tissueConnector, busConnector.fat) annotation (Line(
          points={{-25,49.4},{-48,49.4},{-48,90},{-90,90}},
          color={127,0,0},
          thickness=0.5,
          smooth=Smooth.None));
      connect(skeletalMuscle.tissueConnector, busConnector.skeletalMuscle)
        annotation (Line(
          points={{-21,-30.6},{-48,-30.6},{-48,90},{-90,90}},
          color={127,0,0},
          thickness=0.5,
          smooth=Smooth.None));
      connect(otherTissue.tissueConnector, busConnector.otherTissue)
        annotation (Line(
          points={{-23,-74.6},{-48,-74.6},{-48,90},{-90,90}},
          color={127,0,0},
          thickness=0.5,
          smooth=Smooth.None));
      connect(brain.tissueConnector, busConnector.brain) annotation (Line(
          points={{25,67.4},{25,90},{-90,90}},
          color={127,0,0},
          thickness=0.5,
          smooth=Smooth.None));
      connect(respiratoryMuscle.tissueConnector, busConnector.respiratoryMuscle)
        annotation (Line(
          points={{33,-54.6},{34,-54.6},{34,-54},{52,-54},{52,90},{-90,90}},
          color={127,0,0},
          thickness=0.5,
          smooth=Smooth.None));
        annotation (
          Documentation(info="<HTML>
<PRE>
Blood resistance in peripheral organs except hepatic artery, gastro interstitional tract, vena porte, liver and liver veins.
</PRE>
</HTML>
",     revisions="<html>
<ul>
<li><i>  </i>
       </li>
<li><i> january 2009 </i><br>
       by Marek Matejak in Modelica initially implemented (consulted with Jiri Kofranek), Charles University, Prague<br>
       orginaly described by Tom Coleman in QHP 2008 beta 3, University of Mississippi Medical Center
       </li>
</ul>
</html>"), Icon(graphics={Text(
                extent={{-100,-128},{100,-100}},
                lineColor={0,0,255},
                textString="%name")}));
      end PeripheralCirculation;

      model SplanchnicCirculation
        extends Physiolibrary.Icons.PerfusionDO;
        extends Physiolibrary.Icons.GITract;

      Physiolibrary.Hydraulic.Interfaces.HydraulicPort_a q_in "Blood inflow"
        annotation (extent=[-10,-110; 10,-90], Placement(transformation(extent={{-10,
                -110},{10,-90}}, rotation=0),
                                      iconTransformation(extent={{90,-10},{110,
                10}})));
      Physiolibrary.Hydraulic.Interfaces.HydraulicPort_b q_out "Blood outflow"
        annotation (extent=[-10,-110; 10,-90], Placement(transformation(extent={{-10,
                -110},{10,-90}}, rotation=0),
                                        iconTransformation(extent={{-110,-10},{
                -90,10}})));

      Physiolibrary.Types.BusConnector busConnector
        "signals of organ bood flow resistence" annotation (Placement(
            transformation(extent={{56,-56},{76,-36}}), iconTransformation(
              extent={{-108,42},{-92,58}})));

      Physiolibrary.Hydraulic.Components.ElasticVessel portalVein(
        stateName="SplanchnicVeins.Vol",
        useExternalPressureInput=true,
        useV0Input=true,
        useComplianceInput=false,
        volume_start=0.00100999,
        Compliance=4.6878848490354e-07)
        annotation (Placement(transformation(extent={{-16,-10},{5,11}})));
      Microcirculation.TissueBloodFlow GITract(Cond=1.4001149415786e-09)
        annotation (Placement(transformation(extent={{34,-12},{58,12}})));
      Physiolibrary.Types.Constants.PressureConst ExternalPressure(k=0)
        annotation (Placement(transformation(extent={{24,20},{16,28}})));
      Physiolibrary.Types.Constants.HydraulicComplianceConst Compliance(k=
            4.6878848490354e-07)
        annotation (Placement(transformation(extent={{10,32},{2,40}})));
      Physiolibrary.Types.Constants.VolumeConst               V0(k(displayUnit=
              "ml") = 0.0005)
        annotation (Placement(transformation(extent={{-27,11},{-19,19}})));
      Microcirculation.Liver liver
        annotation (Placement(transformation(extent={{-56,34},{-32,58}})));
      Physiolibrary.Hydraulic.Sensors.PressureMeasure pressureMeasure
        annotation (Placement(transformation(extent={{6,-42},{26,-22}})));
      equation

        connect(GITract.busConnector,busConnector)           annotation (Line(
            points={{55.6,7.2},{66,7.2},{66,-46}},
            color={0,0,255},
            thickness=0.5,
            smooth=Smooth.None));
        connect(portalVein.externalPressure, ExternalPressure.y)
                                                           annotation (Line(
            points={{2.9,8.9},{2.9,24},{15,24}},
            color={0,0,127},
            smooth=Smooth.None));
      connect(portalVein.zeroPressureVolume, V0.y) annotation (Line(
          points={{-13.9,8.9},{-13.9,15},{-18,15}},
          color={0,0,127},
          smooth=Smooth.None));
        connect(GITract.BloodFlow, busConnector.GITract_BloodFlow) annotation (
            Line(
            points={{54.4,-6},{66,-6},{66,-46}},
            color={0,0,127},
            smooth=Smooth.None));
        connect(V0.y, busConnector.PortalVein_V0)      annotation (Line(
            points={{-18,15},{-14,15},{-14,-46},{66,-46}},
            color={0,0,127},
            smooth=Smooth.None), Text(
            string="%second",
            index=1,
            extent={{6,3},{6,3}}));
      connect(portalVein.volume, busConnector.SplanchnicCirculation_DeoxygenatedBloodVolume)
        annotation (Line(
          points={{0.8,-10},{0.8,-46},{66,-46}},
          color={0,0,127},
          smooth=Smooth.None));
      connect(portalVein.q_in, liver.portalVein) annotation (Line(
          points={{-5.5,0.5},{-41.36,0.5},{-41.36,40.24}},
          color={0,0,0},
          thickness=1,
          smooth=Smooth.None));
        connect(busConnector, liver.busConnector) annotation (Line(
            points={{66,-46},{66,48.28},{-35.72,48.28}},
            color={0,0,255},
            thickness=0.5,
            smooth=Smooth.None));
      connect(GITract.q_out, portalVein.q_in) annotation (Line(
          points={{34,0},{14.25,0},{14.25,0.5},{-5.5,0.5}},
          color={0,0,0},
          thickness=1,
          smooth=Smooth.None));
        connect(GITract.q_in, q_in) annotation (Line(
            points={{58,0},{100,0}},
            color={0,0,0},
            thickness=1,
            smooth=Smooth.None));
        connect(liver.q_in, q_in) annotation (Line(
            points={{-32,46},{82,46},{82,0},{100,0}},
            color={0,0,0},
            thickness=1,
            smooth=Smooth.None));
        connect(liver.q_out, q_out) annotation (Line(
            points={{-56,46},{-82,46},{-82,0},{-100,0}},
            color={0,0,0},
            thickness=1,
            smooth=Smooth.None));
      connect(portalVein.q_in, pressureMeasure.q_in) annotation (Line(
          points={{-5.5,0.5},{4,0.5},{4,-38},{12,-38}},
          color={0,0,0},
          thickness=1,
          smooth=Smooth.None));
      connect(pressureMeasure.pressure, busConnector.SplanchnicVeins_Pressure)
        annotation (Line(
          points={{22,-36},{44,-36},{44,-46},{66,-46}},
          color={0,0,127},
          smooth=Smooth.None), Text(
          string="%second",
          index=1,
          extent={{6,3},{6,3}}));
      connect(GITract.tissueConnector, busConnector.GITract) annotation (
          Line(
          points={{46,9.6},{66,9.6},{66,-46}},
          color={127,0,0},
          thickness=0.5,
          smooth=Smooth.None), Text(
          string="%second",
          index=1,
          extent={{6,3},{6,3}}));
        annotation (       Icon(coordinateSystem(
                preserveAspectRatio=true, extent={{-100,-100},{100,100}}),
              graphics={
              Text(
                extent={{-104,-76},{110,-98}},
                lineColor={0,0,255},
                textString="%name")}),
        Documentation(revisions="<html>

<table>
<tr>
<td>Author:</td>
<td>Marek Matejak</td>
</tr>
<tr>
<td>License:</td>
<td><a href=\"http://www.physiomodel.org/license.html\">Physiomodel License 1.0</a> </td>
</tr>
<tr>
<td>By:</td>
<td>Charles University, Prague</td>
</tr>
<tr>
<td>Date of:</td>
<td>january 2009</td>
</tr>
<tr>
<td>References:</td>
<td>Tom Coleman: QHP 2008 beta 3, University of Mississippi Medical Center</td>
</tr>
</table>
<br/><p>Copyright &copy; 2014 Marek Matejak, Charles University in Prague.</p><br/>

</html>", info="<html>
<p>Blood volume (and pressures) distribution between </p>
<p><ul>
<li>pulmonary arteries, </li>
<li>pulmonary veins and </li>
<li>pulmonary capilaries.</li>
</ul></p>
<p>Blood flow through ventilated alveoli.</p>
</html>"));
      end SplanchnicCirculation;

      model LungBloodFlow
          extends Physiolibrary.Icons.LungShunt;
        Physiolibrary.Types.RealIO.VolumeFlowRateInput CardiacOutput
          annotation (Placement(transformation(extent={{-120,40},{-80,80}})));

        parameter Physiolibrary.Types.Fraction BasicRLShuntFraction(displayUnit="%") =  0.02
        "basic percentage of total blood flow not exposed to lung air";                                                            //
      //  parameter Real BasicRLShunt(final displayUnit="ml/min") =  110; // 220.0;
        parameter Physiolibrary.Types.Pressure RightHemithorax_Pressure( displayUnit="mmHg") =   -533.28954966;
        parameter Physiolibrary.Types.Pressure LeftHemithorax_Pressure( displayUnit="mmHg") =   -533.28954966;

        Physiolibrary.Types.Pressure PressureGradientRightLeft(displayUnit="mmHg")
        "difference between right and left hemithorax pressure";
        Physiolibrary.Types.Fraction Thorax_RightLungFlowFract(displayUnit="1")
        "fraction of blood flow to right lung";
        Physiolibrary.Types.Fraction Thorax_LeftLungFlowFract(displayUnit="1")
        "fraction of blood flow to left lung";
        Physiolibrary.Types.Fraction RightHemithorax_LungInflation(displayUnit="1")
        "dammage effect of right hemithorax inflation";
        Physiolibrary.Types.Fraction LeftHemithorax_LungInflation(displayUnit="1")
        "dammage effect of left hemithorax inflation";
        Physiolibrary.Types.VolumeFlowRate Total(displayUnit="ml/min")
        "cardiac output";

        Physiolibrary.Types.VolumeFlowRate RightLeftShunt(displayUnit="ml/min")
        "blood flow not exposed to lung air without dammage effect";
        Physiolibrary.Types.VolumeFlowRate Alveolar(displayUnit="ml/min")
        "blood flow exposed to lung air without dammage effect";

      //  Real RightLungTotal(final displayUnit="ml/min") "right lung blood flow exposed to lung air without dammage effect";
      //  Real RightLungVentilated(final displayUnit="ml/min") "right lung blood flow exposed to lung air";
      //  Real RightLungShunt(final displayUnit="ml/min");
      //  Real LeftLungTotal(final displayUnit="ml/min");
      //  Real LeftLungVentilated(final displayUnit="ml/min");
      //  Real LeftLungShunt(final displayUnit="ml/min");
      //  Real AlveolarShunt(final displayUnit="ml/min");
      //  Real TotalShunt(final displayUnit="ml/min");

        parameter Real[:,3] PressureOnInflation =   {{ -4.0,  1.0,  0}, {  4.0,  0.0,  0}};
        parameter Real[:,3] PressureGradientOnFlowDist =   {{ -25,  0.0,  0}, {   0,  0.5,  0.03}, {  25,  1.0,  0}};

        Physiolibrary.Types.RealIO.VolumeFlowRateOutput AlveolarVentilated(
                                                          final displayUnit="ml/min") annotation (Placement(transformation(extent={{80,40},{120,80}}),
              iconTransformation(extent={{80,40},{120,80}})));
      Physiolibrary.Blocks.Interpolation.Curve
        Thorax_PressureGradientOnFlowDist(
        x=PressureGradientOnFlowDist[:, 1],
        y=PressureGradientOnFlowDist[:, 2],
        slope=PressureGradientOnFlowDist[:, 3],
          Xscale=101325/760)
        annotation (Placement(transformation(extent={{-40,52},{-20,72}})));
      Physiolibrary.Blocks.Interpolation.Curve Thorax_PressureOnInflationR(
        x=PressureOnInflation[:, 1],
        y=PressureOnInflation[:, 2],
        slope=PressureOnInflation[:, 3],
          Xscale=101325/760)
        annotation (Placement(transformation(extent={{52,46},{72,66}})));
      Physiolibrary.Blocks.Interpolation.Curve Thorax_PressureOnInflationL(
        x=PressureOnInflation[:, 1],
        y=PressureOnInflation[:, 2],
        slope=PressureOnInflation[:, 3],
          Xscale=101325/760)
        annotation (Placement(transformation(extent={{-2,-24},{18,-4}})));
      equation
             PressureGradientRightLeft  =  RightHemithorax_Pressure - LeftHemithorax_Pressure;

      //division between left and rigth lung blood flow by hemithorax pressure
             Thorax_PressureGradientOnFlowDist.u = PressureGradientRightLeft;
             Thorax_LeftLungFlowFract  =  Thorax_PressureGradientOnFlowDist.val;
             Thorax_RightLungFlowFract  =  1.0 - Thorax_LeftLungFlowFract;

      //damage effect of hemithorax pressure
             Thorax_PressureOnInflationR.u = RightHemithorax_Pressure;
             RightHemithorax_LungInflation = Thorax_PressureOnInflationR.val;
             Thorax_PressureOnInflationL.u = LeftHemithorax_Pressure;
             LeftHemithorax_LungInflation = Thorax_PressureOnInflationL.val;

             Total  =  CardiacOutput;
             RightLeftShunt  = BasicRLShuntFraction*Total; //min(BasicRLShunt,Total);
             Alveolar  =  Total - RightLeftShunt;
      //       RightLungTotal  =  Alveolar * Thorax_RightLungFlowFract;
      //       RightLungVentilated  =  RightLungTotal * RightHemithorax_LungInflation;
      //       RightLungShunt  =  RightLungTotal - RightLungVentilated;
      //       LeftLungTotal  =  Alveolar * Thorax_LeftLungFlowFract;
      //       LeftLungVentilated  =  LeftLungTotal * LeftHemithorax_LungInflation;
      //       LeftLungShunt  =  LeftLungTotal - LeftLungVentilated;
      //       AlveolarVentilated  =  RightLungVentilated + LeftLungVentilated;
      //       AlveolarShunt  =  RightLungShunt + LeftLungShunt;
      //       TotalShunt  =  RightLeftShunt + AlveolarShunt;
             AlveolarVentilated  = Alveolar * ( Thorax_RightLungFlowFract * RightHemithorax_LungInflation + Thorax_LeftLungFlowFract * LeftHemithorax_LungInflation);
        annotation ( Documentation(revisions="<html>

<table>
<tr>
<td>Author:</td>
<td>Marek Matejak</td>
</tr>
<tr>
<td>License:</td>
<td><a href=\"http://www.physiomodel.org/license.html\">Physiomodel License 1.0</a> </td>
</tr>
<tr>
<td>By:</td>
<td>Charles University, Prague</td>
</tr>
<tr>
<td>Date of:</td>
<td>january 2009</td>
</tr>
<tr>
<td>References:</td>
<td>Tom Coleman: QHP 2008 beta 3, University of Mississippi Medical Center</td>
</tr>
</table>
<br/><p>Copyright &copy; 2014 Marek Matejak, Charles University in Prague.</p><br/>

</html>", info="<html>
<p>Calculation of blood flow fraction through ventilated alveoli.</p>
</html>"),Icon(coordinateSystem(preserveAspectRatio=false, extent={{-100,-100},
                  {100,100}}), graphics={                             Text(
                extent={{-102,-92},{112,-114}},
                lineColor={0,0,255},
                textString="%name")}));
      end LungBloodFlow;

      model SystemicVeinsElacticBloodCompartment
       extends Physiolibrary.Icons.ElasticBalloon;

      Physiolibrary.Hydraulic.Interfaces.HydraulicPort_a referencePoint
        annotation (extent=[-10,-110; 10,-90], Placement(transformation(extent={{-10,
                -110},{10,-90}}, rotation=0),
                                        iconTransformation(
            extent={{-10,-10},{10,10}})));
        Physiolibrary.Types.RealIO.PressureInput ExternalPressure
        "external pressure around the compartment"                              annotation (extent = [-10,90;10,110], rotation = -90,
        Placement(transformation(
            origin={0,100},
            extent={{-10,-10},{10,10}},
            rotation=270)));
        Physiolibrary.Types.RealIO.HydraulicComplianceInput Compliance( displayUnit="ml/mmHg")
        "elasticity of the stressed walls"                               annotation (extent = [50,90;70,110], rotation = -90,
        Placement(transformation(
            origin={60,100},
            extent={{-10,-10},{10,10}},
            rotation=270)));

        Physiolibrary.Types.RealIO.PressureOutput Pressure( displayUnit="mmHg")
        "blod pressure in compartment"
          annotation (Placement(transformation(extent={{30,-110},{50,-90}}, rotation=-90)));
        Physiolibrary.Types.RealIO.VolumeOutput Vol
        "blood volume in compartment"
          annotation (Placement(transformation(extent={{-50,-110},{-30,-90}}, rotation=-90),
              iconTransformation(
              extent={{-10,-10},{10,10}},
              rotation=270,
              origin={-40,-100})));
      Physiolibrary.Types.BusConnector busConnector annotation (Placement(
            transformation(extent={{-88,72},{-68,92}}), iconTransformation(
              extent={{88,51},{108,71}})));
        Physiolibrary.Hydraulic.Components.ElasticVessel systemicVeins(
          stateName="SystemicVeins.Vol",
          useComplianceInput=true,
          useExternalPressureInput=true,
          useV0Input=true,
        volume_start=initialSystemisVeinsVol) "systemic veins"
          annotation (Placement(transformation(extent={{-14,-10},{6,10}})));
      Physiolibrary.Blocks.Factors.Spline V0_A2_Effect(
        data={{0.0,1.05,0.0},{1.3,1.00,-0.10},{3.0,0.85,0.0}},
        Xscale=1e-9/Substances.AngiotensinII.mw,
        UsePositiveLog10=true)
        annotation (Placement(transformation(extent={{-30,7},{-10,27}})));
      Physiolibrary.Types.Constants.VolumeConst               const4(k=0.0017)
        annotation (Placement(transformation(extent={{-32,48},{-23,39}})));
        Physiomodel.Nerves.AplhaReceptorsActivityFactor AplhaReceptors(
          data={{0.0,1.2,0.0},{1.0,1.0,-0.30},{3.0,0.6,0.0}},
        NEURALK=0.333,
        HUMORALK=0.5)
          annotation (Placement(transformation(extent={{-30,20},{-10,40}})));
        Physiolibrary.Types.RealIO.VolumeOutput V0(displayUnit="ml")
        "maximal zero pressure blood volume in compartment"
          annotation (Placement(transformation(extent={{-4.5,-4.5},{4.5,4.5}},rotation=180,
              origin={-27.5,5.5}),
              iconTransformation(
              extent={{-10,-10},{10,10}},
              rotation=90,
              origin={-68,100})));

        parameter Physiolibrary.Types.Volume initialSystemisVeinsVol = 2329.57e-6; // = 2200;// = 2980;

        Physiolibrary.Hydraulic.Sensors.PressureMeasure pressureMeasure
          annotation (Placement(transformation(extent={{16,-20},{36,0}})));
      equation
        connect(V0_A2_Effect.y, systemicVeins.zeroPressureVolume) annotation (Line(
            points={{-20,13},{-20,12},{-12,12},{-12,8}},
            color={0,0,127},
            smooth=Smooth.None));
        connect(AplhaReceptors.y,V0_A2_Effect. yBase) annotation (Line(
            points={{-20,23},{-20,19}},
            color={0,0,127},
            smooth=Smooth.None));
        connect(AplhaReceptors.yBase,const4. y) annotation (Line(
            points={{-20,37},{-20,43.5},{-21.875,43.5}},
            color={0,0,127},
            smooth=Smooth.None));
        connect(systemicVeins.q_in, referencePoint) annotation (Line(
            points={{-4,0},{-100,0}},
            color={0,0,0},
            smooth=Smooth.None));
        connect(systemicVeins.volume, Vol) annotation (Line(
            points={{2,-10},{2,-67},{-40,-67},{-40,-100}},
            color={0,0,127},
            smooth=Smooth.None));
        connect(systemicVeins.externalPressure, ExternalPressure) annotation (Line(
            points={{4,8},{4,67},{0,67},{0,100}},
            color={0,0,127},
            smooth=Smooth.None));
        connect(systemicVeins.compliance, Compliance) annotation (Line(
            points={{-4,8},{-4,50},{60,50},{60,100}},
            color={0,0,127},
            smooth=Smooth.None));
        connect(busConnector.GangliaGeneral_NA, AplhaReceptors.GangliaGeneral_NA)
          annotation (Line(
            points={{-78,82},{-78,24},{-29.8,24}},
            color={0,0,255},
            thickness=0.5,
            smooth=Smooth.None), Text(
            string="%first",
            index=-1,
            extent={{-6,3},{-6,3}}));
        connect(busConnector.AlphaPool_Effect, AplhaReceptors.AlphaPool_Effect)
          annotation (Line(
            points={{-78,82},{-78,36},{-29.8,36}},
            color={0,0,255},
            thickness=0.5,
            smooth=Smooth.None), Text(
            string="%first",
            index=-1,
            extent={{-6,3},{-6,3}}));
        connect(busConnector.AlphaBlocade_Effect, AplhaReceptors.AlphaBlockade_Effect)
          annotation (Line(
            points={{-78,82},{-78,30},{-29.8,30}},
            color={0,0,255},
            thickness=0.5,
            smooth=Smooth.None), Text(
            string="%first",
            index=-1,
            extent={{-6,3},{-6,3}}));
        connect(V0_A2_Effect.y, V0) annotation (Line(
            points={{-20,13},{-20,5.5},{-27.5,5.5}},
            color={0,0,127},
            smooth=Smooth.None));

        connect(systemicVeins.q_in, pressureMeasure.q_in) annotation (Line(
            points={{-4,0},{10,0},{10,-16},{22,-16}},
            color={0,0,0},
            thickness=1,
            smooth=Smooth.None));
      connect(pressureMeasure.pressure, Pressure) annotation (Line(
          points={{32,-14},{40,-14},{40,-100}},
          color={0,0,127},
          smooth=Smooth.None));
      connect(busConnector.Angiotensin2, V0_A2_Effect.u) annotation (Line(
          points={{-78,82},{-78,17},{-28,17}},
          color={0,0,255},
          thickness=0.5,
          smooth=Smooth.None), Text(
          string="%first",
          index=-1,
          extent={{-6,3},{-6,3}}));
       annotation (
          Documentation(info="<HTML>
<PRE>
  Elastic blood flow compartment.

</PRE>
</HTML>
",     revisions="<html>

<table>
<tr>
<td>Author:</td>
<td>Marek Matejak</td>
</tr>

<tr>
<td>License:</td>
<td><a href=\"http://www.physiomodel.org/license.html\">Physiomodel License 1.0</a> </td>
</tr>
<tr>
<td>By:</td>
<td>Charles University, Prague</td>
</tr>
<tr>
<td>Date of:</td>
<td>january 2009</td>
</tr>
<tr>
<td>References:</td>
<td>Tom Coleman: QHP 2008 beta 3, University of Mississippi Medical Center</td>
</tr>
</table>
<br/><p>Copyright &copy; 2014 Marek Matejak, Charles University in Prague.</p><br/>

</html>"));
      end SystemicVeinsElacticBloodCompartment;

      model SequesteredBlood
       extends Interfaces.ISequesteredBlood;

      parameter Physiolibrary.Types.Volume initialVol
        "initial compartment blood volume";
       parameter Real[:,3] data;

      Physiolibrary.Blocks.Interpolation.Curve curve(
        x=data[:, 1],
        y=data[:, 2],
        slope=data[:, 3],
        Xscale=1e-6,
        Yscale=101325/760)
        annotation (Placement(transformation(extent={{-60,50},{-40,70}})));

        Modelica.Blocks.Math.Add add annotation (Placement(transformation(
              extent={{-10,-10},{10,10}},
              rotation=270,
              origin={-6,40})));
        Physiolibrary.Hydraulic.Components.ElasticVessel pressureControledCompartment(
        ZeroPressureVolume(displayUnit="l") = 0.002,
        useExternalPressureInput=true,
        volume_start=initialVol)
        annotation (Placement(transformation(extent={{-24,-10},{-4,10}})));
      equation
        connect(curve.val, add.u2) annotation (Line(
            points={{-40,60},{-12,60},{-12,52}},
            color={0,0,127},
            smooth=Smooth.None));
        connect(ExternalPressure, add.u1) annotation (Line(
            points={{-90,100},{-90,52},{1.77636e-015,52}},
            color={0,0,127},
            smooth=Smooth.None));
        connect(add.y, Pressure) annotation (Line(
            points={{-6,29},{-6,20},{40,20},{40,-100}},
            color={0,0,127},
            smooth=Smooth.None));

      connect(referencePoint, pressureControledCompartment.q_in) annotation (
          Line(
          points={{-100,0},{-18,0},{-18,2.22045e-016},{-14,2.22045e-016}},
          color={0,0,0},
          thickness=1,
          smooth=Smooth.None));
      connect(pressureControledCompartment.volume, Vol) annotation (Line(
          points={{-8,-10},{-8,-42},{-40,-42},{-40,-100}},
          color={0,0,127},
          smooth=Smooth.None));
      connect(pressureControledCompartment.volume, curve.u) annotation (Line(
          points={{-8,-10},{-8,-42},{-70,-42},{-70,60},{-60,60}},
          color={0,0,127},
          smooth=Smooth.None));
      connect(add.y, pressureControledCompartment.externalPressure) annotation (
         Line(
          points={{-6,29},{-6,8}},
          color={0,0,127},
          smooth=Smooth.None));
       annotation (
          Documentation(info="<HTML>
<PRE>
  Elastic blood flow compartment.

</PRE>
</HTML>
",     revisions="<html>

<table>
<tr>
<td>Author:</td>
<td>Marek Matejak</td>
</tr>

<tr>
<td>License:</td>
<td><a href=\"http://www.physiomodel.org/license.html\">Physiomodel License 1.0</a> </td>
</tr>
<tr>
<td>By:</td>
<td>Charles University, Prague</td>
</tr>
<tr>
<td>Date of:</td>
<td>january 2009</td>
</tr>
<tr>
<td>References:</td>
<td>Tom Coleman: QHP 2008 beta 3, University of Mississippi Medical Center</td>
</tr>
</table>
<br/><p>Copyright &copy; 2014 Marek Matejak, Charles University in Prague.</p><br/>

</html>"), Icon(coordinateSystem(preserveAspectRatio=false, extent={{-100,-100},
                  {100,100}}), graphics={Text(
                extent={{-100,-16},{100,-32}},
                lineColor={0,0,255},
                textString="(initial %initialVol ml)")}));
      end SequesteredBlood;

      model CollapsingVeins
      extends Physiolibrary.Icons.CollapsingVessel;

      Physiolibrary.Hydraulic.Interfaces.HydraulicPort_a q_in "Blood inflow"
        annotation (extent=[-10,-110; 10,-90], Placement(transformation(extent={{-10,
                -110},{10,-90}}, rotation=0),
                                      iconTransformation(extent={{90,-10},{110,
                10}})));
      Physiolibrary.Hydraulic.Interfaces.HydraulicPort_b q_out "Blood outflow"
        annotation (extent=[-10,-110; 10,-90], Placement(transformation(extent={{-10,
                -110},{10,-90}}, rotation=0),
                                        iconTransformation(extent={{-110,-10},{
                -90,10}})));

      Modelica.Blocks.Interfaces.RealInput ExternalPressure
                                                       annotation (Placement(
              transformation(extent={{40,0},{80,40}}), iconTransformation(
              extent={{-20,-20},{20,20}},
              rotation=270,
              origin={60,20})));

        parameter Real PR1LL( final quantity="Pressure", final displayUnit="mmHg") = 0
        "start-collapsing sucking pressure, when external pressure is zero";
      equation
         q_in.q + q_out.q = 0;

         q_in.pressure = if (q_out.pressure > (PR1LL+ExternalPressure)) then q_out.pressure else (PR1LL+ExternalPressure);

        annotation (Icon(graphics={
              Text(
                extent={{-62,-32},{58,-58}},
                lineColor={0,0,255},
                textString="%name")}));
      end CollapsingVeins;

      model SystemicVeins
        //extends QHP.Blood.OrganFlow.BaseBadDirection;
      extends Physiolibrary.Icons.Resistor;

      Physiolibrary.Hydraulic.Interfaces.HydraulicPort_a q_in "Blood inflow"
        annotation (extent=[-10,-110; 10,-90], Placement(transformation(extent={{-10,
                -110},{10,-90}}, rotation=0),
                                      iconTransformation(extent={{90,-10},{110,
                10}})));
      Physiolibrary.Hydraulic.Interfaces.HydraulicPort_b q_out "Blood outflow"
        annotation (extent=[-10,-110; 10,-90], Placement(transformation(extent={{-10,
                -110},{10,-90}}, rotation=0),
                                        iconTransformation(extent={{-110,-10},{
                -90,10}})));

      Physiolibrary.Hydraulic.Components.Conductor systemicVeinsConductance(
          useConductanceInput=true)
        annotation (Placement(transformation(extent={{0,-10},{-20,10}})));
      Physiolibrary.Blocks.Factors.Normalization ViscosityEffect
        annotation (Placement(transformation(extent={{-20,0},{0,20}})));
      Physiolibrary.Blocks.Factors.Normalization ExerciseEffect
        annotation (Placement(transformation(extent={{-20,7},{0,27}})));
      Physiolibrary.Blocks.Factors.Normalization CollapseEffect
        annotation (Placement(transformation(extent={{-20,14},{0,34}})));
      Physiolibrary.Types.Constants.HydraulicConductanceConst const12(k=
            BaseConductance)
        annotation (Placement(transformation(extent={{-27,45},{-15,57}})));
        parameter Physiolibrary.Types.HydraulicConductance BaseConductance( displayUnit="ml/(mmHg.min)");

      Physiolibrary.Hydraulic.Sensors.FlowMeasure flowMeasure annotation (
          Placement(transformation(
            extent={{10,-10},{-10,10}},
            origin={80,0})));
        Modelica.Blocks.Interfaces.RealOutput BloodFlow
                                                 annotation (Placement(transformation(
                extent={{76,6},{88,18}}),    iconTransformation(extent={{60,-30},{80,-10}})));
      Physiolibrary.Types.BusConnector busConnector
        "signals of organ bood flow resistence" annotation (Placement(
            transformation(extent={{-96,77},{-76,97}}), iconTransformation(
              extent={{60,10},{78,28}})));
      equation
        connect(systemicVeinsConductance.cond,ViscosityEffect. y) annotation (Line(
            points={{-10,6},{-10,6}},
            color={0,0,127},
            smooth=Smooth.None));
        connect(ViscosityEffect.yBase,ExerciseEffect. y) annotation (Line(
            points={{-10,12},{-10,13}},
            color={0,0,127},
            smooth=Smooth.None));
        connect(ExerciseEffect.yBase,CollapseEffect. y) annotation (Line(
            points={{-10,19},{-10,19.5},{-10.2,19.5},{-10.2,20},{-10,20},{-10,20}},
            color={0,0,127},
            smooth=Smooth.None));
        connect(busConnector.Viscosity_ConductanceEffect,
          ViscosityEffect.u) annotation (Line(
            points={{-86,87},{-86,10},{-18,10}},
            color={0,0,255},
            thickness=0.5,
            smooth=Smooth.None), Text(
            string="%first",
            index=-1,
            extent={{-6,3},{-6,3}}));
        connect(busConnector.Exercise_MusclePump_Effect,
          ExerciseEffect.u) annotation (Line(
            points={{-86,87},{-86,17},{-18,17}},
            color={0,0,255},
            thickness=0.5,
            smooth=Smooth.None), Text(
            string="%first",
            index=-1,
            extent={{-6,3},{-6,3}}));
        connect(busConnector.BloodVol_CollapsedEffect, CollapseEffect.u)
          annotation (Line(
            points={{-86,87},{-86,24},{-18,24}},
            color={0,0,255},
            thickness=0.5,
            smooth=Smooth.None), Text(
            string="%first",
            index=-1,
            extent={{-6,3},{-6,3}}));
        connect(const12.y, CollapseEffect.yBase) annotation (Line(
            points={{-13.5,51},{-10,51},{-10,26}},
            color={0,0,127},
            smooth=Smooth.None));
        connect(flowMeasure.volumeFlow,BloodFlow)  annotation (Line(
            points={{80,12},{80,12},{82,12}},
            color={0,0,127},
            smooth=Smooth.None));
        connect(flowMeasure.q_in, q_in) annotation (Line(
            points={{90,0},{100,0}},
            color={0,0,0},
            thickness=1,
            smooth=Smooth.None));
        connect(flowMeasure.q_out, systemicVeinsConductance.q_in) annotation (
            Line(
            points={{70,0},{0,0}},
            color={0,0,0},
            thickness=1,
            smooth=Smooth.None));
        connect(systemicVeinsConductance.q_out, q_out) annotation (Line(
            points={{-20,0},{-100,0}},
            color={0,0,0},
            thickness=1,
            smooth=Smooth.None));
        annotation ( Icon(coordinateSystem(
              preserveAspectRatio=true,
              extent={{-100,-100},{100,100}},
              grid={1,1}), graphics={Text(
                extent={{-70,-30},{70,30}},
                lineColor={0,0,0},
                textString="%BaseConductance ml/min/mmHg"), Text(
                extent={{-101,-58},{99,-30}},
                lineColor={0,0,255},
                textString="%name")}));
      end SystemicVeins;

      package develop
        extends Modelica.Icons.UnderConstruction;
        model SystemicCirculation_Simplified
          extends SystemicCirculationBase2_Simplified;
        Physiolibrary.Hydraulic.Components.Conductor legsArtys(Conductance=
              5.0004105056376e-009)
          annotation (Placement(transformation(extent={{80,-80},{64,-64}})));
        Physiolibrary.Types.Constants.DeprecatedUntypedConstant const8(k=0)
          annotation (Placement(transformation(extent={{93,-62},{86,-55}})));
        Physiolibrary.Hydraulic.Components.HydrostaticColumn
          hydrostaticDifference(useExternalG=true, useHeightInput=true)
          annotation (Placement(transformation(
              extent={{-10,-10},{10,10}},
              origin={54,-66})));
          SequesteredBlood sequesteredBlood(data={{0,0,10^(-10)},{50,97,1.0},{200,150,0.5}},
              initialVol=50.0044,
            pressureControledCompartment(stateName="BVSeqArtys.Vol"))
            annotation (Placement(transformation(extent={{80,-82},{100,-62}})));
          SequesteredBlood sequesteredBlood1(                data={{0,-100,2.00},{150,11,
                0.11},{600,50,0.15}}, initialVol=120.691,
            pressureControledCompartment(stateName="BVSeqVeins.Vol"))
            annotation (Placement(transformation(extent={{-62,-76},{-44,-58}})));
        Physiolibrary.Hydraulic.Components.Conductor legsVeins(Conductance=
              1.2501026264094e-008)
          annotation (Placement(transformation(extent={{-42,-74},{-28,-60}})));
        Physiolibrary.Hydraulic.Components.HydrostaticColumn
          hydrostaticDifference1(
          useExternalG=true,
          useHeightInput=true,
          usePumpEffect=true)
          annotation (Placement(transformation(extent={{-5,-72},{-25,-52}})));
        Physiolibrary.Types.Constants.DeprecatedUntypedConstant const12(k=0)
          annotation (Placement(transformation(extent={{-52,-54},{-59,-47}})));
        equation
          connect(legsArtys.q_in,sequesteredBlood. referencePoint) annotation (Line(
              points={{76.8,-72},{90,-72}},
              color={0,0,0},
              thickness=1,
              smooth=Smooth.None));
          connect(sequesteredBlood.ExternalPressure,const8. y) annotation (Line(
              points={{81,-62},{81,-58.5},{85.65,-58.5}},
              color={0,0,127},
              smooth=Smooth.None));
          connect(legsArtys.q_out,hydrostaticDifference. q_down) annotation (Line(
              points={{67.2,-72},{63.5,-72},{63.5,-71.6},{61,-71.6}},
              color={0,0,0},
              thickness=1,
              smooth=Smooth.None));
        connect(hydrostaticDifference.q_up, systemicArtys.q_in) annotation (Line(
            points={{61.2,-61.2},{62,-56},{62,0},{75.5,0},{75.5,0.5}},
            color={0,0,0},
            thickness=1,
            smooth=Smooth.None));
          connect(sequesteredBlood1.ExternalPressure,const12. y) annotation (Line(
              points={{-61.1,-58},{-61.1,-50.5},{-59.35,-50.5}},
              color={0,0,127},
              smooth=Smooth.None));
          connect(sequesteredBlood1.referencePoint,legsVeins. q_in) annotation (
              Line(
              points={{-53,-67},{-39.2,-67}},
              color={0,0,0},
              thickness=1,
              smooth=Smooth.None));
          connect(legsVeins.q_out,hydrostaticDifference1. q_down) annotation (
              Line(
              points={{-30.8,-67},{-30.8,-67.4},{-22,-67.4}},
              color={0,0,0},
              thickness=1,
              smooth=Smooth.None));
          connect(hydrostaticDifference1.q_up,
            systemicVeinsElacticBloodCompartment.referencePoint) annotation (Line(
              points={{-22.2,-57.2},{-22.2,0},{-44,0}},
              color={0,0,0},
              thickness=1,
              smooth=Smooth.None));
          connect(hydrostaticDifference1.height, busConnector.LowerTorsoVeinHeight)
            annotation (Line(
              points={{-8.9,-62.3},{46,-62.3},{46,50}},
              color={0,0,127},
              smooth=Smooth.None), Text(
              string="%second",
              index=1,
              extent={{6,3},{6,3}}));
          connect(hydrostaticDifference1.pumpEffect, busConnector.Exercise_MusclePump_Effect)
            annotation (Line(
              points={{-13.5,-52.5},{46,-52.5},{46,50}},
              color={0,0,127},
              smooth=Smooth.None), Text(
              string="%second",
              index=1,
              extent={{6,3},{6,3}}));
          connect(hydrostaticDifference.height, busConnector.LowerTorsoArtyHeight)
            annotation (Line(
              points={{47.9,-66.5},{46,-66.5},{46,50}},
              color={0,0,127},
              smooth=Smooth.None));
          connect(sequesteredBlood1.Vol, busConnector.LegVeins_DeoxygenatedBloodVolume)
            annotation (Line(
              points={{-56.6,-76},{-58,-76},{-58,-84},{46,-84},{46,50}},
              color={0,0,127},
              smooth=Smooth.None));
          connect(sequesteredBlood.Vol, busConnector.LegArtys_OxygenatedBloodVolume)
            annotation (Line(
              points={{86,-82},{86,-84},{46,-84},{46,50}},
              color={0,0,127},
              smooth=Smooth.None));
          connect(G.y,hydrostaticDifference1. G) annotation (Line(
              points={{34,21.6},{34,-84},{-16.5,-84},{-16.5,-70.5}},
              color={0,0,127},
              smooth=Smooth.None));
          connect(G.y,hydrostaticDifference. G) annotation (Line(
              points={{34,21.6},{34,-84},{55.5,-84},{55.5,-74.5}},
              color={0,0,127},
              smooth=Smooth.None));
        end SystemicCirculation_Simplified;

        model SystemicCirculationBase2_Simplified

          extends Physiolibrary.Icons.SystemicCirculation;

        Physiolibrary.Hydraulic.Interfaces.HydraulicPort_a q_in "Blood inflow"
          annotation (extent=[-10,-110; 10,-90], Placement(transformation(extent={{-10,
                  -110},{10,-90}}, rotation=0),
                                        iconTransformation(extent={{90,-10},{110,
                  10}})));
        Physiolibrary.Hydraulic.Interfaces.HydraulicPort_b q_out
          "Blood outflow"
          annotation (extent=[-10,-110; 10,-90], Placement(transformation(extent={{-10,
                  -110},{10,-90}}, rotation=0),
                                          iconTransformation(extent={{-110,-10},{
                  -90,10}})));

          /*
  Library.PressureFlow.NegativePressureFlow fromSystemicVeins annotation (
      Placement(transformation(extent={{-110,-10},{-90,10}}),iconTransformation(
          extent={{-112,44},{-92,64}})));
  Library.PressureFlow.PositivePressureFlow systemicArteries
    annotation (Placement(transformation(extent={{88,-10},{108,10}}),
        iconTransformation(extent={{90,46},{110,66}})));
*/

        Physiolibrary.Hydraulic.Components.ElasticVessel systemicArtys(
          stateName="SystemicArtys.Vol",
          useComplianceInput=true,
          useExternalPressureInput=true,
          useV0Input=true,
          volume_start=0.00100036)
          annotation (Placement(transformation(extent={{65,-10},{86,11}})));
        Physiolibrary.Types.Constants.DeprecatedUntypedConstant V0_artys(
          units="ml",
          k=850,
          varName="SystemicArtys.V0")
          annotation (Placement(transformation(extent={{98,18},{88,28}})));
        Physiolibrary.Types.Constants.HydraulicComplianceConst const7(k=
              6.645545561992547e-007)
          annotation (Placement(transformation(extent={{-27,10},{-35,18}})));
        PeripheralCirculation peripheral
          annotation (Placement(transformation(extent={{-2,-14},{26,14}})));
        SystemicVeins veins(BaseConductance=856)
          "scaled to coronary vessels reorganisation"
          annotation (Placement(transformation(extent={{-72,-8},{-56,8}})));
          SystemicVeinsElacticBloodCompartment
            systemicVeinsElacticBloodCompartment
            annotation (Placement(transformation(extent={{-54,-10},{-34,10}})));
        Physiolibrary.Types.Constants.DeprecatedUntypedConstant const4(k=0)
          annotation (Placement(transformation(extent={{86,14},{79,21}})));
        Physiolibrary.Types.Constants.DeprecatedUntypedConstant const6(k=0)
          annotation (Placement(transformation(extent={{-36,16},{-43,23}})));
        Physiolibrary.Types.BusConnector busConnector
          "signals of organ bood flow resistence" annotation (Placement(
              transformation(extent={{36,40},{56,60}}), iconTransformation(
                extent={{-110,32},{-94,48}})));
        Physiolibrary.Types.Constants.HydraulicComplianceConst const5(k=
              1.162595442560773e-008)
          annotation (Placement(transformation(extent={{96,8},{89,15}})));
        CollapsingVeins collapsedVeins annotation (Placement(transformation(
              extent={{-10,10.5},{10,-10.5}},
              rotation=180,
              origin={-84.5,0})));
        Physiolibrary.Hydraulic.Components.HydrostaticColumn
          gravityHydrostaticDifference(useExternalG=true, useHeightInput=true)
          annotation (Placement(transformation(
              extent={{-10,-10},{10,10}},
              origin={61,35})));
        Physiolibrary.Hydraulic.Sensors.PressureMeasure pressureMeasure
          annotation (Placement(transformation(
              extent={{8.5,-8.5},{-8.5,8.5}},
              origin={78.5,45.5})));
          Modelica.Blocks.Math.Gain G(k=9.81) annotation (Placement(transformation(
                extent={{4,-4},{-4,4}},
                rotation=90,
                origin={34,26})));
        Microcirculation.LeftHeart_Simplified leftCororaryCirculation(
            BasicLargeVeselsConductance=50*0.93677109469950528615290800207779,
            BasicSmallVeselsConductance=2.2*0.93677109469950528615290800207779)
          "scaled to normal pressure gradient 94 mmHg"
          annotation (Placement(transformation(extent={{-10,76},{10,96}})));
        Microcirculation.RightHeart_Simplified rightCororaryCirculation(
            BasicLargeVeselsConductance=10*0.93677109469950528615290800207779,
            BasicSmallVeselsConductance=0.4*0.93677109469950528615290800207779)
          "scaled to normal pressure gradient 94 mmHg"
          annotation (Placement(transformation(extent={{-42,62},{-22,82}})));
        SplanchnicCirculation splanchnicCirculation
          annotation (Placement(transformation(extent={{-8,-44},{30,-6}})));
        equation
          connect(systemicArtys.compliance, const5.y) annotation (Line(
              points={{81.8,11},{81.8,11.5},{88.65,11.5}},
              color={0,0,127},
              smooth=Smooth.None));
        connect(systemicArtys.zeroPressureVolume, V0_artys.y) annotation (Line(
            points={{69.2,11},{69.2,23},{87.5,23}},
            color={0,0,127},
            smooth=Smooth.None));
          connect(busConnector, peripheral.busConnector)          annotation (
              Line(
              points={{46,50},{46,2.66},{21.66,2.66}},
              color={0,0,255},
              thickness=0.5,
              smooth=Smooth.None));
          connect(veins.busConnector,busConnector)           annotation (
             Line(
              points={{-58.48,1.52},{-60,1.52},{-60,50},{46,50}},
              color={0,0,255},
              thickness=0.5,
              smooth=Smooth.None));
          connect(const7.y,systemicVeinsElacticBloodCompartment. Compliance)
            annotation (Line(
              points={{-35.4,14},{-38.2,14},{-38.2,10},{-38,10}},
              color={0,0,127},
              smooth=Smooth.None));
          connect(busConnector,systemicVeinsElacticBloodCompartment. busConnector)
            annotation (Line(
              points={{46,50},{-26,50},{-26,6.1},{-34.2,6.1}},
              color={0,0,255},
              thickness=0.5,
              smooth=Smooth.None));
          connect(systemicArtys.externalPressure,const4. y) annotation (Line(
              points={{75.5,11},{75.5,17.5},{78.65,17.5}},
              color={0,0,127},
              smooth=Smooth.None));
          connect(systemicVeinsElacticBloodCompartment.ExternalPressure,const6. y)
            annotation (Line(
              points={{-44,10},{-44,19.5},{-43.35,19.5}},
              color={0,0,127},
              smooth=Smooth.None));
          connect(systemicArtys.compliance,const5. y) annotation (Line(
              points={{81.8,11},{81.8,11.5},{88.65,11.5}},
              color={0,0,127},
              smooth=Smooth.None));
          connect(collapsedVeins.ExternalPressure, busConnector.Thorax_AvePressure)
            annotation (Line(
              points={{-90.5,2.1},{-90,2.1},{-90,50},{46,50}},
              color={0,0,127},
              smooth=Smooth.None));
        connect(pressureMeasure.pressure, busConnector.CarotidSinus_Pressure)
          annotation (Line(
            points={{74.08,43.8},{46,43.8},{46,50}},
            color={0,0,127},
            smooth=Smooth.None));
          connect(gravityHydrostaticDifference.height, busConnector.CarotidSinusHeight)
            annotation (Line(
              points={{54.9,34.5},{46,32},{46,50}},
              color={0,0,127},
              smooth=Smooth.None));
        connect(gravityHydrostaticDifference.q_down, systemicArtys.q_in)
          annotation (Line(
            points={{68,29.4},{68,0.5},{75.5,0.5}},
            color={0,0,0},
            thickness=1,
            smooth=Smooth.None));
          connect(systemicArtys.Pressure, busConnector.SystemicArtys_Pressure)
            annotation (Line(
              points={{79.7,-10},{80,-10},{80,-28},{46,-28},{46,50}},
              color={0,0,127},
              smooth=Smooth.None), Text(
              string="%second",
              index=1,
              extent={{3,-3},{3,-3}}));

          connect(gravityHydrostaticDifference.q_up, pressureMeasure.q_in)
            annotation (Line(
              points={{68.2,39.8},{80,39.8},{80,42.1},{80.2,42.1}},
              color={0,0,0},
              thickness=1,
              smooth=Smooth.None));
        connect(pressureMeasure.pressure, busConnector.CarotidSinusArteryPressure)
          annotation (Line(
            points={{74.08,43.8},{46,43.8},{46,50}},
            color={0,0,127},
            smooth=Smooth.None));
          connect(systemicVeinsElacticBloodCompartment.Pressure, busConnector.SystemicVeins_Pressure)
            annotation (Line(
              points={{-40,-10},{-40,-28},{46,-28},{46,50}},
              color={0,0,127},
              smooth=Smooth.None), Text(
              string="%second",
              index=1,
              extent={{6,3},{6,3}}));
          connect(systemicVeinsElacticBloodCompartment.V0, busConnector.SystemicVeins_V0)
            annotation (Line(
              points={{-50.8,10},{-50.8,50},{46,50}},
              color={0,0,127},
              smooth=Smooth.None));
          connect(V0_artys.y, busConnector.SystemicArtys_V0) annotation (Line(
              points={{87.5,23},{70,23},{70,22},{46,22},{46,50}},
              color={0,0,127},
              smooth=Smooth.None));
        connect(systemicArtys.volume, busConnector.SystemicArtys_OxygenatedBloodVolume)
          annotation (Line(
            points={{71.3,-10},{72,-10},{72,-28},{46,-28},{46,50}},
            color={0,0,127},
            smooth=Smooth.None));
          connect(q_in, systemicArtys.q_in) annotation (Line(
            points={{100,0},{99.75,0},{99.75,0.5},{75.5,0.5}},
            color={0,0,0},
            thickness=1,
            smooth=Smooth.None));
          connect(collapsedVeins.q_out, q_out) annotation (Line(
              points={{-74.5,-1.22465e-015},{-96.25,-1.22465e-015},{-96.25,0},{
                -100,0}},
              color={0,0,0},
              thickness=1,
              smooth=Smooth.None));
          connect(busConnector.Gravity_Gz, G.u) annotation (Line(
              points={{46,50},{46,38},{34,38},{34,30.8}},
              color={0,0,255},
              thickness=0.5,
              smooth=Smooth.None), Text(
              string="%first",
              index=-1,
              extent={{-6,3},{-6,3}}));
          connect(G.y, gravityHydrostaticDifference.G) annotation (Line(
              points={{34,21.6},{34,16},{62.5,16},{62.5,26.5}},
              color={0,0,127},
              smooth=Smooth.None));
          connect(rightCororaryCirculation.busConnector, busConnector)
                                                                  annotation (
              Line(
              points={{-25.1,73.9},{46,73.9},{46,50}},
              color={0,0,255},
              thickness=0.5,
              smooth=Smooth.None));
          connect(leftCororaryCirculation.busConnector, busConnector)
                                                                 annotation (Line(
              points={{6.9,87.9},{46,87.9},{46,50}},
              color={0,0,255},
              thickness=0.5,
              smooth=Smooth.None));
          connect(leftCororaryCirculation.BloodFlow, busConnector.leftHeart_BloodFlow)
            annotation (Line(
              points={{7,84},{46,84},{46,50}},
              color={0,0,127},
              smooth=Smooth.None));
          connect(rightCororaryCirculation.BloodFlow, busConnector.rightHeart_BloodFlow)
            annotation (Line(
              points={{-25,70},{22,70},{22,50},{46,50}},
              color={0,0,127},
              smooth=Smooth.None));
          connect(leftCororaryCirculation.BloodFlow, busConnector.LeftHeart_BloodFlow)
            annotation (Line(
              points={{7,84},{46,84},{46,50}},
              color={0,0,127},
              smooth=Smooth.None), Text(
              string="%second",
              index=1,
              extent={{6,3},{6,3}}));
          connect(rightCororaryCirculation.BloodFlow, busConnector.RightHeart_BloodFlow)
            annotation (Line(
              points={{-25,70},{22,70},{22,50},{46,50}},
              color={0,0,127},
              smooth=Smooth.None));
          connect(splanchnicCirculation.busConnector, busConnector) annotation (
              Line(
              points={{-8,-15.5},{-8,50},{46,50}},
              color={0,0,255},
              thickness=0.5,
              smooth=Smooth.None));
        connect(splanchnicCirculation.q_in, systemicArtys.q_in) annotation (Line(
            points={{30,-25},{62,-25},{62,0.5},{75.5,0.5}},
            color={0,0,0},
            thickness=1,
            smooth=Smooth.None));
          connect(splanchnicCirculation.q_out,
            systemicVeinsElacticBloodCompartment.referencePoint) annotation (Line(
              points={{-8,-25},{-22,-25},{-22,0},{-44,0}},
              color={0,0,0},
              thickness=1,
              smooth=Smooth.None));
        connect(peripheral.q_in, systemicArtys.q_in) annotation (Line(
            points={{26,1.77636e-015},{52,1.77636e-015},{52,0.5},{75.5,0.5}},
            color={0,0,0},
            thickness=1,
            smooth=Smooth.None));
          connect(peripheral.q_out, systemicVeinsElacticBloodCompartment.referencePoint)
            annotation (Line(
              points={{-2,1.77636e-015},{-24,1.77636e-015},{-24,0},{-44,0}},
              color={0,0,0},
              thickness=1,
              smooth=Smooth.None));
          connect(rightCororaryCirculation.q_out, q_out) annotation (Line(
              points={{-42,72},{-60,72},{-60,86},{-100,86},{-100,0}},
              color={0,0,0},
              thickness=1,
              smooth=Smooth.None));
          connect(leftCororaryCirculation.q_out, q_out) annotation (Line(
              points={{-10,86},{-100,86},{-100,0}},
              color={0,0,0},
              thickness=1,
              smooth=Smooth.None));
          connect(leftCororaryCirculation.q_in, q_in) annotation (Line(
              points={{10,86},{100,86},{100,0}},
              color={0,0,0},
              thickness=1,
              smooth=Smooth.None));
          connect(systemicVeinsElacticBloodCompartment.referencePoint, veins.q_in)
            annotation (Line(
              points={{-44,0},{-56,0}},
              color={0,0,0},
              thickness=1,
              smooth=Smooth.None));
          connect(veins.q_out, collapsedVeins.q_in) annotation (Line(
              points={{-72,0},{-73.25,0},{-73.25,1.22465e-015},{-94.5,
                1.22465e-015}},
              color={0,0,0},
              thickness=1,
              smooth=Smooth.None));

          connect(rightCororaryCirculation.q_in, q_in) annotation (Line(
              points={{-22,72},{36,72},{36,86},{100,86},{100,0}},
              color={0,0,0},
              thickness=1,
              smooth=Smooth.None));
         annotation (Diagram(coordinateSystem(preserveAspectRatio=true, extent={{-100,
                    -100},{100,100}}), graphics={Text(
                  extent={{42,46},{74,46}},
                  lineColor={0,0,255},
                  textString="Carotid Artery Pressure")}),
                                         Icon(coordinateSystem(
                  preserveAspectRatio=true, extent={{-100,-100},{100,100}}),
                graphics={
                Text(
                  extent={{-104,-54},{110,-76}},
                  lineColor={0,0,255},
                  textString="%name")}),
          Documentation(revisions="<html>

<table>
<tr>
<td>Author:</td>
<td>Marek Matejak</td>
</tr>
<tr>
<td>License:</td>
<td><a href=\"http://www.physiomodel.org/license.html\">Physiomodel License 1.0</a> </td>
</tr>
<tr>
<td>By:</td>
<td>Charles University, Prague</td>
</tr>
<tr>
<td>Date of:</td>
<td>january 2009</td>
</tr>
<tr>
<td>References:</td>
<td>Tom Coleman: QHP 2008 beta 3, University of Mississippi Medical Center</td>
</tr>
</table>
<br/><p>Copyright &copy; 2014 Marek Matejak, Charles University in Prague.</p><br/>

</html>",   info="<html>
<p>Blood volume (and pressure) distributions between </p>
<p><ul>
<li>systemic arteries, </li>
<li>systemic veins and</li>
<li>portal (splanchnic) vein.</li>
</ul></p>
<p>Blood flow throught: </p>
<p><ul>
<li>GIT, hepatic artery, liver</li>
<li>Kidney</li>
<li>CNS</li>
<li>Skeletal muscle</li>
<li>Respiratory muscle</li>
<li>Skin</li>
<li>Bones</li>
<li>Adipose tissue</li>
<li>Other tissue</li>
</ul></p>
</html>"));
        end SystemicCirculationBase2_Simplified;

        model SystemicCirculationBase2

           extends Physiolibrary.Icons.SystemicCirculation;

        Physiolibrary.Hydraulic.Interfaces.HydraulicPort_a q_in "Blood inflow"
          annotation (extent=[-10,-110; 10,-90], Placement(transformation(extent={{-10,
                  -110},{10,-90}}, rotation=0),
                                        iconTransformation(extent={{90,-10},{110,
                  10}})));
        Physiolibrary.Hydraulic.Interfaces.HydraulicPort_b q_out
          "Blood outflow"
          annotation (extent=[-10,-110; 10,-90], Placement(transformation(extent={{-10,
                  -110},{10,-90}}, rotation=0),
                                          iconTransformation(extent={{-110,-10},{
                  -90,10}})));

          /*
  Library.PressureFlow.NegativePressureFlow fromSystemicVeins annotation (
      Placement(transformation(extent={{-110,-10},{-90,10}}),iconTransformation(
          extent={{-112,44},{-92,64}})));
  Library.PressureFlow.PositivePressureFlow systemicArteries
    annotation (Placement(transformation(extent={{88,-10},{108,10}}),
        iconTransformation(extent={{90,46},{110,66}})));
*/

        Physiolibrary.Hydraulic.Components.ElasticVessel systemicArtys(
          stateName="SystemicArtys.Vol",
          useComplianceInput=true,
          useExternalPressureInput=true,
          useV0Input=true,
          volume_start=0.00100036)
          annotation (Placement(transformation(extent={{65,-10},{86,11}})));
        Physiolibrary.Types.Constants.VolumeConst V0_artys(k=0.00085)
          annotation (Placement(transformation(extent={{98,18},{88,28}})));
        Physiolibrary.Types.Constants.HydraulicComplianceConst const7(k=
              6.645545561992547e-007)
          annotation (Placement(transformation(extent={{-25,10},{-33,18}})));
        PeripheralCirculation peripheral
          annotation (Placement(transformation(extent={{-2,-14},{26,14}})));
        SystemicVeins veins(BaseConductance=856)
          "scaled to coronary vessels reorganisation"
          annotation (Placement(transformation(extent={{-72,-8},{-56,8}})));
        SystemicVeinsElacticBloodCompartment2
          systemicVeinsElacticBloodCompartment
          annotation (Placement(transformation(extent={{-54,-10},{-34,10}})));
        Physiolibrary.Types.Constants.DeprecatedUntypedConstant const4(k=0)
          annotation (Placement(transformation(extent={{86,14},{78,22}})));
        Physiolibrary.Types.Constants.DeprecatedUntypedConstant const6(k=0)
          annotation (Placement(transformation(extent={{-34,16},{-43,25}})));
        Physiolibrary.Types.BusConnector busConnector
          "signals of organ bood flow resistence" annotation (Placement(
              transformation(extent={{36,40},{56,60}}), iconTransformation(
                extent={{-110,32},{-94,48}})));
        Physiolibrary.Types.Constants.HydraulicComplianceConst const5(k=
              1.162595442560773e-008)
          annotation (Placement(transformation(extent={{98,6},{89,15}})));
        CollapsingVeins collapsedVeins annotation (Placement(transformation(
              extent={{-10,10.5},{10,-10.5}},
              rotation=180,
              origin={-84.5,0})));
        Physiolibrary.Hydraulic.Components.HydrostaticColumn
          gravityHydrostaticDifference(useExternalG=true, useHeightInput=true)
          annotation (Placement(transformation(
              extent={{-10,-10},{10,10}},
              origin={61,35})));
        Physiolibrary.Hydraulic.Sensors.PressureMeasure pressureMeasure
          annotation (Placement(transformation(
              extent={{8.5,-8.5},{-8.5,8.5}},
              origin={78.5,45.5})));
          Modelica.Blocks.Math.Gain G(k=9.81) annotation (Placement(transformation(
                extent={{4,-4},{-4,4}},
                rotation=90,
                origin={34,26})));
        Microcirculation.LeftHeart leftCororaryCirculation(
            BasicLargeVeselsConductance=50*0.93677109469950528615290800207779,
            BasicSmallVeselsConductance=2.2*0.93677109469950528615290800207779)
          "scaled to normal pressure gradient 94 mmHg"
          annotation (Placement(transformation(extent={{-10,76},{10,96}})));
        Microcirculation.RightHeart rightCororaryCirculation(
            BasicLargeVeselsConductance=10*0.93677109469950528615290800207779,
            BasicSmallVeselsConductance=0.4*0.93677109469950528615290800207779)
          "scaled to normal pressure gradient 94 mmHg"
          annotation (Placement(transformation(extent={{-42,62},{-22,82}})));
        SplanchnicCirculation splanchnicCirculation
          annotation (Placement(transformation(extent={{-8,-44},{30,-6}})));
        equation
          connect(systemicArtys.compliance, const5.y) annotation (Line(
              points={{81.8,11},{81.8,10.5},{88.55,10.5}},
              color={0,0,127},
              smooth=Smooth.None));
        connect(systemicArtys.zeroPressureVolume, V0_artys.y) annotation (Line(
            points={{69.2,11},{69.2,23},{87.5,23}},
            color={0,0,127},
            smooth=Smooth.None));
          connect(busConnector, peripheral.busConnector)          annotation (
              Line(
              points={{46,50},{46,2.66},{21.66,2.66}},
              color={0,0,255},
              thickness=0.5,
              smooth=Smooth.None));
          connect(veins.busConnector,busConnector)           annotation (
             Line(
              points={{-58.48,1.52},{-60,1.52},{-60,50},{46,50}},
              color={0,0,255},
              thickness=0.5,
              smooth=Smooth.None));
          connect(const7.y,systemicVeinsElacticBloodCompartment. Compliance)
            annotation (Line(
              points={{-33.4,14},{-38.2,14},{-38.2,10},{-38,10}},
              color={0,0,127},
              smooth=Smooth.None));
          connect(busConnector,systemicVeinsElacticBloodCompartment. busConnector)
            annotation (Line(
              points={{46,50},{-24,50},{-24,6},{-30,6},{-30,6.1},{-34.2,6.1}},
              color={0,0,255},
              thickness=0.5,
              smooth=Smooth.None));
          connect(systemicArtys.externalPressure,const4. y) annotation (Line(
              points={{75.5,11},{75.5,18},{77.6,18}},
              color={0,0,127},
              smooth=Smooth.None));
          connect(systemicVeinsElacticBloodCompartment.ExternalPressure,const6. y)
            annotation (Line(
              points={{-44,10},{-44,20.5},{-43.45,20.5}},
              color={0,0,127},
              smooth=Smooth.None));
          connect(systemicArtys.compliance,const5. y) annotation (Line(
              points={{81.8,11},{81.8,10.5},{88.55,10.5}},
              color={0,0,127},
              smooth=Smooth.None));
          connect(collapsedVeins.ExternalPressure, busConnector.Thorax_AvePressure)
            annotation (Line(
              points={{-90.5,2.1},{-90,2.1},{-90,50},{46,50}},
              color={0,0,127},
              smooth=Smooth.None));
        connect(pressureMeasure.pressure, busConnector.CarotidSinus_Pressure)
          annotation (Line(
            points={{74.08,43.8},{46,43.8},{46,50}},
            color={0,0,127},
            smooth=Smooth.None));
          connect(gravityHydrostaticDifference.height, busConnector.CarotidSinusHeight)
            annotation (Line(
              points={{54.9,34.5},{46,32},{46,50}},
              color={0,0,127},
              smooth=Smooth.None));
        connect(gravityHydrostaticDifference.q_down, systemicArtys.q_in)
          annotation (Line(
            points={{68,29.4},{68,0.5},{75.5,0.5}},
            color={0,0,0},
            thickness=1,
            smooth=Smooth.None));
          connect(systemicArtys.Pressure, busConnector.SystemicArtys_Pressure)
            annotation (Line(
              points={{79.7,-10},{80,-10},{80,-28},{46,-28},{46,50}},
              color={0,0,127},
              smooth=Smooth.None), Text(
              string="%second",
              index=1,
              extent={{3,-3},{3,-3}}));

          connect(gravityHydrostaticDifference.q_up, pressureMeasure.q_in)
            annotation (Line(
              points={{68.2,39.8},{80,39.8},{80,42.1},{80.2,42.1}},
              color={0,0,0},
              thickness=1,
              smooth=Smooth.None));
        connect(pressureMeasure.pressure, busConnector.CarotidSinusArteryPressure)
          annotation (Line(
            points={{74.08,43.8},{46,43.8},{46,50}},
            color={0,0,127},
            smooth=Smooth.None));
          connect(systemicVeinsElacticBloodCompartment.Pressure, busConnector.SystemicVeins_Pressure)
            annotation (Line(
              points={{-40,-10},{-40,-28},{46,-28},{46,50}},
              color={0,0,127},
              smooth=Smooth.None), Text(
              string="%second",
              index=1,
              extent={{6,3},{6,3}}));
          connect(systemicVeinsElacticBloodCompartment.V0, busConnector.SystemicVeins_V0)
            annotation (Line(
              points={{-50.8,10},{-50.8,50},{46,50}},
              color={0,0,127},
              smooth=Smooth.None));
          connect(V0_artys.y, busConnector.SystemicArtys_V0) annotation (Line(
              points={{87.5,23},{70,23},{70,22},{46,22},{46,50}},
              color={0,0,127},
              smooth=Smooth.None));
        connect(systemicArtys.volume, busConnector.SystemicArtys_OxygenatedBloodVolume)
          annotation (Line(
            points={{71.3,-10},{72,-10},{72,-28},{46,-28},{46,50}},
            color={0,0,127},
            smooth=Smooth.None));
          connect(q_in, systemicArtys.q_in) annotation (Line(
            points={{100,0},{99.75,0},{99.75,0.5},{75.5,0.5}},
            color={0,0,0},
            thickness=1,
            smooth=Smooth.None));
          connect(collapsedVeins.q_out, q_out) annotation (Line(
              points={{-74.5,-1.22465e-015},{-96.25,-1.22465e-015},{-96.25,0},{
                -100,0}},
              color={0,0,0},
              thickness=1,
              smooth=Smooth.None));
          connect(busConnector.Gravity_Gz, G.u) annotation (Line(
              points={{46,50},{46,38},{34,38},{34,30.8}},
              color={0,0,255},
              thickness=0.5,
              smooth=Smooth.None), Text(
              string="%first",
              index=-1,
              extent={{-6,3},{-6,3}}));
          connect(G.y, gravityHydrostaticDifference.G) annotation (Line(
              points={{34,21.6},{34,16},{62.5,16},{62.5,26.5}},
              color={0,0,127},
              smooth=Smooth.None));
          connect(rightCororaryCirculation.busConnector, busConnector)
                                                                  annotation (
              Line(
              points={{-25.1,73.9},{46,73.9},{46,50}},
              color={0,0,255},
              thickness=0.5,
              smooth=Smooth.None));
          connect(leftCororaryCirculation.busConnector, busConnector)
                                                                 annotation (Line(
              points={{6.9,87.9},{46,87.9},{46,50}},
              color={0,0,255},
              thickness=0.5,
              smooth=Smooth.None));
          connect(leftCororaryCirculation.BloodFlow, busConnector.leftHeart_BloodFlow)
            annotation (Line(
              points={{7,84},{46,84},{46,50}},
              color={0,0,127},
              smooth=Smooth.None));
          connect(rightCororaryCirculation.BloodFlow, busConnector.rightHeart_BloodFlow)
            annotation (Line(
              points={{-25,70},{22,70},{22,50},{46,50}},
              color={0,0,127},
              smooth=Smooth.None));
          connect(leftCororaryCirculation.BloodFlow, busConnector.LeftHeart_BloodFlow)
            annotation (Line(
              points={{7,84},{46,84},{46,50}},
              color={0,0,127},
              smooth=Smooth.None), Text(
              string="%second",
              index=1,
              extent={{6,3},{6,3}}));
          connect(rightCororaryCirculation.BloodFlow, busConnector.RightHeart_BloodFlow)
            annotation (Line(
              points={{-25,70},{22,70},{22,50},{46,50}},
              color={0,0,127},
              smooth=Smooth.None));
          connect(splanchnicCirculation.busConnector, busConnector) annotation (
              Line(
              points={{-8,-15.5},{-8,50},{46,50}},
              color={0,0,255},
              thickness=0.5,
              smooth=Smooth.None));
        connect(splanchnicCirculation.q_in, systemicArtys.q_in) annotation (Line(
            points={{30,-25},{62,-25},{62,0.5},{75.5,0.5}},
            color={0,0,0},
            thickness=1,
            smooth=Smooth.None));
          connect(splanchnicCirculation.q_out,
            systemicVeinsElacticBloodCompartment.referencePoint) annotation (Line(
              points={{-8,-25},{-22,-25},{-22,0},{-44,0}},
              color={0,0,0},
              thickness=1,
              smooth=Smooth.None));
        connect(peripheral.q_in, systemicArtys.q_in) annotation (Line(
            points={{26,1.77636e-015},{52,1.77636e-015},{52,0.5},{75.5,0.5}},
            color={0,0,0},
            thickness=1,
            smooth=Smooth.None));
          connect(peripheral.q_out, systemicVeinsElacticBloodCompartment.referencePoint)
            annotation (Line(
              points={{-2,1.77636e-015},{-24,1.77636e-015},{-24,0},{-44,0}},
              color={0,0,0},
              thickness=1,
              smooth=Smooth.None));
          connect(rightCororaryCirculation.q_out, q_out) annotation (Line(
              points={{-42,72},{-60,72},{-60,86},{-100,86},{-100,0}},
              color={0,0,0},
              thickness=1,
              smooth=Smooth.None));
          connect(leftCororaryCirculation.q_out, q_out) annotation (Line(
              points={{-10,86},{-100,86},{-100,0}},
              color={0,0,0},
              thickness=1,
              smooth=Smooth.None));
          connect(leftCororaryCirculation.q_in, q_in) annotation (Line(
              points={{10,86},{100,86},{100,0}},
              color={0,0,0},
              thickness=1,
              smooth=Smooth.None));
          connect(systemicVeinsElacticBloodCompartment.referencePoint, veins.q_in)
            annotation (Line(
              points={{-44,0},{-56,0}},
              color={0,0,0},
              thickness=1,
              smooth=Smooth.None));
          connect(veins.q_out, collapsedVeins.q_in) annotation (Line(
              points={{-72,0},{-73.25,0},{-73.25,1.22465e-015},{-94.5,
                1.22465e-015}},
              color={0,0,0},
              thickness=1,
              smooth=Smooth.None));

          connect(rightCororaryCirculation.q_in, q_in) annotation (Line(
              points={{-22,72},{36,72},{36,86},{100,86},{100,0}},
              color={0,0,0},
              thickness=1,
              smooth=Smooth.None));
          connect(busConnector.SystemicVeins_DeoxygenatedBloodVolume,
            systemicVeinsElacticBloodCompartment.BloodVolume) annotation (Line(
              points={{46,50},{46,-28},{-48,-28},{-48,-10}},
              color={0,0,255},
              thickness=0.5,
              smooth=Smooth.None), Text(
              string="%first",
              index=-1,
              extent={{-6,3},{-6,3}}));
         annotation (Diagram(coordinateSystem(preserveAspectRatio=true, extent={{-100,
                    -100},{100,100}}), graphics={Text(
                  extent={{42,46},{74,46}},
                  lineColor={0,0,255},
                  textString="Carotid Artery Pressure")}),
                                         Icon(coordinateSystem(
                  preserveAspectRatio=true, extent={{-100,-100},{100,100}}),
                graphics={
                Text(
                  extent={{-104,-54},{110,-76}},
                  lineColor={0,0,255},
                  textString="%name")}),
          Documentation(revisions="<html>

<table>
<tr>
<td>Author:</td>
<td>Marek Matejak</td>
</tr>

<tr>
<td>License:</td>
<td><a href=\"http://www.physiomodel.org/license.html\">Physiomodel License 1.0</a> </td>
</tr>
<tr>
<td>By:</td>
<td>Charles University, Prague</td>
</tr>
<tr>
<td>Date of:</td>
<td>january 2009</td>
</tr>
<tr>
<td>References:</td>
<td>Tom Coleman: QHP 2008 beta 3, University of Mississippi Medical Center</td>
</tr>
</table>
<br/><p>Copyright &copy; 2014 Marek Matejak, Charles University in Prague.</p><br/>

</html>",   info="<html>
<p>Blood volume (and pressure) distributions between </p>
<p><ul>
<li>systemic arteries, </li>
<li>systemic veins and</li>
<li>portal (splanchnic) vein.</li>
</ul></p>
<p>Blood flow throught: </p>
<p><ul>
<li>GIT, hepatic artery, liver</li>
<li>Kidney</li>
<li>CNS</li>
<li>Skeletal muscle</li>
<li>Respiratory muscle</li>
<li>Skin</li>
<li>Bones</li>
<li>Adipose tissue</li>
<li>Other tissue</li>
</ul></p>
</html>"));
        end SystemicCirculationBase2;

        model SystemicCirculation
          extends develop.SystemicCirculationBase2;
        Physiolibrary.Types.Constants.DeprecatedUntypedConstant const8(k=0)
          annotation (Placement(transformation(extent={{93,-62},{86,-55}})));
        Physiolibrary.Hydraulic.Components.HydrostaticColumn
          hydrostaticDifference(useExternalG=true, useHeightInput=true)
          annotation (Placement(transformation(
              extent={{-10,-10},{10,10}},
              origin={54,-66})));
          SequesteredBlood sequesteredBlood(data={{0,0,10^(-10)},{50,97,1.0},{200,150,0.5}},
              initialVol=50.0044,
            pressureControledCompartment(stateName="BVSeqArtys.Vol"))
            annotation (Placement(transformation(extent={{80,-82},{100,-62}})));
          SequesteredBlood sequesteredBlood1(                data={{0,-100,2.00},{150,11,
                0.11},{600,50,0.15}}, initialVol=120.691,
            pressureControledCompartment(stateName="BVSeqVeins.Vol"))
            annotation (Placement(transformation(extent={{-62,-76},{-44,-58}})));
        Physiolibrary.Hydraulic.Components.HydrostaticColumn
          hydrostaticDifference1(
          useExternalG=true,
          useHeightInput=true,
          usePumpEffect=true)
          annotation (Placement(transformation(extent={{-5,-72},{-25,-52}})));
        Physiolibrary.Types.Constants.PressureConst const12(k=0)
          annotation (Placement(transformation(extent={{-52,-54},{-59,-47}})));
          Physiolibrary.Hydraulic.OneWayResistorWithCondParam
            oneWayResistorWithCondParam(cond=40)
            annotation (Placement(transformation(extent={{64,-88},{84,-68}})));
          Physiolibrary.Hydraulic.OneWayResistorWithCondParam
            oneWayResistorWithCondParam1(cond=40)
            annotation (Placement(transformation(extent={{84,-78},{64,-58}})));
          Physiolibrary.Hydraulic.OneWayResistorWithCondParam
            oneWayResistorWithCondParam2(cond=100)
            annotation (Placement(transformation(extent={{-46,-82},{-26,-62}})));
          Physiolibrary.Hydraulic.OneWayResistorWithCondParam
            oneWayResistorWithCondParam3(cond=100)
            annotation (Placement(transformation(extent={{-26,-72},{-46,-52}})));
        equation
          connect(sequesteredBlood.ExternalPressure,const8. y) annotation (Line(
              points={{81,-62},{81,-58.5},{85.65,-58.5}},
              color={0,0,127},
              smooth=Smooth.None));
        connect(hydrostaticDifference.q_up, systemicArtys.q_in) annotation (Line(
            points={{61.2,-61.2},{62,-56},{62,0},{75.5,0},{75.5,0.5}},
            color={0,0,0},
            thickness=1,
            smooth=Smooth.None));
          connect(sequesteredBlood1.ExternalPressure,const12. y) annotation (Line(
              points={{-61.1,-58},{-61.1,-50.5},{-59.35,-50.5}},
              color={0,0,127},
              smooth=Smooth.None));
          connect(hydrostaticDifference1.q_up,
            systemicVeinsElacticBloodCompartment.referencePoint) annotation (Line(
              points={{-22.2,-57.2},{-22.2,0},{-44,0}},
              color={0,0,0},
              thickness=1,
              smooth=Smooth.None));
          connect(hydrostaticDifference1.height, busConnector.LowerTorsoVeinHeight)
            annotation (Line(
              points={{-8.9,-62.3},{46,-62.3},{46,50}},
              color={0,0,127},
              smooth=Smooth.None), Text(
              string="%second",
              index=1,
              extent={{6,3},{6,3}}));
          connect(hydrostaticDifference1.pumpEffect, busConnector.Exercise_MusclePump_Effect)
            annotation (Line(
              points={{-13.5,-52.5},{46,-52.5},{46,50}},
              color={0,0,127},
              smooth=Smooth.None), Text(
              string="%second",
              index=1,
              extent={{6,3},{6,3}}));
          connect(hydrostaticDifference.height, busConnector.LowerTorsoArtyHeight)
            annotation (Line(
              points={{47.9,-66.5},{46,-66.5},{46,50}},
              color={0,0,127},
              smooth=Smooth.None));
          connect(sequesteredBlood1.Vol, busConnector.LegVeins_DeoxygenatedBloodVolume)
            annotation (Line(
              points={{-56.6,-76},{-58,-76},{-58,-84},{46,-84},{46,50}},
              color={0,0,127},
              smooth=Smooth.None));
          connect(sequesteredBlood.Vol, busConnector.LegArtys_OxygenatedBloodVolume)
            annotation (Line(
              points={{86,-82},{86,-84},{46,-84},{46,50}},
              color={0,0,127},
              smooth=Smooth.None));
          connect(G.y,hydrostaticDifference1. G) annotation (Line(
              points={{34,21.6},{34,-84},{-16.5,-84},{-16.5,-70.5}},
              color={0,0,127},
              smooth=Smooth.None));
          connect(G.y,hydrostaticDifference. G) annotation (Line(
              points={{34,21.6},{34,-84},{55.5,-84},{55.5,-74.5}},
              color={0,0,127},
              smooth=Smooth.None));
          connect(hydrostaticDifference.q_down, oneWayResistorWithCondParam1.q_out)
            annotation (Line(
              points={{61,-71.6},{61,-72.8},{64,-72.8},{64,-68}},
              color={0,0,0},
              thickness=1,
              smooth=Smooth.None));
          connect(hydrostaticDifference.q_down, oneWayResistorWithCondParam.q_in)
            annotation (Line(
              points={{61,-71.6},{61,-72.8},{64,-72.8},{64,-78}},
              color={0,0,0},
              thickness=1,
              smooth=Smooth.None));
          connect(oneWayResistorWithCondParam1.q_in, sequesteredBlood.referencePoint)
            annotation (Line(
              points={{84,-68},{84,-72},{90,-72}},
              color={0,0,0},
              thickness=1,
              smooth=Smooth.None));
          connect(oneWayResistorWithCondParam.q_out, sequesteredBlood.referencePoint)
            annotation (Line(
              points={{84,-78},{84,-72},{90,-72}},
              color={0,0,0},
              thickness=1,
              smooth=Smooth.None));
          connect(hydrostaticDifference1.q_down, oneWayResistorWithCondParam3.q_in)
            annotation (Line(
              points={{-22,-67.4},{-24,-67.4},{-24,-62},{-26,-62}},
              color={0,0,0},
              thickness=1,
              smooth=Smooth.None));
          connect(hydrostaticDifference1.q_down, oneWayResistorWithCondParam2.q_out)
            annotation (Line(
              points={{-22,-67.4},{-24,-67.4},{-24,-72},{-26,-72}},
              color={0,0,0},
              thickness=1,
              smooth=Smooth.None));
          connect(sequesteredBlood1.referencePoint, oneWayResistorWithCondParam3.q_out)
            annotation (Line(
              points={{-53,-67},{-50.5,-67},{-50.5,-62},{-46,-62}},
              color={0,0,0},
              thickness=1,
              smooth=Smooth.None));
          connect(sequesteredBlood1.referencePoint, oneWayResistorWithCondParam2.q_in)
            annotation (Line(
              points={{-53,-67},{-49.5,-67},{-49.5,-72},{-46,-72}},
              color={0,0,0},
              thickness=1,
              smooth=Smooth.None));
        end SystemicCirculation;

        model SystemicCirculationBase

          extends Physiolibrary.Icons.SystemicCirculation;

        Physiolibrary.Hydraulic.Interfaces.HydraulicPort_a q_in "Blood inflow"
          annotation (extent=[-10,-110; 10,-90], Placement(transformation(extent={{-10,
                  -110},{10,-90}}, rotation=0),
                                        iconTransformation(extent={{90,-10},{110,
                  10}})));
        Physiolibrary.Hydraulic.Interfaces.HydraulicPort_b q_out
          "Blood outflow"
          annotation (extent=[-10,-110; 10,-90], Placement(transformation(extent={{-10,
                  -110},{10,-90}}, rotation=0),
                                          iconTransformation(extent={{-110,-10},{
                  -90,10}})));
          /*
  Library.PressureFlow.NegativePressureFlow fromSystemicVeins annotation (
      Placement(transformation(extent={{-110,-10},{-90,10}}),iconTransformation(
          extent={{-112,44},{-92,64}})));
  Library.PressureFlow.PositivePressureFlow systemicArteries
    annotation (Placement(transformation(extent={{88,-10},{108,10}}),
        iconTransformation(extent={{90,46},{110,66}})));
*/

        Physiolibrary.Hydraulic.Components.ElasticVessel systemicArtys(
          stateName="SystemicArtys.Vol",
          useComplianceInput=true,
          useExternalPressureInput=true,
          useV0Input=true,
          volume_start=0.00100036)
          annotation (Placement(transformation(extent={{65,-10},{86,11}})));
        Physiolibrary.Types.Constants.DeprecatedUntypedConstant V0_artys(k=850)
          annotation (Placement(transformation(extent={{98,18},{88,28}})));
        Physiolibrary.Types.Constants.HydraulicComplianceConst
          SystemicVeinsCompliance(k=6.645545561992547e-007)
          annotation (Placement(transformation(extent={{-27,10},{-35,18}})));
        PeripheralCirculation peripheral
          annotation (Placement(transformation(extent={{-2,-14},{26,14}})));
        Physiolibrary.Hydraulic.Sources.UnlimitedPump volumeCorrections(
            useSolutionFlowInput=true)
          annotation (Placement(transformation(extent={{-28,24},{-42,38}})));
        SystemicVeins veins(BaseConductance=856)
          "scaled to coronary vessels reorganisation"
          annotation (Placement(transformation(extent={{-72,-8},{-56,8}})));
          SystemicVeinsElacticBloodCompartment
            systemicVeinsElacticBloodCompartment
            annotation (Placement(transformation(extent={{-54,-10},{-34,10}})));
        Physiolibrary.Types.Constants.PressureConst SystemicArtysExternalPressure(
            k=0) annotation (Placement(transformation(extent={{86,14},{79,21}})));
        Physiolibrary.Types.Constants.PressureConst SystemicVeinsExternalPressure(
            k=0)
          annotation (Placement(transformation(extent={{-36,16},{-43,23}})));
        Physiolibrary.Types.BusConnector busConnector
          "signals of organ bood flow resistence" annotation (Placement(
              transformation(extent={{36,40},{56,60}}), iconTransformation(
                extent={{-110,32},{-94,48}})));
        Physiolibrary.Types.Constants.HydraulicComplianceConst
          SystemicArtysCompliance(k=1.162595442560773e-008)
          annotation (Placement(transformation(extent={{96,8},{89,15}})));
        CollapsingVeins collapsedVeins annotation (Placement(transformation(
              extent={{-10,10.5},{10,-10.5}},
              rotation=180,
              origin={-84.5,0})));
        Physiolibrary.Hydraulic.Components.HydrostaticColumn
          gravityHydrostaticDifference(useExternalG=true, useHeightInput=true)
          annotation (Placement(transformation(
              extent={{-10,-10},{10,10}},
              origin={61,35})));
        Physiolibrary.Hydraulic.Sensors.PressureMeasure pressureMeasure
          annotation (Placement(transformation(
              extent={{8.5,-8.5},{-8.5,8.5}},
              origin={78.5,45.5})));
          Modelica.Blocks.Math.Gain G(k=9.81) annotation (Placement(transformation(
                extent={{4,-4},{-4,4}},
                rotation=90,
                origin={34,26})));
        Microcirculation.LeftHeart leftCororaryCirculation(
            BasicLargeVeselsConductance=50*0.93677109469950528615290800207779,
            BasicSmallVeselsConductance=2.2*0.93677109469950528615290800207779)
          "scaled to normal pressure gradient 94 mmHg"
          annotation (Placement(transformation(extent={{-10,76},{10,96}})));
        Microcirculation.RightHeart rightCororaryCirculation(
            BasicLargeVeselsConductance=10*0.93677109469950528615290800207779,
            BasicSmallVeselsConductance=0.4*0.93677109469950528615290800207779)
          "scaled to normal pressure gradient 94 mmHg"
          annotation (Placement(transformation(extent={{-42,62},{-22,82}})));
        SplanchnicCirculation splanchnicCirculation
          annotation (Placement(transformation(extent={{-8,-44},{30,-6}})));
        equation
          connect(systemicArtys.compliance, SystemicArtysCompliance.y)
                                                      annotation (Line(
              points={{81.8,11},{81.8,11.5},{88.65,11.5}},
              color={0,0,127},
              smooth=Smooth.None));
        connect(systemicArtys.zeroPressureVolume, V0_artys.y) annotation (Line(
            points={{69.2,11},{69.2,23},{87.5,23}},
            color={0,0,127},
            smooth=Smooth.None));
          connect(busConnector, peripheral.busConnector)          annotation (
              Line(
              points={{46,50},{46,2.66},{21.66,2.66}},
              color={0,0,255},
              thickness=0.5,
              smooth=Smooth.None));
          connect(veins.busConnector,busConnector)           annotation (
             Line(
              points={{-58.48,1.52},{-60,1.52},{-60,50},{46,50}},
              color={0,0,255},
              thickness=0.5,
              smooth=Smooth.None));
          connect(SystemicVeinsCompliance.y, systemicVeinsElacticBloodCompartment.Compliance)
            annotation (Line(
              points={{-35.4,14},{-38.2,14},{-38.2,10},{-38,10}},
              color={0,0,127},
              smooth=Smooth.None));
          connect(busConnector,systemicVeinsElacticBloodCompartment. busConnector)
            annotation (Line(
              points={{46,50},{-26,50},{-26,6.1},{-34.2,6.1}},
              color={0,0,255},
              thickness=0.5,
              smooth=Smooth.None));
          connect(systemicVeinsElacticBloodCompartment.referencePoint,volumeCorrections. q_out)
            annotation (Line(
              points={{-44,0},{-46,0},{-46,31.7},{-42,31.7}},
              color={0,0,0},
              smooth=Smooth.None,
              thickness=1));
          connect(systemicArtys.externalPressure, SystemicArtysExternalPressure.y)
                                                            annotation (Line(
              points={{75.5,11},{75.5,17.5},{78.65,17.5}},
              color={0,0,127},
              smooth=Smooth.None));
          connect(systemicVeinsElacticBloodCompartment.ExternalPressure,
            SystemicVeinsExternalPressure.y)
            annotation (Line(
              points={{-44,10},{-44,19.5},{-43.35,19.5}},
              color={0,0,127},
              smooth=Smooth.None));
        connect(busConnector.BloodVolume_change, volumeCorrections.solutionFlow)
          annotation (Line(
            points={{46,50},{-35,50},{-35,35.2}},
            color={0,0,255},
            thickness=0.5,
            smooth=Smooth.None));
          connect(systemicArtys.compliance, SystemicArtysCompliance.y)
                                                      annotation (Line(
              points={{81.8,11},{81.8,11.5},{88.65,11.5}},
              color={0,0,127},
              smooth=Smooth.None));
          connect(collapsedVeins.ExternalPressure, busConnector.Thorax_AvePressure)
            annotation (Line(
              points={{-90.5,2.1},{-90,2.1},{-90,50},{46,50}},
              color={0,0,127},
              smooth=Smooth.None));
        connect(pressureMeasure.pressure, busConnector.CarotidSinus_Pressure)
          annotation (Line(
            points={{74.08,43.8},{46,43.8},{46,50}},
            color={0,0,127},
            smooth=Smooth.None));
          connect(gravityHydrostaticDifference.height, busConnector.CarotidSinusHeight)
            annotation (Line(
              points={{54.9,34.5},{46,32},{46,50}},
              color={0,0,127},
              smooth=Smooth.None));
        connect(gravityHydrostaticDifference.q_down, systemicArtys.q_in)
          annotation (Line(
            points={{68,29.4},{68,0.5},{75.5,0.5}},
            color={0,0,0},
            thickness=1,
            smooth=Smooth.None));
          connect(systemicArtys.Pressure, busConnector.SystemicArtys_Pressure)
            annotation (Line(
              points={{79.7,-10},{80,-10},{80,-28},{46,-28},{46,50}},
              color={0,0,127},
              smooth=Smooth.None), Text(
              string="%second",
              index=1,
              extent={{3,-3},{3,-3}}));

          connect(gravityHydrostaticDifference.q_up, pressureMeasure.q_in)
            annotation (Line(
              points={{68.2,39.8},{80,39.8},{80,42.1},{80.2,42.1}},
              color={0,0,0},
              thickness=1,
              smooth=Smooth.None));
        connect(pressureMeasure.pressure, busConnector.CarotidSinusArteryPressure)
          annotation (Line(
            points={{74.08,43.8},{46,43.8},{46,50}},
            color={0,0,127},
            smooth=Smooth.None));
          connect(systemicVeinsElacticBloodCompartment.Pressure, busConnector.SystemicVeins_Pressure)
            annotation (Line(
              points={{-40,-10},{-40,-28},{46,-28},{46,50}},
              color={0,0,127},
              smooth=Smooth.None), Text(
              string="%second",
              index=1,
              extent={{6,3},{6,3}}));
          connect(systemicVeinsElacticBloodCompartment.V0, busConnector.SystemicVeins_V0)
            annotation (Line(
              points={{-50.8,10},{-50.8,50},{46,50}},
              color={0,0,127},
              smooth=Smooth.None));
          connect(V0_artys.y, busConnector.SystemicArtys_V0) annotation (Line(
              points={{87.5,23},{70,23},{70,22},{46,22},{46,50}},
              color={0,0,127},
              smooth=Smooth.None));
          connect(systemicVeinsElacticBloodCompartment.Vol, busConnector.SystemicVeins_DeoxygenatedBloodVolume)
            annotation (Line(
              points={{-48,-10},{-48,-28},{46,-28},{46,50}},
              color={0,0,127},
              smooth=Smooth.None));
        connect(systemicArtys.volume, busConnector.SystemicArtys_OxygenatedBloodVolume)
          annotation (Line(
            points={{71.3,-10},{72,-10},{72,-28},{46,-28},{46,50}},
            color={0,0,127},
            smooth=Smooth.None));
          connect(q_in, systemicArtys.q_in) annotation (Line(
            points={{100,0},{99.75,0},{99.75,0.5},{75.5,0.5}},
            color={0,0,0},
            thickness=1,
            smooth=Smooth.None));
          connect(collapsedVeins.q_out, q_out) annotation (Line(
              points={{-74.5,-1.22465e-015},{-96.25,-1.22465e-015},{-96.25,0},{
                -100,0}},
              color={0,0,0},
              thickness=1,
              smooth=Smooth.None));
          connect(busConnector.Gravity_Gz, G.u) annotation (Line(
              points={{46,50},{46,38},{34,38},{34,30.8}},
              color={0,0,255},
              thickness=0.5,
              smooth=Smooth.None), Text(
              string="%first",
              index=-1,
              extent={{-6,3},{-6,3}}));
          connect(G.y, gravityHydrostaticDifference.G) annotation (Line(
              points={{34,21.6},{34,16},{62.5,16},{62.5,26.5}},
              color={0,0,127},
              smooth=Smooth.None));
          connect(rightCororaryCirculation.busConnector, busConnector)
                                                                  annotation (
              Line(
              points={{-25.1,73.9},{46,73.9},{46,50}},
              color={0,0,255},
              thickness=0.5,
              smooth=Smooth.None));
          connect(leftCororaryCirculation.busConnector, busConnector)
                                                                 annotation (Line(
              points={{6.9,87.9},{46,87.9},{46,50}},
              color={0,0,255},
              thickness=0.5,
              smooth=Smooth.None));
          connect(leftCororaryCirculation.BloodFlow, busConnector.leftHeart_BloodFlow)
            annotation (Line(
              points={{7,84},{46,84},{46,50}},
              color={0,0,127},
              smooth=Smooth.None));
          connect(rightCororaryCirculation.BloodFlow, busConnector.rightHeart_BloodFlow)
            annotation (Line(
              points={{-25,70},{22,70},{22,50},{46,50}},
              color={0,0,127},
              smooth=Smooth.None));
          connect(leftCororaryCirculation.BloodFlow, busConnector.LeftHeart_BloodFlow)
            annotation (Line(
              points={{7,84},{46,84},{46,50}},
              color={0,0,127},
              smooth=Smooth.None), Text(
              string="%second",
              index=1,
              extent={{6,3},{6,3}}));
          connect(rightCororaryCirculation.BloodFlow, busConnector.RightHeart_BloodFlow)
            annotation (Line(
              points={{-25,70},{22,70},{22,50},{46,50}},
              color={0,0,127},
              smooth=Smooth.None));
          connect(splanchnicCirculation.busConnector, busConnector) annotation (
              Line(
              points={{-8,-15.5},{-8,50},{46,50}},
              color={0,0,255},
              thickness=0.5,
              smooth=Smooth.None));
        connect(splanchnicCirculation.q_in, systemicArtys.q_in) annotation (Line(
            points={{30,-25},{62,-25},{62,0.5},{75.5,0.5}},
            color={0,0,0},
            thickness=1,
            smooth=Smooth.None));
          connect(splanchnicCirculation.q_out,
            systemicVeinsElacticBloodCompartment.referencePoint) annotation (Line(
              points={{-8,-25},{-22,-25},{-22,0},{-44,0}},
              color={0,0,0},
              thickness=1,
              smooth=Smooth.None));
        connect(peripheral.q_in, systemicArtys.q_in) annotation (Line(
            points={{26,1.77636e-015},{52,1.77636e-015},{52,0.5},{75.5,0.5}},
            color={0,0,0},
            thickness=1,
            smooth=Smooth.None));
          connect(peripheral.q_out, systemicVeinsElacticBloodCompartment.referencePoint)
            annotation (Line(
              points={{-2,1.77636e-015},{-24,1.77636e-015},{-24,0},{-44,0}},
              color={0,0,0},
              thickness=1,
              smooth=Smooth.None));
          connect(rightCororaryCirculation.q_out, q_out) annotation (Line(
              points={{-42,72},{-60,72},{-60,86},{-100,86},{-100,0}},
              color={0,0,0},
              thickness=1,
              smooth=Smooth.None));
          connect(leftCororaryCirculation.q_out, q_out) annotation (Line(
              points={{-10,86},{-100,86},{-100,0}},
              color={0,0,0},
              thickness=1,
              smooth=Smooth.None));
          connect(leftCororaryCirculation.q_in, q_in) annotation (Line(
              points={{10,86},{100,86},{100,0}},
              color={0,0,0},
              thickness=1,
              smooth=Smooth.None));
          connect(systemicVeinsElacticBloodCompartment.referencePoint, veins.q_in)
            annotation (Line(
              points={{-44,0},{-56,0}},
              color={0,0,0},
              thickness=1,
              smooth=Smooth.None));
          connect(veins.q_out, collapsedVeins.q_in) annotation (Line(
              points={{-72,0},{-73.25,0},{-73.25,1.22465e-015},{-94.5,
                1.22465e-015}},
              color={0,0,0},
              thickness=1,
              smooth=Smooth.None));

          connect(rightCororaryCirculation.q_in, q_in) annotation (Line(
              points={{-22,72},{36,72},{36,86},{100,86},{100,0}},
              color={0,0,0},
              thickness=1,
              smooth=Smooth.None));
         annotation (Diagram(coordinateSystem(preserveAspectRatio=true, extent={{-100,
                    -100},{100,100}}), graphics={Text(
                  extent={{42,46},{74,46}},
                  lineColor={0,0,255},
                  textString="Carotid Artery Pressure")}),
                                         Icon(coordinateSystem(
                  preserveAspectRatio=true, extent={{-100,-100},{100,100}}),
                graphics={
                Text(
                  extent={{-104,-54},{110,-76}},
                  lineColor={0,0,255},
                  textString="%name")}),
          Documentation(revisions="<html>

<table>
<tr>
<td>Author:</td>
<td>Marek Matejak</td>
</tr>

<tr>
<td>License:</td>
<td><a href=\"http://www.physiomodel.org/license.html\">Physiomodel License 1.0</a> </td>
</tr>
<tr>
<td>By:</td>
<td>Charles University, Prague</td>
</tr>
<tr>
<td>Date of:</td>
<td>january 2009</td>
</tr>
<tr>
<td>References:</td>
<td>Tom Coleman: QHP 2008 beta 3, University of Mississippi Medical Center</td>
</tr>
</table>
<br/><p>Copyright &copy; 2014 Marek Matejak, Charles University in Prague.</p><br/>

</html>",   info="<html>
<p>Blood volume (and pressure) distributions between </p>
<p><ul>
<li>systemic arteries, </li>
<li>systemic veins and</li>
<li>portal (splanchnic) vein.</li>
</ul></p>
<p>Blood flow throught: </p>
<p><ul>
<li>GIT, hepatic artery, liver</li>
<li>Kidney</li>
<li>CNS</li>
<li>Skeletal muscle</li>
<li>Respiratory muscle</li>
<li>Skin</li>
<li>Bones</li>
<li>Adipose tissue</li>
<li>Other tissue</li>
</ul></p>
</html>"));
        end SystemicCirculationBase;

        model GuytonOutputPump

        Physiolibrary.Hydraulic.Interfaces.HydraulicPort_a q_in annotation (
            extent=[-10,-110; 10,-90], Placement(transformation(extent={{-10,
                  -110},{10,-90}}, rotation=0),
                              iconTransformation(extent={{-110,-10},{-90,10}})));
          Modelica.Blocks.Interfaces.RealInput inputPressure
                                                      annotation (Placement(
                transformation(extent={{-96,54},{-56,94}}), iconTransformation(
                extent={{-20,-20},{20,20}},
                rotation=270,
                origin={-80,60})));

        equation
          q_in.pressure = inputPressure;

          annotation (Icon(coordinateSystem(preserveAspectRatio=true, extent={{-100,
                    -100},{100,100}}), graphics={
                Text(
                  extent={{-104,-54},{110,-76}},
                  lineColor={0,0,255},
                  textString="%name"),
                Rectangle(
                  extent={{-100,-50},{100,50}},
                  lineColor={0,0,127},
                  fillColor={255,255,255},
                  fillPattern=FillPattern.Solid),
                Polygon(
                  points={{-80,25},{80,0},{-80,-25},{-80,25}},
                  lineColor={0,0,127},
                  fillColor={0,0,127},
                  fillPattern=FillPattern.Solid)}));
        end GuytonOutputPump;

        model GuytonPump

        Physiolibrary.Hydraulic.Interfaces.HydraulicPort_b q_out annotation (
            extent=[-10,-110; 10,-90], Placement(transformation(extent={{-10,
                  -110},{10,-90}}, rotation=0),
                              iconTransformation(extent={{90,-10},{110,10}})));
        Physiolibrary.Hydraulic.Interfaces.HydraulicPort_a q_in annotation (
            extent=[-10,-110; 10,-90], Placement(transformation(extent={{-10,
                  -110},{10,-90}}, rotation=0),
                              iconTransformation(extent={{-110,-10},{-90,10}})));
          Modelica.Blocks.Interfaces.RealInput inputPressure
                                                      annotation (Placement(
                transformation(extent={{-96,54},{-56,94}}), iconTransformation(
                extent={{-20,-20},{20,20}},
                rotation=270,
                origin={-80,60})));

        equation
          q_in.pressure = inputPressure;
          q_in.q + q_out.q = 0;

          annotation (Icon(coordinateSystem(preserveAspectRatio=true, extent={{-100,
                    -100},{100,100}}), graphics={
                Text(
                  extent={{-104,-54},{110,-76}},
                  lineColor={0,0,255},
                  textString="%name"),
                Rectangle(
                  extent={{-100,-50},{100,50}},
                  lineColor={0,0,127},
                  fillColor={255,255,255},
                  fillPattern=FillPattern.Solid),
                Polygon(
                  points={{-80,25},{80,0},{-80,-25},{-80,25}},
                  lineColor={0,0,127},
                  fillColor={0,0,127},
                  fillPattern=FillPattern.Solid)}));
        end GuytonPump;

        model SystemicVeinsElacticBloodCompartment2
         extends Physiolibrary.Icons.ElasticBalloon;

        Physiolibrary.Hydraulic.Interfaces.HydraulicPort_a referencePoint
          annotation (extent=[-10,-110; 10,-90], Placement(transformation(extent={{-10,
                  -110},{10,-90}}, rotation=0),
                                          iconTransformation(
              extent={{-10,-10},{10,10}})));
          Modelica.Blocks.Interfaces.RealInput ExternalPressure(
                                                              final quantity="Pressure", final displayUnit="mmHg")
          "external pressure around the compartment"                              annotation (extent = [-10,90;10,110], rotation = -90,
          Placement(transformation(
              origin={0,100},
              extent={{-10,-10},{10,10}},
              rotation=270)));
          Modelica.Blocks.Interfaces.RealInput Compliance(
                                                        final quantity="Compliance", final displayUnit="ml/mmHg")
          "elasticity of the stressed walls"                               annotation (extent = [50,90;70,110], rotation = -90,
          Placement(transformation(
              origin={60,100},
              extent={{-10,-10},{10,10}},
              rotation=270)));

          Modelica.Blocks.Interfaces.RealOutput Pressure(  final quantity="Pressure", final displayUnit="mmHg")
          "blod pressure in compartment"
            annotation (Placement(transformation(extent={{30,-110},{50,-90}}, rotation=-90)));
        Physiolibrary.Types.BusConnector busConnector annotation (Placement(
              transformation(extent={{-88,72},{-68,92}}), iconTransformation(
                extent={{88,51},{108,71}})));
        Physiolibrary.Blocks.Factors.Spline V0_A2_Effect(data={{0.0,1.05,0.0},{
              1.3,1.00,-0.10},{3.0,0.85,0.0}})
          annotation (Placement(transformation(extent={{-30,7},{-10,27}})));
        Physiolibrary.Types.Constants.VolumeConst V0_Base(k=0.0018298)
          annotation (Placement(transformation(extent={{-32,48},{-23,39}})));
          Physiomodel.Nerves.AplhaReceptorsActivityFactor AplhaReceptors(
            NEURALK=0.333,
            HUMORALK=0.5,
            data={{0.0,1.2,0.0},{1.0,1.0,-0.30},{3.0,0.6,0.0}})
            annotation (Placement(transformation(extent={{-30,20},{-10,40}})));
          Modelica.Blocks.Interfaces.RealOutput V0(final quantity="Volume", final displayUnit="ml")
          "maximal zero pressure blood volume in compartment"
            annotation (Placement(transformation(extent={{-4.5,-4.5},{4.5,4.5}},rotation=180,
                origin={-27.5,5.5}),
                iconTransformation(
                extent={{-10,-10},{10,10}},
                rotation=90,
                origin={-68,100})));

          parameter Real initialSystemisVeinsVol(final quantity="Volume", final unit =   "ml")= 2329.57; // = 2200;// = 2980;

          Modelica.Blocks.Interfaces.RealOutput NormalizedVolume(final quantity=
                "NormalizedVolume", final displayUnit="1")
          "maximal zero pressure blood volume in compartment"
            annotation (Placement(transformation(extent={{-4.5,-4.5},{4.5,4.5}},origin={22.5,9.5}),
                iconTransformation(
                extent={{-10,-10},{10,10}},
                rotation=180,
                origin={-100,56})));
          Modelica.Blocks.Interfaces.RealInput BloodVolume
                                                    annotation (Placement(
                transformation(
                extent={{-20,-20},{20,20}},
                rotation=90,
                origin={-40,-100})));

          Real StressedVolume(   final quantity="Volume", final displayUnit="ml");

        equation
          StressedVolume = max(BloodVolume-V0,0);
          Pressure = (StressedVolume/Compliance) + ExternalPressure;
          referencePoint.pressure = Pressure;

          NormalizedVolume = if initialSystemisVeinsVol==0 then 0 else BloodVolume/initialSystemisVeinsVol;

          connect(AplhaReceptors.y,V0_A2_Effect. yBase) annotation (Line(
              points={{-20,23},{-20,19}},
              color={0,0,127},
              smooth=Smooth.None));
          connect(AplhaReceptors.yBase, V0_Base.y)
                                                  annotation (Line(
              points={{-20,37},{-20,43.5},{-21.875,43.5}},
              color={0,0,127},
              smooth=Smooth.None));
          connect(busConnector.A2Pool_Log10Conc, V0_A2_Effect.u) annotation (
              Line(
              points={{-78,82},{-78,17},{-28,17}},
              color={0,0,255},
              thickness=0.5,
              smooth=Smooth.None), Text(
              string="%first",
              index=-1,
              extent={{-6,3},{-6,3}}));
          connect(busConnector.GangliaGeneral_NA, AplhaReceptors.GangliaGeneral_NA)
            annotation (Line(
              points={{-78,82},{-78,24},{-29.8,24}},
              color={0,0,255},
              thickness=0.5,
              smooth=Smooth.None), Text(
              string="%first",
              index=-1,
              extent={{-6,3},{-6,3}}));
          connect(busConnector.AlphaPool_Effect, AplhaReceptors.AlphaPool_Effect)
            annotation (Line(
              points={{-78,82},{-78,36},{-29.8,36}},
              color={0,0,255},
              thickness=0.5,
              smooth=Smooth.None), Text(
              string="%first",
              index=-1,
              extent={{-6,3},{-6,3}}));
          connect(busConnector.AlphaBlocade_Effect, AplhaReceptors.AlphaBlockade_Effect)
            annotation (Line(
              points={{-78,82},{-78,30},{-29.8,30}},
              color={0,0,255},
              thickness=0.5,
              smooth=Smooth.None), Text(
              string="%first",
              index=-1,
              extent={{-6,3},{-6,3}}));
          connect(V0_A2_Effect.y, V0) annotation (Line(
              points={{-20,13},{-20,5.5},{-27.5,5.5}},
              color={0,0,127},
              smooth=Smooth.None));

         annotation (
            Documentation(info="<HTML>
<PRE>
  Elastic blood flow compartment.
</PRE>
</HTML>
",       revisions="<html>

<table>
<tr>
<td>Author:</td>
<td>Marek Matejak</td>
</tr>

<tr>
<td>License:</td>
<td><a href=\"http://www.physiomodel.org/license.html\">Physiomodel License 1.0</a> </td>
</tr>
<tr>
<td>By:</td>
<td>Charles University, Prague</td>
</tr>
<tr>
<td>Date of:</td>
<td>january 2009</td>
</tr>
<tr>
<td>References:</td>
<td>Tom Coleman: QHP 2008 beta 3, University of Mississippi Medical Center</td>
</tr>
</table>
<br/><p>Copyright &copy; 2014 Marek Matejak, Charles University in Prague.</p><br/>

</html>"));
        end SystemicVeinsElacticBloodCompartment2;

        model VascularElasticBloodCompartment
          extends Physiolibrary.SteadyStates.Interfaces.SteadyState;
          extends
          Physiomodel.CardioVascular.Circulation.Interfaces.IVascularElasticBloodCompartment;

          Real StressedVolume(   final quantity="Volume", final displayUnit="ml");

          Modelica.Blocks.Interfaces.RealOutput NormalizedVolume(final quantity="NormalizedVolume",
              final displayUnit="1")
          "actual volume divided by standard compartement volume"
            annotation (Placement(transformation(extent={{-10,-10},{10,10}},
                rotation=270,
                origin={-40,-100}), iconTransformation(
                extent={{-10,-10},{10,10}},
                origin={100,60})));
        //initial equation
        //  Vol = initialVol;
         // der(Vol) = 0;
        equation

          StressedVolume = max(Vol-V0,0);
          Pressure = (StressedVolume/Compliance) + ExternalPressure;
          referencePoint.pressure = Pressure;

          NormalizedVolume = if initialVol==0 then 0 else Vol/initialVol;

        state = Vol;
          change = referencePoint.q/60;

         annotation (
            preferredView = text,
            Documentation(info="<HTML>
<PRE>
  Elastic blood flow compartment.
</PRE>
</HTML>
",       revisions="<html>

<table>
<tr>
<td>Author:</td>
<td>Marek Matejak</td>
</tr>

<tr>
<td>License:</td>
<td><a href=\"http://www.physiomodel.org/license.html\">Physiomodel License 1.0</a> </td>
</tr>
<tr>
<td>By:</td>
<td>Charles University, Prague</td>
</tr>
<tr>
<td>Date of:</td>
<td>january 2009</td>
</tr>
<tr>
<td>References:</td>
<td>Tom Coleman: QHP 2008 beta 3, University of Mississippi Medical Center</td>
</tr>
</table>
<br/><p>Copyright &copy; 2014 Marek Matejak, Charles University in Prague.</p><br/>

</html>"),   Icon(coordinateSystem(preserveAspectRatio=true,  extent={{-100,-100},
                    {100,100}}), graphics={Text(
                  extent={{-100,-16},{100,-32}},
                  lineColor={0,0,255},
                  textString="(initial %initialVol ml)")}));
        end VascularElasticBloodCompartment;
      end develop;
    annotation (Documentation(revisions="<html>
</html>"));
    end Circulation;

    package Microcirculation
    "Tissue vessels hydraulic conductance (=1/resistance)"
      class References "References"
        extends Modelica.Icons.References;

        annotation (Documentation(info="<html>
<table>

	<tr>
		<td>[Archer1996]</td>
		<td>S. L. Archer, J. M. C. Huang, H. L. Reeve, V. Hampl, S. Tolarová, E. Michelakis, et al., \"Differential Distribution of Electrophysiologically Distinct Myocytes in Conduit and Resistance Arteries Determines Their Response to Nitric Oxide and Hypoxia,\" Circulation Research, vol. 78, pp. 431-442, March 1, 1996 1996. </td>
	</tr>
	<tr>
		<td>[Aukland1989]</td>
		<td>K. Aukland, \"Myogenic mechanisms in the kidney,\" Journal of hypertension. Supplement: official journal of the International Society of Hypertension, vol. 7, pp. S71-6; discussion S77, 1989. </td>
	</tr>
	<tr>
		<td>[Berg1997]</td>
		<td>B. R. Berg, K. D. Cohen, and I. H. Sarelius, \"Direct coupling between blood flow and metabolism at the capillary level in striated muscle,\" American Journal of Physiology-Heart and Circulatory Physiology, vol. 41, p. H2693, 1997. </td>
	</tr>
	<tr>
		<td>[Borgström1975]</td>
		<td>L. Borgström, H. Jóhannsson, and B. K. Siesjö, \"The Relationship between Arterial PO2 and Cerebral Blood Flow in Hypoxic Hypoxia,\" Acta Physiologica Scandinavica, vol. 93, pp. 423-432, 1975. </td>
	</tr>
	<tr>
		<td>[BRADLEY1952]</td>
		<td>S. E. BRADLEY, F. J. INGELFINGER, and G. P. BRADLEY, \"Hepatic Circulation in Cirrhosis of the Liver,\" Circulation, vol. 5, pp. 419-429, March 1, 1952 1952. </td>
	</tr>
	<tr>
		<td>[Bradley1953]</td>
		<td>S. E. Bradley, P. A. Marks, P. C. Reynell, and J. Meltzer, \"The circulating splanchnic blood volume in dog and man,\" Trans Assoc Am Physicians, vol. 66, pp. 294-302, 1953. </td>
	</tr>
	<tr>
		<td>[Breslow1993]</td>
		<td>M. J. Breslow, J. R. Tobin, D. S. Bredt, C. D. Ferris, S. H. Snyder, and R. J. Traystman, Nitric oxide as a regulator of adrenal blood flow vol. 264, 1993. </td>
	</tr>
	<tr>
		<td>[Burattini1994]</td>
		<td>R. Burattini, P. Borgdorff, and N. Westerhof, \"Relationship between strength of short-term systemic autoregulation and initial resistance,\" American Journal of Physiology-Regulatory Integrative and Comparative Physiology, vol. 36, p. R1182, 1994. </td>
	</tr>
	<tr>
		<td>[Coleman1972]</td>
		<td>T. G. Coleman, R. D. Manning, Jr., R. A. Norman, Jr., and A. C. Guyton, \"Dynamics of water-isotope distribution,\" Am J Physiol, vol. 223, pp. 1371-5, Dec 1972. </td>
	</tr>
	<tr>
		<td>[Davidson1986]</td>
		<td>D. Davidson, S. A. Stalcup, and R. B. Mellins, Systemic hemodynamics affecting cardiac output during hypocapnic and hypercapnic hypoxia vol. 60, 1986. </td>
	</tr>
	<tr>
		<td>[Drummond2008]</td>
		<td>H. A. Drummond, S. C. Grifoni, and N. L. Jernigan, \"A new trick for an old dogma: ENaC proteins as mechanotransducers in vascular smooth muscle,\" Physiology, vol. 23, pp. 23-31, 2008. </td>
	</tr>
	<tr>
		<td>[Fitzgerald1980]</td>
		<td>G. A. Fitzgerald, P. Barnes, C. A. Hamilton, and C. T. Dollery, \"Circulating adrenaline and blood pressure: the metabolic effects and kinetics of infused adrenaline in man,\" European Journal of Clinical Investigation, vol. 10, pp. 401-406, 1980. </td>
	</tr>
	<tr>
		<td>[Frisbee2000]</td>
		<td>J. C. Frisbee and J. H. Lombard, \"Increased Intravascular Pressure Does Not Enhance Skeletal Muscle Arteriolar Constriction to Oxygen or Angiotensin II,\" Microvascular Research, vol. 59, pp. 176-180, 1// 2000. </td>
	</tr>
	<tr>
		<td>[Frisbee2000]</td>
		<td>J. C. Frisbee and J. H. Lombard, \"Short-term angiotensin converting enzyme inhibition reduces basal tone and dilator reactivity in skeletal muscle arterioles*,\" American Journal of Hypertension, vol. 13, pp. 389-395, April 1, 2000 2000. </td>
	</tr>
	<tr>
		<td>[Gibbs1942]</td>
		<td>E. L. Gibbs, F. A. Gibbs, W. G. Lennox, and L. F. Nims, \"REgulation of cerebral carbon dioxide,\" Archives of Neurology & Psychiatry, vol. 47, pp. 879-889, 1942. </td>
	</tr>
	<tr>
		<td>[Goodman1978]</td>
		<td>A. H. Goodman, R. Einstein, and H. J. Granger, \"Effect of changing metabolic rate on local blood flow control in the canine hindlimb,\" Circulation Research, vol. 43, pp. 769-76, November 1, 1978 1978. </td>
	</tr>
	<tr>
		<td>[Granger1969]</td>
		<td>H. J. Granger and A. C. Guyton, \"Autoregulation of the Total Systemic Circulation Following Destruction of the Central Nervous System in the Dog,\" Circulation Research, vol. 25, pp. 379-388, October 1, 1969 1969. </td>
	</tr>
	<tr>
		<td>[Granger1976]</td>
		<td>H. J. Granger, A. H. Goodman, and D. N. Granger, \"Role of resistance and exchange vessels in local microvascular control of skeletal muscle oxygenation in the dog,\" Circulation Research, vol. 38, pp. 379-85, May 1, 1976 1976. </td>
	</tr>
	<tr>
		<td>[Greenway1973]</td>
		<td>C. Greenway and G. Oshiro, \"Effects of histamine on hepatic volume (outflow block) in anaesthetized dogs,\" British journal of pharmacology, vol. 47, pp. 282-290, 1973. </td>
	</tr>
	<tr>
		<td>[Greenway1974]</td>
		<td>C. V. Greenway and G. E. Lister, \"Capacitance effects and blood reservoir function in the splanchnic vascular bed during non-hypotensive haemorrhage and blood volume expansion in anaesthetized cats,\" The Journal of Physiology, vol. 237, pp. 279-294, March 1, 1974 1974. </td>
	</tr>
	<tr>
		<td>[Greenway1985]</td>
		<td>C. V. Greenway, K. L. Seaman, and I. R. Innes, Norepinephrine on venous compliance and unstressed volume in cat liver vol. 248, 1985. </td>
	</tr>
	<tr>
		<td>[Gutsche1980]</td>
		<td>H. U. Gutsche, R. Müller-Suur, U. Hegel, and K. Hierholzer, \"Electrical conductivity of tubular fluid of the rat nephron,\" Pflügers Archiv, vol. 383, pp. 113-121, 1980/01/01 1980. </td>
	</tr>
	<tr>
		<td>[Harder1996]</td>
		<td>D. R. Harder, J. Narayanan, E. K. Birks, J. F. Liard, J. D. Imig, J. H. Lombard, et al., \"Identification of a Putative Microvascular Oxygen Sensor,\" Circulation Research, vol. 79, pp. 54-61, July 1, 1996 1996. </td>
	</tr>
	<tr>
		<td>[Harder1996]</td>
		<td>D. R. Harder, J. Narayanan, E. K. Birks, J. F. Liard, J. D. Imig, J. H. Lombard, et al., \"Identification of a Putative Microvascular Oxygen Sensor,\" Circulation Research, vol. 79, pp. 54-61, July 1, 1996 1996. </td>
	</tr>
	<tr>
		<td>[Heyeraas1987]</td>
		<td>K. J. Heyeraas and K. Aukland, \"Interlobular arterial resistance: Influence of renal arterial pressure and angiotensin II,\" Kidney Int, vol. 31, pp. 1291-1298, 06//print 1987. </td>
	</tr>
	<tr>
		<td>[Hogan1990]</td>
		<td>M. C. Hogan, D. E. Bebout, A. T. Gray, P. D. Wagner, J. B. West, and P. E. Haab, Muscle maximal O2 uptake at constant O2 delivery with and without CO in the blood vol. 69, 1990. </td>
	</tr>
	<tr>
		<td>[Ito1990]</td>
		<td>S. Ito and O. A. Carretero, \"An in vitro approach to the study of macula densa-mediated glomerular hemodynamics,\" Kidney Int, vol. 38, pp. 1206-10, Dec 1990. </td>
	</tr>
	<tr>
		<td>[Ito1992]</td>
		<td>S. Ito, O. A. Carretero, K. Abe, L. A. Juncos, and K. Yoshinaga, \"Macula Densa Control of Renin Release and Glomerular Hemodynamics,\" The Tohoku Journal of Experimental Medicine, vol. 166, pp. 27-39, 1992. </td>
	</tr>
	<tr>
		<td>[Itoh1985]</td>
		<td>S. Itoh and O. A. Carretero, \"Role of the macula densa in renin release,\" Hypertension, vol. 7, p. I49, 1985. </td>
	</tr>
	<tr>
		<td>[Kety1948]</td>
		<td>S. S. Kety and C. F. Schmidt, \"THE EFFECTS OF ALTERED ARTERIAL TENSIONS OF CARBON DIOXIDE AND OXYGEN ON CEREBRAL BLOOD FLOW AND CEREBRAL OXYGEN CONSUMPTION OF NORMAL YOUNG MEN 1,\" The Journal of Clinical Investigation, vol. 27, pp. 484-492, 1948. </td>
	</tr>
	<tr>
		<td>[Kunert1996]</td>
		<td>M. P. Kunert, J. F. Liard, D. J. Abraham, and J. H. Lombard, \"Low-Affinity Hemoglobin Increases Tissue PO2and Decreases Arteriolar Diameter and Flow in the Rat Cremaster Muscle,\" Microvascular Research, vol. 52, pp. 58-68, 7// 1996. </td>
	</tr>
	<tr>
		<td>[Kuwahira1993]</td>
		<td>I. Kuwahira, N. Heisler, J. Piiper, and N. C. Gonzalez, \"Effect of chronic hypoxia on hemodynamics, organ blood flow and O2 supply in rats,\" Respiration Physiology, vol. 92, pp. 227-238, 5// 1993. </td>
	</tr>
	<tr>
		<td>[Laine1979]</td>
		<td>G. A. Laine, J. T. Hall, S. H. Laine, and J. Granger, \"Transsinusoidal fluid dynamics in canine liver during venous hypertension,\" Circulation Research, vol. 45, pp. 317-23, September 1, 1979 1979. </td>
	</tr>
	<tr>
		<td>[Lash1987]</td>
		<td>J. M. Lash and H. G. Bohlen, Perivascular and tissue PO2 in contracting rat spinotrapezius muscle vol. 252, 1987. </td>
	</tr>
	<tr>
		<td>[Lassen1959]</td>
		<td>N. A. Lassen, Cerebral blood flow and oxygen consumption in man: Am Physiological Soc, 1959. </td>
	</tr>
	<tr>
		<td>[Lautt1987]</td>
		<td>W. W. Lautt, C. V. Greenway, and D. J. Legare, \"Effect of hepatic nerves, norepinephrine, angiotensin, and elevated central venous pressure on postsinusoidal resistance sites and intrahepatic pressures in cats,\" Microvascular Research, vol. 33, pp. 50-61, 1// 1987. </td>
	</tr>
	<tr>
		<td>[Maass-Moreno1992]</td>
		<td>R. Maass-Moreno and C. F. Rothe, \"Contribution of the large hepatic veins to postsinusoidal vascular resistance,\" Am J Physiol Gastrointest Liver Physiol, vol. 262, pp. G14-G22, 1992. </td>
	</tr>
	<tr>
		<td>[Malo1984]</td>
		<td>J. Malo, H. Goldberg, R. Graham, H. Unruh, and C. Skoog, Effect of hypoxic hypoxia on systemic vasculature vol. 56, 1984. </td>
	</tr>
	<tr>
		<td>[Manning1987]</td>
		<td>R. D. Manning, Renal hemodynamic, fluid volume, and arterial pressure changes during hyperproteinemia vol. 252, 1987. </td>
	</tr>
	<tr>
		<td>[Manning1990]</td>
		<td>R. D. Manning, Effects of hypoproteinemia on blood volume and arterial pressure of volume-loaded dogs vol. 259, 1990. </td>
	</tr>
	<tr>
		<td>[Manning1983]</td>
		<td>R. D. Manning and A. C. Guyton, Effects of hypoproteinemia on fluid volumes and arterial pressure vol. 245, 1983. </td>
	</tr>
	<tr>
		<td>[Marshall1995]</td>
		<td>J. Marshall, Skeletal Muscle Vasculature and Systemic Hypoxia vol. 10, 1995. </td>
	</tr>
	<tr>
		<td>[Marshall1988]</td>
		<td>J. M. Marshall and J. D. Metcalfe, \"Analysis of the cardiovascular changes induced in the rat by graded levels of systemic hypoxia,\" The Journal of Physiology, vol. 407, pp. 385-403, December 1, 1988 1988. </td>
	</tr>
	<tr>
		<td>[Metting1988]</td>
		<td>P. J. Metting, J. R. Strader, and S. L. Britton, Evaluation of whole body autoregulation in conscious dogs vol. 255, 1988. </td>
	</tr>
	<tr>
		<td>[Metting1989]</td>
		<td>P. J. Metting, P. M. Stein, B. A. Stoos, K. A. Kostrzewski, and S. L. Britton, Systemic vascular autoregulation amplifies pressor responses to vasoconstrictor agents vol. 256, 1989. </td>
	</tr>
	<tr>
		<td>[Mitzner1974]</td>
		<td>W. Mitzner, Hepatic outflow resistance, sinusoid pressure, and the vascular waterfall vol. 227, 1974. </td>
	</tr>
	<tr>
		<td>[Moore1990]</td>
		<td>L. C. Moore and D. Casellas, \"Tubuloglomerular feedback dependence of autoregulation in rat juxtamedullary afferent arterioles,\" Kidney Int, vol. 37, pp. 1402-1408, 06//print 1990. </td>
	</tr>
	<tr>
		<td>[POHOST1976]</td>
		<td>G. M. POHOST, J. B. NEWELL, N. P. HAMLIN, and W. J. POWELL, \"Observations on autoregulation in skeletal muscle: the effects of arterial hypoxia,\" Cardiovascular Research, vol. 10, pp. 405-412, July 1, 1976 1976. </td>
	</tr>
	<tr>
		<td>[Prewitt1976]</td>
		<td>R. L. Prewitt and P. C. Johnson, \"The effect of oxygen on arteriolar red cell velocity and capillary density in the rat cremaster muscle,\" Microvascular Research, vol. 12, pp. 59-70, 7// 1976. </td>
	</tr>
	<tr>
		<td>[Reivich1964]</td>
		<td>M. Reivich, Arterial Pco2 and cerebral hemodynamics vol. 206, 1964. </td>
	</tr>
	<tr>
		<td>[Sage1981]</td>
		<td>J. I. Sage, R. L. Van Uitert, and T. E. Duffy, \"Simultaneous Measurement of Cerebral Blood Flow and Unidirectional Movement of Substances Across the Blood-Brain Barrier: Theory, Method, and Application to Leucine,\" Journal of Neurochemistry, vol. 36, pp. 1731-1738, 1981. </td>
	</tr>
	<tr>
		<td>[Skarlatos1993]</td>
		<td>S. Skarlatos, N. DiPaola, R. A. Frankel, R. W. Pomerantz, P. H. Brand, P. J. Metting, et al., \"Spontaneous pressure-flow relationships in renal circulation of conscious dogs,\" Am J Physiol, vol. 264, pp. H1517-27, May 1993. </td>
	</tr>
	<tr>
		<td>[Skov1996]</td>
		<td>K. Skov, J. Fenger-Gron, and M. J. Mulvany, \"Effects of an angiotensin-converting enzyme inhibitor, a calcium antagonist, and an endothelin receptor antagonist on renal afferent arteriolar structure,\" Hypertension, vol. 28, pp. 464-471, 1996. </td>
	</tr>
	<tr>
		<td>[Stainsby1973]</td>
		<td>W. N. Stainsby, \"Local Control of Regional Blood Flow,\" Annual Review of Physiology, vol. 35, pp. 151-168, 1973. </td>
	</tr>
[SchumackerS. P. T. and C. S. M., \"The concept of a critical oxygen delivery,\" Intensive Care Medicine, vol. 13, pp. 223-229, January 1, 0001.
	<tr>
		<td>[Weber2000]</td>
		<td>D. S. Weber and J. H. Lombard, Elevated salt intake impairs dilation of rat skeletal muscle resistance arteries via ANG II suppression vol. 278, 2000. </td>
	</tr>
	<tr>
		<td>[Whalen1974]</td>
		<td>W. Whalen, P. Nair, D. Buerk, and C. Thuning, \"Tissue PO2 in normal and denervated cat skeletal muscle,\" Am J Physiol, vol. 227, pp. 1221-1225, 1974. </td>
	</tr>
	<tr>
		<td>[Williams1989]</td>
		<td>L. R. Williams and R. W. Leggett, \"Reference values for resting blood flow to organs of man,\" Clinical Physics and Physiological Measurement, vol. 10, p. 187, 1989.  </td>
	</tr>


</table>
</html>"));
      end References;

      model TissueBloodFlow
        extends Physiolibrary.Icons.Microcirculation;
        parameter Physiolibrary.Types.HydraulicConductance Cond;

        parameter Boolean onViscosity=true, onAnesthesia=true, onAngiogenesis=true, onAngiotensinII=true, onVasopressin=true, onCatecholamines=true, onOxygenOnly=true, onOxygenAndCarbonDioxide=false, onOxygenNeed=false, onExercise=false;

        parameter Real[:,3] VasculatureConductanceOnPO2 = {{41,1.2,0},{51,1.0,-0.03},{61,0.8,0}};
        parameter Real[:,3] PO2OnConductance = {{10,2.0,0},{30,1.0,0}};
        parameter Real[:,3] Angiotensin2Effect = {{0.0,1.05,0},{1.3,1.00,-0.08},{3.5,0.50,0}};
        parameter Real[:,3] AlphaReceptorsEffect = {{0.0,1.3,0},{1.0,1.0,-0.3},{5.0,0.1,0}};
        parameter Real[:,3] VasopressinEffect = {{0.8,1.0,0},{3.0,0.1,0}};
        parameter Physiolibrary.Types.Time VasculatureHalfTime=30*86400*Modelica.Math.log(2);

      Physiolibrary.Blocks.Factors.Spline A2Effect(
        Xscale=1e-9/Substances.AngiotensinII.mw,
        UsePositiveLog10=true,
          data=Angiotensin2Effect,
          enabled=onAngiotensinII)
        annotation (Placement(transformation(extent={{-8,40},{12,60}})));
      Physiolibrary.Blocks.Factors.Spline ADHEffect(
        Xscale=1e-9/Substances.Vasopressin.mw,
        UsePositiveLog10=true,
          data=VasopressinEffect,
          enabled=onVasopressin) "0.8 pg/ml = 0.8e-9 kg/m3"
        annotation (Placement(transformation(extent={{-8,30},{12,50}})));
      Physiolibrary.Types.Constants.HydraulicConductanceConst BasicConductance(k=Cond)
        annotation (Placement(transformation(extent={{-18,76},{-6,88}})));
      Physiolibrary.Blocks.Factors.Normalization Anesthesia(enabled=onAnesthesia)
        annotation (Placement(transformation(extent={{-8,50},{12,70}})));
      Physiolibrary.Blocks.Factors.Normalization Viscosity(enabled=onViscosity)
        annotation (Placement(transformation(extent={{-8,58},{12,78}})));
        Physiolibrary.Blocks.Factors.SplineLagOrZero              Vasculature(
          stateName="GITract-Vasculature.Effect",
        Xscale=101325/760,
          data=VasculatureConductanceOnPO2,
          HalfTime=VasculatureHalfTime,
          enabled=onAngiogenesis)
          annotation (Placement(transformation(extent={{-8,-18},{12,2}})));
        Physiomodel.Nerves.AplhaReceptorsActivityFactor AplhaReceptors(data=
              AlphaReceptorsEffect,
          Switch=not onCatecholamines,
          Setting=1)
          annotation (Placement(transformation(extent={{-8,16},{12,36}})));
      Physiolibrary.Hydraulic.Components.Conductor resistor(useConductanceInput=true)
          annotation (Placement(transformation(extent={{12,-100},{-8,-80}})));
      Physiolibrary.Blocks.Factors.Spline pO2OnConductance(
                     Xscale=101325/760, data=PO2OnConductance,
        enabled=onOxygenOnly)
        annotation (Placement(transformation(extent={{-8,-28},{12,-8}})));

      Physiolibrary.Types.TissueBusConnector tissueConnector annotation (
          Placement(transformation(extent={{-94,0},{-74,20}}),
            iconTransformation(extent={{-20,60},{20,100}})));
      Physiolibrary.Blocks.Factors.Spline TensionEffect(data={{0.0,2.2,0},{1.0,
            1.0,-0.5},{2.0,0.6,0}}, enabled=onOxygenAndCarbonDioxide)
        annotation (Placement(transformation(extent={{-8,-72},{12,-52}})));
      Physiolibrary.Blocks.Factors.Spline PO2OnTension(data={{22,0.0,0},{36,1.0,
            0.02},{60,1.2,0}}, Xscale=101325/760,
        enabled=onOxygenAndCarbonDioxide)
        annotation (Placement(transformation(extent={{-28,-48},{-8,-28}})));
      Physiolibrary.Blocks.Factors.Spline PCO2OnTension(
                                    Xscale=101325/760,
        enabled=onOxygenAndCarbonDioxide,
        data={{20,1.8,0},{55,1.0,-0.05},{75,0.0,0}})
        "FIX: normal venous pCO2 in brain to 55mmHg (because of RQ close to 1)"
        annotation (Placement(transformation(extent={{-28,-56},{-8,-36}})));
        Physiolibrary.Types.Constants.OneConst one
          annotation (Placement(transformation(extent={{-30,-30},{-22,-22}})));
      MetabolicVasodilation metabolicVasolidation(
        data={{50,1.0,0},{1000,3.5,0.003},{3000,5.5,0}},
        stateName="SkeletalMuscle-MetabolicVasodilation.Effect",
        Xscale=1/1362657.193569,
        OnTau(displayUnit="min") = 12,
        OffTau(displayUnit="min") = 60,
        enabled=onOxygenNeed)
        annotation (Placement(transformation(extent={{-8,-82},{12,-62}})));
      Physiolibrary.Blocks.Factors.Normalization MusclePumping_SkeletalMuscle(enabled=
              onExercise)
        annotation (Placement(transformation(extent={{12,-2},{-8,18}})));
      Physiolibrary.Blocks.Math.Add add(k=1)
        annotation (Placement(transformation(extent={{4,-4},{-4,4}},
              rotation=90,
              origin={32,18})));
      Physiolibrary.Blocks.Factors.Spline RateEffect(data={{0,0.0,0.04},{60,1.0,
            0.0}}, Xscale=1/60,
          enabled=onExercise)
        annotation (Placement(transformation(extent={{42,20},{22,40}})));
      Physiolibrary.Blocks.Factors.Spline IntensityEffect(data={{0,0.0,0.007},{
            300,1.0,0.0}}, enabled=onExercise)
        annotation (Placement(transformation(extent={{42,30},{22,50}})));
        Physiolibrary.Types.Constants.OneConst one1
          annotation (Placement(transformation(extent={{20,52},{28,60}})));
      Physiolibrary.Hydraulic.Interfaces.HydraulicPort_a q_in "Blood inflow"
        annotation (extent=[-10,-110; 10,-90], Placement(transformation(extent={{-10,
                -110},{10,-90}}, rotation=0),
                                      iconTransformation(extent={{90,-10},{110,
                10}})));
      Physiolibrary.Hydraulic.Sensors.FlowMeasure flowMeasure annotation (
          Placement(transformation(
            extent={{10,-10},{-10,10}},
            origin={58,-90})));
      Physiolibrary.Hydraulic.Interfaces.HydraulicPort_b q_out "Blood outflow"
        annotation (extent=[-10,-110; 10,-90], Placement(transformation(extent={{-10,
                -110},{10,-90}}, rotation=0),
                                        iconTransformation(extent={{-110,-10},{
                -90,10}})));
        Modelica.Blocks.Interfaces.RealOutput BloodFlow
                                                 annotation (Placement(transformation(
                extent={{78,-68},{90,-56}}), iconTransformation(extent={{60,-60},{80,
                  -40}})));
      Physiolibrary.Types.BusConnector busConnector
        "signals of organ bood flow resistence" annotation (Placement(
            transformation(extent={{-100,80},{-80,100}}), iconTransformation(
              extent={{60,40},{100,80}})));
      equation
        connect(Vasculature.y,pO2OnConductance. yBase) annotation (Line(
            points={{2,-14},{2,-16}},
            color={0,0,127},
            smooth=Smooth.None));
        connect(Viscosity.y, Anesthesia.yBase) annotation (Line(
            points={{2,64},{2,62}},
            color={0,0,127},
            smooth=Smooth.None));
        connect(BasicConductance.y, Viscosity.yBase)         annotation (Line(
            points={{-4.5,82},{2,82},{2,70}},
            color={0,0,127},
            smooth=Smooth.None));
        connect(busConnector.AlphaBlocade_Effect, AplhaReceptors.AlphaBlockade_Effect)
          annotation (Line(
            points={{-90,90},{-60,90},{-60,26},{-7.8,26}},
            color={0,0,255},
            thickness=0.5,
            smooth=Smooth.None), Text(
            string="%first",
            index=-1,
            extent={{-6,3},{-6,3}}));
        connect(busConnector.AlphaPool_Effect, AplhaReceptors.AlphaPool_Effect)
          annotation (Line(
            points={{-90,90},{-60,90},{-60,32},{-7.8,32}},
            color={0,0,255},
            thickness=0.5,
            smooth=Smooth.None), Text(
            string="%first",
            index=-1,
            extent={{-6,3},{-6,3}}));
        connect(busConnector.GangliaGeneral_NA, AplhaReceptors.GangliaGeneral_NA)
          annotation (Line(
            points={{-90,90},{-60,90},{-60,20},{-7.8,20}},
            color={0,0,255},
            thickness=0.5,
            smooth=Smooth.None), Text(
            string="%first",
            index=-1,
            extent={{-6,3},{-6,3}}));
        connect(busConnector.Anesthesia_VascularConductance, Anesthesia.u)
          annotation (Line(
            points={{-90,90},{-60,90},{-60,60},{-6,60}},
            color={0,0,255},
            thickness=0.5,
            smooth=Smooth.None), Text(
            string="%first",
            index=-1,
            extent={{-6,3},{-6,3}}));
        connect(busConnector.Viscosity_ConductanceEffect, Viscosity.u) annotation (
            Line(
            points={{-90,90},{-60,90},{-60,68},{-6,68}},
            color={0,0,255},
            thickness=0.5,
            smooth=Smooth.None), Text(
            string="%first",
            index=-1,
            extent={{-6,3},{-6,3}}));
        connect(busConnector.Vasopressin, ADHEffect.u) annotation (Line(
            points={{-90,90},{-60,90},{-60,40},{-6,40}},
            color={0,0,255},
            thickness=0.5,
            smooth=Smooth.None), Text(
            string="%first",
            index=-1,
            extent={{-6,3},{-6,3}}));
        connect(busConnector.Angiotensin2, A2Effect.u) annotation (Line(
            points={{-90,90},{-60,90},{-60,50},{-6,50}},
            color={0,0,255},
            thickness=0.5,
            smooth=Smooth.None), Text(
            string="%first",
            index=-1,
            extent={{-6,3},{-6,3}}));
      connect(tissueConnector.pO2, Vasculature.u) annotation (Line(
          points={{-84,10},{-60,10},{-60,-10},{-8,-10}},
          color={127,0,0},
          thickness=0.5,
          smooth=Smooth.None), Text(
          string="%first",
          index=-1,
          extent={{-6,3},{-6,3}}));
      connect(tissueConnector.pO2, pO2OnConductance.u) annotation (Line(
          points={{-84,10},{-60,10},{-60,-18},{-6,-18}},
          color={127,0,0},
          thickness=0.5,
          smooth=Smooth.None), Text(
          string="%first",
          index=-1,
          extent={{-6,3},{-6,3}}));
        connect(PO2OnTension.y,PCO2OnTension. yBase) annotation (Line(
            points={{-18,-42},{-18,-44}},
            color={0,0,127},
            smooth=Smooth.None));
        connect(TensionEffect.u,PCO2OnTension. y) annotation (Line(
            points={{-6,-62},{-18,-62},{-18,-50}},
            color={0,0,127},
            smooth=Smooth.None));
        connect(one.y, PO2OnTension.yBase) annotation (Line(
            points={{-21,-26},{-18,-26},{-18,-36}},
            color={0,0,127},
            smooth=Smooth.None));
        connect(MusclePumping_SkeletalMuscle.u,add. y) annotation (Line(
            points={{10,8},{32,8},{32,13.6}},
            color={0,0,127},
            smooth=Smooth.None));
        connect(add.u,RateEffect. y) annotation (Line(
            points={{32,22.8},{32,26}},
            color={0,0,127},
            smooth=Smooth.None));
        connect(RateEffect.u, busConnector.Exercise_Metabolism_ContractionRate)
          annotation (Line(
            points={{40,30},{98,30},{98,90},{-90,90}},
            color={0,0,127},
            smooth=Smooth.None), Text(
            string="%second",
            index=1,
            extent={{6,3},{6,3}}));
        connect(TensionEffect.y, metabolicVasolidation.yBase) annotation (Line(
            points={{2,-66},{2,-70}},
            color={0,0,127},
            smooth=Smooth.None));
      connect(tissueConnector.O2Need, metabolicVasolidation.O2Need) annotation (
         Line(
          points={{-84,10},{-60,10},{-60,-72},{-7.8,-72}},
          color={127,0,0},
          thickness=0.5,
          smooth=Smooth.None), Text(
          string="%first",
          index=-1,
          extent={{-6,3},{-6,3}}));
        connect(one1.y, IntensityEffect.yBase) annotation (Line(
            points={{29,56},{32,56},{32,42}},
            color={0,0,127},
            smooth=Smooth.None));
      connect(tissueConnector.pO2, PO2OnTension.u) annotation (Line(
          points={{-84,10},{-60,10},{-60,-38},{-26,-38}},
          color={127,0,0},
          thickness=0.5,
          smooth=Smooth.None), Text(
          string="%first",
          index=-1,
          extent={{-6,3},{-6,3}}));
      connect(tissueConnector.pCO2, PCO2OnTension.u) annotation (Line(
          points={{-84,10},{-60,10},{-60,-46},{-26,-46}},
          color={127,0,0},
          thickness=0.5,
          smooth=Smooth.None), Text(
          string="%first",
          index=-1,
          extent={{-6,3},{-6,3}}));
        connect(flowMeasure.volumeFlow,BloodFlow)  annotation (Line(
            points={{58,-78},{58,-62},{84,-62}},
            color={0,0,127},
            smooth=Smooth.None));
        connect(q_in, flowMeasure.q_in) annotation (Line(
            points={{90,-90},{68,-90}},
            color={0,0,0},
            thickness=1,
            smooth=Smooth.None));
        connect(flowMeasure.q_out, resistor.q_in) annotation (Line(
            points={{48,-90},{12,-90}},
            color={0,0,0},
            thickness=1,
            smooth=Smooth.None));
        connect(resistor.q_out, q_out) annotation (Line(
            points={{-8,-90},{-84,-90}},
            color={0,0,0},
            thickness=1,
            smooth=Smooth.None));
        connect(A2Effect.y, ADHEffect.yBase) annotation (Line(
            points={{2,46},{2,42}},
            color={0,0,127},
            smooth=Smooth.None));
        connect(AplhaReceptors.yBase, ADHEffect.y) annotation (Line(
            points={{2,33},{2,36}},
            color={0,0,127},
            smooth=Smooth.None));
        connect(Anesthesia.y, A2Effect.yBase) annotation (Line(
            points={{2,56},{2,52}},
            color={0,0,127},
            smooth=Smooth.None));
        connect(pO2OnConductance.y, TensionEffect.yBase) annotation (Line(
            points={{2,-22},{2,-60}},
            color={0,0,127},
            smooth=Smooth.None));
        connect(resistor.cond, metabolicVasolidation.y) annotation (Line(
            points={{2,-84},{2,-76}},
            color={0,0,127},
            smooth=Smooth.None));
        connect(AplhaReceptors.y, MusclePumping_SkeletalMuscle.yBase) annotation (
            Line(
            points={{2,19},{2,10}},
            color={0,0,127},
            smooth=Smooth.None));
        connect(Vasculature.yBase, MusclePumping_SkeletalMuscle.y) annotation (Line(
            points={{2,-2},{2,4}},
            color={0,0,127},
            smooth=Smooth.None));
        connect(IntensityEffect.y, RateEffect.yBase) annotation (Line(
            points={{32,36},{32,32}},
            color={0,0,127},
            smooth=Smooth.None));
      connect(tissueConnector.Function_Failed, Vasculature.Failed) annotation (
          Line(
          points={{-84,10},{-60,10},{-60,-4},{-8,-4}},
          color={127,0,0},
          thickness=0.5,
          smooth=Smooth.None), Text(
          string="%first",
          index=-1,
          extent={{-6,3},{-6,3}}));
      connect(IntensityEffect.u, busConnector.Exercise_Metabolism_MotionWatts)
        annotation (Line(
          points={{40,40},{98,40},{98,90},{-90,90}},
          color={0,0,127},
          smooth=Smooth.None), Text(
          string="%second",
          index=1,
          extent={{6,3},{6,3}}));
        annotation (
          Documentation(info="<HTML>
<PRE>
Blood resistance in gastro interstitial tract.

</PRE>
</HTML>
",     revisions="<html>
<ul>
<li><i>  </i>
       </li>
<li><i> january 2009 </i><br>
       by Marek Matejak in Modelica initially implemented (consulted with Jiri Kofranek), Charles University, Prague<br>
       orginaly described by Tom Coleman in QHP 2008 beta 3, University of Mississippi Medical Center
       </li>
</ul>
</html>"), Icon(coordinateSystem(
                preserveAspectRatio=false, extent={{-100,-100},{100,100}}),
              graphics={Text(
                extent={{-120,-106},{80,-86}},
                lineColor={0,0,255},
                textString="%name")}));
      end TissueBloodFlow;

      model Liver
        extends Interfaces.BaseDO;
        extends Physiolibrary.Icons.Liver;
      Physiolibrary.Hydraulic.Interfaces.HydraulicPort_a portalVein annotation (
         extent=[-10,-110; 10,-90], Placement(transformation(extent={{-10,-110},
                {10,-90}}, rotation=0),
                          iconTransformation(extent={{12,-58},{32,-38}})));
      Physiolibrary.Hydraulic.Components.Conductor liverPortalConductance(
          Conductance=2.2251826750088e-08)
        "corrected to flow 1250ml/min in pressure gradient 1 mmHg"
        annotation (Placement(transformation(extent={{-52,-8},{-68,8}})));
      Physiolibrary.Hydraulic.Sensors.FlowMeasure flowMeasure1 annotation (
          Placement(transformation(
            extent={{-10,10},{10,-10}},
            rotation=180,
            origin={-84,0})));
      Physiolibrary.Hydraulic.Sensors.FlowMeasure flowMeasure2 annotation (
          Placement(transformation(
            extent={{-10,10},{10,-10}},
            rotation=180,
            origin={-24,-16})));
      Physiolibrary.Hydraulic.Components.Conductor HepaticArtyConductance(
          Conductance=3.5002873539464e-10)
        annotation (Placement(transformation(extent={{0,36},{-20,56}})));
      Physiolibrary.Hydraulic.Sensors.FlowMeasure flowMeasure3 annotation (
          Placement(transformation(
            extent={{-10,10},{10,-10}},
            rotation=180,
            origin={12,46})));
      equation
        connect(flowMeasure1.volumeFlow, busConnector.Liver_BloodFlow)
          annotation (Line(
            points={{-84,12},{-84,90},{-90,90}},
            color={0,0,127},
            smooth=Smooth.None));
        connect(flowMeasure2.volumeFlow, busConnector.PortalVein_BloodFlow)
          annotation (Line(
            points={{-24,-4},{-24,90},{-90,90}},
            color={0,0,127},
            smooth=Smooth.None));
        connect(flowMeasure3.volumeFlow, busConnector.HepaticArty_BloodFlow)
          annotation (Line(
            points={{12,58},{12,90},{-90,90}},
            color={0,0,127},
            smooth=Smooth.None), Text(
            string="%second",
            index=1,
            extent={{6,3},{6,3}}));
        connect(portalVein, flowMeasure2.q_in) annotation (Line(
            points={{-4,-12},{-4,-16},{-14,-16}},
            color={0,0,0},
            thickness=1,
            smooth=Smooth.None));
        connect(flowMeasure.q_out, flowMeasure3.q_in) annotation (Line(
            points={{78,0},{32,0},{32,46},{22,46}},
            color={0,0,0},
            thickness=1,
            smooth=Smooth.None));
        connect(flowMeasure3.q_out, HepaticArtyConductance.q_in) annotation (
            Line(
            points={{2,46},{0,46}},
            color={0,0,0},
            thickness=1,
            smooth=Smooth.None));
      connect(liverPortalConductance.q_out, flowMeasure1.q_in) annotation (Line(
          points={{-68,0},{-67,0},{-67,-7.34788e-016},{-74,-7.34788e-016}},
          color={0,0,0},
          thickness=1,
          smooth=Smooth.None));
        connect(flowMeasure1.q_out, q_out) annotation (Line(
            points={{-94,7.34788e-016},{-94,0},{-100,0}},
            color={0,0,0},
            thickness=1,
            smooth=Smooth.None));
      connect(flowMeasure2.q_out, liverPortalConductance.q_in) annotation (Line(
          points={{-34,-16},{-50,-16},{-50,0},{-52,0}},
          color={0,0,0},
          thickness=1,
          smooth=Smooth.None));
      connect(liverPortalConductance.q_in, HepaticArtyConductance.q_out)
        annotation (Line(
          points={{-52,2.22045e-016},{-50,2.22045e-016},{-50,46},{-20,46}},
          color={0,0,0},
          thickness=1,
          smooth=Smooth.None));
      end Liver;

      model Kidney
        extends Physiomodel.CardioVascular.Microcirculation.Interfaces.BaseDO;
        extends Physiolibrary.Icons.Kidney;

      Physiolibrary.Blocks.Factors.Normalization
        NephronCountEffect_AfferentArtery
        annotation (Placement(transformation(extent={{20,34},{40,54}})));
      Physiolibrary.Types.Constants.HydraulicConductanceConst
        Afferent_BasicConductance(k=4.2503489297921e-09)
        annotation (Placement(transformation(extent={{16,48},{28,60}})));
        VariableResistorWithMyogenicResponse AfferentArtery(
            PressureChangeOnMyogenicCondEffect={{-20.0,1.2,0.0},{0.0,1.0,-0.02},
              {20.0,0.8,0.0}}, pressureChange(start=0),
        InitialPressureChange(displayUnit="mmHg") = 9.33256711905,
        K_PressureChange(displayUnit="Hz"))
          annotation (Placement(transformation(extent={{20,-12},{44,12}})));
      Physiolibrary.Blocks.Factors.Spline A2Effect2(
        data={{0.0,1.2,0.0},{1.3,1.0,-0.4},{3.0,0.6,0.0}},
        Xscale=1e-9/Substances.AngiotensinII.mw,
        UsePositiveLog10=true)
        annotation (Placement(transformation(extent={{-56,18},{-36,38}})));
      Physiolibrary.Types.Constants.HydraulicConductanceConst
        Efferent_BasicConductance(k=2.87523604074162e-009)
        annotation (Placement(transformation(extent={{-60,48},{-48,60}})));
      Physiolibrary.Blocks.Factors.Normalization
        NephronCountEffect_KidneyEfferentArtery
        annotation (Placement(transformation(extent={{-56,34},{-36,54}})));
      Physiolibrary.Hydraulic.Components.Conductor EfferentArtery(
          useConductanceInput=true)
        annotation (Placement(transformation(extent={{-34,-12},{-58,12}})));
      Physiolibrary.Hydraulic.Components.Conductor ArcuateArtery(Conductance=
            7.500615758456399e-008)
        annotation (Placement(transformation(extent={{78,-8},{62,8}})));
        Physiomodel.Nerves.AplhaReceptorsActivityFactor
          AplhaReceptors_KidneyAfferentArtery(data={{1.5,1.0,0.0},{7.0,0.9,0.0}})
          annotation (Placement(transformation(extent={{20,14},{40,34}})));
        Physiomodel.Nerves.AplhaReceptorsActivityFactor
          AplhaReceptors_KidneyEfferentArtery(data={{1.5,1.0,0.0},{7.0,0.9,0.0}})
          annotation (Placement(transformation(extent={{-56,6},{-36,26}})));
      Physiolibrary.Blocks.Factors.Normalization
        Anesthesia_KidneyEfferentArtery
        annotation (Placement(transformation(extent={{-56,26},{-36,46}})));
      Physiolibrary.Hydraulic.Sensors.PressureMeasure pressureMeasure
        annotation (Placement(transformation(
            extent={{-10,-10},{10,10}},
            origin={-20,8})));
        Modelica.Blocks.Math.Product KidneyPlasmaFlow annotation (Placement(
              transformation(
              extent={{-5,-5},{5,5}},
              rotation=90,
              origin={83,67})));
      Physiolibrary.Hydraulic.Sensors.PressureMeasure pressureMeasure1
        annotation (Placement(transformation(
            extent={{10,-10},{-10,10}},
            origin={52,-20})));
        Modelica.Blocks.Math.Gain IFP(k=0.042)
          annotation (Placement(transformation(extent={{42,-84},{34,-76}})));
        Physiolibrary.Blocks.Factors.LagSpline     TGFEffect(
                                                   data={{0.0,1.2,0.0},{1.3,1.0,
              -0.4},{3.0,0.6,0.0}},
          initialValue=1.01309,
          HalfTime=60*Modelica.Math.log(2),
        integrator(stateName="TGF-Vascular.Signal"))
        "Macula Densa TGF vascular signal delay and effect to afferent arteriole"
          annotation (Placement(transformation(extent={{20,26},{40,46}})));
      Physiolibrary.Blocks.Factors.Spline FurosemideEffect(data={{0.0,1.0,0.0},
            {1.3,0.2,0.0}}, Xscale=1e-3/Substances.Furosemide.mw)
        "furosemide outflow on Macula Densa Na sensibility"
        annotation (Placement(transformation(extent={{-10,-52},{10,-32}})));
      Physiolibrary.Blocks.Factors.Spline NaEffect_MaculaDensa(data={{0,0.0,0.0},
            {48,1.0,0.03},{100,3.0,0.0}})
        annotation (Placement(transformation(extent={{-10,-48},{10,-28}})));
      Physiolibrary.Blocks.Factors.Spline ANP_Effect(data={{0.0,1.2,0.0},{1.3,
            1.0,-0.3},{2.7,0.8,0.0}},
        UsePositiveLog10=true,
        Xscale=1e-9)
        annotation (Placement(transformation(extent={{-10,-56},{10,-36}})));
      Physiolibrary.Blocks.Factors.Spline A2Effect3(
        data={{0.0,0.0,0.0},{0.2,0.6,0.05},{1.3,1.0,0.1},{3.0,8.0,0.0}},
        Xscale=1e-9/Substances.AngiotensinII.mw,
        UsePositiveLog10=true)
        annotation (Placement(transformation(extent={{-10,-60},{10,-40}})));
      Physiolibrary.Types.Constants.FractionConst
        MedulaDensa_BaseTGFSignal(k=1)
        annotation (Placement(transformation(extent={{-10,-34},{-2,-26}})));
        VasaRecta vasaRecta
          annotation (Placement(transformation(extent={{70,-90},{90,-70}})));
      equation
        connect(Afferent_BasicConductance.y, NephronCountEffect_AfferentArtery.yBase)
                                                                   annotation (Line(
            points={{29.5,54},{30,54},{30,46}},
            color={0,0,127},
            smooth=Smooth.None));
        connect(busConnector.Kidney_NephronCount_Total_xNormal,
          NephronCountEffect_AfferentArtery.u) annotation (Line(
            points={{-90,90},{-14,90},{-14,66},{-14,44},{22,44}},
            color={0,0,255},
            thickness=0.5,
            smooth=Smooth.None), Text(
            string="%first",
            index=-1,
            extent={{-6,3},{-6,3}}));
        connect(busConnector.AlphaPool_Effect, AplhaReceptors_KidneyAfferentArtery.AlphaPool_Effect)
          annotation (Line(
            points={{-90,90},{-90,90},{-14,90},{-14,62},{-14,30},{20.2,30}},
            color={0,0,255},
            thickness=0.5,
            smooth=Smooth.None), Text(
            string="%first",
            index=-1,
            extent={{-6,3},{-6,3}}));
        connect(busConnector.AlphaBlocade_Effect, AplhaReceptors_KidneyAfferentArtery.AlphaBlockade_Effect)
          annotation (Line(
            points={{-90,90},{-90,90},{-14,90},{-14,54},{-14,24},{20.2,24}},
            color={0,0,255},
            thickness=0.5,
            smooth=Smooth.None), Text(
            string="%first",
            index=-1,
            extent={{-6,3},{-6,3}}));
        connect(busConnector.GangliaGeneral_NA,
          AplhaReceptors_KidneyAfferentArtery.GangliaGeneral_NA) annotation (
            Line(
            points={{-90,90},{-14,90},{-14,90},{-14,18},{20.2,18}},
            color={0,0,255},
            thickness=0.5,
            smooth=Smooth.None), Text(
            string="%first",
            index=-1,
            extent={{-6,3},{-6,3}}));
        connect(busConnector.AlphaPool_Effect, AplhaReceptors_KidneyEfferentArtery.AlphaPool_Effect)
          annotation (Line(
            points={{-90,90},{-92,90},{-92,22},{-55.8,22}},
            color={0,0,255},
            thickness=0.5,
            smooth=Smooth.None), Text(
            string="%first",
            index=-1,
            extent={{-6,3},{-6,3}}));
        connect(busConnector.GangliaGeneral_NA,
          AplhaReceptors_KidneyEfferentArtery.GangliaGeneral_NA) annotation (
            Line(
            points={{-90,90},{-92,90},{-92,10},{-55.8,10}},
            color={0,0,255},
            thickness=0.5,
            smooth=Smooth.None), Text(
            string="%first",
            index=-1,
            extent={{-6,3},{-6,3}}));
        connect(busConnector.AlphaBlocade_Effect, AplhaReceptors_KidneyEfferentArtery.AlphaBlockade_Effect)
          annotation (Line(
            points={{-90,90},{-92,90},{-92,16},{-55.8,16}},
            color={0,0,255},
            thickness=0.5,
            smooth=Smooth.None), Text(
            string="%first",
            index=-1,
            extent={{-6,3},{-6,3}}));
        connect(busConnector.Kidney_NephronCount_Total_xNormal,
          NephronCountEffect_KidneyEfferentArtery.u) annotation (Line(
            points={{-90,90},{-92,90},{-92,44},{-54,44}},
            color={0,0,255},
            thickness=0.5,
            smooth=Smooth.None), Text(
            string="%first",
            index=-1,
            extent={{-6,3},{-6,3}}));
        connect(busConnector.Anesthesia_VascularConductance,
          Anesthesia_KidneyEfferentArtery.u) annotation (Line(
            points={{-90,90},{-92,90},{-92,36},{-54,36}},
            color={0,0,255},
            thickness=0.5,
            smooth=Smooth.None), Text(
            string="%first",
            index=-1,
            extent={{-6,3},{-6,3}}));
        connect(Efferent_BasicConductance.y,
          NephronCountEffect_KidneyEfferentArtery.yBase) annotation (Line(
            points={{-46.5,54},{-46,54},{-46,46}},
            color={0,0,127},
            smooth=Smooth.None));

        connect(A2Effect2.y, AplhaReceptors_KidneyEfferentArtery.yBase)
          annotation (Line(
            points={{-46,24},{-46,23}},
            color={0,0,127},
            smooth=Smooth.None));
        connect(NephronCountEffect_KidneyEfferentArtery.y,
          Anesthesia_KidneyEfferentArtery.yBase) annotation (Line(
            points={{-46,40},{-46,38}},
            color={0,0,127},
            smooth=Smooth.None));
        connect(Anesthesia_KidneyEfferentArtery.y, A2Effect2.yBase) annotation (
           Line(
            points={{-46,32},{-46,30}},
            color={0,0,127},
            smooth=Smooth.None));
        connect(AplhaReceptors_KidneyEfferentArtery.y, EfferentArtery.cond)
          annotation (Line(
            points={{-46,9},{-46,7.2}},
            color={0,0,127},
            smooth=Smooth.None));
        connect(AplhaReceptors_KidneyAfferentArtery.y, AfferentArtery.cond)
          annotation (Line(
            points={{30,17},{30,4.8},{32,4.8}},
            color={0,0,127},
            smooth=Smooth.None));
        connect(pressureMeasure.q_in, AfferentArtery.q_out) annotation (Line(
            points={{-24,2},{-24,0},{20,0}},
            color={0,0,0},
            thickness=1,
            smooth=Smooth.None));
      connect(pressureMeasure.pressure, busConnector.GlomerulusBloodPressure)
        annotation (Line(
          points={{-14,4},{-14,-16},{-90,-16},{-90,90}},
          color={0,0,127},
          smooth=Smooth.None), Text(
          string="%second",
          index=1,
          extent={{6,-3},{6,-3}}));
        connect(busConnector.BloodVol_PVCrit, KidneyPlasmaFlow.u2)
          annotation (Line(
            points={{-90,90},{96,90},{96,56},{86,56},{86,61}},
            color={0,0,255},
            thickness=0.5,
            smooth=Smooth.None), Text(
            string="%first",
            index=-1,
            extent={{6,-3},{6,-3}}));
        connect(KidneyPlasmaFlow.y, busConnector.KidneyPlasmaFlow)
          annotation (Line(
            points={{83,72.5},{83,90},{-90,90}},
            color={0,0,127},
            smooth=Smooth.None), Text(
            string="%second",
            index=1,
            extent={{3,3},{3,3}}));
        connect(ArcuateArtery.q_out, AfferentArtery.q_in) annotation (Line(
            points={{62,0},{44,0}},
            color={0,0,0},
            thickness=1,
            smooth=Smooth.None));
        connect(EfferentArtery.q_in, AfferentArtery.q_out) annotation (Line(
            points={{-34,0},{20,0}},
            color={0,0,0},
            thickness=1,
            smooth=Smooth.None));
        connect(EfferentArtery.q_out, q_out) annotation (Line(
            points={{-58,0},{-100,0}},
            color={0,0,0},
            thickness=1,
            smooth=Smooth.None));
        connect(AfferentArtery.q_in, pressureMeasure1.q_in) annotation (Line(
            points={{44,0},{58,0},{58,-26},{56,-26}},
            color={0,0,0},
            thickness=1,
            smooth=Smooth.None));
      connect(IFP.u, pressureMeasure1.pressure) annotation (Line(
          points={{42.8,-80},{46,-80},{46,-24}},
          color={0,0,127},
          smooth=Smooth.None));
        connect(ANP_Effect.y,A2Effect3. yBase) annotation (Line(
            points={{0,-50},{0,-48}},
            color={0,0,127},
            smooth=Smooth.None));
        connect(FurosemideEffect.y,ANP_Effect. yBase) annotation (Line(
            points={{0,-46},{0,-44}},
            color={0,0,127},
            smooth=Smooth.None));
        connect(NaEffect_MaculaDensa.y,FurosemideEffect. yBase) annotation (
            Line(
            points={{0,-42},{0,-40}},
            color={0,0,127},
            smooth=Smooth.None));
        connect(MedulaDensa_BaseTGFSignal.y,NaEffect_MaculaDensa. yBase)
          annotation (Line(
            points={{-1,-30},{0,-30},{0,-36}},
            color={0,0,127},
            smooth=Smooth.None));
        connect(A2Effect3.y,TGFEffect. u) annotation (Line(
            points={{0,-54},{-26,-54},{-26,36},{22,36}},
            color={0,0,127},
            smooth=Smooth.None));
        connect(NephronCountEffect_AfferentArtery.y, TGFEffect.yBase) annotation (
            Line(
            points={{30,40},{30,38}},
            color={0,0,127},
            smooth=Smooth.None));
        connect(TGFEffect.y, AplhaReceptors_KidneyAfferentArtery.yBase) annotation (
            Line(
            points={{30,32},{30,31}},
            color={0,0,127},
            smooth=Smooth.None));
        connect(busConnector.FurosemidePool_Loss, FurosemideEffect.u)
          annotation (Line(
            points={{-90,90},{-90,-42},{-8,-42}},
            color={0,0,255},
            thickness=0.5,
            smooth=Smooth.None), Text(
            string="%first",
            index=-1,
            extent={{-6,3},{-6,3}}));
        connect(flowMeasure.volumeFlow, KidneyPlasmaFlow.u1) annotation (Line(
            points={{88,12},{88,50},{80,50},{80,61}},
            color={0,0,127},
            smooth=Smooth.None));
        connect(flowMeasure.q_out,ArcuateArtery. q_in) annotation (Line(
            points={{78,0},{78,0}},
            color={0,0,0},
            thickness=1,
            smooth=Smooth.None));
        connect(busConnector, vasaRecta.busConnector) annotation (Line(
            points={{-90,90},{-90,-72},{72,-72}},
            color={0,0,255},
            thickness=0.5,
            smooth=Smooth.None));
      connect(pressureMeasure1.pressure, vasaRecta.ArcuateArtery_Pressure)
        annotation (Line(
          points={{46,-24},{46,-80},{72,-80}},
          color={0,0,127},
          smooth=Smooth.None));
        connect(busConnector.NephronIFP_Pressure, IFP.y) annotation (
            Line(
            points={{-90,90},{-90,-80},{33.6,-80}},
            color={0,0,255},
            thickness=0.5,
            smooth=Smooth.None), Text(
            string="%first",
            index=-1,
            extent={{-6,3},{-6,3}}));
        connect(busConnector.MD_Na, NaEffect_MaculaDensa.u)
          annotation (Line(
            points={{-90,90},{-90,-38},{-8,-38}},
            color={0,0,255},
            thickness=0.5,
            smooth=Smooth.None), Text(
            string="%first",
            index=-1,
            extent={{-6,3},{-6,3}}));
      connect(busConnector.Angiotensin2, A2Effect2.u) annotation (Line(
          points={{-90,90},{-92,90},{-92,28},{-54,28}},
          color={0,0,255},
          thickness=0.5,
          smooth=Smooth.None), Text(
          string="%first",
          index=-1,
          extent={{-6,3},{-6,3}}));
      connect(busConnector.Angiotensin2, A2Effect3.u) annotation (Line(
          points={{-90,90},{-90,-50},{-8,-50}},
          color={0,0,255},
          thickness=0.5,
          smooth=Smooth.None), Text(
          string="%first",
          index=-1,
          extent={{-6,3},{-6,3}}));
      connect(busConnector.ANP, ANP_Effect.u) annotation (Line(
          points={{-90,90},{-90,-46},{-8,-46}},
          color={0,0,255},
          thickness=0.5,
          smooth=Smooth.None), Text(
          string="%first",
          index=-1,
          extent={{-6,3},{-6,3}}));
        annotation (
          Documentation(info="<HTML>
<PRE>
Blood resistance in kidneys.

QHP 2008 / Kidney-Flow

</PRE>
</HTML>
",     revisions="<html>

<table>
<tr>
<td>Author:</td>
<td>Marek Matejak</td>
</tr>
<tr>
<td>License:</td>
<td><a href=\"http://www.physiomodel.org/license.html\">Physiomodel License 1.0</a> </td>
</tr>
<tr>
<td>By:</td>
<td>Charles University, Prague</td>
</tr>
<tr>
<td>Date of:</td>
<td>2009</td>
</tr>
<tr>
<td>References:</td>
<td>Tom Coleman: QHP 2008 beta 3, University of Mississippi Medical Center</td>
</tr>
</table>
<br/><p>Copyright &copy; 2014 Marek Matejak, Charles University in Prague.</p><br/>

</html>"),Diagram(coordinateSystem(preserveAspectRatio=false,extent={{-100,-100},
                {100,100}}),   graphics={Rectangle(extent={{-18,-24},{18,-62}},
                  lineColor={127,0,0}), Text(
                extent={{-18,-62},{18,-56}},
                lineColor={0,0,255},
                textString="Macula Densa")}),         Icon(coordinateSystem(
                preserveAspectRatio=false, extent={{-100,-100},{100,100}}),
              graphics={Text(
                extent={{-100,-100},{100,-80}},
                lineColor={0,0,255},
                textString="%name")}));
      end Kidney;

      model LeftHeart
        extends Interfaces.Heart(
                      Vasculature(stateName="LeftHeart-Vasculature.Effect"));
        extends Physiolibrary.Icons.LeftHeart;
      equation
        connect(busConnector.LeftHeart_Function_Failed, Vasculature.Failed)
          annotation (Line(
            points={{-90,90},{6,90},{6,44},{60,44}},
            color={0,0,255},
            thickness=0.5,
            smooth=Smooth.None), Text(
            string="%first",
            index=-1,
            extent={{-6,3},{-6,3}}));
        connect(busConnector.LeftHeart_PO2, PO2Effect.u) annotation (
            Line(
            points={{-90,90},{6,90},{6,30},{62,30}},
            color={0,0,255},
            thickness=0.5,
            smooth=Smooth.None), Text(
            string="%first",
            index=-1,
            extent={{-6,3},{-6,3}}));
        connect(busConnector.LeftHeart_O2Need, MetabolismEffect.u)
          annotation (Line(
            points={{-90,90},{6,90},{6,20},{62,20}},
            color={0,0,255},
            thickness=0.5,
            smooth=Smooth.None), Text(
            string="%first",
            index=-1,
            extent={{-6,3},{-6,3}}));
        connect(busConnector.LeftHeart_PO2, Vasculature.u) annotation (
           Line(
            points={{-90,90},{6,90},{6,38},{60,38}},
            color={0,0,255},
            thickness=0.5,
            smooth=Smooth.None), Text(
            string="%first",
            index=-1,
            extent={{-6,3},{-6,3}}));
      end LeftHeart;

      model RightHeart
        extends Interfaces.Heart(
                      Vasculature(stateName="RightHeart-Vasculature.Effect"));
        extends Physiolibrary.Icons.RightHeart;
      equation
        connect(busConnector.RightHeart_PO2, Vasculature.u)
          annotation (Line(
            points={{-90,90},{6,90},{6,38},{60,38}},
            color={0,0,255},
            thickness=0.5,
            smooth=Smooth.None), Text(
            string="%first",
            index=-1,
            extent={{-6,3},{-6,3}}));
        connect(busConnector.RightHeart_PO2, PO2Effect.u) annotation (
            Line(
            points={{-90,90},{6,90},{6,30},{62,30}},
            color={0,0,255},
            thickness=0.5,
            smooth=Smooth.None), Text(
            string="%first",
            index=-1,
            extent={{-6,3},{-6,3}}));
        connect(busConnector.RightHeart_O2Need, MetabolismEffect.u)
          annotation (Line(
            points={{-90,90},{6,90},{6,20},{62,20}},
            color={0,0,255},
            thickness=0.5,
            smooth=Smooth.None), Text(
            string="%first",
            index=-1,
            extent={{-6,3},{-6,3}}));
        connect(busConnector.RightHeart_Function_Failed, Vasculature.Failed)
          annotation (Line(
            points={{-90,90},{6,90},{6,44},{60,44}},
            color={0,0,255},
            thickness=0.5,
            smooth=Smooth.None), Text(
            string="%first",
            index=-1,
            extent={{-6,3},{-6,3}}));
      end RightHeart;

      model Skin
        extends Physiomodel.CardioVascular.Microcirculation.Interfaces.BaseDO;
        extends Physiolibrary.Icons.Skin;

      Physiolibrary.Hydraulic.Components.Conductor skin(useConductanceInput=
            true)
        annotation (Placement(transformation(extent={{80,-26},{56,-2}})));
      Physiolibrary.Blocks.Factors.Spline A2Effect_Skin(
        data={{0.0,1.05,0},{1.3,1.00,-0.08},{3.5,0.50,0}},
        Xscale=1e-9/Substances.AngiotensinII.mw,
        UsePositiveLog10=true)
        annotation (Placement(transformation(extent={{58,30},{78,50}})));
      Physiolibrary.Blocks.Factors.Spline ADHEffect_Skin(
        data={{0.8,1.0,0},{3.0,0.1,0}},
        Xscale=1e-9/Substances.Vasopressin.mw,
        UsePositiveLog10=true)
        annotation (Placement(transformation(extent={{58,16},{78,36}})));
      Physiolibrary.Types.Constants.HydraulicConductanceConst BasicConductance(k=
            2.0001642022551e-10)
        annotation (Placement(transformation(extent={{54,72},{66,84}})));
      Physiolibrary.Blocks.Factors.Normalization Viscosity_Skin
        annotation (Placement(transformation(extent={{58,58},{78,78}})));
      Physiolibrary.Blocks.Factors.Normalization Anesthesia_Skin
        annotation (Placement(transformation(extent={{58,50},{78,70}})));
        Physiolibrary.Blocks.Factors.SplineLagOrZero
          Vasculature_Skin(HalfTime=30*86400*Modelica.Math.log(2), data={{41,1.2,0},{51,1.0,-0.03},{61,0.8,0}},
          stateName="Skin-Vasculature.Effect")
          annotation (Placement(transformation(extent={{58,40},{78,60}})));
      Physiolibrary.Blocks.Factors.Normalization TermoregulationEffect
        annotation (Placement(transformation(extent={{58,-2},{78,18}})));
      equation
        connect(Anesthesia_Skin.yBase,Viscosity_Skin. y) annotation (Line(
            points={{68,62},{68,64}},
            color={0,0,127},
            smooth=Smooth.None));
        connect(Anesthesia_Skin.y,Vasculature_Skin. yBase) annotation (Line(
            points={{68,56},{68,56}},
            color={0,0,127},
            smooth=Smooth.None));
        connect(Vasculature_Skin.y,A2Effect_Skin. yBase) annotation (Line(
            points={{68,44},{68,42}},
            color={0,0,127},
            smooth=Smooth.None));
        connect(BasicConductance.y, Viscosity_Skin.yBase)      annotation (Line(
            points={{67.5,78},{68,78},{68,70}},
            color={0,0,127},
            smooth=Smooth.None));
        connect(busConnector.Viscosity_ConductanceEffect, Viscosity_Skin.u)
          annotation (Line(
            points={{-90,90},{-12,90},{-12,68},{60,68}},
            color={0,0,255},
            thickness=0.5,
            smooth=Smooth.None), Text(
            string="%first",
            index=-1,
            extent={{-6,3},{-6,3}}));
        connect(busConnector.Anesthesia_VascularConductance, Anesthesia_Skin.u)
          annotation (Line(
            points={{-90,90},{-12,90},{-12,60},{60,60}},
            color={0,0,255},
            thickness=0.5,
            smooth=Smooth.None), Text(
            string="%first",
            index=-1,
            extent={{-6,3},{-6,3}}));
        connect(busConnector.Skin_Function_Failed, Vasculature_Skin.Failed)
          annotation (Line(
            points={{-90,90},{-12,90},{-12,54},{58,54}},
            color={0,0,255},
            thickness=0.5,
            smooth=Smooth.None), Text(
            string="%first",
            index=-1,
            extent={{-6,3},{-6,3}}));
        connect(busConnector.Skin_PO2, Vasculature_Skin.u) annotation (Line(
            points={{-90,90},{-12,90},{-12,48},{58,48}},
            color={0,0,255},
            thickness=0.5,
            smooth=Smooth.None), Text(
            string="%first",
            index=-1,
            extent={{-6,3},{-6,3}}));
        connect(skin.q_out, q_out) annotation (Line(
            points={{56,-14},{-24,-14},{-24,0},{-100,0}},
            color={0,0,0},
            thickness=1,
            smooth=Smooth.None));
        connect(skin.q_in, flowMeasure.q_out) annotation (Line(
            points={{80,-14},{80,0},{78,0}},
            color={0,0,0},
            thickness=1,
            smooth=Smooth.None));
        connect(ADHEffect_Skin.y, busConnector.skin_conductanceWithoutTermoregulationEffect)
          annotation (Line(
            points={{68,22},{-90,22},{-90,90}},
            color={0,0,127},
            smooth=Smooth.None), Text(
            string="%second",
            index=1,
            extent={{6,3},{6,3}}));
        connect(busConnector.skinFlow_termoregulationEffect,
          TermoregulationEffect.u) annotation (Line(
            points={{-90,90},{-88,90},{-88,8},{60,8}},
            color={0,0,255},
            thickness=0.5,
            smooth=Smooth.None), Text(
            string="%first",
            index=-1,
            extent={{-6,3},{-6,3}}));
        connect(ADHEffect_Skin.y, TermoregulationEffect.yBase) annotation (Line(
            points={{68,22},{68,10}},
            color={0,0,127},
            smooth=Smooth.None));
        connect(TermoregulationEffect.y, skin.cond) annotation (Line(
            points={{68,4},{68,-6.8}},
            color={0,0,127},
            smooth=Smooth.None));
        connect(A2Effect_Skin.y, ADHEffect_Skin.yBase) annotation (Line(
            points={{68,36},{68,28}},
            color={0,0,127},
            smooth=Smooth.None));
      connect(busConnector.Angiotensin2, A2Effect_Skin.u) annotation (Line(
          points={{-90,90},{-12,90},{-12,40},{60,40}},
          color={0,0,255},
          thickness=0.5,
          smooth=Smooth.None), Text(
          string="%first",
          index=-1,
          extent={{-6,3},{-6,3}}));
      connect(busConnector.Vasopressin, ADHEffect_Skin.u) annotation (Line(
          points={{-90,90},{-12,90},{-12,26},{60,26}},
          color={0,0,255},
          thickness=0.5,
          smooth=Smooth.None), Text(
          string="%first",
          index=-1,
          extent={{-6,3},{-6,3}}));
         annotation (
          Documentation(info="<HTML>
<PRE>
Blood resistance in skin.

QHP 2008 / Skin-Flow

</PRE>
</HTML>
",     revisions="<html>
<ul>
<li><i>  </i>
       </li>
<li><i> january 2009 </i><br>
       by Marek Matejak in Modelica initially implemented (consulted with Jiri Kofranek), Charles University, Prague<br>
       orginaly described by Tom Coleman in QHP 2008 beta 3, University of Mississippi Medical Center
       </li>
</ul>
</html>"), Icon(graphics={Text(
                extent={{-100,-100},{100,-80}},
                lineColor={0,0,255},
                textString="%name")}));
      end Skin;

      model MetabolicVasodilation
        extends Physiolibrary.Icons.BaseFactorIcon5;
        Physiolibrary.Types.RealIO.MolarFlowRateInput O2Need
                     annotation (Placement(transformation(extent={{-110,60},{-82,88}}),
              iconTransformation(extent={{-108,-10},{-88,10}})));

       parameter Boolean enabled=true "disabled => y=yBase";

       parameter Real[:,3] data = {{   50,  1.0,  0}, { 1000,  3.5,  0.003}, { 3000,  5.5,  0}};
       parameter Physiolibrary.Types.Time OnTau = 0.2;
       parameter Physiolibrary.Types.Time OffTau = 1;
       parameter Physiolibrary.Types.Fraction initialEffectValue = 1;
        parameter String stateName=getInstanceName();
        parameter Physiolibrary.Types.MolarFlowRate Xscale = 1
        "conversion scale to SI unit of x values";

      Physiolibrary.Blocks.Interpolation.Curve SteadyState(
        x=data[:, 1],
        y=data[:, 2],
        slope=data[:, 3],
          Xscale=Xscale)
        annotation (Placement(transformation(extent={{-72,64},{-52,84}})));
      Physiolibrary.Blocks.Math.Integrator effect(
        y_start=initialEffectValue,
        stateName=stateName,
          k=1)  annotation (Placement(transformation(
            extent={{-10,-10},{10,10}},
            rotation=270,
            origin={-28,-14})));
        Modelica.Blocks.Math.Feedback feedback annotation (Placement(
              transformation(
              extent={{-8,-12},{12,-32}},
              rotation=270,
              origin={8,64})));
        Modelica.Blocks.Math.Product product1 annotation (Placement(transformation(
              extent={{-10,-10},{10,10}},
              rotation=270,
              origin={-22,16})));
        Modelica.Blocks.Logical.Switch switch1(u2(start=false))
          annotation (Placement(transformation(extent={{-54,24},{-34,44}})));
        Modelica.Blocks.Logical.GreaterThreshold greaterThreshold
          annotation (Placement(transformation(extent={{-72,30},{-64,38}})));
      Physiolibrary.Blocks.Math.Reciprocal OnK annotation (Placement(
            transformation(
            extent={{-10,-10},{10,10}},
            rotation=90,
            origin={-86,8})));
      Physiolibrary.Blocks.Math.Reciprocal OffK annotation (Placement(
            transformation(
            extent={{-10,-10},{10,10}},
            rotation=90,
            origin={-60,8})));
      Physiolibrary.Types.Constants.TimeConst                 Constant0(k=
            OnTau) annotation (Placement(transformation(
            extent={{-10,-10},{10,10}},
            rotation=90,
            origin={-86,-22})));
      Physiolibrary.Types.Constants.TimeConst                 Constant1(k=
            OffTau) annotation (Placement(transformation(
            extent={{-10,-10},{10,10}},
            rotation=90,
            origin={-60,-22})));

        Physiolibrary.Blocks.Factors.Normalization normalization(enabled=enabled)
          annotation (Placement(transformation(extent={{-10,-20},{10,0}})));
      equation
        connect(SteadyState.val, feedback.u1)
                                        annotation (Line(
            points={{-52,74},{-14,74},{-14,70}},
            color={0,0,127},
            smooth=Smooth.None));
        connect(effect.y, feedback.u2)     annotation (Line(
            points={{-28,-25},{-28,-68},{86,-68},{86,62},{-6,62}},
            color={0,0,127},
            smooth=Smooth.None));
        connect(SteadyState.u, O2Need)  annotation (Line(
            points={{-72,74},{-96,74}},
            color={0,0,127},
            smooth=Smooth.None));
        connect(product1.y, effect.u)     annotation (Line(
            points={{-22,5},{-22,-2},{-28,-2}},
            color={0,0,127},
            smooth=Smooth.None));
        connect(product1.u1, feedback.y) annotation (Line(
            points={{-16,28},{-16,40},{-14,40},{-14,53}},
            color={0,0,127},
            smooth=Smooth.None));

        connect(switch1.y, product1.u2) annotation (Line(
            points={{-33,34},{-28,34},{-28,28}},
            color={0,0,127},
            smooth=Smooth.None));
        connect(greaterThreshold.u, feedback.y) annotation (Line(
            points={{-72.8,34},{-76,34},{-76,50},{-14,50},{-14,53}},
            color={0,0,127},
            smooth=Smooth.None));
        connect(greaterThreshold.y, switch1.u2) annotation (Line(
            points={{-63.6,34},{-56,34}},
            color={255,0,255},
            smooth=Smooth.None));
        connect(OnK.y, switch1.u1)  annotation (Line(
            points={{-86,19},{-86,42},{-56,42}},
            color={0,0,127},
            smooth=Smooth.None));
        connect(OffK.y, switch1.u3)  annotation (Line(
            points={{-60,19},{-60,26},{-56,26}},
            color={0,0,127},
            smooth=Smooth.None));
        connect(Constant1.y, OffK.u)  annotation (Line(
            points={{-60,-9.5},{-60,-4}},
            color={0,0,127},
            smooth=Smooth.None));
        connect(Constant0.y, OnK.u)  annotation (Line(
            points={{-86,-9.5},{-86,-4}},
            color={0,0,127},
            smooth=Smooth.None));
        connect(effect.y, normalization.u) annotation (Line(
            points={{-28,-25},{-28,-40},{-12,-40},{-12,-10},{-8,-10}},
            color={0,0,127},
            smooth=Smooth.None));
        connect(yBase, normalization.yBase) annotation (Line(
            points={{0,20},{0,-8}},
            color={0,0,127},
            smooth=Smooth.None));
        connect(normalization.y, y) annotation (Line(
            points={{0,-14},{0,-40}},
            color={0,0,127},
            smooth=Smooth.None));
      end MetabolicVasodilation;

      model VasaRecta

      Physiolibrary.Hydraulic.Components.Conductor resistorWithCond(
          useConductanceInput=true)
        annotation (Placement(transformation(extent={{2,0},{22,20}})));
      Physiolibrary.Blocks.Factors.Spline OsmOnConductance(data={{600,1.4,0},{
            1100,1.0,-0.0006},{2000,0.8,0}})
        annotation (Placement(transformation(extent={{2,38},{22,58}})));
      Physiolibrary.Blocks.Factors.Spline A2OnConductance(
        data={{0.0,1.3,0},{1.3,1.0,-0.6},{2.0,0.5,0}},
        Xscale=1e-9/Substances.AngiotensinII.mw,
        UsePositiveLog10=true)
        annotation (Placement(transformation(extent={{2,26},{22,46}})));
      Physiolibrary.Blocks.Factors.Spline SympsOnConductance(data={{0.0,1.1,0},
            {1.0,1.0,-0.13},{1.4,0.6,0}})
        annotation (Placement(transformation(extent={{2,18},{22,38}})));
      Physiolibrary.Types.Constants.HydraulicConductanceConst condConstant(k(displayUnit="ml/(mmHg.min)")=
          3.3752770913055e-11)
        annotation (Placement(transformation(extent={{-4,62},{8,74}})));
      Physiolibrary.Types.BusConnector busConnector
        "signals of organ bood flow resistence" annotation (Placement(
            transformation(extent={{-96,64},{-74,86}}), iconTransformation(
              extent={{-100,60},{-60,100}})));
      Physiolibrary.Hydraulic.Sensors.FlowMeasure flowMeasure
        annotation (Placement(transformation(extent={{32,20},{52,0}})));
      Physiolibrary.Hydraulic.Sources.UnlimitedPump inputPump(
          useSolutionFlowInput=true)
        annotation (Placement(transformation(extent={{-54,-48},{-34,-28}})));
        Modelica.Blocks.Math.Add Osm
          annotation (Placement(transformation(extent={{-14,44},{-6,52}})));
        Modelica.Blocks.Interfaces.RealInput ArcuateArtery_Pressure
                                                             annotation (
            Placement(transformation(extent={{-80,20},{-68,32}}),
              iconTransformation(extent={{-100,-20},{-60,20}})));
      Physiolibrary.Blocks.Factors.LagSpline
                                          NephroneADHOnConductance(data={{0.0,
            1.4,0},{0.3,1.0,-0.4},{1.0,0.9,0}}, Xscale=1e-9/Substances.Vasopressin.mw,
        HalfTime=Modelica.Math.log(2)*20*60,
        initialValue=2e-9/Substances.Vasopressin.mw)
        "initial 2pg/ml = 2e-9 kg/m3, NephronADH.Tau = 20 min"
        annotation (Placement(transformation(extent={{2,46},{22,66}})));
      Physiolibrary.Hydraulic.Sources.UnlimitedVolume arcuateArtery(
          usePressureInput=true)
        annotation (Placement(transformation(extent={{-62,0},{-42,20}})));
      Physiolibrary.Hydraulic.Sources.UnlimitedVolume veins(usePressureInput=
            true)
        annotation (Placement(transformation(extent={{96,0},{76,20}})));
      equation
        connect(SympsOnConductance.y, resistorWithCond.cond) annotation (Line(
            points={{12,24},{12,16}},
            color={0,0,127},
            smooth=Smooth.None));
        connect(A2OnConductance.y, SympsOnConductance.yBase) annotation (Line(
            points={{12,32},{12,30}},
            color={0,0,127},
            smooth=Smooth.None));
        connect(OsmOnConductance.y, A2OnConductance.yBase) annotation (Line(
            points={{12,44},{12,38}},
            color={0,0,127},
            smooth=Smooth.None));
        connect(busConnector.Kidney_Alpha_NA, SympsOnConductance.u) annotation (Line(
            points={{-85,75},{-60,75},{-60,28},{4,28}},
            color={0,0,255},
            thickness=0.5,
            smooth=Smooth.None), Text(
            string="%first",
            index=-1,
            extent={{-6,3},{-6,3}}));
        connect(resistorWithCond.q_out, flowMeasure.q_in) annotation (Line(
            points={{22,10},{32,10}},
            color={0,0,0},
            thickness=1,
            smooth=Smooth.None));
        connect(flowMeasure.volumeFlow, busConnector.VasaRecta_Outflow) annotation (
            Line(
            points={{42,-2},{42,75},{-85,75}},
            color={0,0,127},
            smooth=Smooth.None), Text(
            string="%second",
            index=1,
            extent={{6,-12},{6,-12}}));
        connect(inputPump.q_out, flowMeasure.q_in) annotation (Line(
            points={{-34,-38},{26,-38},{26,10},{32,10}},
            color={0,0,0},
            thickness=1,
            smooth=Smooth.None));
        connect(Osm.y, OsmOnConductance.u) annotation (Line(
            points={{-5.6,48},{4,48}},
            color={0,0,127},
            smooth=Smooth.None));
        connect(busConnector.MedullaNa_Osmolarity, Osm.u1) annotation (Line(
            points={{-85,75},{-60,75},{-60,50.4},{-14.8,50.4}},
            color={0,0,255},
            thickness=0.5,
            smooth=Smooth.None), Text(
            string="%first",
            index=-1,
            extent={{-6,3},{-6,3}}));
        connect(busConnector.MedullaUrea_Osmolarity, Osm.u2) annotation (Line(
            points={{-85,75},{-60,75},{-60,45.6},{-14.8,45.6}},
            color={0,0,255},
            thickness=0.5,
            smooth=Smooth.None), Text(
            string="%first",
            index=-1,
            extent={{-6,3},{-6,3}}));
      connect(busConnector.CD_H2O_Reab, inputPump.solutionFlow) annotation (
          Line(
          points={{-85,75},{-76,75},{-76,-22},{-44,-22},{-44,-31}},
          color={0,0,255},
          thickness=0.5,
          smooth=Smooth.None), Text(
          string="%first",
          index=-1,
          extent={{-6,3},{-6,3}}));
        connect(NephroneADHOnConductance.y, OsmOnConductance.yBase) annotation (
           Line(
            points={{12,52},{12,50}},
            color={0,0,127},
            smooth=Smooth.None));
        connect(condConstant.y, NephroneADHOnConductance.yBase) annotation (
            Line(
            points={{9.5,68},{12,68},{12,58}},
            color={0,0,127},
            smooth=Smooth.None));
      connect(ArcuateArtery_Pressure, arcuateArtery.pressure) annotation (Line(
          points={{-74,26},{-68,26},{-68,10},{-62,10}},
          color={0,0,127},
          smooth=Smooth.None));
      connect(arcuateArtery.y, resistorWithCond.q_in) annotation (Line(
          points={{-42,10},{2,10}},
          color={0,0,0},
          thickness=1,
          smooth=Smooth.None));
      connect(busConnector.SystemicVeins_Pressure, veins.pressure) annotation (
          Line(
          points={{-85,75},{96,75},{96,10}},
          color={0,0,255},
          thickness=0.5,
          smooth=Smooth.None), Text(
          string="%first",
          index=-1,
          extent={{-6,3},{-6,3}}));
      connect(flowMeasure.q_out, veins.y) annotation (Line(
          points={{52,10},{76,10}},
          color={0,0,0},
          thickness=1,
          smooth=Smooth.None));
      connect(busConnector.Angiotensin2, A2OnConductance.u) annotation (Line(
          points={{-85,75},{-60,75},{-60,36},{4,36}},
          color={0,0,255},
          thickness=0.5,
          smooth=Smooth.None), Text(
          string="%first",
          index=-1,
          extent={{-6,3},{-6,3}}));
      connect(busConnector.Vasopressin, NephroneADHOnConductance.u) annotation (
         Line(
          points={{-85,75},{-60,75},{-60,56},{4,56}},
          color={0,0,255},
          thickness=0.5,
          smooth=Smooth.None), Text(
          string="%first",
          index=-1,
          extent={{-6,3},{-6,3}}));
        annotation (          Documentation(revisions="<html>

<table>
<tr>
<td>Author:</td>
<td>Marek Matejak</td>
</tr>
<tr>
<td>License:</td>
<td><a href=\"http://www.physiomodel.org/license.html\">Physiomodel License 1.0</a> </td>
</tr>
<tr>
<td>By:</td>
<td>Charles University, Prague</td>
</tr>
<tr>
<td>Date of:</td>
<td>2010</td>
</tr>
<tr>
<td>References:</td>
<td>Tom Coleman: QHP 2008 beta 3, University of Mississippi Medical Center</td>
</tr>
</table>
<br/><p>Copyright &copy; 2014 Marek Matejak, Charles University in Prague.</p><br/>

</html>"));
      end VasaRecta;

    model VariableResistorWithMyogenicResponse
      extends Physiolibrary.Icons.Resistor;

      Physiolibrary.Hydraulic.Interfaces.HydraulicPort_a q_in "Blood inflow"
        annotation (extent=[-10,-110; 10,-90], Placement(transformation(extent={{-10,
                -110},{10,-90}}, rotation=0),
                                      iconTransformation(extent={{90,-10},{110,
                10}})));
      Physiolibrary.Hydraulic.Interfaces.HydraulicPort_b q_out "Blood outflow"
        annotation (extent=[-10,-110; 10,-90], Placement(transformation(extent={{-10,
                -110},{10,-90}}, rotation=0),
                                        iconTransformation(extent={{-110,-10},{
                -90,10}})));

      //(q_in(pressure(start=95.5)),q_out(pressure(start=61.5)));
      extends Physiolibrary.SteadyStates.Interfaces.SteadyState(
                                                    stateName="Kidney-MyogenicDelay.PressureChange", state_start=InitialPressureChange);

      Physiolibrary.Types.RealIO.HydraulicConductanceInput cond(displayUnit="ml/(min.mmHg)")
          annotation (Placement(transformation(extent={{-100,92},             {-80,112}}), iconTransformation(
                   extent={{-10,-10},{10,10}},         rotation=270,         origin={0,40})));

      Physiolibrary.Types.Fraction myogenicEffect;
      Physiolibrary.Types.Pressure pressureChange(start=InitialPressureChange); //(start=0.161874);
    //  Real pressureChangeSteadyState;
     // Real adaptedPressure; //(start=77.9546);
    //  Real interlobarPressure;
      parameter Physiolibrary.Types.Pressure InitialPressureChange=0;

      parameter Physiolibrary.Types.Frequency K_PressureChange(displayUnit="1/min") =  2.0/60;
      parameter Physiolibrary.Types.Time Tau_PressureAdoption(displayUnit="hod") =  4.0*60*60;
      parameter Real[:,3] PressureChangeOnMyogenicCondEffect;
      Physiolibrary.Blocks.Interpolation.Curve PressureChangeOnCondEffect(
        x=PressureChangeOnMyogenicCondEffect[:, 1],
        y=PressureChangeOnMyogenicCondEffect[:, 2],
        slope=PressureChangeOnMyogenicCondEffect[:, 3],
        Xscale=101325/760)
        annotation (Placement(transformation(extent={{14,26},{34,46}})));

      AfferentArteryMyogenicReceptors kidneyMyogenic(initialPressure(
            displayUnit="mmHg") = 9999.179056125)
        annotation (Placement(transformation(extent={{-46,50},{-26,70}})));
    //initial equation
     // adaptedPressure = interlobarPressure;
      //der(adaptedPressure) = 0;
     // der(pressureChange) = 0;
    equation
      q_in.q + q_out.q = 0;

      q_in.q = myogenicEffect * cond * (q_in.pressure - q_out.pressure);
      kidneyMyogenic.InterlobarPressure = (q_in.pressure + q_out.pressure)/2;  //stredny tlak v arteriole
     // der(adaptedPressure) = (1/(60*Tau_PressureAdoption)) * (interlobarPressure-adaptedPressure); //receptory sa adaptuju na tlak (polcas adaptacie nastane za 2hod a 45min)
     // pressureChangeSteadyState = interlobarPressure-adaptedPressure;  //zmena tlaku sa taktiez adaptuje - neviem preco? => potom to vizera, ze stimulacia receptorov je postupny proces (polcas nabudenia stimulacie je 20 sekund)

      state = pressureChange;
      change = K_PressureChange * (kidneyMyogenic.PressureChange_SteadyState - pressureChange);

      PressureChangeOnCondEffect.u = pressureChange; //zmena tlaku aktivuje receptory
      myogenicEffect = PressureChangeOnCondEffect.val; //stimulacia receptorov ma vplyv na vodivost (odpor) krvi aferentnej arterie
      annotation ( Icon(graphics={
              Text(
                extent={{-110,-68},{106,-32}},
                textString="%name",
                lineColor={0,0,255}),
              Text(
                extent={{-68,-20},{66,12}},
                lineColor={0,0,0},
                textString="blood flow"),
              Rectangle(
                extent={{-70,30},{70,-30}},
                lineColor={0,0,255},
                fillColor={215,215,215},
                fillPattern=FillPattern.Sphere),
              Text(
                extent={{-54,20},{52,-18}},
                lineColor={0,0,0},
                fillPattern=FillPattern.Sphere,
                fillColor={215,215,215},
                textString="Myogenic")}),
            Documentation(info="<html> <pre>Receptory sa adaptuju na priemerny tlak v arteriole - polcas adaptacie nastane za 2hod a 45min.
        Zmena tlaku sa taktiez adaptuje - neviem preco? =&GT; potom to vizera, ze stimulacia receptorov je postupny proces (polcas nabudenia stimulacie je 20 sekund).
        Zmena tlaku aktivuje receptory, ktorych stimulacia ma vplyv na vasokonstrikciu danej arterioly.</pre> </html>"));
    end VariableResistorWithMyogenicResponse;

      model AfferentArteryMyogenicReceptors
        extends Physiolibrary.SteadyStates.Interfaces.SteadyState(
                                                      stateName="Kidney-Myogenic.AdaptedPressure",
                                                      state_start=initialPressure,
                                                      state(nominal=1e5));
        parameter Physiolibrary.Types.Time Tau = 4*60*60;
        parameter Physiolibrary.Types.Frequency K =   1 / ( Tau);
        parameter Physiolibrary.Types.Pressure initialPressure;
        Physiolibrary.Types.Pressure AdaptedPressure(displayUnit="mmHg");
        Physiolibrary.Types.RealIO.PressureInput
                                           InterlobarPressure(
                                                        displayUnit="mmHg") annotation (
            Placement(transformation(extent={{-100,20},{-60,60}}), iconTransformation(
                extent={{-100,20},{-60,60}})));
        Physiolibrary.Types.RealIO.PressureOutput
                                            PressureChange_SteadyState(
                                                                 displayUnit="mmHg")
          annotation (Placement(transformation(extent={{80,-60},{120,-20}}),
              iconTransformation(extent={{80,-60},{120,-20}})));
      equation
      state = AdaptedPressure;
        change = K  * ( InterlobarPressure  -  AdaptedPressure);

        PressureChange_SteadyState = InterlobarPressure - AdaptedPressure;
      end AfferentArteryMyogenicReceptors;

      package Interfaces
        partial model BaseOD
        extends Physiolibrary.Icons.PerfusionOD;

        Physiolibrary.Hydraulic.Interfaces.HydraulicPort_a q_in "Blood inflow"
          annotation (extent=[-10,-110; 10,-90], Placement(transformation(extent={{-10,
                  -110},{10,-90}}, rotation=0),
                                        iconTransformation(extent={{-110,-10},{-90,10}})));
        Physiolibrary.Hydraulic.Interfaces.HydraulicPort_b q_out
          "Blood outflow"
          annotation (extent=[-10,-110; 10,-90], Placement(transformation(extent={{-10,
                  -110},{10,-90}}, rotation=0),
                                          iconTransformation(extent={{90,-10},{110,10}})));

        Physiolibrary.Types.BusConnector busConnector
          "signals of organ bood flow resistence" annotation (Placement(
              transformation(extent={{-100,80},{-80,100}}), iconTransformation(
                extent={{60,10},{78,28}})));

          Modelica.Blocks.Interfaces.RealOutput BloodFlow
                                                   annotation (Placement(transformation(
                  extent={{-76,-18},{-66,-8}}),iconTransformation(extent={{60,-30},{80,-10}})));
        Physiolibrary.Hydraulic.Sensors.FlowMeasure flowMeasure annotation (
            Placement(transformation(
              extent={{-10,-10},{10,10}},
              origin={-82,0})));
        equation

          connect(q_in, flowMeasure.q_in) annotation (Line(
              points={{-100,0},{-92,0}},
              color={0,0,0},
              thickness=1,
              smooth=Smooth.None));
          connect(flowMeasure.volumeFlow, BloodFlow) annotation (Line(
              points={{-82,12},{-82,-13},{-71,-13}},
              color={0,0,127},
              smooth=Smooth.None));
          annotation (Documentation(info="<HTML>
<PRE>
Blood flow variable resistor abstract model.
</PRE>
</HTML>
",       revisions="<html>

<table>
<tr>
<td>Author:</td>
<td>Marek Matejak</td>
</tr>
<tr>
<td>License:</td>
<td><a href=\"http://www.physiomodel.org/license.html\">Physiomodel License 1.0</a> </td>
</tr>
<tr>
<td>By:</td>
<td>Charles University, Prague</td>
</tr>
<tr>
<td>Date of:</td>
<td>2009</td>
</tr>
</table>
<br/><p>Copyright &copy; 2014 Marek Matejak, Charles University in Prague.</p><br/>

</html>"));
        end BaseOD;

        partial model BaseDO
        extends Physiolibrary.Icons.PerfusionDO;

        Physiolibrary.Hydraulic.Interfaces.HydraulicPort_a q_in "Blood inflow"
          annotation (extent=[-10,-110; 10,-90], Placement(transformation(extent={{-10,
                  -110},{10,-90}}, rotation=0),
                                        iconTransformation(extent={{90,-10},{110,
                  10}})));
        Physiolibrary.Hydraulic.Interfaces.HydraulicPort_b q_out
          "Blood outflow"
          annotation (extent=[-10,-110; 10,-90], Placement(transformation(extent={{-10,
                  -110},{10,-90}}, rotation=0),
                                          iconTransformation(extent={{-110,-10},{
                  -90,10}})));

        Physiolibrary.Types.BusConnector busConnector
          "signals of organ bood flow resistence" annotation (Placement(
              transformation(extent={{-100,80},{-80,100}}), iconTransformation(
                extent={{60,10},{78,28}})));

          Modelica.Blocks.Interfaces.RealOutput BloodFlow
                                                   annotation (Placement(transformation(
                  extent={{90,-22},{102,-10}}),iconTransformation(extent={{60,-60},{80,
                    -40}})));
        Physiolibrary.Hydraulic.Sensors.FlowMeasure flowMeasure annotation (
            Placement(transformation(
              extent={{10,-10},{-10,10}},
              origin={88,0})));
        equation

          connect(flowMeasure.volumeFlow, BloodFlow) annotation (Line(
              points={{88,12},{88,-16},{96,-16}},
              color={0,0,127},
              smooth=Smooth.None));
          connect(flowMeasure.q_in, q_in) annotation (Line(
              points={{98,0},{100,0}},
              color={0,0,0},
              thickness=1,
              smooth=Smooth.None));
          annotation (Documentation(info="<HTML>
<PRE>
Blood flow variable resistor abstract model.
</PRE>
</HTML>
",       revisions="<html>

<table>
<tr>
<td>Author:</td>
<td>Marek Matejak</td>
</tr>
<tr>
<td>License:</td>
<td><a href=\"http://www.physiomodel.org/license.html\">Physiomodel License 1.0</a> </td>
</tr>
<tr>
<td>By:</td>
<td>Charles University, Prague</td>
</tr>
<tr>
<td>Date of:</td>
<td>2009</td>
</tr>
</table>
<br/><p>Copyright &copy; 2014 Marek Matejak, Charles University in Prague.</p><br/>

</html>"));
        end BaseDO;

        partial model Heart
          extends Physiomodel.CardioVascular.Microcirculation.Interfaces.BaseDO;

        //parameter Real BasicLargeVeselsConductance( final quantity="Conductance", final displayUnit="ml/(min.mmHg)");
        //parameter Real BasicSmallVeselsConductance( final quantity="Conductance", final displayUnit="ml/(min.mmHg)");
        parameter Physiolibrary.Types.HydraulicConductance BasicLargeVeselsConductance( displayUnit="ml/(min.mmHg)");
        parameter Physiolibrary.Types.HydraulicConductance BasicSmallVeselsConductance( displayUnit="ml/(min.mmHg)");

        Physiolibrary.Blocks.Factors.Spline PO2Effect(data={{12,2.0,0},{17,1.0,-0.04},
              {30,0.8,0}}, Xscale=101325/760)
          annotation (Placement(transformation(extent={{60,20},{80,40}})));
        Physiolibrary.Blocks.Factors.Spline ADHEffect2(
          data={{0.8,1.0,0},{3.0,0.1,0}},
          UsePositiveLog10=true,
          Xscale=1e-9/Substances.Vasopressin.mw)
          annotation (Placement(transformation(extent={{60,58},{80,78}})));
        Physiolibrary.Blocks.Factors.Spline MetabolismEffect(data={{30,1.0,0},{
              100,3.0,0}}, Xscale=1/1362657.193569)
          "O2Need 1 ml_STP/min = 1/1362657.193569 mol/s"
          annotation (Placement(transformation(extent={{60,10},{80,30}})));
        Physiolibrary.Blocks.Factors.Normalization Anesthesia
          annotation (Placement(transformation(extent={{60,66},{80,86}})));
        Physiolibrary.Types.Constants.HydraulicConductanceConst
          LargeVesselBasicConductance(k=BasicLargeVeselsConductance)
          annotation (Placement(transformation(extent={{-6,18},{-18,30}})));
        Physiolibrary.Blocks.Factors.Normalization Viscosity1
          annotation (Placement(transformation(extent={{-30,4},{-10,24}})));
        Physiolibrary.Types.Constants.HydraulicConductanceConst
          SmallVesselBasicConductance(k=BasicSmallVeselsConductance)
          annotation (Placement(transformation(extent={{90,86},{78,98}})));
          Physiomodel.Nerves.AplhaReceptorsActivityFactor aplhaReceptorsActivityFactor(
              data={{0.0,1.3,0},{1.0,1.0,-0.16},{4.0,0.8,0}})
            annotation (Placement(transformation(extent={{60,46},{80,66}})));
        Physiolibrary.Blocks.Factors.DamagedFraction Infraction
          annotation (Placement(transformation(extent={{60,2},{80,22}})));
          Physiolibrary.Blocks.Factors.SplineLagOrZero              Vasculature(
              data={{41,1.2,0},{51,1.0,-0.03},{61,0.8,0}}, HalfTime=30*86400*Modelica.Math.log(2),
            integrator(y_start=1.2),
          Xscale=101325/760)
            annotation (Placement(transformation(extent={{60,30},{80,50}})));
        Physiolibrary.Blocks.Factors.Normalization Viscosity
          annotation (Placement(transformation(extent={{60,74},{80,94}})));
        Physiolibrary.Hydraulic.Components.Conductor resistor2_1(
            useConductanceInput=true)
          annotation (Placement(transformation(extent={{60,-10},{80,10}})));
        Physiolibrary.Hydraulic.Components.Conductor resistor2_2(
            useConductanceInput=true)
          annotation (Placement(transformation(extent={{-30,-10},{-10,10}})));
        equation
          connect(LargeVesselBasicConductance.y, Viscosity1.yBase) annotation (Line(
              points={{-19.5,24},{-20,24},{-20,16}},
              color={0,0,127},
              smooth=Smooth.None));
          connect(Viscosity.y, Anesthesia.yBase) annotation (Line(
              points={{70,80},{70,78}},
              color={0,0,127},
              smooth=Smooth.None));
          connect(busConnector.Anesthesia_VascularConductance, Anesthesia.u)
            annotation (Line(
              points={{-90,90},{6,90},{6,76},{62,76}},
              color={0,0,255},
              thickness=0.5,
              smooth=Smooth.None), Text(
              string="%first",
              index=-1,
              extent={{-6,3},{-6,3}}));
          connect(busConnector.Viscosity_ConductanceEffect, Viscosity.u) annotation (
              Line(
              points={{-90,90},{6,90},{6,84},{62,84}},
              color={0,0,255},
              thickness=0.5,
              smooth=Smooth.None), Text(
              string="%first",
              index=-1,
              extent={{-6,3},{-6,3}}));
          connect(busConnector.AlphaPool_Effect, aplhaReceptorsActivityFactor.AlphaPool_Effect)
            annotation (Line(
              points={{-90,90},{6,90},{6,62},{60.2,62}},
              color={0,0,255},
              thickness=0.5,
              smooth=Smooth.None), Text(
              string="%first",
              index=-1,
              extent={{-6,3},{-6,3}}));
          connect(busConnector.AlphaBlocade_Effect, aplhaReceptorsActivityFactor.AlphaBlockade_Effect)
            annotation (Line(
              points={{-90,90},{6,90},{6,56},{60.2,56}},
              color={0,0,255},
              thickness=0.5,
              smooth=Smooth.None), Text(
              string="%first",
              index=-1,
              extent={{-6,3},{-6,3}}));
          connect(busConnector.GangliaGeneral_NA, aplhaReceptorsActivityFactor.GangliaGeneral_NA)
            annotation (Line(
              points={{-90,90},{6,90},{6,50},{60.2,50}},
              color={0,0,255},
              thickness=0.5,
              smooth=Smooth.None), Text(
              string="%first",
              index=-1,
              extent={{-6,3},{-6,3}}));
          connect(busConnector.Viscosity_ConductanceEffect, Viscosity1.u) annotation (
              Line(
              points={{-90,90},{-74,90},{-74,14},{-28,14}},
              color={0,0,255},
              thickness=0.5,
              smooth=Smooth.None), Text(
              string="%first",
              index=-1,
              extent={{-6,3},{-6,3}}));
          connect(Viscosity.yBase, SmallVesselBasicConductance.y) annotation (
              Line(
              points={{70,86},{70,92},{76.5,92}},
              color={0,0,127},
              smooth=Smooth.None));
          connect(Anesthesia.y, ADHEffect2.yBase) annotation (Line(
              points={{70,72},{70,70}},
              color={0,0,127},
              smooth=Smooth.None));
          connect(ADHEffect2.y, aplhaReceptorsActivityFactor.yBase) annotation (
              Line(
              points={{70,64},{70,63}},
              color={0,0,127},
              smooth=Smooth.None));
          connect(aplhaReceptorsActivityFactor.y, Vasculature.yBase) annotation (
              Line(
              points={{70,49},{70,46}},
              color={0,0,127},
              smooth=Smooth.None));
          connect(Vasculature.y, PO2Effect.yBase) annotation (Line(
              points={{70,34},{70,32}},
              color={0,0,127},
              smooth=Smooth.None));
          connect(PO2Effect.y, MetabolismEffect.yBase) annotation (Line(
              points={{70,26},{70,22}},
              color={0,0,127},
              smooth=Smooth.None));
          connect(MetabolismEffect.y, Infraction.yBase) annotation (Line(
              points={{70,16},{70,14}},
              color={0,0,127},
              smooth=Smooth.None));
          connect(q_out, resistor2_2.q_in) annotation (Line(
              points={{-100,0},{-30,0}},
              color={0,0,0},
              thickness=1,
              smooth=Smooth.None));
          connect(resistor2_2.q_out, resistor2_1.q_in) annotation (Line(
              points={{-10,0},{60,0}},
              color={0,0,0},
              thickness=1,
              smooth=Smooth.None));
          connect(resistor2_1.q_out, flowMeasure.q_out) annotation (Line(
              points={{80,0},{78,0}},
              color={0,0,0},
              thickness=1,
              smooth=Smooth.None));
          connect(resistor2_1.cond, Infraction.y) annotation (Line(
              points={{70,6},{70,8}},
              color={0,0,127},
              smooth=Smooth.None));
          connect(resistor2_2.cond, Viscosity1.y) annotation (Line(
              points={{-20,6},{-20,10}},
              color={0,0,127},
              smooth=Smooth.None));
        connect(busConnector.Vasopressin, ADHEffect2.u) annotation (Line(
            points={{-90,90},{6,90},{6,68},{62,68}},
            color={0,0,255},
            thickness=0.5,
            smooth=Smooth.None), Text(
            string="%first",
            index=-1,
            extent={{-6,3},{-6,3}}));
          annotation (
            Documentation(info="<HTML>
<PRE>
Blood resistance in left heart.

QHP 2008 / LeftHeart-Flow

</PRE>
</HTML>
",       revisions="<html>
<ul>
<li><i>  </i>
       </li>
<li><i> january 2009 </i><br>
       by Marek Matejak in Modelica initially implemented (consulted with Jiri Kofranek), Charles University, Prague<br>
       orginaly described by Tom Coleman in QHP 2008 beta 3, University of Mississippi Medical Center
       </li>
</ul>
</html>"), Icon(graphics={Text(
                  extent={{-100,-100},{100,-80}},
                  lineColor={0,0,255},
                  textString="%name")}));
        end Heart;
      end Interfaces;
    end Microcirculation;

    package Blood "Red Cells and Blood Properties"
      class References "References"
        extends Modelica.Icons.References;

        annotation (Documentation(info="<html>
<table>

	<tr>
		<td>[Begg1966]</td>
		<td>T. Begg and J. Hearns, \"Components in blood viscosity. The relative contribution of haematocrit, plasma fibrinogen and other proteins,\" Clinical science, vol. 31, pp. 87-93, 1966. </td>
	</tr>
	<tr>
		<td>[Brezis1995]</td>
		<td>M. Brezis and S. Rosen, \"Hypoxia of the Renal Medulla — Its Implications for Disease,\" New England Journal of Medicine, vol. 332, pp. 647-655, 1995. </td>
	</tr>
	<tr>
		<td>[Fan1980]</td>
		<td>F. C. Fan, R. Y. Chen, G. B. Schuessler, and S. Chien, Effects of hematocrit variations on regional hemodynamics and oxygen transport in the dog vol. 238, 1980. </td>
	</tr>
	<tr>
		<td>[Jan1977]</td>
		<td>K. M. Jan and S. Chien, Effect of hematocrit variations on coronary hemodynamics and oxygen utilization vol. 233, 1977. </td>
	</tr>
	<tr>
		<td>[Schrier1970]</td>
		<td>R. W. Schrier, K. M. McDonald, R. Wells, and D. P. Lauler, \"Influence of hematocrit and colloid on whole blood viscosity during volume expansion,\" Am. J. Physiol, vol. 218, p. 77, 1970. </td>
	</tr>
	<tr>
		<td>[Stone1968]</td>
		<td>H. Stone, Thompson HK, and K. Schmidt-Nielsen, Influence of erythrocytes on blood viscosity vol. 214, 1968. </td>
	</tr>
	<tr>
		<td>[Whittaker1933]</td>
		<td>S. R. F. Whittaker and F. R. Winton, \"The apparent viscosity of blood flowing in the isolated hindlimb of the dog, and its variation with corpuscular concentration,\" The Journal of Physiology, vol. 78, pp. 339-369, July 10, 1933 1933.  </td>
	</tr>


</table>
</html>"));
      end References;

      model RedCells2
        extends Physiolibrary.Icons.RedCells;
        Physiolibrary.Blocks.Factors.SplineLag      EPOEffect(
          HalfTime=3*86400*Modelica.Math.log(2),
          data={{0.0,0.0,0},{1.3,1.0,1.0},{4.0,4.0,0}},
          stateName="[EPO]Delay.Effect",
        UsePositiveLog10=true,
        Xscale=1e3) "20 miu/ml = 20e3 iu/m3"
          annotation (Placement(transformation(extent={{-46,-16},{-26,4}})));
      Physiolibrary.Types.BusConnector busConnector
        annotation (Placement(transformation(extent={{-88,58},{-68,78}})));
        Physiolibrary.Blocks.Math.FractionGain
                                  H2O(f=0.66)
          annotation (Placement(transformation(extent={{-4,-4},{4,4}},
            origin={54,-84})));
      Hormones.EPO EPO
        annotation (Placement(transformation(extent={{-74,-16},{-54,4}})));
      Physiolibrary.Population.Sources.Growth transfusion(useChangeInput=true)
        annotation (Placement(transformation(extent={{-46,-52},{-26,-32}})));
      Physiolibrary.Population.Sources.Growth erythropoiesis(useChangeInput=
            true)
        annotation (Placement(transformation(extent={{-46,-30},{-26,-10}})));
      Physiolibrary.Population.Sources.Loss hemorrhage(useChangeInput=true)
        annotation (Placement(transformation(extent={{58,-32},{78,-12}})));
      Physiolibrary.Population.Components.Mortality mortality(LifeTime(
            displayUnit="d") = 10368000)
        annotation (Placement(transformation(extent={{58,-52},{78,-32}})));
      Physiolibrary.Population.Components.Population erythrocytes(
        population_start=12e12,
        NominalPopulation=1e12,
        NominalPopulationChange=1e6)
        "red cell count (with density of 5e6 per one uL)"
        annotation (Placement(transformation(extent={{4,-42},{24,-22}})));
        Modelica.Blocks.Math.Gain RBCVol(k=2.4e-3/12e12) "12e12 cells == 2.4 L"
        annotation (Placement(transformation(
            extent={{-4,-4},{4,4}},
            origin={30,-76})));
      Physiolibrary.Types.Constants.PopulationChangeConst RBCBaseSecretionRate(
          k=1.16e6) "13.7 ml/day (12e12 cells == 2.4 L)"
        annotation (Placement(transformation(extent={{-50,8},{-42,16}})));
        Modelica.Blocks.Math.Gain RBCVolToCells(k=12e12/2.4e-3)
        "12e12 cells == 2.4 L" annotation (Placement(transformation(
            extent={{-4,-4},{4,4}},
            origin={-58,-36})));
        Modelica.Blocks.Math.Gain RBCVol2(k=12e12/2.4e-3)
        "12e12 cells == 2.4 L" annotation (Placement(transformation(
            extent={{-4,-4},{4,4}},
            rotation=270,
            origin={68,0})));
      equation

        connect(H2O.y, busConnector.RBCH2O_Vol) annotation (Line(
            points={{58.4,-84},{98,-84},{98,68},{-78,68}},
            color={0,0,127},
            smooth=Smooth.None), Text(
            string="%second",
            index=1,
            extent={{6,3},{6,3}}));
      connect(EPOEffect.u, EPO.Erythropoetin) annotation (Line(
          points={{-44,-6},{-54,-6}},
          color={0,0,127},
          smooth=Smooth.None));
      connect(busConnector, EPO.busConnector) annotation (Line(
          points={{-78,68},{-78,-12},{-72,-12}},
          color={255,204,51},
          thickness=0.5,
          smooth=Smooth.None));
      connect(EPOEffect.y, erythropoiesis.populationChange) annotation (Line(
          points={{-36,-10},{-36,-16}},
          color={0,0,127},
          smooth=Smooth.None));
      connect(erythropoiesis.port_b, erythrocytes.port) annotation (Line(
          points={{-26,-20},{-6,-20},{-6,-32},{14,-32}},
          color={0,127,127},
          thickness=1,
          smooth=Smooth.None));
      connect(transfusion.port_b, erythrocytes.port) annotation (Line(
          points={{-26,-42},{-6,-42},{-6,-32},{14,-32}},
          color={0,127,127},
          thickness=1,
          smooth=Smooth.None));
      connect(erythrocytes.port, hemorrhage.port_a) annotation (Line(
          points={{14,-32},{34,-32},{34,-22},{58,-22}},
          color={0,127,127},
          thickness=1,
          smooth=Smooth.None));
      connect(erythrocytes.port, mortality.port_a) annotation (Line(
          points={{14,-32},{34,-32},{34,-42},{58.2,-42}},
          color={0,127,127},
          thickness=1,
          smooth=Smooth.None));
      connect(RBCVol.y, H2O.u) annotation (Line(
          points={{34.4,-76},{42,-76},{42,-84},{49.2,-84}},
          color={0,0,127},
          smooth=Smooth.None));
      connect(erythrocytes.population, RBCVol.u) annotation (Line(
          points={{20,-42},{20,-76},{25.2,-76}},
          color={0,0,127},
          smooth=Smooth.None));
      connect(RBCVol.y, busConnector.RBCVol_Vol) annotation (Line(
          points={{34.4,-76},{98,-76},{98,68},{-78,68}},
          color={0,0,127},
          smooth=Smooth.None), Text(
          string="%second",
          index=1,
          extent={{6,3},{6,3}}));
      connect(RBCBaseSecretionRate.y, EPOEffect.yBase) annotation (Line(
          points={{-41,12},{-36,12},{-36,-4}},
          color={0,0,127},
          smooth=Smooth.None));
      connect(transfusion.populationChange, RBCVolToCells.y) annotation (Line(
          points={{-36,-38},{-36,-36},{-53.6,-36}},
          color={0,0,127},
          smooth=Smooth.None));
      connect(busConnector.Transfusion_RBCRate, RBCVolToCells.u) annotation (
          Line(
          points={{-78,68},{-78,-36},{-62.8,-36}},
          color={255,204,51},
          thickness=0.5,
          smooth=Smooth.None), Text(
          string="%first",
          index=-1,
          extent={{-6,3},{-6,3}}));
      connect(busConnector.Hemorrhage_RBCRate, RBCVol2.u) annotation (Line(
          points={{-78,68},{68,68},{68,4.8}},
          color={255,204,51},
          thickness=0.5,
          smooth=Smooth.None), Text(
          string="%first",
          index=-1,
          extent={{-6,3},{-6,3}}));
      connect(RBCVol2.y, hemorrhage.populationChange) annotation (Line(
          points={{68,-4.4},{68,-18}},
          color={0,0,127},
          smooth=Smooth.None));
        annotation ( Icon(coordinateSystem(
                preserveAspectRatio=false, extent={{-100,-100},{100,100}}),
              graphics={                  Text(
                extent={{-136,-46},{148,-68}},
                lineColor={0,0,255},
                textString="%name")}),
          Documentation(revisions="<html>

<table>
<tr>
<td>Author:</td>
<td>Marek Matejak</td>
</tr>
<tr>
<td>License:</td>
<td><a href=\"http://www.physiomodel.org/license.html\">Physiomodel License 1.0</a> </td>
</tr>
<tr>
<td>By:</td>
<td>Charles University, Prague</td>
</tr>
<tr>
<td>Date of:</td>
<td>2009</td>
</tr>
<tr>
<td>References:</td>
<td>Tom Coleman: QHP 2008 beta 3, University of Mississippi Medical Center</td>
</tr>
</table>
<br/><p>Copyright &copy; 2014 Marek Matejak, Charles University in Prague.</p><br/>

</html>"));
      end RedCells2;

      model BloodPropertiesBase
          extends Physiolibrary.Icons.Blood;

        Modelica.Blocks.Math.Add BloodVolume
          annotation (Placement(transformation(extent={{10,-70},{18,-62}})));
        Modelica.Blocks.Math.Min CollapsedEffect
          annotation (Placement(transformation(extent={{50,-84},{58,-76}})));
        Modelica.Blocks.Math.Division division
          annotation (Placement(transformation(extent={{38,-78},{46,-70}})));
      Physiolibrary.Types.Constants.OneConst one
        annotation (Placement(transformation(extent={{38,-94},{46,-86}})));
        Modelica.Blocks.Math.Division HtcFract
          annotation (Placement(transformation(extent={{32,-46},{40,-38}})));
      Physiolibrary.Blocks.Interpolation.Curve HtcOnVisc(
        x={0,0.44,0.8},
        y={0.5,1,5},
        slope={0.8,3,30})
        annotation (Placement(transformation(extent={{46,-52},{66,-32}})));
        Modelica.Blocks.Math.Division division1
          annotation (Placement(transformation(extent={{78,-40},{86,-32}})));
      Physiolibrary.Types.Constants.OneConst one1
        annotation (Placement(transformation(extent={{64,-30},{72,-22}})));
      Physiolibrary.Types.Constants.OneConst one2
        annotation (Placement(transformation(extent={{28,-14},{36,-6}})));
        Modelica.Blocks.Math.Feedback PVCrit
          annotation (Placement(transformation(extent={{38,-14},{46,-6}})));
      Physiolibrary.Types.Constants.ConcentrationConst Hb(k=9.3)
        annotation (Placement(transformation(extent={{-20,8},{-28,16}})));
      Physiolibrary.Blocks.Factors.Normalization hematocritEffect(NormalValue=
            0.44)
        annotation (Placement(transformation(extent={{-44,-10},{-24,10}})));
      Physiolibrary.Types.Constants.ConcentrationConst DPG(k=5.4)
        annotation (Placement(transformation(extent={{26,90},{18,98}})));
      Physiolibrary.Types.Constants.FractionConst FMetHb(k=0.005)
        annotation (Placement(transformation(extent={{26,82},{18,90}})));
      Physiolibrary.Types.Constants.FractionConst FHbF(k=0.005)
        annotation (Placement(transformation(extent={{26,74},{18,82}})));
      Physiolibrary.Types.BusConnector busConnector
        annotation (Placement(transformation(extent={{-104,58},{-84,78}})));
        Modelica.Blocks.Math.Division division3(y(displayUnit="mmol/l"))
          annotation (Placement(transformation(extent={{-4,-4},{4,4}},
              origin={-4,2})));
        Modelica.Blocks.Math.Feedback feedback
          annotation (Placement(transformation(extent={{-20,32},{-40,52}})));
        Modelica.Blocks.Math.Add BloodVolume1
          annotation (Placement(transformation(extent={{-46,24},{-38,32}})));
        Modelica.Blocks.Math.Product product
          annotation (Placement(transformation(extent={{66,2},{74,10}})));
        Modelica.Blocks.Math.Sum V0(nin=5)
          annotation (Placement(transformation(extent={{-30,-90},{-22,-82}})));
        Modelica.Blocks.Math.Sum VeinsVol(nin=5) "volume of deoxygenated blood"
          annotation (Placement(transformation(extent={{-26,-54},{-18,-46}})));
        Modelica.Blocks.Math.Sum ArtysVol(nin=4) "volume of oxygenated blood"
          annotation (Placement(transformation(extent={{-26,-34},{-18,-26}})));
      equation
        connect(busConnector.PlasmaVol_Vol, BloodVolume.u2)
                                                    annotation (Line(
            points={{-94,68},{-94,-68.4},{9.2,-68.4}},
            color={0,0,127},
            smooth=Smooth.None));
        connect(busConnector.RBCVol_Vol, BloodVolume.u1)
                                                  annotation (Line(
            points={{-94,68},{-94,-63.6},{9.2,-63.6}},
            color={0,0,127},
            smooth=Smooth.None));
        connect(division.y, CollapsedEffect.u1)
                                    annotation (Line(
            points={{46.4,-74},{47.8,-74},{47.8,-77.6},{49.2,-77.6}},
            color={0,0,127},
            smooth=Smooth.None));
        connect(BloodVolume.y, division.u1)
                                    annotation (Line(
            points={{18.4,-66},{28,-66},{28,-71.6},{37.2,-71.6}},
            color={0,0,127},
            smooth=Smooth.None));
      connect(one.y, CollapsedEffect.u2) annotation (Line(
          points={{47,-90},{48,-90},{48,-82.4},{49.2,-82.4}},
          color={0,0,127},
          smooth=Smooth.None));
        connect(CollapsedEffect.y, busConnector.BloodVol_CollapsedEffect)
                                                              annotation (Line(
            points={{58.4,-80},{90,-80},{90,68},{-94,68}},
            color={0,0,127},
            smooth=Smooth.None));
        connect(HtcFract.u2, BloodVolume.y)
                                    annotation (Line(
            points={{31.2,-44.4},{26,-44.4},{26,-66},{18.4,-66}},
            color={0,0,127},
            smooth=Smooth.None));
        connect(HtcFract.u1,busConnector. RBCVol_Vol) annotation (Line(
            points={{31.2,-39.6},{-94,-39.6},{-94,68}},
            color={0,0,127},
            smooth=Smooth.None));
        connect(HtcFract.y,HtcOnVisc. u) annotation (Line(
            points={{40.4,-42},{46,-42}},
            color={0,0,127},
            smooth=Smooth.None));
      connect(one1.y, division1.u1) annotation (Line(
          points={{73,-26},{74,-26},{74,-33.6},{77.2,-33.6}},
          color={0,0,127},
          smooth=Smooth.None));
        connect(HtcOnVisc.val,division1. u2) annotation (Line(
            points={{66,-42},{75.5,-42},{75.5,-38.4},{77.2,-38.4}},
            color={0,0,127},
            smooth=Smooth.None));
        connect(division1.y,busConnector. Viscosity_ConductanceEffect) annotation (Line(
            points={{86.4,-36},{90,-36},{90,68},{-94,68}},
            color={0,0,127},
            smooth=Smooth.None));
        connect(HtcFract.y,busConnector. BloodVol_Hct) annotation (Line(
            points={{40.4,-42},{42,-42},{42,-20},{-94,-20},{-94,68}},
            color={0,0,127},
            smooth=Smooth.None));
      connect(one2.y, PVCrit.u1) annotation (Line(
          points={{37,-10},{38.8,-10}},
          color={0,0,127},
          smooth=Smooth.None));
        connect(HtcFract.y,PVCrit. u2) annotation (Line(
            points={{40.4,-42},{42,-42},{42,-13.2}},
            color={0,0,127},
            smooth=Smooth.None));
        connect(PVCrit.y,busConnector. BloodVol_PVCrit) annotation (Line(
            points={{45.6,-10},{90,-10},{90,68},{-94,68}},
            color={0,0,127},
            smooth=Smooth.None), Text(
            string="%second",
            index=1,
            extent={{6,3},{6,3}}));
      connect(Hb.y, hematocritEffect.yBase) annotation (Line(
          points={{-29,12},{-34,12},{-34,2}},
          color={0,0,127},
          smooth=Smooth.None));
        connect(hematocritEffect.y,busConnector. ctHb) annotation (Line(
            points={{-34,-4},{-34,-10},{-94,-10},{-94,68}},
            color={0,0,127},
            smooth=Smooth.None), Text(
            string="%second",
            index=1,
            extent={{6,3},{6,3}}));
      connect(busConnector.cDPG, DPG.y) annotation (Line(
          points={{-94,68},{-4,68},{-4,94},{17,94}},
          color={0,0,255},
          thickness=0.5,
          smooth=Smooth.None), Text(
          string="%first",
          index=-1,
          extent={{-6,3},{-6,3}}));
      connect(busConnector.FMetHb, FMetHb.y) annotation (Line(
          points={{-94,68},{-4,68},{-4,86},{17,86}},
          color={0,0,255},
          thickness=0.5,
          smooth=Smooth.None), Text(
          string="%first",
          index=-1,
          extent={{-6,3},{-6,3}}));
      connect(busConnector.FHbF, FHbF.y) annotation (Line(
          points={{-94,68},{-4,68},{-4,78},{17,78}},
          color={0,0,255},
          thickness=0.5,
          smooth=Smooth.None), Text(
          string="%first",
          index=-1,
          extent={{-6,3},{-6,3}}));
      connect(Hb.y, division3.u1) annotation (Line(
          points={{-29,12},{-34,12},{-34,4},{-8.8,4},{-8.8,4.4}},
          color={0,0,127},
          smooth=Smooth.None));
        connect(HtcFract.y, division3.u2) annotation (Line(
            points={{40.4,-42},{42,-42},{42,-20},{-18,-20},{-18,-0.4},{-8.8,
              -0.4}},
            color={0,0,127},
            smooth=Smooth.None));

        connect(division3.y, busConnector.ctHb_ery) annotation (Line(
            points={{0.4,2},{20,2},{20,68},{-94,68}},
            color={0,0,127},
            smooth=Smooth.None), Text(
            string="%second",
            index=1,
            extent={{6,3},{6,3}}));
        connect(BloodVolume.y, feedback.u1) annotation (Line(
            points={{18.4,-66},{26,-66},{26,42},{-22,42}},
            color={0,0,127},
            smooth=Smooth.None));
        connect(busConnector.ArtysVol, BloodVolume1.u1) annotation (Line(
            points={{-94,68},{-94,30},{-46.8,30},{-46.8,30.4}},
            color={0,0,255},
            thickness=0.5,
            smooth=Smooth.None), Text(
            string="%first",
            index=-1,
            extent={{-6,3},{-6,3}}));
        connect(busConnector.VeinsVol, BloodVolume1.u2) annotation (Line(
            points={{-94,68},{-94,26},{-46.8,26},{-46.8,25.6}},
            color={0,0,255},
            thickness=0.5,
            smooth=Smooth.None), Text(
            string="%first",
            index=-1,
            extent={{-6,3},{-6,3}}));
        connect(BloodVolume1.y, feedback.u2) annotation (Line(
            points={{-37.6,28},{-30,28},{-30,34}},
            color={0,0,127},
            smooth=Smooth.None));
        connect(PVCrit.y, product.u2) annotation (Line(
            points={{45.6,-10},{54,-10},{54,3.6},{65.2,3.6}},
            color={0,0,127},
            smooth=Smooth.None));
        connect(busConnector.PortalVein_BloodFlow, product.u1) annotation (Line(
            points={{-94,68},{54,68},{54,8.4},{65.2,8.4}},
            color={0,0,255},
            thickness=0.5,
            smooth=Smooth.None));
        connect(product.y, busConnector.PortalVein_PlasmaFlow) annotation (Line(
            points={{74.4,6},{90,6},{90,68},{-94,68}},
            color={0,0,127},
            smooth=Smooth.None));

        connect(busConnector.PulmonaryCirculation_V0,V0. u[1])
          annotation (Line(
            points={{-94,68},{-94,-82},{-32,-82},{-32,-86.64},{-30.8,-86.64}},
            color={0,0,255},
            thickness=0.5,
            smooth=Smooth.None), Text(
            string="%first",
            index=-1,
            extent={{-6,6},{-6,6}}));
        connect(busConnector.Heart_V0,V0. u[2]) annotation (
            Line(
            points={{-94,68},{-94,-86.32},{-30.8,-86.32}},
            color={0,0,255},
            thickness=0.5,
            smooth=Smooth.None), Text(
            string="%first",
            index=-1,
            extent={{-6,2},{-6,2}}));
        connect(busConnector.SystemicArtys_V0,V0. u[3])
          annotation (Line(
            points={{-94,68},{-94,-90},{-32,-90},{-32,-86},{-30.8,-86}},
            color={0,0,255},
            thickness=0.5,
            smooth=Smooth.None), Text(
            string="%first",
            index=-1,
            extent={{-6,-2},{-6,-2}}));
        connect(busConnector.PortalVein_V0,V0. u[4]) annotation (Line(
            points={{-94,68},{-94,-94},{-32,-94},{-32,-86},{-30.8,-85.68}},
            color={0,0,255},
            thickness=0.5,
            smooth=Smooth.None), Text(
            string="%first",
            index=-1,
            extent={{-6,-6},{-6,-6}}));
        connect(busConnector.SystemicVeins_V0,V0. u[5]) annotation (Line(
            points={{-94,68},{-94,-98},{-32,-98},{-32,-86},{-30.8,-85.36}},
            color={0,0,255},
            thickness=0.5,
            smooth=Smooth.None), Text(
            string="%first",
            index=-1,
            extent={{-6,-10},{-6,-10}}));
        connect(VeinsVol.y, busConnector.VeinsVol) annotation (Line(
            points={{-17.6,-50},{2,-50},{2,-42},{-94,-42},{-94,68}},
            color={0,0,127},
            smooth=Smooth.None), Text(
            string="%second",
            index=1,
            extent={{6,3},{6,3}}));
        connect(busConnector.PulmonaryCirculation_DeoxygenatedBloodVolume,VeinsVol. u[1])
          annotation (Line(
            points={{-94,68},{-94,-46},{-28,-46},{-28,-50.64},{-26.8,-50.64}},
            color={0,0,255},
            thickness=0.5,
            smooth=Smooth.None), Text(
            string="%first",
            index=-1,
            extent={{-6,6},{-6,6}}));
        connect(busConnector.Heart_DeoxygenatedBloodVolume,VeinsVol. u[2]) annotation (
            Line(
            points={{-94,68},{-94,-50.32},{-26.8,-50.32}},
            color={0,0,255},
            thickness=0.5,
            smooth=Smooth.None), Text(
            string="%first",
            index=-1,
            extent={{-6,2},{-6,2}}));
        connect(busConnector.SplanchnicCirculation_DeoxygenatedBloodVolume,VeinsVol. u[3])
          annotation (Line(
            points={{-94,68},{-94,-54},{-28,-54},{-28,-50},{-26.8,-50}},
            color={0,0,255},
            thickness=0.5,
            smooth=Smooth.None), Text(
            string="%first",
            index=-1,
            extent={{-6,-2},{-6,-2}}));
        connect(busConnector.SystemicVeins_DeoxygenatedBloodVolume,VeinsVol. u[4])
          annotation (Line(
            points={{-94,68},{-94,-58},{-28,-58},{-28,-49.68},{-26.8,-49.68}},
            color={0,0,255},
            thickness=0.5,
            smooth=Smooth.None), Text(
            string="%first",
            index=-1,
            extent={{-6,-6},{-6,-6}}));
        connect(ArtysVol.y, busConnector.ArtysVol) annotation (Line(
            points={{-17.6,-30},{2,-30},{2,-22},{-94,-22},{-94,68}},
            color={0,0,127},
            smooth=Smooth.None), Text(
            string="%second",
            index=1,
            extent={{6,3},{6,3}}));
        connect(busConnector.PulmonaryCirculation_OxygenatedBloodVolume,ArtysVol. u[1])
          annotation (Line(
            points={{-94,68},{-94,-26},{-28,-26},{-28,-30.6},{-26.8,-30.6}},
            color={0,0,255},
            thickness=0.5,
            smooth=Smooth.None), Text(
            string="%first",
            index=-1,
            extent={{-6,6},{-6,6}}));
        connect(busConnector.Heart_OxygenatedBloodVolume,ArtysVol. u[2]) annotation (
            Line(
            points={{-94,68},{-94,-30.2},{-26.8,-30.2}},
            color={0,0,255},
            thickness=0.5,
            smooth=Smooth.None), Text(
            string="%first",
            index=-1,
            extent={{-6,2},{-6,2}}));
        connect(busConnector.SystemicArtys_OxygenatedBloodVolume,ArtysVol. u[3])
          annotation (Line(
            points={{-94,68},{-94,-34},{-28,-34},{-28,-29.8},{-26.8,-29.8}},
            color={0,0,255},
            thickness=0.5,
            smooth=Smooth.None), Text(
            string="%first",
            index=-1,
            extent={{-6,-2},{-6,-2}}));
        connect(feedback.y, busConnector.BloodVolume_change) annotation (Line(
            points={{-39,42},{-66,42},{-66,68},{-94,68}},
            color={0,0,127},
            smooth=Smooth.None), Text(
            string="%second",
            index=1,
            extent={{6,3},{6,3}}));
      connect(BloodVolume.y, busConnector.BloodVolume) annotation (Line(
          points={{18.4,-66},{90,-66},{90,68},{-94,68}},
          color={0,0,127},
          smooth=Smooth.None), Text(
          string="%second",
          index=1,
          extent={{6,3},{6,3}}));
      connect(HtcFract.y, hematocritEffect.u) annotation (Line(
          points={{40.4,-42},{42,-42},{42,-20},{-52,-20},{-52,0},{-42,0}},
          color={0,0,127},
          smooth=Smooth.None));
        connect(busConnector.LegArtys_OxygenatedBloodVolume, ArtysVol.u[4])
          annotation (Line(
            points={{-94,68},{-94,-38},{-26.8,-38},{-26.8,-29.4}},
            color={0,0,255},
            thickness=0.5,
            smooth=Smooth.None), Text(
            string="%first",
            index=-1,
            extent={{-6,-6},{-6,-6}}));
        connect(busConnector.LegVeins_DeoxygenatedBloodVolume, VeinsVol.u[5])
          annotation (Line(
            points={{-94,68},{-94,-62},{-28,-62},{-28,-49.36},{-26.8,-49.36}},
            color={0,0,255},
            thickness=0.5,
            smooth=Smooth.None), Text(
            string="%first",
            index=-1,
            extent={{-6,-10},{-6,-10}}));
      connect(V0.y, division.u2) annotation (Line(
          points={{-21.6,-86},{8,-86},{8,-76.4},{37.2,-76.4}},
          color={0,0,127},
          smooth=Smooth.None));
        annotation ( Icon(coordinateSystem(
                preserveAspectRatio=true, extent={{-100,-100},{100,100}}),
              graphics={                          Text(
                extent={{-142,-108},{142,-130}},
                lineColor={0,0,255},
                textString="%name")}),
          Documentation(info="<html>
<p>BloodVolume .. whole blood volume</p>
<p>BloodVol_Hct .. haematocrit</p>
<p>BloodVol_PVCrit .. 1-BloodVol_Hct, plamacrit</p>
<p>ctHb_ery .. concentration of heme group in erythrocytes = 4 * MCHC (mean corpuscular hemoglobin concentration)</p>
<p>ctHb .. concentration of heme group in whole blood</p>
<p>FHbF .. featal Hb fraction from all Hb</p>
<p>FMetHb .. metha-Hb fraction from all Hb</p>
<p>cDPG .. concentration of 2,3-diphosphoglycerate in erythrocytes</p>
<p>Viscosity_ConductanceEffect .. multiply coeficient of blood resistance through vesseles</p>
<p>BloodVol_CollapsedEffect .. effect of small blood volume on systemic veins collasping</p>
<p>Vesseles_V0 .. volume of no-pressure generating blood in all vessels.</p>
<p>ArtysVol .. volume of all oxigenated blood</p>
<p>VeinsVol .. volume of all deoxigenated blood</p>
</html>", revisions="<html>

<table>
<tr>
<td>Author:</td>
<td>Marek Matejak</td>
</tr>
<tr>
<td>License:</td>
<td><a href=\"http://www.physiomodel.org/license.html\">Physiomodel License 1.0</a> </td>
</tr>
<tr>
<td>By:</td>
<td>Charles University, Prague</td>
</tr>
<tr>
<td>Date of:</td>
<td>2009</td>
</tr>
<tr>
<td>References:</td>
<td>Tom Coleman: QHP 2008 beta 3, University of Mississippi Medical Center</td>
</tr>
</table>
<br/><p>Copyright &copy; 2014 Marek Matejak, Charles University in Prague.</p><br/>

</html>"));
      end BloodPropertiesBase;

    end Blood;

    model CardioVascularSystem
      extends Physiolibrary.Icons.CardioVascular;
    //  extends Physiomodel.Library.Utilities.DynamicState(stateName="BloodVol.Vol", initType=Library.Utilities.Init.NoInit);

    Heart.Heart heart
      annotation (Placement(transformation(extent={{0,-6},{26,20}})));
    Circulation.PulmonaryCirculation pulmonaryCirculation
      annotation (Placement(transformation(extent={{2,50},{30,78}})));
    Circulation.SystemicCirculationFullDynamic systemicCirculation
      annotation (Placement(transformation(extent={{-2,-68},{32,-34}})));
    Physiolibrary.Types.BusConnector busConnector
      "signals of organ bood flow resistence" annotation (Placement(
          transformation(extent={{-38,-8},{-16,14}}), iconTransformation(extent=
             {{-100,60},{-60,100}})));
    Blood.RedCells2 redCells(RBCBaseSecretionRate(k(displayUnit="m3/s")))
      annotation (Placement(transformation(extent={{-34,26},{-54,46}})));
    Blood.BloodPropertiesBase bloodProperties
      annotation (Placement(transformation(extent={{-36,-34},{-56,-14}})));

    /*initial equation
  if STEADY then
     bloodProperties.feedback.y = 0;
  end if;
*/

    equation
      connect(busConnector, pulmonaryCirculation.busConnector) annotation (
          Line(
          points={{-27,3},{-26,3},{-26,71},{2,71}},
          color={0,0,255},
          thickness=0.5,
          smooth=Smooth.None));
      connect(busConnector, systemicCirculation.busConnector) annotation (
          Line(
          points={{-27,3},{-26,3},{-26,-44.2},{-2.34,-44.2}},
          color={0,0,255},
          thickness=0.5,
          smooth=Smooth.None));
      connect(busConnector, redCells.busConnector)    annotation (Line(
          points={{-27,3},{-26,3},{-26,42.8},{-36.2,42.8}},
          color={0,0,255},
          thickness=0.5,
          smooth=Smooth.None));
      connect(busConnector, bloodProperties.busConnector) annotation (Line(
          points={{-27,3},{-26,3},{-26,-17.2},{-36.6,-17.2}},
          color={0,0,255},
          thickness=0.5,
          smooth=Smooth.None));
      connect(busConnector, heart.busConnector) annotation (Line(
          points={{-27,3},{-25.5,3},{-25.5,3.1},{0,3.1}},
          color={0,0,255},
          thickness=0.5,
          smooth=Smooth.None));
      connect(heart.fromLeftVentricle, systemicCirculation.q_in) annotation (
          Line(
          points={{16.12,3.36},{16.12,18},{32,18},{32,-51}},
          color={0,0,0},
          thickness=1,
          smooth=Smooth.None));
      connect(systemicCirculation.q_out, heart.rightAtrium) annotation (Line(
          points={{-2,-51},{-4,-51},{-4,12.2},{5.72,12.2}},
          color={0,0,0},
          thickness=1,
          smooth=Smooth.None));
      connect(pulmonaryCirculation.q_in, heart.fromRightVentricle) annotation (
          Line(
          points={{1.72,64},{-4,64},{-4,18},{8.06,18},{8.06,3.36}},
          color={0,0,0},
          thickness=1,
          smooth=Smooth.None));
      connect(pulmonaryCirculation.q_out, heart.leftAtrium) annotation (Line(
          points={{30,64},{36,64},{36,12.46},{18.72,12.46}},
          color={0,0,0},
          thickness=1,
          smooth=Smooth.None));

    //  stateValue = bloodProperties.BloodVolume1.y;

      annotation ( Documentation(info="<html>
<p><h4><font color=\"#008000\">Cardiovascular system</font></h4></p>
<p><font style=\"color: #008000; \">Connect heart with pulmonary and systemic part. This connection contains pressures and blood flows before and after heart.</font></p>
<p><font style=\"color: #008000; \">Output signal variables about blood volume between lungs capilaries and systemic tissue capilaries are used in gass transport submodels like O2 or CO2.</font></p>
<p><font style=\"color: #008000; \">Output signal Vesseles_V0 is used for systemic veins collapsing in massive blood lost.</font></p>
<p><font style=\"color: #008000; \">The blood properties convert known variables values to another meanings (haematocrit, viscosity, ..).</font></p>
<p><font style=\"color: #008000; \">Red cells contains volume, loss and gains all red blood cells.</font></p>
</html>", revisions="<html>

<table>
<tr>
<td>Author:</td>
<td>Marek Matejak</td>
</tr>
<tr>
<td>License:</td>
<td><a href=\"http://www.physiomodel.org/license.html\">Physiomodel License 1.0</a> </td>
</tr>
<tr>
<td>By:</td>
<td>Charles University, Prague</td>
</tr>
<tr>
<td>Date of:</td>
<td>2009</td>
</tr>
<tr>
<td>References:</td>
<td>Tom Coleman: QHP 2008 beta 3, University of Mississippi Medical Center</td>
</tr>
</table>
<br/><p>Copyright &copy; 2014 Marek Matejak, Charles University in Prague.</p><br/>

</html>"),
        Icon(coordinateSystem(preserveAspectRatio=true,  extent={{-100,-100},{
                100,100}}), graphics={Text(
              extent={{-116,-96},{126,-130}},
              lineColor={0,0,255},
              textString="%name")}));
    end CardioVascularSystem;

    package IO_Bus
      extends Physiolibrary.Types.IO_Bus;

      redeclare model extends Variables

      T.Volume ArtysVol(varName="ArtysVol.Vol")
        "Volume of oxygenated blood in body."
      annotation (Placement(transformation(extent={{-36,10},{-30,16}})));
      T.Fraction BloodVol_Hct(varName="BloodVol.Hct")
        "Heamatocrit = red cells / blood."
      annotation (Placement(transformation(extent={{-36,20},{-30,26}})));
      T.Fraction BloodVol_PVCrit(varName="BloodVol.PVCrit")
        "Plasma volume fraction = plasma / blood."
      annotation (Placement(transformation(extent={{-36,30},{-30,36}})));
      T.VolumeFlowRate Bone_BloodFlow(varName="Bone-Flow.BloodFlow")
        "Bone blood flow."
      annotation (Placement(transformation(extent={{-36,40},{-30,46}})));
      T.VolumeFlowRate bone_BloodFlow(varName="Bone-Flow.BloodFlow")
        "Bone blood flow."
      annotation (Placement(transformation(extent={{-36,50},{-30,56}})));
      T.VolumeFlowRate Brain_BloodFlow(varName="Brain-Flow.BloodFlow")
        "Brain blood flow."
      annotation (Placement(transformation(extent={{-36,60},{-30,66}})));
      T.VolumeFlowRate brain_BloodFlow(varName="Brain-Flow.BloodFlow")
        "Brain blood flow."
      annotation (Placement(transformation(extent={{-36,70},{-30,76}})));
      T.VolumeFlowRate CardiacOutput(varName="CardiacOutput.Flow")
        "Cardiac output."
      annotation (Placement(transformation(extent={{-36,80},{-30,86}})));
      T.Pressure CarotidSinusArteryPressure(varName="CarotidSinus.Pressure")
        "Mean blood pressure in carotid sinus artery."
      annotation (Placement(transformation(extent={{-36,90},{-30,96}})));
      T.VolumeFlowRate Fat_BloodFlow(varName="Fat-Flow.BloodFlow")
        "Fat blood flow."
      annotation (Placement(transformation(extent={{-36,100},{-30,106}})));
      T.VolumeFlowRate fat_BloodFlow(varName="Fat-Flow.BloodFlow")
        "Fat blood flow."
      annotation (Placement(transformation(extent={{-36,110},{-30,116}})));
      T.VolumeFlowRate GITract_BloodFlow(varName="GITract-Flow.BloodFlow")
        "GITract blood flow."
      annotation (Placement(transformation(extent={{-36,120},{-30,126}})));
      T.Pressure GlomerulusBloodPressure(varName="GlomerulusFiltrate.Pressure")
        "Blood pressure in glomerulus capilaries."
      annotation (Placement(transformation(extent={{-36,130},{-30,136}})));
      T.VolumeFlowRate HepaticArty_BloodFlow(varName="HepaticArty.Flow")
        "Hepatic artery blood flow."
      annotation (Placement(transformation(extent={{-36,140},{-30,146}})));
      T.VolumeFlowRate Kidney_BloodFlow(varName="Kidney-Flow.BloodFlow")
        "Kidney blood flow."
      annotation (Placement(transformation(extent={{-36,150},{-30,156}})));
      T.VolumeFlowRate kidney_BloodFlow(varName="Kidney-Flow.BloodFlow")
        "Kidney blood flow."
      annotation (Placement(transformation(extent={{-36,160},{-30,166}})));
      T.VolumeFlowRate KidneyPlasmaFlow(varName="Kidney-Flow.PlasmaFlow")
        "Kidney plasma flow."
      annotation (Placement(transformation(extent={{-36,170},{-30,176}})));
      //Variable LeftAtrium_TMP(varName="LeftAtrium.TMP")
      //    "Left atrium pressure gradient between inside and pericardium."
      //annotation (Placement(transformation(extent={{-36,180},{-30,186}})));
      T.VolumeFlowRate LeftHeart_BloodFlow(varName="LeftHeart-Flow.BloodFlow")
        "LeftHeart blood flow."
      annotation (Placement(transformation(extent={{-36,200},{-30,206}})));
      T.VolumeFlowRate leftHeart_BloodFlow(varName="LeftHeart-Flow.BloodFlow")
        "LeftHeart blood flow."
      annotation (Placement(transformation(extent={{-36,210},{-30,216}})));
      T.VolumeFlowRate AlveolarVentilated_BloodFlow(varName="LungBloodFlow.AlveolarVentilated")
        "Blood flow through ventilated alveoli."
      annotation (Placement(transformation(extent={{-36,220},{-30,226}})));
      T.VolumeFlowRate OtherTissue_BloodFlow(varName="OtherTissue-Flow.BloodFlow")
        "OtherTissue blood flow."
      annotation (Placement(transformation(extent={{-36,230},{-30,236}})));
      T.VolumeFlowRate otherTissue_BloodFlow(varName="OtherTissue-Flow.BloodFlow")
        "OtherTissue blood flow."
      annotation (Placement(transformation(extent={{-36,240},{-30,246}})));
      T.VolumeFlowRate PortalVein_BloodFlow(varName="PortalVein.BloodFlow")
        "Portal vein blood flow."
      annotation (Placement(transformation(extent={{-36,250},{-30,256}})));
      T.VolumeFlowRate PortalVein_PlasmaFlow(varName="PortalVein.PlasmaFlow")
        "Portal vein plasma flow."
      annotation (Placement(transformation(extent={{-36,260},{-30,266}})));
      T.Pressure PulmCapys_Pressure(varName="PulmCapys.Pressure")
        "Blood pressure in pulmonary capylaries."
      annotation (Placement(transformation(extent={{-36,270},{-30,276}})));
      T.Volume RBCH2O_Vol(varName="RBCH2O.Vol")
        "Intracellular water in erythrocytes."
      annotation (Placement(transformation(extent={{-36,280},{-30,286}})));
      T.VolumeFlowRate RespiratoryMuscle_BloodFlow(varName="RespiratoryMuscle-Flow.BloodFlow")
        "RespiratoryMuscle blood flow."
      annotation (Placement(transformation(extent={{-36,290},{-30,296}})));
      T.VolumeFlowRate respiratoryMuscle_BloodFlow(varName="RespiratoryMuscle-Flow.BloodFlow")
        "RespiratoryMuscle blood flow."
      annotation (Placement(transformation(extent={{-36,300},{-30,306}})));
      T.Pressure RightAtrium_Pressure(varName="RightAtrium.Pressure")
        "Blood pressure in right atrium."
      annotation (Placement(transformation(extent={{-36,310},{-30,316}})));
      //Variable RightAtrium_TMP(varName="RightAtrium.TMP")
      //    "Right atrium pressure gradient between inside and pericardium."
      //annotation (Placement(transformation(extent={{-36,320},{-30,326}})));
      T.VolumeFlowRate RightHeart_BloodFlow(varName="RightHeart-Flow.BloodFlow")
        "RightHeart blood flow."
      annotation (Placement(transformation(extent={{-36,340},{-30,346}})));
      T.VolumeFlowRate rightHeart_BloodFlow(varName="RightHeart-Flow.BloodFlow")
        "RightHeart blood flow."
      annotation (Placement(transformation(extent={{-36,350},{-30,356}})));
      T.VolumeFlowRate SkeletalMuscle_BloodFlow(varName="SkeletalMuscle-Flow.BloodFlow")
        "SkeletalMuscle blood flow."
      annotation (Placement(transformation(extent={{-36,360},{-30,366}})));
      T.VolumeFlowRate skeletalMuscle_BloodFlow(varName="SkeletalMuscle-Flow.BloodFlow")
        "SkeletalMuscle blood flow."
      annotation (Placement(transformation(extent={{-36,370},{-30,376}})));
      T.VolumeFlowRate Skin_BloodFlow(varName="Skin-Flow.BloodFlow")
        "Skin blood flow."
      annotation (Placement(transformation(extent={{-36,380},{-30,386}})));
      T.VolumeFlowRate skin_BloodFlow(varName="Skin-Flow.BloodFlow")
        "Skin blood flow."
      annotation (Placement(transformation(extent={{-36,390},{-30,396}})));
      T.Pressure SplanchnicVeins_Pressure(varName="SplanchnicVeins.Pressure")
        "Splanchnic (=portal vein) veins blood pressure."
      annotation (Placement(transformation(extent={{-36,400},{-30,406}})));
      T.Volume SplanchnicCirculation_DeoxygenatedBloodVolume(                          varName="SplanchnicVeins.Vol")
        "Splanchnic (=portal vein and venules) veins blood volume."
      annotation (Placement(transformation(extent={{-36,410},{-30,416}})));
      T.Pressure SystemicArtys_Pressure(varName="SystemicArtys.Pressure")
        "Mean systemic arteries blood pressure."
      annotation (Placement(transformation(extent={{-36,420},{-30,426}})));
      T.VolumeFlowRate VasaRecta_Outflow(varName="VasaRecta.Outflow")
        "Kidney vasa recta blood outflow to kidney veins."
      annotation (Placement(transformation(extent={{-36,430},{-30,436}})));
      T.Volume VeinsVol(varName="VeinsVol.Vol")
        "Volume of deoxygenated blood in body."
      annotation (Placement(transformation(extent={{-36,440},{-30,446}})));
      T.Concentration ctHb(varName="ctHb") "Hemoglobin concentration in blood."
      annotation (Placement(transformation(extent={{-36,450},{-30,456}})));
      T.Concentration ctHb_ery(varName="ctHb_ery")
        "Hemoglobin concentration in erythrocytes."
      annotation (Placement(transformation(extent={{-36,460},{-30,466}})));
      T.Pressure NephronIFP_Pressure(varName=
              "NephronIFP.Pressure") "Renal interstitial pressure."
      annotation (Placement(transformation(extent={{-34,-10},{-28,-4}})));
      T.VolumeFlowRate Liver_BloodFlow(varName=
              "Liver-O2.BloodFlow") "Liver blood flow."
      annotation (Placement(transformation(extent={{-30,-26},{-24,-20}})));
      T.Concentration cDPG(varName="cDPG") "2,3-DPG concentration"
      annotation (Placement(transformation(extent={{18,-84},{24,-78}})));
      T.Fraction FMetHb(varName="FMetHb")
        "Fraction of methemoglobin with Fe^3+ instead of Fe^2+"
      annotation (Placement(transformation(extent={{18,-74},{24,-68}})));
      T.Fraction FHbF(varName="FHbF") "Fraction of foetal hemoglobin"
      annotation (Placement(transformation(extent={{18,-64},{24,-58}})));
      T.Pressure SystemicVeins_Pressure(varName="SystemicVeins.Pressure")
        "Systemic veins pressure."
      annotation (Placement(transformation(extent={{-36,-40},{-30,-34}})));
      T.HydraulicConductance
                 skin_conductanceWithoutTermoregulationEffect(varName=
              "skin_conductanceWithoutTermoregulationEffect")
        "Skin conductance without termoregulation effect."
      annotation (Placement(transformation(extent={{-34,-54},{-28,-48}})));
      T.Concentration ANPPool_ANP(varName="ANPPool.[ANP]", storeUnit="pmol/l",
        y(nominal=1e-8)) "Atrial natriuretic peptide concentration."
          annotation (Placement(transformation(extent={{-82,-78},{-76,-72}})));
      T.Volume BloodVol_Vol(varName="BloodVol.Vol") "Blood volume"
      annotation (Placement(transformation(extent={{-84,4},{-78,10}})));
      T.Fraction AtrialLowPressureReceptors_NA(varName="LowPressureReceptors.NA")
        "Atrial Low Pressure Receptors neural activity."
          annotation (Placement(transformation(extent={{-84,-90},{-78,-84}})));
      equation

      connect(ArtysVol.y, busConnector.ArtysVol) annotation (Line(
       points={{-29.7,13},{90,13},{90,-2}},
            color={0,0,127},
            smooth=Smooth.None), Text(
            string="%second",
            index=1,
            extent={{6,3},{6,3}}));
      connect(BloodVol_Hct.y, busConnector.BloodVol_Hct) annotation (Line(
       points={{-29.7,23},{90,23},{90,-2}},
            color={0,0,127},
            smooth=Smooth.None), Text(
            string="%second",
            index=1,
            extent={{6,3},{6,3}}));
      connect(BloodVol_PVCrit.y, busConnector.BloodVol_PVCrit) annotation (Line(
       points={{-29.7,33},{90,33},{90,-2}},
            color={0,0,127},
            smooth=Smooth.None), Text(
            string="%second",
            index=1,
            extent={{6,3},{6,3}}));
      connect(Bone_BloodFlow.y, busConnector.Bone_BloodFlow) annotation (Line(
       points={{-29.7,43},{90,43},{90,-2}},
            color={0,0,127},
            smooth=Smooth.None), Text(
            string="%second",
            index=1,
            extent={{6,3},{6,3}}));
      connect(bone_BloodFlow.y, busConnector.bone_BloodFlow) annotation (Line(
       points={{-29.7,53},{90,53},{90,-2}},
            color={0,0,127},
            smooth=Smooth.None), Text(
            string="%second",
            index=1,
            extent={{6,3},{6,3}}));
      connect(Brain_BloodFlow.y, busConnector.Brain_BloodFlow) annotation (Line(
       points={{-29.7,63},{90,63},{90,-2}},
            color={0,0,127},
            smooth=Smooth.None), Text(
            string="%second",
            index=1,
            extent={{6,3},{6,3}}));
      connect(brain_BloodFlow.y, busConnector.brain_BloodFlow) annotation (Line(
       points={{-29.7,73},{90,73},{90,-2}},
            color={0,0,127},
            smooth=Smooth.None), Text(
            string="%second",
            index=1,
            extent={{6,3},{6,3}}));
      connect(CardiacOutput.y, busConnector.CardiacOutput) annotation (Line(
       points={{-29.7,83},{90,83},{90,-2}},
            color={0,0,127},
            smooth=Smooth.None), Text(
            string="%second",
            index=1,
            extent={{6,3},{6,3}}));
      connect(CarotidSinusArteryPressure.y, busConnector.CarotidSinusArteryPressure) annotation (Line(
       points={{-29.7,93},{90,93},{90,-2}},
            color={0,0,127},
            smooth=Smooth.None), Text(
            string="%second",
            index=1,
            extent={{6,3},{6,3}}));
      connect(Fat_BloodFlow.y, busConnector.Fat_BloodFlow) annotation (Line(
       points={{-29.7,103},{90,103},{90,-2}},
            color={0,0,127},
            smooth=Smooth.None), Text(
            string="%second",
            index=1,
            extent={{6,3},{6,3}}));
      connect(fat_BloodFlow.y, busConnector.fat_BloodFlow) annotation (Line(
       points={{-29.7,113},{90,113},{90,-2}},
            color={0,0,127},
            smooth=Smooth.None), Text(
            string="%second",
            index=1,
            extent={{6,3},{6,3}}));
      connect(GITract_BloodFlow.y, busConnector.GITract_BloodFlow) annotation (Line(
       points={{-29.7,123},{90,123},{90,-2}},
            color={0,0,127},
            smooth=Smooth.None), Text(
            string="%second",
            index=1,
            extent={{6,3},{6,3}}));
      connect(GlomerulusBloodPressure.y, busConnector.GlomerulusBloodPressure) annotation (Line(
       points={{-29.7,133},{90,133},{90,-2}},
            color={0,0,127},
            smooth=Smooth.None), Text(
            string="%second",
            index=1,
            extent={{6,3},{6,3}}));
      connect(HepaticArty_BloodFlow.y, busConnector.HepaticArty_BloodFlow) annotation (Line(
       points={{-29.7,143},{90,143},{90,-2}},
            color={0,0,127},
            smooth=Smooth.None), Text(
            string="%second",
            index=1,
            extent={{6,3},{6,3}}));
      connect(Kidney_BloodFlow.y, busConnector.Kidney_BloodFlow) annotation (Line(
       points={{-29.7,153},{90,153},{90,-2}},
            color={0,0,127},
            smooth=Smooth.None), Text(
            string="%second",
            index=1,
            extent={{6,3},{6,3}}));
      connect(kidney_BloodFlow.y, busConnector.kidney_BloodFlow) annotation (Line(
       points={{-29.7,163},{90,163},{90,-2}},
            color={0,0,127},
            smooth=Smooth.None), Text(
            string="%second",
            index=1,
            extent={{6,3},{6,3}}));
      connect(KidneyPlasmaFlow.y, busConnector.KidneyPlasmaFlow) annotation (Line(
       points={{-29.7,173},{90,173},{90,-2}},
            color={0,0,127},
            smooth=Smooth.None), Text(
            string="%second",
            index=1,
            extent={{6,3},{6,3}}));
      connect(LeftHeart_BloodFlow.y, busConnector.LeftHeart_BloodFlow) annotation (Line(
       points={{-29.7,203},{90,203},{90,-2}},
            color={0,0,127},
            smooth=Smooth.None), Text(
            string="%second",
            index=1,
            extent={{6,3},{6,3}}));
      connect(leftHeart_BloodFlow.y, busConnector.leftHeart_BloodFlow) annotation (Line(
       points={{-29.7,213},{90,213},{90,-2}},
            color={0,0,127},
            smooth=Smooth.None), Text(
            string="%second",
            index=1,
            extent={{6,3},{6,3}}));
      connect(AlveolarVentilated_BloodFlow.y, busConnector.AlveolarVentilated_BloodFlow) annotation (Line(
       points={{-29.7,223},{90,223},{90,-2}},
            color={0,0,127},
            smooth=Smooth.None), Text(
            string="%second",
            index=1,
            extent={{6,3},{6,3}}));
      connect(OtherTissue_BloodFlow.y, busConnector.OtherTissue_BloodFlow) annotation (Line(
       points={{-29.7,233},{90,233},{90,-2}},
            color={0,0,127},
            smooth=Smooth.None), Text(
            string="%second",
            index=1,
            extent={{6,3},{6,3}}));
      connect(otherTissue_BloodFlow.y, busConnector.otherTissue_BloodFlow) annotation (Line(
       points={{-29.7,243},{90,243},{90,-2}},
            color={0,0,127},
            smooth=Smooth.None), Text(
            string="%second",
            index=1,
            extent={{6,3},{6,3}}));
      connect(PortalVein_BloodFlow.y, busConnector.PortalVein_BloodFlow) annotation (Line(
       points={{-29.7,253},{90,253},{90,-2}},
            color={0,0,127},
            smooth=Smooth.None), Text(
            string="%second",
            index=1,
            extent={{6,3},{6,3}}));
      connect(PortalVein_PlasmaFlow.y, busConnector.PortalVein_PlasmaFlow) annotation (Line(
       points={{-29.7,263},{90,263},{90,-2}},
            color={0,0,127},
            smooth=Smooth.None), Text(
            string="%second",
            index=1,
            extent={{6,3},{6,3}}));
      connect(PulmCapys_Pressure.y, busConnector.PulmCapys_Pressure) annotation (Line(
       points={{-29.7,273},{90,273},{90,-2}},
            color={0,0,127},
            smooth=Smooth.None), Text(
            string="%second",
            index=1,
            extent={{6,3},{6,3}}));
      connect(RBCH2O_Vol.y, busConnector.RBCH2O_Vol) annotation (Line(
       points={{-29.7,283},{90,283},{90,-2}},
            color={0,0,127},
            smooth=Smooth.None), Text(
            string="%second",
            index=1,
            extent={{6,3},{6,3}}));
      connect(RespiratoryMuscle_BloodFlow.y, busConnector.RespiratoryMuscle_BloodFlow) annotation (Line(
       points={{-29.7,293},{90,293},{90,-2}},
            color={0,0,127},
            smooth=Smooth.None), Text(
            string="%second",
            index=1,
            extent={{6,3},{6,3}}));
      connect(respiratoryMuscle_BloodFlow.y, busConnector.respiratoryMuscle_BloodFlow) annotation (Line(
       points={{-29.7,303},{90,303},{90,-2}},
            color={0,0,127},
            smooth=Smooth.None), Text(
            string="%second",
            index=1,
            extent={{6,3},{6,3}}));
      connect(RightAtrium_Pressure.y, busConnector.RightAtrium_Pressure) annotation (Line(
       points={{-29.7,313},{90,313},{90,-2}},
            color={0,0,127},
            smooth=Smooth.None), Text(
            string="%second",
            index=1,
            extent={{6,3},{6,3}}));
      connect(RightHeart_BloodFlow.y, busConnector.RightHeart_BloodFlow) annotation (Line(
       points={{-29.7,343},{90,343},{90,-2}},
            color={0,0,127},
            smooth=Smooth.None), Text(
            string="%second",
            index=1,
            extent={{6,3},{6,3}}));
      connect(rightHeart_BloodFlow.y, busConnector.rightHeart_BloodFlow) annotation (Line(
       points={{-29.7,353},{90,353},{90,-2}},
            color={0,0,127},
            smooth=Smooth.None), Text(
            string="%second",
            index=1,
            extent={{6,3},{6,3}}));
      connect(SkeletalMuscle_BloodFlow.y, busConnector.SkeletalMuscle_BloodFlow) annotation (Line(
       points={{-29.7,363},{90,363},{90,-2}},
            color={0,0,127},
            smooth=Smooth.None), Text(
            string="%second",
            index=1,
            extent={{6,3},{6,3}}));
      connect(skeletalMuscle_BloodFlow.y, busConnector.skeletalMuscle_BloodFlow) annotation (Line(
       points={{-29.7,373},{90,373},{90,-2}},
            color={0,0,127},
            smooth=Smooth.None), Text(
            string="%second",
            index=1,
            extent={{6,3},{6,3}}));
      connect(Skin_BloodFlow.y, busConnector.Skin_BloodFlow) annotation (Line(
       points={{-29.7,383},{90,383},{90,-2}},
            color={0,0,127},
            smooth=Smooth.None), Text(
            string="%second",
            index=1,
            extent={{6,3},{6,3}}));
      connect(skin_BloodFlow.y, busConnector.skin_BloodFlow) annotation (Line(
       points={{-29.7,393},{90,393},{90,-2}},
            color={0,0,127},
            smooth=Smooth.None), Text(
            string="%second",
            index=1,
            extent={{6,3},{6,3}}));
      connect(SplanchnicVeins_Pressure.y, busConnector.SplanchnicVeins_Pressure) annotation (Line(
       points={{-29.7,403},{90,403},{90,-2}},
            color={0,0,127},
            smooth=Smooth.None), Text(
            string="%second",
            index=1,
            extent={{6,3},{6,3}}));
      connect(SplanchnicCirculation_DeoxygenatedBloodVolume.y, busConnector.SplanchnicCirculation_DeoxygenatedBloodVolume) annotation (Line(
       points={{-29.7,413},{90,413},{90,-2}},
            color={0,0,127},
            smooth=Smooth.None), Text(
            string="%second",
            index=1,
            extent={{6,3},{6,3}}));
      connect(SystemicArtys_Pressure.y, busConnector.SystemicArtys_Pressure) annotation (Line(
       points={{-29.7,423},{90,423},{90,-2}},
            color={0,0,127},
            smooth=Smooth.None), Text(
            string="%second",
            index=1,
            extent={{6,3},{6,3}}));
      connect(VasaRecta_Outflow.y, busConnector.VasaRecta_Outflow) annotation (Line(
       points={{-29.7,433},{90,433},{90,-2}},
            color={0,0,127},
            smooth=Smooth.None), Text(
            string="%second",
            index=1,
            extent={{6,3},{6,3}}));
      connect(VeinsVol.y, busConnector.VeinsVol) annotation (Line(
       points={{-29.7,443},{90,443},{90,-2}},
            color={0,0,127},
            smooth=Smooth.None), Text(
            string="%second",
            index=1,
            extent={{6,3},{6,3}}));
      connect(ctHb.y, busConnector.ctHb) annotation (Line(
       points={{-29.7,453},{90,453},{90,-2}},
            color={0,0,127},
            smooth=Smooth.None), Text(
            string="%second",
            index=1,
            extent={{6,3},{6,3}}));
      connect(ctHb_ery.y, busConnector.ctHb_ery) annotation (Line(
       points={{-29.7,463},{90,463},{90,-2}},
            color={0,0,127},
            smooth=Smooth.None), Text(
            string="%second",
            index=1,
            extent={{6,3},{6,3}}));
        connect(NephronIFP_Pressure.y, busConnector.NephronIFP_Pressure)
          annotation (Line(
            points={{-27.7,-7},{90,-2}},
            color={0,0,127},
            smooth=Smooth.None), Text(
            string="%second",
            index=1,
            extent={{6,3},{6,3}}));

        connect(Liver_BloodFlow.y, busConnector.Liver_BloodFlow) annotation (Line(
            points={{-23.7,-23},{90,-23},{90,-2}},
            color={0,0,127},
            smooth=Smooth.None), Text(
            string="%second",
            index=1,
            extent={{6,3},{6,3}}));
      connect(FHbF.y,busConnector. FHbF) annotation (Line(
       points={{24.3,-61},{78,-61},{78,-2},{90,-2}},
            color={0,0,127},
            smooth=Smooth.None), Text(
            string="%second",
            index=1,
            extent={{6,3},{6,3}}));
      connect(FMetHb.y,busConnector. FMetHb) annotation (Line(
       points={{24.3,-71},{90,-71},{90,-2}},
            color={0,0,127},
            smooth=Smooth.None), Text(
            string="%second",
            index=1,
            extent={{6,3},{6,3}}));
      connect(cDPG.y,busConnector. cDPG) annotation (Line(
       points={{24.3,-81},{90,-81},{90,-2}},
            color={0,0,127},
            smooth=Smooth.None), Text(
            string="%second",
            index=1,
            extent={{6,3},{6,3}}));
        connect(SystemicVeins_Pressure.y, busConnector.SystemicVeins_Pressure)
          annotation (Line(
            points={{-29.7,-37},{90,-37},{90,-2}},
            color={0,0,127},
            smooth=Smooth.None), Text(
            string="%second",
            index=1,
            extent={{6,3},{6,3}}));
        connect(skin_conductanceWithoutTermoregulationEffect.y, busConnector.skin_conductanceWithoutTermoregulationEffect)
          annotation (Line(
            points={{-27.7,-51},{90,-51},{90,-2}},
            color={0,0,127},
            smooth=Smooth.None), Text(
            string="%second",
            index=1,
            extent={{6,3},{6,3}}));
        connect(BloodVol_Vol.y, busConnector.BloodVolume) annotation (Line(
            points={{-77.7,7},{0.15,7},{0.15,-2},{90,-2}},
            color={0,0,127},
            smooth=Smooth.None), Text(
            string="%second",
            index=1,
            extent={{6,3},{6,3}}));
        connect(ANPPool_ANP.y, busConnector.ANP) annotation (Line(
            points={{-75.7,-75},{90,-75},{90,-2}},
            color={0,0,127},
            smooth=Smooth.None), Text(
            string="%second",
            index=1,
            extent={{6,3},{6,3}}));
        connect(AtrialLowPressureReceptors_NA.y, busConnector.AtrialLowPressureReceptors_NA)
          annotation (Line(
            points={{-77.7,-87},{90,-87},{90,-2}},
            color={0,0,127},
            smooth=Smooth.None), Text(
            string="%second",
            index=1,
            extent={{6,3},{6,3}}));
        annotation (Icon(coordinateSystem(preserveAspectRatio=true, extent={{-100,
                  -100},{100,100}},
                lineColor={0,0,0},
                textString="const"), graphics={Text(
                extent={{6,126},{100,90}},
                lineColor={0,0,0},
                textString="vars"), Text(
                extent={{-126,-98},{116,-132}},
                lineColor={0,0,255},
                textString="%name")}));
      end Variables;

      model CardioVascular_test
        import Physiomodel;
      Physiomodel.CardioVascular.CardioVascularSystem cardioVascularSystem
        annotation (Placement(transformation(extent={{40,72},{60,94}})));
        Physiomodel.Metabolism.IO_Bus.InputFromFile
                                                nutrientsAndMetabolism
          annotation (Placement(transformation(extent={{-88,60},{-68,80}})));
        Physiomodel.Electrolytes.IO_Bus.InputFromFile electrolytes
          annotation (Placement(transformation(extent={{74,-34},{94,-14}})));
        Physiomodel.Hormones.IO_Bus.InputFromFile hormones
          annotation (Placement(transformation(extent={{40,6},{60,26}})));
        Physiomodel.Nerves.IO_Bus.InputFromFile nerves
          annotation (Placement(transformation(extent={{74,38},{94,58}})));
        Physiomodel.Setup.IO_Bus.InputFromFile     setup
          annotation (Placement(transformation(extent={{-14,-96},{6,-76}})));
        Physiomodel.Water.IO_Bus.InputFromFile water
          annotation (Placement(transformation(extent={{-86,-6},{-66,14}})));
        Physiomodel.Proteins.IO_Bus.InputFromFile proteins
          annotation (Placement(transformation(extent={{-48,-30},{-28,-10}})));
        Physiomodel.Status.IO_Bus.InputFromFile status
          annotation (Placement(transformation(extent={{42,-80},{62,-60}})));
        Physiomodel.Gases.IO_Bus.InputFromFile gases
          annotation (Placement(transformation(extent={{-76,-64},{-56,-44}})));
        Physiomodel.Heat.IO_Bus.InputFromFile heat
          annotation (Placement(transformation(extent={{-28,30},{-48,50}})));
        Physiomodel.CardioVascular.IO_Bus.OutputComparison
                                           cVS_dif
          annotation (Placement(transformation(extent={{76,72},{96,92}})));
        Physiomodel.CardioVascular.IO_Bus.OutputToFile
                                                  cVS_varsToFile
          annotation (Placement(transformation(extent={{14,60},{34,80}})));
      equation
        connect(setup.busConnector,hormones. busConnector) annotation (Line(
            points={{-4,-86},{-4,16},{50,16}},
            color={0,0,255},
            thickness=0.5,
            smooth=Smooth.None));
        connect(setup.busConnector,proteins. busConnector) annotation (Line(
            points={{-4,-86},{-4,-20},{-38,-20}},
            color={0,0,255},
            thickness=0.5,
            smooth=Smooth.None));
        connect(setup.busConnector,cardioVascularSystem. busConnector)
                                                      annotation (Line(
            points={{-4,-86},{-4,91.8},{42,91.8}},
            color={0,0,255},
            thickness=0.5,
            smooth=Smooth.None));
        connect(setup.busConnector,nutrientsAndMetabolism. busConnector)
          annotation (Line(
            points={{-4,-86},{-4,70},{-78,70}},
            color={0,0,255},
            thickness=0.5,
            smooth=Smooth.None));
        connect(setup.busConnector,water. busConnector) annotation (Line(
            points={{-4,-86},{-4,4},{-76,4}},
            color={0,0,255},
            thickness=0.5,
            smooth=Smooth.None));
        connect(setup.busConnector,nerves. busConnector) annotation (Line(
            points={{-4,-86},{-4,48},{84,48}},
            color={0,0,255},
            thickness=0.5,
            smooth=Smooth.None));
        connect(status.busConnector,setup. busConnector)         annotation (Line(
            points={{52,-70},{-4,-70},{-4,-86}},
            color={0,0,255},
            thickness=0.5,
            smooth=Smooth.None));
        connect(electrolytes.busConnector,setup. busConnector) annotation (Line(
            points={{84,-24},{-4,-24},{-4,-86}},
            color={0,0,255},
            thickness=0.5,
            smooth=Smooth.None));
        connect(gases.busConnector,setup. busConnector) annotation (Line(
            points={{-66,-54},{-4,-54},{-4,-86}},
            color={0,0,255},
            thickness=0.5,
            smooth=Smooth.None));
        connect(heat.busConnector,setup. busConnector) annotation (Line(
            points={{-38,40},{-4,40},{-4,-86}},
            color={0,0,255},
            thickness=0.5,
            smooth=Smooth.None));
        connect(cardioVascularSystem.busConnector, cVS_dif.busConnector)
          annotation (Line(
            points={{42,91.8},{64,91.8},{64,82},{86,82}},
            color={0,0,255},
            thickness=0.5,
            smooth=Smooth.None));
        connect(cardioVascularSystem.busConnector, cVS_varsToFile.busConnector)
          annotation (Line(
            points={{42,91.8},{24,91.8},{24,70}},
            color={0,0,255},
            thickness=0.5,
            smooth=Smooth.None));
        annotation (        experiment(StopTime=3.1536e+007));
      end CardioVascular_test;

      model CardioVascular_test_SI
        import Physiomodel;
      Physiomodel.CardioVascular.CardioVascularSystem cardioVascularSystem
        annotation (Placement(transformation(extent={{40,72},{60,94}})));
        Physiomodel.Metabolism.IO_Bus.InputFromFile_SI
                                                nutrientsAndMetabolism
          annotation (Placement(transformation(extent={{-88,60},{-68,80}})));
        Physiomodel.Electrolytes.IO_Bus.InputFromFile_SI electrolytes
          annotation (Placement(transformation(extent={{74,-34},{94,-14}})));
        Physiomodel.Hormones.IO_Bus.InputFromFile_SI hormones
          annotation (Placement(transformation(extent={{40,6},{60,26}})));
        Physiomodel.Nerves.IO_Bus.InputFromFile_SI nerves
          annotation (Placement(transformation(extent={{74,38},{94,58}})));
        Physiomodel.Setup.IO_Bus.InputFromFile_SI     setup
          annotation (Placement(transformation(extent={{-14,-96},{6,-76}})));
        Physiomodel.Water.IO_Bus.InputFromFile_SI water
          annotation (Placement(transformation(extent={{-86,-6},{-66,14}})));
        Physiomodel.Proteins.IO_Bus.InputFromFile_SI proteins
          annotation (Placement(transformation(extent={{-48,-30},{-28,-10}})));
        Physiomodel.Status.IO_Bus.InputFromFile_SI status
          annotation (Placement(transformation(extent={{42,-80},{62,-60}})));
        Physiomodel.Gases.IO_Bus.InputFromFile_SI gases
          annotation (Placement(transformation(extent={{-76,-64},{-56,-44}})));
        Physiomodel.Heat.IO_Bus.InputFromFile_SI heat
          annotation (Placement(transformation(extent={{-28,30},{-48,50}})));
        Physiomodel.CardioVascular.IO_Bus.OutputComparison_SI
                                           cVS_dif
          annotation (Placement(transformation(extent={{76,72},{96,92}})));
        Physiomodel.CardioVascular.IO_Bus.OutputToFile_SI
                                                  cVS_varsToFile
          annotation (Placement(transformation(extent={{14,60},{34,80}})));
      equation
        connect(setup.busConnector,hormones. busConnector) annotation (Line(
            points={{-4,-86},{-4,16},{50,16}},
            color={0,0,255},
            thickness=0.5,
            smooth=Smooth.None));
        connect(setup.busConnector,proteins. busConnector) annotation (Line(
            points={{-4,-86},{-4,-20},{-38,-20}},
            color={0,0,255},
            thickness=0.5,
            smooth=Smooth.None));
        connect(setup.busConnector,cardioVascularSystem. busConnector)
                                                      annotation (Line(
            points={{-4,-86},{-4,91.8},{42,91.8}},
            color={0,0,255},
            thickness=0.5,
            smooth=Smooth.None));
        connect(setup.busConnector,nutrientsAndMetabolism. busConnector)
          annotation (Line(
            points={{-4,-86},{-4,70},{-78,70}},
            color={0,0,255},
            thickness=0.5,
            smooth=Smooth.None));
        connect(setup.busConnector,water. busConnector) annotation (Line(
            points={{-4,-86},{-4,4},{-76,4}},
            color={0,0,255},
            thickness=0.5,
            smooth=Smooth.None));
        connect(setup.busConnector,nerves. busConnector) annotation (Line(
            points={{-4,-86},{-4,48},{84,48}},
            color={0,0,255},
            thickness=0.5,
            smooth=Smooth.None));
        connect(status.busConnector,setup. busConnector)         annotation (Line(
            points={{52,-70},{-4,-70},{-4,-86}},
            color={0,0,255},
            thickness=0.5,
            smooth=Smooth.None));
        connect(electrolytes.busConnector,setup. busConnector) annotation (Line(
            points={{84,-24},{-4,-24},{-4,-86}},
            color={0,0,255},
            thickness=0.5,
            smooth=Smooth.None));
        connect(gases.busConnector,setup. busConnector) annotation (Line(
            points={{-66,-54},{-4,-54},{-4,-86}},
            color={0,0,255},
            thickness=0.5,
            smooth=Smooth.None));
        connect(heat.busConnector,setup. busConnector) annotation (Line(
            points={{-38,40},{-4,40},{-4,-86}},
            color={0,0,255},
            thickness=0.5,
            smooth=Smooth.None));
        connect(cardioVascularSystem.busConnector, cVS_dif.busConnector)
          annotation (Line(
            points={{42,91.8},{64,91.8},{64,82},{86,82}},
            color={0,0,255},
            thickness=0.5,
            smooth=Smooth.None));
        connect(cardioVascularSystem.busConnector, cVS_varsToFile.busConnector)
          annotation (Line(
            points={{42,91.8},{24,91.8},{24,70}},
            color={0,0,255},
            thickness=0.5,
            smooth=Smooth.None));
        annotation (        experiment(StopTime=864000));
      end CardioVascular_test_SI;
    end IO_Bus;
  annotation (Documentation(revisions="<html>
<table cellspacing=\"2\" cellpadding=\"0\" border=\"0\"><tr>
<td><p>Author:</p></td>
<td>Marek Matejak</td>
</tr>
<tr>
<td><p>License:</p></td>
<td><p><a href=\"http://www.physiomodel.org/license.html\">Physiomodel License 1.0</a> </p></td>
</tr>

<tr>
<td><p>Date of:</p></td>
<td><p>2008-2015</p></td>
</tr>
<tr>
<td><p>References:</p></td>
<td><p><br><a href=\"modelica://Physiomodel.UsersGuide.References\">User&apos;s Guide</a></p><p><br><a href=\"https://www.zotero.org/search/type/group/q/physiomodel\">zotero: Physiomodel</a></p><p><br><a href=\"http://www.hummod.org\">HumMod</a></p><p><br><a href=\"https://www.zotero.org/groups/hummod_references\">zotero: HumMod References</a></p></td>
</tr>
</table>
<p><br>Copyright &copy; 2008-2015 Marek Matejak, Charles University in Prague.</p>
</html>", info="<html>
<p>Heart pump</p>
<p>Cardiac output (CO) as a mean blood flow from heart ventricle is heart rate (HR) multiplied by stroke volume (SV), where stroke volume is difference of end diastolic volume (EDV) [Gaasch1975,Carter1998] and end systolic volume (ESV) [Noda1993]. The HR and heart contractility (in the meaning of ESV) [Suga1976] can be influenced by nervus vagus (main parasympathicus autonomic neural pathway) [Xenopoulos1994], epinephrine [Collins-Nakai1994] or angiotensin II [Kumagai1994]. The most comon descriptions are pressure-volume relations [Sawaga1988] as in famous A-V fistula experiments [Guyton1961] or filling pressure experiments [Suga1974] or less invasive exercise experiments [Little1993].</p>
<p>There is some evidence of non-steady state behaviour of end diastolic volume, because the stroke volume is dependent on heart rate [Ross1965,Sugimoto1966].</p>
<p><br><br>Blood viscosity[Begg1966,Schrier1970]</p>
<p><br>Vasoconstriction [Mellander1992, Shigemi1994]</p>
<p><br>The compliance of systemic arteries is constant around normal working conditions [Roach1957].</p>
<p><br>Systemic veins [Shigemi1994,Echt1974,Gauer1956]</p>
<p><br>Muscle pump effect [Armstrong1985,Laughlin1987,Laughlin1983]</p>
<p><br>Sequestered volume [Ochsner1951,Mayerson1939,Bevegard1962,Pollack1949,Block1930,Henry1950,Thomson1928]</p>
<p><br>Kidney blood flow [Skarlatos1993,Manning1987] - effect to renal arteries [Skov1996]</p>
<p>-myogenic [Auckland1989,Drummond2008,Heyeraas1987]</p>
<p>-tubuloglomerular feedback [Moore1990,Drummond2008,Ito1990]</p>
<p><br>Splanchnic circulation [Maass-Moreno1992,Bradley1953,Bradley1952,Mitzner1974,Laine1979]</p>
<p>- effect of norepinephrine [Greenway1985,Laut1987]</p>
<p>- effect of histamine [Greenway1973]</p>
<p><br><br>Brain blood flow [Kety1948]</p>
<p><br>Blood Volume regulations </p>
<p>- hypoproteinemia [Manning1990,Manning1983]</p>
<p><br>Autoregulation of circulation</p>
<p>- CO on CO2 [Davidson1986]</p>
<p>-  ,Hogan1990,Lash1987,Malo1984,Marshall1995,Metting1989,Metting1988,Weber2000,Borgstr&ouml;m1975,Whalen1974,Frisbee2000,Berg1997,Burattini1994,POHOST1976,Archer1996,Goodman1978,Granger1976,Granger1969,Harder1996,Harder1996,Marshall1988,Frisbee2000,Kunert1996,Prewitt1976,Kuwahira1993]</p>
<p><br>RAAS and other regulations .. see hormones, nerves and drugs</p>
</html>"));
  end CardioVascular;

  package Gases "Body O2 and CO2"
    extends Physiolibrary.Icons.GasesLib;
    package O2 "Body O2 Transport"

    partial model BloodO2Base
    //start values is for tissues veins blood

      parameter Boolean isSaturated = false;

      Physiolibrary.Types.Concentration tO2(start=0.75*8.14);
      Real aO2;
    //  Real pO2(start=5.33,           unit="kPa");
      // start=13,
      Physiolibrary.Types.Fraction sO2CO(start=0.75);
      Physiolibrary.Types.Pressure pO2CO;
      Physiolibrary.Types.Concentration cO2Hb(start=6);
      //
      Physiolibrary.Types.Fraction sCO;

      Physiolibrary.Types.Concentration ceHb;
      Real a(start=0.5);
      Real k;
      Real x;
      Real y;
      Real h;

    /*  Real ex;
  Real ey;
  Real ey0;
  Real tnh;
*/
      Physiolibrary.Types.Fraction FCOHb(start=0);

    //  Real pCO;
    //  Real pCO2;
      //(start=5);

      Physiolibrary.Types.RealIO.FractionOutput sO2
                                          annotation (Placement(
            transformation(extent={{-30,-112},{10,-72}}),
                                                        iconTransformation(
            extent={{-20,-20},{20,20}},
            rotation=270,
            origin={0,-120})));
      Physiolibrary.Types.RealIO.pHInput pH
                                      annotation (Placement(transformation(extent={{-120,70},
                {-80,110}}),          iconTransformation(extent={{-100,90},{
                -80,110}})));
      Physiolibrary.Types.RealIO.ConcentrationInput ctHb
                                       annotation (Placement(transformation(extent={{60,60},
                {100,100}}),          iconTransformation(
            extent={{-10,-10},{10,10}},
            rotation=180,
            origin={90,100})));

      Physiolibrary.Types.RealIO.TemperatureInput T(start=310.15)  annotation (Placement(transformation(extent={{-120,
                -20},{-80,20}}),      iconTransformation(extent={{-100,10},{
                -80,30}})));
      Physiolibrary.Types.RealIO.PressureInput pCO
                                       annotation (Placement(transformation(extent={{60,-100},
                {100,-60}}),          iconTransformation(extent={{-10,-10},{
                10,10}},
            rotation=180,
            origin={90,-60})));
      Physiolibrary.Types.RealIO.PressureInput pCO2(start=5330)
                                       annotation (Placement(transformation(extent={{-120,20},
                {-80,60}}),           iconTransformation(extent={{-100,50},{-80,70}})));
      Physiolibrary.Types.RealIO.ConcentrationInput cDPG
                                       annotation (Placement(transformation(extent={{60,20},
                {100,60}}),           iconTransformation(
            extent={{-10,-10},{10,10}},
            rotation=180,
            origin={90,60})));
      Physiolibrary.Types.RealIO.FractionInput FMetHb
                                       annotation (Placement(transformation(extent={{60,-20},
                {100,20}}),           iconTransformation(
            extent={{-10,-10},{10,10}},
            rotation=180,
            origin={90,20})));

      Physiolibrary.Types.RealIO.FractionInput FHbF
                                       annotation (Placement(transformation(extent={{60,-60},
                {100,-20}}),          iconTransformation(
            extent={{-10,-10},{10,10}},
            rotation=180,
            origin={90,-20})));

    //  Real mlTOmmol_O2(unit="mMol/ml") = 8.18/0.182
    //    "conversion constant for oxygen mass from ml to mMol";

     // Real mlTOmmol_O2(unit="mMol/ml") = 1/(740*2*16/1000)
     //   "conversion constant for oxygen mass from ml to mMol";
                                                       //8.18 / 0.182
                                                       //molar mass = 2*16 g/mol; density = 740 ml/g

     // constant Real MiniliterPerLiter(final unit="ml/l")=1000;

      Physiolibrary.Types.RealIO.PressureOutput pO2(start=5330)
                                          annotation (Placement(
            transformation(extent={{2,-112},{42,-72}}), iconTransformation(
            extent={{-20,-20},{20,20}},
            rotation=270,
            origin={40,-120})));

      Physiolibrary.Types.Concentration cdO2;
    /*
  Real aa;
  Real xx;
  Real yy;
  Real ssO2CO(start=0.96);
*/

     parameter Physiolibrary.Types.Temperature T0 = 273.15+37
        "normal temperature";
     parameter Physiolibrary.Types.pH pH0 = 7.4 "normal arterial pH";
     parameter Physiolibrary.Types.Pressure pCO20 = 5330
        "normal arterial CO2 partial pressure";
     parameter Physiolibrary.Types.Concentration cDPG0 = 5
        "normal DPG,used by a";
     parameter Real dadcDPG0 = 0.3 "used by a";
     parameter Real dadcDPGxHbF = -0.1 "or perhabs -0.125";
     parameter Real dadpH = -0.88 "used by a";
     parameter Real dadlnpCO2 = 0.048 "used by a";
     parameter Real dadxMetHb = -0.7 "used by a";
     parameter Real dadxHbF = -0.25 "used by a";

     //constant Real PaTOmmHg = 1/133;

    equation
    //   PO2 = PaTOmmHg*1000 * pO2;

    //  pCOmmHg = PaTOmmHg*1000 * pCO;
    //  pCO2mmHg = PaTOmmHg*1000 * pCO2;

    //oxygen:
      ceHb = ctHb * (1-FCOHb-FMetHb); //effective haemoglobin

      assert(tO2 <= ceHb*(1.06), "Model does not support this high level of oxygen in blood. Maximum of oxygen concentration should be connected with efective hemoglobin concentration!");
        //pO2,pCO,pCO2 .. Pa
      //TODO: check units of solubility
      aO2 = exp(log(0.0105)+(-0.0115*(T-T0))+0.5*0.00042*(T-T0)^2)/1000; //solubility
      cdO2 = aO2*pO2;
    /*  if (isSaturated) then
    cdO2 = homotopy( tO2 - sO2*ceHb, tO2 - 0.9999*ceHb);
  else
    sO2 = homotopy( (tO2-cdO2)/ceHb,  tO2/ceHb);  // ctO2 = aO2*pO2 + ceHb*sO2;  nazaciatok postaci veskery kyslik mat iba na hemoglobine a potom pridat uz len to zrnko rozpusteneho..
  end if; */
     //TODO: why not sO2 = homotopy( (tO2-cdO2)/ceHb,  tO2/ceHb);
      tO2 = aO2*pO2 + ceHb*sO2;
    //  cO2Hb = tO2 - cdO2;
      sO2 = cO2Hb/ceHb;
      //TODO: check this: a=-0.88*(pH-7.4)+0.048*log(pCO2/5.33)-0.7*FMetHb+(0.3-0.25*FHbF)*cDPG/(5-1);
      //TANH
      a=dadpH*(pH-pH0)+dadlnpCO2*log(max(1e-15+1e-22*pCO2,pCO2/pCO20)) +dadxMetHb*FMetHb+(dadcDPG0 + dadcDPGxHbF*FHbF)*(cDPG/cDPG0 - 1); //log(pCO2/5330)

      //orginal:
      x=log(pO2CO/7000) - a - 0.055*(T-T0); //namiesto:  x=log(pO2CO/7) - a - 0.055*(T-37);
      y-1.8747=x+h*tanh(k*x);
      k=0.5342857;
      h=3.5 + a;
      y=log(sO2CO/(1-sO2CO));

      //simplification:
    /*  ey/ey0=ex*exp((3.5 + a)*tnh);  //TANH:  y-log(0.867/(1-0.867))=x+(3.5 + a)*tanh(0.5342857*x);
  ey0=0.867/(1-0.867);  //y0=log(0.867/(1-0.867)); //1.8747
  tnh = (ex^(2*k) - 1) / (ex^(2*k) + 1);  // = tanh(k*x)
  ex=max(1e-15*(1+1e-6*pO2CO),(pO2CO/7.000) / exp(a + 0.055*(T-37)));  // = exp(x); x=log(max(1e-15*(1+1e-6*pO2CO),pO2CO/7000)) - a - 0.055*(T_degC-37);
  k=0.5342857;
  ey=sO2CO/(1-sO2CO); // = exp(y);  y=log(max(1e-15*(1+1e-6*sO2CO/(1-sO2CO)),sO2CO/(1-sO2CO)));
  */
        /************ O2 ********************/

      /************ CO ********************/
      //Haldane:
     /* if (pCOmmHg<1e-10) then
    sCO = 0;
    pO2CO = pO2;
    sO2CO = sO2;
    FCOHb = 0;/*
  else*/
     /*   pCO = sCO*pO2CO/ 218*sO2CO;
    pO2CO = pO2 + 218*pCO;
    sO2CO = (cO2Hb + ctHb*FCOHb)/(ctHb*(1-FMetHb));
    sCO = ctHb*FCOHb/(ctHb*(1-FMetHb));*/

        {pCO,FCOHb,pO2CO,sO2CO}=homotopy({sCO*pO2CO/ 218*sO2CO,sCO*(1-FMetHb),pO2 + 218*pCO,(cO2Hb + ctHb*FCOHb)/(ctHb*(1-FMetHb))},
        {0,0,pO2,sO2});
    //  end if;

    /*  ceHb = ctHb * (1-FCOHb-FMetHb); //effective haemoglobin
  aO2 = exp(log(0.0105)+(-0.0115*(T-37))+0.5*0.00042*(T-37)^2); //solubility
  tO2 = aO2*pO2 + ceHb*sO2;
  //Haldane:
  sCO*pO2CO = 218*pCO*sO2CO;
  pO2CO = pO2 + 218*pCO;
  //saturation definitions: "result: sO2CO = (sO2*(ceHb/ctHb)+FCOHb)/(1-FMetHb);"
  sO2 = cO2Hb/ceHb;
  sO2CO = (cO2Hb + ctHb*FCOHb)/(ctHb*(1-FMetHb));
  sCO = ctHb*FCOHb/(ctHb*(1-FMetHb));
  //TANH
//  a=-0.88*(pH-7.4)+0.048*log(pCO2/5.33)-0.7*FMetHb+(0.3-0.25*FHbF)*cDPG/(5-1); //Bohr coefficient: -der(log10(pO2),pH)=0.88/ln(10)=0.38, -der(ln(pO2),pH)=0.88
//  x=log(pO2CO/7); //namiesto:  x=log(pO2CO/7) - a - 0.055*(T-37);
  y-y0=x+h*tanh(k*x);
  y0=log(0.867/(1-0.867)); //1.8747

  k=0.5342857;
  h=3.5 + a;
//  y=log(sO2CO/(1-sO2CO));

//corrected:
  a=-0.88*(pH-7.4)+0.048*log(max(1e-15+1e-24*pCO2,pCO2/5.33))-0.7*FMetHb+(0.3-0.1*FHbF)*(cDPG/5 - 1);
  x=log(max(1e-15+1e-24*pO2CO,pO2CO/7)) - a - 0.055*(T-37);
  y=log(max(1e-15+1e-24*sO2CO/(1-sO2CO),sO2CO/(1-sO2CO)));

*/

    //oxygen: working well:
      //TANH
    //  a=-0.88*(pH-7.4)+0.048*log(max(1e-15+1e-19*pCO2,pCO2/5.33))-0.7*FMetHb+(0.3-0.25*FHbF)*cDPG/(5-1); //Bohr coefficient: -der(log10(pO2),pH)=0.88/ln(10)=0.38, -der(ln(pO2),pH)=0.88
    //  x=log(pO2CO/7);
    //  x=log(max(1e-15+1e-19*pO2CO,pO2CO/7)) - a - 0.055*(T-37); //namiesto:  x=log(pO2CO/7) - a - 0.055*(T-37);
    //  y=log(max(1e-15+1e-19*sO2CO/(1-sO2CO),sO2CO/(1-sO2CO)));

      annotation (Icon(coordinateSystem(preserveAspectRatio=true, extent={{-100,
                -100},{100,100}}), graphics={Rectangle(
              extent={{-100,100},{100,-100}},
              lineColor={0,0,255},
              fillColor={215,215,215},
              fillPattern=FillPattern.Solid), Text(
              extent={{-74,-32},{74,-64}},
              lineColor={0,0,255},
              textString="%name")}));
    end BloodO2Base;

      model MeassureBloodO2
        extends Physiomodel.Gases.O2.BloodO2Base;//_withoutCO_;
      Physiolibrary.Chemical.Interfaces.ChemicalPort_a q_in annotation (
          Placement(transformation(extent={{-28,-116},{12,-76}}),
            iconTransformation(extent={{-20,-100},{20,-60}})));
      equation
         q_in.q = 0;  //flows: mmol/min
         tO2 = q_in.conc; //mmol/l
      end MeassureBloodO2;

      model BloodO2_Siggaard

      extends BloodO2Base;
                          //_withoutCO_;

      //Physiolibrary.Chemical.Interfaces.ChemicalPort_a q_in;
      //Physiolibrary.Chemical.Interfaces.ChemicalPort_b q_out;
      //Physiolibrary.Chemical.Interfaces.ChemicalPort_b alveolar;
      //Modelica.Blocks.Interfaces.RealInput

        Physiolibrary.Chemical.Interfaces.ChemicalPort_a q_in
          annotation (Placement(transformation(extent={{-100,-100},{-80,-80}}),
              iconTransformation(extent={{-100,-100},{-80,-80}})));
        Physiolibrary.Chemical.Interfaces.ChemicalPort_b q_out
          annotation (Placement(transformation(extent={{80,-100},{100,-80}}),
              iconTransformation(extent={{80,-100},{100,-80}})));
        Physiolibrary.Chemical.Interfaces.ChemicalPort_b alveolar
          annotation (Placement(transformation(extent={{-14,72},{6,92}}),
              iconTransformation(extent={{-14,72},{6,92}})));
        Physiolibrary.Types.RealIO.VolumeFlowRateInput BloodFlow
          annotation (Placement(transformation(extent={{-120,-54},{-80,-14}})));
        Physiolibrary.Types.RealIO.ConcentrationOutput ceHb_(
                                             displayUnit="mmol/l")
        "effective haemoglobin"             annotation (Placement(
              transformation(extent={{38,-102},{78,-62}}),iconTransformation(
              extent={{-20,-20},{20,20}},
              rotation=270,
              origin={-40,-120})));
      equation
      q_in.q + q_out.q + alveolar.q = 0;  //flows: mmol/min

      alveolar.conc =cdO2;

      q_in.conc = q_in.q/ BloodFlow; //mmol/l

      //tO2 = MiniliterPerLiter * (-q_out.q/ BloodFlow); //mmol/l
      tO2 =  (-q_out.q/ BloodFlow); //mmol/l

      ceHb_ = ceHb;

      end BloodO2_Siggaard;

      model BloodO2_Siggaard_Liver
        extends Physiomodel.Gases.O2.BloodO2Base;//_withoutCO_;
      Physiolibrary.Chemical.Interfaces.ChemicalPort_a hepaticArty annotation (
          Placement(transformation(extent={{-120,-120},{-80,-80}}),
            iconTransformation(extent={{-120,-120},{-80,-80}})));
      Physiolibrary.Chemical.Interfaces.ChemicalPort_b q_out annotation (
          Placement(transformation(extent={{80,-120},{120,-80}}),
            iconTransformation(extent={{80,-120},{120,-80}})));
      Physiolibrary.Hydraulic.Interfaces.HydraulicPort_a alveolar annotation (
          Placement(transformation(extent={{-20,80},{20,120}}),
            iconTransformation(extent={{-20,80},{20,120}})));

        Modelica.Blocks.Interfaces.RealInput HepaticArtyBloodFlow(
                                                           displayUnit="ml/min")
                                         annotation (Placement(transformation(extent={{-120,
                  -80},{-80,-40}}),     iconTransformation(extent={{-100,-80},{-80,-60}})));

      Physiolibrary.Chemical.Interfaces.ChemicalPort_a GIT annotation (
          Placement(transformation(extent={{-120,-120},{-80,-80}}),
            iconTransformation(extent={{-120,-40},{-80,0}})));
        Modelica.Blocks.Interfaces.RealInput GITBloodFlow(
                                                   displayUnit="ml/min")
                                         annotation (Placement(transformation(extent={{-120,
                  -80},{-80,-40}}),     iconTransformation(extent={{-100,0},{-80,20}})));
      equation
        GIT.q + hepaticArty.q + q_out.q + alveolar.q = 0;  //flows: mmol/min

        alveolar.pressure =Physiolibrary.NonSIunits.PaTOmmHg
                                                       *1000 * pO2;

        hepaticArty.conc = hepaticArty.q/ HepaticArtyBloodFlow; //mmol/ml
        GIT.conc = GIT.q/ GITBloodFlow; //mmol/ml

        tO2 = MiniliterPerLiter * (-q_out.q/ (GITBloodFlow+HepaticArtyBloodFlow)); //mmol/l

        annotation (Icon(coordinateSystem(preserveAspectRatio=true, extent={{-100,
                  -100},{100,100}}), graphics={
              Rectangle(
                extent={{-100,100},{100,-100}},
                lineColor={0,0,255},
                fillColor={215,215,215},
                fillPattern=FillPattern.Solid),
              Text(
                extent={{-74,-32},{74,-64}},
                lineColor={0,0,255},
                textString="%name"),
              Polygon(
                points={{-72,10},{80,0},{-72,-10},{-72,10}},
                lineColor={0,0,127},
                fillColor={255,255,255},
                fillPattern=FillPattern.Solid,
                origin={-2,-84},
                rotation=360)}));
      end BloodO2_Siggaard_Liver;

      model TissuesO2
       extends Physiolibrary.Icons.Tissues;
      Physiolibrary.Chemical.Interfaces.ChemicalPort_a q_in annotation (
          Placement(transformation(extent={{80,-20},{120,20}}),
            iconTransformation(extent={{100,-20},{140,20}})));
      Physiolibrary.Chemical.Interfaces.ChemicalPort_b q_out annotation (
          Placement(transformation(extent={{-120,-20},{-80,20}}),
            iconTransformation(extent={{-140,-20},{-100,20}})));
        Tissues.SkeletalMuscleO2 skeletalMuscleO2(
                                               initialMass=323.9)
          annotation (Placement(transformation(extent={{-54,64},{-34,84}})));
        Tissues.BoneO2 boneO2(       initialMass=56.2)
          annotation (Placement(transformation(extent={{-54,36},{-34,56}})));
        Tissues.FatO2 fatO2(        initialMass=39.8)
          annotation (Placement(transformation(extent={{-54,-54},{-34,-34}})));
        Tissues.BrainO2 brainO2(      initialMass=19.1)
          annotation (Placement(transformation(extent={{52,20},{72,40}})));
        Tissues.RightHeartO2 rightHeartO2( initialMass=0.6)
          annotation (Placement(transformation(extent={{52,-100},{72,-80}})));
        Tissues.RespiratoryMuscleO2 respiratoryMuscleO2(
                                                  initialMass=48.1)
          annotation (Placement(transformation(extent={{-54,-24},{-34,-4}})));
        Tissues.OtherTissueO2 otherTissueO2(initialMass=50.7)
          annotation (Placement(transformation(extent={{-54,6},{-34,26}})));
        Tissues.LiverO2 liverO2(initialMass=22.8)
          annotation (Placement(transformation(extent={{52,50},{72,70}})));
        Tissues.LeftHeartO2 leftHeartO2(  initialMass=3.5)
          annotation (Placement(transformation(extent={{52,-70},{72,-50}})));
        Physiomodel.Gases.O2.Tissues.TissueO2_kidney kidneyO2(initialMass=4.1)
          annotation (Placement(transformation(extent={{52,-40},{72,-20}})));
        Tissues.GITractO2 GITractO2(    initialMass=17.6)
          annotation (Placement(transformation(extent={{52,-10},{72,10}})));
      Physiolibrary.Types.BusConnector busConnector
        annotation (Placement(transformation(extent={{-108,72},{-68,112}})));
        Tissues.SkinO2 skinO2(       initialMass=28.2)
          annotation (Placement(transformation(extent={{-54,-84},{-34,-64}})));

       Physiolibrary.Types.MolarFlowRate O2ToTissues(displayUnit="mmol/min");
      // Real O2ToTissues2(displayUnit="mmol/min");
      // Real O2ToTissues3(displayUnit="ml/min");
       Physiolibrary.Types.VolumeFlowRate BloodFlow(displayUnit="ml/min");
      equation
       O2ToTissues = q_in.q + q_out.q;
       /*O2ToTissues2 =
 skeletalMuscleO2.O2Use_mmol_per_min +
 boneO2.O2Use_mmol_per_min +
 fatO2.O2Use_mmol_per_min +
 brainO2.O2Use_mmol_per_min +
 rightHeartO2.O2Use_mmol_per_min +
 respiratoryMuscleO2.O2Use_mmol_per_min +
 otherTissueO2.O2Use_mmol_per_min +
 liverO2.O2Use_mmol_per_min +
 leftHeartO2.O2Use_mmol_per_min +
 kidneyO2.O2Use_mmol_per_min +
 GITractO2.O2Use_mmol_per_min +
 skinO2.O2Use_mmol_per_min;
 O2ToTissues3 =
 skeletalMuscleO2.O2Use_ml_per_min +
 boneO2.O2Use_ml_per_min +
 fatO2.O2Use_ml_per_min +
 brainO2.O2Use_ml_per_min +
 rightHeartO2.O2Use_ml_per_min +
 respiratoryMuscleO2.O2Use_ml_per_min +
 otherTissueO2.O2Use_ml_per_min +
 liverO2.O2Use_ml_per_min +
 leftHeartO2.O2Use_ml_per_min +
 kidneyO2.O2Use_ml_per_min +
 GITractO2.O2Use_ml_per_min +
 skinO2.O2Use_ml_per_min;*/
      BloodFlow=
       skeletalMuscleO2.BloodFlow +
       boneO2.BloodFlow +
       fatO2.BloodFlow +
       brainO2.BloodFlow +
       rightHeartO2.BloodFlow +
       respiratoryMuscleO2.BloodFlow +
       otherTissueO2.BloodFlow +
       liverO2.BloodFlow +
       leftHeartO2.BloodFlow +
       kidneyO2.BloodFlow +
       GITractO2.BloodFlow +
       skinO2.BloodFlow;

        connect(q_out, skeletalMuscleO2.vein) annotation (Line(
            points={{-100,0},{-82,0},{-82,76},{-54,76}},
            color={200,0,0},
            thickness=1,
            smooth=Smooth.None));

        connect(q_out, boneO2.vein) annotation (Line(
            points={{-100,0},{-82,0},{-82,48},{-54,48}},
            color={200,0,0},
            thickness=1,
            smooth=Smooth.None));
        connect(q_out, otherTissueO2.vein) annotation (Line(
            points={{-100,0},{-82,0},{-82,18},{-54,18}},
            color={200,0,0},
            thickness=1,
            smooth=Smooth.None));
        connect(q_out, respiratoryMuscleO2.vein) annotation (Line(
            points={{-100,0},{-81,0},{-81,-12},{-54,-12}},
            color={200,0,0},
            thickness=1,
            smooth=Smooth.None));
        connect(q_out, fatO2.vein) annotation (Line(
            points={{-100,0},{-82,0},{-82,-42},{-54,-42}},
            color={200,0,0},
            thickness=1,
            smooth=Smooth.None));
        connect(q_out, skinO2.vein) annotation (Line(
            points={{-100,0},{-82,0},{-82,-72},{-54,-72}},
            color={200,0,0},
            thickness=1,
            smooth=Smooth.None));
        connect(q_out, liverO2.vein) annotation (Line(
            points={{-100,0},{-82,0},{-82,62},{52,62}},
            color={200,0,0},
            thickness=1,
            smooth=Smooth.None));
        connect(q_out, brainO2.vein) annotation (Line(
            points={{-100,0},{-82,0},{-82,32},{52,32}},
            color={200,0,0},
            thickness=1,
            smooth=Smooth.None));
        connect(q_out, kidneyO2.vein) annotation (Line(
            points={{-100,0},{-82,0},{-82,-28},{52,-28}},
            color={200,0,0},
            thickness=1,
            smooth=Smooth.None));
        connect(q_out, leftHeartO2.vein) annotation (Line(
            points={{-100,0},{-82,0},{-82,-58},{52,-58}},
            color={200,0,0},
            thickness=1,
            smooth=Smooth.None));
        connect(skeletalMuscleO2.arty, q_in) annotation (Line(
            points={{-34,76},{84,76},{84,0},{100,0}},
            color={200,0,0},
            thickness=1,
            smooth=Smooth.None));
        connect(brainO2.arty, q_in) annotation (Line(
            points={{72,32},{84,32},{84,0},{100,0}},
            color={200,0,0},
            thickness=1,
            smooth=Smooth.None));
        connect(GITractO2.arty, q_in) annotation (Line(
            points={{72,2},{86,2},{86,0},{100,0}},
            color={200,0,0},
            thickness=1,
            smooth=Smooth.None));
        connect(kidneyO2.arty, q_in) annotation (Line(
            points={{72,-28},{84,-28},{84,0},{100,0}},
            color={200,0,0},
            thickness=1,
            smooth=Smooth.None));
        connect(leftHeartO2.arty, q_in) annotation (Line(
            points={{72,-58},{84,-58},{84,0},{100,0}},
            color={200,0,0},
            thickness=1,
            smooth=Smooth.None));
        connect(rightHeartO2.arty, q_in) annotation (Line(
            points={{72,-88},{84,-88},{84,0},{100,0}},
            color={200,0,0},
            thickness=1,
            smooth=Smooth.None));
        connect(rightHeartO2.vein, q_out) annotation (Line(
            points={{52,-88},{-82,-88},{-82,0},{-100,0}},
            color={200,0,0},
            thickness=1,
            smooth=Smooth.None));
        connect(boneO2.arty, q_in) annotation (Line(
            points={{-34,48},{84,48},{84,0},{100,0}},
            color={200,0,0},
            thickness=1,
            smooth=Smooth.None));
        connect(otherTissueO2.arty, q_in) annotation (Line(
            points={{-34,18},{84,18},{84,0},{100,0}},
            color={200,0,0},
            thickness=1,
            smooth=Smooth.None));
        connect(fatO2.arty, q_in) annotation (Line(
            points={{-34,-42},{84,-42},{84,0},{100,0}},
            color={200,0,0},
            thickness=1,
            smooth=Smooth.None));
        connect(skinO2.arty, q_in) annotation (Line(
            points={{-34,-72},{84,-72},{84,0},{100,0}},
            color={200,0,0},
            thickness=1,
            smooth=Smooth.None));
        connect(q_in, respiratoryMuscleO2.arty) annotation (Line(
            points={{100,0},{84,0},{84,-12},{-34,-12}},
            color={200,0,0},
            thickness=1,
            smooth=Smooth.None));

        connect(busConnector.cDPG, boneO2.cDPG)     annotation (
           Line(
            points={{-88,92},{-88,56},{-53,56}},
            color={0,127,0},
            smooth=Smooth.None), Text(
            string="%first",
            index=-1,
            extent={{-5,2},{-5,2}}));
        connect(busConnector.cDPG, brainO2.cDPG)
          annotation (Line(
            points={{-88,92},{6,92},{6,40},{53,40}},
            color={0,127,0},
            smooth=Smooth.None), Text(
            string="%first",
            index=-1,
            extent={{-5,2},{-5,2}}));
        connect(busConnector.cDPG, fatO2.cDPG)      annotation (
            Line(
            points={{-88,92},{-88,-34},{-53,-34}},
            color={0,127,0},
            smooth=Smooth.None), Text(
            string="%first",
            index=-1,
            extent={{-5,2},{-5,2}}));
        connect(busConnector.cDPG, GITractO2.cDPG)
          annotation (Line(
            points={{-88,92},{6,92},{6,10},{53,10}},
            color={0,127,0},
            smooth=Smooth.None), Text(
            string="%first",
            index=-1,
            extent={{-5,2},{-5,2}}));
        connect(busConnector.cDPG, kidneyO2.cDPG)
          annotation (Line(
            points={{-88,92},{6,92},{6,-20},{53,-20}},
            color={0,127,0},
            smooth=Smooth.None), Text(
            string="%first",
            index=-1,
            extent={{-5,2},{-5,2}}));
        connect(busConnector.cDPG, leftHeartO2.cDPG)
          annotation (Line(
            points={{-88,92},{6,92},{6,-50},{53,-50}},
            color={0,127,0},
            smooth=Smooth.None), Text(
            string="%first",
            index=-1,
            extent={{-5,2},{-5,2}}));
        connect(busConnector.cDPG, liverO2.cDPG)
          annotation (Line(
            points={{-88,92},{6,92},{6,70},{53,70}},
            color={0,127,0},
            smooth=Smooth.None), Text(
            string="%first",
            index=-1,
            extent={{-5,2},{-5,2}}));
        connect(busConnector.cDPG, otherTissueO2.cDPG)
          annotation (Line(
            points={{-88,92},{-88,26},{-53,26}},
            color={0,127,0},
            smooth=Smooth.None), Text(
            string="%first",
            index=-1,
            extent={{-5,2},{-5,2}}));
        connect(busConnector.cDPG, respiratoryMuscleO2.cDPG)
          annotation (Line(
            points={{-88,92},{-88,-4},{-53,-4}},
            color={0,127,0},
            smooth=Smooth.None), Text(
            string="%first",
            index=-1,
            extent={{-5,2},{-5,2}}));
        connect(busConnector.cDPG, rightHeartO2.cDPG)
          annotation (Line(
            points={{-88,92},{6,92},{6,-80},{53,-80}},
            color={0,127,0},
            smooth=Smooth.None), Text(
            string="%first",
            index=-1,
            extent={{-5,2},{-5,2}}));
        connect(busConnector.cDPG, skinO2.cDPG)      annotation (
           Line(
            points={{-88,92},{-88,-64},{-53,-64}},
            color={0,127,0},
            smooth=Smooth.None), Text(
            string="%first",
            index=-1,
            extent={{-5,2},{-5,2}}));
        connect(busConnector.cDPG, skeletalMuscleO2.cDPG)
          annotation (Line(
            points={{-88,92},{-87.5,92},{-87.5,84},{-53,84}},
            color={127,0,0},
            smooth=Smooth.None), Text(
            string="%first",
            index=-1,
            extent={{-5,2},{-5,2}}));

        connect(busConnector.FHbF, boneO2.FHbF)      annotation (
           Line(
            points={{-88,92},{-88,40},{-53,40}},
            color={0,127,0},
            smooth=Smooth.None), Text(
            string="%first",
            index=-1,
            extent={{-5,2},{-5,2}}));
        connect(busConnector.FHbF, brainO2.FHbF)
          annotation (Line(
            points={{-88,92},{6,92},{6,24},{53,24}},
            color={0,127,0},
            smooth=Smooth.None), Text(
            string="%first",
            index=-1,
            extent={{-5,2},{-5,2}}));
        connect(busConnector.FHbF, fatO2.FHbF)      annotation (
            Line(
            points={{-88,92},{-88,-50},{-53,-50}},
            color={0,127,0},
            smooth=Smooth.None), Text(
            string="%first",
            index=-1,
            extent={{-5,2},{-5,2}}));
        connect(busConnector.FHbF, GITractO2.FHbF)
          annotation (Line(
            points={{-88,92},{6,92},{6,-6},{53,-6}},
            color={0,127,0},
            smooth=Smooth.None), Text(
            string="%first",
            index=-1,
            extent={{-5,2},{-5,2}}));
        connect(busConnector.FHbF, kidneyO2.FHbF)
          annotation (Line(
            points={{-88,92},{6,92},{6,-36},{53,-36}},
            color={0,127,0},
            smooth=Smooth.None), Text(
            string="%first",
            index=-1,
            extent={{-5,2},{-5,2}}));
        connect(busConnector.FHbF, leftHeartO2.FHbF)
          annotation (Line(
            points={{-88,92},{6,92},{6,-66},{53,-66}},
            color={0,127,0},
            smooth=Smooth.None), Text(
            string="%first",
            index=-1,
            extent={{-5,2},{-5,2}}));
        connect(busConnector.FHbF, liverO2.FHbF)
          annotation (Line(
            points={{-88,92},{6,92},{6,54},{53,54}},
            color={0,127,0},
            smooth=Smooth.None), Text(
            string="%first",
            index=-1,
            extent={{-5,2},{-5,2}}));
        connect(busConnector.FHbF, otherTissueO2.FHbF)
          annotation (Line(
            points={{-88,92},{-88,10},{-53,10}},
            color={0,127,0},
            smooth=Smooth.None), Text(
            string="%first",
            index=-1,
            extent={{-5,2},{-5,2}}));
        connect(busConnector.FHbF, respiratoryMuscleO2.FHbF)
          annotation (Line(
            points={{-88,92},{-88,-20},{-53,-20}},
            color={0,127,0},
            smooth=Smooth.None), Text(
            string="%first",
            index=-1,
            extent={{-5,2},{-5,2}}));
        connect(busConnector.FHbF, rightHeartO2.FHbF)
          annotation (Line(
            points={{-88,92},{6,92},{6,-96},{53,-96}},
            color={0,127,0},
            smooth=Smooth.None), Text(
            string="%first",
            index=-1,
            extent={{-5,2},{-5,2}}));
        connect(busConnector.FHbF, skinO2.FHbF)      annotation (
           Line(
            points={{-88,92},{-88,-80},{-53,-80}},
            color={0,127,0},
            smooth=Smooth.None), Text(
            string="%first",
            index=-1,
            extent={{-5,2},{-5,2}}));
        connect(busConnector.FHbF, skeletalMuscleO2.FHbF)
          annotation (Line(
            points={{-88,92},{-87.5,92},{-87.5,68},{-53,68}},
            color={127,0,0},
            smooth=Smooth.None), Text(
            string="%first",
            index=-1,
            extent={{-5,2},{-5,2}}));

        connect(busConnector.bone.pCO2, boneO2.pCO2)        annotation (
           Line(
            points={{-88,92},{-88,36},{-53,36}},
            color={0,127,0},
            smooth=Smooth.None), Text(
            string="%first",
            index=-1,
            extent={{-5,2},{-5,2}}));
        connect(busConnector.brain.pCO2, brainO2.pCO2)
          annotation (Line(
            points={{-88,92},{6,92},{6,20},{53,20}},
            color={0,127,0},
            smooth=Smooth.None), Text(
            string="%first",
            index=-1,
            extent={{-5,2},{-5,2}}));
        connect(busConnector.fat.pCO2, fatO2.pCO2)      annotation (
            Line(
            points={{-88,92},{-88,-54},{-53,-54}},
            color={0,127,0},
            smooth=Smooth.None), Text(
            string="%first",
            index=-1,
            extent={{-5,2},{-5,2}}));
        connect(busConnector.GITract.pCO2, GITractO2.pCO2)
          annotation (Line(
            points={{-88,92},{6,92},{6,-10},{53,-10}},
            color={0,127,0},
            smooth=Smooth.None), Text(
            string="%first",
            index=-1,
            extent={{-5,2},{-5,2}}));
        connect(busConnector.kidney_pCO2, kidneyO2.pCO2)
          annotation (Line(
            points={{-88,92},{6,92},{6,-40},{53,-40}},
            color={0,127,0},
            smooth=Smooth.None), Text(
            string="%first",
            index=-1,
            extent={{-5,2},{-5,2}}));
        connect(busConnector.leftHeart_pCO2, leftHeartO2.pCO2)
          annotation (Line(
            points={{-88,92},{6,92},{6,-70},{53,-70}},
            color={0,127,0},
            smooth=Smooth.None), Text(
            string="%first",
            index=-1,
            extent={{-5,2},{-5,2}}));
        connect(busConnector.liver_pCO2, liverO2.pCO2)
          annotation (Line(
            points={{-88,92},{6,92},{6,50},{53,50}},
            color={0,127,0},
            smooth=Smooth.None), Text(
            string="%first",
            index=-1,
            extent={{-5,2},{-5,2}}));
        connect(busConnector.otherTissue.pCO2, otherTissueO2.pCO2)
          annotation (Line(
            points={{-88,92},{-88,6},{-53,6}},
            color={0,127,0},
            smooth=Smooth.None), Text(
            string="%first",
            index=-1,
            extent={{-5,2},{-5,2}}));
        connect(busConnector.respiratoryMuscle.pCO2, respiratoryMuscleO2.pCO2)
          annotation (Line(
            points={{-88,92},{-88,-24},{-53,-24}},
            color={0,127,0},
            smooth=Smooth.None), Text(
            string="%first",
            index=-1,
            extent={{-5,2},{-5,2}}));
        connect(busConnector.rightHeart_pCO2, rightHeartO2.pCO2)
          annotation (Line(
            points={{-88,92},{6,92},{6,-100},{53,-100}},
            color={0,127,0},
            smooth=Smooth.None), Text(
            string="%first",
            index=-1,
            extent={{-5,2},{-5,2}}));
        connect(busConnector.skin_pCO2, skinO2.pCO2)      annotation (
           Line(
            points={{-88,92},{-88,-84},{-53,-84}},
            color={0,127,0},
            smooth=Smooth.None), Text(
            string="%first",
            index=-1,
            extent={{-5,2},{-5,2}}));
        connect(busConnector.skeletalMuscle.pCO2, skeletalMuscleO2.pCO2)
          annotation (Line(
            points={{-88,92},{-87.5,92},{-87.5,64},{-53,64}},
            color={127,0,0},
            smooth=Smooth.None), Text(
            string="%first",
            index=-1,
            extent={{-5,2},{-5,2}}));

        connect(busConnector.ctHb, boneO2.ctHb)      annotation (
           Line(
            points={{-88,92},{-88,44},{-53,44}},
            color={0,127,0},
            smooth=Smooth.None), Text(
            string="%first",
            index=-1,
            extent={{-5,2},{-5,2}}));
        connect(busConnector.ctHb, brainO2.ctHb)
          annotation (Line(
            points={{-88,92},{6,92},{6,28},{53,28}},
            color={0,127,0},
            smooth=Smooth.None), Text(
            string="%first",
            index=-1,
            extent={{-5,2},{-5,2}}));
        connect(busConnector.ctHb, fatO2.ctHb)      annotation (
            Line(
            points={{-88,92},{-88,-46},{-53,-46}},
            color={0,127,0},
            smooth=Smooth.None), Text(
            string="%first",
            index=-1,
            extent={{-5,2},{-5,2}}));
        connect(busConnector.ctHb, GITractO2.ctHb)
          annotation (Line(
            points={{-88,92},{6,92},{6,-2},{53,-2}},
            color={0,127,0},
            smooth=Smooth.None), Text(
            string="%first",
            index=-1,
            extent={{-5,2},{-5,2}}));
        connect(busConnector.ctHb, kidneyO2.ctHb)
          annotation (Line(
            points={{-88,92},{6,92},{6,-32},{53,-32}},
            color={0,127,0},
            smooth=Smooth.None), Text(
            string="%first",
            index=-1,
            extent={{-5,2},{-5,2}}));
        connect(busConnector.ctHb, leftHeartO2.ctHb)
          annotation (Line(
            points={{-88,92},{6,92},{6,-62},{53,-62}},
            color={0,127,0},
            smooth=Smooth.None), Text(
            string="%first",
            index=-1,
            extent={{-5,2},{-5,2}}));
        connect(busConnector.ctHb, liverO2.ctHb)
          annotation (Line(
            points={{-88,92},{6,92},{6,58},{53,58}},
            color={0,127,0},
            smooth=Smooth.None), Text(
            string="%first",
            index=-1,
            extent={{-5,2},{-5,2}}));
        connect(busConnector.ctHb, otherTissueO2.ctHb)
          annotation (Line(
            points={{-88,92},{-88,14},{-53,14}},
            color={0,127,0},
            smooth=Smooth.None), Text(
            string="%first",
            index=-1,
            extent={{-5,2},{-5,2}}));
        connect(busConnector.ctHb, respiratoryMuscleO2.ctHb)
          annotation (Line(
            points={{-88,92},{-88,-16},{-53,-16}},
            color={0,127,0},
            smooth=Smooth.None), Text(
            string="%first",
            index=-1,
            extent={{-5,2},{-5,2}}));
        connect(busConnector.ctHb, rightHeartO2.ctHb)
          annotation (Line(
            points={{-88,92},{6,92},{6,-92},{53,-92}},
            color={0,127,0},
            smooth=Smooth.None), Text(
            string="%first",
            index=-1,
            extent={{-5,2},{-5,2}}));
        connect(busConnector.ctHb, skinO2.ctHb)      annotation (
           Line(
            points={{-88,92},{-88,-76},{-53,-76}},
            color={0,127,0},
            smooth=Smooth.None), Text(
            string="%first",
            index=-1,
            extent={{-5,2},{-5,2}}));
        connect(busConnector.ctHb, skeletalMuscleO2.ctHb)
          annotation (Line(
            points={{-88,92},{-87.5,92},{-87.5,72},{-53,72}},
            color={127,0,0},
            smooth=Smooth.None), Text(
            string="%first",
            index=-1,
            extent={{-5,2},{-5,2}}));

        connect(busConnector.pCO, boneO2.pCO)
          annotation (Line(
            points={{-88,92},{-87.5,92},{-87.5,52},{-53,52}},
            color={127,0,0},
            smooth=Smooth.None), Text(
            string="%first",
            index=-1,
            extent={{-5,2},{-5,2}}));
        connect(busConnector.pCO, brainO2.pCO)
          annotation (Line(
            points={{-88,92},{6,92},{6,36},{53,36}},
            color={0,127,0},
            smooth=Smooth.None), Text(
            string="%first",
            index=-1,
            extent={{-5,2},{-5,2}}));
        connect(busConnector.pCO, fatO2.pCO)      annotation (
            Line(
            points={{-88,92},{-88,-38},{-53,-38}},
            color={0,127,0},
            smooth=Smooth.None), Text(
            string="%first",
            index=-1,
            extent={{-5,2},{-5,2}}));
        connect(busConnector.pCO, GITractO2.pCO)
          annotation (Line(
            points={{-88,92},{6,92},{6,6},{53,6}},
            color={0,127,0},
            smooth=Smooth.None), Text(
            string="%first",
            index=-1,
            extent={{-5,2},{-5,2}}));
        connect(busConnector.pCO, kidneyO2.pCO)
          annotation (Line(
            points={{-88,92},{6,92},{6,-24},{53,-24}},
            color={0,127,0},
            smooth=Smooth.None), Text(
            string="%first",
            index=-1,
            extent={{-5,2},{-5,2}}));
        connect(busConnector.pCO, leftHeartO2.pCO)
          annotation (Line(
            points={{-88,92},{6,92},{6,-54},{53,-54}},
            color={0,127,0},
            smooth=Smooth.None), Text(
            string="%first",
            index=-1,
            extent={{-5,2},{-5,2}}));
        connect(busConnector.pCO, liverO2.pCO)
          annotation (Line(
            points={{-88,92},{6,92},{6,66},{53,66}},
            color={0,127,0},
            smooth=Smooth.None), Text(
            string="%first",
            index=-1,
            extent={{-5,2},{-5,2}}));
        connect(busConnector.pCO, otherTissueO2.pCO)
          annotation (Line(
            points={{-88,92},{-88,22},{-53,22}},
            color={0,127,0},
            smooth=Smooth.None), Text(
            string="%first",
            index=-1,
            extent={{-5,2},{-5,2}}));
        connect(busConnector.pCO, respiratoryMuscleO2.pCO)
          annotation (Line(
            points={{-88,92},{-88,-8},{-53,-8}},
            color={0,127,0},
            smooth=Smooth.None), Text(
            string="%first",
            index=-1,
            extent={{-5,2},{-5,2}}));
        connect(busConnector.pCO, rightHeartO2.pCO)
          annotation (Line(
            points={{-88,92},{6,92},{6,-84},{53,-84}},
            color={0,127,0},
            smooth=Smooth.None), Text(
            string="%first",
            index=-1,
            extent={{-5,2},{-5,2}}));
        connect(busConnector.pCO, skinO2.pCO)      annotation (
           Line(
            points={{-88,92},{-88,-68},{-53,-68}},
            color={0,127,0},
            smooth=Smooth.None), Text(
            string="%first",
            index=-1,
            extent={{-5,2},{-5,2}}));
        connect(busConnector.pCO, skeletalMuscleO2.pCO)
          annotation (Line(
            points={{-88,92},{-87.5,92},{-87.5,80},{-53,80}},
            color={127,0,0},
            smooth=Smooth.None), Text(
            string="%first",
            index=-1,
            extent={{-5,2},{-5,2}}));

        connect(boneO2.pH_plasma, busConnector.bone_pH_plasma)       annotation (
           Line(
            points={{-35,56},{6,56},{6,92},{-88,92}},
            color={0,127,0},
            smooth=Smooth.None), Text(
            string="%second",
            index=1,
            extent={{5,2},{5,2}}));
        connect(brainO2.pH_plasma, busConnector.brain_pH_plasma)
          annotation (Line(
            points={{71,40},{98,40},{98,92},{-88,92}},
            color={0,127,0},
            smooth=Smooth.None), Text(
            string="%second",
            index=1,
            extent={{5,2},{5,2}}));
        connect(fatO2.pH_plasma, busConnector.fat_pH_plasma)     annotation (
            Line(
            points={{-35,-34},{6,-34},{6,92},{-88,92}},
            color={0,127,0},
            smooth=Smooth.None), Text(
            string="%second",
            index=1,
            extent={{5,2},{5,2}}));
        connect(GITractO2.pH_plasma, busConnector.GITract_pH_plasma)
          annotation (Line(
            points={{71,10},{98,10},{98,92},{-88,92}},
            color={0,127,0},
            smooth=Smooth.None), Text(
            string="%second",
            index=1,
            extent={{5,2},{5,2}}));
        connect(kidneyO2.pH_plasma, busConnector.kidney_pH_plasma)
          annotation (Line(
            points={{71,-20},{98,-20},{98,92},{-88,92}},
            color={0,127,0},
            smooth=Smooth.None), Text(
            string="%second",
            index=1,
            extent={{5,2},{5,2}}));
        connect(leftHeartO2.pH_plasma, busConnector.leftHeart_pH_plasma)
          annotation (Line(
            points={{71,-50},{98,-50},{98,92},{-88,92}},
            color={0,127,0},
            smooth=Smooth.None), Text(
            string="%second",
            index=1,
            extent={{5,2},{5,2}}));
        connect(liverO2.pH_plasma, busConnector.liver_pH_plasma)
          annotation (Line(
            points={{71,70},{98,70},{98,92},{-88,92}},
            color={0,127,0},
            smooth=Smooth.None), Text(
            string="%second",
            index=1,
            extent={{5,2},{5,2}}));
        connect(otherTissueO2.pH_plasma, busConnector.otherTissue_pH_plasma)
          annotation (Line(
            points={{-35,26},{6,26},{6,92},{-88,92}},
            color={0,127,0},
            smooth=Smooth.None), Text(
            string="%second",
            index=1,
            extent={{5,2},{5,2}}));
        connect(respiratoryMuscleO2.pH_plasma, busConnector.respiratoryMuscle_pH_plasma)
          annotation (Line(
            points={{-35,-4},{6,-4},{6,92},{-88,92}},
            color={0,127,0},
            smooth=Smooth.None), Text(
            string="%second",
            index=1,
            extent={{5,2},{5,2}}));
        connect(rightHeartO2.pH_plasma, busConnector.rightHeart_pH_plasma)
          annotation (Line(
            points={{71,-80},{98,-80},{98,92},{-88,92}},
            color={0,127,0},
            smooth=Smooth.None), Text(
            string="%second",
            index=1,
            extent={{5,2},{5,2}}));
        connect(skinO2.pH_plasma, busConnector.skin_pH_plasma)     annotation (
           Line(
            points={{-35,-64},{6,-64},{6,92},{-88,92}},
            color={0,127,0},
            smooth=Smooth.None), Text(
            string="%second",
            index=1,
            extent={{5,2},{5,2}}));
        connect(skeletalMuscleO2.pH_plasma, busConnector.skeletalMuscle_pH_plasma)
          annotation (Line(
            points={{-35,84},{5.5,84},{5.5,92},{-88,92}},
            color={127,0,0},
            smooth=Smooth.None), Text(
            string="%second",
            index=1,
            extent={{5,2},{5,2}}));
        connect(boneO2.FMetHb, busConnector.FMetHb)       annotation (
           Line(
            points={{-35,52},{6,52},{6,92},{-88,92}},
            color={0,127,0},
            smooth=Smooth.None), Text(
            string="%second",
            index=1,
            extent={{5,2},{5,2}}));
        connect(brainO2.FMetHb, busConnector.FMetHb)
          annotation (Line(
            points={{71,36},{98,36},{98,92},{-88,92}},
            color={0,127,0},
            smooth=Smooth.None), Text(
            string="%second",
            index=1,
            extent={{5,2},{5,2}}));
        connect(fatO2.FMetHb, busConnector.FMetHb)     annotation (
            Line(
            points={{-35,-38},{6,-38},{6,92},{-88,92}},
            color={0,127,0},
            smooth=Smooth.None), Text(
            string="%second",
            index=1,
            extent={{5,2},{5,2}}));
        connect(GITractO2.FMetHb, busConnector.FMetHb)
          annotation (Line(
            points={{71,6},{98,6},{98,92},{-88,92}},
            color={0,127,0},
            smooth=Smooth.None), Text(
            string="%second",
            index=1,
            extent={{5,2},{5,2}}));
        connect(kidneyO2.FMetHb, busConnector.FMetHb)
          annotation (Line(
            points={{71,-24},{98,-24},{98,92},{-88,92}},
            color={0,127,0},
            smooth=Smooth.None), Text(
            string="%second",
            index=1,
            extent={{5,2},{5,2}}));
        connect(leftHeartO2.FMetHb, busConnector.FMetHb)
          annotation (Line(
            points={{71,-54},{98,-54},{98,92},{-88,92}},
            color={0,127,0},
            smooth=Smooth.None), Text(
            string="%second",
            index=1,
            extent={{5,2},{5,2}}));
        connect(liverO2.FMetHb, busConnector.FMetHb)
          annotation (Line(
            points={{71,66},{98,66},{98,92},{-88,92}},
            color={0,127,0},
            smooth=Smooth.None), Text(
            string="%second",
            index=1,
            extent={{5,2},{5,2}}));
        connect(otherTissueO2.FMetHb, busConnector.FMetHb)
          annotation (Line(
            points={{-35,22},{6,22},{6,92},{-88,92}},
            color={0,127,0},
            smooth=Smooth.None), Text(
            string="%second",
            index=1,
            extent={{5,2},{5,2}}));
        connect(respiratoryMuscleO2.FMetHb, busConnector.FMetHb)
          annotation (Line(
            points={{-35,-8},{6,-8},{6,92},{-88,92}},
            color={0,127,0},
            smooth=Smooth.None), Text(
            string="%second",
            index=1,
            extent={{5,2},{5,2}}));
        connect(rightHeartO2.FMetHb, busConnector.FMetHb)
          annotation (Line(
            points={{71,-84},{98,-84},{98,92},{-88,92}},
            color={0,127,0},
            smooth=Smooth.None), Text(
            string="%second",
            index=1,
            extent={{5,2},{5,2}}));
        connect(skinO2.FMetHb, busConnector.FMetHb)     annotation (
           Line(
            points={{-35,-68},{6,-68},{6,92},{-88,92}},
            color={0,127,0},
            smooth=Smooth.None), Text(
            string="%second",
            index=1,
            extent={{5,2},{5,2}}));
        connect(skeletalMuscleO2.FMetHb, busConnector.FMetHb)
          annotation (Line(
            points={{-35,80},{5.5,80},{5.5,92},{-88,92}},
            color={127,0,0},
            smooth=Smooth.None), Text(
            string="%second",
            index=1,
            extent={{5,2},{5,2}}));

        connect(boneO2.Tissue_O2Use, busConnector.bone_O2Use)       annotation (
           Line(
            points={{-35,44},{6,44},{6,92},{-88,92}},
            color={0,127,0},
            smooth=Smooth.None), Text(
            string="%second",
            index=1,
            extent={{5,2},{5,2}}));
        connect(brainO2.Tissue_O2Use, busConnector.brain_O2Use)
          annotation (Line(
            points={{71,28},{98,28},{98,92},{-88,92}},
            color={0,127,0},
            smooth=Smooth.None), Text(
            string="%second",
            index=1,
            extent={{5,2},{5,2}}));
        connect(fatO2.Tissue_O2Use, busConnector.fat_O2Use)     annotation (
            Line(
            points={{-35,-46},{6,-46},{6,92},{-88,92}},
            color={0,127,0},
            smooth=Smooth.None), Text(
            string="%second",
            index=1,
            extent={{5,2},{5,2}}));
        connect(GITractO2.Tissue_O2Use, busConnector.GITract_O2Use)
          annotation (Line(
            points={{71,-2},{98,-2},{98,92},{-88,92}},
            color={0,127,0},
            smooth=Smooth.None), Text(
            string="%second",
            index=1,
            extent={{5,2},{5,2}}));
        connect(kidneyO2.Tissue_O2Use, busConnector.kidney_O2Use)
          annotation (Line(
            points={{71,-32},{98,-32},{98,92},{-88,92}},
            color={0,127,0},
            smooth=Smooth.None), Text(
            string="%second",
            index=1,
            extent={{5,2},{5,2}}));
        connect(leftHeartO2.Tissue_O2Use, busConnector.leftHeart_O2Use)
          annotation (Line(
            points={{71,-62},{98,-62},{98,92},{-88,92}},
            color={0,127,0},
            smooth=Smooth.None), Text(
            string="%second",
            index=1,
            extent={{5,2},{5,2}}));
        connect(liverO2.Tissue_O2Use, busConnector.liver_O2Use)
          annotation (Line(
            points={{71,58},{98,58},{98,92},{-88,92}},
            color={0,127,0},
            smooth=Smooth.None), Text(
            string="%second",
            index=1,
            extent={{5,2},{5,2}}));
        connect(otherTissueO2.Tissue_O2Use, busConnector.otherTissue_O2Use)
          annotation (Line(
            points={{-35,14},{6,14},{6,92},{-88,92}},
            color={0,127,0},
            smooth=Smooth.None), Text(
            string="%second",
            index=1,
            extent={{5,2},{5,2}}));
        connect(respiratoryMuscleO2.Tissue_O2Use, busConnector.respiratoryMuscle_O2Use)
          annotation (Line(
            points={{-35,-16},{6,-16},{6,92},{-88,92}},
            color={0,127,0},
            smooth=Smooth.None), Text(
            string="%second",
            index=1,
            extent={{5,2},{5,2}}));
        connect(rightHeartO2.Tissue_O2Use, busConnector.rightHeart_O2Use)
          annotation (Line(
            points={{71,-92},{98,-92},{98,92},{-88,92}},
            color={0,127,0},
            smooth=Smooth.None), Text(
            string="%second",
            index=1,
            extent={{5,2},{5,2}}));
        connect(skinO2.Tissue_O2Use, busConnector.skin_O2Use)     annotation (
           Line(
            points={{-35,-76},{6,-76},{6,92},{-88,92}},
            color={0,127,0},
            smooth=Smooth.None), Text(
            string="%second",
            index=1,
            extent={{5,2},{5,2}}));
        connect(skeletalMuscleO2.Tissue_O2Use, busConnector.skeletalMuscle_O2Use)
          annotation (Line(
            points={{-35,72},{5.5,72},{5.5,92},{-88,92}},
            color={127,0,0},
            smooth=Smooth.None), Text(
            string="%second",
            index=1,
            extent={{5,2},{5,2}}));

        connect(boneO2.BloodFlow, busConnector.bone_BloodFlow)        annotation (
           Line(
            points={{-35,36},{6,36},{6,92},{-88,92}},
            color={0,127,0},
            smooth=Smooth.None), Text(
            string="%second",
            index=1,
            extent={{5,2},{5,2}}));
        connect(brainO2.BloodFlow, busConnector.brain_BloodFlow)
          annotation (Line(
            points={{71,20},{98,20},{98,92},{-88,92}},
            color={0,127,0},
            smooth=Smooth.None), Text(
            string="%second",
            index=1,
            extent={{5,2},{5,2}}));
        connect(fatO2.BloodFlow, busConnector.fat_BloodFlow)     annotation (
            Line(
            points={{-35,-54},{6,-54},{6,92},{-88,92}},
            color={0,127,0},
            smooth=Smooth.None), Text(
            string="%second",
            index=1,
            extent={{5,2},{5,2}}));
        connect(GITractO2.BloodFlow, busConnector.GITract_BloodFlow)
          annotation (Line(
            points={{71,-10},{98,-10},{98,92},{-88,92}},
            color={0,127,0},
            smooth=Smooth.None), Text(
            string="%second",
            index=1,
            extent={{5,2},{5,2}}));
        connect(kidneyO2.BloodFlow, busConnector.kidney_BloodFlow)
          annotation (Line(
            points={{71,-40},{98,-40},{98,92},{-88,92}},
            color={0,127,0},
            smooth=Smooth.None), Text(
            string="%second",
            index=1,
            extent={{5,2},{5,2}}));
        connect(leftHeartO2.BloodFlow, busConnector.leftHeart_BloodFlow)
          annotation (Line(
            points={{71,-70},{98,-70},{98,92},{-88,92}},
            color={0,127,0},
            smooth=Smooth.None), Text(
            string="%second",
            index=1,
            extent={{5,2},{5,2}}));
        connect(otherTissueO2.BloodFlow, busConnector.otherTissue_BloodFlow)
          annotation (Line(
            points={{-35,6},{6,6},{6,92},{-88,92}},
            color={0,127,0},
            smooth=Smooth.None), Text(
            string="%second",
            index=1,
            extent={{5,2},{5,2}}));
        connect(respiratoryMuscleO2.BloodFlow, busConnector.respiratoryMuscle_BloodFlow)
          annotation (Line(
            points={{-35,-24},{6,-24},{6,92},{-88,92}},
            color={0,127,0},
            smooth=Smooth.None), Text(
            string="%second",
            index=1,
            extent={{5,2},{5,2}}));
        connect(rightHeartO2.BloodFlow, busConnector.rightHeart_BloodFlow)
          annotation (Line(
            points={{71,-100},{98,-100},{98,92},{-88,92}},
            color={0,127,0},
            smooth=Smooth.None), Text(
            string="%second",
            index=1,
            extent={{5,2},{5,2}}));
        connect(skinO2.BloodFlow, busConnector.skin_BloodFlow)     annotation (
           Line(
            points={{-35,-84},{6,-84},{6,92},{-88,92}},
            color={0,127,0},
            smooth=Smooth.None), Text(
            string="%second",
            index=1,
            extent={{5,2},{5,2}}));
        connect(skeletalMuscleO2.BloodFlow, busConnector.skeletalMuscle_BloodFlow)
          annotation (Line(
            points={{-35,64},{5.5,64},{5.5,92},{-88,92}},
            color={127,0,0},
            smooth=Smooth.None), Text(
            string="%second",
            index=1,
            extent={{5,2},{5,2}}));

        connect(boneO2.T, busConnector.bone_T)       annotation (
           Line(
            points={{-35,40},{6,40},{6,92},{-88,92}},
            color={0,127,0},
            smooth=Smooth.None), Text(
            string="%second",
            index=1,
            extent={{5,2},{5,2}}));
        connect(brainO2.T, busConnector.brain_T)
          annotation (Line(
            points={{71,24},{98,24},{98,92},{-88,92}},
            color={0,127,0},
            smooth=Smooth.None), Text(
            string="%second",
            index=1,
            extent={{5,2},{5,2}}));
        connect(fatO2.T, busConnector.fat_T)     annotation (
            Line(
            points={{-35,-50},{6,-50},{6,92},{-88,92}},
            color={0,127,0},
            smooth=Smooth.None), Text(
            string="%second",
            index=1,
            extent={{5,2},{5,2}}));
        connect(GITractO2.T, busConnector.GITract_T)
          annotation (Line(
            points={{71,-6},{98,-6},{98,92},{-88,92}},
            color={0,127,0},
            smooth=Smooth.None), Text(
            string="%second",
            index=1,
            extent={{5,2},{5,2}}));
        connect(kidneyO2.T, busConnector.kidney_T)
          annotation (Line(
            points={{71,-36},{98,-36},{98,92},{-88,92}},
            color={0,127,0},
            smooth=Smooth.None), Text(
            string="%second",
            index=1,
            extent={{5,2},{5,2}}));
        connect(leftHeartO2.T, busConnector.leftHeart_T)
          annotation (Line(
            points={{71,-66},{98,-66},{98,92},{-88,92}},
            color={0,127,0},
            smooth=Smooth.None), Text(
            string="%second",
            index=1,
            extent={{5,2},{5,2}}));
        connect(liverO2.T, busConnector.liver_T)
          annotation (Line(
            points={{71,54},{98,54},{98,92},{-88,92}},
            color={0,127,0},
            smooth=Smooth.None), Text(
            string="%second",
            index=1,
            extent={{5,2},{5,2}}));
        connect(otherTissueO2.T, busConnector.otherTissue_T)
          annotation (Line(
            points={{-35,10},{6,10},{6,92},{-88,92}},
            color={0,127,0},
            smooth=Smooth.None), Text(
            string="%second",
            index=1,
            extent={{5,2},{5,2}}));
        connect(respiratoryMuscleO2.T, busConnector.respiratoryMuscle_T)
          annotation (Line(
            points={{-35,-20},{6,-20},{6,92},{-88,92}},
            color={0,127,0},
            smooth=Smooth.None), Text(
            string="%second",
            index=1,
            extent={{5,2},{5,2}}));
        connect(rightHeartO2.T, busConnector.rightHeart_T)
          annotation (Line(
            points={{71,-96},{98,-96},{98,92},{-88,92}},
            color={0,127,0},
            smooth=Smooth.None), Text(
            string="%second",
            index=1,
            extent={{5,2},{5,2}}));
        connect(skinO2.T, busConnector.skin_T)     annotation (
           Line(
            points={{-35,-80},{6,-80},{6,92},{-88,92}},
            color={0,127,0},
            smooth=Smooth.None), Text(
            string="%second",
            index=1,
            extent={{5,2},{5,2}}));
        connect(skeletalMuscleO2.T, busConnector.skeletalMuscle_T)
          annotation (Line(
            points={{-35,68},{5.5,68},{5.5,92},{-88,92}},
            color={127,0,0},
            smooth=Smooth.None), Text(
            string="%second",
            index=1,
            extent={{5,2},{5,2}}));

          connect(boneO2.sO2, busConnector.bone_sO2) annotation (
           Line(
            points={{-44,35},{6,35},{6,92},{-88,92}},
            color={0,127,0},
            smooth=Smooth.None));
        connect(brainO2.sO2, busConnector.brain_sO2)
          annotation (Line(
            points={{62,19},{98,19},{98,92},{-88,92}},
            color={0,127,0},
            smooth=Smooth.None));
        connect(fatO2.sO2, busConnector.fat_sO2) annotation (
            Line(
            points={{-44,-55},{6,-55},{6,92},{-88,92}},
            color={0,127,0},
            smooth=Smooth.None));
        connect(GITractO2.sO2, busConnector.GITract_sO2)
          annotation (Line(
            points={{62,-11},{98,-11},{98,92},{-88,92}},
            color={0,127,0},
            smooth=Smooth.None));
        connect(kidneyO2.sO2, busConnector.kidney_sO2)
          annotation (Line(
            points={{62,-41},{98,-41},{98,92},{-88,92}},
            color={0,127,0},
            smooth=Smooth.None));
        connect(leftHeartO2.sO2, busConnector.leftHeart_sO2)
          annotation (Line(
            points={{62,-71},{98,-71},{98,92},{-88,92}},
            color={0,127,0},
            smooth=Smooth.None));
        connect(liverO2.sO2, busConnector.liver_sO2)
          annotation (Line(
            points={{62,49},{98,49},{98,92},{-88,92}},
            color={0,127,0},
            smooth=Smooth.None));
        connect(otherTissueO2.sO2, busConnector.otherTissue_sO2)
          annotation (Line(
            points={{-44,5},{6,5},{6,92},{-88,92}},
            color={0,127,0},
            smooth=Smooth.None));
        connect(respiratoryMuscleO2.sO2, busConnector.respiratoryMuscle_sO2)
          annotation (Line(
            points={{-44,-25},{6,-25},{6,92},{-88,92}},
            color={0,127,0},
            smooth=Smooth.None));
        connect(rightHeartO2.sO2, busConnector.rightHeart_sO2)
          annotation (Line(
            points={{62,-101},{98,-101},{98,92},{-88,92}},
            color={0,127,0},
            smooth=Smooth.None));
        connect(skinO2.sO2, busConnector.skin_sO2) annotation (
           Line(
            points={{-44,-85},{6,-85},{6,92},{-88,92}},
            color={0,127,0},
            smooth=Smooth.None));
        connect(skeletalMuscleO2.sO2, busConnector.skeletalMuscle_sO2)
          annotation (Line(
            points={{-44,63},{5.5,63},{5.5,92},{-88,92}},
            color={127,0,0},
            smooth=Smooth.None));

        connect(boneO2.pO2, busConnector.bone.pO2) annotation (
           Line(
            points={{-46,35},{6,35},{6,92},{-88,92}},
            color={0,127,0},
            smooth=Smooth.None));
        connect(brainO2.pO2, busConnector.brain.pO2)
          annotation (Line(
            points={{60,19},{98,19},{98,92},{-88,92}},
            color={0,127,0},
            smooth=Smooth.None));
        connect(fatO2.pO2, busConnector.fat.pO2) annotation (
            Line(
            points={{-46,-55},{6,-55},{6,92},{-88,92}},
            color={0,127,0},
            smooth=Smooth.None));
        connect(GITractO2.pO2, busConnector.GITract.pO2)
          annotation (Line(
            points={{60,-11},{98,-11},{98,92},{-88,92}},
            color={0,127,0},
            smooth=Smooth.None));
        connect(kidneyO2.pO2, busConnector.Kidney_PO2)
          annotation (Line(
            points={{60,-41},{98,-41},{98,92},{-88,92}},
            color={0,127,0},
            smooth=Smooth.None));
        connect(leftHeartO2.pO2, busConnector.LeftHeart_PO2)
          annotation (Line(
            points={{60,-71},{98,-71},{98,92},{-88,92}},
            color={0,127,0},
            smooth=Smooth.None));
        connect(liverO2.pO2, busConnector.Liver_PO2)
          annotation (Line(
            points={{60,49},{98,49},{98,92},{-88,92}},
            color={0,127,0},
            smooth=Smooth.None));
        connect(otherTissueO2.pO2, busConnector.otherTissue.pO2)
          annotation (Line(
            points={{-46,5},{6,5},{6,92},{-88,92}},
            color={0,127,0},
            smooth=Smooth.None));
        connect(respiratoryMuscleO2.pO2, busConnector.respiratoryMuscle.pO2)
          annotation (Line(
            points={{-46,-25},{6,-25},{6,92},{-88,92}},
            color={0,127,0},
            smooth=Smooth.None));
        connect(rightHeartO2.pO2, busConnector.RightHeart_PO2)
          annotation (Line(
            points={{60,-101},{98,-101},{98,92},{-88,92}},
            color={0,127,0},
            smooth=Smooth.None));
        connect(skinO2.pO2, busConnector.Skin_PO2) annotation (
           Line(
            points={{-46,-85},{6,-85},{6,92},{-88,92}},
            color={0,127,0},
            smooth=Smooth.None));
        connect(skeletalMuscleO2.pO2, busConnector.skeletalMuscle.pO2)
          annotation (Line(
            points={{-46,63},{5.5,63},{5.5,92},{-88,92}},
            color={127,0,0},
            smooth=Smooth.None));

        connect(kidneyO2.TubulePO2, busConnector.KidneyO2_TubulePO2) annotation (Line(
            points={{64,-41},{64,-46},{96,-46},{96,92},{-88,92}},
            color={0,0,127},
            smooth=Smooth.None), Text(
            string="%second",
            index=1,
            extent={{6,-3},{6,-3}}));
        connect(GITractO2.vein, q_out) annotation (Line(
            points={{52,2},{-24,2},{-24,0},{-100,0}},
            color={107,45,134},
            thickness=1,
            smooth=Smooth.None));
        connect(liverO2.BloodFlow, busConnector.HepaticArty_BloodFlow) annotation (
            Line(
            points={{71,50},{98,50},{98,92},{-88,92}},
            color={0,0,127},
            smooth=Smooth.None), Text(
            string="%second",
            index=1,
            extent={{6,3},{6,3}}));
        connect(liverO2.arty, q_in) annotation (Line(
            points={{72,62},{84,62},{84,0},{100,0}},
            color={107,45,134},
            thickness=1,
            smooth=Smooth.None));
        annotation (Icon(graphics={Rectangle(extent={{-120,100},{120,-100}},
                  lineColor={0,0,0})}));
      end TissuesO2;

      package Tissues
        model TissueO2Base

        Physiolibrary.Chemical.Interfaces.ChemicalPort_a arty annotation (
            Placement(transformation(extent={{-82,-6},{-62,14}}),
              iconTransformation(extent={{80,0},{120,40}})));
        Physiolibrary.Chemical.Interfaces.ChemicalPort_b vein annotation (
            Placement(transformation(extent={{62,-6},{82,14}}),
              iconTransformation(extent={{-120,0},{-80,40}})));

          parameter Physiolibrary.Types.AmountOfSubstance initialMass;
          Physiolibrary.Types.RealIO.ConcentrationInput ctHb
          "concentration of haemoglobin"                        annotation (Placement(transformation(extent={{72,-20},
                    {64,-12}}),           iconTransformation(extent={{-100,-30},{-80,-10}})));
          Physiolibrary.Types.RealIO.ConcentrationInput cDPG
          "outgoing concentration of DPG" annotation (Placement(transformation(extent={{62,-16},
                    {54,-8}}),            iconTransformation(extent={{-100,90},{-80,110}})));
          Physiolibrary.Types.RealIO.VolumeFlowRateInput BloodFlow
          "blood flow through tissue"      annotation (Placement(transformation(extent={{-50,-4},
                    {-42,4}}),            iconTransformation(extent={{-10,-10},{10,10}},
                rotation=180,
                origin={90,-100})));

          Physiolibrary.Types.RealIO.TemperatureInput T "outgoing temperature"
                                                                 annotation (Placement(transformation(extent={{-38,-12},
                    {-30,-4}}),           iconTransformation(extent={{-10,-10},{10,10}},
                rotation=180,
                origin={90,-60})));
          Physiolibrary.Types.RealIO.PressureInput pCO
          "outgoing partial pressure of CO"
                                           annotation (Placement(transformation(extent={{38,-4},
                    {30,4}}),             iconTransformation(
                extent={{-10,-10},{10,10}},
                origin={-90,60})));
          Physiolibrary.Types.RealIO.FractionInput FHbF
          "Foetal haemoglobin fraction"    annotation (Placement(transformation(extent={{46,-8},
                    {38,0}}),             iconTransformation(
                extent={{-10,-10},{10,10}},
                origin={-90,-60})));
          Physiolibrary.Types.RealIO.FractionInput FMetHb
          "methaemoglobin fraction"                             annotation (Placement(transformation(extent={{56,-12},
                    {48,-4}}),            iconTransformation(extent={{-10,-10},{10,10}},
                rotation=180,
                origin={90,60})));

          Physiolibrary.Types.RealIO.MolarFlowRateInput
                                               Tissue_O2Use
                                           annotation (Placement(transformation(extent={{-82,-64},
                    {-74,-56}}),          iconTransformation(
                extent={{-10,-10},{10,10}},
                rotation=180,
                origin={90,-20})));
          Physiolibrary.Types.RealIO.pHInput pH_plasma
          "outgoing veins pH of plasma"                          annotation (Placement(transformation(extent={{-60,-20},
                    {-52,-12}}),          iconTransformation(extent={{-10,-10},{10,10}},
                rotation=180,
                origin={90,100})));
          BloodO2_Siggaard O2Tissue
            annotation (Placement(transformation(extent={{-18,4},{2,-16}})));
        Physiolibrary.Chemical.Sources.UnlimitedSolutePumpOut
                                                      Metabolism_O2Use(
              useSoluteFlowInput=true) annotation (Placement(transformation(
              extent={{-10,10},{10,-10}},
              rotation=270,
              origin={-8,-84})));
          Physiolibrary.Types.RealIO.FractionOutput sO2
                                                   annotation (Placement(
                transformation(extent={{8,14},{14,20}}),     iconTransformation(
                  extent={{-10,-10},{10,10}},
                rotation=270,
                origin={0,-110})));
          Physiolibrary.Types.RealIO.PressureInput pCO2
          "outgoing veins CO2 partial pressure"                  annotation (Placement(transformation(extent={{-46,-16},
                    {-38,-8}}),           iconTransformation(extent={{-10,-10},{10,10}},
                origin={-90,-100})));
          Physiolibrary.Types.RealIO.PressureOutput pO2       annotation (Placement(
                transformation(extent={{10,8},{18,16}}),     iconTransformation(
                  extent={{-10,-10},{10,10}},
                rotation=270,
                origin={-20,-110})));

        //  Real O2Use_ml_per_min;
        // Real O2Use_mmol_per_min;
        equation
        //  O2Use_mmol_per_min = fromMLtoMMOL.q_MMOL.q;
        //  O2Use_ml_per_min = -fromMLtoMMOL.q_ML.q;

          connect(O2Tissue.sO2, sO2)          annotation (Line(
              points={{-8,6},{-8,17},{11,17}},
              color={0,0,127},
              smooth=Smooth.None));
          connect(pH_plasma, O2Tissue.pH)
                                   annotation (Line(
              points={{-56,-16},{-17,-16}},
              color={0,0,127},
              smooth=Smooth.None));
          connect(T, O2Tissue.T) annotation (Line(
              points={{-34,-8},{-17,-8}},
              color={0,0,127},
              smooth=Smooth.None));
          connect(O2Tissue.pCO2, pCO2) annotation (Line(
              points={{-17,-12},{-42,-12}},
              color={0,0,127},
              smooth=Smooth.None));
          connect(BloodFlow, O2Tissue.BloodFlow) annotation (Line(
              points={{-46,0},{-32,0},{-32,-2.6},{-18,-2.6}},
              color={0,0,127},
              smooth=Smooth.None));
          connect(O2Tissue.ctHb, ctHb) annotation (Line(
              points={{1,-16},{68,-16}},
              color={0,0,127},
              smooth=Smooth.None));
          connect(O2Tissue.cDPG, cDPG) annotation (Line(
              points={{1,-12},{58,-12}},
              color={0,0,127},
              smooth=Smooth.None));
          connect(FMetHb, O2Tissue.FMetHb) annotation (Line(
              points={{52,-8},{1,-8}},
              color={0,0,127},
              smooth=Smooth.None));
          connect(FHbF, O2Tissue.FHbF) annotation (Line(
              points={{42,-4},{1,-4}},
              color={0,0,127},
              smooth=Smooth.None));
          connect(O2Tissue.pCO, pCO) annotation (Line(
              points={{1,0},{34,0}},
              color={0,0,127},
              smooth=Smooth.None));
          connect(arty, O2Tissue.q_in) annotation (Line(
              points={{-72,4},{-44,4},{-44,3},{-17,3}},
              color={200,0,0},
              thickness=1,
              smooth=Smooth.None));
          connect(O2Tissue.q_out, vein) annotation (Line(
              points={{1,3},{36,3},{36,4},{72,4}},
              color={200,0,0},
              thickness=1,
              smooth=Smooth.None));
          connect(O2Tissue.pO2, pO2) annotation (Line(
              points={{-4,6},{-4,12},{14,12}},
              color={0,0,127},
              smooth=Smooth.None));
        connect(Tissue_O2Use, Metabolism_O2Use.soluteFlow) annotation (Line(
            points={{-78,-60},{-46,-60},{-46,-88},{-12,-88}},
            color={0,0,127},
            smooth=Smooth.None));
          annotation ( Icon(coordinateSystem(
                  preserveAspectRatio=true, extent={{-100,-100},{100,100}}),
                graphics={
                Text(
                  extent={{-80,-80},{80,-100}},
                  lineColor={127,0,0},
                  fillPattern=FillPattern.Solid,
                  textString="(init %initialMass mEq)"),
                Text(
                  extent={{28,94},{76,34}},
                  lineColor={0,0,0},
                  textString="O"),
                Text(
                  extent={{62,34},{82,62}},
                  lineColor={0,0,0},
                  textString="2"),
                Rectangle(extent={{-100,100},{100,-100}}, lineColor={0,0,0})}));
        end TissueO2Base;

        model TissueO2_kidney
          extends Physiolibrary.Icons.Kidney;
          extends TissueO2Base;

                                   /*(cO2Hb(start=7.39))*/
        Physiolibrary.Types.Constants.DiffusionPermeabilityConst O2PermBasic(k(
              displayUnit="l/min") = 0.00045)
          "see Resources/Data/erythropiesis ;  older notes:  0.9 ml_STP/(min.mmHg) = ? mol/(s.Pa), alphaO2=1.005e-5 mol/(m3.Pa)   Before: (3.929e-5)/60/0.00133989"
          annotation (Placement(transformation(extent={{46,-42},{60,-28}})));
        Physiolibrary.Blocks.Factors.Spline HgbOnPerm(data={{0.00,0.4,0},{0.15,
              1.0,8.0},{0.25,2.0,0}}, Xscale=9.3/0.15)
          "\"recalculated [Hb] in mmol = 56*[Hb] in ml\""
          annotation (Placement(transformation(extent={{74,-58},{54,-38}})));
          Physiolibrary.Types.RealIO.PressureOutput      TubulePO2
          "oxygen partial pressure KidneyO2_TubulePO2"   annotation (Placement(
                transformation(extent={{60,-90},{68,-82}}), iconTransformation(
                extent={{-10,-10},{10,10}},
                rotation=270,
                origin={20,-110})));
         // Real O2Use_ml_per_min;
         // Real O2Use_mmol_per_min;
          Modelica.Blocks.Math.Gain oxygenSolubility(k=1/1.005e-5)
            annotation (Placement(transformation(extent={{26,-96},{46,-76}})));
          Physiolibrary.Chemical.Components.Diffusion diffusion(useConductanceInput=true)
            annotation (Placement(transformation(
                extent={{-10,-10},{10,10}},
                rotation=270,
                origin={-8,-58})));
          Physiolibrary.Chemical.Sensors.ConcentrationMeasure concentrationMeasure
            annotation (Placement(transformation(extent={{-4,-84},{16,-64}})));
        equation
         // O2Use_mmol_per_min = fromMLtoMMOL.q_MMOL.q;
         // O2Use_ml_per_min = -fromMLtoMMOL.q_ML.q;

          connect(O2PermBasic.y, HgbOnPerm.yBase) annotation (Line(
              points={{61.75,-35},{64,-35},{64,-46}},
              color={0,0,127},
              smooth=Smooth.None));
          connect(diffusion.conductance, HgbOnPerm.y) annotation (Line(
              points={{-4,-58},{64,-58},{64,-52}},
              color={0,0,127},
              smooth=Smooth.None));
          connect(diffusion.q_out, concentrationMeasure.q_in) annotation (Line(
              points={{-8,-68},{-8,-76},{6,-76}},
              color={107,45,134},
              thickness=1,
              smooth=Smooth.None));
          connect(TubulePO2, oxygenSolubility.y) annotation (Line(
              points={{64,-86},{47,-86}},
              color={0,0,127},
              smooth=Smooth.None));
          connect(concentrationMeasure.concentration, oxygenSolubility.u) annotation (
              Line(
              points={{6,-70},{16,-70},{16,-86},{24,-86}},
              color={0,0,127},
              smooth=Smooth.None));
        connect(O2Tissue.alveolar, diffusion.q_in) annotation (Line(
            points={{-8.4,-14.2},{-8.4,-31.1},{-8,-31.1},{-8,-48}},
            color={107,45,134},
            thickness=1,
            smooth=Smooth.None));
        connect(O2Tissue.ceHb_, HgbOnPerm.u) annotation (Line(
            points={{-12,6},{-12,32},{92,32},{92,-48},{72,-48}},
            color={0,0,127},
            smooth=Smooth.None));
        connect(diffusion.q_out, Metabolism_O2Use.q_in) annotation (Line(
            points={{-8,-68},{-8,-74}},
            color={107,45,134},
            thickness=1,
            smooth=Smooth.None));
          annotation ( Icon(coordinateSystem(
                  preserveAspectRatio=true, extent={{-100,-100},{100,100}}),
                graphics={
                Text(
                  extent={{-80,-78},{80,-100}},
                  lineColor={127,0,0},
                  fillPattern=FillPattern.Solid,
                  textString="(init %initialMass mEq)"),
                Text(
                  extent={{28,94},{76,34}},
                  lineColor={0,0,0},
                  textString="O"),
                Text(
                  extent={{62,34},{82,62}},
                  lineColor={0,0,0},
                  textString="2"),
                Rectangle(extent={{-100,100},{100,-100}}, lineColor={0,0,0})}));
        end TissueO2_kidney;

        model TissueO2
          extends TissueO2Base;
        equation
        connect(O2Tissue.alveolar, Metabolism_O2Use.q_in) annotation (Line(
            points={{-8.4,-14.2},{-8.4,-44.1},{-8,-44.1},{-8,-74}},
            color={107,45,134},
            thickness=1,
            smooth=Smooth.None));
        end TissueO2;

        model SkeletalMuscleO2
          extends Physiomodel.Gases.O2.Tissues.TissueO2(arty(q(start=5.048)));
          extends Physiolibrary.Icons.SkeletalMuscle;
        end SkeletalMuscleO2;

        model BoneO2
          extends Physiomodel.Gases.O2.Tissues.TissueO2;
          extends Physiolibrary.Icons.Bone;
        end BoneO2;

        model OtherTissueO2
          extends Physiomodel.Gases.O2.Tissues.TissueO2;
          extends Physiolibrary.Icons.OtherTissue;
        end OtherTissueO2;

        model RespiratoryMuscleO2
          extends Physiomodel.Gases.O2.Tissues.TissueO2;
          extends Physiolibrary.Icons.RespiratoryMuscle;
        end RespiratoryMuscleO2;

        model FatO2
          extends Physiomodel.Gases.O2.Tissues.TissueO2;
          extends Physiolibrary.Icons.Fat;
        end FatO2;

        model SkinO2
          extends TissueO2;
          extends Physiolibrary.Icons.Skin;
        end SkinO2;

        model BrainO2
          extends TissueO2;
          extends Physiolibrary.Icons.Brain;
        end BrainO2;

        model GITractO2
          extends TissueO2;
          extends Physiolibrary.Icons.GITract;
        end GITractO2;

        model LeftHeartO2
          extends TissueO2;
          extends Physiolibrary.Icons.LeftHeart;
        end LeftHeartO2;

        model RightHeartO2
          extends TissueO2;
          extends Physiolibrary.Icons.RightHeart;
        end RightHeartO2;

        model LiverO2
          extends TissueO2;
          extends Physiolibrary.Icons.Liver;
        end LiverO2;
      end Tissues;

      package IO_Bus
      extends Physiolibrary.Types.IO_Bus;
        redeclare model extends Variables

        T.Pressure Bone_PO2(varName="Bone-Flow.PO2")
          "Partial oxygen pressure in bone blood venules."
        annotation (Placement(transformation(extent={{-64,-120},{-58,-114}})));
        T.Pressure Brain_PO2(varName="Brain-Flow.PO2")
          "Partial oxygen pressure in brain blood venules."
        annotation (Placement(transformation(extent={{-64,-90},{-58,-84}})));
        T.Pressure Fat_PO2(varName="Fat-Flow.PO2")
          "Partial oxygen pressure in fat blood venules."
        annotation (Placement(transformation(extent={{-64,-40},{-58,-34}})));
        T.Pressure GITract_PO2(varName="GITract-Flow.PO2")
          "Partial oxygen pressure in gITract blood venules."
        annotation (Placement(transformation(extent={{-64,-20},{-58,-14}})));
        T.Pressure KidneyO2_TubulePO2(varName="Kidney-O2.TubulePO2")
          "Kidney tubule partial O2 pressure. "
        annotation (Placement(transformation(extent={{-84,-4},{-78,2}})));
        T.Pressure Kidney_PO2(varName="Kidney-O2.VeinPO2")
          "Kidney vein partial O2 pressure."
        annotation (Placement(transformation(extent={{-64,10},{-58,16}})));
        T.Pressure LeftHeart_PO2(varName="LeftHeart-Flow.PO2")
          "Partial oxygen pressure in leftHeart blood venules."
        annotation (Placement(transformation(extent={{-64,30},{-58,36}})));
        T.Pressure Liver_PO2(varName="Liver-O2.PO2")
          "Partial oxygen pressure in hepatic vein."
        annotation (Placement(transformation(extent={{-64,50},{-58,56}})));
        T.Pressure OtherTissue_PO2(varName="OtherTissue-Flow.PO2")
          "Partial oxygen pressure in otherTissue blood venules."
        annotation (Placement(transformation(extent={{-64,70},{-58,76}})));
        T.Pressure RespiratoryMuscle_PO2(varName="RespiratoryMuscle-Flow.PO2")
          "Partial oxygen pressure in respiratoryMuscle blood venules."
        annotation (Placement(transformation(extent={{-64,90},{-58,96}})));
        T.Pressure RightHeart_PO2(varName="RightHeart-Flow.PO2")
          "Partial oxygen pressure in rightHeart blood venules."
        annotation (Placement(transformation(extent={{-64,110},{-58,116}})));
        T.Pressure SkeletalMuscle_PO2(varName="SkeletalMuscle-Flow.PO2")
          "Partial oxygen pressure in skeletalMuscle blood venules."
        annotation (Placement(transformation(extent={{-64,140},{-58,146}})));
        T.Pressure Skin_PO2(varName="Skin-Flow.PO2")
          "Partial oxygen pressure in skin blood venules."
        annotation (Placement(transformation(extent={{-64,160},{-58,166}})));
        T.Pressure O2Artys_PO2(varName="PO2Artys.Pressure")
          "Partial oxygen pressure in systemic arteries."
        annotation (Placement(transformation(extent={{-62,-148},{-56,-142}})));
        T.Fraction bone_sO2(varName="bone_sO2")
        annotation (Placement(transformation(extent={{356,86},{362,92}})));
        T.Fraction brain_sO2(varName="brain_sO2")
        annotation (Placement(transformation(extent={{356,170},{362,176}})));
        T.Fraction fat_sO2(varName="fat_sO2")
        annotation (Placement(transformation(extent={{132,192},{138,198}})));
        T.Fraction GITract_sO2(varName="GITract_sO2")
        annotation (Placement(transformation(extent={{114,-332},{120,-326}})));
        T.Fraction kidney_sO2(varName="kidney_sO2")
        annotation (Placement(transformation(extent={{114,-252},{120,-246}})));
        T.Fraction leftHeart_sO2(varName="leftHeart_sO2")
        annotation (Placement(transformation(extent={{114,-182},{120,-176}})));
        T.Fraction liver_sO2(varName="liver_sO2")
        annotation (Placement(transformation(extent={{114,-122},{120,-116}})));
        T.Fraction O2Artys_sO2(varName="O2Artys_sO2")
        annotation (Placement(transformation(extent={{114,-102},{120,-96}})));
        T.Fraction O2Lung_sO2(varName="O2Lung_sO2")
        annotation (Placement(transformation(extent={{114,-92},{120,-86}})));
        T.Fraction O2Veins_sO2(varName="O2Veins_sO2")
        annotation (Placement(transformation(extent={{114,-82},{120,-76}})));
        T.Fraction otherTissue_sO2(varName="otherTissue_sO2")
        annotation (Placement(transformation(extent={{114,-22},{120,-16}})));
        T.Fraction respiratoryMuscle_sO2(varName="respiratoryMuscle_sO2")
        annotation (Placement(transformation(extent={{114,68},{120,74}})));
        T.Fraction rightHeart_sO2(varName="rightHeart_sO2")
        annotation (Placement(transformation(extent={{114,148},{120,154}})));
        T.Fraction skeletalMuscle_sO2(varName="skeletalMuscle_sO2")
        annotation (Placement(transformation(extent={{114,218},{120,224}})));
        T.Fraction skin_sO2(varName="skin_sO2")
        annotation (Placement(transformation(extent={{114,288},{120,294}})));
        equation

        connect(Bone_PO2.y, busConnector.bone.pO2) annotation (Line(
         points={{-57.7,-117},{90,-117},{90,-2}},
              color={0,0,127},
              smooth=Smooth.None), Text(
              string="%second",
              index=1,
              extent={{6,3},{6,3}}));
        connect(Brain_PO2.y, busConnector.brain.pO2) annotation (Line(
         points={{-57.7,-87},{90,-87},{90,-2}},
              color={0,0,127},
              smooth=Smooth.None), Text(
              string="%second",
              index=1,
              extent={{6,3},{6,3}}));
        connect(Fat_PO2.y, busConnector.fat.pO2) annotation (Line(
         points={{-57.7,-37},{90,-37},{90,-2}},
              color={0,0,127},
              smooth=Smooth.None), Text(
              string="%second",
              index=1,
              extent={{6,3},{6,3}}));
        connect(GITract_PO2.y, busConnector.GITract.pO2) annotation (Line(
         points={{-57.7,-17},{90,-17},{90,-2}},
              color={0,0,127},
              smooth=Smooth.None), Text(
              string="%second",
              index=1,
              extent={{6,3},{6,3}}));
        connect(Kidney_PO2.y, busConnector.Kidney_PO2) annotation (Line(
         points={{-57.7,13},{90,13},{90,-2}},
              color={0,0,127},
              smooth=Smooth.None), Text(
              string="%second",
              index=1,
              extent={{6,3},{6,3}}));
        connect(LeftHeart_PO2.y, busConnector.LeftHeart_PO2) annotation (Line(
         points={{-57.7,33},{90,33},{90,-2}},
              color={0,0,127},
              smooth=Smooth.None), Text(
              string="%second",
              index=1,
              extent={{6,3},{6,3}}));
        connect(Liver_PO2.y, busConnector.Liver_PO2) annotation (Line(
         points={{-57.7,53},{90,53},{90,-2}},
              color={0,0,127},
              smooth=Smooth.None), Text(
              string="%second",
              index=1,
              extent={{6,3},{6,3}}));
        connect(OtherTissue_PO2.y, busConnector.otherTissue.pO2) annotation (Line(
         points={{-57.7,73},{90,73},{90,-2}},
              color={0,0,127},
              smooth=Smooth.None), Text(
              string="%second",
              index=1,
              extent={{6,3},{6,3}}));
        connect(RespiratoryMuscle_PO2.y, busConnector.respiratoryMuscle.pO2) annotation (Line(
         points={{-57.7,93},{90,93},{90,-2}},
              color={0,0,127},
              smooth=Smooth.None), Text(
              string="%second",
              index=1,
              extent={{6,3},{6,3}}));
        connect(RightHeart_PO2.y, busConnector.RightHeart_PO2) annotation (Line(
         points={{-57.7,113},{90,113},{90,-2}},
              color={0,0,127},
              smooth=Smooth.None), Text(
              string="%second",
              index=1,
              extent={{6,3},{6,3}}));
        connect(SkeletalMuscle_PO2.y, busConnector.skeletalMuscle.pO2) annotation (Line(
         points={{-57.7,143},{90,143},{90,-2}},
              color={0,0,127},
              smooth=Smooth.None), Text(
              string="%second",
              index=1,
              extent={{6,3},{6,3}}));
        connect(Skin_PO2.y, busConnector.Skin_PO2) annotation (Line(
         points={{-57.7,163},{90,163},{90,-2}},
              color={0,0,127},
              smooth=Smooth.None), Text(
              string="%second",
              index=1,
              extent={{6,3},{6,3}}));
          connect(O2Artys_PO2.y, busConnector.O2Artys_PO2) annotation (Line(
              points={{-55.7,-145},{60,-145},{60,-2},{90,-2}},
              color={0,0,127},
              smooth=Smooth.None), Text(
              string="%second",
              index=1,
              extent={{6,3},{6,3}}));
        connect(bone_sO2.y, busConnector.bone_sO2) annotation (Line(
         points={{362.3,89},{90,89},{90,-2}},
              color={0,0,127},
              smooth=Smooth.None), Text(
              string="%second",
              index=1,
              extent={{6,3},{6,3}}));
        connect(brain_sO2.y, busConnector.brain_sO2) annotation (Line(
         points={{362.3,173},{90,173},{90,-2}},
              color={0,0,127},
              smooth=Smooth.None), Text(
              string="%second",
              index=1,
              extent={{6,3},{6,3}}));
        connect(fat_sO2.y, busConnector.fat_sO2) annotation (Line(
         points={{138.3,195},{90,195},{90,-2}},
              color={0,0,127},
              smooth=Smooth.None), Text(
              string="%second",
              index=1,
              extent={{6,3},{6,3}}));
        connect(GITract_sO2.y, busConnector.GITract_sO2) annotation (Line(
         points={{120.3,-329},{90,-329},{90,-2}},
              color={0,0,127},
              smooth=Smooth.None), Text(
              string="%second",
              index=1,
              extent={{6,3},{6,3}}));
        connect(kidney_sO2.y, busConnector.kidney_sO2) annotation (Line(
         points={{120.3,-249},{90,-249},{90,-2}},
              color={0,0,127},
              smooth=Smooth.None), Text(
              string="%second",
              index=1,
              extent={{6,3},{6,3}}));
        connect(leftHeart_sO2.y, busConnector.leftHeart_sO2) annotation (Line(
         points={{120.3,-179},{90,-179},{90,-2}},
              color={0,0,127},
              smooth=Smooth.None), Text(
              string="%second",
              index=1,
              extent={{6,3},{6,3}}));
        connect(liver_sO2.y, busConnector.liver_sO2) annotation (Line(
         points={{120.3,-119},{90,-119},{90,-2}},
              color={0,0,127},
              smooth=Smooth.None), Text(
              string="%second",
              index=1,
              extent={{6,3},{6,3}}));
        connect(O2Artys_sO2.y, busConnector.O2Artys_sO2) annotation (Line(
         points={{120.3,-99},{90,-99},{90,-2}},
              color={0,0,127},
              smooth=Smooth.None), Text(
              string="%second",
              index=1,
              extent={{6,3},{6,3}}));
        connect(O2Veins_sO2.y, busConnector.O2Veins_sO2) annotation (Line(
         points={{120.3,-79},{90,-79},{90,-2}},
              color={0,0,127},
              smooth=Smooth.None), Text(
              string="%second",
              index=1,
              extent={{6,3},{6,3}}));
        connect(otherTissue_sO2.y, busConnector.otherTissue_sO2) annotation (Line(
         points={{120.3,-19},{90,-19},{90,-2}},
              color={0,0,127},
              smooth=Smooth.None), Text(
              string="%second",
              index=1,
              extent={{6,3},{6,3}}));
        connect(respiratoryMuscle_sO2.y, busConnector.respiratoryMuscle_sO2) annotation (Line(
         points={{120.3,71},{90,71},{90,-2}},
              color={0,0,127},
              smooth=Smooth.None), Text(
              string="%second",
              index=1,
              extent={{6,3},{6,3}}));
        connect(rightHeart_sO2.y, busConnector.rightHeart_sO2) annotation (Line(
         points={{120.3,151},{90,151},{90,-2}},
              color={0,0,127},
              smooth=Smooth.None), Text(
              string="%second",
              index=1,
              extent={{6,3},{6,3}}));
        connect(skeletalMuscle_sO2.y, busConnector.skeletalMuscle_sO2) annotation (Line(
         points={{120.3,221},{90,221},{90,-2}},
              color={0,0,127},
              smooth=Smooth.None), Text(
              string="%second",
              index=1,
              extent={{6,3},{6,3}}));
        connect(skin_sO2.y, busConnector.skin_sO2) annotation (Line(
         points={{120.3,291},{90,291},{90,-2}},
              color={0,0,127},
              smooth=Smooth.None), Text(
              string="%second",
              index=1,
              extent={{6,3},{6,3}}));
        connect(O2Lung_sO2.y, busConnector.O2Lung_sO2) annotation (Line(
         points={{120.3,-89},{90,-89},{90,-2}},
              color={0,0,127},
              smooth=Smooth.None), Text(
              string="%second",
              index=1,
              extent={{6,3},{6,3}}));
        connect(KidneyO2_TubulePO2.y, busConnector.KidneyO2_TubulePO2)
          annotation (Line(
            points={{-77.7,-1},{90,-1},{90,-2}},
            color={0,0,127},
            smooth=Smooth.None), Text(
            string="%second",
            index=1,
            extent={{6,3},{6,3}}));
        end Variables;

        model Oxygen_test_SI
          import Physiomodel;

          import Modelica.Utilities.*;
         // constant String OUTPUT_FILE = "setup/output_startValues.txt"; //"setup/output.txt"; //"setup/v2.txt";

        Physiomodel.CardioVascular.IO_Bus.InputFromFile_SI cardioVascularSystem
            annotation (Placement(transformation(extent={{40,72},{60,94}})));
          Physiomodel.Metabolism.IO_Bus.InputFromFile_SI
                                                  nutrientsAndMetabolism
            annotation (Placement(transformation(extent={{-86,60},{-66,80}})));
          Physiomodel.Electrolytes.IO_Bus.InputFromFile_SI electrolytes
            annotation (Placement(transformation(extent={{74,-34},{94,-14}})));
          Physiomodel.Hormones.IO_Bus.InputFromFile_SI hormones
            annotation (Placement(transformation(extent={{40,6},{60,26}})));
          Physiomodel.Nerves.IO_Bus.InputFromFile_SI nerves
            annotation (Placement(transformation(extent={{74,38},{94,58}})));
          Physiomodel.Setup.IO_Bus.InputFromFile_SI     setup
            annotation (Placement(transformation(extent={{-16,-106},{4,-86}})));
          Physiomodel.Water.IO_Bus.InputFromFile_SI water
            annotation (Placement(transformation(extent={{-86,-6},{-66,14}})));
          Physiomodel.Proteins.IO_Bus.InputFromFile_SI proteins
            annotation (Placement(transformation(extent={{-48,-28},{-28,-8}})));
          Physiomodel.Status.IO_Bus.InputFromFile_SI status
            annotation (Placement(transformation(extent={{42,-80},{62,-60}})));
          Physiomodel.Heat.IO_Bus.InputFromFile_SI heat
            annotation (Placement(transformation(extent={{-28,30},{-48,50}})));
        Physiomodel.Gases.Ventilation.IO_Bus.InputFromFile_SI ventilation_const
          annotation (Placement(transformation(extent={{-36,-76},{-16,-56}})));
          Physiomodel.Gases.CO2.IO_Bus.InputFromFile_SI cO2_variables
            annotation (Placement(transformation(extent={{-88,-48},{-68,-28}})));
          Physiomodel.Gases.O2.O2 o2_1
            annotation (Placement(transformation(extent={{-94,-90},{-74,-70}})));
        equation
          connect(setup.busConnector,hormones. busConnector) annotation (Line(
              points={{-6,-96},{-6,16},{50,16}},
              color={0,0,255},
              thickness=0.5,
              smooth=Smooth.None));
          connect(setup.busConnector,proteins. busConnector) annotation (Line(
              points={{-6,-96},{-6,-18},{-38,-18}},
              color={0,0,255},
              thickness=0.5,
              smooth=Smooth.None));
          connect(setup.busConnector,cardioVascularSystem. busConnector)
                                                        annotation (Line(
              points={{-6,-96},{-6,83},{50,83}},
              color={0,0,255},
              thickness=0.5,
              smooth=Smooth.None));
          connect(setup.busConnector,nutrientsAndMetabolism. busConnector)
            annotation (Line(
              points={{-6,-96},{-6,70},{-76,70}},
              color={0,0,255},
              thickness=0.5,
              smooth=Smooth.None));
          connect(setup.busConnector,water. busConnector) annotation (Line(
              points={{-6,-96},{-6,4},{-76,4}},
              color={0,0,255},
              thickness=0.5,
              smooth=Smooth.None));
          connect(setup.busConnector,nerves. busConnector) annotation (Line(
              points={{-6,-96},{-6,48},{84,48}},
              color={0,0,255},
              thickness=0.5,
              smooth=Smooth.None));
          connect(status.busConnector,setup. busConnector)         annotation (Line(
              points={{52,-70},{-6,-70},{-6,-96}},
              color={0,0,255},
              thickness=0.5,
              smooth=Smooth.None));
          connect(electrolytes.busConnector,setup. busConnector) annotation (Line(
              points={{84,-24},{-6,-24},{-6,-96}},
              color={0,0,255},
              thickness=0.5,
              smooth=Smooth.None));
          connect(heat.busConnector,setup. busConnector) annotation (Line(
              points={{-38,40},{-6,40},{-6,-96}},
              color={0,0,255},
              thickness=0.5,
              smooth=Smooth.None));
        //if terminal() then

        /*   Streams.print("cardioVascularSystem.busConnector.Bone_PCO2\n"+String(cardioVascularSystem.busConnector.Bone_PCO2),OUTPUT_FILE);

Streams.print("cardioVascularSystem.busConnector.Brain_PCO2\n"+String(cardioVascularSystem.busConnector.Brain_PCO2),OUTPUT_FILE);
Streams.print("cardioVascularSystem.busConnector.Fat_PCO2\n"+String(cardioVascularSystem.busConnector.Fat_PCO2),OUTPUT_FILE);
Streams.print("cardioVascularSystem.busConnector.GITract_PCO2\n"+String(cardioVascularSystem.busConnector.GITract_PCO2),OUTPUT_FILE);
Streams.print("cardioVascularSystem.busConnector.Kidney_PCO2\n"+String(cardioVascularSystem.busConnector.Kidney_PCO2),OUTPUT_FILE);
Streams.print("cardioVascularSystem.busConnector.LeftHeart_PCO2\n"+String(cardioVascularSystem.busConnector.LeftHeart_PCO2),OUTPUT_FILE);
Streams.print("cardioVascularSystem.busConnector.Liver_PCO2\n"+String(cardioVascularSystem.busConnector.Liver_PCO2),OUTPUT_FILE);
Streams.print("cardioVascularSystem.busConnector.OtherTissue_PCO2\n"+String(cardioVascularSystem.busConnector.OtherTissue_PCO2),OUTPUT_FILE);
Streams.print("cardioVascularSystem.busConnector.RespiratoryMuscle_PCO2\n"+String(cardioVascularSystem.busConnector.RespiratoryMuscle_PCO2),OUTPUT_FILE);
Streams.print("cardioVascularSystem.busConnector.RightHeart_PCO2\n"+String(cardioVascularSystem.busConnector.RightHeart_PCO2),OUTPUT_FILE);
Streams.print("cardioVascularSystem.busConnector.SkeletalMuscle_PCO2\n"+String(cardioVascularSystem.busConnector.SkeletalMuscle_PCO2),OUTPUT_FILE);
Streams.print("cardioVascularSystem.busConnector.Skin_PCO2\n"+String(cardioVascularSystem.busConnector.Skin_PCO2),OUTPUT_FILE);
Streams.print("cardioVascularSystem.busConnector.Urine_pH\n"+String(cardioVascularSystem.busConnector.Urine_pH),OUTPUT_FILE);

Streams.print("gases.carbonDioxyd.alveolarVentilation.solventFlowPump.q_out.conc|"+String(gases.carbonDioxyd.alveolarVentilation.solventFlowPump.q_out.conc),OUTPUT_FILE);
Streams.print("gases.carbonDioxyd.artysCO2.pCO2|"+String(gases.carbonDioxyd.artysCO2.pCO2),OUTPUT_FILE);
Streams.print("gases.carbonDioxyd.veinsCO2.pCO2|"+String(gases.carbonDioxyd.veinsCO2.pCO2),OUTPUT_FILE);
Streams.print("gases.oxygen.alveolarVentilation.solventFlowPump.q_out.conc|"+String(gases.oxygen.alveolarVentilation.solventFlowPump.q_out.conc),OUTPUT_FILE);
Streams.print("gases.oxygen.artysO2.a|"+String(gases.oxygen.artysO2.a),OUTPUT_FILE);
Streams.print("gases.oxygen.artysO2.FCOHb|"+String(gases.oxygen.artysO2.FCOHb),OUTPUT_FILE);
Streams.print("gases.oxygen.artysO2.pO2|"+String(gases.oxygen.artysO2.pO2),OUTPUT_FILE);
Streams.print("gases.oxygen.O2Lung.a|"+String(gases.oxygen.O2Lung.a),OUTPUT_FILE);
Streams.print("gases.oxygen.O2Lung.FCOHb|"+String(gases.oxygen.O2Lung.FCOHb),OUTPUT_FILE);
Streams.print("gases.oxygen.O2Lung.tO2|"+String(gases.oxygen.O2Lung.tO2),OUTPUT_FILE);
Streams.print("gases.oxygen.tissuesO2.boneO2.O2Tissue.a|"+String(gases.oxygen.tissuesO2.boneO2.O2Tissue.a),OUTPUT_FILE);
Streams.print("gases.oxygen.tissuesO2.boneO2.O2Tissue.FCOHb|"+String(gases.oxygen.tissuesO2.boneO2.O2Tissue.FCOHb),OUTPUT_FILE);
Streams.print("gases.oxygen.tissuesO2.boneO2.O2Tissue.pO2|"+String(gases.oxygen.tissuesO2.boneO2.O2Tissue.pO2),OUTPUT_FILE);
Streams.print("gases.oxygen.tissuesO2.brainO2.O2Tissue.a|"+String(gases.oxygen.tissuesO2.brainO2.O2Tissue.a),OUTPUT_FILE);
Streams.print("gases.oxygen.tissuesO2.brainO2.O2Tissue.FCOHb|"+String(gases.oxygen.tissuesO2.brainO2.O2Tissue.FCOHb),OUTPUT_FILE);
Streams.print("gases.oxygen.tissuesO2.brainO2.O2Tissue.pO2|"+String(gases.oxygen.tissuesO2.brainO2.O2Tissue.pO2),OUTPUT_FILE);
Streams.print("gases.oxygen.tissuesO2.fatO2.O2Tissue.a|"+String(gases.oxygen.tissuesO2.fatO2.O2Tissue.a),OUTPUT_FILE);
Streams.print("gases.oxygen.tissuesO2.fatO2.O2Tissue.FCOHb|"+String(gases.oxygen.tissuesO2.fatO2.O2Tissue.FCOHb),OUTPUT_FILE);
Streams.print("gases.oxygen.tissuesO2.fatO2.O2Tissue.pO2|"+String(gases.oxygen.tissuesO2.fatO2.O2Tissue.pO2),OUTPUT_FILE);
Streams.print("gases.oxygen.tissuesO2.GITractO2.O2Tissue.a|"+String(gases.oxygen.tissuesO2.GITractO2.O2Tissue.a),OUTPUT_FILE);
Streams.print("gases.oxygen.tissuesO2.GITractO2.O2Tissue.FCOHb|"+String(gases.oxygen.tissuesO2.GITractO2.O2Tissue.FCOHb),OUTPUT_FILE);
Streams.print("gases.oxygen.tissuesO2.GITractO2.O2Tissue.pO2|"+String(gases.oxygen.tissuesO2.GITractO2.O2Tissue.pO2),OUTPUT_FILE);
Streams.print("gases.oxygen.tissuesO2.kidneyO2.O2Tissue.a|"+String(gases.oxygen.tissuesO2.kidneyO2.O2Tissue.a),OUTPUT_FILE);
Streams.print("gases.oxygen.tissuesO2.kidneyO2.O2Tissue.FCOHb|"+String(gases.oxygen.tissuesO2.kidneyO2.O2Tissue.FCOHb),OUTPUT_FILE);
Streams.print("gases.oxygen.tissuesO2.kidneyO2.O2Tissue.pO2|"+String(gases.oxygen.tissuesO2.kidneyO2.O2Tissue.pO2),OUTPUT_FILE);
Streams.print("gases.oxygen.tissuesO2.leftHeartO2.O2Tissue.a|"+String(gases.oxygen.tissuesO2.leftHeartO2.O2Tissue.a),OUTPUT_FILE);
Streams.print("gases.oxygen.tissuesO2.leftHeartO2.O2Tissue.FCOHb|"+String(gases.oxygen.tissuesO2.leftHeartO2.O2Tissue.FCOHb),OUTPUT_FILE);
Streams.print("gases.oxygen.tissuesO2.leftHeartO2.O2Tissue.pO2|"+String(gases.oxygen.tissuesO2.leftHeartO2.O2Tissue.pO2),OUTPUT_FILE);
Streams.print("gases.oxygen.tissuesO2.liverO2.O2Tissue.a|"+String(gases.oxygen.tissuesO2.liverO2.O2Tissue.a),OUTPUT_FILE);
Streams.print("gases.oxygen.tissuesO2.liverO2.O2Tissue.FCOHb|"+String(gases.oxygen.tissuesO2.liverO2.O2Tissue.FCOHb),OUTPUT_FILE);
Streams.print("gases.oxygen.tissuesO2.liverO2.O2Tissue.pO2|"+String(gases.oxygen.tissuesO2.liverO2.O2Tissue.pO2),OUTPUT_FILE);
Streams.print("gases.oxygen.tissuesO2.otherTissueO2.O2Tissue.a|"+String(gases.oxygen.tissuesO2.otherTissueO2.O2Tissue.a),OUTPUT_FILE);
Streams.print("gases.oxygen.tissuesO2.otherTissueO2.O2Tissue.FCOHb|"+String(gases.oxygen.tissuesO2.otherTissueO2.O2Tissue.FCOHb),OUTPUT_FILE);
Streams.print("gases.oxygen.tissuesO2.otherTissueO2.O2Tissue.pO2|"+String(gases.oxygen.tissuesO2.otherTissueO2.O2Tissue.pO2),OUTPUT_FILE);
Streams.print("gases.oxygen.tissuesO2.respiratoryMuscleO2.O2Tissue.a|"+String(gases.oxygen.tissuesO2.respiratoryMuscleO2.O2Tissue.a),OUTPUT_FILE);
Streams.print("gases.oxygen.tissuesO2.respiratoryMuscleO2.O2Tissue.FCOHb|"+String(gases.oxygen.tissuesO2.respiratoryMuscleO2.O2Tissue.FCOHb),OUTPUT_FILE);
Streams.print("gases.oxygen.tissuesO2.respiratoryMuscleO2.O2Tissue.pO2|"+String(gases.oxygen.tissuesO2.respiratoryMuscleO2.O2Tissue.pO2),OUTPUT_FILE);
Streams.print("gases.oxygen.tissuesO2.rightHeartO2.O2Tissue.a|"+String(gases.oxygen.tissuesO2.rightHeartO2.O2Tissue.a),OUTPUT_FILE);
Streams.print("gases.oxygen.tissuesO2.rightHeartO2.O2Tissue.FCOHb|"+String(gases.oxygen.tissuesO2.rightHeartO2.O2Tissue.FCOHb),OUTPUT_FILE);
Streams.print("gases.oxygen.tissuesO2.rightHeartO2.O2Tissue.pO2|"+String(gases.oxygen.tissuesO2.rightHeartO2.O2Tissue.pO2),OUTPUT_FILE);
Streams.print("gases.oxygen.tissuesO2.skeletalMuscleO2.O2Tissue.a|"+String(gases.oxygen.tissuesO2.skeletalMuscleO2.O2Tissue.a),OUTPUT_FILE);
Streams.print("gases.oxygen.tissuesO2.skeletalMuscleO2.O2Tissue.FCOHb|"+String(gases.oxygen.tissuesO2.skeletalMuscleO2.O2Tissue.FCOHb),OUTPUT_FILE);
Streams.print("gases.oxygen.tissuesO2.skeletalMuscleO2.O2Tissue.pO2|"+String(gases.oxygen.tissuesO2.skeletalMuscleO2.O2Tissue.pO2),OUTPUT_FILE);
Streams.print("gases.oxygen.tissuesO2.skinO2.O2Tissue.a|"+String(gases.oxygen.tissuesO2.skinO2.O2Tissue.a),OUTPUT_FILE);
Streams.print("gases.oxygen.tissuesO2.skinO2.O2Tissue.FCOHb|"+String(gases.oxygen.tissuesO2.skinO2.O2Tissue.FCOHb),OUTPUT_FILE);
Streams.print("gases.oxygen.tissuesO2.skinO2.O2Tissue.pO2|"+String(gases.oxygen.tissuesO2.skinO2.O2Tissue.pO2),OUTPUT_FILE);
Streams.print("gases.oxygen.veinsO2.a|"+String(gases.oxygen.veinsO2.a),OUTPUT_FILE);
Streams.print("gases.oxygen.veinsO2.FCOHb|"+String(gases.oxygen.veinsO2.FCOHb),OUTPUT_FILE);
Streams.print("gases.oxygen.veinsO2.pO2|"+String(gases.oxygen.veinsO2.pO2),OUTPUT_FILE);*/
        //end if;
          connect(ventilation_const.busConnector, proteins.busConnector) annotation (
              Line(
              points={{-26,-66},{-40,-66},{-40,-18},{-38,-18}},
              color={255,204,51},
              thickness=0.5,
              smooth=Smooth.None));
          connect(o2_1.busConnector, ventilation_const.busConnector) annotation (Line(
              points={{-76,-72},{-44,-72},{-44,-66},{-26,-66}},
              color={255,204,51},
              thickness=0.5,
              smooth=Smooth.None));
          connect(cO2_variables.busConnector, ventilation_const.busConnector)
            annotation (Line(
              points={{-78,-38},{-62,-38},{-62,-66},{-26,-66}},
              color={255,204,51},
              thickness=0.5,
              smooth=Smooth.None));
          annotation (            experiment(StopTime=3600, Tolerance=1e-005));
        end Oxygen_test_SI;
      end IO_Bus;

      model O2
        extends Physiolibrary.Icons.Oxygen;
        Physiolibrary.Chemical.Components.Substance                artys(
                                     stateName="O2Artys.Mass[mMol]",
          useNormalizedVolume=false,
        solute_start=0.0130979)
          annotation (Placement(transformation(extent={{60,-96},{80,-76}})));
        Physiolibrary.Chemical.Components.Substance                veins(
                                               stateName="O2Veins.Mass[mMol]",
          useNormalizedVolume=false,
        solute_start=0.0247781)
          annotation (Placement(transformation(extent={{-88,-54},{-68,-34}})));
      Physiolibrary.Types.BusConnector busConnector annotation (Placement(
            transformation(extent={{88,16},{108,36}}), iconTransformation(
              extent={{60,60},{100,100}})));
      Ventilation.AlveolarVentilation alveolarVentilation(solventFlowPump(q_out(
              conc(start=104/760)), useSolutionFlowInput=true)) annotation (
          Placement(transformation(
            extent={{-10,-10},{10,10}},
            origin={-8,50})));
      Physiolibrary.Chemical.Components.Stream pulmShortCircuit(
          useSolutionFlowInput=true)
        annotation (Placement(transformation(extent={{-16,-28},{4,-48}})));
        Modelica.Blocks.Math.Feedback pulmShortCircuitFlow
          annotation (Placement(transformation(extent={{26,-64},{6,-44}})));
        MeassureBloodO2 artysO2(
        pO2(start=13459),
        cO2Hb(start=7.82305),
        pCO2(start=4428.03),
          a(start=-0.1))
          annotation (Placement(transformation(extent={{64,-20},{84,0}})));
                               /**/
        MeassureBloodO2 veinsO2(
        pO2(start=6140),
        cO2Hb(start=6.52),
        a(start=0.076),
        pCO2(start=6400))
          annotation (Placement(transformation(extent={{-90,-18},{-70,2}})));
                               /**/
        Physiomodel.Gases.O2.BloodO2_Siggaard O2Lung(
        pCO2(start=5700),
        pO2(start=13870),
          sO2CO(start=0.977),
          q_in(q(start=10)),
          a(start=-0.1),
          cO2Hb(start=8.16),
          tO2(start=8.161))
          annotation (Placement(transformation(extent={{-16,-18},{4,2}})));
         // sO2CO(start=0.951486),
                                               /**/
       Real x;
        Physiolibrary.Chemical.Components.GasSolubility
                                          gasSolubility(useHeatPort=true,
        C=1700,
        kH_T0(displayUnit="(mmol/l)/kPa at 37degC") = 0.02707666941329,
        solubilityRateCoef(displayUnit="m3/s") = 0.01,
        T0=310.15)
          annotation (Placement(transformation(extent={{-18,12},{2,32}})));
      Physiolibrary.Thermal.Sources.UnlimitedHeat alveolus(T=310.15)
        annotation (Placement(transformation(extent={{60,46},{80,66}})));
      Physiolibrary.Chemical.Sources.UnlimitedGasStorage air(PartialPressure(
            displayUnit="mmHg") = 21331.5819864, useHeatPort=true)
        annotation (Placement(transformation(extent={{-58,70},{-38,90}})));
      Physiolibrary.Thermal.Sources.UnlimitedHeat environment(T=298.15)
        annotation (Placement(transformation(extent={{-92,46},{-72,66}})));
      TissuesO2 tissuesO2
        annotation (Placement(transformation(extent={{-14,-94},{6,-74}})));
      initial equation
        //if Artys.STEADY then
           // Veins.soluteMass
          // x = -O2Lung.q_out.q;
        //   x = ((-O2Lung.q_out.q - tissuesO2.O2ToTissues)/O2Lung.BloodFlow)*Veins.SolventVolume;
           // end if;

      equation
        x = ((-O2Lung.q_out.q - tissuesO2.O2ToTissues)/O2Lung.BloodFlow)*veins.volume;
        connect(pulmShortCircuitFlow.u1, busConnector.CardiacOutput)
          annotation (Line(
            points={{24,-54},{34,-54},{34,26},{98,26}},
            color={0,0,127},
            smooth=Smooth.None), Text(
            string="%second",
            index=1,
            extent={{6,3},{6,3}}));
        connect(pulmShortCircuit.q_out,artys. q_out)
                                                  annotation (Line(
            points={{4,-38},{14,-38},{14,-18},{70,-18},{70,-86}},
            color={200,0,0},
            thickness=1,
            smooth=Smooth.None));
      connect(pulmShortCircuit.solutionFlow, pulmShortCircuitFlow.y)
        annotation (Line(
          points={{-6,-45},{-6,-54},{7,-54}},
          color={0,0,127},
          smooth=Smooth.None));
        connect(busConnector.AlveolarVentilated_BloodFlow, pulmShortCircuitFlow.u2)
          annotation (Line(
            points={{98,26},{-50,26},{-50,-14},{-30,-14},{-30,-62},{16,-62}},
            color={0,0,255},
            thickness=0.5,
            smooth=Smooth.None), Text(
            string="%first",
            index=-1,
            extent={{-6,3},{-6,3}}));
        connect(veins.q_out, pulmShortCircuit.q_in) annotation (Line(
            points={{-78,-44},{-78,-18},{-24,-18},{-24,-38},{-16,-38}},
            color={200,0,0},
            thickness=1,
            smooth=Smooth.None));
        connect(busConnector.CO2Artys_pCO2, artysO2.pCO2)              annotation (
            Line(
            points={{98,26},{34,26},{34,-4},{65,-4}},
            color={0,0,255},
            thickness=0.5,
            smooth=Smooth.None), Text(
            string="%first",
            index=-1,
            extent={{-6,3},{-6,3}}));
        connect(artysO2.ctHb, busConnector.ctHb)              annotation (Line(
            points={{83,0},{104,0},{104,26},{98,26}},
            color={0,0,127},
            smooth=Smooth.None), Text(
            string="%second",
            index=1,
            extent={{6,3},{6,3}}));
        connect(artysO2.cDPG, busConnector.cDPG)              annotation (Line(
            points={{83,-4},{104,-4},{104,26},{98,26}},
            color={0,0,127},
            smooth=Smooth.None), Text(
            string="%second",
            index=1,
            extent={{6,3},{6,3}}));
        connect(artysO2.FMetHb, busConnector.FMetHb)              annotation (Line(
            points={{83,-8},{104,-8},{104,26},{98,26}},
            color={0,0,127},
            smooth=Smooth.None), Text(
            string="%second",
            index=1,
            extent={{6,3},{6,3}}));
        connect(artysO2.FHbF, busConnector.FHbF)              annotation (Line(
            points={{83,-12},{104,-12},{104,26},{98,26}},
            color={0,0,127},
            smooth=Smooth.None), Text(
            string="%second",
            index=1,
            extent={{6,3},{6,3}}));
        connect(artysO2.pCO, busConnector.pCO)              annotation (Line(
            points={{83,-16},{104,-16},{104,26},{98,26}},
            color={0,0,127},
            smooth=Smooth.None), Text(
            string="%second",
            index=1,
            extent={{6,3},{6,3}}));
        connect(busConnector.Artys_pH, artysO2.pH)  annotation (Line(
            points={{98,26},{34,26},{34,0},{65,0}},
            color={0,0,255},
            thickness=0.5,
            smooth=Smooth.None), Text(
            string="%first",
            index=-1,
            extent={{-6,3},{-6,3}}));
        connect(busConnector.core_T, artysO2.T)       annotation (Line(
            points={{98,26},{34,26},{34,-8},{65,-8}},
            color={0,0,255},
            thickness=0.5,
            smooth=Smooth.None), Text(
            string="%first",
            index=-1,
            extent={{-6,3},{-6,3}}));
        connect(artys.q_out, artysO2.q_in) annotation (Line(
            points={{70,-86},{70,-18},{74,-18}},
            color={200,0,0},
            thickness=1,
            smooth=Smooth.None));
        connect(veinsO2.ctHb, busConnector.ctHb)              annotation (Line(
            points={{-71,2},{-50,2},{-50,26},{98,26}},
            color={0,0,127},
            smooth=Smooth.None), Text(
            string="%second",
            index=1,
            extent={{6,3},{6,3}}));
        connect(veinsO2.cDPG, busConnector.cDPG)              annotation (Line(
            points={{-71,-2},{-50,-2},{-50,26},{98,26}},
            color={0,0,127},
            smooth=Smooth.None), Text(
            string="%second",
            index=1,
            extent={{6,3},{6,3}}));
        connect(veinsO2.FMetHb, busConnector.FMetHb)              annotation (Line(
            points={{-71,-6},{-50,-6},{-50,26},{98,26}},
            color={0,0,127},
            smooth=Smooth.None), Text(
            string="%second",
            index=1,
            extent={{6,3},{6,3}}));
        connect(veinsO2.FHbF, busConnector.FHbF)              annotation (Line(
            points={{-71,-10},{-50,-10},{-50,26},{98,26}},
            color={0,0,127},
            smooth=Smooth.None), Text(
            string="%second",
            index=1,
            extent={{6,3},{6,3}}));
        connect(veinsO2.pCO, busConnector.pCO)              annotation (Line(
            points={{-71,-14},{-50,-14},{-50,26},{98,26}},
            color={0,0,127},
            smooth=Smooth.None), Text(
            string="%second",
            index=1,
            extent={{6,3},{6,3}}));
        connect(busConnector.CO2Veins_pCO2, veinsO2.pCO2)              annotation (
            Line(
            points={{98,26},{-100,26},{-100,-2},{-89,-2}},
            color={0,0,255},
            thickness=0.5,
            smooth=Smooth.None), Text(
            string="%first",
            index=-1,
            extent={{-6,3},{-6,3}}));
        connect(busConnector.Veins_pH, veinsO2.pH)  annotation (Line(
            points={{98,26},{-100,26},{-100,2},{-89,2}},
            color={0,0,255},
            thickness=0.5,
            smooth=Smooth.None), Text(
            string="%first",
            index=-1,
            extent={{-6,3},{-6,3}}));
        connect(busConnector.core_T, veinsO2.T)       annotation (Line(
            points={{98,26},{-100,26},{-100,-6},{-89,-6}},
            color={0,0,255},
            thickness=0.5,
            smooth=Smooth.None), Text(
            string="%first",
            index=-1,
            extent={{-6,3},{-6,3}}));
        connect(veins.q_out, veinsO2.q_in)  annotation (Line(
            points={{-78,-44},{-78,-16},{-80,-16}},
            color={200,0,0},
            thickness=1,
            smooth=Smooth.None));
        connect(busConnector.O2Veins_sO2, veinsO2.sO2)  annotation (Line(
            points={{98,26},{-100,26},{-100,-26},{-80,-26},{-80,-20}},
            color={0,0,255},
            thickness=0.5,
            smooth=Smooth.None), Text(
            string="%first",
            index=-1,
            extent={{-3,-3},{-3,-3}}));
        connect(artysO2.sO2, busConnector.O2Artys_sO2) annotation (Line(
            points={{74,-22},{74,-28},{104,-28},{104,26},{98,26}},
            color={0,0,127},
            smooth=Smooth.None), Text(
            string="%second",
            index=1,
            extent={{3,-3},{3,-3}}));
        connect(artysO2.pO2, busConnector.O2Artys_PO2) annotation (Line(
            points={{78,-22},{104,-22},{104,26},{98,26}},
            color={0,0,127},
            smooth=Smooth.None), Text(
            string="%second",
            index=1,
            extent={{6,3},{6,3}}));
        connect(busConnector.CO2Lung_pCO2,O2Lung. pCO2)               annotation (
            Line(
            points={{98,26},{-50,26},{-50,-2},{-15,-2}},
            color={0,0,255},
            thickness=0.5,
            smooth=Smooth.None), Text(
            string="%first",
            index=-1,
            extent={{-6,3},{-6,3}}));
        connect(O2Lung.ctHb, busConnector.ctHb)               annotation (Line(
            points={{3,2},{34,2},{34,26},{98,26}},
            color={0,0,127},
            smooth=Smooth.None), Text(
            string="%second",
            index=1,
            extent={{6,3},{6,3}}));
        connect(O2Lung.cDPG, busConnector.cDPG)               annotation (Line(
            points={{3,-2},{34,-2},{34,26},{98,26}},
            color={0,0,127},
            smooth=Smooth.None), Text(
            string="%second",
            index=1,
            extent={{6,3},{6,3}}));
        connect(O2Lung.FMetHb, busConnector.FMetHb)               annotation (Line(
            points={{3,-6},{34,-6},{34,26},{98,26}},
            color={0,0,127},
            smooth=Smooth.None), Text(
            string="%second",
            index=1,
            extent={{6,3},{6,3}}));
        connect(O2Lung.FHbF, busConnector.FHbF)               annotation (Line(
            points={{3,-10},{34,-10},{34,26},{98,26}},
            color={0,0,127},
            smooth=Smooth.None), Text(
            string="%second",
            index=1,
            extent={{6,3},{6,3}}));
        connect(O2Lung.pCO, busConnector.pCO)               annotation (Line(
            points={{3,-14},{34,-14},{34,26},{98,26}},
            color={0,0,127},
            smooth=Smooth.None), Text(
            string="%second",
            index=1,
            extent={{6,3},{6,3}}));
        connect(busConnector.AlveolarVentilated_BloodFlow,O2Lung. BloodFlow)
          annotation (Line(
            points={{98,26},{-50,26},{-50,-11.4},{-16,-11.4}},
            color={0,0,255},
            thickness=0.5,
            smooth=Smooth.None), Text(
            string="%first",
            index=-1,
            extent={{-6,3},{-6,3}}));
        connect(O2Lung.sO2, busConnector.O2Lung_sO2) annotation (Line(
            points={{-6,-20},{-6,-26},{34,-26},{34,26},{98,26}},
            color={0,0,127},
            smooth=Smooth.None), Text(
            string="%second",
            index=1,
            extent={{6,-3},{6,-3}}));
        connect(busConnector.core_T,O2Lung. T) annotation (Line(
            points={{98,26},{-50,26},{-50,-6},{-15,-6}},
            color={0,0,255},
            thickness=0.5,
            smooth=Smooth.None), Text(
            string="%first",
            index=-1,
            extent={{-6,3},{-6,3}}));
        connect(veins.q_out,O2Lung. q_in) annotation (Line(
            points={{-78,-44},{-78,-17},{-15,-17}},
            color={200,0,0},
            thickness=1,
            smooth=Smooth.None));
        connect(O2Lung.q_out,artys. q_out) annotation (Line(
            points={{3,-17},{70,-17},{70,-86}},
            color={200,0,0},
            thickness=1,
            smooth=Smooth.None));
        connect(busConnector.lungs_pH_plasma, O2Lung.pH) annotation (Line(
            points={{98,26},{-50,26},{-50,2},{-15,2}},
            color={0,0,255},
            thickness=0.5,
            smooth=Smooth.None), Text(
            string="%first",
            index=-1,
            extent={{-6,3},{-6,3}}));
        connect(alveolarVentilation.AlveolarVentilation_Env, busConnector.AlveolarVentilation_Env)
          annotation (Line(
            points={{0,52},{34,52},{34,26},{98,26}},
            color={0,0,127},
            smooth=Smooth.None), Text(
            string="%second",
            index=1,
            extent={{6,3},{6,3}}));
        connect(alveolarVentilation.BronchiDilution, busConnector.BronchiDilution)
          annotation (Line(
            points={{0,46},{34,46},{34,26},{98,26}},
            color={0,0,127},
            smooth=Smooth.None), Text(
            string="%second",
            index=1,
            extent={{6,3},{6,3}}));
        connect(alveolarVentilation.alveolar, gasSolubility.q_out) annotation (Line(
            points={{-7.8,40},{-8,40},{-8,32}},
            color={107,45,134},
            thickness=1,
            smooth=Smooth.None));
        connect(O2Lung.alveolar, gasSolubility.q_in) annotation (Line(
            points={{-6.4,0.2},{-8,0.2},{-8,14}},
            color={107,45,134},
            thickness=1,
            smooth=Smooth.None));
      connect(artys.solutionVolume, busConnector.ArtysVol) annotation (Line(
          points={{66,-82},{66,-74},{34,-74},{34,26},{98,26}},
          color={0,0,127},
          smooth=Smooth.None), Text(
          string="%second",
          index=1,
          extent={{6,3},{6,3}}));
      connect(veins.solutionVolume, busConnector.VeinsVol) annotation (Line(
          points={{-82,-40},{-82,-34},{-100,-34},{-100,26},{98,26}},
          color={0,0,127},
          smooth=Smooth.None), Text(
          string="%second",
          index=1,
          extent={{6,3},{6,3}}));
      connect(alveolus.port, gasSolubility.heatPort) annotation (Line(
          points={{80,56},{84,56},{84,22},{-8,22}},
          color={191,0,0},
          thickness=1,
          smooth=Smooth.None));
      connect(air.q_out, alveolarVentilation.inspired) annotation (Line(
          points={{-38,80},{-28,80},{-28,58},{-18,58}},
          color={107,45,134},
          thickness=1,
          smooth=Smooth.None));
      connect(air.q_out, alveolarVentilation.expired) annotation (Line(
          points={{-38,80},{14,80},{14,58},{2,58}},
          color={107,45,134},
          thickness=1,
          smooth=Smooth.None));
      connect(environment.port, air.heatPort) annotation (Line(
          points={{-72,56},{-48,56},{-48,80}},
          color={191,0,0},
          thickness=1,
          smooth=Smooth.None));
      connect(artys.q_out, tissuesO2.q_in) annotation (Line(
          points={{70,-86},{38,-86},{38,-84},{8,-84}},
          color={107,45,134},
          thickness=1,
          smooth=Smooth.None));
      connect(veins.q_out, tissuesO2.q_out) annotation (Line(
          points={{-78,-44},{-52,-44},{-52,-84},{-16,-84}},
          color={107,45,134},
          thickness=1,
          smooth=Smooth.None));
      connect(tissuesO2.busConnector, busConnector) annotation (Line(
          points={{-12.8,-74.8},{-12.8,-70},{106,-70},{106,26},{98,26}},
          color={255,204,51},
          thickness=0.5,
          smooth=Smooth.None), Text(
          string="%second",
          index=1,
          extent={{6,3},{6,3}}));
        annotation ( Icon(coordinateSystem(
                preserveAspectRatio=true, extent={{-100,-100},{100,100}}),
              graphics={                 Text(
                extent={{-120,-62},{122,-96}},
                lineColor={0,0,255},
                textString="%name")}),
          Documentation(revisions="<html>

<table cellspacing=\"2\" cellpadding=\"0\" border=\"0\"><tr>
<td><p>Author:</p></td>
<td>Marek Matejak</td>
</tr>
<tr>
<td><p>License:</p></td>
<td><p><a href=\"http://www.physiomodel.org/license.html\">Physiomodel License 1.0</a> </p></td>
</tr>

<tr>
<td><p>Date of:</p></td>
<td><p>2009</p></td>
</tr>
<tr>
<td><p>References:</p></td>
<td>Siggaard Andersen: OSA (2005), University of Copenhagen</td>
</tr>
<tr>
<td></td>
<td><p>Tom Coleman: QHP 2008 beta 3, University of Mississippi Medical Center</p></td>
</tr>
</table>
<br/><p>Copyright &copy; 2014 Marek Matejak, Charles University in Prague.</p><br/>

</html>"));
      end O2;

      model Hemoglobin_MKM_Specie "Part of model Hemoglobin_MKM_Adair"

      parameter Boolean loadStarts
        "Start values of state variables from data file (to help with initialization)";
      parameter Boolean storeState
        "Save state variables at the end of simulation";
      constant String dirName = Modelica.Utilities.Files.loadResource("modelica://Physiolibrary/Resources/Data/Hemoglobin_MKM")
        "Directory to load start gues values and store final simulation values";

      parameter Real[4] pKz
        "Dissociation coefficient of reaction z (Val1 amino terminal protonation)";
      parameter Real[4] pKc
        "Dissociation coefficient of reaction c (Val1 amino terminal carbamination)";
      parameter Real[4] pKh
        "Dissociation coefficient of reaction h (other Bohr protonation reactions of side chains)";

      parameter Physiolibrary.Types.MolarEnergy[4] dH_HbuANH2
        "Standard enthalpy of deprotonated and decarboxylated hemoglobin subunit";
      parameter Physiolibrary.Types.MolarEnergy[4] dHz
        "Enthalpy of reaction z (Val1 amino terminal protonation)";
      parameter Physiolibrary.Types.MolarEnergy[4] dHc
        "Enthalpy of reaction c (Val1 amino terminal carbamination)";
      parameter Physiolibrary.Types.MolarEnergy[4] dHh
        "Enthalpy of reaction h (other Bohr protonation reactions of side chains)";

      parameter Boolean isDependent=false
        "contains dependent equation (if solver is not smart enough)";

      Physiolibrary.Chemical.Interfaces.ChemicalPort_a Hbtn
        annotation (Placement(transformation(extent={{-108,-10},{-88,10}})));
          Physiolibrary.Chemical.Components.Substance Hbu_A_NH3[4](
        each Simulation=Physiolibrary.Types.SimulationType.SteadyState,
        dH=dH_HbuANH2 - dHz,
        each dirName=dirName,
        each LOAD_STARTS=loadStarts,
        each SAVE_RESULTS=storeState,
        each solute_start=1e-06)
        annotation (Placement(transformation(extent={{-32,70},{-12,90}})));
      Physiolibrary.Chemical.Components.Substance Hbu_AH_NH3[4](
        each Simulation=Physiolibrary.Types.SimulationType.SteadyState,
        each dirName=dirName,
        each LOAD_STARTS=loadStarts,
        each SAVE_RESULTS=storeState,
        each solute_start=1e-06,
        dH=dH_HbuANH2 - dHh - dHz)
        annotation (Placement(transformation(extent={{54,70},{74,90}})));
      Physiolibrary.Chemical.Components.Substance Hbu_A_NH2[4](
        each Simulation=Physiolibrary.Types.SimulationType.SteadyState,
        isDependent={isDependent,true,true,true},
        each dirName=dirName,
        each LOAD_STARTS=loadStarts,
        each SAVE_RESULTS=storeState,
        each solute_start=1e-06,
        dH=dH_HbuANH2)
        annotation (Placement(transformation(extent={{-32,-2},{-12,18}})));
      Physiolibrary.Chemical.Components.Substance Hbu_AH_NH2[4](
        each Simulation=Physiolibrary.Types.SimulationType.SteadyState,
        each dirName=dirName,
        each LOAD_STARTS=loadStarts,
        each SAVE_RESULTS=storeState,
        each solute_start=1e-06,
        dH=dH_HbuANH2 - dHh)
        annotation (Placement(transformation(extent={{54,-2},{74,18}})));
      Physiolibrary.Chemical.Components.Substance Hbu_A_NHCOO[4](
        each Simulation=Physiolibrary.Types.SimulationType.SteadyState,
        dH=dH_HbuANH2 + dHc,
        each dirName=dirName,
        each LOAD_STARTS=loadStarts,
        each SAVE_RESULTS=storeState,
        each solute_start=1e-06)
        annotation (Placement(transformation(extent={{-32,-84},{-12,-64}})));
      Physiolibrary.Chemical.Components.Substance Hbu_AH_NHCOO[4](
        each Simulation=Physiolibrary.Types.SimulationType.SteadyState,
        each dirName=dirName,
        each LOAD_STARTS=loadStarts,
        each SAVE_RESULTS=storeState,
        dH=dH_HbuANH2 + dHc,
        each solute_start=1e-06)
        annotation (Placement(transformation(extent={{54,-84},{74,-64}})));
      Physiolibrary.Chemical.Components.ChemicalReaction h2[4](
        each nS=1,
        each nP=2,
        K=fill(10, 4) .^ (-pKh .+ 3),
        each TK=310.15,
        dH=dHh) annotation (Placement(transformation(extent={{32,-2},{12,18}})));
      Physiolibrary.Chemical.Components.ChemicalReaction z1[4](
        each nP=2,
        K=fill(10, 4) .^ (-pKz .+ 3),
        dH=dHz,
        each TK=310.15) annotation (Placement(transformation(
            extent={{-10,-10},{10,10}},
            rotation=270,
            origin={-22,44})));
      Physiolibrary.Chemical.Components.ChemicalReaction z2[4](
        each nP=2,
        K=fill(10, 4) .^ (-pKz .+ 3),
        each TK=310.15,
        dH=dHz) annotation (Placement(transformation(
            extent={{-10,-10},{10,10}},
            rotation=270,
            origin={64,44})));
      Physiolibrary.Chemical.Components.ChemicalReaction c1[4](
        each nS=2,
        each nP=2,
        K=fill(10, 4) .^ (-pKc .+ 3),
        each TK=310.15,
        dH=dHc) annotation (Placement(transformation(
            extent={{-10,-10},{10,10}},
            rotation=270,
            origin={-22,-34})));
      Physiolibrary.Chemical.Components.ChemicalReaction c2[4](
        each nS=2,
        each nP=2,
        K=fill(10, 4) .^ (-pKc .+ 3),
        each TK=310.15,
        dH=dHc) annotation (Placement(transformation(
            extent={{-10,-10},{10,10}},
            rotation=270,
            origin={64,-34})));
      Modelica.Blocks.Math.Sum total[4](each nin=6) annotation (Placement(transformation(
              extent={{-10,-10},{10,10}},
              rotation=180,
              origin={-64,62})));
        Physiolibrary.Chemical.Interfaces.ChemicalPort_a H3O(conc(nominal=10^(-7.2
               + 3))) "hydrogen ions"
        annotation (Placement(transformation(extent={{90,76},{110,96}})));
        Physiolibrary.Chemical.Interfaces.ChemicalPort_a CO2
        annotation (Placement(transformation(extent={{90,-70},{110,-50}})));
        Physiolibrary.Chemical.Components.Speciation Hb_tn(
        Simulation=Physiolibrary.Types.SimulationType.SteadyState,
        NumberOfSubunits=4,
        useInternalHeatsInput=false)
        annotation (Placement(transformation(extent={{-54,-22},{-74,-2}})));
      Physiolibrary.Types.RealIO.AmountOfSubstanceOutput tHb_u annotation (
          Placement(transformation(
            extent={{-10,-10},{10,10}},
            rotation=180,
            origin={-100,-78})));
      equation
      connect(Hbu_AH_NH3.q_out, z2.substrates[1]) annotation (Line(
          points={{64,80},{64,54}},
          color={107,45,134},
          thickness=1,
          smooth=Smooth.None));
      connect(Hbu_A_NH3.q_out, z1.substrates[1]) annotation (Line(
          points={{-22,80},{-22,54}},
          color={107,45,134},
          thickness=1,
          smooth=Smooth.None));
      connect(z1.products[1], Hbu_A_NH2.q_out) annotation (Line(
          points={{-22.5,34},{-22.5,22},{-22,22},{-22,8}},
          color={107,45,134},
          thickness=1,
          smooth=Smooth.None));
      connect(z2.products[1], Hbu_AH_NH2.q_out) annotation (Line(
          points={{63.5,34},{63.5,22},{64,22},{64,8}},
          color={107,45,134},
          thickness=1,
          smooth=Smooth.None));
      connect(h2.substrates[1], Hbu_AH_NH2.q_out) annotation (Line(
          points={{32,8},{64,8}},
          color={107,45,134},
          thickness=1,
          smooth=Smooth.None));
      connect(Hbu_A_NH2.q_out, c1.substrates[1]) annotation (Line(
          points={{-22,8},{-22,-24},{-22.5,-24}},
          color={107,45,134},
          thickness=1,
          smooth=Smooth.None));
      connect(Hbu_AH_NH2.q_out, c2.substrates[1]) annotation (Line(
          points={{64,8},{64,-24},{63.5,-24}},
          color={107,45,134},
          thickness=1,
          smooth=Smooth.None));
      connect(c1.products[1], Hbu_A_NHCOO.q_out) annotation (Line(
          points={{-22.5,-44},{-22.5,-60},{-22,-60},{-22,-74}},
          color={107,45,134},
          thickness=1,
          smooth=Smooth.None));
      connect(c2.products[1], Hbu_AH_NHCOO.q_out) annotation (Line(
          points={{63.5,-44},{63.5,-60},{64,-60},{64,-74}},
          color={107,45,134},
          thickness=1,
          smooth=Smooth.None));
      connect(Hbu_A_NH3.solute, total.u[1]) annotation (Line(
          points={{-16,70},{-44,70},{-44,63.6667},{-52,63.6667}},
          color={0,0,127},
          smooth=Smooth.None));
      connect(Hbu_AH_NH3.solute, total.u[2]) annotation (Line(
          points={{70,70},{-44,70},{-44,63},{-52,63}},
          color={0,0,127},
          smooth=Smooth.None));
      connect(Hbu_A_NH2.solute, total.u[3]) annotation (Line(
          points={{-16,-2},{-44,-2},{-44,62.3333},{-52,62.3333}},
          color={0,0,127},
          smooth=Smooth.None));
      connect(Hbu_AH_NH2.solute, total.u[4]) annotation (Line(
          points={{70,-2},{-44,-2},{-44,61.6667},{-52,61.6667}},
          color={0,0,127},
          smooth=Smooth.None));
      connect(Hbu_A_NHCOO.solute, total.u[5]) annotation (Line(
          points={{-16,-84},{-44,-84},{-44,61},{-52,61}},
          color={0,0,127},
          smooth=Smooth.None));
      connect(Hbu_AH_NHCOO.solute, total.u[6]) annotation (Line(
          points={{70,-84},{-44,-84},{-44,60.3333},{-52,60.3333}},
          color={0,0,127},
          smooth=Smooth.None));

      connect(Hbu_A_NH2.q_out, h2.products[1]) annotation (Line(
          points={{-22,8},{-10,8},{-10,7.5},{12,7.5}},
          color={107,45,134},
          thickness=1,
          smooth=Smooth.None));

        connect(Hb_tn.specificForm, Hbtn) annotation (Line(
            points={{-74,-20},{-86,-20},{-86,0},{-98,0}},
            color={107,45,134},
            thickness=1,
            smooth=Smooth.None));
        connect(total.y, Hb_tn.amountOfSubunit) annotation (Line(
            points={{-75,62},{-78,62},{-78,-12},{-72,-12}},
            color={0,0,127},
            smooth=Smooth.None));

        for i in 1:4 loop
        connect(z1[i].products[2], H3O) annotation (Line(
            points={{-21.5,34},{-21.5,28},{-4,28},{-4,96},{88,96},{88,86},{100,
                86}},
            color={107,45,134},
            thickness=1,
            smooth=Smooth.None));
        connect(z2[i].products[2], H3O) annotation (Line(
            points={{64.5,34},{64.5,28},{-4,28},{-4,96},{88,96},{88,86},{100,86}},
            color={107,45,134},
            thickness=1,
            smooth=Smooth.None));

        connect(c1[i].products[2], H3O) annotation (Line(
            points={{-21.5,-44},{-21.5,-50},{-4,-50},{-4,96},{88,96},{88,86},{
                100,86}},
            color={107,45,134},
            thickness=1,
            smooth=Smooth.None));
        connect(c2[i].products[2], H3O) annotation (Line(
            points={{64.5,-44},{64.5,-50},{-4,-50},{-4,96},{88,96},{88,86},{100,
                86}},
            color={107,45,134},
            thickness=1,
            smooth=Smooth.None));

        connect(H3O, h2[i].products[2]) annotation (Line(
            points={{100,86},{88,86},{88,96},{-4,96},{-4,8.5},{12,8.5}},
            color={107,45,134},
            thickness=1,
            smooth=Smooth.None));

          connect(CO2, c2[i].substrates[2]) annotation (Line(
            points={{100,-60},{88,-60},{88,-20},{64.5,-20},{64.5,-24}},
            color={107,45,134},
            thickness=1,
            smooth=Smooth.None));
        connect(CO2, c1[i].substrates[2]) annotation (Line(
            points={{100,-60},{88,-60},{88,-20},{-21.5,-20},{-21.5,-24}},
            color={107,45,134},
            thickness=1,
            smooth=Smooth.None));
        end for;
        connect(Hb_tn.specificSubunitForm, Hbu_A_NH2.q_out) annotation (Line(
            points={{-64,-2},{-64,8},{-22,8}},
            color={107,45,134},
            thickness=1,
            smooth=Smooth.None));
        connect(tHb_u, Hb_tn.amount) annotation (Line(
            points={{-100,-78},{-64,-78},{-64,-20}},
            color={0,0,127},
            smooth=Smooth.None));

      annotation ( Documentation(revisions="<html>
<p><i>2014</i></p>
<p>Marek Matejak, Charles University, Prague, Czech Republic </p>
</html>", info="<html>

<p>Ref: Mateják Marek, Kulhánek Tomáa, Matouaek Stanislav. Adair-Based Hemoglobin Equilibrium with Oxygen, Carbon Dioxide and Hydrogen Ion Activity. Scandinavian Journal of Clinical &AMP; Laboratory Investigation 2014</p>

<p>Parameters are chosen to fit following measurements:</p>
<p>[1] Bauer C, Schr&ouml;der E. Carbamino compounds of haemoglobin in human adult and foetal blood. The Journal of physiology 1972;227:457-71.</p>
<p>[2] Siggaard-Andersen O. Oxygen-Linked Hydrogen Ion Binding of Human Hemoglobin. Effects of Carbon Dioxide and 2, 3-Diphosphoglycerate I. Studies on Erythrolysate. Scandinavian Journal of Clinical &AMP; Laboratory Investigation 1971;27:351-60.</p>

</html>"));
      end Hemoglobin_MKM_Specie;

      model Hemoglobin_MKM_Adair "Matejak,Kulhanek,Matousek (2014)"

        constant Real pKzD=7.73,pKcD=7.54,pKhD=7.52;
        constant Real pKzO=7.25,pKcO=8.35,pKhO=6.89;
        constant Physiolibrary.Types.MolarEnergy dHzD=-51400;
        constant Physiolibrary.Types.MolarEnergy dHzO=7700;
        constant Physiolibrary.Types.MolarEnergy dHcD=59100;
        constant Physiolibrary.Types.MolarEnergy dHcO=-41100;
        constant Physiolibrary.Types.MolarEnergy dHhD=49000;
        constant Physiolibrary.Types.MolarEnergy dHhO=-105000;
        constant Physiolibrary.Types.MolarEnergy dHo=50000;
        constant Physiolibrary.Types.MolarEnergy dH_HbuDANH2=0;
        // dHhD=0, dHhO=-104000, dHo=12700, dH_HbuDANH2=0;                           // dHhD=48600, dHhO=-104000, dHo=50000, dH_HbuDANH2=0;

        parameter Boolean storeResults=false;
        parameter Boolean loadStarts=true;

        Physiolibrary.Chemical.Components.ChemicalReaction K1(
          K=0.0121,
          nS=1,
          nP=2) annotation (Placement(transformation(
              extent={{10,-10},{-10,10}},
              rotation=270,
              origin={-44,68})));
        Physiolibrary.Chemical.Components.ChemicalReaction K2(
          K=0.0117,
          nS=1,
          nP=2) annotation (Placement(transformation(
              extent={{10,-10},{-10,10}},
              rotation=270,
              origin={-46,28})));
        Physiolibrary.Chemical.Components.ChemicalReaction K3(
          K=0.0871,
          nS=1,
          nP=2) annotation (Placement(transformation(
              extent={{10,-10},{-10,10}},
              rotation=270,
              origin={-48,-18})));
        Physiolibrary.Chemical.Components.ChemicalReaction K4(
          K=0.000386,
          nS=1,
          nP=2) annotation (Placement(transformation(
              extent={{10,-10},{-10,10}},
              rotation=270,
              origin={-50,-60})));
        Physiolibrary.Chemical.Examples.Hemoglobin.Hemoglobin_MKM_Specie Hb0(
          pKz=fill(pKzD, 4),
          pKc=fill(pKcD, 4),
          pKh=fill(pKhD, 4),
          isDependent=true,
          dH_HbuANH2(displayUnit="kJ/mol") = fill(dH_HbuDANH2, 4),
          dHz(displayUnit="kJ/mol") = fill(dHzD, 4),
          dHc(displayUnit="kJ/mol") = fill(dHcD, 4),
          dHh(displayUnit="kJ/mol") = fill(dHhD, 4),
          storeState=storeResults,
          loadStarts=loadStarts)
          annotation (Placement(transformation(extent={{-24,78},{-4,98}})));
        Physiolibrary.Chemical.Examples.Hemoglobin.Hemoglobin_MKM_Specie Hb1(
          pKz=cat(
              1,
              fill(pKzD, 3),
              fill(pKzO, 1)),
          pKc=cat(
              1,
              fill(pKcD, 3),
              fill(pKcO, 1)),
          pKh=cat(
              1,
              fill(pKhD, 3),
              fill(pKhO, 1)),
          dH_HbuANH2(displayUnit="kJ/mol") = cat(
            1,
            fill(dH_HbuDANH2, 3),
            fill(dH_HbuDANH2 - dHo, 1)),
          dHz(displayUnit="kJ/mol") = cat(
            1,
            fill(dHzD, 3),
            fill(dHzO, 1)),
          dHc(displayUnit="kJ/mol") = cat(
            1,
            fill(dHcD, 3),
            fill(dHcO, 1)),
          dHh(displayUnit="kJ/mol") = cat(
            1,
            fill(dHhD, 3),
            fill(dHhO, 1)),
          storeState=storeResults,
          loadStarts=loadStarts)
          annotation (Placement(transformation(extent={{-24,40},{-4,60}})));
        Physiolibrary.Chemical.Examples.Hemoglobin.Hemoglobin_MKM_Specie Hb2(
          pKz=cat(
              1,
              fill(pKzD, 2),
              fill(pKzO, 2)),
          pKc=cat(
              1,
              fill(pKcD, 2),
              fill(pKcO, 2)),
          pKh=cat(
              1,
              fill(pKhD, 2),
              fill(pKhO, 2)),
          dH_HbuANH2(displayUnit="kJ/mol") = cat(
            1,
            fill(dH_HbuDANH2, 2),
            fill(dH_HbuDANH2 - dHo, 2)),
          dHz(displayUnit="kJ/mol") = cat(
            1,
            fill(dHzD, 2),
            fill(dHzO, 2)),
          dHc(displayUnit="kJ/mol") = cat(
            1,
            fill(dHcD, 2),
            fill(dHcO, 2)),
          dHh(displayUnit="kJ/mol") = cat(
            1,
            fill(dHhD, 2),
            fill(dHhO, 2)),
          storeState=storeResults,
          loadStarts=loadStarts)
          annotation (Placement(transformation(extent={{-24,0},{-4,20}})));
        Physiolibrary.Chemical.Examples.Hemoglobin.Hemoglobin_MKM_Specie Hb3(
          pKz=cat(
              1,
              fill(pKzD, 1),
              fill(pKzO, 3)),
          pKc=cat(
              1,
              fill(pKcD, 1),
              fill(pKcO, 3)),
          pKh=cat(
              1,
              fill(pKhD, 1),
              fill(pKhO, 3)),
          dH_HbuANH2(displayUnit="kJ/mol") = cat(
            1,
            fill(dH_HbuDANH2, 1),
            fill(dH_HbuDANH2 - dHo, 3)),
          dHz(displayUnit="kJ/mol") = cat(
            1,
            fill(dHzD, 1),
            fill(dHzO, 3)),
          dHc(displayUnit="kJ/mol") = cat(
            1,
            fill(dHcD, 1),
            fill(dHcO, 3)),
          dHh(displayUnit="kJ/mol") = cat(
            1,
            fill(dHhD, 1),
            fill(dHhO, 3)),
          storeState=storeResults,
          loadStarts=loadStarts)
          annotation (Placement(transformation(extent={{-24,-44},{-4,-24}})));
        Physiolibrary.Chemical.Examples.Hemoglobin.Hemoglobin_MKM_Specie Hb4(
          pKz=fill(pKzO, 4),
          pKc=fill(pKcO, 4),
          pKh=fill(pKhO, 4),
          dH_HbuANH2(displayUnit="kJ/mol") = fill(dH_HbuDANH2 - dHo, 4),
          dHz(displayUnit="kJ/mol") = fill(dHzO, 4),
          dHc(displayUnit="kJ/mol") = fill(dHcO, 4),
          dHh(displayUnit="kJ/mol") = fill(dHhO, 4),
          storeState=storeResults,
          loadStarts=loadStarts)
          annotation (Placement(transformation(extent={{-24,-88},{-4,-68}})));
        Physiolibrary.SteadyStates.Components.MolarConservationLaw totalHemoglobin(
          n=5,
          Total(displayUnit="mol") = 1,
          Simulation=Physiolibrary.Types.SimulationType.SteadyState,
          useTotalInput=true)
          annotation (Placement(transformation(extent={{56,6},{76,26}})));
        Physiolibrary.Chemical.Interfaces.ChemicalPort_a O2
          annotation (Placement(transformation(extent={{-94,-14},{-74,6}})));
        Physiolibrary.Chemical.Interfaces.ChemicalPort_a H3O
          annotation (Placement(transformation(extent={{58,76},{78,96}})));
        Physiolibrary.Chemical.Interfaces.ChemicalPort_a CO2
          annotation (Placement(transformation(extent={{60,-92},{80,-72}})));
        Physiolibrary.Types.RealIO.AmountOfSubstanceInput tHb
          annotation (Placement(transformation(extent={{36,22},{54,40}})));
      equation

        connect(Hb1.H, Hb0.H) annotation (Line(
            points={{-4,58.6},{10,58.6},{10,96.6},{-4,96.6}},
            color={107,45,134},
            thickness=1,
            smooth=Smooth.None));
        connect(Hb4.H, Hb0.H) annotation (Line(
            points={{-4,-69.4},{10,-69.4},{10,96.6},{-4,96.6}},
            color={107,45,134},
            thickness=1,
            smooth=Smooth.None));
        connect(Hb2.H, Hb0.H) annotation (Line(
            points={{-4,18.6},{10,18.6},{10,96.6},{-4,96.6}},
            color={107,45,134},
            thickness=1,
            smooth=Smooth.None));
        connect(Hb1.CO2, Hb0.CO2) annotation (Line(
            points={{-4,44},{4,44},{4,82},{-4,82}},
            color={107,45,134},
            thickness=1,
            smooth=Smooth.None));
        connect(Hb2.CO2, Hb0.CO2) annotation (Line(
            points={{-4,4},{4,4},{4,82},{-4,82}},
            color={107,45,134},
            thickness=1,
            smooth=Smooth.None));
        connect(Hb0.Hbtn, K1.products[2]) annotation (Line(
            points={{-23.8,88},{-43.5,88},{-43.5,78}},
            color={107,45,134},
            thickness=1,
            smooth=Smooth.None));
        connect(Hb1.Hbtn, K1.substrates[1]) annotation (Line(
            points={{-23.8,50},{-44,50},{-44,58}},
            color={107,45,134},
            thickness=1,
            smooth=Smooth.None));
        connect(Hb1.Hbtn, K2.products[2]) annotation (Line(
            points={{-23.8,50},{-44,50},{-44,38},{-45.5,38}},
            color={107,45,134},
            thickness=1,
            smooth=Smooth.None));
        connect(Hb2.Hbtn, K2.substrates[1]) annotation (Line(
            points={{-23.8,10},{-46,10},{-46,18}},
            color={107,45,134},
            thickness=1,
            smooth=Smooth.None));
        connect(Hb2.Hbtn, K3.products[2]) annotation (Line(
            points={{-23.8,10},{-46,10},{-46,-8},{-47.5,-8}},
            color={107,45,134},
            thickness=1,
            smooth=Smooth.None));
        connect(Hb3.Hbtn, K3.substrates[1]) annotation (Line(
            points={{-23.8,-34},{-48,-34},{-48,-28}},
            color={107,45,134},
            thickness=1,
            smooth=Smooth.None));
        connect(Hb3.Hbtn, K4.products[2]) annotation (Line(
            points={{-23.8,-34},{-48,-34},{-48,-50},{-49.5,-50}},
            color={107,45,134},
            thickness=1,
            smooth=Smooth.None));
        connect(Hb4.Hbtn, K4.substrates[1]) annotation (Line(
            points={{-23.8,-78},{-50,-78},{-50,-70}},
            color={107,45,134},
            thickness=1,
            smooth=Smooth.None));
        connect(Hb4.tHb_u, totalHemoglobin.fragment[1]) annotation (Line(
            points={{-24,-85.8},{-30,-85.8},{-30,-96},{24,-96},{24,10.4},{56,10.4}},
            color={0,0,127},
            smooth=Smooth.None));
        connect(Hb3.tHb_u, totalHemoglobin.fragment[2]) annotation (Line(
            points={{-24,-41.8},{-30,-41.8},{-30,-48},{22,-48},{22,11.2},{56,11.2}},
            color={0,0,127},
            smooth=Smooth.None));
        connect(Hb2.tHb_u, totalHemoglobin.fragment[3]) annotation (Line(
            points={{-24,2.2},{-30,2.2},{-30,-4},{20,-4},{20,12},{56,12}},
            color={0,0,127},
            smooth=Smooth.None));
        connect(Hb1.tHb_u, totalHemoglobin.fragment[4]) annotation (Line(
            points={{-24,42.2},{-28,42.2},{-28,34},{18,34},{18,12.8},{56,12.8}},
            color={0,0,127},
            smooth=Smooth.None));
        connect(Hb0.tHb_u, totalHemoglobin.fragment[5]) annotation (Line(
            points={{-24,80.2},{-28,80.2},{-28,72},{20,72},{20,13.6},{56,13.6}},
            color={0,0,127},
            smooth=Smooth.None));

        connect(O2, K4.products[1]) annotation (Line(
            points={{-84,-4},{-68,-4},{-68,-38},{-50.5,-38},{-50.5,-50}},
            color={107,45,134},
            thickness=1,
            smooth=Smooth.None));
        connect(O2, K3.products[1]) annotation (Line(
            points={{-84,-4},{-68,-4},{-68,4},{-48.5,4},{-48.5,-8}},
            color={107,45,134},
            thickness=1,
            smooth=Smooth.None));
        connect(O2, K2.products[1]) annotation (Line(
            points={{-84,-4},{-68,-4},{-68,46},{-46.5,46},{-46.5,38}},
            color={107,45,134},
            thickness=1,
            smooth=Smooth.None));
        connect(O2, K1.products[1]) annotation (Line(
            points={{-84,-4},{-68,-4},{-68,88},{-44.5,88},{-44.5,78}},
            color={107,45,134},
            thickness=1,
            smooth=Smooth.None));
        connect(Hb0.H, Hb3.H) annotation (Line(
            points={{-4,96.6},{10,96.6},{10,-25.4},{-4,-25.4}},
            color={107,45,134},
            thickness=1,
            smooth=Smooth.None));
        connect(Hb0.H, H3O) annotation (Line(
            points={{-4,96.6},{10,96.6},{10,86},{68,86}},
            color={107,45,134},
            thickness=1,
            smooth=Smooth.None));
        connect(Hb1.CO2, CO2) annotation (Line(
            points={{-4,44},{4,44},{4,-82},{70,-82}},
            color={107,45,134},
            thickness=1,
            smooth=Smooth.None));
        connect(tHb, totalHemoglobin.total) annotation (Line(
            points={{45,31},{66,31},{66,24}},
            color={0,0,127},
            smooth=Smooth.None));
        connect(Hb4.CO2, CO2) annotation (Line(
            points={{-4,-84},{4,-84},{4,-82},{70,-82}},
            color={107,45,134},
            thickness=1,
            smooth=Smooth.None));
      connect(Hb3.CO2, CO2) annotation (Line(
          points={{-4,-40},{4,-40},{4,-82},{70,-82}},
          color={107,45,134},
          thickness=1,
          smooth=Smooth.None));
        annotation (          experiment(
            StopTime=15000,
            Tolerance=1e-014,
            __Dymola_Algorithm="Euler"), Documentation(info=
                   "<html>
<p>Ref: Mateják Marek, Kulhánek Tomáa, Matouaek Stanislav. Adair-Based Hemoglobin Equilibrium with Oxygen, Carbon Dioxide and Hydrogen Ion Activity. Scandinavian Journal of Clinical &AMP; Laboratory Investigation 2014</p>

<p>Before silumation in &QUOT;Dymola 2014 FD01&QUOT; please set environment variable &QUOT;<code><b>Advanced.Define.NonLinearIterations&nbsp;=&nbsp;3&QUOT;</b></code> and chose &QUOT;Euler&QUOT; method!</p>
<p>Parameters are chosen to fit following measurements:</p>
<p>[1] Bauer C, Schr&ouml;der E. Carbamino compounds of haemoglobin in human adult and foetal blood. The Journal of physiology 1972;227:457-71.</p>
<p>[2] Siggaard-Andersen O. Oxygen-Linked Hydrogen Ion Binding of Human Hemoglobin. Effects of Carbon Dioxide and 2, 3-Diphosphoglycerate I. Studies on Erythrolysate. Scandinavian Journal of Clinical &AMP; Laboratory Investigation 1971;27:351-60.</p>
<p>[3] Severinghaus JW. Simple, accurate equations for human blood O2 dissociation computations. Journal of Applied Physiology 1979;46:599-602.</p>
</html>", revisions="<html>
<p><i>2014</i></p>
<p>Marek Matejak, Charles University, Prague, Czech Republic </p>
</html>"));
      end Hemoglobin_MKM_Adair;
      annotation (Documentation(revisions="<html>

<table>
<tr>
<td>Author:</td>
<td>Marek Matejak</td>
</tr>
<tr>
<td>License:</td>
<td><a href=\"http://www.physiomodel.org/license.html\">Physiomodel License 1.0</a> </td>
</tr>
<tr>
<td>By:</td>
<td>Charles University, Prague</td>
</tr>
<tr>
<td>Date of:</td>
<td>2009</td>
</tr>
<tr>
<td>References:</td>
<td>Tom Coleman: QHP 2008 beta 3, University of Mississippi Medical Center</td>
</tr><tr>
<td></td>
<td>Siggaard Andersen: OSA (2005), University of Copenhagen</td>
</tr>
</table>
<br/><p>Copyright &copy; 2014 Marek Matejak, Charles University in Prague.</p><br/>

</html>"));
    end O2;

    package CO2 "Body CO2 Transport"

      partial model HendersonHasselbach
        import Modelica.Math;

        Real pK;
        Real aCO2(final displayUnit="mmol/(l.kPa)");
         Physiolibrary.Types.Concentration cdCO2(displayUnit="mmol/l");
      // start=3,
      //  Physiolibrary.Types.Pressure pCO2(start=6000,            displayUnit="kPa");
      //  start=6,
       // constant Real MiniliterPerLiter(final displayUnit="ml/l")=1000;

         Physiolibrary.Types.RealIO.ConcentrationOutput cHCO3(
                                              displayUnit="mmol/l")
        "outgoing concentration of HCO3"                                                             annotation (Placement(
              transformation(extent={{20,-70},{60,-30}}), iconTransformation(
              extent={{-20,-20},{20,20}},
              rotation=270,
              origin={80,-120})));
         Physiolibrary.Types.RealIO.TemperatureInput T(      displayUnit="degC")
        "outgoing temperature"                                                              annotation (Placement(transformation(extent={{70,-26},
                  {110,14}}),           iconTransformation(extent={{-10,-10},{10,10}},
              rotation=180,
              origin={90,80})));        /*start=37,*/

         Physiolibrary.Types.RealIO.pHInput pH "outgoing plasma pH"
                                                              annotation (Placement(transformation(extent={{-120,50},
                  {-80,90}}),           iconTransformation(extent={{-100,70},{-80,90}})));
       Physiolibrary.Types.RealIO.PressureOutput pCO2(start=6000,       displayUnit="mmHg")
        "alveolar partial pressure of pCO2"
                                          annotation (Placement(transformation(
                extent={{20,-70},{60,-30}}), iconTransformation(
              extent={{-20,-20},{20,20}},
              rotation=270,
              origin={40,-120})));               /*start=40,*/
      equation
        //Henderson-Hasselbalch equation:
        pK = 6.1 + (-0.0026)*(T-310.15);
        aCO2 = 0.00023 * 10^(-0.0092*(T-310.15)); //solubility depends on temperature
        cdCO2 = aCO2*pCO2;
       // pH = if ( cdCO2 > 1e-8) then  pK + log10(max(1e-15,cHCO3/cdCO2)) else pK;
        cdCO2 * 10^(pH-pK) = cHCO3;

        annotation ( Documentation(revisions="<html>

<table cellspacing=\"2\" cellpadding=\"0\" border=\"0\"><tr>
<td><p>Author:</p></td>
<td><p>Marek Matejak</p></td>
</tr>
<tr>
<td><p>License:</p></td>
<td><p><a href=\"http://www.physiomodel.org/license.html\">Physiomodel License 1.0</a> </p></td>
</tr>

<tr>
<td><p>Date of:</p></td>
<td><p>2009</p></td>
</tr>
<tr>
<td><p>References:</p></td>
<td>Siggaard Andersen: OSA (2005), University of Copenhagen</td>
</tr>
</table>
<br/><p>Copyright &copy; 2014 Marek Matejak, Charles University in Prague.</p><br/>

</html>"));
      end HendersonHasselbach;

      partial model BloodCO2Base
        extends Physiomodel.Gases.CO2.HendersonHasselbach;

        import Modelica.Math;

        Physiolibrary.Types.Concentration tCO2_P(start=24, displayUnit="mmol/l");
        //start=24,

        Real pK_ery;
        Physiolibrary.Types.GasSolubility aCO2_ery( displayUnit="mmol/l/mmHg");
        Physiolibrary.Types.Concentration tCO2_ery( displayUnit="mmol/l");

         Physiolibrary.Types.Concentration tCO2( displayUnit="mmol/l");

      //  constant Real MiniliterPerLiter(final displayUnit="ml/l")=1000;

         Physiolibrary.Types.RealIO.pHInput pH_ery
        "outgoing intracellular erytrocytes pH"
                                        annotation (Placement(transformation(extent={{-120,10},
                  {-80,50}}),           iconTransformation(extent={{-100,30},{-80,50}})));
         Physiolibrary.Types.RealIO.FractionInput Hct
        "outgoing hematocrit (erytrocytes volume/blood volume)"
                                         annotation (Placement(transformation(extent={{60,60},
                  {100,100}}),          iconTransformation(
              extent={{-10,-10},{10,10}},
              rotation=180,
              origin={90,40})));
         Physiolibrary.Types.RealIO.FractionInput sO2
        "outgoing oxygen saturation"     annotation (Placement(transformation(extent={{60,20},
                  {100,60}}),           iconTransformation(
              extent={{-10,-10},{10,10}},
              rotation=180,
              origin={90,0})));

      equation
        //total plasma CO2 from SimpleCO2Solution
        tCO2_P = cHCO3 + cdCO2;

        //erythrocytes:
        pK_ery = 6.125 - log10(1+10^(pH_ery-7.84-0.06*sO2));
        tCO2_ery=aCO2_ery*pCO2*(1+10^(pH_ery-pK_ery));
        aCO2_ery=0.000195; //solubility 0.23 (mmol/l)/kPa at 25degC

        //plasma+erythrocyte
        tCO2 = tCO2_ery*Hct + tCO2_P*(1-Hct);

        annotation (Icon(coordinateSystem(preserveAspectRatio=true, extent={{-100,
                  -100},{100,100}}), graphics={Rectangle(
                extent={{-100,100},{100,-100}},
                lineColor={0,0,255},
                fillColor={215,215,215},
                fillPattern=FillPattern.Solid), Text(
                extent={{-74,-26},{74,-58}},
                lineColor={0,0,255},
                textString="%name")}),        Documentation(revisions="<html>

<table cellspacing=\"2\" cellpadding=\"0\" border=\"0\"><tr>
<td><p>Author:</p></td>
<td><p>Marek Matejak</p></td>
</tr>
<tr>
<td><p>License:</p></td>
<td><p><a href=\"http://www.physiomodel.org/license.html\">Physiomodel License 1.0</a> </p></td>
</tr>

<tr>
<td><p>Date of:</p></td>
<td><p>2009</p></td>
</tr>
<tr>
<td><p>References:</p></td>
<td>Siggaard Andersen: OSA (2005), University of Copenhagen</td>
</tr>
</table>
<br/><p>Copyright &copy; 2014 Marek Matejak, Charles University in Prague.</p><br/>

</html>"));
      end BloodCO2Base;

      partial model BloodCO2TransportBase
        extends BloodCO2Base;

      Physiolibrary.Chemical.Interfaces.ChemicalPort_a q_in
        "CO2 inflow to ventilated alveols in mmol/ml" annotation (Placement(
            transformation(extent={{-120,-100},{-80,-60}}), iconTransformation(
              extent={{-120,-100},{-80,-60}})));
      Physiolibrary.Chemical.Interfaces.ChemicalPort_b q_out
        "CO2 outflow from ventilated alveols in mmol/ml" annotation (Placement(
            transformation(extent={{80,-100},{120,-60}}), iconTransformation(
              extent={{80,-100},{120,-60}})));
        Physiolibrary.Types.RealIO.VolumeFlowRateInput BloodFlow(
                                                final displayUnit="ml/min")
        "blood flow through ventilated alveols"
                                         annotation (Placement(transformation(extent={{-120,
                  -80},{-80,-40}}),     iconTransformation(extent={{-100,-10},{-80,10}})));
      equation
        q_in.conc = q_in.q/ BloodFlow; //mmol/l

        tCO2 = (-q_out.q/BloodFlow); //mmol/l

        annotation (Icon(coordinateSystem(preserveAspectRatio=true, extent={{-100,
                  -100},{100,100}}), graphics={
              Rectangle(
                extent={{-100,100},{100,-100}},
                lineColor={0,0,255},
                fillColor={215,215,215},
                fillPattern=FillPattern.Solid),
              Text(
                extent={{-74,-26},{74,-58}},
                lineColor={0,0,255},
                textString="%name"),
              Polygon(
                points={{-72,10},{80,0},{-72,-10},{-72,10}},
                lineColor={0,0,127},
                fillColor={255,255,255},
                fillPattern=FillPattern.Solid,
                origin={-2,-80},
                rotation=360)}),        Documentation(revisions="<html>

<table cellspacing=\"2\" cellpadding=\"0\" border=\"0\"><tr>
<td><p>Author:</p></td>
<td><p>Marek Matejak</p></td>
</tr>
<tr>
<td><p>License:</p></td>
<td><p><a href=\"http://www.physiomodel.org/license.html\">Physiomodel License 1.0</a> </p></td>
</tr>

<tr>
<td><p>Date of:</p></td>
<td><p>2009</p></td>
</tr>
<tr>
<td><p>References:</p></td>
<td>Siggaard Andersen: OSA (2005), University of Copenhagen</td>
</tr>
</table>
<br/><p>Copyright &copy; 2014 Marek Matejak, Charles University in Prague.</p><br/>

</html>"));
      end BloodCO2TransportBase;

      model CO2
       extends Physiolibrary.Icons.CarbonDioxide;
        Physiolibrary.Chemical.Components.Substance                veins(
                                                                 stateName=
              "CO2Veins.Mass[mMol]",
        useNormalizedVolume=false,
        solute_start=0.0869)
          annotation (Placement(transformation(extent={{-96,-14},{-76,6}})));
        Physiolibrary.Chemical.Components.Substance                artys(
                                                                 stateName=
              "CO2Artys.Mass[mMol]",
        useNormalizedVolume=false,
        solute_start=0.0343)
          annotation (Placement(transformation(extent={{92,-12},{72,8}})));
        TissuesWithInterstitium.TissuesCO2 CO2Tissues(
          skeletalMuscleCO2(vein(q(start=-14.5357))),
          liverCO2(vein(q(start=-31.11))),
          boneCO2(vein(q(start=-7.3))),
          brainCO2(vein(q(start=-18.5364)), tissueVeinsCO2(tCO2_P(start=27.1283))),
          otherTissueCO2(vein(q(start=-8.149))),
          GITractCO2(vein(q(start=-24.8656))),
          respiratoryMuscleCO2(vein(q(start=-2.26257))),
          kidneyCO2(vein(q(start=-26.7849))),
          fatCO2(vein(q(start=-5.277))),
          leftHeartCO2(vein(q(start=-4.84675))),
          rightHeartCO2(vein(q(start=-0.914))),
          skinCO2(vein(q(start=-3.5889))))
          annotation (Placement(transformation(extent={{-48,-40},{-28,-20}})));

          /*(
    skeletalMuscleCO2(tissueVeinsCO2(pCO2(start=6.079))),
    liverCO2(tissueVeinsCO2(pCO2(start=5.8879))),
    boneCO2(tissueVeinsCO2(pCO2(start=6.0267))),
    brainCO2(tissueVeinsCO2(pCO2(start=6.2398))),
    otherTissueCO2(tissueVeinsCO2(pCO2(start=5.7258))),
    GITractCO2(tissueVeinsCO2(pCO2(start=5.6768))),
    respiratoryMuscleCO2(tissueVeinsCO2(pCO2(start=6.34097))),
    kidneyCO2(tissueVeinsCO2(pCO2(start=5.51929))),
    fatCO2(tissueVeinsCO2(pCO2(start=5.6931))),
    leftHeartCO2(tissueVeinsCO2(pCO2(start=7.8986))),
    rightHeartCO2(tissueVeinsCO2(pCO2(start=7.9346))),
    skinCO2(tissueVeinsCO2(pCO2(start=5.9118))))*/

      Physiolibrary.Types.BusConnector busConnector annotation (Placement(
            transformation(extent={{-114,-62},{-74,-22}}), iconTransformation(
              extent={{60,40},{100,80}})));
        Physiolibrary.Chemical.Sources.UnlimitedGasStorage air(useHeatPort=true)
          annotation (Placement(transformation(extent={{-60,84},{-48,96}})));
      Ventilation.AlveolarVentilation alveolarVentilation annotation (Placement(
            transformation(
            extent={{-10,-10},{10,10}},
            origin={0,78})));                       /*(
    solventFlowPump(q_out(conc(start=0.05))))*/
      Physiolibrary.Chemical.Components.Stream pulmShortCircuit(
          useSolutionFlowInput=true)
        annotation (Placement(transformation(extent={{-22,14},{-2,-6}})));
        Modelica.Blocks.Math.Feedback pulmShortCircuitFlow
          annotation (Placement(transformation(extent={{10,-10},{-10,10}},
              rotation=270,
              origin={-12,-10})));
      //1000 * 1.977/40.01
        Physiomodel.Gases.CO2.MeassureBloodCO2 veinsCO2(tCO2_P(start=27.4), pCO2(
              start=6240))
          annotation (Placement(transformation(extent={{-96,22},{-76,42}})));
        Physiomodel.Gases.CO2.MeassureBloodCO2 artysCO2(tCO2_P(start=26), pCO2(start=5330))
          annotation (Placement(transformation(extent={{72,22},{92,42}})));

        Physiomodel.Gases.CO2.BloodCO2 CO2Lung(
          q_in(q(start=115.472)),
          tCO2_P(start=24.9),
        pCO2(start=5160))
          annotation (Placement(transformation(extent={{-10,22},{10,42}})));

      Physiolibrary.Chemical.Components.GasSolubility gasSolubility(
        useHeatPort=true,
          C=2400,
        kH_T0(displayUnit="(mmol/l)/(mmol/l)") = 0.604,
        solubilityRateCoef(displayUnit="m3/s") = 0.1,
        T0=310.15)
        annotation (Placement(transformation(extent={{-10,44},{10,64}})));
      Physiolibrary.Thermal.Sources.UnlimitedHeat environment(T=298.15)
        annotation (Placement(transformation(extent={{-90,64},{-70,84}})));
      Physiolibrary.Thermal.Sources.UnlimitedHeat alveolus(T=310.15)
        annotation (Placement(transformation(extent={{64,58},{84,78}})));
      equation
        connect(CO2Tissues.q_out, veins.q_out)   annotation (Line(
            points={{-50,-30},{-70,-30},{-70,-4},{-86,-4}},
            color={200,0,0},
            thickness=1,
            smooth=Smooth.None));
        connect(air.q_out, alveolarVentilation.inspired) annotation (Line(
            points={{-48,90},{-14,90},{-14,86},{-10,86}},
            color={200,0,0},
            thickness=1,
            smooth=Smooth.None));
        connect(air.q_out, alveolarVentilation.expired) annotation (Line(
            points={{-48,90},{14,90},{14,86},{10,86}},
            color={200,0,0},
            thickness=1,
            smooth=Smooth.None));
      connect(pulmShortCircuit.solutionFlow, pulmShortCircuitFlow.y)
        annotation (Line(
          points={{-12,-3},{-12,-3},{-12,-1},{-12,-1}},
          color={0,0,127},
          smooth=Smooth.None));
        connect(pulmShortCircuitFlow.u1, busConnector.CardiacOutput)
          annotation (Line(
            points={{-12,-18},{10,-18},{10,-42},{-94,-42}},
            color={0,0,127},
            smooth=Smooth.None), Text(
            string="%second",
            index=1,
            extent={{6,3},{6,3}}));
        connect(busConnector.AlveolarVentilated_BloodFlow, pulmShortCircuitFlow.u2)
          annotation (Line(
            points={{-94,-42},{-54,-42},{-54,-10},{-20,-10}},
            color={0,0,255},
            thickness=0.5,
            smooth=Smooth.None), Text(
            string="%first",
            index=-1,
            extent={{-6,3},{-6,3}}));
        connect(veins.q_out, pulmShortCircuit.q_in)    annotation (Line(
            points={{-86,-4},{-86,24},{-46,24},{-46,4},{-22,4}},
            color={200,0,0},
            thickness=1,
            smooth=Smooth.None));
        connect(pulmShortCircuit.q_out, artys.q_out)    annotation (Line(
            points={{-2,4},{24,4},{24,24},{82,24},{82,-2}},
            color={200,0,0},
            thickness=1,
            smooth=Smooth.None));
        connect(busConnector.Veins_pH, veinsCO2.pH)             annotation (
            Line(
            points={{-94,-42},{-100,-42},{-100,40},{-95,40}},
            color={0,0,255},
            thickness=0.5,
            smooth=Smooth.None), Text(
            string="%first",
            index=-1,
            extent={{-6,3},{-6,3}}));
        connect(busConnector.Veins_pH_ery, veinsCO2.pH_ery)
          annotation (Line(
            points={{-94,-42},{-100,-42},{-100,36},{-95,36}},
            color={0,0,255},
            thickness=0.5,
            smooth=Smooth.None), Text(
            string="%first",
            index=-1,
            extent={{-6,3},{-6,3}}));
        connect(veinsCO2.sO2, busConnector.O2Veins_sO2)             annotation (
            Line(
            points={{-77,32},{-54,32},{-54,-42},{-94,-42}},
            color={0,0,127},
            smooth=Smooth.None), Text(
            string="%second",
            index=1,
            extent={{6,3},{6,3}}));
        connect(veinsCO2.Hct, busConnector.BloodVol_Hct)             annotation (Line(
            points={{-77,36},{-54,36},{-54,-42},{-94,-42}},
            color={0,0,127},
            smooth=Smooth.None), Text(
            string="%second",
            index=1,
            extent={{6,3},{6,3}}));
        connect(veinsCO2.T, busConnector.core_T)
                                                annotation (Line(
            points={{-77,40},{-54,40},{-54,-42},{-94,-42}},
            color={0,0,127},
            smooth=Smooth.None), Text(
            string="%second",
            index=1,
            extent={{6,3},{6,3}}));
        connect(veinsCO2.cHCO3, busConnector.CO2Veins_cHCO3)
                                                            annotation (Line(
            points={{-78,20},{-78,14},{-100,14},{-100,-42},{-94,-42}},
            color={0,0,127},
            smooth=Smooth.None), Text(
            string="%second",
            index=1,
            extent={{3,-3},{3,-3}}));
        connect(veins.q_out, veinsCO2.q_in)   annotation (Line(
            points={{-86,-4},{-86,24}},
            color={200,0,0},
            thickness=1,
            smooth=Smooth.None));
        connect(busConnector.Artys_pH, artysCO2.pH)             annotation (
            Line(
            points={{-94,-42},{50,-42},{50,40},{73,40}},
            color={0,0,255},
            thickness=0.5,
            smooth=Smooth.None), Text(
            string="%first",
            index=-1,
            extent={{-6,3},{-6,3}}));
        connect(busConnector.Artys_pH_ery, artysCO2.pH_ery)
          annotation (Line(
            points={{-94,-42},{50,-42},{50,36},{73,36}},
            color={0,0,255},
            thickness=0.5,
            smooth=Smooth.None), Text(
            string="%first",
            index=-1,
            extent={{-6,3},{-6,3}}));
        connect(artysCO2.sO2, busConnector.O2Artys_sO2)             annotation (
            Line(
            points={{91,32},{100,32},{100,-42},{-94,-42}},
            color={0,0,127},
            smooth=Smooth.None), Text(
            string="%second",
            index=1,
            extent={{6,3},{6,3}}));
        connect(artysCO2.Hct, busConnector.BloodVol_Hct)             annotation (Line(
            points={{91,36},{100,36},{100,-42},{-94,-42}},
            color={0,0,127},
            smooth=Smooth.None), Text(
            string="%second",
            index=1,
            extent={{6,3},{6,3}}));
        connect(artysCO2.T, busConnector.core_T)       annotation (Line(
            points={{91,40},{100,40},{100,-42},{-94,-42}},
            color={0,0,127},
            smooth=Smooth.None), Text(
            string="%second",
            index=1,
            extent={{6,3},{6,3}}));
        connect(artysCO2.q_in, artys.q_out)    annotation (Line(
            points={{82,24},{82,-2}},
            color={200,0,0},
            thickness=1,
            smooth=Smooth.None));
        connect(artysCO2.cHCO3, busConnector.CO2Artys_cHCO3) annotation (Line(
            points={{90,20},{90,14},{100,14},{100,-42},{-94,-42}},
            color={0,0,127},
            smooth=Smooth.None), Text(
            string="%second",
            index=1,
            extent={{3,-3},{3,-3}}));
        connect(veinsCO2.pCO2, busConnector.CO2Veins_pCO2)     annotation (Line(
            points={{-82,20},{-82,16},{-100,16},{-100,-42},{-94,-42}},
            color={0,0,127},
            smooth=Smooth.None));
        connect(artysCO2.pCO2, busConnector.CO2Artys_pCO2) annotation (
            Line(
            points={{86,20},{86,12},{100,12},{100,-42},{-94,-42}},
            color={0,0,127},
            smooth=Smooth.None));
        connect(busConnector, CO2Tissues.busConnector) annotation (Line(
            points={{-94,-42},{-54,-42},{-54,-20.8},{-46.8,-20.8}},
            color={0,0,255},
            thickness=0.5,
            smooth=Smooth.None));
        connect(CO2Lung.sO2, busConnector.O2Lung_sO2)              annotation (
            Line(
            points={{9,32},{50,32},{50,-42},{-94,-42}},
            color={0,0,127},
            smooth=Smooth.None), Text(
            string="%second",
            index=1,
            extent={{6,3},{6,3}}));
        connect(busConnector.AlveolarVentilated_BloodFlow,CO2Lung. BloodFlow)
          annotation (Line(
            points={{-94,-42},{-54,-42},{-54,32},{-9,32}},
            color={0,0,255},
            thickness=0.5,
            smooth=Smooth.None), Text(
            string="%first",
            index=-1,
            extent={{-6,3},{-6,3}}));
        connect(CO2Lung.q_out, artys.q_out)                 annotation (Line(
            points={{10,24},{82,24},{82,-2}},
            color={200,0,0},
            thickness=1,
            smooth=Smooth.None));
        connect(CO2Lung.Hct, busConnector.BloodVol_Hct)              annotation (Line(
            points={{9,36},{50,36},{50,-42},{-94,-42}},
            color={0,0,127},
            smooth=Smooth.None), Text(
            string="%second",
            index=1,
            extent={{6,3},{6,3}}));
        connect(CO2Lung.T, busConnector.core_T) annotation (Line(
            points={{9,40},{50,40},{50,-42},{-94,-42}},
            color={0,0,127},
            smooth=Smooth.None), Text(
            string="%second",
            index=1,
            extent={{6,3},{6,3}}));
        connect(CO2Lung.pCO2, busConnector.CO2Lung_pCO2) annotation (Line(
            points={{4,20},{4,10},{10,10},{10,-42},{-94,-42}},
            color={0,0,127},
            smooth=Smooth.None), Text(
            string="%second",
            index=1,
            extent={{6,-5},{6,-5}}));
        connect(CO2Lung.cHCO3, busConnector.CO2Lung_cHCO3) annotation (Line(
            points={{8,20},{8,12},{10,12},{10,-42},{-94,-42}},
            color={0,0,127},
            smooth=Smooth.None));
        connect(veins.q_out, CO2Lung.q_in)    annotation (Line(
            points={{-86,-4},{-86,24},{-10,24}},
            color={200,0,0},
            thickness=1,
            smooth=Smooth.None));
        connect(busConnector.lungs_pH_plasma, CO2Lung.pH) annotation (Line(
            points={{-94,-42},{-54,-42},{-54,40},{-9,40}},
            color={0,0,255},
            thickness=0.5,
            smooth=Smooth.None), Text(
            string="%first",
            index=-1,
            extent={{-6,3},{-6,3}}));
        connect(busConnector.lungs_pH_ery, CO2Lung.pH_ery) annotation (Line(
            points={{-94,-42},{-54,-42},{-54,36},{-9,36}},
            color={0,0,255},
            thickness=0.5,
            smooth=Smooth.None), Text(
            string="%first",
            index=-1,
            extent={{-6,3},{-6,3}}));
        connect(alveolarVentilation.AlveolarVentilation_Env, busConnector.AlveolarVentilation_Env)
          annotation (Line(
            points={{8,80},{100,80},{100,-42},{-94,-42}},
            color={0,0,127},
            smooth=Smooth.None), Text(
            string="%second",
            index=1,
            extent={{6,3},{6,3}}));
        connect(artys.q_out, CO2Tissues.q_in) annotation (Line(
            points={{82,-2},{52,-2},{52,-30},{-26,-30}},
            color={200,0,0},
            thickness=1,
            smooth=Smooth.None));
        connect(alveolarVentilation.BronchiDilution, busConnector.BronchiDilution)
          annotation (Line(
            points={{8,74},{100,74},{100,-42},{-94,-42}},
            color={0,0,127},
            smooth=Smooth.None), Text(
            string="%second",
            index=1,
            extent={{6,3},{6,3}}));
      connect(alveolarVentilation.alveolar, gasSolubility.q_out) annotation (
          Line(
          points={{0.2,68},{0,68},{0,64}},
          color={107,45,134},
          thickness=1,
          smooth=Smooth.None));
      connect(CO2Lung.alveolar_outflow, gasSolubility.q_in) annotation (Line(
          points={{0,42},{0,46}},
          color={107,45,134},
          thickness=1,
          smooth=Smooth.None));
      connect(busConnector.VeinsVol, veins.solutionVolume) annotation (Line(
          points={{-94,-42},{-100,-42},{-100,0},{-90,0}},
          color={0,0,255},
          thickness=0.5,
          smooth=Smooth.None), Text(
          string="%first",
          index=-1,
          extent={{-6,3},{-6,3}}));
      connect(artys.solutionVolume, busConnector.ArtysVol) annotation (Line(
          points={{86,2},{100,2},{100,-42},{-94,-42}},
          color={0,0,127},
          smooth=Smooth.None), Text(
          string="%second",
          index=1,
          extent={{6,3},{6,3}}));
      connect(environment.port, air.heatPort) annotation (Line(
          points={{-70,74},{-54,74},{-54,90}},
          color={191,0,0},
          thickness=1,
          smooth=Smooth.None));
      connect(alveolus.port, gasSolubility.heatPort) annotation (Line(
          points={{84,68},{94,68},{94,54},{0,54}},
          color={191,0,0},
          thickness=1,
          smooth=Smooth.None));
        annotation ( Icon(coordinateSystem(
                preserveAspectRatio=true, extent={{-100,-100},{100,100}}),
              graphics={              Text(
                extent={{-116,-60},{126,-94}},
                lineColor={0,0,255},
                textString="%name")}),
          Documentation(revisions="<html>

<table cellspacing=\"2\" cellpadding=\"0\" border=\"0\"><tr>
<td><p>Author:</p></td>
<td><p>Marek Matejak</p></td>
</tr>
<tr>
<td><p>License:</p></td>
<td><p><a href=\"http://www.physiomodel.org/license.html\">Physiomodel License 1.0</a> </p></td>
</tr>

<tr>
<td><p>Date of:</p></td>
<td><p>2009</p></td>
</tr>
<tr>
<td><p>References:</p></td>
<td>Siggaard Andersen: OSA (2005), University of Copenhagen</td>
</tr>
<tr>
<td></td>
<td><p>Tom Coleman: QHP 2008 beta 3, University of Mississippi Medical Center</p></td>
</tr>
</table>
<br/><p>Copyright &copy; 2014 Marek Matejak, Charles University in Prague.</p><br/>

</html>"));
      end CO2;

      model MeassureBloodCO2
        extends BloodCO2Base;

      Physiolibrary.Chemical.Interfaces.ChemicalPort_a q_in annotation (
          Placement(transformation(extent={{80,-20},{120,20}}),
            iconTransformation(extent={{-20,-100},{20,-60}})));
      equation
        q_in.q=0;
        tCO2 = q_in.conc;// * MiniliterPerLiter;  //mmol/l

        annotation (Icon(coordinateSystem(preserveAspectRatio=true, extent={{-100,
                  -100},{100,100}}), graphics={Rectangle(
                extent={{-100,100},{100,-100}},
                lineColor={0,0,255},
                fillColor={215,215,215},
                fillPattern=FillPattern.Solid), Text(
                extent={{-74,-26},{74,-58}},
                lineColor={0,0,255},
                textString="%name")}));
      end MeassureBloodCO2;

      model TissueHCO3
        extends Physiomodel.Gases.CO2.HendersonHasselbach;
        import Modelica.Math;

      /*  Real pK;
  Real aCO2(final displayUnit="mmol/(l.kPa)");
  Real cdCO2(start=3,             final displayUnit="mmol/l");

  Real pCO2(displayUnit="kPa");

  constant Real MiniliterPerLiter(final displayUnit="ml/l")=1000;


  Library.Interfaces.RealOutput_ cHCO3(final displayUnit="mmol/l")
    "outgoing concentration of HCO3"                                                           annotation (Placement(
        transformation(extent={{20,-70},{60,-30}}), iconTransformation(
        extent={{-20,-20},{20,20}},
        rotation=270,
        origin={80,-120})));
  Library.Interfaces.RealInput_ T(final displayUnit="degC") "outgoing temperature" annotation (Placement(transformation(extent={{70,-26},
            {110,14}}),           iconTransformation(extent={{-10,-10},{10,10}},
        rotation=180,
        origin={90,80})));

  Library.Interfaces.RealInput_ pH "outgoing plasma pH" annotation (Placement(transformation(extent={{-120,50},
            {-80,90}}),           iconTransformation(extent={{-100,70},{-80,90}})));
*/
       Physiolibrary.Types.Concentration tCO2(final displayUnit="mmol/l");

       Physiolibrary.Types.RealIO.PressureInput pCO2_(       displayUnit="mmHg")
        "tissue venous partial pressure of CO2"
                                          annotation (Placement(transformation(
                extent={{20,-70},{60,-30}}), iconTransformation(
              extent={{-10,-10},{10,10}},
              origin={-90,42})));               //start=45,

      equation
        pCO2 = pCO2_;

        /*




  //Henderson-Hasselbalch equation:
  pK = 6.1 + (-0.0026)*(T-37);
  pH = pK + log10(max(1e-15,cHCO3/cdCO2));
  cdCO2 = aCO2*pCO2;
  aCO2 = 0.23 * 10^(-0.0092*(T-37)); //solubility depends on temperature

*/
        //total interstitial CO2 from SimpleCO2Solution
        tCO2 = cHCO3 + cdCO2;

        annotation (Icon(coordinateSystem(preserveAspectRatio=true, extent={{-100,
                  -100},{100,100}}), graphics={Rectangle(
                extent={{-100,100},{100,-100}},
                lineColor={0,0,255},
                fillColor={215,215,215},
                fillPattern=FillPattern.Solid), Text(
                extent={{-96,-40},{98,-68}},
                lineColor={0,0,255},
                textString="%name")}),        Documentation(revisions="<html>

<table cellspacing=\"2\" cellpadding=\"0\" border=\"0\"><tr>
<td><p>Author:</p></td>
<td><p>Marek Matejak</p></td>
</tr>
<tr>
<td><p>License:</p></td>
<td><p><a href=\"http://www.physiomodel.org/license.html\">Physiomodel License 1.0</a> </p></td>
</tr>

<tr>
<td><p>Date of:</p></td>
<td><p>2009</p></td>
</tr>
<tr>
<td><p>References:</p></td>
<td>Siggaard Andersen: OSA (2005), University of Copenhagen</td>
</tr>
</table>
<br/><p>Copyright &copy; 2014 Marek Matejak, Charles University in Prague.</p><br/>

</html>"));
      end TissueHCO3;

      model FlowMeasureCO2
        extends Physiomodel.Gases.CO2.BloodCO2Base;

        import Modelica.Math;
      /*
  Real tCO2_P(start=24,              final displayUnit="mmol/l");

  Real pK_ery;
  Real aCO2_ery(final displayUnit="mmol/l/mmHg");
  Real tCO2_ery(final displayUnit="mmol/l");

  Real tCO2(final displayUnit="mmol/l");

  constant Real MiniliterPerLiter(final displayUnit="ml/l")=1000;
*/
      Physiolibrary.Chemical.Interfaces.ChemicalPort_a q_in
        "CO2 inflow to ventilated alveols in mmol/ml" annotation (Placement(
            transformation(extent={{-120,-100},{-80,-60}}), iconTransformation(
              extent={{-120,-100},{-80,-60}})));
      /*  Library.Interfaces.RealInput_ pH_ery "outgoing intracellular erytrocytes pH"
                                  annotation (Placement(transformation(extent={{-120,10},
            {-80,50}}),           iconTransformation(extent={{-100,30},{-80,50}})));
  Library.Interfaces.RealInput_ Hct
    "outgoing hematocrit (erytrocytes volume/blood volume)"
                                   annotation (Placement(transformation(extent={{60,60},
            {100,100}}),          iconTransformation(
        extent={{-10,-10},{10,10}},
        rotation=180,
        origin={90,40})));
  Library.Interfaces.RealInput_ sO2 "outgoing oxygen saturation"
                                   annotation (Placement(transformation(extent={{60,20},
            {100,60}}),           iconTransformation(
        extent={{-10,-10},{10,10}},
        rotation=180,
        origin={90,0})));
*/
      Physiolibrary.Chemical.Interfaces.ChemicalPort_b q_out
        "CO2 outflow from ventilated alveols in mmol/ml" annotation (Placement(
            transformation(extent={{80,-100},{120,-60}}), iconTransformation(
              extent={{80,-100},{120,-60}})));
        Physiolibrary.Types.RealIO.VolumeFlowRateInput BloodFlow(
                                                displayUnit="ml/min")
        "blood flow through ventilated alveols"
                                         annotation (Placement(transformation(extent={{-120,
                  -80},{-80,-40}}),     iconTransformation(extent={{-100,-10},{-80,10}})));
      equation

        q_in.q + q_out.q = 0;
        q_in.conc = (q_in.q/BloodFlow);
        tCO2 = q_in.conc; //=(-q_out.q/BloodFlow);  //mmol/l

      /*
  //total plasma CO2 from SimpleCO2Solution
  tCO2_P = cHCO3 + cdCO2;

  //erythrocytes:
  pK_ery = 6.125 - log10(1+10^(pH_ery-7.84-0.06*sO2));
  tCO2_ery=aCO2_ery*pCO2*(1+10^(pH_ery-pK_ery));
  aCO2_ery=0.195; //solubility

  //plasma+erythrocyte
  tCO2 = tCO2_ery*Hct + tCO2_P*(1-Hct);
*/
        annotation (Icon(coordinateSystem(preserveAspectRatio=true, extent={{-100,
                  -100},{100,100}}), graphics={
              Rectangle(
                extent={{-100,100},{100,-100}},
                lineColor={0,0,255},
                fillColor={215,215,215},
                fillPattern=FillPattern.Solid),
              Text(
                extent={{-74,-26},{74,-58}},
                lineColor={0,0,255},
                textString="%name"),
              Polygon(
                points={{-72,10},{80,0},{-72,-10},{-72,10}},
                lineColor={0,0,127},
                fillColor={255,255,255},
                fillPattern=FillPattern.Solid,
                origin={-2,-80},
                rotation=360)}));
      end FlowMeasureCO2;

      package TissuesWithInterstitium

        model TissuesCO2
          import QHP = Physiomodel;
         extends Physiolibrary.Icons.Tissues;
        Physiolibrary.Chemical.Interfaces.ChemicalPort_a q_in annotation (
            Placement(transformation(extent={{80,-20},{120,20}}),
              iconTransformation(extent={{100,-20},{140,20}})));
        Physiolibrary.Chemical.Interfaces.ChemicalPort_b q_out annotation (
            Placement(transformation(extent={{-140,-20},{-100,20}}),
              iconTransformation(extent={{-140,-20},{-100,20}})));
          SkeletalMuscleCO2 skeletalMuscleCO2(      initialMass=323.9)
            annotation (Placement(transformation(extent={{-54,64},{-34,84}})));
          BoneCO2 boneCO2(                initialMass=56.2)
            annotation (Placement(transformation(extent={{-54,36},{-34,56}})));
          FatCO2 fatCO2(                 initialMass=39.8)
            annotation (Placement(transformation(extent={{-54,-54},{-34,-34}})));
          BrainCO2 brainCO2(               initialMass=19.1)
            annotation (Placement(transformation(extent={{52,20},{72,40}})));
          QHP.Gases.CO2.TissuesWithInterstitium.RightHeartCO2 rightHeartCO2(
                                                initialMass=0.6)
            annotation (Placement(transformation(extent={{52,-100},{72,-80}})));
          RespiratoryMuscleCO2 respiratoryMuscleCO2(   initialMass=48.1)
            annotation (Placement(transformation(extent={{-54,-24},{-34,-4}})));
          OtherTissueCO2 otherTissueCO2(         initialMass=50.7)
            annotation (Placement(transformation(extent={{-54,6},{-34,26}})));
          TissueCO2_liver liverCO2(        initialMass=22.8)
            annotation (Placement(transformation(extent={{52,50},{72,70}})));
          QHP.Gases.CO2.TissuesWithInterstitium.LeftHeartCO2 leftHeartCO2(
                                               initialMass=3.5)
            annotation (Placement(transformation(extent={{52,-70},{72,-50}})));
          QHP.Gases.CO2.TissuesWithInterstitium.KidneyCO2 kidneyCO2(
                                            initialMass=4.1)
            annotation (Placement(transformation(extent={{52,-40},{72,-20}})));
          QHP.Gases.CO2.TissuesWithInterstitium.GITractCO2 GITractCO2(
                                             initialMass=17.6)
            annotation (Placement(transformation(extent={{52,-10},{72,10}})));
        Physiolibrary.Types.BusConnector busConnector
          annotation (Placement(transformation(extent={{-108,72},{-68,112}})));
          SkinCO2 skinCO2(                initialMass=28.2)
            annotation (Placement(transformation(extent={{-54,-84},{-34,-64}})));

          Physiolibrary.Types.MolarFlowRate CO2FromTissues(displayUnit="mmol/min");
        equation
          CO2FromTissues = -( q_out.q + q_in.q);
          connect(q_out, skeletalMuscleCO2.vein) annotation (Line(
              points={{-120,0},{-82,0},{-82,75},{-54,75}},
              color={200,0,0},
              thickness=1,
              smooth=Smooth.None));
          connect(q_out, boneCO2.vein) annotation (Line(
              points={{-120,0},{-82,0},{-82,47},{-54,47}},
              color={200,0,0},
              thickness=1,
              smooth=Smooth.None));
          connect(q_out, otherTissueCO2.vein) annotation (Line(
              points={{-120,0},{-82,0},{-82,17},{-54,17}},
              color={200,0,0},
              thickness=1,
              smooth=Smooth.None));
          connect(q_out, respiratoryMuscleCO2.vein) annotation (Line(
              points={{-120,0},{-81,0},{-81,-13},{-54,-13}},
              color={200,0,0},
              thickness=1,
              smooth=Smooth.None));
          connect(q_out, fatCO2.vein) annotation (Line(
              points={{-120,0},{-82,0},{-82,-43},{-54,-43}},
              color={200,0,0},
              thickness=1,
              smooth=Smooth.None));
          connect(q_out, skinCO2.vein) annotation (Line(
              points={{-120,0},{-82,0},{-82,-73},{-54,-73}},
              color={200,0,0},
              thickness=1,
              smooth=Smooth.None));
          connect(q_out, liverCO2.vein) annotation (Line(
              points={{-120,0},{-82,0},{-82,61},{52,61}},
              color={200,0,0},
              thickness=1,
              smooth=Smooth.None));
          connect(q_out, brainCO2.vein) annotation (Line(
              points={{-120,0},{-82,0},{-82,31},{52,31}},
              color={200,0,0},
              thickness=1,
              smooth=Smooth.None));
          connect(q_out, kidneyCO2.vein) annotation (Line(
              points={{-120,0},{-82,0},{-82,-29},{52,-29}},
              color={200,0,0},
              thickness=1,
              smooth=Smooth.None));
          connect(q_out, leftHeartCO2.vein) annotation (Line(
              points={{-120,0},{-82,0},{-82,-59},{52,-59}},
              color={200,0,0},
              thickness=1,
              smooth=Smooth.None));

          connect(skeletalMuscleCO2.arty, q_in) annotation (Line(
              points={{-34,75},{84,75},{84,0},{100,0}},
              color={200,0,0},
              thickness=1,
              smooth=Smooth.None));
          connect(brainCO2.arty, q_in) annotation (Line(
              points={{72,31},{84,31},{84,0},{100,0}},
              color={200,0,0},
              thickness=1,
              smooth=Smooth.None));
          connect(GITractCO2.arty, q_in) annotation (Line(
              points={{72,1},{72,0},{100,0}},
              color={200,0,0},
              thickness=1,
              smooth=Smooth.None));
          connect(kidneyCO2.arty, q_in) annotation (Line(
              points={{72,-29},{84,-29},{84,0},{100,0}},
              color={200,0,0},
              thickness=1,
              smooth=Smooth.None));
          connect(leftHeartCO2.arty, q_in) annotation (Line(
              points={{72,-59},{84,-59},{84,0},{100,0}},
              color={200,0,0},
              thickness=1,
              smooth=Smooth.None));
          connect(rightHeartCO2.arty, q_in) annotation (Line(
              points={{72,-89},{84,-89},{84,0},{100,0}},
              color={200,0,0},
              thickness=1,
              smooth=Smooth.None));
          connect(rightHeartCO2.vein, q_out) annotation (Line(
              points={{52,-89},{-82,-89},{-82,0},{-120,0}},
              color={200,0,0},
              thickness=1,
              smooth=Smooth.None));
          connect(boneCO2.arty, q_in) annotation (Line(
              points={{-34,47},{84,47},{84,0},{100,0}},
              color={200,0,0},
              thickness=1,
              smooth=Smooth.None));
          connect(otherTissueCO2.arty, q_in) annotation (Line(
              points={{-34,17},{84,17},{84,0},{100,0}},
              color={200,0,0},
              thickness=1,
              smooth=Smooth.None));
          connect(fatCO2.arty, q_in) annotation (Line(
              points={{-34,-43},{84,-43},{84,0},{100,0}},
              color={200,0,0},
              thickness=1,
              smooth=Smooth.None));
          connect(skinCO2.arty, q_in) annotation (Line(
              points={{-34,-73},{84,-73},{84,0},{100,0}},
              color={200,0,0},
              thickness=1,
              smooth=Smooth.None));
          connect(q_in, respiratoryMuscleCO2.arty) annotation (Line(
              points={{100,0},{84,0},{84,-13},{-34,-13}},
              color={200,0,0},
              thickness=1,
              smooth=Smooth.None));

          connect(busConnector.bone_pH_plasma, boneCO2.pH_plasma)      annotation (
             Line(
              points={{-88,92},{-88,44},{-53,44}},
              color={0,127,0},
              smooth=Smooth.None), Text(
              string="%first",
              index=-1,
              extent={{-5,2},{-5,2}}));
          connect(busConnector.brain_pH_plasma, brainCO2.pH_plasma)
            annotation (Line(
              points={{-88,92},{6,92},{6,28},{53,28}},
              color={0,127,0},
              smooth=Smooth.None), Text(
              string="%first",
              index=-1,
              extent={{-5,2},{-5,2}}));
          connect(busConnector.fat_pH_plasma, fatCO2.pH_plasma)      annotation (
              Line(
              points={{-88,92},{-88,-46},{-53,-46}},
              color={0,127,0},
              smooth=Smooth.None), Text(
              string="%first",
              index=-1,
              extent={{-5,2},{-5,2}}));
          connect(busConnector.GITract_pH_plasma, GITractCO2.pH_plasma)
            annotation (Line(
              points={{-88,92},{6,92},{6,-2},{53,-2}},
              color={0,127,0},
              smooth=Smooth.None), Text(
              string="%first",
              index=-1,
              extent={{-5,2},{-5,2}}));
          connect(busConnector.kidney_pH_plasma, kidneyCO2.pH_plasma)
            annotation (Line(
              points={{-88,92},{6,92},{6,-32},{53,-32}},
              color={0,127,0},
              smooth=Smooth.None), Text(
              string="%first",
              index=-1,
              extent={{-5,2},{-5,2}}));
          connect(busConnector.leftHeart_pH_plasma, leftHeartCO2.pH_plasma)
            annotation (Line(
              points={{-88,92},{6,92},{6,-62},{53,-62}},
              color={0,127,0},
              smooth=Smooth.None), Text(
              string="%first",
              index=-1,
              extent={{-5,2},{-5,2}}));
          connect(busConnector.liver_pH_plasma, liverCO2.pH_plasma)
            annotation (Line(
              points={{-88,92},{6,92},{6,58},{53,58}},
              color={0,127,0},
              smooth=Smooth.None), Text(
              string="%first",
              index=-1,
              extent={{-5,2},{-5,2}}));
          connect(busConnector.otherTissue_pH_plasma, otherTissueCO2.pH_plasma)
            annotation (Line(
              points={{-88,92},{-88,14},{-53,14}},
              color={0,127,0},
              smooth=Smooth.None), Text(
              string="%first",
              index=-1,
              extent={{-5,2},{-5,2}}));
          connect(busConnector.respiratoryMuscle_pH_plasma,
            respiratoryMuscleCO2.pH_plasma)
            annotation (Line(
              points={{-88,92},{-88,-16},{-53,-16}},
              color={0,127,0},
              smooth=Smooth.None), Text(
              string="%first",
              index=-1,
              extent={{-5,2},{-5,2}}));
          connect(busConnector.rightHeart_pH_plasma, rightHeartCO2.pH_plasma)
            annotation (Line(
              points={{-88,92},{6,92},{6,-92},{53,-92}},
              color={0,127,0},
              smooth=Smooth.None), Text(
              string="%first",
              index=-1,
              extent={{-5,2},{-5,2}}));
          connect(busConnector.skin_pH_plasma, skinCO2.pH_plasma)      annotation (
             Line(
              points={{-88,92},{-88,-76},{-53,-76}},
              color={0,127,0},
              smooth=Smooth.None), Text(
              string="%first",
              index=-1,
              extent={{-5,2},{-5,2}}));
          connect(busConnector.skeletalMuscle_pH_plasma, skeletalMuscleCO2.pH_plasma)
            annotation (Line(
              points={{-88,92},{-87.5,92},{-87.5,72},{-53,72}},
              color={127,0,0},
              smooth=Smooth.None), Text(
              string="%first",
              index=-1,
              extent={{-5,2},{-5,2}}));

          connect(busConnector.bone_pH_ery, boneCO2.pH_ery)      annotation (
             Line(
              points={{-88,92},{-88,56},{-53,56}},
              color={0,127,0},
              smooth=Smooth.None), Text(
              string="%first",
              index=-1,
              extent={{-5,2},{-5,2}}));
          connect(busConnector.brain_pH_ery, brainCO2.pH_ery)
            annotation (Line(
              points={{-88,92},{6,92},{6,40},{53,40}},
              color={0,127,0},
              smooth=Smooth.None), Text(
              string="%first",
              index=-1,
              extent={{-5,2},{-5,2}}));
          connect(busConnector.fat_pH_ery, fatCO2.pH_ery)      annotation (
              Line(
              points={{-88,92},{-88,-34},{-53,-34}},
              color={0,127,0},
              smooth=Smooth.None), Text(
              string="%first",
              index=-1,
              extent={{-5,2},{-5,2}}));
          connect(busConnector.GITract_pH_ery, GITractCO2.pH_ery)
            annotation (Line(
              points={{-88,92},{6,92},{6,10},{53,10}},
              color={0,127,0},
              smooth=Smooth.None), Text(
              string="%first",
              index=-1,
              extent={{-5,2},{-5,2}}));
          connect(busConnector.kidney_pH_ery, kidneyCO2.pH_ery)
            annotation (Line(
              points={{-88,92},{6,92},{6,-20},{53,-20}},
              color={0,127,0},
              smooth=Smooth.None), Text(
              string="%first",
              index=-1,
              extent={{-5,2},{-5,2}}));
          connect(busConnector.leftHeart_pH_ery, leftHeartCO2.pH_ery)
            annotation (Line(
              points={{-88,92},{6,92},{6,-50},{53,-50}},
              color={0,127,0},
              smooth=Smooth.None), Text(
              string="%first",
              index=-1,
              extent={{-5,2},{-5,2}}));
          connect(busConnector.liver_pH_ery, liverCO2.pH_ery)
            annotation (Line(
              points={{-88,92},{6,92},{6,70},{53,70}},
              color={0,127,0},
              smooth=Smooth.None), Text(
              string="%first",
              index=-1,
              extent={{-5,2},{-5,2}}));
          connect(busConnector.otherTissue_pH_ery, otherTissueCO2.pH_ery)
            annotation (Line(
              points={{-88,92},{-88,26},{-53,26}},
              color={0,127,0},
              smooth=Smooth.None), Text(
              string="%first",
              index=-1,
              extent={{-5,2},{-5,2}}));
          connect(busConnector.respiratoryMuscle_pH_ery, respiratoryMuscleCO2.pH_ery)
            annotation (Line(
              points={{-88,92},{-88,-4},{-53,-4}},
              color={0,127,0},
              smooth=Smooth.None), Text(
              string="%first",
              index=-1,
              extent={{-5,2},{-5,2}}));
          connect(busConnector.rightHeart_pH_ery, rightHeartCO2.pH_ery)
            annotation (Line(
              points={{-88,92},{6,92},{6,-80},{53,-80}},
              color={0,127,0},
              smooth=Smooth.None), Text(
              string="%first",
              index=-1,
              extent={{-5,2},{-5,2}}));
          connect(busConnector.skin_pH_ery, skinCO2.pH_ery)      annotation (
             Line(
              points={{-88,92},{-88,-64},{-53,-64}},
              color={0,127,0},
              smooth=Smooth.None), Text(
              string="%first",
              index=-1,
              extent={{-5,2},{-5,2}}));
          connect(busConnector.skeletalMuscle_pH_ery, skeletalMuscleCO2.pH_ery)
            annotation (Line(
              points={{-88,92},{-87.5,92},{-87.5,84},{-53,84}},
              color={127,0,0},
              smooth=Smooth.None), Text(
              string="%first",
              index=-1,
              extent={{-5,2},{-5,2}}));

          connect(busConnector.bone_sO2, boneCO2.sO2)        annotation (
             Line(
              points={{-88,92},{-88,52},{-53,52}},
              color={0,127,0},
              smooth=Smooth.None), Text(
              string="%first",
              index=-1,
              extent={{-5,2},{-5,2}}));
          connect(busConnector.brain_sO2, brainCO2.sO2)
            annotation (Line(
              points={{-88,92},{6,92},{6,36},{53,36}},
              color={0,127,0},
              smooth=Smooth.None), Text(
              string="%first",
              index=-1,
              extent={{-5,2},{-5,2}}));
          connect(busConnector.fat_sO2, fatCO2.sO2)      annotation (
              Line(
              points={{-88,92},{-88,-38},{-53,-38}},
              color={0,127,0},
              smooth=Smooth.None), Text(
              string="%first",
              index=-1,
              extent={{-5,2},{-5,2}}));
          connect(busConnector.GITract_sO2, GITractCO2.sO2)
            annotation (Line(
              points={{-88,92},{6,92},{6,6},{53,6}},
              color={0,127,0},
              smooth=Smooth.None), Text(
              string="%first",
              index=-1,
              extent={{-5,2},{-5,2}}));
          connect(busConnector.kidney_sO2, kidneyCO2.sO2)
            annotation (Line(
              points={{-88,92},{6,92},{6,-24},{53,-24}},
              color={0,127,0},
              smooth=Smooth.None), Text(
              string="%first",
              index=-1,
              extent={{-5,2},{-5,2}}));
          connect(busConnector.leftHeart_sO2, leftHeartCO2.sO2)
            annotation (Line(
              points={{-88,92},{6,92},{6,-54},{53,-54}},
              color={0,127,0},
              smooth=Smooth.None), Text(
              string="%first",
              index=-1,
              extent={{-5,2},{-5,2}}));
          connect(busConnector.liver_sO2, liverCO2.sO2)
            annotation (Line(
              points={{-88,92},{6,92},{6,66},{53,66}},
              color={0,127,0},
              smooth=Smooth.None), Text(
              string="%first",
              index=-1,
              extent={{-5,2},{-5,2}}));
          connect(busConnector.otherTissue_sO2, otherTissueCO2.sO2)
            annotation (Line(
              points={{-88,92},{-88,22},{-53,22}},
              color={0,127,0},
              smooth=Smooth.None), Text(
              string="%first",
              index=-1,
              extent={{-5,2},{-5,2}}));
          connect(busConnector.respiratoryMuscle_sO2, respiratoryMuscleCO2.sO2)
            annotation (Line(
              points={{-88,92},{-88,-8},{-53,-8}},
              color={0,127,0},
              smooth=Smooth.None), Text(
              string="%first",
              index=-1,
              extent={{-5,2},{-5,2}}));
          connect(busConnector.rightHeart_sO2, rightHeartCO2.sO2)
            annotation (Line(
              points={{-88,92},{6,92},{6,-84},{53,-84}},
              color={0,127,0},
              smooth=Smooth.None), Text(
              string="%first",
              index=-1,
              extent={{-5,2},{-5,2}}));
          connect(busConnector.skin_sO2, skinCO2.sO2)      annotation (
             Line(
              points={{-88,92},{-88,-68},{-53,-68}},
              color={0,127,0},
              smooth=Smooth.None), Text(
              string="%first",
              index=-1,
              extent={{-5,2},{-5,2}}));
          connect(busConnector.skeletalMuscle_sO2, skeletalMuscleCO2.sO2)
            annotation (Line(
              points={{-88,92},{-87.5,92},{-87.5,80},{-53,80}},
              color={127,0,0},
              smooth=Smooth.None), Text(
              string="%first",
              index=-1,
              extent={{-5,2},{-5,2}}));

          connect(busConnector.BloodVol_Hct, boneCO2.Hct)      annotation (
             Line(
              points={{-88,92},{-88,40},{-53,40}},
              color={0,127,0},
              smooth=Smooth.None), Text(
              string="%first",
              index=-1,
              extent={{-5,2},{-5,2}}));
          connect(busConnector.BloodVol_Hct, brainCO2.Hct)
            annotation (Line(
              points={{-88,92},{6,92},{6,24},{53,24}},
              color={0,127,0},
              smooth=Smooth.None), Text(
              string="%first",
              index=-1,
              extent={{-5,2},{-5,2}}));
          connect(busConnector.BloodVol_Hct, fatCO2.Hct)      annotation (
              Line(
              points={{-88,92},{-88,-50},{-53,-50}},
              color={0,127,0},
              smooth=Smooth.None), Text(
              string="%first",
              index=-1,
              extent={{-5,2},{-5,2}}));
          connect(busConnector.BloodVol_Hct, GITractCO2.Hct)
            annotation (Line(
              points={{-88,92},{6,92},{6,-6},{53,-6}},
              color={0,127,0},
              smooth=Smooth.None), Text(
              string="%first",
              index=-1,
              extent={{-5,2},{-5,2}}));
          connect(busConnector.BloodVol_Hct, kidneyCO2.Hct)
            annotation (Line(
              points={{-88,92},{6,92},{6,-36},{53,-36}},
              color={0,127,0},
              smooth=Smooth.None), Text(
              string="%first",
              index=-1,
              extent={{-5,2},{-5,2}}));
          connect(busConnector.BloodVol_Hct, leftHeartCO2.Hct)
            annotation (Line(
              points={{-88,92},{6,92},{6,-66},{53,-66}},
              color={0,127,0},
              smooth=Smooth.None), Text(
              string="%first",
              index=-1,
              extent={{-5,2},{-5,2}}));
          connect(busConnector.BloodVol_Hct, liverCO2.Hct)
            annotation (Line(
              points={{-88,92},{6,92},{6,54},{53,54}},
              color={0,127,0},
              smooth=Smooth.None), Text(
              string="%first",
              index=-1,
              extent={{-5,2},{-5,2}}));
          connect(busConnector.BloodVol_Hct, otherTissueCO2.Hct)
            annotation (Line(
              points={{-88,92},{-88,10},{-53,10}},
              color={0,127,0},
              smooth=Smooth.None), Text(
              string="%first",
              index=-1,
              extent={{-5,2},{-5,2}}));
          connect(busConnector.BloodVol_Hct, respiratoryMuscleCO2.Hct)
            annotation (Line(
              points={{-88,92},{-88,-20},{-53,-20}},
              color={0,127,0},
              smooth=Smooth.None), Text(
              string="%first",
              index=-1,
              extent={{-5,2},{-5,2}}));
          connect(busConnector.BloodVol_Hct, rightHeartCO2.Hct)
            annotation (Line(
              points={{-88,92},{6,92},{6,-96},{53,-96}},
              color={0,127,0},
              smooth=Smooth.None), Text(
              string="%first",
              index=-1,
              extent={{-5,2},{-5,2}}));
          connect(busConnector.BloodVol_Hct, skinCO2.Hct)      annotation (
             Line(
              points={{-88,92},{-88,-80},{-53,-80}},
              color={0,127,0},
              smooth=Smooth.None), Text(
              string="%first",
              index=-1,
              extent={{-5,2},{-5,2}}));
          connect(busConnector.BloodVol_Hct, skeletalMuscleCO2.Hct)
            annotation (Line(
              points={{-88,92},{-87.5,92},{-87.5,68},{-53,68}},
              color={127,0,0},
              smooth=Smooth.None), Text(
              string="%first",
              index=-1,
              extent={{-5,2},{-5,2}}));

          connect(boneCO2.Tissue_CO2FromMetabolism, busConnector.bone_CO2FromMetabolism)    annotation (
             Line(
              points={{-35,44},{6,44},{6,92},{-88,92}},
              color={0,127,0},
              smooth=Smooth.None), Text(
              string="%second",
              index=1,
              extent={{5,2},{5,2}}));
          connect(brainCO2.Tissue_CO2FromMetabolism, busConnector.brain_CO2FromMetabolism)
            annotation (Line(
              points={{71,28},{98,28},{98,92},{-88,92}},
              color={0,127,0},
              smooth=Smooth.None), Text(
              string="%second",
              index=1,
              extent={{5,2},{5,2}}));
          connect(fatCO2.Tissue_CO2FromMetabolism, busConnector.fat_CO2FromMetabolism)     annotation (
              Line(
              points={{-35,-46},{6,-46},{6,92},{-88,92}},
              color={0,127,0},
              smooth=Smooth.None), Text(
              string="%second",
              index=1,
              extent={{5,2},{5,2}}));
          connect(GITractCO2.Tissue_CO2FromMetabolism, busConnector.GITract_CO2FromMetabolism)
            annotation (Line(
              points={{71,-2},{98,-2},{98,92},{-88,92}},
              color={0,127,0},
              smooth=Smooth.None), Text(
              string="%second",
              index=1,
              extent={{5,2},{5,2}}));
          connect(kidneyCO2.Tissue_CO2FromMetabolism, busConnector.kidney_CO2FromMetabolism)
            annotation (Line(
              points={{71,-32},{98,-32},{98,92},{-88,92}},
              color={0,127,0},
              smooth=Smooth.None), Text(
              string="%second",
              index=1,
              extent={{5,2},{5,2}}));
          connect(leftHeartCO2.Tissue_CO2FromMetabolism, busConnector.leftHeart_CO2FromMetabolism)
            annotation (Line(
              points={{71,-62},{98,-62},{98,92},{-88,92}},
              color={0,127,0},
              smooth=Smooth.None), Text(
              string="%second",
              index=1,
              extent={{5,2},{5,2}}));
          connect(liverCO2.Tissue_CO2FromMetabolism, busConnector.liver_CO2FromMetabolism)
            annotation (Line(
              points={{71,56},{98,56},{98,92},{-88,92}},
              color={0,127,0},
              smooth=Smooth.None), Text(
              string="%second",
              index=1,
              extent={{5,2},{5,2}}));
          connect(otherTissueCO2.Tissue_CO2FromMetabolism, busConnector.otherTissue_CO2FromMetabolism)
            annotation (Line(
              points={{-35,14},{6,14},{6,92},{-88,92}},
              color={0,127,0},
              smooth=Smooth.None), Text(
              string="%second",
              index=1,
              extent={{5,2},{5,2}}));
          connect(respiratoryMuscleCO2.Tissue_CO2FromMetabolism, busConnector.respiratoryMuscle_CO2FromMetabolism)
            annotation (Line(
              points={{-35,-16},{6,-16},{6,92},{-88,92}},
              color={0,127,0},
              smooth=Smooth.None), Text(
              string="%second",
              index=1,
              extent={{5,2},{5,2}}));
          connect(rightHeartCO2.Tissue_CO2FromMetabolism, busConnector.rightHeart_CO2FromMetabolism)
            annotation (Line(
              points={{71,-92},{98,-92},{98,92},{-88,92}},
              color={0,127,0},
              smooth=Smooth.None), Text(
              string="%second",
              index=1,
              extent={{5,2},{5,2}}));
          connect(skinCO2.Tissue_CO2FromMetabolism, busConnector.skin_CO2FromMetabolism)     annotation (
             Line(
              points={{-35,-76},{6,-76},{6,92},{-88,92}},
              color={0,127,0},
              smooth=Smooth.None), Text(
              string="%second",
              index=1,
              extent={{5,2},{5,2}}));
          connect(skeletalMuscleCO2.Tissue_CO2FromMetabolism, busConnector.skeletalMuscle_CO2FromMetabolism)
            annotation (Line(
              points={{-35,72},{5.5,72},{5.5,92},{-88,92}},
              color={127,0,0},
              smooth=Smooth.None), Text(
              string="%second",
              index=1,
              extent={{5,2},{5,2}}));

          connect(boneCO2.BloodFlow, busConnector.bone_BloodFlow)        annotation (
             Line(
              points={{-35,51.4},{6,51.4},{6,92},{-88,92}},
              color={0,127,0},
              smooth=Smooth.None), Text(
              string="%second",
              index=1,
              extent={{5,2},{5,2}}));
          connect(brainCO2.BloodFlow, busConnector.brain_BloodFlow)
            annotation (Line(
              points={{71,35.4},{98,35.4},{98,92},{-88,92}},
              color={0,127,0},
              smooth=Smooth.None), Text(
              string="%second",
              index=1,
              extent={{5,2},{5,2}}));
          connect(fatCO2.BloodFlow, busConnector.fat_BloodFlow)     annotation (
              Line(
              points={{-35,-38.6},{6,-38.6},{6,92},{-88,92}},
              color={0,127,0},
              smooth=Smooth.None), Text(
              string="%second",
              index=1,
              extent={{5,2},{5,2}}));
          connect(GITractCO2.BloodFlow, busConnector.GITract_BloodFlow)
            annotation (Line(
              points={{71,5.4},{98,5.4},{98,92},{-88,92}},
              color={0,127,0},
              smooth=Smooth.None), Text(
              string="%second",
              index=1,
              extent={{5,2},{5,2}}));
          connect(kidneyCO2.BloodFlow, busConnector.kidney_BloodFlow)
            annotation (Line(
              points={{71,-24.6},{98,-24.6},{98,92},{-88,92}},
              color={0,127,0},
              smooth=Smooth.None), Text(
              string="%second",
              index=1,
              extent={{5,2},{5,2}}));
          connect(leftHeartCO2.BloodFlow, busConnector.leftHeart_BloodFlow)
            annotation (Line(
              points={{71,-54.6},{98,-54.6},{98,92},{-88,92}},
              color={0,127,0},
              smooth=Smooth.None), Text(
              string="%second",
              index=1,
              extent={{5,2},{5,2}}));
          connect(otherTissueCO2.BloodFlow, busConnector.otherTissue_BloodFlow)
            annotation (Line(
              points={{-35,21.4},{6,21.4},{6,92},{-88,92}},
              color={0,127,0},
              smooth=Smooth.None), Text(
              string="%second",
              index=1,
              extent={{5,2},{5,2}}));
          connect(respiratoryMuscleCO2.BloodFlow, busConnector.respiratoryMuscle_BloodFlow)
            annotation (Line(
              points={{-35,-8.6},{6,-8.6},{6,92},{-88,92}},
              color={0,127,0},
              smooth=Smooth.None), Text(
              string="%second",
              index=1,
              extent={{5,2},{5,2}}));
          connect(rightHeartCO2.BloodFlow, busConnector.rightHeart_BloodFlow)
            annotation (Line(
              points={{71,-84.6},{98,-84.6},{98,92},{-88,92}},
              color={0,127,0},
              smooth=Smooth.None), Text(
              string="%second",
              index=1,
              extent={{5,2},{5,2}}));
          connect(skinCO2.BloodFlow, busConnector.skin_BloodFlow)     annotation (
             Line(
              points={{-35,-68.6},{6,-68.6},{6,92},{-88,92}},
              color={0,127,0},
              smooth=Smooth.None), Text(
              string="%second",
              index=1,
              extent={{5,2},{5,2}}));
          connect(skeletalMuscleCO2.BloodFlow, busConnector.skeletalMuscle_BloodFlow)
            annotation (Line(
              points={{-35,79.4},{5.5,79.4},{5.5,92},{-88,92}},
              color={127,0,0},
              smooth=Smooth.None), Text(
              string="%second",
              index=1,
              extent={{5,2},{5,2}}));

          connect(boneCO2.T, busConnector.bone_T)       annotation (
             Line(
              points={{-35,40},{6,40},{6,92},{-88,92}},
              color={0,127,0},
              smooth=Smooth.None), Text(
              string="%second",
              index=1,
              extent={{5,2},{5,2}}));
          connect(brainCO2.T, busConnector.brain_T)
            annotation (Line(
              points={{71,24},{98,24},{98,92},{-88,92}},
              color={0,127,0},
              smooth=Smooth.None), Text(
              string="%second",
              index=1,
              extent={{5,2},{5,2}}));
          connect(fatCO2.T, busConnector.fat_T)     annotation (
              Line(
              points={{-35,-50},{6,-50},{6,92},{-88,92}},
              color={0,127,0},
              smooth=Smooth.None), Text(
              string="%second",
              index=1,
              extent={{5,2},{5,2}}));
          connect(GITractCO2.T, busConnector.GITract_T)
            annotation (Line(
              points={{71,-6},{98,-6},{98,92},{-88,92}},
              color={0,127,0},
              smooth=Smooth.None), Text(
              string="%second",
              index=1,
              extent={{5,2},{5,2}}));
          connect(kidneyCO2.T, busConnector.kidney_T)
            annotation (Line(
              points={{71,-36},{98,-36},{98,92},{-88,92}},
              color={0,127,0},
              smooth=Smooth.None), Text(
              string="%second",
              index=1,
              extent={{5,2},{5,2}}));
          connect(leftHeartCO2.T, busConnector.leftHeart_T)
            annotation (Line(
              points={{71,-66},{98,-66},{98,92},{-88,92}},
              color={0,127,0},
              smooth=Smooth.None), Text(
              string="%second",
              index=1,
              extent={{5,2},{5,2}}));
          connect(liverCO2.T, busConnector.liver_T)
            annotation (Line(
              points={{71,65.8},{98,65.8},{98,92},{-88,92}},
              color={0,127,0},
              smooth=Smooth.None), Text(
              string="%second",
              index=1,
              extent={{5,2},{5,2}}));
          connect(otherTissueCO2.T, busConnector.otherTissue_T)
            annotation (Line(
              points={{-35,10},{6,10},{6,92},{-88,92}},
              color={0,127,0},
              smooth=Smooth.None), Text(
              string="%second",
              index=1,
              extent={{5,2},{5,2}}));
          connect(respiratoryMuscleCO2.T, busConnector.respiratoryMuscle_T)
            annotation (Line(
              points={{-35,-20},{6,-20},{6,92},{-88,92}},
              color={0,127,0},
              smooth=Smooth.None), Text(
              string="%second",
              index=1,
              extent={{5,2},{5,2}}));
          connect(rightHeartCO2.T, busConnector.rightHeart_T)
            annotation (Line(
              points={{71,-96},{98,-96},{98,92},{-88,92}},
              color={0,127,0},
              smooth=Smooth.None), Text(
              string="%second",
              index=1,
              extent={{5,2},{5,2}}));
          connect(skinCO2.T, busConnector.skin_T)     annotation (
             Line(
              points={{-35,-80},{6,-80},{6,92},{-88,92}},
              color={0,127,0},
              smooth=Smooth.None), Text(
              string="%second",
              index=1,
              extent={{5,2},{5,2}}));
          connect(skeletalMuscleCO2.T, busConnector.skeletalMuscle_T)
            annotation (Line(
              points={{-35,68},{5.5,68},{5.5,92},{-88,92}},
              color={127,0,0},
              smooth=Smooth.None), Text(
              string="%second",
              index=1,
              extent={{5,2},{5,2}}));

          connect(boneCO2.pCO2, busConnector.bone.pCO2)       annotation (
             Line(
              points={{-44,35},{6,35},{6,92},{-88,92}},
              color={0,127,0},
              smooth=Smooth.None));
          connect(brainCO2.pCO2, busConnector.brain.pCO2)
            annotation (Line(
              points={{62,19},{98,19},{98,92},{-88,92}},
              color={0,127,0},
              smooth=Smooth.None));
          connect(fatCO2.pCO2, busConnector.fat.pCO2)     annotation (
              Line(
              points={{-44,-55},{6,-55},{6,92},{-88,92}},
              color={0,127,0},
              smooth=Smooth.None));
          connect(GITractCO2.pCO2, busConnector.GITract_pCO2)
            annotation (Line(
              points={{62,-11},{98,-11},{98,92},{-88,92}},
              color={0,127,0},
              smooth=Smooth.None));
          connect(kidneyCO2.pCO2, busConnector.kidney_pCO2)
            annotation (Line(
              points={{62,-41},{98,-41},{98,92},{-88,92}},
              color={0,127,0},
              smooth=Smooth.None));
          connect(leftHeartCO2.pCO2, busConnector.leftHeart_pCO2)
            annotation (Line(
              points={{62,-71},{98,-71},{98,92},{-88,92}},
              color={0,127,0},
              smooth=Smooth.None));
          connect(liverCO2.pCO2, busConnector.liver_pCO2)
            annotation (Line(
              points={{62,49},{98,49},{98,92},{-88,92}},
              color={0,127,0},
              smooth=Smooth.None));
          connect(otherTissueCO2.pCO2, busConnector.otherTissue.pCO2)
            annotation (Line(
              points={{-44,5},{6,5},{6,92},{-88,92}},
              color={0,127,0},
              smooth=Smooth.None));
          connect(respiratoryMuscleCO2.pCO2, busConnector.respiratoryMuscle.pCO2)
            annotation (Line(
              points={{-44,-25},{6,-25},{6,92},{-88,92}},
              color={0,127,0},
              smooth=Smooth.None));
          connect(rightHeartCO2.pCO2, busConnector.rightHeart_pCO2)
            annotation (Line(
              points={{62,-101},{98,-101},{98,92},{-88,92}},
              color={0,127,0},
              smooth=Smooth.None));
          connect(skinCO2.pCO2, busConnector.skin_pCO2)     annotation (
             Line(
              points={{-44,-85},{6,-85},{6,92},{-88,92}},
              color={0,127,0},
              smooth=Smooth.None));
          connect(skeletalMuscleCO2.pCO2, busConnector.skeletalMuscle.pCO2)
            annotation (Line(
              points={{-44,63},{5.5,63},{5.5,92},{-88,92}},
              color={127,0,0},
              smooth=Smooth.None));

          connect(boneCO2.pCO2, busConnector.Bone_PCO2)       annotation (
             Line(
              points={{-44,35},{6,35},{6,92},{-88,92}},
              color={0,127,0},
              smooth=Smooth.None));
          connect(brainCO2.pCO2, busConnector.Brain_PCO2)
            annotation (Line(
              points={{62,19},{98,19},{98,92},{-88,92}},
              color={0,127,0},
              smooth=Smooth.None));
          connect(fatCO2.pCO2, busConnector.Fat_PCO2)     annotation (
              Line(
              points={{-44,-55},{6,-55},{6,92},{-88,92}},
              color={0,127,0},
              smooth=Smooth.None));
          connect(GITractCO2.pCO2, busConnector.GITract.pCO2)
            annotation (Line(
              points={{62,-11},{98,-11},{98,92},{-88,92}},
              color={0,127,0},
              smooth=Smooth.None));
          connect(kidneyCO2.pCO2, busConnector.Kidney_PCO2)
            annotation (Line(
              points={{62,-41},{98,-41},{98,92},{-88,92}},
              color={0,127,0},
              smooth=Smooth.None));
          connect(leftHeartCO2.pCO2, busConnector.LeftHeart_PCO2)
            annotation (Line(
              points={{62,-71},{98,-71},{98,92},{-88,92}},
              color={0,127,0},
              smooth=Smooth.None));
          connect(liverCO2.pCO2, busConnector.Liver_PCO2)
            annotation (Line(
              points={{62,49},{98,49},{98,92},{-88,92}},
              color={0,127,0},
              smooth=Smooth.None));
          connect(otherTissueCO2.pCO2, busConnector.OtherTissue_PCO2)
            annotation (Line(
              points={{-44,5},{6,5},{6,92},{-88,92}},
              color={0,127,0},
              smooth=Smooth.None));
          connect(respiratoryMuscleCO2.pCO2, busConnector.RespiratoryMuscle_PCO2)
            annotation (Line(
              points={{-44,-25},{6,-25},{6,92},{-88,92}},
              color={0,127,0},
              smooth=Smooth.None));
          connect(rightHeartCO2.pCO2, busConnector.RightHeart_PCO2)
            annotation (Line(
              points={{62,-101},{98,-101},{98,92},{-88,92}},
              color={0,127,0},
              smooth=Smooth.None));
          connect(skinCO2.pCO2, busConnector.Skin_PCO2)     annotation (
             Line(
              points={{-44,-85},{6,-85},{6,92},{-88,92}},
              color={0,127,0},
              smooth=Smooth.None));
          connect(skeletalMuscleCO2.pCO2, busConnector.SkeletalMuscle_PCO2)
            annotation (Line(
              points={{-44,63},{5.5,63},{5.5,92},{-88,92}},
              color={127,0,0},
              smooth=Smooth.None));

          connect(boneCO2.cHCO3, busConnector.bone_cHCO3)       annotation (
             Line(
              points={{-46,35},{6,35},{6,92},{-88,92}},
              color={0,127,0},
              smooth=Smooth.None));
          connect(brainCO2.cHCO3, busConnector.brain_cHCO3)
            annotation (Line(
              points={{60,19},{98,19},{98,92},{-88,92}},
              color={0,127,0},
              smooth=Smooth.None));
          connect(fatCO2.cHCO3, busConnector.fat_cHCO3)     annotation (
              Line(
              points={{-46,-55},{6,-55},{6,92},{-88,92}},
              color={0,127,0},
              smooth=Smooth.None));
          connect(GITractCO2.cHCO3, busConnector.GITract_cHCO3)
            annotation (Line(
              points={{60,-11},{98,-11},{98,92},{-88,92}},
              color={0,127,0},
              smooth=Smooth.None));
          connect(kidneyCO2.cHCO3, busConnector.kidney_cHCO3)
            annotation (Line(
              points={{60,-41},{98,-41},{98,92},{-88,92}},
              color={0,127,0},
              smooth=Smooth.None));
          connect(leftHeartCO2.cHCO3, busConnector.leftHeart_cHCO3)
            annotation (Line(
              points={{60,-71},{98,-71},{98,92},{-88,92}},
              color={0,127,0},
              smooth=Smooth.None));
          connect(liverCO2.cHCO3, busConnector.liver_cHCO3)
            annotation (Line(
              points={{60,49},{98,49},{98,92},{-88,92}},
              color={0,127,0},
              smooth=Smooth.None));
          connect(otherTissueCO2.cHCO3, busConnector.otherTissue_cHCO3)
            annotation (Line(
              points={{-46,5},{6,5},{6,92},{-88,92}},
              color={0,127,0},
              smooth=Smooth.None));
          connect(respiratoryMuscleCO2.cHCO3, busConnector.respiratoryMuscle_cHCO3)
            annotation (Line(
              points={{-46,-25},{6,-25},{6,92},{-88,92}},
              color={0,127,0},
              smooth=Smooth.None));
          connect(rightHeartCO2.cHCO3, busConnector.rightHeart_cHCO3)
            annotation (Line(
              points={{60,-101},{98,-101},{98,92},{-88,92}},
              color={0,127,0},
              smooth=Smooth.None));
          connect(skinCO2.cHCO3, busConnector.skin_cHCO3)     annotation (
             Line(
              points={{-46,-85},{6,-85},{6,92},{-88,92}},
              color={0,127,0},
              smooth=Smooth.None));
          connect(skeletalMuscleCO2.cHCO3, busConnector.skeletalMuscle_cHCO3)
            annotation (Line(
              points={{-46,63},{5.5,63},{5.5,92},{-88,92}},
              color={127,0,0},
              smooth=Smooth.None));

          connect(boneCO2.cHCO3_interstitial, busConnector.bone_cHCO3_interstitial)       annotation (
             Line(
              points={{-42,35},{6,35},{6,92},{-88,92}},
              color={0,127,0},
              smooth=Smooth.None));
          connect(brainCO2.cHCO3_interstitial, busConnector.brain_cHCO3_interstitial)
            annotation (Line(
              points={{64,19},{98,19},{98,92},{-88,92}},
              color={0,127,0},
              smooth=Smooth.None));
          connect(fatCO2.cHCO3_interstitial, busConnector.fat_cHCO3_interstitial)     annotation (
              Line(
              points={{-42,-55},{6,-55},{6,92},{-88,92}},
              color={0,127,0},
              smooth=Smooth.None));
          connect(GITractCO2.cHCO3_interstitial, busConnector.GITract_cHCO3_interstitial)
            annotation (Line(
              points={{64,-11},{98,-11},{98,92},{-88,92}},
              color={0,127,0},
              smooth=Smooth.None));
          connect(kidneyCO2.cHCO3_interstitial, busConnector.kidney_cHCO3_interstitial)
            annotation (Line(
              points={{64,-41},{98,-41},{98,92},{-88,92}},
              color={0,127,0},
              smooth=Smooth.None));
          connect(leftHeartCO2.cHCO3_interstitial, busConnector.leftHeart_cHCO3_interstitial)
            annotation (Line(
              points={{64,-71},{98,-71},{98,92},{-88,92}},
              color={0,127,0},
              smooth=Smooth.None));
          connect(liverCO2.cHCO3_interstitial, busConnector.liver_cHCO3_interstitial)
            annotation (Line(
              points={{64,49},{98,49},{98,92},{-88,92}},
              color={0,127,0},
              smooth=Smooth.None));
          connect(otherTissueCO2.cHCO3_interstitial, busConnector.otherTissue_cHCO3_interstitial)
            annotation (Line(
              points={{-42,5},{6,5},{6,92},{-88,92}},
              color={0,127,0},
              smooth=Smooth.None));
          connect(respiratoryMuscleCO2.cHCO3_interstitial, busConnector.respiratoryMuscle_cHCO3_interstitial)
            annotation (Line(
              points={{-42,-25},{6,-25},{6,92},{-88,92}},
              color={0,127,0},
              smooth=Smooth.None));
          connect(rightHeartCO2.cHCO3_interstitial, busConnector.rightHeart_cHCO3_interstitial)
            annotation (Line(
              points={{64,-101},{98,-101},{98,92},{-88,92}},
              color={0,127,0},
              smooth=Smooth.None));
          connect(skinCO2.cHCO3_interstitial, busConnector.skin_cHCO3_interstitial)     annotation (
             Line(
              points={{-42,-85},{6,-85},{6,92},{-88,92}},
              color={0,127,0},
              smooth=Smooth.None));
          connect(skeletalMuscleCO2.cHCO3_interstitial, busConnector.skeletalMuscle_cHCO3_interstitial)
            annotation (Line(
              points={{-42,63},{5.5,63},{5.5,92},{-88,92}},
              color={127,0,0},
              smooth=Smooth.None));

          connect(liverCO2.HepaticArtyBloodFlow, busConnector.HepaticArty_BloodFlow)
            annotation (Line(
              points={{71,50},{98,50},{98,92},{-88,92}},
              color={0,0,127},
              smooth=Smooth.None), Text(
              string="%second",
              index=1,
              extent={{6,3},{6,3}}));
          connect(busConnector.GITract_BloodFlow, liverCO2.PortalVeinBloodFlow)
            annotation (Line(
              points={{-88,92},{60,92},{60,69}},
              color={0,0,255},
              thickness=0.5,
              smooth=Smooth.None), Text(
              string="%first",
              index=-1,
              extent={{-3,13},{-3,13}}));
          connect(GITractCO2.vein, liverCO2.portalVein) annotation (Line(
              points={{52,1},{38,1},{38,80},{64,80},{64,70}},
              color={200,0,0},
              thickness=1,
              smooth=Smooth.None));
          connect(q_in, liverCO2.hepaticArty) annotation (Line(
              points={{100,0},{84,0},{84,61},{72,61}},
              color={200,0,0},
              thickness=1,
              smooth=Smooth.None));
          annotation (Icon(graphics={Rectangle(extent={{-120,100},{120,-100}},
                    lineColor={0,0,0})}));
        end TissuesCO2;

        model TissueCO2

        Physiolibrary.Chemical.Interfaces.ChemicalPort_a arty annotation (
            Placement(transformation(extent={{76,-66},{96,-46}}),
              iconTransformation(extent={{80,-10},{120,30}})));
        Physiolibrary.Chemical.Interfaces.ChemicalPort_b vein annotation (
            Placement(transformation(extent={{-88,-66},{-68,-46}}),
              iconTransformation(extent={{-120,-10},{-80,30}})));
        Physiolibrary.Chemical.Sources.UnlimitedSolutePump InflowBase(
            useSoluteFlowInput=true)
          annotation (Placement(transformation(extent={{-64,42},{-44,62}})));

          parameter Real initialMass;
          Modelica.Blocks.Interfaces.RealInput pH_plasma "outgoing plasma pH"
                                                                annotation (Placement(transformation(extent={{-3,-3},
                    {3,3}},
                rotation=180,
                origin={9,-39}),          iconTransformation(extent={{-100,-30},{-80,-10}})));
          Modelica.Blocks.Interfaces.RealInput pH_ery
          "outgoing intracellular erytrocytes pH"
                                          annotation (Placement(transformation(extent={{-3,-3},
                    {3,3}},
                rotation=180,
                origin={9,-45}),          iconTransformation(extent={{-100,90},{-80,110}})));
          Modelica.Blocks.Interfaces.RealInput BloodFlow
          "blood flow through ventilated alveols"
                                           annotation (Placement(transformation(extent={{64,-50},
                    {58,-44}}),           iconTransformation(extent={{-10,-10},{10,10}},
                rotation=180,
                origin={90,54})));

          Modelica.Blocks.Interfaces.RealInput T "outgoing temperature"
                                                                 annotation (Placement(transformation(extent={{-4,-4},
                    {4,4}},
                rotation=180,
                origin={86,20}),          iconTransformation(extent={{-10,-10},{10,10}},
                rotation=180,
                origin={90,-60})));
          Modelica.Blocks.Interfaces.RealInput sO2 "outgoing oxygen saturation"
                                           annotation (Placement(transformation(extent={{3,-3},{
                    -3,3}},
                rotation=180,
                origin={-35,-47}),        iconTransformation(
                extent={{-10,-10},{10,10}},
                origin={-90,60})));
          Modelica.Blocks.Interfaces.RealInput Hct
          "outgoing hematocrit (erytrocytes volume/blood volume)"
                                           annotation (Placement(transformation(extent={{3,-3},{
                    -3,3}},
                rotation=180,
                origin={-35,-41}),        iconTransformation(
                extent={{-10,-10},{10,10}},
                origin={-90,-60})));

          Modelica.Blocks.Interfaces.RealInput Tissue_CO2FromMetabolism
          "Co2 flow from metabolism"       annotation (Placement(transformation(extent={{-74,66},
                    {-66,74}}),           iconTransformation(
                extent={{-10,-10},{10,10}},
                rotation=180,
                origin={90,-20})));
          Physiolibrary.Types.RealIO.PressureOutput pCO2(
                                              start=45)
                                                   annotation (Placement(
                transformation(extent={{38,-82},{46,-74}}),  iconTransformation(
                  extent={{-10,-10},{10,10}},
                rotation=270,
                origin={0,-110})));
          Physiolibrary.Types.RealIO.ConcentrationOutput cHCO3
                                                   annotation (Placement(
                transformation(extent={{36,-90},{44,-82}}),  iconTransformation(
                  extent={{-10,-10},{10,10}},
                rotation=270,
                origin={-20,-110})));
          Physiolibrary.Types.RealIO.ConcentrationOutput cHCO3_interstitial
                                                   annotation (Placement(
                transformation(extent={{50,36},{58,44}}),    iconTransformation(
                  extent={{-10,-10},{10,10}},
                rotation=270,
                origin={20,-110})));
        Physiolibrary.Chemical.Components.Stream tissueFlow(
            useSolutionFlowInput=true) annotation (Placement(transformation(
              extent={{-10,10},{10,-10}},
              rotation=180,
              origin={42,-56})));
          FlowMeasureCO2 tissueVeinsCO2
            annotation (Placement(transformation(extent={{-4,-58},{-24,-38}})));
          Modelica.Blocks.Math.Gain DonnansCoeficient(k=1.04)
            annotation (Placement(transformation(extent={{34,36},{42,44}})));
        equation

          connect(arty, tissueFlow.q_in) annotation (Line(
              points={{86,-56},{52,-56}},
              color={200,0,0},
              thickness=1,
              smooth=Smooth.None));
        connect(tissueFlow.solutionFlow, BloodFlow) annotation (Line(
            points={{42,-49},{42,-47},{61,-47}},
            color={0,0,127},
            smooth=Smooth.None));
          connect(tissueVeinsCO2.pCO2, pCO2) annotation (Line(
              points={{-18,-60},{-18,-78},{42,-78}},
              color={0,0,127},
              smooth=Smooth.None));
          connect(tissueVeinsCO2.cHCO3, cHCO3) annotation (Line(
              points={{-22,-60},{-22,-86},{40,-86}},
              color={0,0,127},
              smooth=Smooth.None));
          connect(tissueVeinsCO2.T, T) annotation (Line(
              points={{-23,-40},{-26,-40},{-26,20},{86,20}},
              color={0,0,127},
              smooth=Smooth.None));
          connect(tissueVeinsCO2.Hct, Hct) annotation (Line(
              points={{-23,-44},{-29,-44},{-29,-41},{-35,-41}},
              color={0,0,127},
              smooth=Smooth.None));
          connect(tissueVeinsCO2.sO2, sO2) annotation (Line(
              points={{-23,-48},{-30,-48},{-30,-47},{-35,-47}},
              color={0,0,127},
              smooth=Smooth.None));
          connect(tissueVeinsCO2.pH, pH_plasma) annotation (Line(
              points={{-5,-40},{2,-40},{2,-39},{9,-39}},
              color={0,0,127},
              smooth=Smooth.None));
          connect(pH_ery, tissueVeinsCO2.pH_ery) annotation (Line(
              points={{9,-45},{0.5,-45},{0.5,-44},{-5,-44}},
              color={0,0,127},
              smooth=Smooth.None));
          connect(InflowBase.q_out, tissueVeinsCO2.q_in) annotation (Line(
              points={{-44,52},{10,52},{10,-56},{-4,-56}},
              color={200,0,0},
              thickness=1,
              smooth=Smooth.None));
          connect(tissueFlow.q_out, tissueVeinsCO2.q_in) annotation (Line(
              points={{32,-56},{-4,-56}},
              color={200,0,0},
              thickness=1,
              smooth=Smooth.None));
          connect(tissueVeinsCO2.q_out, vein) annotation (Line(
              points={{-24,-56},{-78,-56}},
              color={200,0,0},
              thickness=1,
              smooth=Smooth.None));
          connect(BloodFlow, tissueVeinsCO2.BloodFlow) annotation (Line(
              points={{61,-47},{28.5,-47},{28.5,-48},{-5,-48}},
              color={0,0,127},
              smooth=Smooth.None));
        connect(InflowBase.soluteFlow, Tissue_CO2FromMetabolism) annotation (
            Line(
            points={{-50,56},{-50,70},{-70,70}},
            color={0,0,127},
            smooth=Smooth.None));
          connect(DonnansCoeficient.y, cHCO3_interstitial) annotation (Line(
              points={{42.4,40},{54,40}},
              color={0,0,127},
              smooth=Smooth.None));
          connect(tissueVeinsCO2.cHCO3, DonnansCoeficient.u) annotation (Line(
              points={{-22,-60},{-22,-86},{26,-86},{26,40},{33.2,40}},
              color={0,0,127},
              smooth=Smooth.None));
          annotation ( Icon(coordinateSystem(
                  preserveAspectRatio=true, extent={{-100,-100},{100,100}}),
                graphics={
                Text(
                  extent={{-100,-80},{100,-100}},
                  lineColor={127,0,0},
                  fillPattern=FillPattern.Solid,
                  textString="(init %initialMass mEq)"),
                Text(
                  extent={{-6,92},{80,34}},
                  lineColor={0,0,0},
                  textString="CO"),
                Text(
                  extent={{66,34},{86,62}},
                  lineColor={0,0,0},
                  textString="2"),
                Rectangle(extent={{-100,100},{100,-100}}, lineColor={0,0,0})}));
        end TissueCO2;

        model TissueCO2_liver
         extends Physiolibrary.Icons.Liver;
        Physiolibrary.Chemical.Interfaces.ChemicalPort_b vein annotation (
            Placement(transformation(extent={{-42,-66},{-22,-46}}),
              iconTransformation(extent={{-120,-10},{-80,30}})));
        Physiolibrary.Chemical.Sources.UnlimitedSolutePump InflowBase(
            useSoluteFlowInput=true)
          annotation (Placement(transformation(extent={{-64,24},{-44,44}})));

          parameter Real initialMass;
          Modelica.Blocks.Interfaces.RealInput pH_plasma "outgoing plasma pH"
                                                                annotation (Placement(transformation(extent={{-3,-3},
                    {3,3}},
                rotation=180,
                origin={7,-37}),          iconTransformation(extent={{-100,-30},{-80,-10}})));
          Modelica.Blocks.Interfaces.RealInput pH_ery
          "outgoing intracellular erytrocytes pH"
                                          annotation (Placement(transformation(extent={{-3,-3},
                    {3,3}},
                rotation=180,
                origin={7,-43}),          iconTransformation(extent={{-100,90},{-80,110}})));

          Modelica.Blocks.Interfaces.RealInput T "outgoing temperature"
                                                                 annotation (Placement(transformation(extent={{-4,-4},
                    {4,4}},
                rotation=180,
                origin={86,20}),          iconTransformation(extent={{-10,-10},{10,10}},
                rotation=180,
                origin={90,58})));
          Modelica.Blocks.Interfaces.RealInput sO2 "outgoing oxygen saturation"
                                           annotation (Placement(transformation(extent={{3,-3},{
                    -3,3}},
                rotation=180,
                origin={-35,-47}),        iconTransformation(
                extent={{-10,-10},{10,10}},
                origin={-90,60})));
          Modelica.Blocks.Interfaces.RealInput Hct
          "outgoing hematocrit (erytrocytes volume/blood volume)"
                                           annotation (Placement(transformation(extent={{3,-3},{
                    -3,3}},
                rotation=180,
                origin={-35,-41}),        iconTransformation(
                extent={{-10,-10},{10,10}},
                origin={-90,-60})));

          Modelica.Blocks.Interfaces.RealOutput pCO2
                                                   annotation (Placement(
                transformation(extent={{38,-82},{46,-74}}),  iconTransformation(
                  extent={{-10,-10},{10,10}},
                rotation=270,
                origin={0,-110})));
          Modelica.Blocks.Interfaces.RealOutput cHCO3
                                                   annotation (Placement(
                transformation(extent={{36,-90},{44,-82}}),  iconTransformation(
                  extent={{-10,-10},{10,10}},
                rotation=270,
                origin={-20,-110})));
          Modelica.Blocks.Interfaces.RealOutput cHCO3_interstitial
                                                   annotation (Placement(
                transformation(extent={{50,36},{58,44}}),    iconTransformation(
                  extent={{-10,-10},{10,10}},
                rotation=270,
                origin={20,-110})));
        Physiolibrary.Chemical.Components.Stream tissueFlow(
            useSolutionFlowInput=true) annotation (Placement(transformation(
              extent={{-10,10},{10,-10}},
              rotation=180,
              origin={42,-56})));
          FlowMeasureCO2 tissueVeinsCO2
            annotation (Placement(transformation(extent={{-4,-58},{-24,-38}})));
        Physiolibrary.Chemical.Interfaces.ChemicalPort_a portalVein annotation (
           Placement(transformation(extent={{68,-86},{88,-66}}),
              iconTransformation(extent={{0,80},{40,120}})));
        Physiolibrary.Chemical.Interfaces.ChemicalPort_a hepaticArty
          annotation (Placement(transformation(extent={{78,-66},{98,-46}}),
              iconTransformation(extent={{80,-10},{120,30}})));
          Modelica.Blocks.Interfaces.RealInput HepaticArtyBloodFlow
          "blood flow through hepatic artery"
                                           annotation (Placement(transformation(extent={{62,-50},
                    {54,-42}}),           iconTransformation(extent={{-10,-10},{10,10}},
                rotation=180,
                origin={90,-100})));
          Modelica.Blocks.Interfaces.RealInput PortalVeinBloodFlow
          "blood flow through portal vein" annotation (Placement(transformation(extent={{-4,-4},
                    {4,4}},
                rotation=180,
                origin={46,-28}),         iconTransformation(extent={{-10,-10},{10,10}},
                rotation=270,
                origin={-20,90})));
          Modelica.Blocks.Math.Add add annotation (Placement(transformation(
                extent={{-4,-4},{4,4}},
                rotation=180,
                origin={30,-40})));
          Modelica.Blocks.Interfaces.RealInput Tissue_CO2FromMetabolism
          "Co2 flow from metabolism"       annotation (Placement(transformation(extent={{-72,40},
                    {-64,48}}),           iconTransformation(
                extent={{-10,-10},{10,10}},
                rotation=180,
                origin={90,-40})));
          Modelica.Blocks.Math.Gain DonnansCoeficient(k=1.04)
            annotation (Placement(transformation(extent={{32,36},{40,44}})));
        equation

          connect(tissueVeinsCO2.pCO2, pCO2) annotation (Line(
              points={{-18,-60},{-18,-78},{42,-78}},
              color={0,0,127},
              smooth=Smooth.None));
          connect(tissueVeinsCO2.cHCO3, cHCO3) annotation (Line(
              points={{-22,-60},{-22,-86},{40,-86}},
              color={0,0,127},
              smooth=Smooth.None));
          connect(tissueVeinsCO2.T, T) annotation (Line(
              points={{-23,-40},{-26,-40},{-26,20},{86,20}},
              color={0,0,127},
              smooth=Smooth.None));
          connect(tissueVeinsCO2.Hct, Hct) annotation (Line(
              points={{-23,-44},{-29,-44},{-29,-41},{-35,-41}},
              color={0,0,127},
              smooth=Smooth.None));
          connect(tissueVeinsCO2.sO2, sO2) annotation (Line(
              points={{-23,-48},{-30,-48},{-30,-47},{-35,-47}},
              color={0,0,127},
              smooth=Smooth.None));
          connect(tissueVeinsCO2.pH, pH_plasma) annotation (Line(
              points={{-5,-40},{0,-40},{0,-37},{7,-37}},
              color={0,0,127},
              smooth=Smooth.None));
          connect(pH_ery, tissueVeinsCO2.pH_ery) annotation (Line(
              points={{7,-43},{0.5,-43},{0.5,-44},{-5,-44}},
              color={0,0,127},
              smooth=Smooth.None));
          connect(InflowBase.q_out, tissueVeinsCO2.q_in) annotation (Line(
              points={{-44,34},{10,34},{10,-56},{-4,-56}},
              color={200,0,0},
              thickness=1,
              smooth=Smooth.None));
          connect(tissueFlow.q_out, tissueVeinsCO2.q_in) annotation (Line(
              points={{32,-56},{-4,-56}},
              color={200,0,0},
              thickness=1,
              smooth=Smooth.None));
          connect(tissueVeinsCO2.q_out, vein) annotation (Line(
              points={{-24,-56},{-32,-56}},
              color={200,0,0},
              thickness=1,
              smooth=Smooth.None));
          connect(hepaticArty, tissueFlow.q_in) annotation (Line(
              points={{88,-56},{52,-56}},
              color={200,0,0},
              thickness=1,
              smooth=Smooth.None));
          connect(tissueVeinsCO2.q_in, portalVein) annotation (Line(
              points={{-4,-56},{24,-56},{24,-74},{78,-74},{78,-76}},
              color={200,0,0},
              thickness=1,
              smooth=Smooth.None));
        connect(HepaticArtyBloodFlow, tissueFlow.solutionFlow) annotation (Line(
            points={{58,-46},{42,-46},{42,-52}},
            color={0,0,127},
            smooth=Smooth.None));
          connect(PortalVeinBloodFlow, add.u2) annotation (Line(
              points={{46,-28},{40,-28},{40,-37.6},{34.8,-37.6}},
              color={0,0,127},
              smooth=Smooth.None));
          connect(HepaticArtyBloodFlow, add.u1) annotation (Line(
              points={{58,-46},{42,-46},{42,-42.4},{34.8,-42.4}},
              color={0,0,127},
              smooth=Smooth.None));
          connect(add.y, tissueVeinsCO2.BloodFlow) annotation (Line(
              points={{25.6,-40},{24,-40},{24,-48},{-5,-48}},
              color={0,0,127},
              smooth=Smooth.None));
        connect(InflowBase.soluteFlow, Tissue_CO2FromMetabolism) annotation (
            Line(
            points={{-50,38},{-50,44},{-68,44}},
            color={0,0,127},
            smooth=Smooth.None));
          connect(DonnansCoeficient.y, cHCO3_interstitial) annotation (Line(
              points={{40.4,40},{54,40}},
              color={0,0,127},
              smooth=Smooth.None));
          connect(tissueVeinsCO2.cHCO3, DonnansCoeficient.u) annotation (Line(
              points={{-22,-60},{-22,-86},{20,-86},{20,40},{31.2,40}},
              color={0,0,127},
              smooth=Smooth.None));
          annotation ( Icon(coordinateSystem(
                  preserveAspectRatio=true, extent={{-100,-100},{100,100}}),
                graphics={
                Text(
                  extent={{-100,-80},{100,-100}},
                  lineColor={127,0,0},
                  fillPattern=FillPattern.Solid,
                  textString="(init %initialMass mEq)"),
                Text(
                  extent={{-6,92},{80,34}},
                  lineColor={0,0,0},
                  textString="CO"),
                Text(
                  extent={{66,34},{86,62}},
                  lineColor={0,0,0},
                  textString="2"),
                Rectangle(extent={{-100,100},{100,-100}}, lineColor={0,0,0})}));
        end TissueCO2_liver;

        model SkeletalMuscleCO2
          extends TissueCO2;
          extends Physiolibrary.Icons.SkeletalMuscle;
        end SkeletalMuscleCO2;

        model BoneCO2
          extends TissueCO2;
          extends Physiolibrary.Icons.Bone;
        end BoneCO2;

        model OtherTissueCO2
          extends TissueCO2;
          extends Physiolibrary.Icons.OtherTissue;
        end OtherTissueCO2;

        model RespiratoryMuscleCO2
          extends TissueCO2;
          extends Physiolibrary.Icons.RespiratoryMuscle;
        end RespiratoryMuscleCO2;

        model FatCO2
          extends TissueCO2;
          extends Physiolibrary.Icons.Fat;
        end FatCO2;

        model SkinCO2
          extends TissueCO2;
          extends Physiolibrary.Icons.Skin;
        end SkinCO2;

        model BrainCO2
          extends TissueCO2;
          extends Physiolibrary.Icons.Brain;
        end BrainCO2;

        model GITractCO2
          extends TissueCO2;
          extends Physiolibrary.Icons.GITract;
        end GITractCO2;

        model LeftHeartCO2
          extends TissueCO2;
          extends Physiolibrary.Icons.LeftHeart;
        end LeftHeartCO2;

        model RightHeartCO2
          extends TissueCO2;
          extends Physiolibrary.Icons.RightHeart;
        end RightHeartCO2;

        model KidneyCO2
          extends TissueCO2;
          extends Physiolibrary.Icons.Kidney;
        end KidneyCO2;
      end TissuesWithInterstitium;

      model BloodCO2

       extends BloodCO2TransportBase;
      // extends Physiolibrary.Icons.LungShunt;

      Physiolibrary.Chemical.Interfaces.ChemicalPort_a alveolar_outflow
        "CO2 outflow from blood to alveol space in mmol/min"
          annotation (Placement(transformation(extent={{-20,80},{20,120}}),
              iconTransformation(extent={{-20,80},{20,120}})));
      equation
        q_in.q + q_out.q + alveolar_outflow.q = 0;
        alveolar_outflow.conc = cdCO2;

      end BloodCO2;

      package IO_Bus
      extends Physiolibrary.Types.IO_Bus;
        redeclare model extends Variables

        T.Pressure Brain_PCO2(varName="Brain-CO2.PCO2")
          "Partial carbondioxyde pressure in brain venules."
        annotation (Placement(transformation(extent={{-80,128},{-74,134}})));
        T.Concentration CO2Artys_cHCO3(varName="CO2Artys.[HCO3(mEq/L)]")
        annotation (Placement(transformation(extent={{-80,-206},{-74,-200}})));
        T.Pressure CO2Artys_pCO2(varName="CO2Artys.Pressure")
        annotation (Placement(transformation(extent={{-80,-196},{-74,-190}})));
        T.Pressure CO2Lung_pCO2(varName="LungCO2.PCapy")
        annotation (Placement(transformation(extent={{-80,-186},{-74,-180}})));
        T.Concentration CO2Veins_cHCO3(varName="CO2Veins.[HCO3(mEq/L)]")
        annotation (Placement(transformation(extent={{-80,-176},{-74,-170}})));
        T.Pressure CO2Veins_pCO2(varName="CO2Veins.Pressure")
        annotation (Placement(transformation(extent={{-80,-166},{-74,-160}})));
        T.Concentration GITract_cHCO3_interstitial(varName="GITract-CO2.[HCO3(mEq/L)]")
        annotation (Placement(transformation(extent={{-80,-152},{-74,-146}})));
        T.Concentration bone_cHCO3_interstitial(varName="Bone-CO2.[HCO3(mEq/L)]")
        annotation (Placement(transformation(extent={{-80,-142},{-74,-136}})));
        T.Concentration brain_cHCO3_interstitial(varName="Brain-CO2.[HCO3(mEq/L)]")
        annotation (Placement(transformation(extent={{-80,-132},{-74,-126}})));
        T.Concentration fat_cHCO3_interstitial(varName="Fat-CO2.[HCO3(mEq/L)]")
        annotation (Placement(transformation(extent={{-80,-122},{-74,-116}})));
        T.Concentration kidney_cHCO3_interstitial(varName="Kidney-CO2.[HCO3(mEq/L)]")
        annotation (Placement(transformation(extent={{-80,-112},{-74,-106}})));
        T.Concentration leftHeart_cHCO3_interstitial(varName="LeftHeart-CO2.[HCO3(mEq/L)]")
        annotation (Placement(transformation(extent={{-80,-102},{-74,-96}})));
        T.Concentration liver_cHCO3_interstitial(varName="Liver-CO2.[HCO3(mEq/L)]")
        annotation (Placement(transformation(extent={{-80,-92},{-74,-86}})));
        T.Concentration otherTissue_cHCO3_interstitial(varName="OtherTissue-CO2.[HCO3(mEq/L)]")
        annotation (Placement(transformation(extent={{-80,-82},{-74,-76}})));
        T.Concentration respiratoryMuscle_cHCO3_interstitial(varName="RespiratoryMuscle-CO2.[HCO3(mEq/L)]")
        annotation (Placement(transformation(extent={{-80,-72},{-74,-66}})));
        T.Concentration rightHeart_cHCO3_interstitial(varName="RightHeart-CO2.[HCO3(mEq/L)]")
        annotation (Placement(transformation(extent={{-80,-62},{-74,-56}})));
        T.Concentration skeletalMuscle_cHCO3_interstitial(varName="SkeletalMuscle-CO2.[HCO3(mEq/L)]")
        annotation (Placement(transformation(extent={{-80,-52},{-74,-46}})));
        T.Concentration skin_cHCO3_interstitial(varName="Skin-CO2.[HCO3(mEq/L)]")
        annotation (Placement(transformation(extent={{-80,-42},{-74,-36}})));
        T.Concentration skin_cHCO3(varName="Skin-CO2.[BloodHCO3(mEq/L)]")
        annotation (Placement(transformation(extent={{-80,-12},{-74,-6}})));
        T.Concentration skeletalMuscle_cHCO3(varName="SkeletalMuscle-CO2.[BloodHCO3(mEq/L)]")
        annotation (Placement(transformation(extent={{-80,-2},{-74,4}})));
        T.Concentration rightHeart_cHCO3(varName="RightHeart-CO2.[BloodHCO3(mEq/L)]")
        annotation (Placement(transformation(extent={{-80,8},{-74,14}})));
        T.Concentration respiratoryMuscle_cHCO3(varName="RespiratoryMuscle-CO2.[BloodHCO3(mEq/L)]")
        annotation (Placement(transformation(extent={{-80,18},{-74,24}})));
        T.Concentration otherTissue_cHCO3(varName="OtherTissue-CO2.[BloodHCO3(mEq/L)]")
        annotation (Placement(transformation(extent={{-80,28},{-74,34}})));
        T.Concentration liver_cHCO3(varName="Liver-CO2.[BloodHCO3(mEq/L)]")
        annotation (Placement(transformation(extent={{-80,38},{-74,44}})));
        T.Concentration leftHeart_cHCO3(varName="LeftHeart-CO2.[BloodHCO3(mEq/L)]")
        annotation (Placement(transformation(extent={{-80,48},{-74,54}})));
        T.Concentration kidney_cHCO3(varName="Kidney-CO2.[BloodHCO3(mEq/L)]")
        annotation (Placement(transformation(extent={{-80,58},{-74,64}})));
        T.Concentration GITract_cHCO3(varName="GITract-CO2.[BloodHCO3(mEq/L)]")
        annotation (Placement(transformation(extent={{-80,68},{-74,74}})));
        T.Concentration fat_cHCO3(varName="Fat-CO2.[BloodHCO3(mEq/L)]")
        annotation (Placement(transformation(extent={{-80,78},{-74,84}})));
        T.Concentration brain_cHCO3(varName="Brain-CO2.[BloodHCO3(mEq/L)]")
        annotation (Placement(transformation(extent={{-80,88},{-74,94}})));
        T.Concentration bone_cHCO3(varName="Bone-CO2.[BloodHCO3(mEq/L)]")
        annotation (Placement(transformation(extent={{-80,98},{-74,104}})));
        T.Pressure GITract_pCO2(varName="GITract-CO2.PCO2")
        annotation (Placement(transformation(extent={{-78,108},{-72,114}})));
        T.Pressure bone_pCO2(varName="Bone-CO2.PCO2")
        annotation (Placement(transformation(extent={{-78,118},{-72,124}})));
        T.Pressure brain_pCO2(varName="Brain-CO2.PCO2")
        annotation (Placement(transformation(extent={{-80,138},{-74,144}})));
        T.Pressure fat_pCO2(varName="Fat-CO2.PCO2")
        annotation (Placement(transformation(extent={{-80,148},{-74,154}})));
        T.Pressure kidney_pCO2(varName="Kidney-CO2.PCO2")
        annotation (Placement(transformation(extent={{-80,158},{-74,164}})));
        T.Pressure leftHeart_pCO2(varName="LeftHeart-CO2.PCO2")
        annotation (Placement(transformation(extent={{-80,168},{-74,174}})));
        T.Pressure liver_pCO2(varName="Liver-CO2.PCO2")
        annotation (Placement(transformation(extent={{-80,178},{-74,184}})));
        T.Pressure otherTissue_pCO2(varName="OtherTissue-CO2.PCO2")
        annotation (Placement(transformation(extent={{-80,188},{-74,194}})));
        T.Pressure respiratoryMuscle_pCO2(varName="RespiratoryMuscle-CO2.PCO2")
        annotation (Placement(transformation(extent={{-80,198},{-74,204}})));
        T.Pressure rightHeart_pCO2(varName="RightHeart-CO2.PCO2")
        annotation (Placement(transformation(extent={{-80,208},{-74,214}})));
        T.Pressure skeletalMuscle_pCO2(varName="SkeletalMuscle-CO2.PCO2")
        annotation (Placement(transformation(extent={{-80,218},{-74,224}})));
        T.Pressure skin_pCO2(varName="Skin-CO2.PCO2")
        annotation (Placement(transformation(extent={{-80,228},{-74,234}})));
        T.Concentration CO2Lungs_cHCO3(varName="LungCO2.[Capy]", storeUnit=
              "mol/l")
          annotation (Placement(transformation(extent={{-80,-20},{-74,-14}})));
        equation

        connect(Brain_PCO2.y, busConnector.Brain_PCO2) annotation (Line(
         points={{-73.7,131},{90,131},{90,-2}},
              color={0,0,127},
              smooth=Smooth.None), Text(
              string="%second",
              index=1,
              extent={{6,3},{6,3}}));
        connect(bone_cHCO3.y, busConnector.bone_cHCO3) annotation (Line(
         points={{-73.7,101},{90,101},{90,-2}},
              color={0,0,127},
              smooth=Smooth.None), Text(
              string="%second",
              index=1,
              extent={{6,3},{6,3}}));
        connect(brain_cHCO3.y, busConnector.brain_cHCO3) annotation (Line(
         points={{-73.7,91},{90,91},{90,-2}},
              color={0,0,127},
              smooth=Smooth.None), Text(
              string="%second",
              index=1,
              extent={{6,3},{6,3}}));
        connect(CO2Artys_cHCO3.y, busConnector.CO2Artys_cHCO3) annotation (Line(
         points={{-73.7,-203},{90,-203},{90,-2}},
              color={0,0,127},
              smooth=Smooth.None), Text(
              string="%second",
              index=1,
              extent={{6,3},{6,3}}));
        connect(CO2Veins_cHCO3.y, busConnector.CO2Veins_cHCO3) annotation (Line(
         points={{-73.7,-173},{90,-173},{90,-2}},
              color={0,0,127},
              smooth=Smooth.None), Text(
              string="%second",
              index=1,
              extent={{6,3},{6,3}}));
        connect(fat_cHCO3.y, busConnector.fat_cHCO3) annotation (Line(
         points={{-73.7,81},{90,81},{90,-2}},
              color={0,0,127},
              smooth=Smooth.None), Text(
              string="%second",
              index=1,
              extent={{6,3},{6,3}}));
        connect(GITract_cHCO3.y, busConnector.GITract_cHCO3) annotation (Line(
         points={{-73.7,71},{90,71},{90,-2}},
              color={0,0,127},
              smooth=Smooth.None), Text(
              string="%second",
              index=1,
              extent={{6,3},{6,3}}));
        connect(kidney_cHCO3.y, busConnector.kidney_cHCO3) annotation (Line(
         points={{-73.7,61},{90,61},{90,-2}},
              color={0,0,127},
              smooth=Smooth.None), Text(
              string="%second",
              index=1,
              extent={{6,3},{6,3}}));
        connect(leftHeart_cHCO3.y, busConnector.leftHeart_cHCO3) annotation (Line(
         points={{-73.7,51},{90,51},{90,-2}},
              color={0,0,127},
              smooth=Smooth.None), Text(
              string="%second",
              index=1,
              extent={{6,3},{6,3}}));
        connect(liver_cHCO3.y, busConnector.liver_cHCO3) annotation (Line(
         points={{-73.7,41},{90,41},{90,-2}},
              color={0,0,127},
              smooth=Smooth.None), Text(
              string="%second",
              index=1,
              extent={{6,3},{6,3}}));
        connect(otherTissue_cHCO3.y, busConnector.otherTissue_cHCO3) annotation (Line(
         points={{-73.7,31},{90,31},{90,-2}},
              color={0,0,127},
              smooth=Smooth.None), Text(
              string="%second",
              index=1,
              extent={{6,3},{6,3}}));
        connect(respiratoryMuscle_cHCO3.y, busConnector.respiratoryMuscle_cHCO3) annotation (Line(
         points={{-73.7,21},{90,21},{90,-2}},
              color={0,0,127},
              smooth=Smooth.None), Text(
              string="%second",
              index=1,
              extent={{6,3},{6,3}}));
        connect(rightHeart_cHCO3.y, busConnector.rightHeart_cHCO3) annotation (Line(
         points={{-73.7,11},{90,11},{90,-2}},
              color={0,0,127},
              smooth=Smooth.None), Text(
              string="%second",
              index=1,
              extent={{6,3},{6,3}}));
        connect(skeletalMuscle_cHCO3.y, busConnector.skeletalMuscle_cHCO3) annotation (Line(
         points={{-73.7,1},{86,1},{86,-2},{90,-2}},
              color={0,0,127},
              smooth=Smooth.None), Text(
              string="%second",
              index=1,
              extent={{6,3},{6,3}}));
        connect(skin_cHCO3.y, busConnector.skin_cHCO3) annotation (Line(
         points={{-73.7,-9},{90,-9},{90,-2}},
              color={0,0,127},
              smooth=Smooth.None), Text(
              string="%second",
              index=1,
              extent={{6,3},{6,3}}));
        connect(bone_cHCO3_interstitial.y, busConnector.bone_cHCO3_interstitial) annotation (Line(
         points={{-73.7,-139},{90,-139},{90,-2}},
              color={0,0,127},
              smooth=Smooth.None), Text(
              string="%second",
              index=1,
              extent={{6,3},{6,3}}));
        connect(brain_cHCO3_interstitial.y, busConnector.brain_cHCO3_interstitial) annotation (Line(
         points={{-73.7,-129},{90,-129},{90,-2}},
              color={0,0,127},
              smooth=Smooth.None), Text(
              string="%second",
              index=1,
              extent={{6,3},{6,3}}));
        connect(fat_cHCO3_interstitial.y, busConnector.fat_cHCO3_interstitial) annotation (Line(
         points={{-73.7,-119},{90,-119},{90,-2}},
              color={0,0,127},
              smooth=Smooth.None), Text(
              string="%second",
              index=1,
              extent={{6,3},{6,3}}));
        connect(GITract_cHCO3_interstitial.y, busConnector.GITract_cHCO3_interstitial) annotation (Line(
         points={{-73.7,-149},{90,-149},{90,-2}},
              color={0,0,127},
              smooth=Smooth.None), Text(
              string="%second",
              index=1,
              extent={{6,3},{6,3}}));
        connect(kidney_cHCO3_interstitial.y, busConnector.kidney_cHCO3_interstitial) annotation (Line(
         points={{-73.7,-109},{90,-109},{90,-2}},
              color={0,0,127},
              smooth=Smooth.None), Text(
              string="%second",
              index=1,
              extent={{6,3},{6,3}}));
        connect(leftHeart_cHCO3_interstitial.y, busConnector.leftHeart_cHCO3_interstitial) annotation (Line(
         points={{-73.7,-99},{90,-99},{90,-2}},
              color={0,0,127},
              smooth=Smooth.None), Text(
              string="%second",
              index=1,
              extent={{6,3},{6,3}}));
        connect(liver_cHCO3_interstitial.y, busConnector.liver_cHCO3_interstitial) annotation (Line(
         points={{-73.7,-89},{90,-89},{90,-2}},
              color={0,0,127},
              smooth=Smooth.None), Text(
              string="%second",
              index=1,
              extent={{6,3},{6,3}}));
        connect(otherTissue_cHCO3_interstitial.y, busConnector.otherTissue_cHCO3_interstitial) annotation (Line(
         points={{-73.7,-79},{90,-79},{90,-2}},
              color={0,0,127},
              smooth=Smooth.None), Text(
              string="%second",
              index=1,
              extent={{6,3},{6,3}}));
        connect(respiratoryMuscle_cHCO3_interstitial.y, busConnector.respiratoryMuscle_cHCO3_interstitial) annotation (Line(
         points={{-73.7,-69},{90,-69},{90,-2}},
              color={0,0,127},
              smooth=Smooth.None), Text(
              string="%second",
              index=1,
              extent={{6,3},{6,3}}));
        connect(rightHeart_cHCO3_interstitial.y, busConnector.rightHeart_cHCO3_interstitial) annotation (Line(
         points={{-73.7,-59},{90,-59},{90,-2}},
              color={0,0,127},
              smooth=Smooth.None), Text(
              string="%second",
              index=1,
              extent={{6,3},{6,3}}));
        connect(skeletalMuscle_cHCO3_interstitial.y, busConnector.skeletalMuscle_cHCO3_interstitial) annotation (Line(
         points={{-73.7,-49},{90,-49},{90,-2}},
              color={0,0,127},
              smooth=Smooth.None), Text(
              string="%second",
              index=1,
              extent={{6,3},{6,3}}));
        connect(skin_cHCO3_interstitial.y, busConnector.skin_cHCO3_interstitial) annotation (Line(
         points={{-73.7,-39},{90,-39},{90,-2}},
              color={0,0,127},
              smooth=Smooth.None), Text(
              string="%second",
              index=1,
              extent={{6,3},{6,3}}));
        connect(bone_pCO2.y, busConnector.bone.pCO2) annotation (Line(
         points={{-71.7,121},{90,121},{90,-2}},
              color={0,0,127},
              smooth=Smooth.None), Text(
              string="%second",
              index=1,
              extent={{6,3},{6,3}}));
        connect(brain_pCO2.y, busConnector.brain.pCO2) annotation (Line(
         points={{-73.7,141},{90,141},{90,-2}},
              color={0,0,127},
              smooth=Smooth.None), Text(
              string="%second",
              index=1,
              extent={{6,3},{6,3}}));
        connect(CO2Artys_pCO2.y, busConnector.CO2Artys_pCO2) annotation (Line(
         points={{-73.7,-193},{90,-193},{90,-2}},
              color={0,0,127},
              smooth=Smooth.None), Text(
              string="%second",
              index=1,
              extent={{6,3},{6,3}}));
        connect(CO2Veins_pCO2.y, busConnector.CO2Veins_pCO2) annotation (Line(
         points={{-73.7,-163},{90,-163},{90,-2}},
              color={0,0,127},
              smooth=Smooth.None), Text(
              string="%second",
              index=1,
              extent={{6,3},{6,3}}));
        connect(fat_pCO2.y, busConnector.fat.pCO2) annotation (Line(
         points={{-73.7,151},{90,151},{90,-2}},
              color={0,0,127},
              smooth=Smooth.None), Text(
              string="%second",
              index=1,
              extent={{6,3},{6,3}}));
        connect(GITract_pCO2.y, busConnector.GITract.pCO2) annotation (Line(
         points={{-71.7,111},{90,111},{90,-2}},
              color={0,0,127},
              smooth=Smooth.None), Text(
              string="%second",
              index=1,
              extent={{6,3},{6,3}}));
        connect(kidney_pCO2.y, busConnector.kidney_pCO2) annotation (Line(
         points={{-73.7,161},{90,161},{90,-2}},
              color={0,0,127},
              smooth=Smooth.None), Text(
              string="%second",
              index=1,
              extent={{6,3},{6,3}}));
        connect(leftHeart_pCO2.y, busConnector.leftHeart_pCO2) annotation (Line(
         points={{-73.7,171},{90,171},{90,-2}},
              color={0,0,127},
              smooth=Smooth.None), Text(
              string="%second",
              index=1,
              extent={{6,3},{6,3}}));
        connect(liver_pCO2.y, busConnector.liver_pCO2) annotation (Line(
         points={{-73.7,181},{90,181},{90,-2}},
              color={0,0,127},
              smooth=Smooth.None), Text(
              string="%second",
              index=1,
              extent={{6,3},{6,3}}));
        connect(CO2Lung_pCO2.y, busConnector.CO2Lung_pCO2) annotation (Line(
         points={{-73.7,-183},{90,-183},{90,-2}},
              color={0,0,127},
              smooth=Smooth.None), Text(
              string="%second",
              index=1,
              extent={{6,3},{6,3}}));
        connect(otherTissue_pCO2.y, busConnector.otherTissue.pCO2) annotation (Line(
         points={{-73.7,191},{90,191},{90,-2}},
              color={0,0,127},
              smooth=Smooth.None), Text(
              string="%second",
              index=1,
              extent={{6,3},{6,3}}));
        connect(respiratoryMuscle_pCO2.y, busConnector.respiratoryMuscle.pCO2) annotation (Line(
         points={{-73.7,201},{90,201},{90,-2}},
              color={0,0,127},
              smooth=Smooth.None), Text(
              string="%second",
              index=1,
              extent={{6,3},{6,3}}));
        connect(rightHeart_pCO2.y, busConnector.rightHeart_pCO2) annotation (Line(
         points={{-73.7,211},{90,211},{90,-2}},
              color={0,0,127},
              smooth=Smooth.None), Text(
              string="%second",
              index=1,
              extent={{6,3},{6,3}}));
        connect(skeletalMuscle_pCO2.y, busConnector.skeletalMuscle.pCO2) annotation (Line(
         points={{-73.7,221},{90,221},{90,-2}},
              color={0,0,127},
              smooth=Smooth.None), Text(
              string="%second",
              index=1,
              extent={{6,3},{6,3}}));
        connect(skin_pCO2.y, busConnector.skin_pCO2) annotation (Line(
         points={{-73.7,231},{90,231},{90,-2}},
              color={0,0,127},
              smooth=Smooth.None), Text(
              string="%second",
              index=1,
              extent={{6,3},{6,3}}));
        connect(CO2Lungs_cHCO3.y, busConnector.CO2Lung_cHCO3) annotation (Line(
            points={{-73.7,-17},{-6.85,-17},{-6.85,-2},{90,-2}},
            color={0,0,127},
            smooth=Smooth.None), Text(
            string="%second",
            index=1,
            extent={{6,3},{6,3}}));
        end Variables;

        model CO2_test_SI
        import Physiomodel;
        CardioVascular.IO_Bus.InputFromFile_SI             cardioVascularSystem
            annotation (Placement(transformation(extent={{42,78},{62,100}})));
          Metabolism.IO_Bus.InputFromFile_SI      nutrientsAndMetabolism
            annotation (Placement(transformation(extent={{-84,66},{-64,86}})));
          Electrolytes.IO_Bus.InputFromFile_SI             electrolytes
            annotation (Placement(transformation(extent={{76,-28},{96,-8}})));
          Hormones.IO_Bus.InputFromFile_SI             hormones
            annotation (Placement(transformation(extent={{42,12},{62,32}})));
          Nerves.IO_Bus.InputFromFile_SI             nerves
            annotation (Placement(transformation(extent={{76,44},{96,64}})));
          Setup.IO_Bus.InputFromFile_SI                 setup
            annotation (Placement(transformation(extent={{-14,-100},{6,-80}})));
          Water.IO_Bus.InputFromFile_SI             water
            annotation (Placement(transformation(extent={{-84,0},{-64,20}})));
          Proteins.IO_Bus.InputFromFile_SI             proteins
            annotation (Placement(transformation(extent={{-46,-22},{-26,-2}})));
          Status.IO_Bus.InputFromFile_SI             status
            annotation (Placement(transformation(extent={{44,-74},{64,-54}})));
          Heat.IO_Bus.InputFromFile_SI             heat
            annotation (Placement(transformation(extent={{-26,36},{-46,56}})));
        Physiomodel.Gases.Ventilation.IO_Bus.InputFromFile_SI ventilation_const
          annotation (Placement(transformation(extent={{-34,-70},{-14,-50}})));
        Physiomodel.Gases.O2.IO_Bus.InputFromFile O2
          annotation (Placement(transformation(extent={{-66,-94},{-46,-74}})));
        Physiomodel.Gases.CO2.CO2 cO2_1
          annotation (Placement(transformation(extent={{-90,-56},{-70,-36}})));
        equation
          connect(setup.busConnector,hormones. busConnector) annotation (Line(
              points={{-4,-90},{-4,22},{52,22}},
              color={0,0,255},
              thickness=0.5,
              smooth=Smooth.None));
          connect(setup.busConnector,proteins. busConnector) annotation (Line(
              points={{-4,-90},{-4,-12},{-36,-12}},
              color={0,0,255},
              thickness=0.5,
              smooth=Smooth.None));
          connect(setup.busConnector,cardioVascularSystem. busConnector)
                                                        annotation (Line(
              points={{-4,-90},{-4,89},{52,89}},
              color={0,0,255},
              thickness=0.5,
              smooth=Smooth.None));
          connect(setup.busConnector,nutrientsAndMetabolism. busConnector)
            annotation (Line(
              points={{-4,-90},{-4,76},{-74,76}},
              color={0,0,255},
              thickness=0.5,
              smooth=Smooth.None));
          connect(setup.busConnector,water. busConnector) annotation (Line(
              points={{-4,-90},{-4,10},{-74,10}},
              color={0,0,255},
              thickness=0.5,
              smooth=Smooth.None));
          connect(setup.busConnector,nerves. busConnector) annotation (Line(
              points={{-4,-90},{-4,54},{86,54}},
              color={0,0,255},
              thickness=0.5,
              smooth=Smooth.None));
          connect(status.busConnector,setup. busConnector)         annotation (Line(
              points={{54,-64},{-4,-64},{-4,-90}},
              color={0,0,255},
              thickness=0.5,
              smooth=Smooth.None));
          connect(electrolytes.busConnector,setup. busConnector) annotation (Line(
              points={{86,-18},{-4,-18},{-4,-90}},
              color={0,0,255},
              thickness=0.5,
              smooth=Smooth.None));
          connect(heat.busConnector,setup. busConnector) annotation (Line(
              points={{-36,46},{-4,46},{-4,-90}},
              color={0,0,255},
              thickness=0.5,
              smooth=Smooth.None));
          connect(ventilation_const.busConnector,proteins. busConnector) annotation (
              Line(
              points={{-24,-60},{-38,-60},{-38,-12},{-36,-12}},
              color={255,204,51},
              thickness=0.5,
              smooth=Smooth.None));
        connect(proteins.busConnector, O2.busConnector) annotation (Line(
            points={{-36,-12},{-46,-12},{-46,-84},{-56,-84}},
            color={255,204,51},
            thickness=0.5,
            smooth=Smooth.None));
        connect(proteins.busConnector, cO2_1.busConnector) annotation (Line(
            points={{-36,-12},{-54,-12},{-54,-40},{-72,-40}},
            color={0,0,255},
            thickness=0.5,
            smooth=Smooth.None));
        end CO2_test_SI;
      end IO_Bus;

      annotation (Documentation(revisions="<html>

<table>
<tr>
<td>Author:</td>
<td>Marek Matejak</td>
</tr>
<tr>
<td>License:</td>
<td><a href=\"http://www.physiomodel.org/license.html\">Physiomodel License 1.0</a> </td>
</tr>
<tr>
<td>By:</td>
<td>Charles University, Prague</td>
</tr>
<tr>
<td>Date of:</td>
<td>2009</td>
</tr>
<tr>
<td>References:</td>
<td>Tom Coleman: QHP 2008 beta 3, University of Mississippi Medical Center</td>
</tr><tr>
<td></td>
<td>Siggaard Andersen: OSA (2005), University of Copenhagen</td>
</tr>
</table>
<br/><p>Copyright &copy; 2014 Marek Matejak, Charles University in Prague.</p><br/>

</html>"));
    end CO2;

    package Ventilation
      model RespiratoryNeuralDrive3
        extends Physiolibrary.Icons.RespiratoryCenter;
      AfferentPath afferentPath annotation (Placement(transformation(
            extent={{-10,-10},{10,10}},
            origin={66,32})));
      Physiolibrary.Types.BusConnector busConnector annotation (Placement(
            transformation(extent={{-80,80},{-60,100}}), iconTransformation(
              extent={{-100,60},{-60,100}})));
        Physiomodel.Gases.Ventilation.PeripheralChemoreceptors peripheralChemoreceptors
        annotation (Placement(transformation(
            extent={{-10,-10},{10,10}},
            rotation=270,
            origin={-26,36})));
        Physiomodel.Gases.Ventilation.SkeletalMuscleMetaboreflex skeletalMuscleMetaboreflex
        annotation (Placement(transformation(extent={{-18,-16},{2,4}})));
        Physiomodel.Gases.Ventilation.CentralChemoreceptors centralChemoreceptors
        annotation (Placement(transformation(extent={{8,48},{28,68}})));
      EfferentPath efferentPath
        annotation (Placement(transformation(extent={{50,-22},{70,-2}})));
      /*  Modelica.Blocks.Logical.TerminateSimulation terminateSimulation(
      terminationText="solution reached", condition=false and (
        afferentPath.TotalDrive < efferentPath.TotalDrive))
    annotation (Placement(transformation(extent={{-10,-84},{70,-76}})));

Physiolibrary.Utilities.ConstantFromFile RespiratoryCenter_RespRate(
                                    varName="RespiratoryCenter-Output.Rate")
    "Respiration rate. [1/min]"
annotation (Placement(transformation(extent={{-92,-78},{-86,-72}})));
Physiolibrary.Utilities.ConstantFromFile
    RespiratoryCenter_MotorNerveActivity(     varName="RespiratoryCenter-Output.MotorNerveActivity")
    "Neural activity from respiratory center to respiratory muscle. []"
annotation (Placement(transformation(extent={{-92,-88},{-86,-82}})));
Physiolibrary.Utilities.ConstantFromFile
    RespiratoryCenterIntegration_TotalDrive(                                      varName=
        "RespiratoryCenter-Integration.TotalDrive")
    "RespiratoryCenter-Integration.TotalDrive"
annotation (Placement(transformation(extent={{16,-70},{22,-64}})));
  Physiolibrary.Blocks.Constant Constant(
                                   k=1.04494)
    annotation (Placement(transformation(extent={{24,-84},{32,-76}})));
  Modelica.Blocks.Sources.Clock clock(offset=0.75)
    annotation (Placement(transformation(extent={{-28,-80},{-8,-60}})));
*/
      Physiolibrary.Blocks.Math.HomotopyStrongComponentBreaker homotopy(
          defaultValue=1, defaultSlope=0.1)
        annotation (Placement(transformation(extent={{82,32},{90,40}})));
      Physiolibrary.Types.Constants.OneConst one
        annotation (Placement(transformation(extent={{8,-34},{16,-26}})));
      equation
       // efferentPath.TotalDrive=homotopy(actual=afferentPath.TotalDrive, simplified=1.045922);

        connect(busConnector, afferentPath.busConnector)      annotation (Line(
            points={{-70,90},{61.8,90},{61.8,40.2}},
            color={0,0,255},
            thickness=0.5,
            smooth=Smooth.None));
        connect(busConnector, peripheralChemoreceptors.busConnector)
                                                           annotation (Line(
            points={{-70,90},{-25.8,90},{-25.8,43.6}},
            color={0,0,255},
            thickness=0.5,
            smooth=Smooth.None));
        connect(peripheralChemoreceptors.Chemoreceptors_FiringRate,
          afferentPath.Chemoreceptors_FiringRate)
          annotation (Line(
            points={{-16,38},{58,38}},
            color={0,0,127},
            smooth=Smooth.None));
        connect(skeletalMuscleMetaboreflex.NA, afferentPath.Metaboreflex)
          annotation (Line(
            points={{2,-6},{28,-6},{28,34},{56.2,34}},
            color={0,0,127},
            smooth=Smooth.None));
        connect(busConnector.skeletalMuscle_pH_intracellular,
          skeletalMuscleMetaboreflex.skeletalMuscle_pH) annotation (Line(
            points={{-70,90},{-70,-6},{-18,-6}},
            color={0,0,255},
            thickness=0.5,
            smooth=Smooth.None), Text(
            string="%first",
            index=-1,
            extent={{-6,3},{-6,3}}));
        connect(busConnector.GangliaGeneral_NA, peripheralChemoreceptors.GangliaGeneral_NA)
          annotation (Line(
            points={{-70,90},{-70,40},{-36,40}},
            color={0,0,255},
            thickness=0.5,
            smooth=Smooth.None), Text(
            string="%first",
            index=-1,
            extent={{-6,3},{-6,3}}));
        connect(busConnector.brain_pH_intracellular, centralChemoreceptors.Brain_pH_intracellular)
          annotation (Line(
            points={{-70,90},{-70,64},{10,64}},
            color={0,0,255},
            thickness=0.5,
            smooth=Smooth.None), Text(
            string="%first",
            index=-1,
            extent={{-6,3},{-6,3}}));
        connect(busConnector.O2Artys_PO2, peripheralChemoreceptors.artys_pO2)
                                                                    annotation (
            Line(
            points={{-70,90},{-70,32},{-36,32}},
            color={0,0,255},
            thickness=0.5,
            smooth=Smooth.None), Text(
            string="%first",
            index=-1,
            extent={{-6,3},{-6,3}}));
        connect(busConnector.Artys_pH, peripheralChemoreceptors.artys_ph)
                                                                annotation (Line(
            points={{-70,90},{-70,36},{-36,36}},
            color={0,0,255},
            thickness=0.5,
            smooth=Smooth.None), Text(
            string="%first",
            index=-1,
            extent={{-6,3},{-6,3}}));
        connect(efferentPath.RespRate, busConnector.RespiratoryCenter_RespRate)
          annotation (Line(
            points={{69.4,-8},{98,-8},{98,90},{-70,90}},
            color={0,0,127},
            smooth=Smooth.None), Text(
            string="%second",
            index=1,
            extent={{6,3},{6,3}}));
        connect(efferentPath.RespiratoryCenterOutput_MotorNerveActivity,
          busConnector.RespiratoryCenter_MotorNerveActivity) annotation (Line(
            points={{69.6,-16},{98,-16},{98,90},{-70,90}},
            color={0,0,127},
            smooth=Smooth.None), Text(
            string="%second",
            index=1,
            extent={{6,3},{6,3}}));
        connect(efferentPath.busConnector, busConnector)              annotation (
           Line(
            points={{55.8,-3.8},{50,-3.8},{50,90},{-70,90}},
            color={0,0,255},
            thickness=0.5,
            smooth=Smooth.None));

        connect(centralChemoreceptors.CentralChemoreceptors, afferentPath.CentralChemoreceptors)
          annotation (Line(
            points={{27.4,62},{38,62},{38,29},{58,29}},
            color={0,0,127},
            smooth=Smooth.None));
      connect(afferentPath.TotalDrive, homotopy.u) annotation (Line(
          points={{75.4,36},{81.2,36}},
          color={0,0,127},
          smooth=Smooth.None));
      connect(one.y, efferentPath.TotalDrive) annotation (Line(
          points={{17,-30},{34,-30},{34,-10},{50.2,-10}},
          color={0,0,127},
          smooth=Smooth.None));
        annotation ( Icon(coordinateSystem(
                preserveAspectRatio=true, extent={{-100,-100},{100,100}}),
              graphics={Text(
                extent={{-142,-108},{142,-140}},
                lineColor={0,0,255},
                textString="%name")}));
      end RespiratoryNeuralDrive3;

      model AfferentPath
        extends Physiolibrary.Icons.RespiratoryCenter;
        parameter Real RadiationTotalDrive[:,3]={{    0,  0.0,  0}, {  500,  3.5,  0.003}, { 1000,  4.0,  0}};
        parameter Real OutputRate[:,3]={{  0,   0,  12}, {  1,  12,   4}, { 10,  40,   0}};

        Physiolibrary.Types.RealIO.FractionOutput TotalDrive
          annotation (Placement(transformation(extent={{80,-20},{120,20}}),
              iconTransformation(extent={{74,20},{114,60}})));
      Physiolibrary.Types.BusConnector busConnector annotation (Placement(
            transformation(extent={{-42,82},{-22,102}}), iconTransformation(
              extent={{-62,62},{-22,102}})));
        Physiolibrary.Types.RealIO.FractionInput Chemoreceptors_FiringRate
          annotation (Placement(transformation(extent={{-100,40},{-60,80}}),
              iconTransformation(extent={{-100,40},{-60,80}})));
      Physiolibrary.Blocks.Interpolation.Curve Radiation(
        x=RadiationTotalDrive[:, 1],
        y=RadiationTotalDrive[:, 2],
        slope=RadiationTotalDrive[:, 3])
        annotation (Placement(transformation(extent={{-10,12},{10,32}})));
        Modelica.Blocks.Math.Add RespiratoryCenterChemical_TotalDrive(k1=0.6,
            k2=0.4)
          annotation (Placement(transformation(extent={{36,52},{56,72}})));
        Physiolibrary.Types.RealIO.FractionInput Metaboreflex
          annotation (Placement(transformation(extent={{-120,0},{-80,40}}),
              iconTransformation(extent={{-118,0},{-78,40}})));
        Modelica.Blocks.Math.Add RespiratoryCenterExercise_TotalDrive
          annotation (Placement(transformation(extent={{26,18},{46,38}})));
        Modelica.Blocks.Math.Add RespiratoryCenterIntegration_TotalDrive
          annotation (Placement(transformation(extent={{66,24},{86,44}})));
        Physiolibrary.Types.RealIO.FractionInput CentralChemoreceptors
          annotation (Placement(transformation(extent={{-100,66},{-60,106}}),
              iconTransformation(extent={{-100,-50},{-60,-10}})));
      equation
        connect(Radiation.val, RespiratoryCenterExercise_TotalDrive.u2) annotation (
            Line(
            points={{10,22},{24,22}},
            color={0,0,127},
            smooth=Smooth.None));
        connect(Metaboreflex, RespiratoryCenterExercise_TotalDrive.u1) annotation (
            Line(
            points={{-100,20},{-44,20},{-44,34},{24,34}},
            color={0,0,127},
            smooth=Smooth.None));
        connect(RespiratoryCenterChemical_TotalDrive.y,
          RespiratoryCenterIntegration_TotalDrive.u1) annotation (Line(
            points={{57,62},{60,62},{60,40},{64,40}},
            color={0,0,127},
            smooth=Smooth.None));
        connect(RespiratoryCenterExercise_TotalDrive.y,
          RespiratoryCenterIntegration_TotalDrive.u2) annotation (Line(
            points={{47,28},{64,28}},
            color={0,0,127},
            smooth=Smooth.None));
        connect(RespiratoryCenterChemical_TotalDrive.u1, CentralChemoreceptors)
          annotation (Line(
            points={{34,68},{-18,68},{-18,86},{-80,86}},
            color={0,0,127},
            smooth=Smooth.None));

        connect(RespiratoryCenterIntegration_TotalDrive.y, TotalDrive)
          annotation (Line(
            points={{87,34},{94,34},{94,0},{100,0}},
            color={0,0,127},
            smooth=Smooth.None));
        connect(Chemoreceptors_FiringRate, RespiratoryCenterChemical_TotalDrive.u2)
          annotation (Line(
            points={{-80,60},{-23,60},{-23,56},{34,56}},
            color={0,0,127},
            smooth=Smooth.None));
      connect(busConnector.Exercise_Metabolism_MotionWatts, Radiation.u)
        annotation (Line(
          points={{-32,92},{-32,22},{-10,22}},
          color={0,0,255},
          thickness=0.5,
          smooth=Smooth.None), Text(
          string="%first",
          index=-1,
          extent={{-6,3},{-6,3}}));
        annotation ( Icon(coordinateSystem(
                preserveAspectRatio=true,  extent={{-100,-100},{100,100}}),
              graphics={
              Text(
                extent={{-66,32},{76,-22}},
                lineColor={0,0,0},
                fillColor={213,255,170},
                fillPattern=FillPattern.Solid,
                textString="%name"),
              Text(
                extent={{-124,-104},{124,-130}},
                lineColor={0,0,255},
                textString="%name")}));
      end AfferentPath;

      model EfferentPath
        extends Physiolibrary.Icons.RespiratoryCenter;
        parameter Real RadiationTotalDrive[:,3]={{    0,  0.0,  0}, {  500,  3.5,  0.003}, { 1000,  4.0,  0}};
        parameter Real OutputRate[:,3]={{  0,   0,  12}, {  1,  12,   4}, { 10,  40,   0}};

      Physiolibrary.Blocks.Interpolation.Curve RespiratoryCenterOutput(
        x=OutputRate[:, 1],
        y=OutputRate[:, 2],
        slope=OutputRate[:, 3],
        Yscale=1/60)
        annotation (Placement(transformation(extent={{-10,-16},{10,4}})));
        Physiolibrary.Types.RealIO.FrequencyOutput RespRate
          annotation (Placement(transformation(extent={{80,-20},{120,20}}),
              iconTransformation(extent={{74,20},{114,60}})));
        Physiolibrary.Types.RealIO.FractionOutput
          RespiratoryCenterOutput_MotorNerveActivity
          annotation (Placement(transformation(extent={{54,-68},{94,-28}}),
              iconTransformation(extent={{76,-60},{116,-20}})));
      Physiolibrary.Types.BusConnector busConnector annotation (Placement(
            transformation(extent={{-42,82},{-22,102}}), iconTransformation(
              extent={{-62,62},{-22,102}})));
        Physiolibrary.Types.RealIO.FractionInput TotalDrive(
                                                 start=1)
          annotation (Placement(transformation(extent={{-120,0},{-80,40}}),
              iconTransformation(extent={{-118,0},{-78,40}})));
        Modelica.Blocks.Math.Product Rate
          annotation (Placement(transformation(extent={{62,-10},{82,10}})));
      Physiolibrary.Blocks.Factors.Normalization FunctionEffect
        annotation (Placement(transformation(extent={{14,-48},{34,-28}})));
      Physiolibrary.Blocks.Factors.Normalization AnesthesiaEffect
        annotation (Placement(transformation(extent={{14,-60},{34,-40}})));
      equation
        connect(RespiratoryCenterOutput.val, Rate.u2) annotation (Line(
            points={{10,-6},{60,-6}},
            color={0,0,127},
            smooth=Smooth.None));
        connect(Rate.y, RespRate) annotation (Line(
            points={{83,0},{100,0}},
            color={0,0,127},
            smooth=Smooth.None));
        connect(FunctionEffect.y, AnesthesiaEffect.yBase) annotation (Line(
            points={{24,-42},{24,-48}},
            color={0,0,127},
            smooth=Smooth.None));
        connect(AnesthesiaEffect.y, RespiratoryCenterOutput_MotorNerveActivity)
          annotation (Line(
            points={{24,-54},{24,-62},{64,-62},{64,-48},{74,-48}},
            color={0,0,127},
            smooth=Smooth.None));
        connect(busConnector.AnesthesiaTidalVolume, AnesthesiaEffect.u)
          annotation (Line(
            points={{-32,92},{-32,-50},{16,-50}},
            color={0,0,255},
            thickness=0.5,
            smooth=Smooth.None), Text(
            string="%first",
            index=-1,
            extent={{-6,3},{-6,3}}));
        connect(busConnector.brain_FunctionEffect, FunctionEffect.u) annotation (
            Line(
            points={{-32,92},{-32,-38},{16,-38}},
            color={0,0,255},
            thickness=0.5,
            smooth=Smooth.None), Text(
            string="%first",
            index=-1,
            extent={{-6,3},{-6,3}}));
        connect(busConnector.brain_FunctionEffect, Rate.u1) annotation (Line(
            points={{-32,92},{-32,6},{60,6}},
            color={0,0,255},
            thickness=0.5,
            smooth=Smooth.None), Text(
            string="%first",
            index=-1,
            extent={{-6,3},{-6,3}}));

        connect(TotalDrive, RespiratoryCenterOutput.u) annotation (Line(
            points={{-100,20},{-56,20},{-56,-6},{-10,-6}},
            color={0,0,127},
            smooth=Smooth.None));
        connect(TotalDrive, FunctionEffect.yBase) annotation (Line(
            points={{-100,20},{-56,20},{-56,-22},{24,-22},{24,-36}},
            color={0,0,127},
            smooth=Smooth.None));
        annotation ( Icon(coordinateSystem(
                preserveAspectRatio=true,  extent={{-100,-100},{100,100}}),
              graphics={
              Text(
                extent={{-66,32},{76,-22}},
                lineColor={0,0,0},
                fillColor={213,255,170},
                fillPattern=FillPattern.Solid,
                textString="%name"),
              Text(
                extent={{-122,-100},{126,-126}},
                lineColor={0,0,255},
                textString="%name")}));
      end EfferentPath;

      model CentralChemoreceptors
          extends Physiolibrary.Icons.RespiratoryCenter;

          parameter Real data[:,3]={{6.60,0.0,0},{6.85,10.0,0},{7.07,1.0,-8.0},{7.50,0.0,0}}; //{{6.60,0.0,0},{6.87,10.0,0},{7.12,1.0,-8.0},{7.50,0.0,0}};
        Physiolibrary.Types.RealIO.FractionOutput CentralChemoreceptors
          annotation (Placement(transformation(extent={{80,-20},{120,20}}),
              iconTransformation(extent={{74,20},{114,60}})));
        Physiolibrary.Types.RealIO.pHInput Brain_pH_intracellular
          annotation (Placement(transformation(extent={{-100,40},{-60,80}}),
              iconTransformation(extent={{-100,40},{-60,80}})));                                                //orginal data from Coleman {{6.60,0.0,0},{6.87,10.0,0},{7.22,1.0,-8.0},{7.50,0.0,0}}) was corrected, becase the normal intracellular pH in neuron cells is 7.16
      Physiolibrary.Blocks.Interpolation.Curve curve(
        x=data[:, 1],
        y=data[:, 2],
        slope=data[:, 3])
        annotation (Placement(transformation(extent={{18,-10},{38,10}})));
      equation

        connect(curve.val, CentralChemoreceptors) annotation (Line(
            points={{38,0},{100,0}},
            color={0,0,127},
            smooth=Smooth.None));
        connect(Brain_pH_intracellular, curve.u) annotation (Line(
            points={{-80,60},{-32,60},{-32,0},{18,0}},
            color={0,0,127},
            smooth=Smooth.None));
        annotation ( Icon(coordinateSystem(
                preserveAspectRatio=true,  extent={{-100,-100},{100,100}}),
              graphics={
              Text(
                extent={{-66,32},{76,-22}},
                lineColor={0,0,0},
                fillColor={213,255,170},
                fillPattern=FillPattern.Solid,
                textString="%name"),
              Text(
                extent={{-118,-104},{130,-130}},
                lineColor={0,0,255},
                textString="%name")}));
      end CentralChemoreceptors;

      model PeripheralChemoreceptors
        extends Physiolibrary.Icons.PeripheralChemoreceptors;
      Physiolibrary.Blocks.Interpolation.Curve PhEffectCurve(
        x=PhEffect[:, 1],
        y=PhEffect[:, 2],
        slope=PhEffect[:, 3])
        annotation (Placement(transformation(extent={{-24,8},{12,44}})));
        Physiolibrary.Types.RealIO.FractionOutput
                                              Chemoreceptors_FiringRate
          annotation (Placement(transformation(extent={{98,-18},{122,6}}),
              iconTransformation(
              extent={{-20,-20},{20,20}},
              rotation=90,
              origin={-20,100})));
        parameter Real PhEffect[:,3]={{7.1,2,0},{7.4,0.4,-3},{7.7,0,0}}; //Orginal values from Coleman {{ 7.10,  2.0,  0}, { 7.44,  0.4,  -3.0}, { 7.70,  0.0,  0}} was corrected, because normal arteries pH is not 7.44 but 7.4
        parameter Real PO2Effect[:,3]={{  30,  10.0,  0}, {  60,   2.0,  -0.05}, {  85,   0.5,  -0.005}, { 200,   0.2,  0}}; //Orginal values from Coleman {{  30,  10.0,  0}, {  60,   2.0,  -0.05}, {  94,   0.5,  -0.005}, { 400,   0.2,  0}} was corrected, because normal arteries pO2 is not 94 but 85
        parameter Real PO2Effect_original[:,3]={{  30,  10.0,  0}, {  60,   2.0,  -0.05}, {  94,   0.5,  -0.005}, { 200,   0.2,  0}};
        parameter Real SteadyState[:,3]={{  0,  0,  0}, {  1,  1,  0.3}, { 10,  2,  0}};
        parameter Physiolibrary.Types.Time Tau(displayUnit="h") = 20*60*60;

      Physiolibrary.Types.BusConnector busConnector annotation (Placement(
            transformation(extent={{-102,64},{-82,84}}), iconTransformation(
              extent={{-96,-18},{-56,22}})));
        Physiolibrary.Types.RealIO.FractionInput
                                             GangliaGeneral_NA
          annotation (Placement(transformation(extent={{-74,44},{-48,70}}),
              iconTransformation(extent={{-20,-20},{20,20}},
              rotation=90,
              origin={-40,-100})));
        Physiomodel.Nerves.AplhaReceptorsActivityFactor aplhaReceptorsActivityFactor(
          data={{0,0.0,0},{1,0.1,0.2},{4,0.6,0}},
          NEURALK=0.5,
          HUMORALK=0.5)
          annotation (Placement(transformation(extent={{-26,68},{-6,88}})));
      Physiolibrary.Types.Constants.FractionConst             Constant(k=1)
        annotation (Placement(transformation(extent={{-30,90},{-22,98}})));
      Physiolibrary.Blocks.Interpolation.Curve PO2EffectCurve(
        x=PO2Effect[:, 1],
        y=PO2Effect[:, 2],
        slope=PO2Effect[:, 3],
          Xscale=101325/760)
        annotation (Placement(transformation(extent={{-24,-38},{12,-2}})));
        Modelica.Blocks.Math.Sum sum(nin=3)
          annotation (Placement(transformation(extent={{32,0},{52,20}})));
        Modelica.Blocks.Math.Product product
          annotation (Placement(transformation(extent={{74,-16},{94,4}})));
      Physiolibrary.Blocks.Interpolation.Curve SteadyStateCurve(
        x=SteadyState[:, 1],
        y=SteadyState[:, 2],
        slope=SteadyState[:, 3]) "ChemoreceptorAcclimation"
        annotation (Placement(transformation(extent={{-62,-96},{-26,-60}})));
        Modelica.Blocks.Math.Feedback feedback
          annotation (Placement(transformation(extent={{-8,-88},{12,-68}})));
      Physiolibrary.Blocks.Math.Integrator integrator(
        stateName="ChemoreceptorAcclimation.Effect",
        y_start=1.01445,
          k=1/Tau) "ChemoreceptorAcclimation.Effect"
        annotation (Placement(transformation(extent={{24,-88},{44,-68}})));
        Physiolibrary.Types.RealIO.pHInput   artys_ph
          annotation (Placement(transformation(extent={{-106,16},{-66,56}}),
              iconTransformation(extent={{-20,-20},{20,20}},
              rotation=90,
              origin={0,-100})));
        Physiolibrary.Types.RealIO.PressureInput
                                             artys_pO2
          annotation (Placement(transformation(extent={{-106,-20},{-66,20}}),
              iconTransformation(extent={{-20,-20},{20,20}},
              rotation=90,
              origin={40,-100})));
      Physiolibrary.Blocks.Interpolation.Curve PO2EffectCurve1(
        x=PO2Effect_original[:, 1],
        y=PO2Effect_original[:, 2],
        slope=PO2Effect_original[:, 3],
          Xscale=101325/760)
        annotation (Placement(transformation(extent={{40,52},{76,88}})));
      equation
        assert(artys_pO2>30,"artys_pO2 should be greater then 30 mmHg!");
        connect(Constant.y, aplhaReceptorsActivityFactor.yBase) annotation (Line(
            points={{-21,94},{-16,94},{-16,85}},
            color={0,0,127},
            smooth=Smooth.None));
        connect(busConnector.AlphaPool_Effect, aplhaReceptorsActivityFactor.AlphaPool_Effect)
          annotation (Line(
            points={{-92,74},{-60,74},{-60,84},{-25.8,84}},
            color={0,0,255},
            thickness=0.5,
            smooth=Smooth.None), Text(
            string="%first",
            index=-1,
            extent={{-6,3},{-6,3}}));
        connect(busConnector.AlphaBlocade_Effect, aplhaReceptorsActivityFactor.AlphaBlockade_Effect)
          annotation (Line(
            points={{-92,74},{-60,74},{-60,78},{-25.8,78}},
            color={0,0,255},
            thickness=0.5,
            smooth=Smooth.None), Text(
            string="%first",
            index=-1,
            extent={{-6,3},{-6,3}}));
        connect(aplhaReceptorsActivityFactor.GangliaGeneral_NA, GangliaGeneral_NA)
          annotation (Line(
            points={{-25.8,72},{-46,72},{-46,57},{-61,57}},
            color={0,0,127},
            smooth=Smooth.None));
        connect(PhEffectCurve.val, sum.u[2]) annotation (Line(
            points={{12,26},{26,26},{26,10},{30,10}},
            color={0,0,127},
            smooth=Smooth.None));
        connect(aplhaReceptorsActivityFactor.y, sum.u[1]) annotation (Line(
            points={{-16,71},{-16,54},{26,54},{26,8.66667},{30,8.66667}},
            color={0,0,127},
            smooth=Smooth.None));
        connect(product.y, Chemoreceptors_FiringRate) annotation (Line(
            points={{95,-6},{110,-6}},
            color={0,0,127},
            smooth=Smooth.None));
        connect(sum.y, product.u1) annotation (Line(
            points={{53,10},{60,10},{60,0},{72,0}},
            color={0,0,127},
            smooth=Smooth.None));
        connect(sum.y, SteadyStateCurve.u) annotation (Line(
            points={{53,10},{60,10},{60,-42},{-82,-42},{-82,-78},{-62,-78}},
            color={0,0,127},
            smooth=Smooth.None));
        connect(integrator.y, product.u2) annotation (Line(
            points={{45,-78},{66,-78},{66,-12},{72,-12}},
            color={0,0,127},
            smooth=Smooth.None));
        connect(SteadyStateCurve.val, feedback.u1) annotation (Line(
            points={{-26,-78},{-6,-78}},
            color={0,0,127},
            smooth=Smooth.None));
        connect(integrator.y, feedback.u2) annotation (Line(
            points={{45,-78},{56,-78},{56,-98},{2,-98},{2,-86}},
            color={0,0,127},
            smooth=Smooth.None));
        connect(feedback.y, integrator.u) annotation (Line(
            points={{11,-78},{22,-78}},
            color={0,0,127},
            smooth=Smooth.None));
        connect(PhEffectCurve.u, artys_ph) annotation (Line(
            points={{-24,26},{-50,26},{-50,36},{-86,36}},
            color={0,0,127},
            smooth=Smooth.None));
        connect(PO2EffectCurve.u, artys_pO2) annotation (Line(
            points={{-24,-20},{-50,-20},{-50,0},{-86,0}},
            color={0,0,127},
            smooth=Smooth.None));
        connect(artys_pO2, PO2EffectCurve1.u) annotation (Line(
            points={{-86,0},{20,0},{20,70},{40,70}},
            color={0,0,127},
            smooth=Smooth.None));
        connect(PO2EffectCurve1.val, sum.u[3]) annotation (Line(
            points={{76,70},{88,70},{88,32},{26,32},{26,11.3333},{30,11.3333}},
            color={0,0,127},
            smooth=Smooth.None));

        annotation ( Icon(coordinateSystem(
                preserveAspectRatio=true, extent={{-100,-100},{100,100}}),
              graphics={Text(
                extent={{-124,13},{124,-13}},
                lineColor={0,0,255},
                textString="%name",
                origin={122,-9},
                rotation=90)}));
      end PeripheralChemoreceptors;

      model SkeletalMuscleMetaboreflex
        extends Physiolibrary.Icons.SkeletalMuscleAcidity;
        Physiolibrary.Types.RealIO.pHInput skeletalMuscle_pH
                                               annotation (Placement(transformation(
                extent={{-120,-20},{-80,20}}), iconTransformation(extent={{-110,-10},
                  {-90,10}})));
      Physiolibrary.Blocks.Interpolation.Curve NerveActivity(
        x=PhOnNerveActivity[:, 1],
        y=PhOnNerveActivity[:, 2],
        slope=PhOnNerveActivity[:, 3])
        annotation (Placement(transformation(extent={{-10,-18},{26,18}})));
        Physiolibrary.Types.RealIO.FractionOutput NA
          annotation (Placement(transformation(extent={{80,-20},{120,20}})));
         parameter Real PhOnNerveActivity[:,3]={{ 6.5,  5.0,  0}, { 6.9,  0.0,  0}};

      equation
        connect(NerveActivity.val, NA)      annotation (Line(
            points={{26,0},{100,0}},
            color={0,0,127},
            smooth=Smooth.None));
        connect(skeletalMuscle_pH, NerveActivity.u) annotation (Line(
            points={{-100,0},{-10,0}},
            color={0,0,127},
            smooth=Smooth.None));
        annotation ( Icon(coordinateSystem(
                preserveAspectRatio=true, extent={{-100,-100},{100,100}}),
              graphics={
              Text(
                extent={{-128,-106},{120,-132}},
                lineColor={0,0,255},
                textString="%name")}));
      end SkeletalMuscleMetaboreflex;

      model GasEquation

        Physiolibrary.Types.RealIO.VolumeInput
                                           V1(
                                         displayUnit="ml") annotation (Placement(transformation(extent={
                  {-118,42},{-78,82}}), iconTransformation(extent={{-100,66},{-72,94}})));
        Physiolibrary.Types.RealIO.PressureInput
                                           P1(
                                         displayUnit="mmHg") annotation (Placement(transformation(extent={
                  {-118,42},{-78,82}}), iconTransformation(extent={{-100,6},{-72,34}})));
        Physiolibrary.Types.RealIO.TemperatureInput
                                           T1(
                                         displayUnit="degC") annotation (Placement(transformation(extent={
                  {-118,42},{-78,82}}), iconTransformation(extent={{-100,-54},{-72,
                  -26}})));
        Physiolibrary.Types.RealIO.PressureInput
                                           P2(
                                        displayUnit="mmHg") annotation (Placement(transformation(extent={
                  {-118,42},{-78,82}}), iconTransformation(
              extent={{-14,-14},{14,14}},
              rotation=180,
              origin={86,20})));
        Physiolibrary.Types.RealIO.TemperatureInput
                                           T2(
                                         displayUnit="degC") annotation (Placement(transformation(extent={
                  {-118,42},{-78,82}}), iconTransformation(
              extent={{-14,-14},{14,14}},
              rotation=180,
              origin={86,-40})));
        Physiolibrary.Types.RealIO.VolumeOutput
                                            V2(
                                          displayUnit="ml") annotation (Placement(transformation(extent=
                  {{56,54},{96,94}}), iconTransformation(extent={{72,66},{100,94}})));
      equation
        (P1*V1)/(T1)=(P2*V2)/(T2);
        annotation (Icon(coordinateSystem(preserveAspectRatio=true, extent={{-100,
                  -100},{100,100}}), graphics={
              Rectangle(
                extent={{-100,100},{100,-100}},
                lineColor={0,0,0},
                fillColor={170,213,255},
                fillPattern=FillPattern.Solid),
              Rectangle(
                extent={{0,100},{0,-100}},
                lineColor={0,0,0},
                fillColor={170,213,255},
                fillPattern=FillPattern.Solid),
              Text(
                extent={{-98,136},{100,100}},
                lineColor={0,0,0},
                fillColor={170,213,255},
                fillPattern=FillPattern.Solid,
                textString="%name")}));
      end GasEquation;

      model VaporPressure

        Physiolibrary.Types.RealIO.TemperatureInput
                                           T(
                                        displayUnit="degC")   annotation (Placement(transformation(extent={
                  {-118,42},{-78,82}}), iconTransformation(extent={{-100,-14},{-72,14}})));
        Physiolibrary.Types.RealIO.PressureOutput
                                            VaporPressure_(
                                                    displayUnit="mmHg")
                                                          annotation (Placement(transformation(extent=
                  {{56,54},{96,94}}), iconTransformation(extent={{100,-14},{128,14}})));
      equation
       VaporPressure_ =  if T<273.15 then 0 else if T>373.15 then 101325 else
                          (101325/760)*exp(18.6686-(4030.183/(T-273.15+235)));
        annotation (Icon(coordinateSystem(preserveAspectRatio=true, extent={{-100,
                  -100},{100,100}}), graphics={Rectangle(
                extent={{-100,40},{100,-40}},
                lineColor={0,0,0},
                fillColor={170,213,255},
                fillPattern=FillPattern.Solid)}));
      end VaporPressure;

      model NaturalVentilation2
        extends Physiolibrary.Icons.Ventilation;
        Physiolibrary.Types.RealIO.FrequencyInput
          RespiratoryCenterOutput_MotorNerveActivity(
             displayUnit="Hz")                             annotation (Placement(transformation(extent={{-88,40},
                  {-48,80}}),           iconTransformation(extent={{-100,66},{-72,94}})));
        Physiolibrary.Types.RealIO.FractionInput Thorax_LungInflation(
                                                            displayUnit="1")
                                                           annotation (Placement(transformation(extent={{-88,-22},
                  {-48,18}}),           iconTransformation(extent={{-100,-54},{
                  -72,-26}})));
        Physiolibrary.Types.RealIO.VolumeInput ExcessLungWater_Volume(
                                                             displayUnit=
              "1")                                      annotation (Placement(transformation(extent={{-88,-58},
                  {-48,-18}}),          iconTransformation(extent={{-100,-94},{
                  -72,-66}})));
        Physiolibrary.Types.RealIO.VolumeOutput TidalVolume(
                                                   displayUnit="ml")
                                                          annotation (Placement(transformation(extent={{52,-48},
                  {92,-8}}),          iconTransformation(extent={{100,6},{128,34}})));
        Physiolibrary.Types.RealIO.VolumeOutput DeadSpace(
                                                  displayUnit="ml")
                                                          annotation (Placement(transformation(extent={{14,-96},
                  {54,-56}}),         iconTransformation(extent={{100,-54},{128,
                  -26}})));
        Physiolibrary.Types.RealIO.FractionInput RespiratoryMuscleFunctionEffect(
                                                                      displayUnit= "1")
                                                        annotation (Placement(transformation(extent={{-88,6},
                  {-48,46}}),           iconTransformation(extent={{-100,26},{-72,
                  54}})));

        parameter Physiolibrary.Types.Fraction DeadSpaceSlope =   0.20;
        parameter Physiolibrary.Types.Volume DeadSpaceMin =                            60.0e-6;
        parameter Real[:,3] DriveOnTidalVolume =  {{  0,     0,    0}, {  1,   450,  400}, { 10,  2630,    0}};  //corrected from {{  0,     0,    0}, {  1,   550,  400}, { 10,  2630,    0}}

      // Real TidalVolumeBasic;
      Physiolibrary.Blocks.Interpolation.Curve curve(
        x=DriveOnTidalVolume[:, 1],
        y=DriveOnTidalVolume[:, 2],
        slope=DriveOnTidalVolume[:, 3],
        Yscale=1e-6)
        annotation (Placement(transformation(extent={{-2,32},{18,52}})));

      Physiolibrary.Blocks.Factors.Normalization LungInflation
        annotation (Placement(transformation(extent={{16,6},{36,26}})));
      Physiolibrary.Blocks.Factors.Normalization FunctionEffect
        annotation (Placement(transformation(extent={{16,16},{36,36}})));
        Modelica.Blocks.Math.Max max
          annotation (Placement(transformation(extent={{36,-38},{56,-18}})));
        Modelica.Blocks.Math.Feedback tidalVol0 annotation (Placement(transformation(
              extent={{-10,-10},{10,10}},
              rotation=270,
              origin={26,-2})));
      Physiolibrary.Types.Constants.VolumeConst Breathing_TidalVolumeMin(k=0)
        "Breathing.TidalVolumeMin"
        annotation (Placement(transformation(extent={{4,-42},{20,-26}})));
      Physiolibrary.Types.Constants.VolumeConst Breathing_DeadSpaceMin(k=
            DeadSpaceMin) "Breathing.DeadSpaceMin"
        annotation (Placement(transformation(extent={{-88,-102},{-58,-72}})));
      Physiolibrary.Types.Constants.FractionConst             deadSpaceSlope(k=
            DeadSpaceSlope)
        annotation (Placement(transformation(extent={{-82,-80},{-58,-56}})));
        Modelica.Blocks.Math.Product product
          annotation (Placement(transformation(extent={{-30,-72},{-10,-52}})));
        Modelica.Blocks.Math.Add add
          annotation (Placement(transformation(extent={{2,-86},{22,-66}})));
      equation
      //  u=RespiratoryCenterOutput_MotorNerveActivity; //curve x value
      /*
  TidalVolumeBasic  =
      curve.val
    * Thorax_LungInflation
    * RespiratoryMuscleFunctionEffect;   //val.. curve y value

   TidalVolume  = max(0, TidalVolumeBasic - ExcessLungWater_Volume);
   DeadSpace  =  DeadSpaceSlope * TidalVolume + DeadSpaceMin; */
        connect(RespiratoryCenterOutput_MotorNerveActivity, curve.u) annotation (Line(
            points={{-68,60},{-16,60},{-16,42},{-2,42}},
            color={0,0,127},
            smooth=Smooth.None));
        connect(RespiratoryMuscleFunctionEffect, FunctionEffect.u) annotation (Line(
            points={{-68,26},{18,26}},
            color={0,0,127},
            smooth=Smooth.None));
        connect(Thorax_LungInflation, LungInflation.u) annotation (Line(
            points={{-68,-2},{-32,-2},{-32,16},{18,16}},
            color={0,0,127},
            smooth=Smooth.None));
        connect(curve.val, FunctionEffect.yBase) annotation (Line(
            points={{18,42},{26,42},{26,28}},
            color={0,0,127},
            smooth=Smooth.None));
        connect(FunctionEffect.y, LungInflation.yBase) annotation (Line(
            points={{26,22},{26,18}},
            color={0,0,127},
            smooth=Smooth.None));
        connect(LungInflation.y, tidalVol0.u1) annotation (Line(
            points={{26,12},{26,6}},
            color={0,0,127},
            smooth=Smooth.None));
        connect(ExcessLungWater_Volume, tidalVol0.u2) annotation (Line(
            points={{-68,-38},{-16,-38},{-16,-2},{18,-2}},
            color={0,0,127},
            smooth=Smooth.None));
        connect(tidalVol0.y, max.u1) annotation (Line(
            points={{26,-11},{26,-22},{34,-22}},
            color={0,0,127},
            smooth=Smooth.None));
        connect(Breathing_TidalVolumeMin.y, max.u2)
                                          annotation (Line(
            points={{22,-34},{34,-34}},
            color={0,0,127},
            smooth=Smooth.None));
        connect(add.y, DeadSpace) annotation (Line(
            points={{23,-76},{34,-76}},
            color={0,0,127},
            smooth=Smooth.None));
        connect(deadSpaceSlope.y, product.u2) annotation (Line(
            points={{-55,-68},{-32,-68}},
            color={0,0,127},
            smooth=Smooth.None));
        connect(product.y, add.u1) annotation (Line(
            points={{-9,-62},{-6,-62},{-6,-70},{0,-70}},
            color={0,0,127},
            smooth=Smooth.None));
        connect(Breathing_DeadSpaceMin.y, add.u2)
                                           annotation (Line(
            points={{-54.25,-87},{-28,-87},{-28,-82},{0,-82}},
            color={0,0,127},
            smooth=Smooth.None));
        connect(product.u1, TidalVolume) annotation (Line(
            points={{-32,-56},{-42,-56},{-42,-46},{68,-46},{68,-28},{72,-28}},
            color={0,0,127},
            smooth=Smooth.None));
        connect(max.y, TidalVolume) annotation (Line(
            points={{57,-28},{72,-28}},
            color={0,0,127},
            smooth=Smooth.None));
        annotation (Icon(coordinateSystem(preserveAspectRatio=true, extent={{-100,
                  -100},{100,100}}), graphics={Text(
                extent={{-120,-108},{130,-126}},
                lineColor={0,0,255},
                textString="%name")}));
      end NaturalVentilation2;

      model AlveolarVentilation_STPD
        extends Physiolibrary.Icons.Lungs;
      //  parameter Real EnvironmentPressure(final displayUnit="mmHg");
      //  parameter Real EnvironmentTemperature(final displayUnit="degC");

        Physiolibrary.Types.RealIO.FrequencyInput RespRate
                                               annotation (Placement(transformation(
                extent={{26,68},{40,82}}),    iconTransformation(
              extent={{-20,-20},{20,20}},
              rotation=180,
              origin={80,20})));
        Physiolibrary.Types.RealIO.VolumeInput TidalVolume
                                                  annotation (Placement(
              transformation(
              extent={{-18,-18},{10,10}},
              origin={-50,-32}), iconTransformation(
              extent={{-20,-20},{20,20}},
              rotation=180,
              origin={80,100})));
        Physiolibrary.Types.RealIO.VolumeInput DeadSpace
                                                annotation (Placement(transformation(
                extent={{-68,-76},{-40,-48}}), iconTransformation(
              extent={{-20,-20},{20,20}},
              rotation=180,
              origin={80,60})));
        Physiolibrary.Types.RealIO.TemperatureInput core_T
                                               annotation (Placement(
              transformation(
              extent={{-20,-20},{8,8}},
              origin={-48,-80}), iconTransformation(
              extent={{-20,-20},{20,20}},
              rotation=180,
              origin={80,-20})));
        GasEquation tidalVolume(V2(start=400))
          annotation (Placement(transformation(extent={{-12,-54},{8,-34}})));
        GasEquation deadVolume(V2(start=150))
          annotation (Placement(transformation(extent={{-12,-80},{8,-60}})));
        Modelica.Blocks.Math.Product alveolarVentilation annotation (Placement(
            transformation(
            extent={{-10,-10},{10,10}},
            rotation=270,
            origin={54,52})));
        VaporPressure vaporPressure annotation (Placement(transformation(
              extent={{-10,-10},{10,10}},
              rotation=180,
              origin={14,90})));
        Modelica.Blocks.Math.Division vaporPart annotation (Placement(
              transformation(
              extent={{-6,-6},{6,6}},
              rotation=270,
              origin={-20,34})));
        Modelica.Blocks.Math.Feedback added_pH2O annotation (Placement(
              transformation(
              extent={{-7,-7},{7,7}},
              rotation=270,
              origin={-15,61})));
        VaporPressure vaporPressure1
                                    annotation (Placement(transformation(
              extent={{-10,-10},{10,10}},
              origin={-56,64})));
        Modelica.Blocks.Math.Product air_pH2O
          annotation (Placement(transformation(extent={{-36,68},{-26,78}})));
        Physiolibrary.Types.RealIO.TemperatureInput AmbientTemperature
                                               annotation (Placement(
              transformation(
              extent={{-20,-20},{8,8}},
              origin={-78,70}),  iconTransformation(
              extent={{-20,-20},{20,20}},
              origin={-80,100})));
        Physiolibrary.Types.RealIO.PressureInput EnvironmentPressure
                                               annotation (Placement(
              transformation(
              extent={{-20,-20},{8,8}},
              origin={-78,-4}),  iconTransformation(
              extent={{-20,-20},{20,20}},
              origin={-80,40})));
        Physiolibrary.Types.RealIO.FractionInput EnvironmentRelativeHumidity
                                               annotation (Placement(
              transformation(
              extent={{-20,-20},{8,8}},
              origin={-58,90}),  iconTransformation(
              extent={{-20,-20},{20,20}},
              origin={-80,-20})));
        Modelica.Blocks.Math.Feedback alveolarVolume
        annotation (Placement(transformation(extent={{58,-46},{78,-26}})));
        Modelica.Blocks.Math.Feedback airPressureWitoutVapor
          annotation (Placement(transformation(extent={{-64,0},{-44,-20}})));
        Physiolibrary.Types.RealIO.VolumeFlowRateOutput AlveolarVentilation
        annotation (Placement(transformation(extent={{70,22},{84,36}}),
            iconTransformation(
            extent={{-20,-20},{20,20}},
            origin={100,-60})));
        Modelica.Blocks.Math.Feedback dilution
          annotation (Placement(transformation(extent={{-30,20},{-10,0}})));
      Physiolibrary.Types.Constants.FractionConst             Constant(k=1)
        annotation (Placement(transformation(extent={{-48,6},{-40,14}})));
        Physiolibrary.Types.RealIO.FractionOutput BronchiDilution
                                               annotation (Placement(transformation(
                extent={{6,4},{18,16}}),      iconTransformation(
              extent={{-20,-20},{20,20}},
              origin={100,-100})));
      equation

        connect(TidalVolume,tidalVolume. V1) annotation (Line(
            points={{-54,-36},{-10.6,-36}},
            color={0,0,127},
            smooth=Smooth.None));
        connect(DeadSpace, deadVolume.V1)   annotation (Line(
            points={{-54,-62},{-10.6,-62}},
            color={0,0,127},
            smooth=Smooth.None));
      connect(RespRate, alveolarVentilation.u2) annotation (Line(
          points={{33,75},{48,75},{48,64}},
          color={0,0,127},
          smooth=Smooth.None));
        connect(core_T, vaporPressure.T)   annotation (Line(
            points={{-54,-86},{94,-86},{94,90},{22.6,90}},
            color={0,0,127},
            smooth=Smooth.None));
        connect(air_pH2O.y, added_pH2O.u2) annotation (Line(
            points={{-25.5,73},{-25.5,61},{-20.6,61}},
            color={0,0,127},
            smooth=Smooth.None));
        connect(added_pH2O.y, vaporPart.u1) annotation (Line(
            points={{-15,54.7},{-14,54.7},{-14,54},{-16,54},{-16,44},{-16.4,44},
              {-16.4,41.2}},
            color={0,0,127},
            smooth=Smooth.None));
        connect(AmbientTemperature, vaporPressure1.T) annotation (Line(
            points={{-84,64},{-64.6,64}},
            color={0,0,127},
            smooth=Smooth.None));
        connect(EnvironmentRelativeHumidity, air_pH2O.u1) annotation (Line(
            points={{-64,84},{-40,84},{-40,76},{-37,76}},
            color={0,0,127},
            smooth=Smooth.None));
        connect(core_T, tidalVolume.T1) annotation (Line(
            points={{-54,-86},{-32,-86},{-32,-48},{-10.6,-48}},
            color={0,0,127},
            smooth=Smooth.None));
        connect(core_T, deadVolume.T1) annotation (Line(
            points={{-54,-86},{-32,-86},{-32,-74},{-10.6,-74}},
            color={0,0,127},
            smooth=Smooth.None));
      connect(alveolarVolume.y, alveolarVentilation.u1) annotation (Line(
          points={{77,-36},{90,-36},{90,80},{60,80},{60,64}},
          color={0,0,127},
          smooth=Smooth.None));
      connect(tidalVolume.V2, alveolarVolume.u1) annotation (Line(
          points={{6.6,-36},{60,-36}},
          color={0,0,127},
          smooth=Smooth.None));
      connect(alveolarVolume.u2, deadVolume.V2) annotation (Line(
          points={{68,-44},{68,-62},{6.6,-62}},
          color={0,0,127},
          smooth=Smooth.None));
        connect(EnvironmentPressure, airPressureWitoutVapor.u1) annotation (Line(
            points={{-84,-10},{-62,-10}},
            color={0,0,127},
            smooth=Smooth.None));

        connect(airPressureWitoutVapor.y, tidalVolume.P1) annotation (Line(
            points={{-45,-10},{-28,-10},{-28,-42},{-10.6,-42}},
            color={0,0,127},
            smooth=Smooth.None));
        connect(airPressureWitoutVapor.y, deadVolume.P1) annotation (Line(
            points={{-45,-10},{-28,-10},{-28,-68},{-10.6,-68}},
            color={0,0,127},
            smooth=Smooth.None));

        connect(Constant.y, dilution.u1) annotation (Line(
            points={{-39,10},{-28,10}},
            color={0,0,127},
            smooth=Smooth.None));
        connect(vaporPart.y, dilution.u2) annotation (Line(
            points={{-20,27.4},{-20,18}},
            color={0,0,127},
            smooth=Smooth.None));
        connect(dilution.y, BronchiDilution) annotation (Line(
            points={{-11,10},{12,10}},
            color={0,0,127},
            smooth=Smooth.None));
      connect(vaporPressure1.VaporPressure_, air_pH2O.u2) annotation (Line(
          points={{-44.6,64},{-40,64},{-40,70},{-37,70}},
          color={0,0,127},
          smooth=Smooth.None));
      connect(vaporPressure.VaporPressure_, added_pH2O.u1) annotation (Line(
          points={{2.6,90},{-15,90},{-15,66.6}},
          color={0,0,127},
          smooth=Smooth.None));
      connect(alveolarVentilation.y, AlveolarVentilation) annotation (Line(
          points={{54,41},{54,29},{77,29}},
          color={0,0,127},
          smooth=Smooth.None));
      connect(added_pH2O.y, airPressureWitoutVapor.u2) annotation (Line(
          points={{-15,54.7},{-54,54.7},{-54,-2}},
          color={0,0,127},
          smooth=Smooth.None));
      connect(EnvironmentPressure, vaporPart.u2) annotation (Line(
          points={{-84,-10},{-70,-10},{-70,41.2},{-23.6,41.2}},
          color={0,0,127},
          smooth=Smooth.None));
      connect(EnvironmentPressure, tidalVolume.P2) annotation (Line(
          points={{-84,-10},{-70,-10},{-70,-22},{30,-22},{30,-42},{6.6,-42}},
          color={0,0,127},
          smooth=Smooth.None));
      connect(EnvironmentPressure, deadVolume.P2) annotation (Line(
          points={{-84,-10},{-70,-10},{-70,-22},{30,-22},{30,-68},{6.6,-68}},
          color={0,0,127},
          smooth=Smooth.None));
      connect(AmbientTemperature, tidalVolume.T2) annotation (Line(
          points={{-84,64},{-94,64},{-94,-98},{38,-98},{38,-48},{6.6,-48}},
          color={0,0,127},
          smooth=Smooth.None));
      connect(AmbientTemperature, deadVolume.T2) annotation (Line(
          points={{-84,64},{-94,64},{-94,-98},{38,-98},{38,-74},{6.6,-74}},
          color={0,0,127},
          smooth=Smooth.None));
       annotation (
          Icon(coordinateSystem(preserveAspectRatio=true, extent={{-100,-100},{
                  100,100}}), graphics={Text(
                extent={{-100,-100},{76,-70}},
                textString="%name",
                lineColor={0,0,255})}));
      end AlveolarVentilation_STPD;

      model AlveolarVentilation
        extends Physiolibrary.Icons.Lungs;
      //  parameter Real EnvironmentPressure(final displayUnit="mmHg");
      //  parameter Real EnvironmentTemperature(final displayUnit="degC");
      Physiolibrary.Chemical.Interfaces.ChemicalPort_b expired annotation (
          extent=[-10,-110; 10,-90], Placement(transformation(extent={{-10,-110},
                {10,-90}}, rotation=0),
                          iconTransformation(extent={{90,70},{110,90}})));

      Physiolibrary.Chemical.Interfaces.ChemicalPort_a inspired annotation (
          Placement(transformation(extent={{-120,8},{-80,48}}),
            iconTransformation(extent={{-110,70},{-90,90}})));
        Physiolibrary.Types.RealIO.VolumeFlowRateInput AlveolarVentilation_Env
        annotation (Placement(transformation(extent={{-14,44},{0,58}}),
            iconTransformation(
            extent={{-20,-20},{20,20}},
            rotation=180,
            origin={80,20})));
      Physiolibrary.Chemical.Components.Stream solventFlowPump(q_out(conc(start=
               0.13686)), useSolutionFlowInput=true)
        annotation (Placement(transformation(extent={{-2,18},{18,38}})));
      Physiolibrary.Chemical.Components.Dilution dilution(useDilutionInput=true)
                                                          annotation (Placement(
            transformation(
            extent={{-8,8},{12,-12}},
            origin={-26,30})));
      Physiolibrary.Chemical.Components.Stream solventFlowPump1(
          useSolutionFlowInput=true)
        annotation (Placement(transformation(extent={{44,18},{64,38}})));
      Physiolibrary.Chemical.Interfaces.ChemicalPort_b   alveolar annotation (
          extent=[-10,-110; 10,-90], Placement(transformation(extent={{-10,-110},
                {10,-90}}, rotation=0),
                          iconTransformation(extent={{-8,-110},{12,-90}})));
        Physiolibrary.Types.RealIO.FractionInput BronchiDilution
                                               annotation (Placement(
              transformation(
              extent={{-10.0004,-10.0004},{4.00021,4.00021}},
              origin={-78.0002,73.9998}),
                                 iconTransformation(
              extent={{-20,-20},{20,20}},
              rotation=180,
              origin={80,-40})));
      equation

        connect(solventFlowPump1.q_out, expired) annotation (Line(
            points={{64,28},{78,28}},
            color={200,0,0},
            smooth=Smooth.None,
            thickness=1));
        connect(solventFlowPump.q_out, solventFlowPump1.q_in) annotation (Line(
            points={{18,28},{44,28}},
            color={200,0,0},
            smooth=Smooth.None,
            thickness=1));

      connect(AlveolarVentilation_Env, solventFlowPump.solutionFlow)
        annotation (Line(
          points={{-7,51},{8,51},{8,35}},
          color={0,0,127},
          smooth=Smooth.None));
      connect(AlveolarVentilation_Env, solventFlowPump1.solutionFlow)
        annotation (Line(
          points={{-7,51},{54,51},{54,35}},
          color={0,0,127},
          smooth=Smooth.None));
        connect(BronchiDilution, dilution.dilution) annotation (Line(
            points={{-81.0003,70.9997},{-46,70.9997},{-46,20},{-34,20}},
            color={0,0,127},
            smooth=Smooth.None));
      connect(dilution.q_out, solventFlowPump.q_in) annotation (Line(
          points={{-14,28},{-2,28}},
          color={200,0,0},
          thickness=1,
          smooth=Smooth.None));
      connect(inspired, dilution.q_in) annotation (Line(
          points={{-100,28},{-34,28}},
          color={200,0,0},
          thickness=1,
          smooth=Smooth.None));
      connect(solventFlowPump.q_out, alveolar) annotation (Line(
          points={{18,28},{36,28},{36,-4},{30,-4}},
          color={107,45,134},
          thickness=1,
          smooth=Smooth.None));
       annotation (
          Icon(coordinateSystem(preserveAspectRatio=true, extent={{-100,-100},{
                  100,100}}), graphics={Polygon(
                points={{-38,93},{40,80},{-38,66},{-38,93}},
                lineColor={0,0,127},
                fillColor={255,255,255},
                fillPattern=FillPattern.Solid), Text(
                extent={{-92,-90},{84,-60}},
                textString="%name",
                lineColor={0,0,255})}));
      end AlveolarVentilation;

      model GasEquation_Flow

        Physiolibrary.Types.RealIO.VolumeFlowRateInput
                                           V1(
                                         displayUnit="ml/min") annotation (Placement(transformation(extent={
                  {-118,42},{-78,82}}), iconTransformation(extent={{-100,66},{-72,94}})));
        Physiolibrary.Types.RealIO.PressureInput
                                           P1(
                                         displayUnit="mmHg") annotation (Placement(transformation(extent={
                  {-118,42},{-78,82}}), iconTransformation(extent={{-100,6},{-72,34}})));
        Physiolibrary.Types.RealIO.TemperatureInput
                                           T1(
                                         displayUnit="degC") annotation (Placement(transformation(extent={
                  {-118,42},{-78,82}}), iconTransformation(extent={{-100,-54},{-72,
                  -26}})));
        Physiolibrary.Types.RealIO.PressureInput
                                           P2(
                                         displayUnit="mmHg") annotation (Placement(transformation(extent={
                  {-118,42},{-78,82}}), iconTransformation(
              extent={{-14,-14},{14,14}},
              rotation=180,
              origin={86,20})));
        Physiolibrary.Types.RealIO.TemperatureInput
                                           T2(
                                         displayUnit="degC") annotation (Placement(transformation(extent={
                  {-118,42},{-78,82}}), iconTransformation(
              extent={{-14,-14},{14,14}},
              rotation=180,
              origin={86,-40})));
        Physiolibrary.Types.RealIO.VolumeFlowRateOutput
                                            V2(
                                          displayUnit="ml/min") annotation (Placement(transformation(extent=
                  {{56,54},{96,94}}), iconTransformation(extent={{72,66},{100,94}})));
      equation
        (P1*V1)/(T1)=(P2*V2)/(T2);
        annotation (Icon(coordinateSystem(preserveAspectRatio=false,extent={{-100,
                -100},{100,100}}),   graphics={
              Rectangle(
                extent={{-100,100},{100,-100}},
                lineColor={0,0,0},
                fillColor={170,213,255},
                fillPattern=FillPattern.Solid),
              Rectangle(
                extent={{0,100},{0,-100}},
                lineColor={0,0,0},
                fillColor={170,213,255},
                fillPattern=FillPattern.Solid),
              Text(
                extent={{-98,136},{100,100}},
                lineColor={0,0,0},
                fillColor={170,213,255},
                fillPattern=FillPattern.Solid,
                textString="%name")}));
      end GasEquation_Flow;

      model Ventilation
        extends Physiolibrary.Icons.Ventilation;
      Physiolibrary.Types.BusConnector busConnector annotation (Placement(
            transformation(extent={{66,-30},{86,-10}}), iconTransformation(
              extent={{80,40},{120,80}})));
      AlveolarVentilation_STPD alveolarVentilation annotation (Placement(
            transformation(
            extent={{-10,-10},{10,10}},
            origin={-32,-38})));
        NaturalVentilation2 naturalVentilation(DriveOnTidalVolume={{0,0,0},{1,
            550,400},{10,2630,0}})
          annotation (Placement(transformation(extent={{46,2},{26,22}})));
        Modelica.Blocks.Math.Product TotalVentilation
          annotation (Placement(transformation(extent={{42,24},{48,30}})));
        RespiratoryNeuralDrive3 respiratoryNeuralDrive2_1
          annotation (Placement(transformation(extent={{-56,38},{-22,72}})));
      equation
        connect(alveolarVentilation.TidalVolume,naturalVentilation. TidalVolume)
          annotation (Line(
            points={{-24,-28},{2,-28},{2,14},{24.6,14}},
            color={0,0,127},
            smooth=Smooth.None));
        connect(alveolarVentilation.DeadSpace,naturalVentilation. DeadSpace)
          annotation (Line(
            points={{-24,-32},{6.3,-32},{6.3,8},{24.6,8}},
            color={0,0,127},
            smooth=Smooth.None));
        connect(naturalVentilation.ExcessLungWater_Volume,busConnector. ExcessLungWater_Volume)
          annotation (Line(
            points={{44.6,4},{76,4},{76,-20}},
            color={0,0,127},
            smooth=Smooth.None), Text(
            string="%second",
            index=1,
            extent={{6,3},{6,3}}));
        connect(naturalVentilation.Thorax_LungInflation,busConnector. Thorax_LungInflation)
          annotation (Line(
            points={{44.6,8},{76,8},{76,-20}},
            color={0,0,127},
            smooth=Smooth.None), Text(
            string="%second",
            index=1,
            extent={{6,3},{6,3}}));
        connect(naturalVentilation.RespiratoryMuscleFunctionEffect,busConnector. RespiratoryMuscleFunctionEffect)
          annotation (Line(
            points={{44.6,16},{76,16},{76,-20}},
            color={0,0,127},
            smooth=Smooth.None), Text(
            string="%second",
            index=1,
            extent={{6,3},{6,3}}));
        connect(naturalVentilation.RespiratoryCenterOutput_MotorNerveActivity,
          busConnector.RespiratoryCenter_MotorNerveActivity) annotation (Line(
            points={{44.6,20},{76,20},{76,-20}},
            color={0,0,127},
            smooth=Smooth.None), Text(
            string="%second",
            index=1,
            extent={{6,3},{6,3}}));
        connect(alveolarVentilation.core_T,busConnector. core_T)
          annotation (Line(
            points={{-24,-40},{18,-40},{18,-20},{76,-20}},
            color={0,0,127},
            smooth=Smooth.None), Text(
            string="%second",
            index=1,
            extent={{6,3},{6,3}}));
        connect(naturalVentilation.TidalVolume,TotalVentilation. u2)
          annotation (Line(
            points={{24.6,14},{4,14},{4,26},{41.4,26},{41.4,25.2}},
            color={0,0,127},
            smooth=Smooth.None));
        connect(busConnector.RespiratoryCenter_RespRate,TotalVentilation. u1)
          annotation (Line(
            points={{76,-20},{76,44},{24,44},{24,28.8},{41.4,28.8}},
            color={0,0,255},
            thickness=0.5,
            smooth=Smooth.None), Text(
            string="%first",
            index=-1,
            extent={{-6,3},{-6,3}}));
        connect(TotalVentilation.y,busConnector. BreathingTotalVentilation)
          annotation (Line(
            points={{48.3,27},{76,27},{76,-20}},
            color={0,0,127},
            smooth=Smooth.None), Text(
            string="%second",
            index=1,
            extent={{6,3},{6,3}}));
        connect(alveolarVentilation.RespRate,busConnector. RespiratoryCenter_RespRate)
          annotation (Line(
            points={{-24,-36},{18,-36},{18,-20},{76,-20}},
            color={0,0,127},
            smooth=Smooth.None), Text(
            string="%second",
            index=1,
            extent={{6,3},{6,3}}));
        connect(busConnector.BarometerPressure,alveolarVentilation. EnvironmentPressure)
          annotation (Line(
            points={{76,-20},{-72,-20},{-72,-34},{-40,-34}},
            color={0,0,255},
            thickness=0.5,
            smooth=Smooth.None), Text(
            string="%first",
            index=-1,
            extent={{-6,3},{-6,3}}));
        connect(busConnector.AmbientTemperature,alveolarVentilation. AmbientTemperature)
          annotation (Line(
            points={{76,-20},{-72,-20},{-72,-28},{-40,-28}},
            color={0,0,255},
            thickness=0.5,
            smooth=Smooth.None), Text(
            string="%first",
            index=-1,
            extent={{-6,3},{-6,3}}));
        connect(busConnector.EnvironmentRelativeHumidity,alveolarVentilation. EnvironmentRelativeHumidity)
          annotation (Line(
            points={{76,-20},{-72,-20},{-72,-40},{-40,-40}},
            color={0,0,255},
            thickness=0.5,
            smooth=Smooth.None), Text(
            string="%first",
            index=-1,
            extent={{-6,3},{-6,3}}));
        connect(respiratoryNeuralDrive2_1.busConnector, busConnector) annotation (
           Line(
            points={{-52.6,68.6},{76,68.6},{76,-20}},
            color={0,0,255},
            thickness=0.5,
            smooth=Smooth.None));
        connect(alveolarVentilation.BronchiDilution, busConnector.BronchiDilution)
          annotation (Line(
            points={{-22,-48},{76,-48},{76,-20}},
            color={0,0,127},
            smooth=Smooth.None), Text(
            string="%second",
            index=1,
            extent={{6,3},{6,3}}));
      connect(alveolarVentilation.AlveolarVentilation, busConnector.AlveolarVentilation_Env)
        annotation (Line(
          points={{-22,-44},{76,-44},{76,-20}},
          color={0,0,127},
          smooth=Smooth.None), Text(
          string="%second",
          index=1,
          extent={{6,3},{6,3}}));
        annotation (Icon(coordinateSystem(preserveAspectRatio=true, extent={{-100,
                  -100},{100,100}}), graphics={Text(
                extent={{-120,-108},{130,-126}},
                lineColor={0,0,255},
                textString="%name")}));
      end Ventilation;

      package IO_Bus
      extends Physiolibrary.Types.IO_Bus;
        redeclare model extends Variables
        //  extends Physiolibrary.Icons.Ventilation;

        T.Frequency RespiratoryCenter_RespRate(varName="RespiratoryCenter-Output.Rate")
          "Respiration rate."
        annotation (Placement(transformation(extent={{-44,-62},{-38,-56}})));
        T.Fraction RespiratoryCenter_MotorNerveActivity(varName="RespiratoryCenter-Output.MotorNerveActivity")
          "Neural activity from respiratory center to respiratory muscle."
        annotation (Placement(transformation(extent={{-44,-72},{-38,-66}})));
        T.VolumeFlowRate AlveolarVentilation_Env(varName=
              "AlveolarVentilation_Env")
          annotation (Placement(transformation(extent={{-22,76},{-16,82}})));
        T.Fraction Bronchi_Dilution(varName="Bronchi.Dilution")
        annotation (Placement(transformation(extent={{-44,-24},{-38,-18}})));
        T.VolumeFlowRate BreathingTotalVentilation(
                                  varName="Breathing.TotalVentilation")
        annotation (Placement(transformation(extent={{-34,10},{-28,16}})));
        equation

        connect(RespiratoryCenter_MotorNerveActivity.y, busConnector.RespiratoryCenter_MotorNerveActivity) annotation (Line(
         points={{-37.7,-69},{90,-69},{90,-2}},
              color={0,0,127},
              smooth=Smooth.None), Text(
              string="%second",
              index=1,
              extent={{6,3},{6,3}}));
        connect(RespiratoryCenter_RespRate.y, busConnector.RespiratoryCenter_RespRate) annotation (Line(
         points={{-37.7,-59},{90,-59},{90,-2}},
              color={0,0,127},
              smooth=Smooth.None), Text(
              string="%second",
              index=1,
              extent={{6,3},{6,3}}));
          connect(Bronchi_Dilution.y, busConnector.BronchiDilution) annotation (
              Line(
              points={{-37.7,-21},{26,-21},{26,-2},{90,-2}},
              color={0,0,127},
              smooth=Smooth.None), Text(
              string="%second",
              index=1,
              extent={{6,3},{6,3}}));
          connect(BreathingTotalVentilation.y, busConnector.BreathingTotalVentilation)
                                                                    annotation (
              Line(
              points={{-27.7,13},{15.65,13},{15.65,-2},{90,-2}},
              color={0,0,127},
              smooth=Smooth.None), Text(
              string="%second",
              index=1,
              extent={{6,3},{6,3}}));
        connect(AlveolarVentilation_Env.y, busConnector.AlveolarVentilation_Env)
          annotation (Line(
            points={{-15.7,79},{90,79},{90,-2}},
            color={0,0,127},
            smooth=Smooth.None), Text(
            string="%second",
            index=1,
            extent={{6,3},{6,3}}));
        end Variables;
      end IO_Bus;
    end Ventilation;

    model Gases
      extends Physiolibrary.Icons.Gases;

    Physiolibrary.Types.BusConnector busConnector annotation (Placement(
          transformation(extent={{38,-4},{58,16}}), iconTransformation(extent={
              {60,60},{100,100}})));
      O2.O2 oxygen annotation (Placement(transformation(extent={{-62,-24},{-42,
                -4}})));
      CO2.CO2 carbonDioxyd
        annotation (Placement(transformation(extent={{-22,-22},{-2,-2}})));
    Ventilation.Ventilation ventilation
      annotation (Placement(transformation(extent={{-50,28},{-30,48}})));
    equation
      connect(carbonDioxyd.busConnector, busConnector) annotation (Line(
          points={{-4,-6},{-4,6},{48,6}},
          color={0,0,255},
          thickness=0.5,
          smooth=Smooth.None));
      connect(oxygen.busConnector, busConnector) annotation (Line(
          points={{-44,-6},{-44,6},{48,6}},
          color={0,0,255},
          thickness=0.5,
          smooth=Smooth.None));
      connect(ventilation.busConnector, busConnector) annotation (Line(
          points={{-30,44},{-28,44},{-28,6},{48,6}},
          color={0,0,255},
          thickness=0.5,
          smooth=Smooth.None));
      annotation (Icon(coordinateSystem(preserveAspectRatio=true,  extent={{-100,
                -100},{100,100}}), graphics={
            Text(
              extent={{-122,-106},{126,-132}},
              lineColor={0,0,255},
              textString="%name"),
            Text(
              extent={{-82,24},{-8,58}},
              lineColor={0,0,0},
              textString="CO2"),
            Text(
              extent={{6,-64},{80,-30}},
              lineColor={0,0,0},
              textString="O2"),
            Text(
              extent={{-104,-70},{-30,-36}},
              lineColor={255,255,255},
              textString="pH")}));
    end Gases;

    package IO_Bus
      extends Physiolibrary.Types.IO_Bus;

      redeclare model extends Variables

      CO2.IO_Bus.Variables co2(T(redeclare block Variable = T.Variable))
        annotation (Placement(transformation(extent={{-14,-46},{6,-26}})));
      Ventilation.IO_Bus.Variables ventilation(T(redeclare block Variable =
              T.Variable))
        annotation (Placement(transformation(extent={{-4,28},{16,48}})));
      O2.IO_Bus.Variables o2(T(redeclare block Variable = T.Variable))
        annotation (Placement(transformation(extent={{-58,-48},{-38,-28}})));
      equation

      connect(co2.busConnector, busConnector) annotation (Line(
          points={{-4,-36},{-4,-2},{90,-2}},
          color={0,0,255},
          thickness=0.5,
          smooth=Smooth.None));
      connect(o2.busConnector, busConnector) annotation (Line(
          points={{-48,-38},{-52,-38},{-52,-2},{90,-2}},
          color={0,0,255},
          thickness=0.5,
          smooth=Smooth.None));
      connect(ventilation.busConnector, busConnector) annotation (Line(
          points={{6,38},{6,-2},{90,-2}},
          color={0,0,255},
          thickness=0.5,
          smooth=Smooth.None));
      end Variables;

      model Gases_test
        import Physiomodel;

        import Modelica.Utilities.*;
       // constant String OUTPUT_FILE = "setup/output_startValues.txt"; //"setup/output.txt"; //"setup/v2.txt";

      Physiomodel.CardioVascular.IO_Bus.InputFromFile cardioVascularSystem
          annotation (Placement(transformation(extent={{40,72},{60,94}})));
        Physiomodel.Metabolism.IO_Bus.InputFromFile
                                                nutrientsAndMetabolism
          annotation (Placement(transformation(extent={{-86,60},{-66,80}})));
        Physiomodel.Electrolytes.IO_Bus.InputFromFile electrolytes
          annotation (Placement(transformation(extent={{74,-34},{94,-14}})));
        Physiomodel.Hormones.IO_Bus.InputFromFile hormones
          annotation (Placement(transformation(extent={{40,6},{60,26}})));
        Physiomodel.Nerves.IO_Bus.InputFromFile nerves
          annotation (Placement(transformation(extent={{74,38},{94,58}})));
        Physiomodel.Setup.IO_Bus.InputFromFile     setup
          annotation (Placement(transformation(extent={{-16,-106},{4,-86}})));
        Physiomodel.Water.IO_Bus.InputFromFile water
          annotation (Placement(transformation(extent={{-86,-6},{-66,14}})));
        Physiomodel.Proteins.IO_Bus.InputFromFile proteins
          annotation (Placement(transformation(extent={{-48,-28},{-28,-8}})));
        Physiomodel.Status.IO_Bus.InputFromFile status
          annotation (Placement(transformation(extent={{42,-80},{62,-60}})));
        Physiomodel.Gases.Gases gases
          annotation (Placement(transformation(extent={{-78,-64},{-58,-44}})));
        Physiomodel.Heat.IO_Bus.InputFromFile heat
          annotation (Placement(transformation(extent={{-28,30},{-48,50}})));
        Physiomodel.Gases.IO_Bus.OutputComparison
                                    gases_dif
          annotation (Placement(transformation(extent={{-38,-80},{-18,-60}})));
        Physiomodel.Gases.IO_Bus.OutputToFile
                                           gases_varsToFile
          annotation (Placement(transformation(extent={{-98,-92},{-78,-72}})));
      equation
        connect(setup.busConnector,hormones. busConnector) annotation (Line(
            points={{-6,-96},{-6,16},{50,16}},
            color={0,0,255},
            thickness=0.5,
            smooth=Smooth.None));
        connect(setup.busConnector,proteins. busConnector) annotation (Line(
            points={{-6,-96},{-6,-18},{-38,-18}},
            color={0,0,255},
            thickness=0.5,
            smooth=Smooth.None));
        connect(setup.busConnector,cardioVascularSystem. busConnector)
                                                      annotation (Line(
            points={{-6,-96},{-6,83},{50,83}},
            color={0,0,255},
            thickness=0.5,
            smooth=Smooth.None));
        connect(setup.busConnector,nutrientsAndMetabolism. busConnector)
          annotation (Line(
            points={{-6,-96},{-6,70},{-76,70}},
            color={0,0,255},
            thickness=0.5,
            smooth=Smooth.None));
        connect(setup.busConnector,water. busConnector) annotation (Line(
            points={{-6,-96},{-6,4},{-76,4}},
            color={0,0,255},
            thickness=0.5,
            smooth=Smooth.None));
        connect(setup.busConnector,nerves. busConnector) annotation (Line(
            points={{-6,-96},{-6,48},{84,48}},
            color={0,0,255},
            thickness=0.5,
            smooth=Smooth.None));
        connect(status.busConnector,setup. busConnector)         annotation (Line(
            points={{52,-70},{-6,-70},{-6,-96}},
            color={0,0,255},
            thickness=0.5,
            smooth=Smooth.None));
        connect(electrolytes.busConnector,setup. busConnector) annotation (Line(
            points={{84,-24},{-6,-24},{-6,-96}},
            color={0,0,255},
            thickness=0.5,
            smooth=Smooth.None));
        connect(gases.busConnector,setup. busConnector) annotation (Line(
            points={{-60,-46},{-6,-46},{-6,-96}},
            color={0,0,255},
            thickness=0.5,
            smooth=Smooth.None));
        connect(heat.busConnector,setup. busConnector) annotation (Line(
            points={{-38,40},{-6,40},{-6,-96}},
            color={0,0,255},
            thickness=0.5,
            smooth=Smooth.None));
        connect(gases.busConnector, gases_dif.busConnector) annotation (Line(
            points={{-60,-46},{-44,-46},{-44,-70},{-28,-70}},
            color={0,0,255},
            thickness=0.5,
            smooth=Smooth.None));
        connect(gases_varsToFile.busConnector, gases.busConnector) annotation (
            Line(
            points={{-88,-82},{-88,-46},{-60,-46}},
            color={0,0,255},
            thickness=0.5,
            smooth=Smooth.None));
      if terminal() then

      /*   Streams.print("cardioVascularSystem.busConnector.Bone_PCO2\n"+String(cardioVascularSystem.busConnector.Bone_PCO2),OUTPUT_FILE);

Streams.print("cardioVascularSystem.busConnector.Brain_PCO2\n"+String(cardioVascularSystem.busConnector.Brain_PCO2),OUTPUT_FILE);
Streams.print("cardioVascularSystem.busConnector.Fat_PCO2\n"+String(cardioVascularSystem.busConnector.Fat_PCO2),OUTPUT_FILE);
Streams.print("cardioVascularSystem.busConnector.GITract_PCO2\n"+String(cardioVascularSystem.busConnector.GITract_PCO2),OUTPUT_FILE);
Streams.print("cardioVascularSystem.busConnector.Kidney_PCO2\n"+String(cardioVascularSystem.busConnector.Kidney_PCO2),OUTPUT_FILE);
Streams.print("cardioVascularSystem.busConnector.LeftHeart_PCO2\n"+String(cardioVascularSystem.busConnector.LeftHeart_PCO2),OUTPUT_FILE);
Streams.print("cardioVascularSystem.busConnector.Liver_PCO2\n"+String(cardioVascularSystem.busConnector.Liver_PCO2),OUTPUT_FILE);
Streams.print("cardioVascularSystem.busConnector.OtherTissue_PCO2\n"+String(cardioVascularSystem.busConnector.OtherTissue_PCO2),OUTPUT_FILE);
Streams.print("cardioVascularSystem.busConnector.RespiratoryMuscle_PCO2\n"+String(cardioVascularSystem.busConnector.RespiratoryMuscle_PCO2),OUTPUT_FILE);
Streams.print("cardioVascularSystem.busConnector.RightHeart_PCO2\n"+String(cardioVascularSystem.busConnector.RightHeart_PCO2),OUTPUT_FILE);
Streams.print("cardioVascularSystem.busConnector.SkeletalMuscle_PCO2\n"+String(cardioVascularSystem.busConnector.SkeletalMuscle_PCO2),OUTPUT_FILE);
Streams.print("cardioVascularSystem.busConnector.Skin_PCO2\n"+String(cardioVascularSystem.busConnector.Skin_PCO2),OUTPUT_FILE);
Streams.print("cardioVascularSystem.busConnector.Urine_pH\n"+String(cardioVascularSystem.busConnector.Urine_pH),OUTPUT_FILE);

Streams.print("gases.carbonDioxyd.alveolarVentilation.solventFlowPump.q_out.conc|"+String(gases.carbonDioxyd.alveolarVentilation.solventFlowPump.q_out.conc),OUTPUT_FILE);
Streams.print("gases.carbonDioxyd.artysCO2.pCO2|"+String(gases.carbonDioxyd.artysCO2.pCO2),OUTPUT_FILE);
Streams.print("gases.carbonDioxyd.veinsCO2.pCO2|"+String(gases.carbonDioxyd.veinsCO2.pCO2),OUTPUT_FILE);
Streams.print("gases.oxygen.alveolarVentilation.solventFlowPump.q_out.conc|"+String(gases.oxygen.alveolarVentilation.solventFlowPump.q_out.conc),OUTPUT_FILE);
Streams.print("gases.oxygen.artysO2.a|"+String(gases.oxygen.artysO2.a),OUTPUT_FILE);
Streams.print("gases.oxygen.artysO2.FCOHb|"+String(gases.oxygen.artysO2.FCOHb),OUTPUT_FILE);
Streams.print("gases.oxygen.artysO2.pO2|"+String(gases.oxygen.artysO2.pO2),OUTPUT_FILE);
Streams.print("gases.oxygen.O2Lung.a|"+String(gases.oxygen.O2Lung.a),OUTPUT_FILE);
Streams.print("gases.oxygen.O2Lung.FCOHb|"+String(gases.oxygen.O2Lung.FCOHb),OUTPUT_FILE);
Streams.print("gases.oxygen.O2Lung.tO2|"+String(gases.oxygen.O2Lung.tO2),OUTPUT_FILE);
Streams.print("gases.oxygen.tissuesO2.boneO2.O2Tissue.a|"+String(gases.oxygen.tissuesO2.boneO2.O2Tissue.a),OUTPUT_FILE);
Streams.print("gases.oxygen.tissuesO2.boneO2.O2Tissue.FCOHb|"+String(gases.oxygen.tissuesO2.boneO2.O2Tissue.FCOHb),OUTPUT_FILE);
Streams.print("gases.oxygen.tissuesO2.boneO2.O2Tissue.pO2|"+String(gases.oxygen.tissuesO2.boneO2.O2Tissue.pO2),OUTPUT_FILE);
Streams.print("gases.oxygen.tissuesO2.brainO2.O2Tissue.a|"+String(gases.oxygen.tissuesO2.brainO2.O2Tissue.a),OUTPUT_FILE);
Streams.print("gases.oxygen.tissuesO2.brainO2.O2Tissue.FCOHb|"+String(gases.oxygen.tissuesO2.brainO2.O2Tissue.FCOHb),OUTPUT_FILE);
Streams.print("gases.oxygen.tissuesO2.brainO2.O2Tissue.pO2|"+String(gases.oxygen.tissuesO2.brainO2.O2Tissue.pO2),OUTPUT_FILE);
Streams.print("gases.oxygen.tissuesO2.fatO2.O2Tissue.a|"+String(gases.oxygen.tissuesO2.fatO2.O2Tissue.a),OUTPUT_FILE);
Streams.print("gases.oxygen.tissuesO2.fatO2.O2Tissue.FCOHb|"+String(gases.oxygen.tissuesO2.fatO2.O2Tissue.FCOHb),OUTPUT_FILE);
Streams.print("gases.oxygen.tissuesO2.fatO2.O2Tissue.pO2|"+String(gases.oxygen.tissuesO2.fatO2.O2Tissue.pO2),OUTPUT_FILE);
Streams.print("gases.oxygen.tissuesO2.GITractO2.O2Tissue.a|"+String(gases.oxygen.tissuesO2.GITractO2.O2Tissue.a),OUTPUT_FILE);
Streams.print("gases.oxygen.tissuesO2.GITractO2.O2Tissue.FCOHb|"+String(gases.oxygen.tissuesO2.GITractO2.O2Tissue.FCOHb),OUTPUT_FILE);
Streams.print("gases.oxygen.tissuesO2.GITractO2.O2Tissue.pO2|"+String(gases.oxygen.tissuesO2.GITractO2.O2Tissue.pO2),OUTPUT_FILE);
Streams.print("gases.oxygen.tissuesO2.kidneyO2.O2Tissue.a|"+String(gases.oxygen.tissuesO2.kidneyO2.O2Tissue.a),OUTPUT_FILE);
Streams.print("gases.oxygen.tissuesO2.kidneyO2.O2Tissue.FCOHb|"+String(gases.oxygen.tissuesO2.kidneyO2.O2Tissue.FCOHb),OUTPUT_FILE);
Streams.print("gases.oxygen.tissuesO2.kidneyO2.O2Tissue.pO2|"+String(gases.oxygen.tissuesO2.kidneyO2.O2Tissue.pO2),OUTPUT_FILE);
Streams.print("gases.oxygen.tissuesO2.leftHeartO2.O2Tissue.a|"+String(gases.oxygen.tissuesO2.leftHeartO2.O2Tissue.a),OUTPUT_FILE);
Streams.print("gases.oxygen.tissuesO2.leftHeartO2.O2Tissue.FCOHb|"+String(gases.oxygen.tissuesO2.leftHeartO2.O2Tissue.FCOHb),OUTPUT_FILE);
Streams.print("gases.oxygen.tissuesO2.leftHeartO2.O2Tissue.pO2|"+String(gases.oxygen.tissuesO2.leftHeartO2.O2Tissue.pO2),OUTPUT_FILE);
Streams.print("gases.oxygen.tissuesO2.liverO2.O2Tissue.a|"+String(gases.oxygen.tissuesO2.liverO2.O2Tissue.a),OUTPUT_FILE);
Streams.print("gases.oxygen.tissuesO2.liverO2.O2Tissue.FCOHb|"+String(gases.oxygen.tissuesO2.liverO2.O2Tissue.FCOHb),OUTPUT_FILE);
Streams.print("gases.oxygen.tissuesO2.liverO2.O2Tissue.pO2|"+String(gases.oxygen.tissuesO2.liverO2.O2Tissue.pO2),OUTPUT_FILE);
Streams.print("gases.oxygen.tissuesO2.otherTissueO2.O2Tissue.a|"+String(gases.oxygen.tissuesO2.otherTissueO2.O2Tissue.a),OUTPUT_FILE);
Streams.print("gases.oxygen.tissuesO2.otherTissueO2.O2Tissue.FCOHb|"+String(gases.oxygen.tissuesO2.otherTissueO2.O2Tissue.FCOHb),OUTPUT_FILE);
Streams.print("gases.oxygen.tissuesO2.otherTissueO2.O2Tissue.pO2|"+String(gases.oxygen.tissuesO2.otherTissueO2.O2Tissue.pO2),OUTPUT_FILE);
Streams.print("gases.oxygen.tissuesO2.respiratoryMuscleO2.O2Tissue.a|"+String(gases.oxygen.tissuesO2.respiratoryMuscleO2.O2Tissue.a),OUTPUT_FILE);
Streams.print("gases.oxygen.tissuesO2.respiratoryMuscleO2.O2Tissue.FCOHb|"+String(gases.oxygen.tissuesO2.respiratoryMuscleO2.O2Tissue.FCOHb),OUTPUT_FILE);
Streams.print("gases.oxygen.tissuesO2.respiratoryMuscleO2.O2Tissue.pO2|"+String(gases.oxygen.tissuesO2.respiratoryMuscleO2.O2Tissue.pO2),OUTPUT_FILE);
Streams.print("gases.oxygen.tissuesO2.rightHeartO2.O2Tissue.a|"+String(gases.oxygen.tissuesO2.rightHeartO2.O2Tissue.a),OUTPUT_FILE);
Streams.print("gases.oxygen.tissuesO2.rightHeartO2.O2Tissue.FCOHb|"+String(gases.oxygen.tissuesO2.rightHeartO2.O2Tissue.FCOHb),OUTPUT_FILE);
Streams.print("gases.oxygen.tissuesO2.rightHeartO2.O2Tissue.pO2|"+String(gases.oxygen.tissuesO2.rightHeartO2.O2Tissue.pO2),OUTPUT_FILE);
Streams.print("gases.oxygen.tissuesO2.skeletalMuscleO2.O2Tissue.a|"+String(gases.oxygen.tissuesO2.skeletalMuscleO2.O2Tissue.a),OUTPUT_FILE);
Streams.print("gases.oxygen.tissuesO2.skeletalMuscleO2.O2Tissue.FCOHb|"+String(gases.oxygen.tissuesO2.skeletalMuscleO2.O2Tissue.FCOHb),OUTPUT_FILE);
Streams.print("gases.oxygen.tissuesO2.skeletalMuscleO2.O2Tissue.pO2|"+String(gases.oxygen.tissuesO2.skeletalMuscleO2.O2Tissue.pO2),OUTPUT_FILE);
Streams.print("gases.oxygen.tissuesO2.skinO2.O2Tissue.a|"+String(gases.oxygen.tissuesO2.skinO2.O2Tissue.a),OUTPUT_FILE);
Streams.print("gases.oxygen.tissuesO2.skinO2.O2Tissue.FCOHb|"+String(gases.oxygen.tissuesO2.skinO2.O2Tissue.FCOHb),OUTPUT_FILE);
Streams.print("gases.oxygen.tissuesO2.skinO2.O2Tissue.pO2|"+String(gases.oxygen.tissuesO2.skinO2.O2Tissue.pO2),OUTPUT_FILE);
Streams.print("gases.oxygen.veinsO2.a|"+String(gases.oxygen.veinsO2.a),OUTPUT_FILE);
Streams.print("gases.oxygen.veinsO2.FCOHb|"+String(gases.oxygen.veinsO2.FCOHb),OUTPUT_FILE);
Streams.print("gases.oxygen.veinsO2.pO2|"+String(gases.oxygen.veinsO2.pO2),OUTPUT_FILE);*/
      end if;
        annotation (          experiment(StopTime=3600, Tolerance=1e-005));
      end Gases_test;

      model Gases_test_SI
        import Physiomodel;

        import Modelica.Utilities.*;
       // constant String OUTPUT_FILE = "setup/output_startValues.txt"; //"setup/output.txt"; //"setup/v2.txt";

      Physiomodel.CardioVascular.IO_Bus.InputFromFile_SI cardioVascularSystem
          annotation (Placement(transformation(extent={{40,72},{60,94}})));
        Physiomodel.Metabolism.IO_Bus.InputFromFile_SI
                                                nutrientsAndMetabolism
          annotation (Placement(transformation(extent={{-86,60},{-66,80}})));
        Physiomodel.Electrolytes.IO_Bus.InputFromFile_SI electrolytes
          annotation (Placement(transformation(extent={{74,-34},{94,-14}})));
        Physiomodel.Hormones.IO_Bus.InputFromFile_SI hormones
          annotation (Placement(transformation(extent={{40,6},{60,26}})));
        Physiomodel.Nerves.IO_Bus.InputFromFile_SI nerves
          annotation (Placement(transformation(extent={{74,38},{94,58}})));
        Physiomodel.Setup.IO_Bus.InputFromFile_SI     setup
          annotation (Placement(transformation(extent={{-16,-106},{4,-86}})));
        Physiomodel.Water.IO_Bus.InputFromFile_SI water
          annotation (Placement(transformation(extent={{-86,-6},{-66,14}})));
        Physiomodel.Proteins.IO_Bus.InputFromFile_SI proteins
          annotation (Placement(transformation(extent={{-48,-28},{-28,-8}})));
        Physiomodel.Status.IO_Bus.InputFromFile_SI status
          annotation (Placement(transformation(extent={{42,-80},{62,-60}})));
        Physiomodel.Gases.Gases gases
          annotation (Placement(transformation(extent={{-78,-64},{-58,-44}})));
        Physiomodel.Heat.IO_Bus.InputFromFile_SI heat
          annotation (Placement(transformation(extent={{-28,30},{-48,50}})));
        Physiomodel.Gases.IO_Bus.OutputComparison_SI
                                    gases_dif
          annotation (Placement(transformation(extent={{-38,-80},{-18,-60}})));
        Physiomodel.Gases.IO_Bus.OutputToFile_SI
                                           gases_varsToFile
          annotation (Placement(transformation(extent={{-98,-92},{-78,-72}})));
      equation
        connect(setup.busConnector,hormones. busConnector) annotation (Line(
            points={{-6,-96},{-6,16},{50,16}},
            color={0,0,255},
            thickness=0.5,
            smooth=Smooth.None));
        connect(setup.busConnector,proteins. busConnector) annotation (Line(
            points={{-6,-96},{-6,-18},{-38,-18}},
            color={0,0,255},
            thickness=0.5,
            smooth=Smooth.None));
        connect(setup.busConnector,cardioVascularSystem. busConnector)
                                                      annotation (Line(
            points={{-6,-96},{-6,83},{50,83}},
            color={0,0,255},
            thickness=0.5,
            smooth=Smooth.None));
        connect(setup.busConnector,nutrientsAndMetabolism. busConnector)
          annotation (Line(
            points={{-6,-96},{-6,70},{-76,70}},
            color={0,0,255},
            thickness=0.5,
            smooth=Smooth.None));
        connect(setup.busConnector,water. busConnector) annotation (Line(
            points={{-6,-96},{-6,4},{-76,4}},
            color={0,0,255},
            thickness=0.5,
            smooth=Smooth.None));
        connect(setup.busConnector,nerves. busConnector) annotation (Line(
            points={{-6,-96},{-6,48},{84,48}},
            color={0,0,255},
            thickness=0.5,
            smooth=Smooth.None));
        connect(status.busConnector,setup. busConnector)         annotation (Line(
            points={{52,-70},{-6,-70},{-6,-96}},
            color={0,0,255},
            thickness=0.5,
            smooth=Smooth.None));
        connect(electrolytes.busConnector,setup. busConnector) annotation (Line(
            points={{84,-24},{-6,-24},{-6,-96}},
            color={0,0,255},
            thickness=0.5,
            smooth=Smooth.None));
        connect(gases.busConnector,setup. busConnector) annotation (Line(
            points={{-60,-46},{-6,-46},{-6,-96}},
            color={0,0,255},
            thickness=0.5,
            smooth=Smooth.None));
        connect(heat.busConnector,setup. busConnector) annotation (Line(
            points={{-38,40},{-6,40},{-6,-96}},
            color={0,0,255},
            thickness=0.5,
            smooth=Smooth.None));
        connect(gases.busConnector, gases_dif.busConnector) annotation (Line(
            points={{-60,-46},{-44,-46},{-44,-70},{-28,-70}},
            color={0,0,255},
            thickness=0.5,
            smooth=Smooth.None));
        connect(gases_varsToFile.busConnector, gases.busConnector) annotation (
            Line(
            points={{-88,-82},{-88,-46},{-60,-46}},
            color={0,0,255},
            thickness=0.5,
            smooth=Smooth.None));
      //if terminal() then

      /*   Streams.print("cardioVascularSystem.busConnector.Bone_PCO2\n"+String(cardioVascularSystem.busConnector.Bone_PCO2),OUTPUT_FILE);

Streams.print("cardioVascularSystem.busConnector.Brain_PCO2\n"+String(cardioVascularSystem.busConnector.Brain_PCO2),OUTPUT_FILE);
Streams.print("cardioVascularSystem.busConnector.Fat_PCO2\n"+String(cardioVascularSystem.busConnector.Fat_PCO2),OUTPUT_FILE);
Streams.print("cardioVascularSystem.busConnector.GITract_PCO2\n"+String(cardioVascularSystem.busConnector.GITract_PCO2),OUTPUT_FILE);
Streams.print("cardioVascularSystem.busConnector.Kidney_PCO2\n"+String(cardioVascularSystem.busConnector.Kidney_PCO2),OUTPUT_FILE);
Streams.print("cardioVascularSystem.busConnector.LeftHeart_PCO2\n"+String(cardioVascularSystem.busConnector.LeftHeart_PCO2),OUTPUT_FILE);
Streams.print("cardioVascularSystem.busConnector.Liver_PCO2\n"+String(cardioVascularSystem.busConnector.Liver_PCO2),OUTPUT_FILE);
Streams.print("cardioVascularSystem.busConnector.OtherTissue_PCO2\n"+String(cardioVascularSystem.busConnector.OtherTissue_PCO2),OUTPUT_FILE);
Streams.print("cardioVascularSystem.busConnector.RespiratoryMuscle_PCO2\n"+String(cardioVascularSystem.busConnector.RespiratoryMuscle_PCO2),OUTPUT_FILE);
Streams.print("cardioVascularSystem.busConnector.RightHeart_PCO2\n"+String(cardioVascularSystem.busConnector.RightHeart_PCO2),OUTPUT_FILE);
Streams.print("cardioVascularSystem.busConnector.SkeletalMuscle_PCO2\n"+String(cardioVascularSystem.busConnector.SkeletalMuscle_PCO2),OUTPUT_FILE);
Streams.print("cardioVascularSystem.busConnector.Skin_PCO2\n"+String(cardioVascularSystem.busConnector.Skin_PCO2),OUTPUT_FILE);
Streams.print("cardioVascularSystem.busConnector.Urine_pH\n"+String(cardioVascularSystem.busConnector.Urine_pH),OUTPUT_FILE);

Streams.print("gases.carbonDioxyd.alveolarVentilation.solventFlowPump.q_out.conc|"+String(gases.carbonDioxyd.alveolarVentilation.solventFlowPump.q_out.conc),OUTPUT_FILE);
Streams.print("gases.carbonDioxyd.artysCO2.pCO2|"+String(gases.carbonDioxyd.artysCO2.pCO2),OUTPUT_FILE);
Streams.print("gases.carbonDioxyd.veinsCO2.pCO2|"+String(gases.carbonDioxyd.veinsCO2.pCO2),OUTPUT_FILE);
Streams.print("gases.oxygen.alveolarVentilation.solventFlowPump.q_out.conc|"+String(gases.oxygen.alveolarVentilation.solventFlowPump.q_out.conc),OUTPUT_FILE);
Streams.print("gases.oxygen.artysO2.a|"+String(gases.oxygen.artysO2.a),OUTPUT_FILE);
Streams.print("gases.oxygen.artysO2.FCOHb|"+String(gases.oxygen.artysO2.FCOHb),OUTPUT_FILE);
Streams.print("gases.oxygen.artysO2.pO2|"+String(gases.oxygen.artysO2.pO2),OUTPUT_FILE);
Streams.print("gases.oxygen.O2Lung.a|"+String(gases.oxygen.O2Lung.a),OUTPUT_FILE);
Streams.print("gases.oxygen.O2Lung.FCOHb|"+String(gases.oxygen.O2Lung.FCOHb),OUTPUT_FILE);
Streams.print("gases.oxygen.O2Lung.tO2|"+String(gases.oxygen.O2Lung.tO2),OUTPUT_FILE);
Streams.print("gases.oxygen.tissuesO2.boneO2.O2Tissue.a|"+String(gases.oxygen.tissuesO2.boneO2.O2Tissue.a),OUTPUT_FILE);
Streams.print("gases.oxygen.tissuesO2.boneO2.O2Tissue.FCOHb|"+String(gases.oxygen.tissuesO2.boneO2.O2Tissue.FCOHb),OUTPUT_FILE);
Streams.print("gases.oxygen.tissuesO2.boneO2.O2Tissue.pO2|"+String(gases.oxygen.tissuesO2.boneO2.O2Tissue.pO2),OUTPUT_FILE);
Streams.print("gases.oxygen.tissuesO2.brainO2.O2Tissue.a|"+String(gases.oxygen.tissuesO2.brainO2.O2Tissue.a),OUTPUT_FILE);
Streams.print("gases.oxygen.tissuesO2.brainO2.O2Tissue.FCOHb|"+String(gases.oxygen.tissuesO2.brainO2.O2Tissue.FCOHb),OUTPUT_FILE);
Streams.print("gases.oxygen.tissuesO2.brainO2.O2Tissue.pO2|"+String(gases.oxygen.tissuesO2.brainO2.O2Tissue.pO2),OUTPUT_FILE);
Streams.print("gases.oxygen.tissuesO2.fatO2.O2Tissue.a|"+String(gases.oxygen.tissuesO2.fatO2.O2Tissue.a),OUTPUT_FILE);
Streams.print("gases.oxygen.tissuesO2.fatO2.O2Tissue.FCOHb|"+String(gases.oxygen.tissuesO2.fatO2.O2Tissue.FCOHb),OUTPUT_FILE);
Streams.print("gases.oxygen.tissuesO2.fatO2.O2Tissue.pO2|"+String(gases.oxygen.tissuesO2.fatO2.O2Tissue.pO2),OUTPUT_FILE);
Streams.print("gases.oxygen.tissuesO2.GITractO2.O2Tissue.a|"+String(gases.oxygen.tissuesO2.GITractO2.O2Tissue.a),OUTPUT_FILE);
Streams.print("gases.oxygen.tissuesO2.GITractO2.O2Tissue.FCOHb|"+String(gases.oxygen.tissuesO2.GITractO2.O2Tissue.FCOHb),OUTPUT_FILE);
Streams.print("gases.oxygen.tissuesO2.GITractO2.O2Tissue.pO2|"+String(gases.oxygen.tissuesO2.GITractO2.O2Tissue.pO2),OUTPUT_FILE);
Streams.print("gases.oxygen.tissuesO2.kidneyO2.O2Tissue.a|"+String(gases.oxygen.tissuesO2.kidneyO2.O2Tissue.a),OUTPUT_FILE);
Streams.print("gases.oxygen.tissuesO2.kidneyO2.O2Tissue.FCOHb|"+String(gases.oxygen.tissuesO2.kidneyO2.O2Tissue.FCOHb),OUTPUT_FILE);
Streams.print("gases.oxygen.tissuesO2.kidneyO2.O2Tissue.pO2|"+String(gases.oxygen.tissuesO2.kidneyO2.O2Tissue.pO2),OUTPUT_FILE);
Streams.print("gases.oxygen.tissuesO2.leftHeartO2.O2Tissue.a|"+String(gases.oxygen.tissuesO2.leftHeartO2.O2Tissue.a),OUTPUT_FILE);
Streams.print("gases.oxygen.tissuesO2.leftHeartO2.O2Tissue.FCOHb|"+String(gases.oxygen.tissuesO2.leftHeartO2.O2Tissue.FCOHb),OUTPUT_FILE);
Streams.print("gases.oxygen.tissuesO2.leftHeartO2.O2Tissue.pO2|"+String(gases.oxygen.tissuesO2.leftHeartO2.O2Tissue.pO2),OUTPUT_FILE);
Streams.print("gases.oxygen.tissuesO2.liverO2.O2Tissue.a|"+String(gases.oxygen.tissuesO2.liverO2.O2Tissue.a),OUTPUT_FILE);
Streams.print("gases.oxygen.tissuesO2.liverO2.O2Tissue.FCOHb|"+String(gases.oxygen.tissuesO2.liverO2.O2Tissue.FCOHb),OUTPUT_FILE);
Streams.print("gases.oxygen.tissuesO2.liverO2.O2Tissue.pO2|"+String(gases.oxygen.tissuesO2.liverO2.O2Tissue.pO2),OUTPUT_FILE);
Streams.print("gases.oxygen.tissuesO2.otherTissueO2.O2Tissue.a|"+String(gases.oxygen.tissuesO2.otherTissueO2.O2Tissue.a),OUTPUT_FILE);
Streams.print("gases.oxygen.tissuesO2.otherTissueO2.O2Tissue.FCOHb|"+String(gases.oxygen.tissuesO2.otherTissueO2.O2Tissue.FCOHb),OUTPUT_FILE);
Streams.print("gases.oxygen.tissuesO2.otherTissueO2.O2Tissue.pO2|"+String(gases.oxygen.tissuesO2.otherTissueO2.O2Tissue.pO2),OUTPUT_FILE);
Streams.print("gases.oxygen.tissuesO2.respiratoryMuscleO2.O2Tissue.a|"+String(gases.oxygen.tissuesO2.respiratoryMuscleO2.O2Tissue.a),OUTPUT_FILE);
Streams.print("gases.oxygen.tissuesO2.respiratoryMuscleO2.O2Tissue.FCOHb|"+String(gases.oxygen.tissuesO2.respiratoryMuscleO2.O2Tissue.FCOHb),OUTPUT_FILE);
Streams.print("gases.oxygen.tissuesO2.respiratoryMuscleO2.O2Tissue.pO2|"+String(gases.oxygen.tissuesO2.respiratoryMuscleO2.O2Tissue.pO2),OUTPUT_FILE);
Streams.print("gases.oxygen.tissuesO2.rightHeartO2.O2Tissue.a|"+String(gases.oxygen.tissuesO2.rightHeartO2.O2Tissue.a),OUTPUT_FILE);
Streams.print("gases.oxygen.tissuesO2.rightHeartO2.O2Tissue.FCOHb|"+String(gases.oxygen.tissuesO2.rightHeartO2.O2Tissue.FCOHb),OUTPUT_FILE);
Streams.print("gases.oxygen.tissuesO2.rightHeartO2.O2Tissue.pO2|"+String(gases.oxygen.tissuesO2.rightHeartO2.O2Tissue.pO2),OUTPUT_FILE);
Streams.print("gases.oxygen.tissuesO2.skeletalMuscleO2.O2Tissue.a|"+String(gases.oxygen.tissuesO2.skeletalMuscleO2.O2Tissue.a),OUTPUT_FILE);
Streams.print("gases.oxygen.tissuesO2.skeletalMuscleO2.O2Tissue.FCOHb|"+String(gases.oxygen.tissuesO2.skeletalMuscleO2.O2Tissue.FCOHb),OUTPUT_FILE);
Streams.print("gases.oxygen.tissuesO2.skeletalMuscleO2.O2Tissue.pO2|"+String(gases.oxygen.tissuesO2.skeletalMuscleO2.O2Tissue.pO2),OUTPUT_FILE);
Streams.print("gases.oxygen.tissuesO2.skinO2.O2Tissue.a|"+String(gases.oxygen.tissuesO2.skinO2.O2Tissue.a),OUTPUT_FILE);
Streams.print("gases.oxygen.tissuesO2.skinO2.O2Tissue.FCOHb|"+String(gases.oxygen.tissuesO2.skinO2.O2Tissue.FCOHb),OUTPUT_FILE);
Streams.print("gases.oxygen.tissuesO2.skinO2.O2Tissue.pO2|"+String(gases.oxygen.tissuesO2.skinO2.O2Tissue.pO2),OUTPUT_FILE);
Streams.print("gases.oxygen.veinsO2.a|"+String(gases.oxygen.veinsO2.a),OUTPUT_FILE);
Streams.print("gases.oxygen.veinsO2.FCOHb|"+String(gases.oxygen.veinsO2.FCOHb),OUTPUT_FILE);
Streams.print("gases.oxygen.veinsO2.pO2|"+String(gases.oxygen.veinsO2.pO2),OUTPUT_FILE);*/
      //end if;
        annotation (          experiment(StopTime=864000, Tolerance=1e-005));
      end Gases_test_SI;

      model WithoutProteins_test_SI
        import Physiomodel;

        import Modelica.Utilities.*;
       // constant String OUTPUT_FILE = "setup/output_startValues.txt"; //"setup/output.txt"; //"setup/v2.txt";

        Physiomodel.Setup.IO_Bus.InputFromFile_SI     setup
          annotation (Placement(transformation(extent={{-16,-106},{4,-86}})));
        Physiomodel.Gases.Gases gases
          annotation (Placement(transformation(extent={{-78,-64},{-58,-44}})));
        Physiomodel.Gases.IO_Bus.OutputComparison_SI
                                    gases_dif
          annotation (Placement(transformation(extent={{-38,-80},{-18,-60}})));
        Physiomodel.Gases.IO_Bus.OutputToFile_SI
                                           gases_varsToFile
          annotation (Placement(transformation(extent={{-98,-92},{-78,-72}})));
      Physiomodel.Metabolism.NutrientsAndMetabolism nutrientsAndMetabolism1
        annotation (Placement(transformation(extent={{-84,60},{-64,80}})));
      Physiomodel.Electrolytes.Electrolytes electrolytes1
        annotation (Placement(transformation(extent={{70,-36},{90,-16}})));
      Physiomodel.CardioVascular.CardioVascularSystem cVS_Dynamic
        annotation (Placement(transformation(extent={{50,60},{70,80}})));
      Physiomodel.Nerves.Nerves nerves1
        annotation (Placement(transformation(extent={{74,28},{94,48}})));
      Physiomodel.Hormones.Hormones hormones1
        annotation (Placement(transformation(extent={{44,2},{64,22}})));
      Physiomodel.Heat.Heat2 heat2_1
        annotation (Placement(transformation(extent={{-52,24},{-32,46}})));
      Physiomodel.Status.TissuesFitness tissuesFitness
        annotation (Placement(transformation(extent={{40,-72},{60,-52}})));
      Physiomodel.Water.Water3 water3_1
        annotation (Placement(transformation(extent={{-78,-12},{-58,8}})));
      Physiomodel.Proteins.IO_Bus.InputFromFile_SI proteins
        annotation (Placement(transformation(extent={{-42,-34},{-22,-14}})));
      equation
        connect(gases.busConnector,setup. busConnector) annotation (Line(
            points={{-60,-46},{-6,-46},{-6,-96}},
            color={0,0,255},
            thickness=0.5,
            smooth=Smooth.None));
        connect(gases.busConnector, gases_dif.busConnector) annotation (Line(
            points={{-60,-46},{-44,-46},{-44,-70},{-28,-70}},
            color={0,0,255},
            thickness=0.5,
            smooth=Smooth.None));
        connect(gases_varsToFile.busConnector, gases.busConnector) annotation (
            Line(
            points={{-88,-82},{-88,-46},{-60,-46}},
            color={0,0,255},
            thickness=0.5,
            smooth=Smooth.None));
      //if terminal() then

      /*   Streams.print("cardioVascularSystem.busConnector.Bone_PCO2\n"+String(cardioVascularSystem.busConnector.Bone_PCO2),OUTPUT_FILE);

Streams.print("cardioVascularSystem.busConnector.Brain_PCO2\n"+String(cardioVascularSystem.busConnector.Brain_PCO2),OUTPUT_FILE);
Streams.print("cardioVascularSystem.busConnector.Fat_PCO2\n"+String(cardioVascularSystem.busConnector.Fat_PCO2),OUTPUT_FILE);
Streams.print("cardioVascularSystem.busConnector.GITract_PCO2\n"+String(cardioVascularSystem.busConnector.GITract_PCO2),OUTPUT_FILE);
Streams.print("cardioVascularSystem.busConnector.Kidney_PCO2\n"+String(cardioVascularSystem.busConnector.Kidney_PCO2),OUTPUT_FILE);
Streams.print("cardioVascularSystem.busConnector.LeftHeart_PCO2\n"+String(cardioVascularSystem.busConnector.LeftHeart_PCO2),OUTPUT_FILE);
Streams.print("cardioVascularSystem.busConnector.Liver_PCO2\n"+String(cardioVascularSystem.busConnector.Liver_PCO2),OUTPUT_FILE);
Streams.print("cardioVascularSystem.busConnector.OtherTissue_PCO2\n"+String(cardioVascularSystem.busConnector.OtherTissue_PCO2),OUTPUT_FILE);
Streams.print("cardioVascularSystem.busConnector.RespiratoryMuscle_PCO2\n"+String(cardioVascularSystem.busConnector.RespiratoryMuscle_PCO2),OUTPUT_FILE);
Streams.print("cardioVascularSystem.busConnector.RightHeart_PCO2\n"+String(cardioVascularSystem.busConnector.RightHeart_PCO2),OUTPUT_FILE);
Streams.print("cardioVascularSystem.busConnector.SkeletalMuscle_PCO2\n"+String(cardioVascularSystem.busConnector.SkeletalMuscle_PCO2),OUTPUT_FILE);
Streams.print("cardioVascularSystem.busConnector.Skin_PCO2\n"+String(cardioVascularSystem.busConnector.Skin_PCO2),OUTPUT_FILE);
Streams.print("cardioVascularSystem.busConnector.Urine_pH\n"+String(cardioVascularSystem.busConnector.Urine_pH),OUTPUT_FILE);

Streams.print("gases.carbonDioxyd.alveolarVentilation.solventFlowPump.q_out.conc|"+String(gases.carbonDioxyd.alveolarVentilation.solventFlowPump.q_out.conc),OUTPUT_FILE);
Streams.print("gases.carbonDioxyd.artysCO2.pCO2|"+String(gases.carbonDioxyd.artysCO2.pCO2),OUTPUT_FILE);
Streams.print("gases.carbonDioxyd.veinsCO2.pCO2|"+String(gases.carbonDioxyd.veinsCO2.pCO2),OUTPUT_FILE);
Streams.print("gases.oxygen.alveolarVentilation.solventFlowPump.q_out.conc|"+String(gases.oxygen.alveolarVentilation.solventFlowPump.q_out.conc),OUTPUT_FILE);
Streams.print("gases.oxygen.artysO2.a|"+String(gases.oxygen.artysO2.a),OUTPUT_FILE);
Streams.print("gases.oxygen.artysO2.FCOHb|"+String(gases.oxygen.artysO2.FCOHb),OUTPUT_FILE);
Streams.print("gases.oxygen.artysO2.pO2|"+String(gases.oxygen.artysO2.pO2),OUTPUT_FILE);
Streams.print("gases.oxygen.O2Lung.a|"+String(gases.oxygen.O2Lung.a),OUTPUT_FILE);
Streams.print("gases.oxygen.O2Lung.FCOHb|"+String(gases.oxygen.O2Lung.FCOHb),OUTPUT_FILE);
Streams.print("gases.oxygen.O2Lung.tO2|"+String(gases.oxygen.O2Lung.tO2),OUTPUT_FILE);
Streams.print("gases.oxygen.tissuesO2.boneO2.O2Tissue.a|"+String(gases.oxygen.tissuesO2.boneO2.O2Tissue.a),OUTPUT_FILE);
Streams.print("gases.oxygen.tissuesO2.boneO2.O2Tissue.FCOHb|"+String(gases.oxygen.tissuesO2.boneO2.O2Tissue.FCOHb),OUTPUT_FILE);
Streams.print("gases.oxygen.tissuesO2.boneO2.O2Tissue.pO2|"+String(gases.oxygen.tissuesO2.boneO2.O2Tissue.pO2),OUTPUT_FILE);
Streams.print("gases.oxygen.tissuesO2.brainO2.O2Tissue.a|"+String(gases.oxygen.tissuesO2.brainO2.O2Tissue.a),OUTPUT_FILE);
Streams.print("gases.oxygen.tissuesO2.brainO2.O2Tissue.FCOHb|"+String(gases.oxygen.tissuesO2.brainO2.O2Tissue.FCOHb),OUTPUT_FILE);
Streams.print("gases.oxygen.tissuesO2.brainO2.O2Tissue.pO2|"+String(gases.oxygen.tissuesO2.brainO2.O2Tissue.pO2),OUTPUT_FILE);
Streams.print("gases.oxygen.tissuesO2.fatO2.O2Tissue.a|"+String(gases.oxygen.tissuesO2.fatO2.O2Tissue.a),OUTPUT_FILE);
Streams.print("gases.oxygen.tissuesO2.fatO2.O2Tissue.FCOHb|"+String(gases.oxygen.tissuesO2.fatO2.O2Tissue.FCOHb),OUTPUT_FILE);
Streams.print("gases.oxygen.tissuesO2.fatO2.O2Tissue.pO2|"+String(gases.oxygen.tissuesO2.fatO2.O2Tissue.pO2),OUTPUT_FILE);
Streams.print("gases.oxygen.tissuesO2.GITractO2.O2Tissue.a|"+String(gases.oxygen.tissuesO2.GITractO2.O2Tissue.a),OUTPUT_FILE);
Streams.print("gases.oxygen.tissuesO2.GITractO2.O2Tissue.FCOHb|"+String(gases.oxygen.tissuesO2.GITractO2.O2Tissue.FCOHb),OUTPUT_FILE);
Streams.print("gases.oxygen.tissuesO2.GITractO2.O2Tissue.pO2|"+String(gases.oxygen.tissuesO2.GITractO2.O2Tissue.pO2),OUTPUT_FILE);
Streams.print("gases.oxygen.tissuesO2.kidneyO2.O2Tissue.a|"+String(gases.oxygen.tissuesO2.kidneyO2.O2Tissue.a),OUTPUT_FILE);
Streams.print("gases.oxygen.tissuesO2.kidneyO2.O2Tissue.FCOHb|"+String(gases.oxygen.tissuesO2.kidneyO2.O2Tissue.FCOHb),OUTPUT_FILE);
Streams.print("gases.oxygen.tissuesO2.kidneyO2.O2Tissue.pO2|"+String(gases.oxygen.tissuesO2.kidneyO2.O2Tissue.pO2),OUTPUT_FILE);
Streams.print("gases.oxygen.tissuesO2.leftHeartO2.O2Tissue.a|"+String(gases.oxygen.tissuesO2.leftHeartO2.O2Tissue.a),OUTPUT_FILE);
Streams.print("gases.oxygen.tissuesO2.leftHeartO2.O2Tissue.FCOHb|"+String(gases.oxygen.tissuesO2.leftHeartO2.O2Tissue.FCOHb),OUTPUT_FILE);
Streams.print("gases.oxygen.tissuesO2.leftHeartO2.O2Tissue.pO2|"+String(gases.oxygen.tissuesO2.leftHeartO2.O2Tissue.pO2),OUTPUT_FILE);
Streams.print("gases.oxygen.tissuesO2.liverO2.O2Tissue.a|"+String(gases.oxygen.tissuesO2.liverO2.O2Tissue.a),OUTPUT_FILE);
Streams.print("gases.oxygen.tissuesO2.liverO2.O2Tissue.FCOHb|"+String(gases.oxygen.tissuesO2.liverO2.O2Tissue.FCOHb),OUTPUT_FILE);
Streams.print("gases.oxygen.tissuesO2.liverO2.O2Tissue.pO2|"+String(gases.oxygen.tissuesO2.liverO2.O2Tissue.pO2),OUTPUT_FILE);
Streams.print("gases.oxygen.tissuesO2.otherTissueO2.O2Tissue.a|"+String(gases.oxygen.tissuesO2.otherTissueO2.O2Tissue.a),OUTPUT_FILE);
Streams.print("gases.oxygen.tissuesO2.otherTissueO2.O2Tissue.FCOHb|"+String(gases.oxygen.tissuesO2.otherTissueO2.O2Tissue.FCOHb),OUTPUT_FILE);
Streams.print("gases.oxygen.tissuesO2.otherTissueO2.O2Tissue.pO2|"+String(gases.oxygen.tissuesO2.otherTissueO2.O2Tissue.pO2),OUTPUT_FILE);
Streams.print("gases.oxygen.tissuesO2.respiratoryMuscleO2.O2Tissue.a|"+String(gases.oxygen.tissuesO2.respiratoryMuscleO2.O2Tissue.a),OUTPUT_FILE);
Streams.print("gases.oxygen.tissuesO2.respiratoryMuscleO2.O2Tissue.FCOHb|"+String(gases.oxygen.tissuesO2.respiratoryMuscleO2.O2Tissue.FCOHb),OUTPUT_FILE);
Streams.print("gases.oxygen.tissuesO2.respiratoryMuscleO2.O2Tissue.pO2|"+String(gases.oxygen.tissuesO2.respiratoryMuscleO2.O2Tissue.pO2),OUTPUT_FILE);
Streams.print("gases.oxygen.tissuesO2.rightHeartO2.O2Tissue.a|"+String(gases.oxygen.tissuesO2.rightHeartO2.O2Tissue.a),OUTPUT_FILE);
Streams.print("gases.oxygen.tissuesO2.rightHeartO2.O2Tissue.FCOHb|"+String(gases.oxygen.tissuesO2.rightHeartO2.O2Tissue.FCOHb),OUTPUT_FILE);
Streams.print("gases.oxygen.tissuesO2.rightHeartO2.O2Tissue.pO2|"+String(gases.oxygen.tissuesO2.rightHeartO2.O2Tissue.pO2),OUTPUT_FILE);
Streams.print("gases.oxygen.tissuesO2.skeletalMuscleO2.O2Tissue.a|"+String(gases.oxygen.tissuesO2.skeletalMuscleO2.O2Tissue.a),OUTPUT_FILE);
Streams.print("gases.oxygen.tissuesO2.skeletalMuscleO2.O2Tissue.FCOHb|"+String(gases.oxygen.tissuesO2.skeletalMuscleO2.O2Tissue.FCOHb),OUTPUT_FILE);
Streams.print("gases.oxygen.tissuesO2.skeletalMuscleO2.O2Tissue.pO2|"+String(gases.oxygen.tissuesO2.skeletalMuscleO2.O2Tissue.pO2),OUTPUT_FILE);
Streams.print("gases.oxygen.tissuesO2.skinO2.O2Tissue.a|"+String(gases.oxygen.tissuesO2.skinO2.O2Tissue.a),OUTPUT_FILE);
Streams.print("gases.oxygen.tissuesO2.skinO2.O2Tissue.FCOHb|"+String(gases.oxygen.tissuesO2.skinO2.O2Tissue.FCOHb),OUTPUT_FILE);
Streams.print("gases.oxygen.tissuesO2.skinO2.O2Tissue.pO2|"+String(gases.oxygen.tissuesO2.skinO2.O2Tissue.pO2),OUTPUT_FILE);
Streams.print("gases.oxygen.veinsO2.a|"+String(gases.oxygen.veinsO2.a),OUTPUT_FILE);
Streams.print("gases.oxygen.veinsO2.FCOHb|"+String(gases.oxygen.veinsO2.FCOHb),OUTPUT_FILE);
Streams.print("gases.oxygen.veinsO2.pO2|"+String(gases.oxygen.veinsO2.pO2),OUTPUT_FILE);*/
      //end if;
      connect(gases.busConnector, electrolytes1.busConnector) annotation (Line(
          points={{-60,-46},{-6,-46},{-6,-22},{70,-22}},
          color={0,0,255},
          thickness=0.5,
          smooth=Smooth.None));
      connect(nutrientsAndMetabolism1.busConnector, cVS_Dynamic.busConnector)
        annotation (Line(
          points={{-66,78},{52,78}},
          color={0,0,255},
          thickness=0.5,
          smooth=Smooth.None));
      connect(cVS_Dynamic.busConnector, gases.busConnector) annotation (Line(
          points={{52,78},{-6,78},{-6,-46},{-60,-46}},
          color={0,0,255},
          thickness=0.5,
          smooth=Smooth.None));
      connect(cVS_Dynamic.busConnector, nerves1.busConnector) annotation (Line(
          points={{52,78},{-6,78},{-6,45.6},{76.2,45.6}},
          color={0,0,255},
          thickness=0.5,
          smooth=Smooth.None));
      connect(nutrientsAndMetabolism1.busConnector, hormones1.busConnector)
        annotation (Line(
          points={{-66,78},{-6,78},{-6,17.9},{47.9,17.9}},
          color={0,0,255},
          thickness=0.5,
          smooth=Smooth.None));
      connect(nutrientsAndMetabolism1.busConnector, heat2_1.busConnector)
        annotation (Line(
          points={{-66,78},{-6,78},{-6,45.56},{-51.4,45.56}},
          color={0,0,255},
          thickness=0.5,
          smooth=Smooth.None));
      connect(electrolytes1.busConnector, tissuesFitness.busConnector)
        annotation (Line(
          points={{70,-22},{-6,-22},{-6,-54},{41.2,-54},{41.2,-52.8}},
          color={0,0,255},
          thickness=0.5,
          smooth=Smooth.None));
      connect(hormones1.busConnector, water3_1.busConnector) annotation (Line(
          points={{47.9,17.9},{-6,17.9},{-6,5},{-61,5}},
          color={0,0,255},
          thickness=0.5,
          smooth=Smooth.None));
      connect(water3_1.busConnector, proteins.busConnector) annotation (Line(
          points={{-61,5},{-6,5},{-6,-24},{-32,-24}},
          color={0,0,255},
          thickness=0.5,
          smooth=Smooth.None));
        annotation (          experiment(StopTime=3600, Tolerance=1e-005));
      end WithoutProteins_test_SI;

      model GasesAndElectrolytes_test_SI
        import Physiomodel;

        import Modelica.Utilities.*;
       // constant String OUTPUT_FILE = "setup/output_startValues.txt"; //"setup/output.txt"; //"setup/v2.txt";

      Physiomodel.CardioVascular.IO_Bus.InputFromFile_SI cardioVascularSystem
          annotation (Placement(transformation(extent={{40,72},{60,94}})));
        Physiomodel.Metabolism.IO_Bus.InputFromFile_SI
                                                nutrientsAndMetabolism
          annotation (Placement(transformation(extent={{-86,60},{-66,80}})));
        Physiomodel.Electrolytes.Electrolytes            electrolytes
          annotation (Placement(transformation(extent={{74,-34},{94,-14}})));
        Physiomodel.Hormones.IO_Bus.InputFromFile_SI hormones
          annotation (Placement(transformation(extent={{40,6},{60,26}})));
        Physiomodel.Nerves.IO_Bus.InputFromFile_SI nerves
          annotation (Placement(transformation(extent={{74,38},{94,58}})));
        Physiomodel.Setup.IO_Bus.InputFromFile_SI     setup
          annotation (Placement(transformation(extent={{-16,-106},{4,-86}})));
        Physiomodel.Water.IO_Bus.InputFromFile_SI water
          annotation (Placement(transformation(extent={{-86,-6},{-66,14}})));
        Physiomodel.Proteins.IO_Bus.InputFromFile_SI proteins
          annotation (Placement(transformation(extent={{-48,-28},{-28,-8}})));
        Physiomodel.Status.IO_Bus.InputFromFile_SI status
          annotation (Placement(transformation(extent={{42,-80},{62,-60}})));
        Physiomodel.Gases.Gases gases
          annotation (Placement(transformation(extent={{-78,-64},{-58,-44}})));
        Physiomodel.Heat.IO_Bus.InputFromFile_SI heat
          annotation (Placement(transformation(extent={{-28,30},{-48,50}})));
        Physiomodel.Gases.IO_Bus.OutputComparison_SI
                                    gases_dif
          annotation (Placement(transformation(extent={{-38,-80},{-18,-60}})));
        Physiomodel.Gases.IO_Bus.OutputToFile_SI
                                           gases_varsToFile
          annotation (Placement(transformation(extent={{-98,-92},{-78,-72}})));
      equation
        connect(setup.busConnector,hormones. busConnector) annotation (Line(
            points={{-6,-96},{-6,16},{50,16}},
            color={0,0,255},
            thickness=0.5,
            smooth=Smooth.None));
        connect(setup.busConnector,proteins. busConnector) annotation (Line(
            points={{-6,-96},{-6,-18},{-38,-18}},
            color={0,0,255},
            thickness=0.5,
            smooth=Smooth.None));
        connect(setup.busConnector,cardioVascularSystem. busConnector)
                                                      annotation (Line(
            points={{-6,-96},{-6,83},{50,83}},
            color={0,0,255},
            thickness=0.5,
            smooth=Smooth.None));
        connect(setup.busConnector,nutrientsAndMetabolism. busConnector)
          annotation (Line(
            points={{-6,-96},{-6,70},{-76,70}},
            color={0,0,255},
            thickness=0.5,
            smooth=Smooth.None));
        connect(setup.busConnector,water. busConnector) annotation (Line(
            points={{-6,-96},{-6,4},{-76,4}},
            color={0,0,255},
            thickness=0.5,
            smooth=Smooth.None));
        connect(setup.busConnector,nerves. busConnector) annotation (Line(
            points={{-6,-96},{-6,48},{84,48}},
            color={0,0,255},
            thickness=0.5,
            smooth=Smooth.None));
        connect(status.busConnector,setup. busConnector)         annotation (Line(
            points={{52,-70},{-6,-70},{-6,-96}},
            color={0,0,255},
            thickness=0.5,
            smooth=Smooth.None));
        connect(electrolytes.busConnector,setup. busConnector) annotation (Line(
            points={{74,-20},{-6,-20},{-6,-96}},
            color={0,0,255},
            thickness=0.5,
            smooth=Smooth.None));
        connect(gases.busConnector,setup. busConnector) annotation (Line(
            points={{-60,-46},{-6,-46},{-6,-96}},
            color={0,0,255},
            thickness=0.5,
            smooth=Smooth.None));
        connect(heat.busConnector,setup. busConnector) annotation (Line(
            points={{-38,40},{-6,40},{-6,-96}},
            color={0,0,255},
            thickness=0.5,
            smooth=Smooth.None));
        connect(gases.busConnector, gases_dif.busConnector) annotation (Line(
            points={{-60,-46},{-44,-46},{-44,-70},{-28,-70}},
            color={0,0,255},
            thickness=0.5,
            smooth=Smooth.None));
        connect(gases_varsToFile.busConnector, gases.busConnector) annotation (
            Line(
            points={{-88,-82},{-88,-46},{-60,-46}},
            color={0,0,255},
            thickness=0.5,
            smooth=Smooth.None));
      //if terminal() then

      /*   Streams.print("cardioVascularSystem.busConnector.Bone_PCO2\n"+String(cardioVascularSystem.busConnector.Bone_PCO2),OUTPUT_FILE);

Streams.print("cardioVascularSystem.busConnector.Brain_PCO2\n"+String(cardioVascularSystem.busConnector.Brain_PCO2),OUTPUT_FILE);
Streams.print("cardioVascularSystem.busConnector.Fat_PCO2\n"+String(cardioVascularSystem.busConnector.Fat_PCO2),OUTPUT_FILE);
Streams.print("cardioVascularSystem.busConnector.GITract_PCO2\n"+String(cardioVascularSystem.busConnector.GITract_PCO2),OUTPUT_FILE);
Streams.print("cardioVascularSystem.busConnector.Kidney_PCO2\n"+String(cardioVascularSystem.busConnector.Kidney_PCO2),OUTPUT_FILE);
Streams.print("cardioVascularSystem.busConnector.LeftHeart_PCO2\n"+String(cardioVascularSystem.busConnector.LeftHeart_PCO2),OUTPUT_FILE);
Streams.print("cardioVascularSystem.busConnector.Liver_PCO2\n"+String(cardioVascularSystem.busConnector.Liver_PCO2),OUTPUT_FILE);
Streams.print("cardioVascularSystem.busConnector.OtherTissue_PCO2\n"+String(cardioVascularSystem.busConnector.OtherTissue_PCO2),OUTPUT_FILE);
Streams.print("cardioVascularSystem.busConnector.RespiratoryMuscle_PCO2\n"+String(cardioVascularSystem.busConnector.RespiratoryMuscle_PCO2),OUTPUT_FILE);
Streams.print("cardioVascularSystem.busConnector.RightHeart_PCO2\n"+String(cardioVascularSystem.busConnector.RightHeart_PCO2),OUTPUT_FILE);
Streams.print("cardioVascularSystem.busConnector.SkeletalMuscle_PCO2\n"+String(cardioVascularSystem.busConnector.SkeletalMuscle_PCO2),OUTPUT_FILE);
Streams.print("cardioVascularSystem.busConnector.Skin_PCO2\n"+String(cardioVascularSystem.busConnector.Skin_PCO2),OUTPUT_FILE);
Streams.print("cardioVascularSystem.busConnector.Urine_pH\n"+String(cardioVascularSystem.busConnector.Urine_pH),OUTPUT_FILE);

Streams.print("gases.carbonDioxyd.alveolarVentilation.solventFlowPump.q_out.conc|"+String(gases.carbonDioxyd.alveolarVentilation.solventFlowPump.q_out.conc),OUTPUT_FILE);
Streams.print("gases.carbonDioxyd.artysCO2.pCO2|"+String(gases.carbonDioxyd.artysCO2.pCO2),OUTPUT_FILE);
Streams.print("gases.carbonDioxyd.veinsCO2.pCO2|"+String(gases.carbonDioxyd.veinsCO2.pCO2),OUTPUT_FILE);
Streams.print("gases.oxygen.alveolarVentilation.solventFlowPump.q_out.conc|"+String(gases.oxygen.alveolarVentilation.solventFlowPump.q_out.conc),OUTPUT_FILE);
Streams.print("gases.oxygen.artysO2.a|"+String(gases.oxygen.artysO2.a),OUTPUT_FILE);
Streams.print("gases.oxygen.artysO2.FCOHb|"+String(gases.oxygen.artysO2.FCOHb),OUTPUT_FILE);
Streams.print("gases.oxygen.artysO2.pO2|"+String(gases.oxygen.artysO2.pO2),OUTPUT_FILE);
Streams.print("gases.oxygen.O2Lung.a|"+String(gases.oxygen.O2Lung.a),OUTPUT_FILE);
Streams.print("gases.oxygen.O2Lung.FCOHb|"+String(gases.oxygen.O2Lung.FCOHb),OUTPUT_FILE);
Streams.print("gases.oxygen.O2Lung.tO2|"+String(gases.oxygen.O2Lung.tO2),OUTPUT_FILE);
Streams.print("gases.oxygen.tissuesO2.boneO2.O2Tissue.a|"+String(gases.oxygen.tissuesO2.boneO2.O2Tissue.a),OUTPUT_FILE);
Streams.print("gases.oxygen.tissuesO2.boneO2.O2Tissue.FCOHb|"+String(gases.oxygen.tissuesO2.boneO2.O2Tissue.FCOHb),OUTPUT_FILE);
Streams.print("gases.oxygen.tissuesO2.boneO2.O2Tissue.pO2|"+String(gases.oxygen.tissuesO2.boneO2.O2Tissue.pO2),OUTPUT_FILE);
Streams.print("gases.oxygen.tissuesO2.brainO2.O2Tissue.a|"+String(gases.oxygen.tissuesO2.brainO2.O2Tissue.a),OUTPUT_FILE);
Streams.print("gases.oxygen.tissuesO2.brainO2.O2Tissue.FCOHb|"+String(gases.oxygen.tissuesO2.brainO2.O2Tissue.FCOHb),OUTPUT_FILE);
Streams.print("gases.oxygen.tissuesO2.brainO2.O2Tissue.pO2|"+String(gases.oxygen.tissuesO2.brainO2.O2Tissue.pO2),OUTPUT_FILE);
Streams.print("gases.oxygen.tissuesO2.fatO2.O2Tissue.a|"+String(gases.oxygen.tissuesO2.fatO2.O2Tissue.a),OUTPUT_FILE);
Streams.print("gases.oxygen.tissuesO2.fatO2.O2Tissue.FCOHb|"+String(gases.oxygen.tissuesO2.fatO2.O2Tissue.FCOHb),OUTPUT_FILE);
Streams.print("gases.oxygen.tissuesO2.fatO2.O2Tissue.pO2|"+String(gases.oxygen.tissuesO2.fatO2.O2Tissue.pO2),OUTPUT_FILE);
Streams.print("gases.oxygen.tissuesO2.GITractO2.O2Tissue.a|"+String(gases.oxygen.tissuesO2.GITractO2.O2Tissue.a),OUTPUT_FILE);
Streams.print("gases.oxygen.tissuesO2.GITractO2.O2Tissue.FCOHb|"+String(gases.oxygen.tissuesO2.GITractO2.O2Tissue.FCOHb),OUTPUT_FILE);
Streams.print("gases.oxygen.tissuesO2.GITractO2.O2Tissue.pO2|"+String(gases.oxygen.tissuesO2.GITractO2.O2Tissue.pO2),OUTPUT_FILE);
Streams.print("gases.oxygen.tissuesO2.kidneyO2.O2Tissue.a|"+String(gases.oxygen.tissuesO2.kidneyO2.O2Tissue.a),OUTPUT_FILE);
Streams.print("gases.oxygen.tissuesO2.kidneyO2.O2Tissue.FCOHb|"+String(gases.oxygen.tissuesO2.kidneyO2.O2Tissue.FCOHb),OUTPUT_FILE);
Streams.print("gases.oxygen.tissuesO2.kidneyO2.O2Tissue.pO2|"+String(gases.oxygen.tissuesO2.kidneyO2.O2Tissue.pO2),OUTPUT_FILE);
Streams.print("gases.oxygen.tissuesO2.leftHeartO2.O2Tissue.a|"+String(gases.oxygen.tissuesO2.leftHeartO2.O2Tissue.a),OUTPUT_FILE);
Streams.print("gases.oxygen.tissuesO2.leftHeartO2.O2Tissue.FCOHb|"+String(gases.oxygen.tissuesO2.leftHeartO2.O2Tissue.FCOHb),OUTPUT_FILE);
Streams.print("gases.oxygen.tissuesO2.leftHeartO2.O2Tissue.pO2|"+String(gases.oxygen.tissuesO2.leftHeartO2.O2Tissue.pO2),OUTPUT_FILE);
Streams.print("gases.oxygen.tissuesO2.liverO2.O2Tissue.a|"+String(gases.oxygen.tissuesO2.liverO2.O2Tissue.a),OUTPUT_FILE);
Streams.print("gases.oxygen.tissuesO2.liverO2.O2Tissue.FCOHb|"+String(gases.oxygen.tissuesO2.liverO2.O2Tissue.FCOHb),OUTPUT_FILE);
Streams.print("gases.oxygen.tissuesO2.liverO2.O2Tissue.pO2|"+String(gases.oxygen.tissuesO2.liverO2.O2Tissue.pO2),OUTPUT_FILE);
Streams.print("gases.oxygen.tissuesO2.otherTissueO2.O2Tissue.a|"+String(gases.oxygen.tissuesO2.otherTissueO2.O2Tissue.a),OUTPUT_FILE);
Streams.print("gases.oxygen.tissuesO2.otherTissueO2.O2Tissue.FCOHb|"+String(gases.oxygen.tissuesO2.otherTissueO2.O2Tissue.FCOHb),OUTPUT_FILE);
Streams.print("gases.oxygen.tissuesO2.otherTissueO2.O2Tissue.pO2|"+String(gases.oxygen.tissuesO2.otherTissueO2.O2Tissue.pO2),OUTPUT_FILE);
Streams.print("gases.oxygen.tissuesO2.respiratoryMuscleO2.O2Tissue.a|"+String(gases.oxygen.tissuesO2.respiratoryMuscleO2.O2Tissue.a),OUTPUT_FILE);
Streams.print("gases.oxygen.tissuesO2.respiratoryMuscleO2.O2Tissue.FCOHb|"+String(gases.oxygen.tissuesO2.respiratoryMuscleO2.O2Tissue.FCOHb),OUTPUT_FILE);
Streams.print("gases.oxygen.tissuesO2.respiratoryMuscleO2.O2Tissue.pO2|"+String(gases.oxygen.tissuesO2.respiratoryMuscleO2.O2Tissue.pO2),OUTPUT_FILE);
Streams.print("gases.oxygen.tissuesO2.rightHeartO2.O2Tissue.a|"+String(gases.oxygen.tissuesO2.rightHeartO2.O2Tissue.a),OUTPUT_FILE);
Streams.print("gases.oxygen.tissuesO2.rightHeartO2.O2Tissue.FCOHb|"+String(gases.oxygen.tissuesO2.rightHeartO2.O2Tissue.FCOHb),OUTPUT_FILE);
Streams.print("gases.oxygen.tissuesO2.rightHeartO2.O2Tissue.pO2|"+String(gases.oxygen.tissuesO2.rightHeartO2.O2Tissue.pO2),OUTPUT_FILE);
Streams.print("gases.oxygen.tissuesO2.skeletalMuscleO2.O2Tissue.a|"+String(gases.oxygen.tissuesO2.skeletalMuscleO2.O2Tissue.a),OUTPUT_FILE);
Streams.print("gases.oxygen.tissuesO2.skeletalMuscleO2.O2Tissue.FCOHb|"+String(gases.oxygen.tissuesO2.skeletalMuscleO2.O2Tissue.FCOHb),OUTPUT_FILE);
Streams.print("gases.oxygen.tissuesO2.skeletalMuscleO2.O2Tissue.pO2|"+String(gases.oxygen.tissuesO2.skeletalMuscleO2.O2Tissue.pO2),OUTPUT_FILE);
Streams.print("gases.oxygen.tissuesO2.skinO2.O2Tissue.a|"+String(gases.oxygen.tissuesO2.skinO2.O2Tissue.a),OUTPUT_FILE);
Streams.print("gases.oxygen.tissuesO2.skinO2.O2Tissue.FCOHb|"+String(gases.oxygen.tissuesO2.skinO2.O2Tissue.FCOHb),OUTPUT_FILE);
Streams.print("gases.oxygen.tissuesO2.skinO2.O2Tissue.pO2|"+String(gases.oxygen.tissuesO2.skinO2.O2Tissue.pO2),OUTPUT_FILE);
Streams.print("gases.oxygen.veinsO2.a|"+String(gases.oxygen.veinsO2.a),OUTPUT_FILE);
Streams.print("gases.oxygen.veinsO2.FCOHb|"+String(gases.oxygen.veinsO2.FCOHb),OUTPUT_FILE);
Streams.print("gases.oxygen.veinsO2.pO2|"+String(gases.oxygen.veinsO2.pO2),OUTPUT_FILE);*/
      //end if;
        annotation (          experiment(StopTime=1e+006, Tolerance=1e-005));
      end GasesAndElectrolytes_test_SI;
    end IO_Bus;
    annotation (Documentation(revisions="<html>
<table cellspacing=\"2\" cellpadding=\"0\" border=\"0\"><tr>
<td><p>Author:</p></td>
<td><p>Marek Matejak</p></td>
</tr>
<tr>
<td><p>License:</p></td>
<td><p><a href=\"http://www.physiomodel.org/license.html\">Physiomodel License 1.0</a> </p></td>
</tr>

<tr>
<td><p>Date of:</p></td>
<td><p>2008-2015</p></td>
</tr>
<tr>
<td><p>References:</p></td>
<td><p>Tom Coleman: HumMod 1.6, University of Mississippi Medical Center</p></td>
</tr>
<tr>
<td></td>
<td><p><br><br>Siggaard Andersen: OSA (2005), University of Copenhagen</p><p>M. Matej&aacute;k, T. Kulh&aacute;nek, and S. Matou&scaron;ek, &QUOT;Adair-based hemoglobin equilibrium with oxygen, carbon dioxide and hydrogen ion activity,&QUOT; Scandinavian Journal of Clinical &AMP; Laboratory Investigation, pp. 1-8, 2015.</p></td>
</tr>
</table>
<p><br><br>Copyright &copy; 2008-2015 Marek Matejak, Charles University in Prague.</p>
</html>"));
  end Gases;

  package Water "Body Water"
    extends Physiolibrary.Icons.WaterLib;
    package Hydrostatics
    "Hydrostatic pressure difference in upper, midle and lower torso"

    block Constant "Generate constant signal of type Posture"
      parameter Posture k=Posture.Lying "Constant output value";

      PostureOutput y "Connector of Real output signal"
        annotation (Placement(transformation(extent={{100,-10},{120,10}})));

    equation
      y = k;

      annotation (
        Icon(coordinateSystem(
        preserveAspectRatio=true,
        extent={{-100,-100},{100,100}},
        grid={2,2},
        initialScale=0.04), graphics={Rectangle(
                extent={{-100,100},{100,-100}},
                lineColor={0,0,255},
                fillPattern=FillPattern.Solid,
                fillColor={255,255,255}), Text(
                extent={{-100,-40},{100,46}},
                lineColor={0,0,0},
                fillColor={255,255,255},
                fillPattern=FillPattern.Solid,
                textString="%k")}),
        Diagram(coordinateSystem(
        preserveAspectRatio=true,
        extent={{-100,-100},{100,100}},
        grid={2,2},
        initialScale=0.04), graphics={Text(
                extent={{-100,-100},{100,100}},
                lineColor={0,0,0},
                textString="%k")}),
    Documentation(info="<html>
<p>
The Real output y is a constant signal:
</p>
</html>"));
    end Constant;

      type Posture = enumeration(
        Lying,
        Sitting,
        Standing,
        Tilting,
        SteadyState);

      model TorsoHydrostatics

         parameter Physiolibrary.Types.Fraction Alpha =   0.1667
        "torso: capilary pressure coeficient between artery and vein pressure";
         parameter Physiolibrary.Types.Acceleration GravityAcceleration = 9.81
        "gravity constant";
         parameter Physiolibrary.Types.Density BloodDensity = 1060
        "blood density";

         parameter Physiolibrary.Types.Position TorsoHeight
        "torso: center of gravity - height";

         parameter Physiolibrary.Types.Fraction artyFractGz[Posture]
        "torso: arty hydrostatic effects for posturing";
         parameter Physiolibrary.Types.Fraction veinFractGz[Posture]
        "torso: vein hydrostatic effects for posturing";

         Physiolibrary.Types.Fraction ArtyFractGz;
         Physiolibrary.Types.Fraction VeinFractGz;
         Physiolibrary.Types.Pressure TorsoArtyGradient;
         Physiolibrary.Types.Pressure TorsoVeinGradient;
         Physiolibrary.Types.Pressure Arty;
         Physiolibrary.Types.Pressure Vein;

        Physiolibrary.Types.RealIO.FractionInput
                                           Pump_Effect "xNormal"
                                                 annotation (Placement(transformation(extent={{
                  -120,-100},{-80,-60}}), iconTransformation(extent={{-120,-100},{-80,
                  -60}})));
        Physiolibrary.Types.RealIO.PressureInput
                                           fromPressure
        "torso: systemic arteries pressure"                               annotation (Placement(transformation(extent={{
                  -120,0},{-80,40}}), iconTransformation(extent={{-120,0},{-80,40}})));
        Physiolibrary.Types.RealIO.PressureInput
                                           toPressure
        "torso: systemic veins pressure"                                     annotation (Placement(transformation(extent={{-120,
                  -40},{-80,0}}),       iconTransformation(extent={{-120,-40},{-80,0}})));
        PostureInput Status_Posture "Lying, Sitting, Standing or Tilting"           annotation (Placement(transformation(
                extent={{-120,60},{-80,100}}), iconTransformation(extent={{-120,60},{
                  -80,100}})));
        Physiolibrary.Types.RealIO.PressureOutput Capy
        "torso: average capilaries pressure"                                                        annotation (Placement(transformation(extent={{80,-20},
                  {120,20}}), iconTransformation(extent={{80,-20},{120,20}})));
      equation
         ArtyFractGz = artyFractGz[Status_Posture];
         VeinFractGz = veinFractGz[Status_Posture]; //in legs veins are valves

         TorsoArtyGradient  =  TorsoHeight * GravityAcceleration * BloodDensity * ArtyFractGz;  //Hydrostatic pressure: P=ro.g.h
         //cm *  0.01 m/cm * 9.81 m/s² * 1060 kg/m3 * 1/133.322 mmHg/Pa
         //= height[cm] * 0.77996129671022036873134216408395 [mmHg]
         //Blood density = 1060 kg/m3: Cutnell, John & Johnson, Kenneth. Physics, Fourth Edition. Wiley, 1998: 308.

         //bloodDensity = 1060 kg/m3
         //gravityAcceleration = 9.81 m/s2
         //Pa2mmHg = 1/133.322 mmHg/Pa
         //cm2m = 0.01 m/cm
         //averageHydrostaticHeight = TorsoCM * postureCoef[Status_Posture]
         //hydrostaticPressure = averageHydrostaticHeight * cm2m * bloodDensity * gravityAcceleration * Pa2mmHg
         //                    = 0.77996 * averageHydrostaticHeight

         TorsoVeinGradient  =  TorsoHeight * GravityAcceleration * BloodDensity * VeinFractGz;

         Arty  = max( (fromPressure + TorsoArtyGradient), 0);
         Vein  = max( toPressure + ( TorsoVeinGradient * Pump_Effect), 0);  //only lower torso has LegMusclePump_Effect
         Capy  = max( ( Alpha * Arty)   + ( 1.0 - Alpha)  * Vein, 0);

       annotation (
      Documentation(info="<HTML>
</HTML>
",     revisions="<html>
<ul>
<li><i>  </i>
       </li>
<li><i> january 2009 </i><br>
       by Marek Matejak in Modelica initially implemented (consulted with Jiri Kofranek), Charles University, Prague<br>
       orginaly described by Tom Coleman in QHP 2008 beta 3, University of Mississippi Medical Center
       </li>
</ul>
</html>"));
      end TorsoHydrostatics;

      model Hydrostatics
        extends Physiolibrary.Icons.Hydrostatics;

         parameter Real TiltTable_Degrees( final quantity="Angle", final displayUnit="Deg")= 0;

        TorsoHydrostatics UpperTorsoHydrostatics(
          artyFractGz={0,1,1,sin(Modelica.SIunits.Conversions.from_deg(
              TiltTable_Degrees)),1.76947},
          veinFractGz={0,1,1,sin(Modelica.SIunits.Conversions.from_deg(
              TiltTable_Degrees)),1.76947},
          TorsoHeight=-0.1)
          annotation (Placement(transformation(extent={{-12,34},{16,62}})));

        TorsoHydrostatics LowerTorsoHydrostatics(
          artyFractGz={0,0.7,1,sin(Modelica.SIunits.Conversions.from_deg(
              TiltTable_Degrees)),0.0190301},
          veinFractGz={0.2,0.7,1,0.2 + sin(Modelica.SIunits.Conversions.from_deg(
              TiltTable_Degrees)),0.0190301},
          TorsoHeight=0.5)
          annotation (Placement(transformation(extent={{-12,-42},{16,-14}})));

        TorsoHydrostatics MiddleTorsoHydrostatics(
          artyFractGz={0,1,1,sin(Modelica.SIunits.Conversions.from_deg(
              TiltTable_Degrees)),-0.00024891},
          veinFractGz={0,1,1,sin(Modelica.SIunits.Conversions.from_deg(
              TiltTable_Degrees)),-0.00024891},
          TorsoHeight=0.04)
          annotation (Placement(transformation(extent={{-12,-4},{16,24}})));

      Physiolibrary.Types.Constants.FractionConst             PumpEffect(k=1)
        annotation (Placement(transformation(extent={{-40,32},{-36,36}})));
        Physiolibrary.Types.RealIO.PressureInput
                                           SystemicArtys_Pressure
          annotation (Placement(transformation(extent={{-44,56},{-40,60}}),
              iconTransformation(extent={{-100,-30},{-80,-10}})));
        Physiolibrary.Types.RealIO.PressureInput
                                           RightAtrium_Pressure
          annotation (Placement(transformation(extent={{-34,66},{-30,70}}),
              iconTransformation(extent={{-100,10},{-80,30}})));
        Physiolibrary.Types.RealIO.FractionInput
                                           LegMusclePump_Effect
          annotation (Placement(transformation(extent={{-46,-42},{-38,-34}}),
              iconTransformation(extent={{-100,-90},{-80,-70}})));
        Modelica.Blocks.Interfaces.RealInput Status_Posture
        "Lying, Sitting, Standing or Tilting"                                     annotation (Placement(transformation(
                extent={{-90,22},{-86,26}}), iconTransformation(extent={{-100,70},{-80,
                  90}})));
        Physiolibrary.Types.RealIO.PressureOutput
                                            RegionalPressure_UpperCapy
                                                annotation (Placement(transformation(
                extent={{42,44},{50,52}}),     iconTransformation(extent={{90,20},{
                  110,40}})));
        Physiolibrary.Types.RealIO.PressureOutput
                                            RegionalPressure_MiddleCapy
                                                annotation (Placement(transformation(
                extent={{42,6},{50,14}}),      iconTransformation(extent={{90,-20},{
                  110,0}})));
        Physiolibrary.Types.RealIO.PressureOutput
                                            RegionalPressure_LowerCapy
                                                annotation (Placement(transformation(
                extent={{42,-32},{50,-24}}),   iconTransformation(extent={{90,-60},{
                  110,-40}})));
        Real2Posture real2Posture
          annotation (Placement(transformation(extent={{-72,20},{-64,28}})));
      equation
        connect(RightAtrium_Pressure,LowerTorsoHydrostatics. toPressure) annotation (
            Line(
            points={{-32,68},{-28,68},{-28,-30.8},{-12,-30.8}},
            color={0,0,127},
            smooth=Smooth.None));
        connect(RightAtrium_Pressure,MiddleTorsoHydrostatics. toPressure) annotation (
           Line(
            points={{-32,68},{-28,68},{-28,7.2},{-12,7.2}},
            color={0,0,127},
            smooth=Smooth.None));
        connect(RightAtrium_Pressure,UpperTorsoHydrostatics. toPressure) annotation (
            Line(
            points={{-32,68},{-28,68},{-28,45.2},{-12,45.2}},
            color={0,0,127},
            smooth=Smooth.None));
        connect(PumpEffect.y,UpperTorsoHydrostatics. Pump_Effect) annotation (Line(
            points={{-35.5,34},{-26,34},{-26,36.8},{-12,36.8}},
            color={0,0,127},
            smooth=Smooth.None));
        connect(MiddleTorsoHydrostatics.Pump_Effect,PumpEffect. y) annotation (Line(
            points={{-12,-1.2},{-26,-1.2},{-26,34},{-35.5,34}},
            color={0,0,127},
            smooth=Smooth.None));
        connect(SystemicArtys_Pressure,LowerTorsoHydrostatics. fromPressure)
          annotation (Line(
            points={{-42,58},{-30,58},{-30,-25.2},{-12,-25.2}},
            color={0,0,127},
            smooth=Smooth.None));
        connect(SystemicArtys_Pressure,MiddleTorsoHydrostatics. fromPressure)
          annotation (Line(
            points={{-42,58},{-30,58},{-30,12.8},{-12,12.8}},
            color={0,0,127},
            smooth=Smooth.None));
        connect(SystemicArtys_Pressure,UpperTorsoHydrostatics. fromPressure)
          annotation (Line(
            points={{-42,58},{-30,58},{-30,50.8},{-12,50.8}},
            color={0,0,127},
            smooth=Smooth.None));
        connect(LegMusclePump_Effect,LowerTorsoHydrostatics. Pump_Effect) annotation (
           Line(
            points={{-42,-38},{-32,-38},{-32,-39.2},{-12,-39.2}},
            color={0,0,127},
            smooth=Smooth.None));
        connect(UpperTorsoHydrostatics.Capy, RegionalPressure_UpperCapy) annotation (
            Line(
            points={{16,48},{46,48}},
            color={0,0,127},
            smooth=Smooth.None));
        connect(MiddleTorsoHydrostatics.Capy, RegionalPressure_MiddleCapy)
          annotation (Line(
            points={{16,10},{46,10}},
            color={0,0,127},
            smooth=Smooth.None));
        connect(LowerTorsoHydrostatics.Capy, RegionalPressure_LowerCapy) annotation (
            Line(
            points={{16,-28},{46,-28}},
            color={0,0,127},
            smooth=Smooth.None));

        connect(UpperTorsoHydrostatics.Status_Posture, real2Posture.y) annotation (
            Line(
            points={{-12,59.2},{-32,59.2},{-32,24},{-63.2,24}},
            color={0,127,127},
            smooth=Smooth.None));

        connect(real2Posture.y, MiddleTorsoHydrostatics.Status_Posture) annotation (
            Line(
            points={{-63.2,24},{-32,24},{-32,21.2},{-12,21.2}},
            color={0,127,127},
            smooth=Smooth.None));
        connect(LowerTorsoHydrostatics.Status_Posture, real2Posture.y) annotation (
            Line(
            points={{-12,-16.8},{-32,-16.8},{-32,24},{-63.2,24}},
            color={0,127,127},
            smooth=Smooth.None));
      connect(Status_Posture, real2Posture.u) annotation (Line(
          points={{-88,24},{-72.8,24}},
          color={0,0,127},
          smooth=Smooth.None));
        annotation ( Icon(coordinateSystem(
                preserveAspectRatio=true, extent={{-100,-100},{100,100}}),
              graphics={
              Text(
                extent={{-100,122},{100,102}},
                lineColor={0,0,255},
                textString="%name"),
              Rectangle(extent={{-100,100},{100,-100}}, lineColor={0,0,0})}));
      end Hydrostatics;

      connector PostureInput =
                            input Posture "'input Posture' as connector"
        annotation (defaultComponentName="u",
        Icon(graphics={Polygon(
              points={{-100,100},{100,0},{-100,-100},{-100,100}},
              lineColor={0,127,127},
              fillColor={0,127,127},
              fillPattern=FillPattern.Solid), Text(
              extent={{100,-50},{700,50}},
              lineColor={0,127,127},
              textString="%name")},
             coordinateSystem(extent={{-100,-100},{100,100}}, preserveAspectRatio=true, initialScale=0.2)),
        Diagram(coordinateSystem(
              preserveAspectRatio=true, initialScale=0.2,
              extent={{-100,-100},{100,100}},
              grid={1,1}), graphics={Polygon(
              points={{0,50},{100,0},{0,-50},{0,50}},
              lineColor={0,127,127},
              fillColor={0,127,127},
              fillPattern=FillPattern.Solid), Text(
              extent={{-10,85},{-10,60}},
              lineColor={0,127,127},
              textString="%name")}),
          Documentation(info="<html>
<p>
Connector with one input signal of type Posture.
</p>
</html>"));

      connector PostureOutput =
                          output Posture "'input Posture' as connector"
      annotation (defaultComponentName="u",
      Icon(graphics={Polygon(
              points={{-100,100},{100,0},{-100,-100},{-100,100}},
              lineColor={0,127,127},
              fillColor={255,255,255},
              fillPattern=FillPattern.Solid), Text(
              extent={{100,-50},{700,50}},
              lineColor={0,127,127},
              textString="%name")},
           coordinateSystem(extent={{-100,-100},{100,100}}, preserveAspectRatio=true, initialScale=0.2)),
      Diagram(coordinateSystem(
            preserveAspectRatio=true, initialScale=0.2,
            extent={{-100,-100},{100,100}},
            grid={1,1}), graphics={Polygon(
              points={{0,50},{100,0},{0,-50},{0,50}},
              lineColor={0,127,127},
              fillColor={0,127,127},
              fillPattern=FillPattern.Solid), Text(
              extent={{-10,85},{-10,60}},
              lineColor={0,127,127},
              textString="%name")}),
        Documentation(info="<html>
<p>
Connector with one input signal of type Posture.
</p>
</html>"));

    model Real2Posture "Convert Real to type Posture"
      extends Physiolibrary.Icons.ConversionIcon;

      PostureOutput y "Connector of Real output signal"
        annotation (Placement(transformation(extent={{60,-20},{80,0}}), iconTransformation(extent={{100,-20},{140,20}})));

      Modelica.Blocks.Interfaces.RealInput u
                                      annotation (Placement(transformation(extent={{-130,
                -20},{-90,20}}),      iconTransformation(extent={{-140,-20},{-100,20}})));
      Integer tmp;
    equation

      tmp = integer(u);
      y = if tmp <= 0 then Posture.Lying elseif tmp == 1 then Posture.Sitting
       elseif tmp == 2 then Posture.Standing
       elseif tmp == 3 then Posture.Tilting else Posture.SteadyState;
      annotation (
    Documentation(info="<html>
<p>
The Real output y is a constant signal:
</p>
</html>"));
    end Real2Posture;
    end Hydrostatics;

    package Osmoles "Intracellular vs. Extracellular Water"

      model OsmBody

        Physiolibrary.Types.RealIO.AmountOfSubstanceInput
                                           OsmECFV_Electrolytes                                annotation (Placement(transformation(
                extent={{-120,50},{-80,90}}), iconTransformation(extent={{-100,88},{-76,
                  112}})));
        Physiolibrary.Types.RealIO.AmountOfSubstanceInput
                                           OsmCell_Electrolytes                                annotation (Placement(transformation(
                extent={{-120,-10},{-80,30}}),
                                             iconTransformation(extent={{-100,48},{-76,
                  72}})));
        Physiolibrary.Types.RealIO.AmountOfSubstanceInput
                                           UreaECF      annotation (Placement(
              transformation(extent={{-120,20},{-80,60}}), iconTransformation(extent={{-100,8},
                  {-76,32}})));
        Physiolibrary.Types.RealIO.AmountOfSubstanceInput
                                           UreaICF      annotation (Placement(
              transformation(extent={{-120,-40},{-80,0}}),iconTransformation(extent={{-100,
                  -32},{-76,-8}})));
        Physiolibrary.Types.RealIO.VolumeInput
                                           BodyH2O_Vol "all water in body"
                                                               annotation (Placement(transformation(extent={{-120,
                  -110},{-80,-70}}),   iconTransformation(extent={{-100,-112},{-76,-88}})));
        Physiolibrary.Types.RealIO.VolumeOutput
                                            ECFV "extracellular water"
                                                           annotation (Placement(transformation(extent={{60,-80},
                  {100,-40}}),iconTransformation(extent={{92,28},{116,52}})));
        Physiolibrary.Types.RealIO.VolumeOutput
                                            ICFV "intracellular water"
                                                           annotation (Placement(transformation(extent={{60,60},
                  {100,100}}),iconTransformation(extent={{92,68},{116,92}})));

        parameter Physiolibrary.Types.Fraction Dissociation = 0.890;

        Physiolibrary.Types.AmountOfSubstance OsmECFV_NonElectrolytes;
        Physiolibrary.Types.AmountOfSubstance OsmCell_NonElectrolytes;
        Physiolibrary.Types.AmountOfSubstance Electrolytes;
        Physiolibrary.Types.AmountOfSubstance NonElectrolytes;
        Physiolibrary.Types.AmountOfSubstance Total;
        Physiolibrary.Types.AmountOfSubstance ECFVActiveElectrolytes;
        Physiolibrary.Types.AmountOfSubstance ICFVActiveElectrolytes;
        Physiolibrary.Types.AmountOfSubstance ActiveElectrolytes;
        Physiolibrary.Types.AmountOfSubstance ECFVActiveOsmoles;
        Physiolibrary.Types.AmountOfSubstance ICFVActiveOsmoles;
        Physiolibrary.Types.AmountOfSubstance ActiveOsmoles(start=11.6831341496947);
      //  Real Osm_conc_CellWall;
        //Real Osm_conc_Osmoreceptors;
        Physiolibrary.Types.RealIO.OsmolarityOutput
                                            OsmBody_Osm_conc_CellWalls      annotation (
            Placement(transformation(extent={{60,-20},{100,20}}), iconTransformation(
                extent={{92,-12},{116,12}})));
        Physiolibrary.Types.RealIO.OsmolarityOutput
                                            Osmoreceptors( start=0.25331)
                                                                  annotation (
            Placement(transformation(extent={{60,-54},{100,-14}}),iconTransformation(
                extent={{92,-52},{116,-28}})));
        Physiolibrary.Types.RealIO.AmountOfSubstanceInput
                                           GlucoseECF   annotation (Placement(
              transformation(extent={{-120,-40},{-80,0}}),iconTransformation(extent={{-100,
                  -72},{-76,-48}})));
        Physiolibrary.Types.RealIO.OsmolarityOutput ECFVOsmolarity annotation (
            Placement(transformation(extent={{60,-120},{100,-80}}),
              iconTransformation(extent={{92,-92},{116,-68}})));
      equation
            OsmECFV_NonElectrolytes = UreaECF + GlucoseECF + 0.340;
            OsmCell_NonElectrolytes = UreaICF + 0.354;

             Electrolytes  =  OsmECFV_Electrolytes + OsmCell_Electrolytes;
             NonElectrolytes  =  OsmECFV_NonElectrolytes + OsmCell_NonElectrolytes;
             Total  =  Electrolytes + NonElectrolytes;
             ECFVActiveElectrolytes  =  Dissociation * OsmECFV_Electrolytes;
             ICFVActiveElectrolytes  =  Dissociation * OsmCell_Electrolytes;
             ActiveElectrolytes  =  ECFVActiveElectrolytes + ICFVActiveElectrolytes;
             ECFVActiveOsmoles  =  ECFVActiveElectrolytes + OsmECFV_NonElectrolytes;
             ICFVActiveOsmoles  =  ICFVActiveElectrolytes + OsmCell_NonElectrolytes;
             ActiveOsmoles  =  ECFVActiveOsmoles + ICFVActiveOsmoles;
             OsmBody_Osm_conc_CellWalls  =  ActiveOsmoles / BodyH2O_Vol;
             Osmoreceptors  = ActiveElectrolytes / BodyH2O_Vol; //, simplified=0.25331);
             ICFV  =  ( ICFVActiveOsmoles / ActiveOsmoles)  * BodyH2O_Vol;
             ECFV  =  BodyH2O_Vol - ICFV; // == ( ECFVActiveOsmoles / ActiveOsmoles)  * BodyH2O_Vol

             ECFVOsmolarity = ECFVActiveOsmoles/ECFV; // == OsmBody_Osm_conc_CellWalls
      annotation (
      Documentation(info="<html>
<pre>QHP 2008 / OsmBody

</pre>
<p><br/><br/>Intracellular water calculation from cells osmotic pressure.</p>
</html>",
       revisions="<html>
<ul>
<li><i>  </i>
       </li>
<li><i> january 2009 </i><br>
       by Marek Matejak in Modelica initially implemented (consulted with Jiri Kofranek), Charles University, Prague<br>
       orginaly described by Tom Coleman in QHP 2008 beta 3, University of Mississippi Medical Center
       </li>
</ul>
</html>"));
      end OsmBody;

      model ActiveOsmolesFake
      "Fake Distribution of active osmoles into extracellular parts to have the same extracellular osmolarity (typically 285 mosm/l)"

        Modelica.Blocks.Math.Product plasmaOsmoles
          annotation (Placement(transformation(extent={{40,9},{52,20}})));
      Physiolibrary.Types.BusConnector busConnector annotation (Placement(
            transformation(extent={{-20,32},{-8,44}}),iconTransformation(extent={
                {-118,62},{-80,100}})));
        Modelica.Blocks.Math.Product upperTorsoInterstitialOsmoles
          annotation (Placement(transformation(extent={{40,-15},{52,-4}})));
        Modelica.Blocks.Math.Product middleTorsoInterstitialOsmoles
          annotation (Placement(transformation(extent={{40,-35},{52,-24}})));
        Modelica.Blocks.Math.Product lowerTorsoInterstitialOsmoles
          annotation (Placement(transformation(extent={{40,-57},{52,-46}})));
        Modelica.Blocks.Math.Product plasmaOsmoles1
          annotation (Placement(transformation(extent={{40,31},{52,42}})));
      equation
        connect(busConnector.PlasmaVol, plasmaOsmoles.u2) annotation (Line(
            points={{-14,38},{-14,11.2},{38.8,11.2}},
            color={255,204,51},
            thickness=0.5,
            smooth=Smooth.None));
        connect(plasmaOsmoles.y, busConnector.PlasmaActiveOsmoles) annotation (Line(
            points={{52.6,14.5},{90,14.5},{90,25},{-14,25},{-14,38}},
            color={0,0,127},
            smooth=Smooth.None), Text(
            string="%second",
            index=1,
            extent={{6,3},{6,3}}));
        connect(busConnector.ECFVOsmolarity, plasmaOsmoles.u1) annotation (Line(
            points={{-14,38},{-14,17.8},{38.8,17.8}},
            color={255,204,51},
            thickness=0.5,
            smooth=Smooth.None), Text(
            string="%first",
            index=-1,
            extent={{-6,3},{-6,3}}));
        connect(upperTorsoInterstitialOsmoles.y, busConnector.UT.InterstitialOsmoles)
          annotation (Line(
            points={{52.6,-9.5},{92,-9.5},{92,1},{-14,1},{-14,38}},
            color={0,0,127},
            smooth=Smooth.None), Text(
            string="%second",
            index=1,
            extent={{6,3},{6,3}}));
        connect(busConnector.ECFVOsmolarity, upperTorsoInterstitialOsmoles.u1)
          annotation (Line(
            points={{-14,38},{-14,-6.2},{38.8,-6.2}},
            color={255,204,51},
            thickness=0.5,
            smooth=Smooth.None), Text(
            string="%first",
            index=-1,
            extent={{-6,3},{-6,3}}));
        connect(busConnector.MT.InterstitialWater_Vol, middleTorsoInterstitialOsmoles.u2)
          annotation (Line(
            points={{-14,38},{-14,-32.8},{38.8,-32.8}},
            color={255,204,51},
            thickness=0.5,
            smooth=Smooth.None));
        connect(middleTorsoInterstitialOsmoles.y, busConnector.MT.InterstitialOsmoles)
          annotation (Line(
            points={{52.6,-29.5},{92,-29.5},{92,-19},{-14,-19},{-14,38}},
            color={0,0,127},
            smooth=Smooth.None), Text(
            string="%second",
            index=1,
            extent={{6,3},{6,3}}));
        connect(busConnector.ECFVOsmolarity, middleTorsoInterstitialOsmoles.u1)
          annotation (Line(
            points={{-14,38},{-14,-26.2},{38.8,-26.2}},
            color={255,204,51},
            thickness=0.5,
            smooth=Smooth.None), Text(
            string="%first",
            index=-1,
            extent={{-6,3},{-6,3}}));
        connect(busConnector.LT.InterstitialWater_Vol, lowerTorsoInterstitialOsmoles.u2) annotation (
           Line(
            points={{-14,38},{-14,-54.8},{38.8,-54.8}},
            color={255,204,51},
            thickness=0.5,
            smooth=Smooth.None));
        connect(lowerTorsoInterstitialOsmoles.y, busConnector.LT.InterstitialOsmoles)
          annotation (Line(
            points={{52.6,-51.5},{92,-51.5},{92,-41},{-14,-41},{-14,38}},
            color={0,0,127},
            smooth=Smooth.None), Text(
            string="%second",
            index=1,
            extent={{6,3},{6,3}}));
        connect(busConnector.ECFVOsmolarity, lowerTorsoInterstitialOsmoles.u1)
          annotation (Line(
            points={{-14,38},{-14,-48.2},{38.8,-48.2}},
            color={255,204,51},
            thickness=0.5,
            smooth=Smooth.None), Text(
            string="%first",
            index=-1,
            extent={{-6,3},{-6,3}}));
        connect(busConnector.UT.InterstitialWater_Vol, upperTorsoInterstitialOsmoles.u2)
          annotation (Line(
            points={{-14,38},{-14,-12.8},{38.8,-12.8}},
            color={255,204,51},
            thickness=0.5,
            smooth=Smooth.None), Text(
            string="%first",
            index=-1,
            extent={{-6,3},{-6,3}}));
      connect(busConnector.RBCH2O_Vol, plasmaOsmoles1.u2) annotation (Line(
          points={{-14,38},{-14,33.2},{38.8,33.2}},
          color={0,0,255},
          thickness=0.5,
          smooth=Smooth.None), Text(
          string="%first",
          index=-1,
          extent={{-6,3},{-6,3}}));
      connect(plasmaOsmoles1.y, busConnector.ErythrocytesOsmoles) annotation (
          Line(
          points={{52.6,36.5},{88,36.5},{88,52},{-14,52},{-14,38}},
          color={0,0,127},
          smooth=Smooth.None), Text(
          string="%second",
          index=1,
          extent={{6,3},{6,3}}));
      connect(busConnector.ECFVOsmolarity, plasmaOsmoles1.u1) annotation (Line(
          points={{-14,38},{-14,39.8},{38.8,39.8}},
          color={0,0,255},
          thickness=0.5,
          smooth=Smooth.None), Text(
          string="%first",
          index=-1,
          extent={{-6,3},{-6,3}}));
      end ActiveOsmolesFake;

      model ActiveOsmolesFake2
      "Fake Distribution of active osmoles into extracellular parts to have the same extracellular osmolarity (typically 285 mosm/l)"

        Physiolibrary.Types.Constants.AmountOfSubstanceConst plasmaOsmoles(k=0.82)
          annotation (Placement(transformation(extent={{40,9},{52,20}})));
      Physiolibrary.Types.BusConnector busConnector annotation (Placement(
            transformation(extent={{-20,32},{-8,44}}),iconTransformation(extent={
                {-118,62},{-80,100}})));
        Physiolibrary.Types.Constants.AmountOfSubstanceConst upperTorsoInterstitialOsmoles(k=0.62)
          annotation (Placement(transformation(extent={{40,-15},{52,-4}})));
        Physiolibrary.Types.Constants.AmountOfSubstanceConst middleTorsoInterstitialOsmoles(k=1.55)
          annotation (Placement(transformation(extent={{40,-35},{52,-24}})));
        Physiolibrary.Types.Constants.AmountOfSubstanceConst lowerTorsoInterstitialOsmoles(k=0.93)
          annotation (Placement(transformation(extent={{40,-57},{52,-46}})));
        Physiolibrary.Types.Constants.AmountOfSubstanceConst ErythrocytesOsmoles(k=0.43)
          annotation (Placement(transformation(extent={{40,31},{52,42}})));
      equation
        connect(plasmaOsmoles.y, busConnector.PlasmaActiveOsmoles) annotation (Line(
            points={{53.5,14.5},{90,14.5},{90,25},{-14,25},{-14,38}},
            color={0,0,127},
            smooth=Smooth.None), Text(
            string="%second",
            index=1,
            extent={{6,3},{6,3}}));
        connect(upperTorsoInterstitialOsmoles.y, busConnector.UT.InterstitialOsmoles)
          annotation (Line(
            points={{53.5,-9.5},{92,-9.5},{92,1},{-14,1},{-14,38}},
            color={0,0,127},
            smooth=Smooth.None), Text(
            string="%second",
            index=1,
            extent={{6,3},{6,3}}));
        connect(middleTorsoInterstitialOsmoles.y, busConnector.MT.InterstitialOsmoles)
          annotation (Line(
            points={{53.5,-29.5},{92,-29.5},{92,-19},{-14,-19},{-14,38}},
            color={0,0,127},
            smooth=Smooth.None), Text(
            string="%second",
            index=1,
            extent={{6,3},{6,3}}));
        connect(lowerTorsoInterstitialOsmoles.y, busConnector.LT.InterstitialOsmoles)
          annotation (Line(
            points={{53.5,-51.5},{92,-51.5},{92,-41},{-14,-41},{-14,38}},
            color={0,0,127},
            smooth=Smooth.None), Text(
            string="%second",
            index=1,
            extent={{6,3},{6,3}}));
        connect(ErythrocytesOsmoles.y, busConnector.ErythrocytesOsmoles) annotation (
            Line(
            points={{53.5,36.5},{88,36.5},{88,52},{-14,52},{-14,38}},
            color={0,0,127},
            smooth=Smooth.None), Text(
            string="%second",
            index=1,
            extent={{6,3},{6,3}}));
      end ActiveOsmolesFake2;
    end Osmoles;

    package WaterCompartments "Body Water Distribution"

      model Outtake

      Physiolibrary.Osmotic.Interfaces.OsmoticPort_a     H2OLoss annotation (
          Placement(transformation(extent={{-120,-20},{-80,20}}),
            iconTransformation(extent={{-110,-10},{-90,10}})));

      //parameter Real H2OTarget(final quantity="VolumeFlowRate",final displayUnit="ml/min") = 0;

      parameter Real H2OMassEffect[ :,3] = {{  0.0,  0.0,  0.0}, { 50.0,  1.0,  0.0}}
        "volume to outtake effect";

      Physiolibrary.Osmotic.Sources.SolventOutflux  outputPump(
          useSolutionFlowInput=true)
        annotation (Placement(transformation(extent={{20,-20},{60,20}})));
      Physiolibrary.Blocks.Interpolation.Curve curve(
        x=H2OMassEffect[:, 1],
        y=H2OMassEffect[:, 2],
        slope=H2OMassEffect[:, 3])
        annotation (Placement(transformation(extent={{-60,24},{-40,44}})));
        Modelica.Blocks.Math.Product product
          annotation (Placement(transformation(extent={{-8,30},{12,50}})));
        Physiolibrary.Types.RealIO.VolumeFlowRateOutput
                                              outflow "volume flow rate"
                                               annotation (Placement(
              transformation(extent={{80,-60},{120,-20}}), iconTransformation(
              extent={{-20,-20},{20,20}},
              origin={100,-40})));
        Physiolibrary.Types.RealIO.VolumeFlowRateInput
                                             H2OTarget(displayUnit="ml/min")
        "maximal volume outflow rate"
          annotation (Placement(transformation(extent={{-100,60},{-60,100}}),
              iconTransformation(
              extent={{-20,-20},{20,20}},
              rotation=270,
              origin={0,40})));
        Physiolibrary.Types.RealIO.VolumeInput H2OVolume "volume" annotation (
            Placement(transformation(extent={{-118,22},{-78,62}}), iconTransformation(
              extent={{-20,-20},{20,20}},
              rotation=270,
              origin={-60,40})));
      equation

        connect(curve.val, product.u2) annotation (Line(
            points={{-40,34},{-10,34}},
            color={0,0,127},
            smooth=Smooth.None));
        connect(product.y, outflow) annotation (Line(
            points={{13,40},{84,40},{84,-40},{100,-40}},
            color={0,0,127},
            smooth=Smooth.None));
        connect(H2OTarget, product.u1) annotation (Line(
            points={{-80,80},{-24,80},{-24,46},{-10,46}},
            color={0,0,127},
            smooth=Smooth.None));
        connect(product.y, outputPump.solutionFlow) annotation (Line(
            points={{13,40},{40,40},{40,14}},
            color={0,0,127},
            smooth=Smooth.None));
        connect(H2OVolume, curve.u) annotation (Line(
            points={{-98,42},{-80,42},{-80,34},{-60,34}},
            color={0,0,127},
            smooth=Smooth.None));
      connect(H2OLoss, outputPump.q_in) annotation (Line(
          points={{-100,0},{28,0}},
          color={127,127,0},
          thickness=1,
          smooth=Smooth.None));
        annotation (Icon(coordinateSystem(preserveAspectRatio=false,extent={{-100,-100},
                  {100,100}}),       graphics={Rectangle(
                extent={{-100,40},{100,-40}},
                lineColor={0,0,255},
                fillPattern=FillPattern.Solid,
                fillColor={255,255,255}), Text(
                extent={{-90,-40},{100,40}},
                lineColor={0,0,255},
                fillColor={255,255,255},
                fillPattern=FillPattern.Solid,
                textString="%name")}));
      end Outtake;

      model GILumenInternal
        extends Physiolibrary.SteadyStates.Interfaces.SteadyState(state_start=mass_start);
        extends Physiolibrary.Icons.GILumen;

        Physiolibrary.Types.RealIO.AmountOfSubstanceInput
                                             GILumenSodium
        "sodium in gastro intestinal lumen"                                                                  annotation (Placement(transformation(extent={{120,20},
                  {80,60}}),
                         iconTransformation(extent={{-100,70},{-80,90}})));
        Physiolibrary.Types.RealIO.AmountOfSubstanceInput
                                             GILumenPotassium
        "potasium in gastro intestinal lumen"                     annotation (Placement(transformation(
                extent={{120,60},{80,100}}),iconTransformation(extent={{-100,10},{-80,
                  30}})));

      Physiolibrary.Osmotic.Interfaces.OsmoticPort_b absorbtion annotation (
          Placement(transformation(extent={{60,-20},{100,20}}),
            iconTransformation(extent={{90,-10},{110,10}})));

      /*Physiolibrary.Hydraulic.Interfaces.HydraulicPort_a env annotation (
    Placement(transformation(extent={{-120,-60},{-80,-20}}),
    iconTransformation(extent={{-120,-60},{-80,-20}})));
    */
      //parameter Physiolibrary.Types.Osmolarity Fiber_mass = 0.043;
      //parameter Real Na_EqToAllConnectedOsm(final displayUnit="mOsm/mEq") = 2;
      //parameter Real K_EqToAllConnectedOsm(final displayUnit="mOsm/mEq") = 2;
      //parameter Real initialVolume(final quantity="Volume", final displayUnit="ml") = initialValue;
      parameter Physiolibrary.Types.Volume mass_start= 0.000949201;
      Physiolibrary.Types.Volume mass(start= mass_start)
        "water volume in gastro intestinal lumen";
      Physiolibrary.Types.Osmolarity OsmNa;
      Physiolibrary.Types.Osmolarity OsmK;
      //Physiolibrary.Types.Osmolarity Fiber;

        Physiolibrary.Types.RealIO.VolumeOutput
                                              Vol
                                           annotation (Placement(transformation(
                extent={{82,60},{122,100}}), iconTransformation(extent={{82,60},{122,100}})));
        Physiolibrary.Types.RealIO.OsmolarityInput Fiber
        "dietary fiber in gastro intestinal lumen"   annotation (Placement(
              transformation(extent={{120,60},{80,100}}), iconTransformation(extent={{
                  -100,-50},{-80,-30}})));
      initial equation
        //mass = 949.201;
      equation
      //   der(mass) = (intake.q + absorbtion.q + outtake.q)/Library.SecPerMin;

       //  env.pressure = Vol; //used in diarrea or vomitus calculation
      //   OsmNa=Na_EqToAllConnectedOsm*GILumenSodium_Mass/mass;
      //   OsmK = K_EqToAllConnectedOsm*GILumenPotassium_Mass/mass;
         OsmNa=2*GILumenSodium/mass;
         OsmK =2*GILumenPotassium/mass;

      //   Fiber =Fiber_mass; ///mass;
         absorbtion.o = (Fiber + OsmNa + OsmK);

         Vol = mass;

      state = mass;
         change = (            absorbtion.q)/60;
                   /*env.q + */
          annotation (
      Documentation(info="<HTML>
<PRE>
QHP 2008 / GILumenH2O.REF



Volume ========================================

Typical lumen volume is 1000 mL on an intake of 1.4 mL/Min.
This number is based on lumen volume being 1.4% body weight
from

   JCI 36:289-296, 1957.

Data suggests a 1L oral load is nearly all absorbed in
1 Hr.  Average rate would be 17 mL/Hr with a peak rate
of about 30.

   Baldes & Smirk. J.Physiol. 82:62,1934.

Osmolar gradient is assumed to be 0.200 mOsm/mL.

   Rate = Perm * Grad
   30 = Perm * 0.200
   Perm = 150

Temperature ===================================

Typical lumen heat content is 155 kCal.

Specific heat (SH) of H2O is 0.001 (kCal/G)/DegK.

To get temperature from heat

   DegK = 1000.0 * kCal/G (or mL)
   DegC = DegK - 273.15
   DegF = ( 9 / 5 ) * DegC + 32

To get heat from temperature

   kCal = 0.001 * DegK * mL
   kCal/Min = 0.001 * DegK * mL/Min
</PRE>
</HTML>
",     revisions="<html>
<ul>
<li><i>  </i>
       </li>
<li><i> january 2009 </i><br>
       by Marek Matejak in Modelica initially implemented (consulted with Jiri Kofranek), Charles University, Prague<br>
       orginaly described by Tom Coleman in QHP 2008 beta 3, University of Mississippi Medical Center
       </li>
</ul>
</html>"), Icon(coordinateSystem(
                preserveAspectRatio=false,extent={{-100,-100},{100,100}}),
              graphics={
              Text(
                extent={{-100,-10},{100,-26}},
                lineColor={0,0,255},
                textString="(initial %initialVolume ml)"),
              Rectangle(extent={{-100,100},{100,-100}}, lineColor={0,0,0}),
              Text(
                extent={{-100,120},{100,104}},
                lineColor={0,0,255},
                textString="%name")}));
      end GILumenInternal;

      model GI_Absorption
        import QHP = Physiomodel;
      extends Physiolibrary.Icons.GILumen;

      Physiolibrary.Osmotic.Interfaces.OsmoticPort_b vascularH2O
        "plasma osmolarity on cell membranes"
                      annotation (Placement(transformation(extent={{80,44},{100,
                64}}), iconTransformation(extent={{90,-10},{110,10}})));
      parameter Physiolibrary.Types.Osmolarity Fiber = 0.043;
      //parameter Real Na_EqToAllConnectedOsm(final displayUnit="mOsm/mEq") = 2;
      //parameter Real K_EqToAllConnectedOsm(final displayUnit="mOsm/mEq") = 2;
      //parameter Real initialVolume(final quantity="Volume", final displayUnit="ml") =  1000;

      //    Na_EqToAllConnectedOsm=Na_EqToAllConnectedOsm,
      //    K_EqToAllConnectedOsm=K_EqToAllConnectedOsm,
        Outtake vomitus
          annotation (Placement(transformation(extent={{-7,-7},{7,7}},
              rotation=180,
              origin={-34,79})));
        Outtake diarrhea
          annotation (Placement(transformation(extent={{-27,60},{-41,74}})));
      Physiolibrary.Osmotic.Components.Membrane absorption(cond=0.15e-6/(8.314*310.15)
              /60) annotation (Placement(transformation(
              extent={{-8,-8},{8,8}},
              origin={18,22})));
      Physiolibrary.Osmotic.Sources.SolventInflux   Diet(useSolutionFlowInput=
            true)
        annotation (Placement(transformation(extent={{-59,-52},{-49,-42}})));
      Physiolibrary.Osmotic.Sensors.FlowMeasure flowMeasure annotation (
          Placement(transformation(
            extent={{-7,-6},{7,6}},
            rotation=90,
            origin={42,33})));
      Physiolibrary.Blocks.Factors.Spline DietThirst(data={{233,0.0,0},{253,1.0,0.1},{
              313,15.0,0}})
        annotation (Placement(transformation(extent={{-64,-32},{-44,-12}})));
      Physiolibrary.Types.Constants.VolumeFlowRateConst Normal(k(displayUnit="ml/day")=
               2.3148148148148e-08)
          annotation (Placement(transformation(extent={{-68,-14},{-60,-6}})));
      Physiolibrary.Types.BusConnector busConnector annotation (Placement(
            transformation(extent={{-98,80},{-78,100}}), iconTransformation(
              extent={{-106,-10},{-86,10}})));
      Physiolibrary.Osmotic.Sensors.FlowMeasure   flowMeasure1 annotation (
          Placement(transformation(
            extent={{-7,7},{7,-7}},
            rotation=90,
            origin={-31,-1})));
        Physiolibrary.Osmotic.Components.OsmoticCell GILumen(
            useImpermeableSolutesInput=true, volume_start=0.0009492)
          annotation (Placement(transformation(extent={{-34,12},{-14,32}})));
        Modelica.Blocks.Math.Add3 osmoles(
          k1=2,
          k2=2,
          k3=1) annotation (Placement(transformation(extent={{-48,22},{-36,34}})));
      equation

        connect(absorption.q_out, flowMeasure.q_in) annotation (Line(
            points={{26,22},{42,22},{42,26}},
            color={127,127,0},
            thickness=1,
            smooth=Smooth.None));
        connect(Normal.y, DietThirst.yBase) annotation (Line(
            points={{-59,-10},{-54,-10},{-54,-20}},
            color={0,0,127},
            smooth=Smooth.None));

      connect(flowMeasure.volumeFlowRate, busConnector.GILumenVolume_Absorption)
        annotation (Line(
          points={{46.8,33},{98,33},{98,90},{-88,90}},
          color={0,0,127},
          smooth=Smooth.None), Text(
          string="%second",
          index=1,
          extent={{6,3},{6,3}}));
        connect(busConnector.GILumenDiarrhea_H2OLoss, diarrhea.outflow)
          annotation (Line(
            points={{-88,90},{-88,64.2},{-41,64.2}},
            color={0,0,255},
            thickness=0.5,
            smooth=Smooth.None), Text(
            string="%first",
            index=-1,
            extent={{-6,3},{-6,3}}));
        connect(busConnector.GILumenVomitus_H2OLoss, vomitus.outflow)
          annotation (Line(
            points={{-88,90},{-88,81.8},{-41,81.8}},
            color={0,0,255},
            thickness=0.5,
            smooth=Smooth.None), Text(
            string="%first",
            index=-1,
            extent={{-6,3},{-6,3}}));
      connect(busConnector.GILumenVolume_Intake, flowMeasure1.volumeFlowRate)
        annotation (Line(
          points={{-88,90},{-88,-1},{-36.6,-1}},
          color={0,0,255},
          thickness=0.5,
          smooth=Smooth.None), Text(
          string="%first",
          index=-1,
          extent={{-6,3},{-6,3}}));
        connect(busConnector.GILumenVomitus_H2OTarget, vomitus.H2OTarget)
          annotation (Line(
            points={{-88,90},{-88,76},{-34,76},{-34,76.2}},
            color={0,0,255},
            thickness=0.5,
            smooth=Smooth.None), Text(
            string="%first",
            index=-1,
            extent={{-6,3},{-6,3}}));
        connect(busConnector.GILumenDiarrhea_H2OTarget, diarrhea.H2OTarget)
          annotation (Line(
            points={{-88,90},{-88,69.8},{-34,69.8}},
            color={0,0,255},
            thickness=0.5,
            smooth=Smooth.None), Text(
            string="%first",
            index=-1,
            extent={{-6,3},{-6,3}}));
        connect(busConnector.Osmreceptors, DietThirst.u) annotation (Line(
            points={{-88,90},{-88,-22},{-62,-22}},
            color={0,0,255},
            thickness=0.5,
            smooth=Smooth.None), Text(
            string="%first",
            index=-1,
            extent={{-6,3},{-6,3}}));
        connect(diarrhea.H2OLoss, vomitus.H2OLoss) annotation (Line(
            points={{-27,67},{-24,67},{-24,79},{-27,79}},
            color={127,127,0},
            thickness=1,
            smooth=Smooth.None));
        connect(Diet.q_out, flowMeasure1.q_in) annotation (Line(
            points={{-51,-47},{-31,-47},{-31,-8}},
            color={127,127,0},
            thickness=1,
            smooth=Smooth.None));
        connect(busConnector.GILumenSodium_Mass, osmoles.u1) annotation (Line(
            points={{-88,90},{-88,32.8},{-49.2,32.8}},
            color={0,0,255},
            thickness=0.5,
            smooth=Smooth.None), Text(
            string="%first",
            index=-1,
            extent={{-6,3},{-6,3}}));
        connect(busConnector.GILumenPotassium_Mass, osmoles.u2) annotation (Line(
            points={{-88,90},{-88,28},{-49.2,28}},
            color={0,0,255},
            thickness=0.5,
            smooth=Smooth.None), Text(
            string="%first",
            index=-1,
            extent={{-6,3},{-6,3}}));
        connect(busConnector.GILumenFiber_Mass, osmoles.u3) annotation (Line(
            points={{-88,90},{-88,23.2},{-49.2,23.2}},
            color={0,0,255},
            thickness=0.5,
            smooth=Smooth.None), Text(
            string="%first",
            index=-1,
            extent={{-6,3},{-6,3}}));
        connect(GILumen.volume, busConnector.GILumenVolume_Mass) annotation (Line(
            points={{-18,12},{-10,12},{-10,90},{-88,90}},
            color={0,0,127},
            smooth=Smooth.None), Text(
            string="%second",
            index=1,
            extent={{6,3},{6,3}}));
        connect(GILumen.volume, vomitus.H2OVolume) annotation (Line(
            points={{-18,12},{-10,12},{-10,76.2},{-29.8,76.2}},
            color={0,0,127},
            smooth=Smooth.None));
        connect(GILumen.volume, diarrhea.H2OVolume) annotation (Line(
            points={{-18,12},{-10,12},{-10,69.8},{-29.8,69.8}},
            color={0,0,127},
            smooth=Smooth.None));
        connect(diarrhea.H2OLoss, GILumen.q_in[1]) annotation (Line(
            points={{-27,67},{-24,67},{-24,22}},
            color={127,127,0},
            thickness=1,
            smooth=Smooth.None));
        connect(osmoles.y, GILumen.impermeableSolutes[1]) annotation (Line(
            points={{-35.4,28},{-32,28}},
            color={0,0,127},
            smooth=Smooth.None));
        connect(GILumen.q_in[1], flowMeasure1.q_out) annotation (Line(
            points={{-24,22},{-32,22},{-32,6},{-31,6}},
            color={127,127,0},
            thickness=1,
            smooth=Smooth.None));
        connect(GILumen.q_in[1], absorption.q_in) annotation (Line(
            points={{-24,22},{10,22}},
            color={127,127,0},
            thickness=1,
            smooth=Smooth.None));
        connect(DietThirst.y, Diet.solutionFlow) annotation (Line(
            points={{-54,-26},{-54,-43.5}},
            color={0,0,127},
            smooth=Smooth.None));
        connect(vascularH2O, flowMeasure.q_out) annotation (Line(
            points={{90,54},{42,54},{42,40}},
            color={127,127,0},
            thickness=1,
            smooth=Smooth.None));
          annotation (
      Documentation(info="<HTML>
<PRE>
QHP 2008 / GILumenH2O.REF



Volume ========================================

Typical lumen volume is 1000 mL on an intake of 1.4 mL/Min.
This number is based on lumen volume being 1.4% body weight
from

   JCI 36:289-296, 1957.

Data suggests a 1L oral load is nearly all absorbed in
1 Hr.  Average rate would be 17 mL/Hr with a peak rate
of about 30.

   Baldes & Smirk. J.Physiol. 82:62,1934.

Osmolar gradient is assumed to be 0.200 mOsm/mL.

   Rate = Perm * Grad
   30 = Perm * 0.200
   Perm = 150

Temperature ===================================

Typical lumen heat content is 155 kCal.

Specific heat (SH) of H2O is 0.001 (kCal/G)/DegK.

To get temperature from heat

   DegK = 1000.0 * kCal/G (or mL)
   DegC = DegK - 273.15
   DegF = ( 9 / 5 ) * DegC + 32

To get heat from temperature

   kCal = 0.001 * DegK * mL
   kCal/Min = 0.001 * DegK * mL/Min
</PRE>
</HTML>
",     revisions="<html>
<ul>
<li><i>  </i>
       </li>
<li><i> january 2009 </i><br>
       by Marek Matejak in Modelica initially implemented (consulted with Jiri Kofranek), Charles University, Prague<br>
       orginaly described by Tom Coleman in QHP 2008 beta 3, University of Mississippi Medical Center
       </li>
</ul>
</html>"), Icon(coordinateSystem(
                preserveAspectRatio=true, extent={{-100,-100},{100,100}}),
              graphics={Text(
                extent={{-102,124},{98,108}},
                lineColor={0,0,255},
                textString="%name")}));
      end GI_Absorption;

      model LungEdema
      extends Physiolibrary.Icons.Lungs;

       parameter Real initialVolume(displayUnit="ml") = 0;

      Physiolibrary.Osmotic.Interfaces.OsmoticPort_a q_in(o(final displayUnit=
              "g/ml")) annotation (Placement(transformation(extent={{-110,10},{
                -90,30}}), iconTransformation(extent={{-10,30},{10,50}})));
      Physiolibrary.Blocks.Interpolation.Curve ExcessLungWaterOnLymph(
        x={10,1000},
        y={0,1},
        slope={0,0},
        Xscale=1e-6,
        Yscale=1e-6/60)
        annotation (Placement(transformation(extent={{16,-26},{-4,-6}})));
      Physiolibrary.Types.BusConnector busConnector annotation (Placement(
            transformation(extent={{-104,61},{-84,81}}), iconTransformation(
              extent={{60,60},{80,80}})));

      Physiolibrary.Osmotic.Components.Membrane pulmCapys(
          useHydraulicPressureInputs=true, cond=3.7503078792283e-10)
        annotation (Placement(transformation(extent={{-44,28},{-24,48}})));
      Physiolibrary.Osmotic.Components.SolventFlux PulmLymph(
          useSolutionFlowInput=true) annotation (Placement(transformation(
            extent={{-10,-10},{10,10}},
            rotation=180,
            origin={-42,-2})));
      Physiolibrary.Osmotic.Components.OsmoticCell waterInLungs(volume_start=
            1e-09)
        annotation (Placement(transformation(extent={{16,20},{36,40}})));
      Physiolibrary.Types.Constants.PressureConst pressure(k=0)
        annotation (Placement(transformation(extent={{-12,58},{-20,66}})));
      equation
      connect(busConnector.PulmCapys_Pressure, pulmCapys.hydraulicPressureIn)
        annotation (Line(
          points={{-94,71},{-42,71},{-42,46}},
          color={0,0,255},
          thickness=0.5,
          smooth=Smooth.None), Text(
          string="%first",
          index=-1,
          extent={{-6,3},{-6,3}}));
      connect(ExcessLungWaterOnLymph.val, PulmLymph.solutionFlow) annotation (
          Line(
          points={{-4,-16},{-42,-16},{-42,-9}},
          color={0,0,127},
          smooth=Smooth.None));
      connect(pulmCapys.q_out, waterInLungs.q_in[1]) annotation (Line(
          points={{-24,38},{2,38},{2,30},{26,30}},
          color={127,127,0},
          thickness=1,
          smooth=Smooth.None));
      connect(waterInLungs.q_in[1], PulmLymph.q_in) annotation (Line(
          points={{26,30},{2,30},{2,-2},{-32,-2}},
          color={127,127,0},
          thickness=1,
          smooth=Smooth.None));
      connect(PulmLymph.q_out, q_in) annotation (Line(
          points={{-52,-2},{-66,-2},{-66,20},{-100,20}},
          color={127,127,0},
          thickness=1,
          smooth=Smooth.None));
      connect(pulmCapys.q_in, q_in) annotation (Line(
          points={{-44,38},{-66,38},{-66,20},{-100,20}},
          color={127,127,0},
          thickness=1,
          smooth=Smooth.None));
      connect(waterInLungs.volume, ExcessLungWaterOnLymph.u) annotation (Line(
          points={{32,20},{32,-16},{16,-16}},
          color={0,0,127},
          smooth=Smooth.None));
      connect(waterInLungs.volume, busConnector.ExcessLungWater_Volume)
        annotation (Line(
          points={{32,20},{32,8},{58,8},{58,71},{-94,71}},
          color={0,0,127},
          smooth=Smooth.None), Text(
          string="%second",
          index=1,
          extent={{6,3},{6,3}}));
      connect(pressure.y, pulmCapys.hydraulicPressureOut) annotation (Line(
          points={{-21,62},{-26,62},{-26,46}},
          color={0,0,127},
          smooth=Smooth.None));
          annotation (
      Documentation(info="<HTML>
<PRE>
Torso water compartment.

</PRE>
</HTML>
",     revisions="<html>
<ul>
<li><i>  </i>
       </li>
<li><i> january 2009 </i><br>
       by Marek Matejak in Modelica initially implemented (consulted with Jiri Kofranek), Charles University, Prague<br>
       orginaly described by Tom Coleman in QHP 2008 beta 3, University of Mississippi Medical Center
       </li>
</ul>
</html>"), Icon(coordinateSystem(
                preserveAspectRatio=true, extent={{-100,-100},{100,100}}),
              graphics={                                   Text(
                extent={{-100,88},{100,72}},
                lineColor={0,0,255},
                textString="%name")}));
      end LungEdema;

      model Peritoneum2
      extends Physiolibrary.Icons.Peritoneum;
      Physiolibrary.Osmotic.Interfaces.OsmoticPort_a flux
        "plasma proteins concentration" annotation (Placement(transformation(
              extent={{76,-8},{96,12}}), iconTransformation(extent={{-10,30},{
                10,50}})));

        parameter Physiolibrary.Types.Volume initialVolume = 0
        "initial water in peritoneum";

      Physiomodel.Metabolism.deprecated.HydraulicPressure colloidhydraulicPressure0_1
        annotation (Placement(transformation(extent={{68,34},{60,42}})));
      Physiomodel.Metabolism.deprecated.HydraulicPressure colloidhydraulicPressure0_2
        annotation (Placement(transformation(extent={{64,-6},{56,2}})));
      Physiolibrary.Types.Constants.PressureConst ExternalPressure(k=
            1199.901486735)
        annotation (Placement(transformation(extent={{-72,60},{-64,68}})));
        Physiolibrary.Hydraulic.Components.ElasticVessel
          vascularElasticBloodCompartment(volume_start=initialVolume, stateName=
              "PeritoneumSpace.Volume",
          useV0Input=true,
          useComplianceInput=true,
          useExternalPressureInput=true)
          annotation (Placement(transformation(extent={{-70,14},{-50,34}})));
      Physiolibrary.Types.Constants.VolumeConst PeritoneumSpace_V0(k=0)
        "PeritoneumSpace.V0"
        annotation (Placement(transformation(extent={{-78,36},{-70,44}})));
      Physiolibrary.Types.Constants.HydraulicComplianceConst complianceConstant(
          k=5.700467976427015e-006)
        annotation (Placement(transformation(extent={{-74,48},{-66,56}})));

      Physiolibrary.Types.BusConnector busConnector annotation (Placement(
            transformation(extent={{-84,71},{-64,91}}), iconTransformation(
              extent={{60,60},{80,80}})));

        Physiolibrary.Hydraulic.Components.IdealValve idealValve
          annotation (Placement(transformation(extent={{30,-8},{50,12}})));
        Physiolibrary.Hydraulic.Components.Conductor lymph(Conductance=1.8751539396141e-10)
          annotation (Placement(transformation(extent={{-32,-8},{-12,12}})));
        Physiolibrary.Hydraulic.Sensors.FlowMeasure flowMeasure
          annotation (Placement(transformation(extent={{2,-8},{22,12}})));
        Physiolibrary.Hydraulic.Components.Conductor splanchnic(Conductance=1.8751539396141e-10)
          annotation (Placement(transformation(extent={{-28,32},{-8,52}})));
        Physiolibrary.Hydraulic.Sensors.FlowMeasure flowMeasure1
          annotation (Placement(transformation(extent={{20,52},{0,32}})));

      Physiolibrary.Osmotic.Sensors.FlowMeasure flowMeasure2
        annotation (Placement(transformation(extent={{82,32},{70,16}})));
      equation
        connect(colloidhydraulicPressure0_2.hydraulicPressure, ExternalPressure.y)
          annotation (Line(
            points={{58.4,2.8},{58.4,20},{-38,20},{-38,64},{-63,64}},
            color={0,0,127},
            smooth=Smooth.None));
        connect(busConnector.SplanchnicVeins_Pressure,
          colloidhydraulicPressure0_1.hydraulicPressure) annotation (Line(
            points={{-74,81},{62.4,81},{62.4,42.8}},
            color={0,0,255},
            thickness=0.5,
            smooth=Smooth.None), Text(
            string="%first",
            index=-1,
            extent={{-6,3},{-6,3}}));
        connect(colloidhydraulicPressure0_2.withoutCOP, idealValve.q_out) annotation (
           Line(
            points={{56,2},{50,2}},
            color={0,0,0},
            thickness=1,
            smooth=Smooth.None));
        connect(lymph.q_out, flowMeasure.q_in) annotation (Line(
            points={{-12,2},{2,2}},
            color={0,0,0},
            thickness=1,
            smooth=Smooth.None));
        connect(idealValve.q_in, flowMeasure.q_out) annotation (Line(
            points={{30,2},{22,2}},
            color={0,0,0},
            thickness=1,
            smooth=Smooth.None));
        connect(flowMeasure.volumeFlow, busConnector.PeritoneumSpace_Loss)
          annotation (Line(
            points={{12,14},{12,-16},{94,-16},{94,81},{-74,81}},
            color={0,0,127},
            smooth=Smooth.None));
        connect(flowMeasure1.q_in, colloidhydraulicPressure0_1.withoutCOP)
          annotation (Line(
            points={{20,42},{60,42}},
            color={0,0,0},
            thickness=1,
            smooth=Smooth.None));
        connect(flowMeasure1.q_out, splanchnic.q_out) annotation (Line(
            points={{0,42},{-8,42}},
            color={0,0,0},
            thickness=1,
            smooth=Smooth.None));
        connect(flowMeasure1.volumeFlow, busConnector.PeritoneumSpace_Gain)
          annotation (Line(
            points={{10,30},{10,81},{-74,81}},
            color={0,0,127},
            smooth=Smooth.None));
        connect(PeritoneumSpace_V0.y, vascularElasticBloodCompartment.zeroPressureVolume)
          annotation (Line(
            points={{-69,40},{-68,40},{-68,32}},
            color={0,0,127},
            smooth=Smooth.None));
        connect(ExternalPressure.y, vascularElasticBloodCompartment.externalPressure)
          annotation (Line(
            points={{-63,64},{-52,64},{-52,32}},
            color={0,0,127},
            smooth=Smooth.None));
        connect(complianceConstant.y, vascularElasticBloodCompartment.compliance)
          annotation (Line(
            points={{-65,52},{-60,52},{-60,32}},
            color={0,0,127},
            smooth=Smooth.None));
        connect(busConnector.PeritoneumSpace_Vol,
          vascularElasticBloodCompartment.volume) annotation (Line(
            points={{-74,81},{-96,81},{-96,14},{-54,14}},
            color={0,0,255},
            thickness=0.5,
            smooth=Smooth.None), Text(
            string="%first",
            index=-1,
            extent={{-6,3},{-6,3}}));
        connect(vascularElasticBloodCompartment.q_in, splanchnic.q_in)
          annotation (Line(
            points={{-60,24},{-36,24},{-36,42},{-28,42}},
            color={0,0,0},
            thickness=1,
            smooth=Smooth.None));
        connect(vascularElasticBloodCompartment.q_in, lymph.q_in)
          annotation (Line(
            points={{-60,24},{-46,24},{-46,2},{-32,2}},
            color={0,0,0},
            thickness=1,
            smooth=Smooth.None));
      connect(flux, flowMeasure2.q_in) annotation (Line(
          points={{86,2},{86,24},{82,24}},
          color={127,127,0},
          thickness=1,
          smooth=Smooth.None));
      connect(colloidhydraulicPressure0_1.q_in, flowMeasure2.q_out) annotation (
         Line(
          points={{68,38},{70,38},{70,24}},
          color={127,127,0},
          thickness=1,
          smooth=Smooth.None));
      connect(colloidhydraulicPressure0_2.q_in, flowMeasure2.q_out) annotation (
         Line(
          points={{64,-2},{70,-2},{70,24}},
          color={127,127,0},
          thickness=1,
          smooth=Smooth.None));
      connect(flowMeasure2.volumeFlowRate, busConnector.PeritoneumSpace_Change)
        annotation (Line(
          points={{76,30.4},{76,81},{-74,81}},
          color={0,0,127},
          smooth=Smooth.None));
        annotation (
      Documentation(info="<HTML>
<PRE>
QHP 2008 / Peritoneum
</PRE>
</HTML>
",     revisions="<html>
<ul>
<li><i>  </i>
       </li>
<li><i> january 2009 </i><br>
       by Marek Matejak in Modelica initially implemented (consulted with Jiri Kofranek), Charles University, Prague<br>
       orginaly described by Tom Coleman in QHP 2008 beta 3, University of Mississippi Medical Center
       </li>
</ul>
</html>"),       Icon(coordinateSystem(preserveAspectRatio=true, extent={{-100,
                  -100},{100,100}}), graphics={Text(
                extent={{-100,120},{100,104}},
                lineColor={0,0,255},
                textString="%name")}));
      end Peritoneum2;

      model Torso
        import Physiomodel;
          extends Physiolibrary.Icons.Torso;

      //    parameter Real interstitiumProteins = 2.6;

          parameter Physiolibrary.Types.Volume InterstitialWater_start
        "2270,5670,3400 ml";
          parameter Physiolibrary.Types.Volume IntracellularWater_start
        "4980,12460,7470 ml";

          parameter Physiolibrary.Types.VolumeFlowRate NormalLymphFlow
        "0.4,0.8,1.3 ml/min";

          parameter Physiolibrary.Types.OsmoticPermeability CapillaryConductance
        "Capillary wall permeability for water. 0.6, 3.6, 1.3 ml/(kPa.min)";

          parameter Real[ :,3] InterstitialPressureVolumeData
        "{{600.0,-30.0,0.01},{2000.0,-4.8,0.0004},{5000.0,0.0,0.0004},{12000.0,50.0,0.01}}, {{1200.0,-30.0,0.01},{4800.0,-4.8,0.0004},{12000.0,0.0,0.0004},{24000.0,50.0,0.01}}, {{600.0,-30.0,0.02},{3000.0,-4.8,0.0004},{4000.0,-4.0,0.0004},{6000.0,50.0,0.03}}";
          parameter Physiolibrary.Types.Fraction ICFVFract
        "0.94. Ratio between non-RBC-ICFV and total ICFV, because red cells are not part of any torso ICF!";
          parameter Physiolibrary.Types.Fraction SizeFract "0.2,0.5,0.3";
          parameter Physiolibrary.Types.Fraction CalsFract "0.3,0.5,0.2";
          parameter Physiolibrary.Types.Fraction SweatFract "0.33,0.34,0.33";
          parameter Physiolibrary.Types.Fraction SkinFract "0.33,0.34,0.33";
          parameter Physiolibrary.Types.Fraction LungFract "0,1,0";

      Physiolibrary.Types.TorsoBusConnector torsoSpecific annotation (Placement(
            transformation(extent={{62,27},{80,44}}), iconTransformation(extent=
               {{30,10},{50,30}})));
      Physiolibrary.Osmotic.Interfaces.OsmoticPort_a vascularH2O
        "plasma capillary wall osmotic connector"
        annotation (Placement(transformation(extent={{-92,-42},{-72,-22}}),
            iconTransformation(extent={{-70,-10},{-50,10}})));
        Modelica.Blocks.Math.Gain calsFract(k=CalsFract) annotation (Placement(
              transformation(
              extent={{-6,-6},{6,6}},
              origin={48,-82})));

      //  Physiolibrary.Types.Volume volume;
      //  Physiolibrary.Types.VolumeFlowRate change;
      Physiolibrary.Osmotic.Sources.SolventInflux metabolicH2O(useSolutionFlowInput=true)
          annotation (Placement(transformation(extent={{68,-98},{88,-78}})));
      Physiolibrary.Osmotic.Sensors.FlowMeasure flowMeasure1 annotation (
          Placement(transformation(
            extent={{5,4},{-5,-4}},
            rotation=270,
            origin={24,45})));
      Physiolibrary.Osmotic.Sensors.FlowMeasure flowMeasure2 annotation (
          Placement(transformation(
            extent={{5,6},{-5,-6}},
            rotation=270,
            origin={8,25})));
        Physiolibrary.Osmotic.Components.Membrane capyMembrane(
          useHydraulicPressureInputs=true,
          useTemperatureInputs=false,
          cond=CapillaryConductance)
          annotation (Placement(transformation(extent={{-60,-24},{-40,-4}})));
      Physiolibrary.Osmotic.Components.SolventFlux lymph(useSolutionFlowInput=
            true) annotation (Placement(transformation(
            extent={{-10,10},{10,-10}},
            rotation=180,
            origin={-58,-70})));
      Physiolibrary.Blocks.Factors.Spline InterstitialPressureEffect(
          data={{-14.0,0.0,0.0},{-4.0,1.0,0.1},{2.0,8.0,4.0},{6.0,25.0,0.0}},
          Xscale=101325/760,
          y(unit="m3/s"))
        annotation (Placement(transformation(extent={{-48,-68},{-68,-48}})));
      Physiolibrary.Types.Constants.VolumeFlowRateConst flowConstant(k=
              NormalLymphFlow)
        annotation (Placement(transformation(extent={{-68,-50},{-60,-42}})));
        Physiolibrary.Osmotic.Components.OsmoticCell Interstitium(
            useImpermeableSolutesInput=true, volume_start=InterstitialWater_start,
          NumberOfMembraneTypes=2)
        "Iterstitium has two type of membranes: capillary membrane (index 1) and cell membrane (index 2)"
          annotation (Placement(transformation(extent={{18,-10},{-2,10}})));
        Physiolibrary.Blocks.Interpolation.Curve pressureOnVolume(
          Xscale=1e-6,
          Yscale=101325/760,
        data=InterstitialPressureVolumeData)
          annotation (Placement(transformation(extent={{4,-50},{-16,-30}})));
      Physiolibrary.Osmotic.Sources.SolventOutflux sweat(useSolutionFlowInput=
            true)
        annotation (Placement(transformation(extent={{10,10},{-10,-10}},
            rotation=270,
            origin={24,64})));
      Physiolibrary.Types.Constants.VolumeFlowRateConst Vapor(k=
            6.1666666666667e-09)
          annotation (Placement(transformation(extent={{-24,40},{-16,48}})));
      Physiolibrary.Osmotic.Sources.SolventOutflux insensibleSkinVapor(
            useSolutionFlowInput=true) annotation (Placement(transformation(
              extent={{10,10},{-10,-10}},
              rotation=270,
              origin={8,44})));
        Physiolibrary.Osmotic.Components.OsmoticCell ICF(useImpermeableSolutesInput=true,
            volume_start=IntracellularWater_start)
          annotation (Placement(transformation(extent={{94,-66},{74,-46}})));
        Physiolibrary.Osmotic.Components.Membrane cellMembrane(
          useTemperatureInputs=false,
          useHydraulicPressureInputs=false,
        cond(displayUnit="l/(kPa.min)") = 1.6666666666667e-08)
          annotation (Placement(transformation(extent={{62,-46},{82,-26}})));
      Physiolibrary.Types.BusConnector busConnector annotation (Placement(
            transformation(extent={{30,70},{50,90}}), iconTransformation(extent=
               {{30,70},{50,90}})));
        Modelica.Blocks.Math.Gain sizeFract(k=SizeFract*ICFVFract)
                                                         annotation (Placement(
              transformation(
              extent={{6,-6},{-6,6}},
              rotation=180,
              origin={90,72})));
      Modelica.Blocks.Math.Gain lungFract(k=LungFract)
        annotation (Placement(transformation(extent={{-24,22},{-16,30}})));
      Physiolibrary.Osmotic.Sources.SolventOutflux insensibleLungVapor(
          useSolutionFlowInput=true) annotation (Placement(transformation(
            extent={{-10,-10},{10,10}},
            rotation=90,
            origin={-6,26})));
      Modelica.Blocks.Math.Gain skinFract(k=SkinFract) annotation (Placement(
            transformation(
            extent={{-4,-4},{4,4}},
            origin={-6,44})));
      Modelica.Blocks.Math.Gain sweatFract(k=SweatFract) annotation (Placement(
            transformation(
            extent={{-4,-4},{4,4}},
            origin={10,64})));

        Physiolibrary.Types.VolumeFlowRate fromCapillaries, toLymph, evaporation, fromMetabolism;
      equation
        fromCapillaries = capyMembrane.q_in.q;
        toLymph = lymph.q_out.q;
        evaporation = insensibleLungVapor.q_in.q + insensibleSkinVapor.q_in.q + sweat.q_in.q;
        fromMetabolism = metabolicH2O.q_out.q;

        connect(calsFract.y, metabolicH2O.solutionFlow) annotation (Line(
            points={{54.6,-82},{78,-82},{78,-81}},
            color={0,0,127},
            smooth=Smooth.None));
      //  volume = extravascularH2O.WaterVolume;
      //  change = extravascularH2O.q_out.q;

        connect(vascularH2O, capyMembrane.q_in) annotation (Line(
            points={{-82,-32},{-82,-14},{-60,-14}},
            color={127,127,0},
            thickness=1,
            smooth=Smooth.None));
        connect(InterstitialPressureEffect.y, lymph.solutionFlow) annotation (Line(
            points={{-58,-62},{-58,-63}},
            color={0,0,127},
            smooth=Smooth.None));
        connect(flowConstant.y,InterstitialPressureEffect. yBase) annotation (
            Line(
            points={{-59,-46},{-58,-46},{-58,-56}},
            color={0,0,127},
            smooth=Smooth.None));
        connect(vascularH2O, lymph.q_out) annotation (Line(
            points={{-82,-32},{-82,-70},{-68,-70}},
            color={127,127,0},
            thickness=1,
            smooth=Smooth.None));
        connect(flowMeasure2.q_in, Interstitium.q_in[1]) annotation (Line(
            points={{8,20},{8,-0.5}},
            color={127,127,0},
            thickness=1,
            smooth=Smooth.None));
        connect(pressureOnVolume.u, Interstitium.volume) annotation (Line(
            points={{4,-40},{2,-40},{2,-10}},
            color={0,0,127},
            smooth=Smooth.None));
        connect(pressureOnVolume.val, capyMembrane.hydraulicPressureOut) annotation (
            Line(
            points={{-16,-40},{-20,-40},{-20,-6},{-42,-6}},
            color={0,0,127},
            smooth=Smooth.None));
        connect(pressureOnVolume.val, InterstitialPressureEffect.u) annotation (Line(
            points={{-16,-40},{-20,-40},{-20,-58},{-50,-58}},
            color={0,0,127},
            smooth=Smooth.None));
        connect(sweat.q_in, flowMeasure1.q_out) annotation (Line(
            points={{24,58},{24,50}},
            color={127,127,0},
            thickness=1,
            smooth=Smooth.None));
        connect(insensibleSkinVapor.q_in, flowMeasure2.q_out) annotation (Line(
            points={{8,38},{8,30}},
            color={127,127,0},
            thickness=1,
            smooth=Smooth.None));
        connect(ICF.q_in[1], cellMembrane.q_out) annotation (Line(
            points={{84,-56},{86,-56},{86,-36},{82,-36}},
            color={127,127,0},
            thickness=1,
            smooth=Smooth.None));
        connect(metabolicH2O.q_out, ICF.q_in[1]) annotation (Line(
            points={{84,-88},{96,-88},{96,-56},{84,-56}},
            color={127,127,0},
            thickness=1,
            smooth=Smooth.None));
      connect(flowMeasure1.volumeFlowRate, torsoSpecific.Sweat_H2OOutflow)
        annotation (Line(
          points={{27.2,45},{54,45},{54,35.5},{71,35.5}},
          color={215,215,215},
          smooth=Smooth.None), Text(
          string="%second",
          index=1,
          extent={{6,3},{6,3}}));
      connect(flowMeasure2.volumeFlowRate, torsoSpecific.InsensibleSkin_H2O)
        annotation (Line(
          points={{12.8,25},{54,25},{54,35.5},{71,35.5}},
          color={215,215,215},
          smooth=Smooth.None), Text(
          string="%second",
          index=1,
          extent={{6,3},{6,3}}));
        connect(Interstitium.volume, torsoSpecific.InterstitialWater_Vol) annotation (
           Line(
            points={{2,-10},{54,-10},{54,35.5},{71,35.5}},
            color={215,215,215},
            smooth=Smooth.None), Text(
            string="%second",
            index=1,
            extent={{6,3},{6,3}}));
        connect(Interstitium.impermeableSolutes[1], torsoSpecific.InterstitialProtein_Mass)
          annotation (Line(
            points={{16,5},{54,5},{54,35.5},{71,35.5}},
            color={0,0,127},
            smooth=Smooth.None), Text(
            string="%second",
            index=1,
            extent={{6,3},{6,3}}));
        connect(InterstitialPressureEffect.y, torsoSpecific.LymphFlow) annotation (
           Line(
            points={{-58,-62},{52,-62},{52,35.5},{71,35.5}},
            color={215,215,215},
            smooth=Smooth.None), Text(
            string="%second",
            index=1,
            extent={{6,3},{6,3}}));
        connect(ICF.impermeableSolutes[1], sizeFract.y) annotation (Line(
            points={{92,-50},{96,-50},{96,72},{96.6,72}},
            color={0,0,127},
            smooth=Smooth.None));
        connect(busConnector.OsmBody_ICFVActiveOsmoles, sizeFract.u) annotation (Line(
            points={{40,80},{40,72},{82.8,72}},
            color={0,0,127},
            smooth=Smooth.None), Text(
            string="%first",
            index=-1,
            extent={{-6,3},{-6,3}}));
        connect(torsoSpecific.CapillaryRegionalPressure, capyMembrane.hydraulicPressureIn)
          annotation (Line(
            points={{71,35.5},{71,36},{56,36},{56,14},{-98,14},{-98,-6},{-58,-6}},
            color={170,255,255},
            smooth=Smooth.None,
          thickness=0.5),        Text(
            string="%first",
            index=-1,
            extent={{-6,3},{-6,3}}));
      connect(lungFract.y, insensibleLungVapor.solutionFlow) annotation (Line(
          points={{-15.6,26},{-13,26}},
          color={0,0,127},
          smooth=Smooth.None));
        connect(insensibleLungVapor.q_in, Interstitium.q_in[1]) annotation (Line(
            points={{-6,20},{-6,10},{8,10},{8,-0.5}},
            color={127,127,0},
            thickness=1,
            smooth=Smooth.None));
      connect(Vapor.y, skinFract.u) annotation (Line(
          points={{-15,44},{-10.8,44}},
          color={0,0,127},
          smooth=Smooth.None));
      connect(insensibleSkinVapor.solutionFlow, skinFract.y) annotation (Line(
          points={{1,44},{-1.6,44}},
          color={0,0,127},
          smooth=Smooth.None));
      connect(sweat.solutionFlow, sweatFract.y) annotation (Line(
          points={{17,64},{14.4,64}},
          color={0,0,127},
          smooth=Smooth.None));
      connect(busConnector.SweatDuct_H2OOutflow, sweatFract.u) annotation (Line(
          points={{40,80},{-66,80},{-66,64},{5.2,64}},
          color={0,0,255},
          smooth=Smooth.None), Text(
          string="%first",
          index=-1,
          extent={{-6,3},{-6,3}}));
      connect(busConnector.HeatInsensibleLung_H2O, lungFract.u) annotation (
          Line(
          points={{40,80},{-66,80},{-66,26},{-24.8,26}},
          color={0,0,255},
          smooth=Smooth.None), Text(
          string="%first",
          index=-1,
          extent={{-6,3},{-6,3}}));
      connect(torsoSpecific.Cell_H2O, ICF.volume) annotation (Line(
          points={{71,35.5},{54,35.5},{54,-66},{78,-66}},
          color={215,215,215},
          smooth=Smooth.None), Text(
          string="%first",
          index=-1,
          extent={{-6,3},{-6,3}}));
      connect(busConnector.MetabolicH2O_Rate, calsFract.u) annotation (Line(
          points={{40,80},{-100,80},{-100,-82},{40.8,-82}},
          color={0,0,255},
          smooth=Smooth.None), Text(
          string="%first",
          index=-1,
          extent={{-6,3},{-6,3}}));
        connect(Interstitium.impermeableSolutes[2], torsoSpecific.InterstitialOsmoles)
          annotation (Line(
            points={{16,7},{68,7},{68,35.5},{71,35.5}},
            color={0,0,127},
            smooth=Smooth.None));
        connect(Interstitium.q_in[2], cellMembrane.q_in) annotation (Line(
            points={{8,0.5},{36,0.5},{36,-36},{62,-36}},
            color={127,127,0},
            thickness=1,
            smooth=Smooth.None));
      connect(flowMeasure1.q_in, Interstitium.q_in[1]) annotation (Line(
          points={{24,40},{24,10},{8,10},{8,-0.5}},
          color={127,127,0},
          thickness=1,
          smooth=Smooth.None));
      connect(Interstitium.q_in[1], lymph.q_in) annotation (Line(
          points={{8,-0.5},{-18,-0.5},{-18,-70},{-48,-70}},
          color={127,127,0},
          thickness=1,
          smooth=Smooth.None));
      connect(capyMembrane.q_out, Interstitium.q_in[1]) annotation (Line(
          points={{-40,-14},{-18,-14},{-18,-0.5},{8,-0.5}},
          color={127,127,0},
          thickness=1,
          smooth=Smooth.None));
        annotation ( Icon(coordinateSystem(
                preserveAspectRatio=false, extent={{-100,-100},{100,100}}),
              graphics={                 Text(
                extent={{-139,-101},{142,-126}},
                lineColor={0,0,255},
                textString="%name")}), experiment(StopTime=31536000, Tolerance=
              1e-005));
      end Torso;

      model CerebrospinalFluid
          extends Physiolibrary.Icons.Brain;
      Physiolibrary.Osmotic.Components.OsmoticCell CSF_osmotic(volume_start(
            displayUnit="ml") = 0.00015, ImpermeableSolutes={(0.286*0.15)})
        "cerebro-spinal fluid"
        annotation (Placement(transformation(extent={{-78,-16},{-58,4}})));
        Physiolibrary.Osmotic.Components.Membrane
                            choroid_plexus(useHydraulicPressureInputs=true, cond(
              displayUnit="ml/(mmHg.day)") = 1.9966916949595e-12)
        "choroid plexus"
          annotation (Placement(transformation(extent={{-18,-16},{-38,4}})));
        Physiolibrary.Hydraulic.Components.ElasticVessel
                                           CSF_hydraulic(
          volume_start=0.00015,
          ZeroPressureVolume=0.000145,
          Compliance=2.250184727537e-09) "cerebro-spinal fluid"
          annotation (Placement(transformation(extent={{-98,-42},{-78,-22}})));
        Physiolibrary.Hydraulic.Components.Pump
                                  choroid_plexus_hydraulic(useSolutionFlowInput=
              true) annotation (Placement(transformation(
              extent={{-10,10},{10,-10}},
              rotation=180,
              origin={6,-32})));
        Physiolibrary.Osmotic.Sensors.FlowMeasure
                            flowMeasure annotation (Placement(transformation(
              extent={{-10,10},{10,-10}},
              rotation=180,
              origin={6,-6})));
        Physiolibrary.Hydraulic.Sensors.PressureMeasure
                                          pressureMeasure
          annotation (Placement(transformation(extent={{-92,54},{-72,74}})));
        Physiolibrary.Hydraulic.Sources.UnlimitedVolume
                                          veins(P=0) annotation (Placement(
              transformation(
              extent={{-10,-10},{10,10}},
              rotation=180,
              origin={80,76})));
        Physiolibrary.Osmotic.Components.Membrane
                            arachnoid_villi(useHydraulicPressureInputs=true, cond(
              displayUnit="ml/(mmHg.day)") = 1.1285648710641e-11)
        "choroid plexus"
          annotation (Placement(transformation(extent={{-38,36},{-18,56}})));
        Physiolibrary.Hydraulic.Components.Pump
                                  arachnoid_villi_hydraulic(useSolutionFlowInput=
              true)
          annotation (Placement(transformation(extent={{-4,86},{16,66}})));
        Physiolibrary.Osmotic.Sensors.FlowMeasure
                            flowMeasure1
          annotation (Placement(transformation(extent={{-4,56},{16,36}})));
        Physiolibrary.Hydraulic.Sources.UnlimitedVolume choroidPlexusCapy(P=
            3733.02684762) annotation (Placement(transformation(
            extent={{-10,-10},{10,10}},
            rotation=180,
            origin={80,-28})));
        Physiolibrary.Hydraulic.Sensors.PressureMeasure
                                          pressureMeasure1
          annotation (Placement(transformation(extent={{66,54},{46,74}})));
        Physiolibrary.Hydraulic.Sensors.PressureMeasure
                                          pressureMeasure2
          annotation (Placement(transformation(extent={{60,-32},{40,-12}})));
      Physiolibrary.Osmotic.Interfaces.OsmoticPort_a flux
        "plasma proteins concentration" annotation (Placement(transformation(
              extent={{46,14},{66,34}}), iconTransformation(extent={{-10,30},{
                10,50}})));
      Physiolibrary.Osmotic.Components.PermeabilityLevelSwitch
        permeabilityLevelSwitch
        annotation (Placement(transformation(extent={{44,14},{24,34}})));
      Physiolibrary.Types.BusConnector busConnector annotation (Placement(
            transformation(extent={{28,81},{48,101}}), iconTransformation(
              extent={{50,-10},{70,10}})));
      equation

      connect(flowMeasure.volumeFlowRate, choroid_plexus_hydraulic.solutionFlow)
        annotation (Line(
          points={{6,-12},{6,-25}},
          color={0,0,127},
          smooth=Smooth.None));
        connect(CSF_hydraulic.q_in,pressureMeasure. q_in) annotation (Line(
            points={{-88,-32},{-88,58},{-86,58}},
            color={0,0,0},
            thickness=1,
            smooth=Smooth.None));
        connect(CSF_hydraulic.q_in,choroid_plexus_hydraulic. q_out) annotation (
            Line(
            points={{-88,-32},{-4,-32}},
            color={0,0,0},
            thickness=1,
            smooth=Smooth.None));
      connect(CSF_osmotic.q_in[1], arachnoid_villi.q_in) annotation (Line(
          points={{-68,-6},{-68,46},{-38,46}},
          color={127,127,0},
          thickness=1,
          smooth=Smooth.None));
        connect(CSF_hydraulic.q_in,arachnoid_villi_hydraulic. q_in) annotation (
            Line(
            points={{-88,-32},{-88,76},{-4,76}},
            color={0,0,0},
            thickness=1,
            smooth=Smooth.None));
        connect(arachnoid_villi_hydraulic.q_out,veins. y) annotation (Line(
            points={{16,76},{70,76}},
            color={0,0,0},
            thickness=1,
            smooth=Smooth.None));
      connect(pressureMeasure.pressure, arachnoid_villi.hydraulicPressureIn)
        annotation (Line(
          points={{-76,60},{-36,60},{-36,54}},
          color={0,0,127},
          smooth=Smooth.None));
        connect(arachnoid_villi.q_out,flowMeasure1. q_in) annotation (Line(
            points={{-18,46},{-4,46}},
            color={127,127,0},
            thickness=1,
            smooth=Smooth.None));
      connect(flowMeasure1.volumeFlowRate, arachnoid_villi_hydraulic.solutionFlow)
        annotation (Line(
          points={{6,52},{6,69}},
          color={0,0,127},
          smooth=Smooth.None));
        connect(pressureMeasure1.q_in,veins. y) annotation (Line(
            points={{60,58},{64,58},{64,76},{70,76}},
            color={0,0,0},
            thickness=1,
            smooth=Smooth.None));
      connect(pressureMeasure1.pressure, arachnoid_villi.hydraulicPressureOut)
        annotation (Line(
          points={{50,60},{-20,60},{-20,54}},
          color={0,0,127},
          smooth=Smooth.None));
      connect(CSF_osmotic.q_in[1], choroid_plexus.q_out) annotation (Line(
          points={{-68,-6},{-38,-6}},
          color={127,127,0},
          thickness=1,
          smooth=Smooth.None));
        connect(choroid_plexus.q_in,flowMeasure. q_out) annotation (Line(
            points={{-18,-6},{-4,-6}},
            color={127,127,0},
            thickness=1,
            smooth=Smooth.None));
      connect(pressureMeasure.pressure, choroid_plexus.hydraulicPressureOut)
        annotation (Line(
          points={{-76,60},{-44,60},{-44,10},{-36,10},{-36,2}},
          color={0,0,127},
          smooth=Smooth.None));
      connect(pressureMeasure2.pressure, choroid_plexus.hydraulicPressureIn)
        annotation (Line(
          points={{44,-26},{26,-26},{26,10},{-20,10},{-20,2}},
          color={0,0,127},
          smooth=Smooth.None));
      connect(flux, permeabilityLevelSwitch.q_in) annotation (Line(
          points={{56,24},{44,24}},
          color={127,127,0},
          thickness=1,
          smooth=Smooth.None));
      connect(flowMeasure.q_in, permeabilityLevelSwitch.q_out) annotation (Line(
          points={{16,-6},{20,-6},{20,24},{24,24}},
          color={127,127,0},
          thickness=1,
          smooth=Smooth.None));
      connect(permeabilityLevelSwitch.q_out, flowMeasure1.q_out) annotation (
          Line(
          points={{24,24},{20,24},{20,46},{16,46}},
          color={127,127,0},
          thickness=1,
          smooth=Smooth.None));
      connect(permeabilityLevelSwitch.additionalOsmolarity, busConnector.OsmBody_Osm_conc_CellWalls)
        annotation (Line(
          points={{24,34},{24,63},{38,63},{38,91}},
          color={0,0,127},
          smooth=Smooth.None), Text(
          string="%second",
          index=1,
          extent={{6,3},{6,3}}));
      connect(choroidPlexusCapy.y, choroid_plexus_hydraulic.q_in) annotation (
          Line(
          points={{70,-28},{54,-28},{54,-32},{16,-32}},
          color={0,0,0},
          thickness=1,
          smooth=Smooth.None));
      connect(choroidPlexusCapy.y, pressureMeasure2.q_in) annotation (Line(
          points={{70,-28},{54,-28}},
          color={0,0,0},
          thickness=1,
          smooth=Smooth.None));
      annotation (  Icon(graphics={      Text(
                extent={{-145,87},{136,62}},
                lineColor={0,0,255},
                textString="%name")}));
      end CerebrospinalFluid;

      model Bladder
       // extends Library.PressureFlow.VolumeCompartement;
        extends Physiolibrary.Icons.Bladder;
        Physiolibrary.Hydraulic.Components.ElasticVessel   volumeCompartement(
          stateName="BladderVolume.Mass", volume_start=0.0002)
          annotation (Placement(transformation(extent={{-18,0},{2,20}})));
      Physiolibrary.Hydraulic.Interfaces.HydraulicPort_a con annotation (
          Placement(transformation(extent={{-84,18},{-44,58}}),
            iconTransformation(extent={{-120,-20},{-80,20}})));
      Physiolibrary.Hydraulic.Sources.UnlimitedOutflowPump
                                                    bladderVoidFlow(
          useSolutionFlowInput=true)
        annotation (Placement(transformation(extent={{-58,-23},{-73,-8}})));
      Physiolibrary.Types.BusConnector busConnector annotation (Placement(
            transformation(extent={{-100,69},{-80,89}}), iconTransformation(
              extent={{-100,-100},{-80,-80}})));

      //  Real volume;
      //  Real change;
      equation
      //  volume = volumeCompartement.Volume;
      //  change = volumeCompartement.con.q;

      connect(busConnector.BladderVoidFlow, bladderVoidFlow.solutionFlow)
        annotation (Line(
          points={{-90,79},{-90,0},{-65.5,0},{-65.5,-10.25}},
          color={0,0,255},
          thickness=0.5,
          smooth=Smooth.None), Text(
          string="%first",
          index=-1,
          extent={{-6,3},{-6,3}}));
        connect(con, volumeCompartement.q_in) annotation (Line(
            points={{-64,38},{-36,38},{-36,10},{-8,10}},
            color={0,0,0},
            thickness=1,
            smooth=Smooth.None));
        connect(bladderVoidFlow.q_in, volumeCompartement.q_in) annotation (Line(
            points={{-58,-15.5},{-36,-15.5},{-36,10},{-8,10}},
            color={0,0,0},
            thickness=1,
            smooth=Smooth.None));
        connect(volumeCompartement.volume, busConnector.BladderVolume_Mass)
          annotation (Line(
            points={{-2,0},{46,0},{46,80},{-90,80},{-90,79}},
            color={0,0,127},
            smooth=Smooth.None), Text(
            string="%second",
            index=1,
            extent={{6,3},{6,3}}));
        annotation (Icon(coordinateSystem(preserveAspectRatio=true, extent={{-100,
                  -100},{100,100}}), graphics={Text(
                extent={{-100,96},{100,80}},
                lineColor={0,0,255},
                textString="%name")}));
      end Bladder;

      package Kidney "Kidney Water Excretion"
         extends Physiolibrary.Icons.Kidney;

        model DistalTubule

        Physiolibrary.Osmotic.Interfaces.OsmoticPort_a Inflow annotation (
            Placement(transformation(extent={{-120,-20},{-80,20}}),
              iconTransformation(extent={{-120,-20},{-80,20}})));
        Physiolibrary.Osmotic.Interfaces.OsmoticPort_b Outflow
          annotation (Placement(transformation(extent={{80,-20},{120,20}})));
        Physiolibrary.Osmotic.Interfaces.OsmoticPort_b Reabsorbtion
          annotation (Placement(transformation(extent={{-20,-60},{20,-20}}),
              iconTransformation(extent={{-20,-60},{20,-20}})));
          Physiolibrary.Types.RealIO.VolumeFlowRateInput DesiredFlow(displayUnit="ml/min")
                                       annotation (Placement(transformation(extent={{-20,20},{20,
                    60}}), iconTransformation(extent={{-20,-20},{20,20}},
                                                                        rotation=-90,
                origin={60,40})));
        equation
          Outflow.q + Inflow.q + Reabsorbtion.q = 0;
          Inflow.o = Outflow.o;
          Outflow.q = - DesiredFlow;
          annotation (Icon(coordinateSystem(preserveAspectRatio=false,extent={{-100,
                  -100},{100,100}}),   graphics={
                Rectangle(
                  extent={{-100,40},{100,-40}},
                  lineColor={127,127,0},
                  fillColor={255,255,170},
                  fillPattern=FillPattern.HorizontalCylinder),
                Line(
                  points={{-70,14},{-70,-18},{-52,-12},{-36,-14},{-18,-20},{-2,
                      -28},{6,-36},{8,-40},{6,-22},{0,-12},{-8,-6},{-22,2},{-40,
                      8},{-58,12},{-70,14}},
                  color={0,0,255},
                  smooth=Smooth.None),
                Text(
                  extent={{12,-42},{166,-72}},
                  lineColor={0,0,255},
                  textString="%name"),
                Polygon(
                  points={{20,14},{20,-14},{82,-2},{20,14}},
                  lineColor={0,0,255},
                  smooth=Smooth.None,
                  fillColor={0,0,255},
                  fillPattern=FillPattern.Solid)}));
        end DistalTubule;

        model CD_H2OChannels
          extends Physiolibrary.SteadyStates.Interfaces.SteadyState(
                                                        stateName="CD_H2OChannels.Inactive", state_start = 2-initialActive);

        parameter Physiolibrary.Types.Fraction initialActive(final displayUnit="1") = 1;
        parameter Physiolibrary.Types.Volume InactivateKinv(final displayUnit="ml")
          "1/0.000125 ml";
        parameter Physiolibrary.Types.Frequency ReactivateK(final displayUnit="1/min")
          "0.0004 1/min";

        Physiolibrary.Osmotic.Interfaces.OsmoticPort_a     CD_H2O_Reab
          annotation (Placement(transformation(extent={{-20,80},{20,120}}),
              iconTransformation(extent={{-20,80},{20,120}})));

          Physiolibrary.Types.Fraction Inactive( start = 2-initialActive, final displayUnit="1");
          Physiolibrary.Types.RealIO.FractionOutput Active(final displayUnit="1")
                                     annotation (Placement(transformation(extent={{96,46},
                    {136,86}}), iconTransformation(extent={{96,46},{136,86}})));
        Physiolibrary.Osmotic.Interfaces.OsmoticPort_b     q_out annotation (
            Placement(transformation(extent={{-20,-120},{20,-80}}),
              iconTransformation(extent={{-20,-120},{20,-80}})));
        equation
          q_out.q + CD_H2O_Reab.q = 0;
          q_out.o = CD_H2O_Reab.o;

        //  der(Inactive) = ((1/InactivateKinv) * CD_H2O_Reab.q - ReactivateK * Inactive) / Library.SecPerMin;
          Active = 2 - Inactive;

        state = Inactive;
          change = ((1/InactivateKinv) * CD_H2O_Reab.q - ReactivateK * Inactive);
          annotation (Icon(coordinateSystem(preserveAspectRatio=false,extent={{-100,-100},
                    {100,100}}),       graphics={Rectangle(
                  extent={{-100,100},{100,-100}},
                  lineColor={0,0,255},
                  fillColor={170,255,255},
                  fillPattern=FillPattern.Solid),Text(
                  extent={{-100,-22},{100,-38}},
                  lineColor={0,0,255},
                  textString="(initial %initialActive)")}));
        end CD_H2OChannels;

        model Kidney
           extends Physiolibrary.Icons.Kidney;
          import QHP = Physiomodel;
        Physiolibrary.Osmotic.Interfaces.OsmoticPort_b     urine
          "H2O excretion" annotation (Placement(transformation(extent={{78,-82},
                  {100,-62}}),iconTransformation(extent={{-10,-110},{10,-90}})));
        Physiolibrary.Osmotic.Components.Reabsorption   LoopOfHenle
          annotation (Placement(transformation(extent={{-12,-68},{6,-50}})));
          Modelica.Blocks.Math.Gain gain(k=0.37)
            annotation (Placement(transformation(extent={{4,-4},{-4,4}},      rotation=180,
                origin={-24,-64})));
        Physiolibrary.Blocks.Factors.Normalization ADHEffect(yBase(nominal=1e-5),
            y(nominal=1e-7))
          annotation (Placement(transformation(extent={{34,50},{14,70}})));
        Physiolibrary.Osmotic.Components.Reabsorption   CollectingDuct(
            useExternalOutflowMin=true)
          annotation (Placement(transformation(extent={{34,-26},{54,-6}})));
          Modelica.Blocks.Math.Gain gain1(k=0.5)
            annotation (Placement(transformation(extent={{54,24},{50,28}})));
          Modelica.Blocks.Math.Sum sum1(nin=4)
            annotation (Placement(transformation(extent={{3,-3},{-5,5}},
                rotation=90,
                origin={49,17})));
        Physiolibrary.Blocks.Factors.Normalization MedullaNaEffect
          annotation (Placement(transformation(extent={{58,-4},{38,16}})));
        Physiolibrary.Osmotic.Interfaces.OsmoticPort_a plasma "blood plasma"
            annotation (Placement(transformation(extent={{-108,20},{-88,40}}),
                iconTransformation(extent={{30,-10},{50,10}})));
          QHP.Water.WaterCompartments.Kidney.CD_H2OChannels H2OChannels(
            initialActive=0.969492,
            InactivateKinv=0.008,
            ReactivateK=6.6666666666667e-06)
            annotation (Placement(transformation(extent={{34,-68},{54,-48}})));
        Physiolibrary.Blocks.Math.Reciprocal inv1 annotation (Placement(
              transformation(
              extent={{2,-2},{-2,2}},
              origin={38,60})));
        Physiolibrary.Blocks.Math.Reciprocal inv2 annotation (Placement(
              transformation(
              extent={{-5,-5},{3,3}},
              rotation=180,
              origin={65,5})));
        Physiolibrary.Osmotic.Sensors.FlowMeasure   flowMeasure1
          annotation (Placement(transformation(extent={{62,-2},{82,-22}})));
        Physiolibrary.Blocks.Factors.LagSpline
                                            NephronADHOnPerm(data={{0.0,0.3,0},
              {2.0,1.0,0.5},{10.0,3.0,0}}, Xscale=1e-9/QHP.Substances.Vasopressin.mw,
          HalfTime=Modelica.Math.log(2)*20*60,
          initialValue=2.0)
          annotation (Placement(transformation(
              extent={{10,-10},{-10,10}},
              rotation=270,
              origin={72,-44})));
        Physiolibrary.Blocks.Factors.Spline PermOnOutflow(data={{0.3,0.00,0},{
              1.0,0.93,0.1},{3.0,1.00,0}}) annotation (Placement(transformation(
              extent={{10,-10},{-10,10}},
              rotation=270,
              origin={66,-30})));
        Physiolibrary.Types.Constants.FractionConst             Constant(k=1)
          annotation (Placement(transformation(extent={{76,-32},{72,-28}})));
        Physiolibrary.Types.Constants.FractionConst             Constant1(k=1)
          annotation (Placement(transformation(extent={{38,72},{44,78}})));
        Physiolibrary.Blocks.Factors.LagSpline
                                            NephronADHEffect(data={{0.0,0.060,0},
              {2.0,0.110,0.02},{10,0.160,0}}, Xscale=1e-9/QHP.Substances.Vasopressin.mw,
          HalfTime=Modelica.Math.log(2)*20*60,
          initialValue=2.0,
          Yscale=1e3) "initial: 2 pg/ml = 2e-9 kg/m3, NephronADH.Tau = 20 min"
          annotation (Placement(transformation(
              extent={{10,-10},{-10,10}},
              origin={46,68})));
        Physiolibrary.Osmotic.Sensors.FlowMeasure   flowMeasure2 annotation (
            Placement(transformation(
              extent={{-10,10},{10,-10}},
              rotation=180,
              origin={26,-80})));
        Physiolibrary.Osmotic.Sensors.FlowMeasure   flowMeasure3 annotation (
            Placement(transformation(
              extent={{-10,10},{10,-10}},
              rotation=90,
              origin={12,-30})));
        Physiolibrary.Types.BusConnector busConnector annotation (Placement(
              transformation(extent={{-102,76},{-82,96}}), iconTransformation(
                extent={{-70,66},{-50,86}})));
          Physiolibrary.Osmotic.Components.Membrane glomerulus(
              useHydraulicPressureInputs=true,
          useConductanceInput=true)
            annotation (Placement(transformation(extent={{-66,48},{-46,68}})));
          Physiolibrary.Osmotic.Sensors.FlowMeasure flowMeasure4 annotation (Placement(
                transformation(
                extent={{-10,-10},{10,10}},
                rotation=270,
                origin={-44,24})));
          Physiolibrary.Types.Constants.PressureConst PelvisPressure(k=0)
          annotation (Placement(transformation(extent={{-34,70},{-42,78}})));
          Physiolibrary.Osmotic.Components.Reabsorption ProximalTubule
            annotation (Placement(transformation(extent={{10,-10},{-10,10}},
              rotation=90,
              origin={-18,44})));
        Physiolibrary.Types.Constants.VolumeConst MedullaVolume(k=3.1e-05)
          annotation (Placement(transformation(extent={{-86,-94},{-78,-86}})));
        Physiolibrary.Types.Constants.OsmoticPermeabilityConst Perm(k(displayUnit="ml/(mmHg.min)")=
                 6.500533657329e-10)
          "glomerular Kf and PT conductance (permeability"
          annotation (Placement(transformation(extent={{-68,90},{-60,98}})));
        Physiolibrary.Blocks.Factors.Normalization NephronCountEffect
          annotation (Placement(transformation(extent={{-66,68},{-46,88}})));
          Physiolibrary.Osmotic.Components.IdealOverflowFiltration
                                                               glomerulusFlow(
              useSolutionFlowInput=true) annotation (Placement(transformation(
                extent={{-10,-10},{10,10}},
                rotation=90,
                origin={-78,44})));
        Physiolibrary.Osmotic.Components.SolventFlux distalTubule(
            useSolutionFlowInput=true) annotation (Placement(transformation(
              extent={{-10,-10},{10,10}},
              origin={24,46})));
        QHP.Water.WaterCompartments.Kidney.ZeroOsmol zeroOsmol annotation (
            Placement(transformation(
              extent={{-10,-10},{10,10}},
              rotation=90,
              origin={-4,70})));
        equation

          connect(gain1.y, sum1.u[1]) annotation (Line(
              points={{49.8,26},{48.6,26},{48.6,20.8}},
              color={0,0,127},
              smooth=Smooth.None));
          connect(MedullaNaEffect.yBase, sum1.y)   annotation (Line(
              points={{48,8},{48,11.6}},
              color={0,0,127},
              smooth=Smooth.None));
          connect(inv1.y, ADHEffect.u)  annotation (Line(
              points={{35.8,60},{32,60}},
              color={0,0,127},
              smooth=Smooth.None));
          connect(inv2.y, MedullaNaEffect.u) annotation (Line(
              points={{61.6,6},{56,6}},
              color={0,0,127},
              smooth=Smooth.None));
          connect(H2OChannels.Active, NephronADHOnPerm.yBase) annotation (Line(
              points={{55.6,-51.4},{66,-51.4},{66,-58},{78,-58},{78,-44},{74,
                -44}},
              color={0,0,127},
              smooth=Smooth.None));
          connect(NephronADHOnPerm.y, PermOnOutflow.u) annotation (Line(
              points={{68,-44},{66,-44},{66,-38}},
              color={0,0,127},
              smooth=Smooth.None));
          connect(PermOnOutflow.y, CollectingDuct.FractReab) annotation (Line(
              points={{62,-30},{30,-30},{30,-20},{36,-20}},
              color={0,0,127},
              smooth=Smooth.None));

          connect(Constant.y, PermOnOutflow.yBase) annotation (Line(
              points={{71.5,-30},{68,-30}},
              color={0,0,127},
              smooth=Smooth.None));
          connect(Constant1.y, NephronADHEffect.yBase) annotation (Line(
              points={{44.75,75},{46,75},{46,70}},
              color={0,0,127},
              smooth=Smooth.None));
          connect(NephronADHEffect.y, inv1.u) annotation (Line(
              points={{46,64},{46,60},{40.4,60}},
              color={0,0,127},
              smooth=Smooth.None));
          connect(LoopOfHenle.FractReab, gain.y) annotation (Line(
              points={{-10.2,-62.6},{-15.82,-62.6},{-15.82,-64},{-19.6,-64}},
              color={0,0,127},
              smooth=Smooth.None));

          connect(CollectingDuct.outflowMin, MedullaNaEffect.y) annotation (
              Line(
              points={{48,-8},{48,2}},
              color={0,0,127},
              smooth=Smooth.None));

          //!!!

          connect(busConnector.DT_Na_Outflow, ADHEffect.yBase)       annotation (Line(
              points={{-92,86},{24,86},{24,62}},
              color={0,0,127},
              smooth=Smooth.None));
          connect(gain.u, busConnector.LH_Na_FractReab) annotation (Line(
              points={{-28.8,-64},{-36,-64},{-36,86},{-92,86}},
              color={0,0,127},
              smooth=Smooth.None));
          connect(inv2.u, busConnector.MedullaNa_conc) annotation (Line(
              points={{70.8,6},{96,6},{96,86},{-92,86}},
              color={0,0,127},
              smooth=Smooth.None));
          connect(busConnector.CD_Glucose_Outflow, gain1.u) annotation (Line(
              points={{-92,86},{96.1,86},{96.1,26},{54.4,26}},
              color={0,0,127},
              smooth=Smooth.None));
          connect(busConnector.CD_NH4_Outflow, sum1.u[2]) annotation (Line(
              points={{-92,86},{98,86},{98,20.8},{48.2,20.8}},
              color={0,0,127},
              smooth=Smooth.None));
          connect(busConnector.CD_K_Outflow, sum1.u[3]) annotation (Line(
              points={{-92,86},{98,86},{98,20.8},{47.8,20.8}},
              color={0,0,127},
              smooth=Smooth.None));
          connect(busConnector.CD_Na_Outflow, sum1.u[4]) annotation (Line(
              points={{-92,86},{98,86},{98,20.8},{47.4,20.8}},
              color={0,0,127},
              smooth=Smooth.None));

        connect(NephronADHEffect.u, busConnector.Vasopressin) annotation (Line(
            points={{54,68},{78,68},{78,86},{-92,86}},
            color={0,0,127},
            smooth=Smooth.None), Text(
            string="%second",
            index=1,
            extent={{6,3},{6,3}}));
        connect(NephronADHOnPerm.u, busConnector.Vasopressin) annotation (Line(
            points={{72,-52},{96,-52},{96,86},{-92,86}},
            color={0,0,127},
            smooth=Smooth.None), Text(
            string="%second",
            index=1,
            extent={{6,3},{6,3}}));
          connect(busConnector.GlomerulusBloodPressure, glomerulus.hydraulicPressureIn)
            annotation (Line(
              points={{-92,86},{-92,66},{-64,66}},
              color={0,0,255},
              thickness=0.5,
              smooth=Smooth.None), Text(
              string="%first",
              index=-1,
              extent={{-6,3},{-6,3}}));
          connect(glomerulus.q_out, flowMeasure4.q_in) annotation (Line(
              points={{-46,58},{-44,58},{-44,34}},
              color={127,127,0},
              thickness=1,
              smooth=Smooth.None));
        connect(PelvisPressure.y, glomerulus.hydraulicPressureOut) annotation (
            Line(
            points={{-43,74},{-48,74},{-48,66}},
            color={0,0,127},
            smooth=Smooth.None));
          connect(busConnector.GlomerulusFiltrate_GFR, flowMeasure4.volumeFlowRate)
            annotation (Line(
              points={{-92,86},{-92,24},{-52,24}},
              color={0,0,255},
              thickness=0.5,
              smooth=Smooth.None), Text(
              string="%first",
              index=-1,
              extent={{-6,3},{-6,3}}));
          connect(flowMeasure4.q_out, ProximalTubule.Inflow) annotation (Line(
              points={{-44,14},{-44,12},{-34,12},{-34,58},{-22,58},{-22,54}},
              color={127,127,0},
              thickness=1,
              smooth=Smooth.None));
          connect(ProximalTubule.Outflow, LoopOfHenle.Inflow) annotation (Line(
              points={{-22,34},{-22,-55.4},{-12,-55.4}},
              color={127,127,0},
              thickness=1,
              smooth=Smooth.None));
          connect(LoopOfHenle.Outflow, flowMeasure3.q_in) annotation (Line(
              points={{6,-55.4},{6,-56},{12,-56},{12,-40}},
              color={127,127,0},
              thickness=1,
              smooth=Smooth.None));
          connect(busConnector.LH_H2O_Outflow, flowMeasure3.volumeFlowRate) annotation (
             Line(
              points={{-92,86},{-92,-30},{4,-30}},
              color={0,0,255},
              thickness=0.5,
              smooth=Smooth.None), Text(
              string="%first",
              index=-1,
              extent={{-6,3},{-6,3}}));
          connect(flowMeasure1.volumeFlowRate, busConnector.CD_H2O_Outflow) annotation (
             Line(
              points={{72,-4},{98,-4},{98,86},{-92,86}},
              color={0,0,127},
              smooth=Smooth.None), Text(
              string="%second",
              index=1,
              extent={{6,3},{6,3}}));
          connect(CollectingDuct.Reabsorption, H2OChannels.CD_H2O_Reab) annotation (
              Line(
              points={{44,-26},{44,-48}},
              color={127,127,0},
              thickness=1,
              smooth=Smooth.None));
          connect(flowMeasure2.volumeFlowRate, busConnector.CD_H2O_Reab) annotation (
              Line(
              points={{26,-88},{98,-88},{98,86},{-92,86}},
              color={0,0,127},
              smooth=Smooth.None), Text(
              string="%second",
              index=1,
              extent={{6,3},{6,3}}));
          connect(flowMeasure2.q_in, H2OChannels.q_out) annotation (Line(
              points={{36,-80},{44,-80},{44,-68}},
              color={127,127,0},
              thickness=1,
              smooth=Smooth.None));
          connect(flowMeasure2.q_out, plasma) annotation (Line(
              points={{16,-80},{-98,-80},{-98,30}},
              color={127,127,0},
              thickness=1,
              smooth=Smooth.None));
          connect(LoopOfHenle.Reabsorption, plasma) annotation (Line(
              points={{-3,-68},{-2,-68},{-2,-80},{-98,-80},{-98,30}},
              color={127,127,0},
              thickness=1,
              smooth=Smooth.None));

          connect(ProximalTubule.FractReab, busConnector.PT_Na_FractReab) annotation (Line(
              points={{-14,52},{-14,86},{-92,86}},
              color={0,0,127},
              smooth=Smooth.None));
        connect(MedullaVolume.y, busConnector.Medulla_Volume) annotation (Line(
            points={{-77,-90},{98,-90},{98,86},{-92,86}},
            color={0,0,127},
            smooth=Smooth.None), Text(
            string="%second",
            index=1,
            extent={{6,3},{6,3}}));
        connect(busConnector.Glomerulus_GFR, flowMeasure4.volumeFlowRate)
          annotation (Line(
            points={{-92,86},{-92,24},{-52,24}},
            color={0,0,255},
            thickness=0.5,
            smooth=Smooth.None));
        connect(CollectingDuct.Outflow, flowMeasure1.q_in) annotation (Line(
            points={{54,-12},{62,-12}},
            color={127,127,0},
            thickness=1,
            smooth=Smooth.None));
        connect(flowMeasure1.q_out, urine) annotation (Line(
            points={{82,-12},{94,-12},{94,-72},{89,-72}},
            color={127,127,0},
            thickness=1,
            smooth=Smooth.None));
        connect(Perm.y, NephronCountEffect.yBase) annotation (Line(
            points={{-59,94},{-56,94},{-56,80}},
            color={0,0,127},
            smooth=Smooth.None));
        connect(NephronCountEffect.y, glomerulus.conduction) annotation (Line(
            points={{-56,74},{-56,66}},
            color={0,0,127},
            smooth=Smooth.None));
        connect(busConnector.Kidney_NephronCount_Total_xNormal,
          NephronCountEffect.u) annotation (Line(
            points={{-92,86},{-92,78},{-64,78}},
            color={0,0,255},
            thickness=0.5,
            smooth=Smooth.None), Text(
            string="%first",
            index=-1,
            extent={{-6,3},{-6,3}}));
          connect(plasma, glomerulusFlow.port_a) annotation (Line(
              points={{-98,30},{-82,30},{-82,34.4}},
              color={127,127,0},
              thickness=1,
              smooth=Smooth.None));
          connect(glomerulus.q_in, glomerulusFlow.filtrate) annotation (Line(
              points={{-66,58},{-66,44},{-67.8,44}},
              color={127,127,0},
              thickness=1,
              smooth=Smooth.None));
          connect(busConnector.KidneyPlasmaFlow, glomerulusFlow.solutionFlow)
            annotation (Line(
              points={{-92,86},{-92,44},{-85,44}},
              color={0,0,255},
              thickness=0.5,
              smooth=Smooth.None), Text(
              string="%first",
              index=-1,
              extent={{-6,3},{-6,3}}));
        connect(ADHEffect.y, distalTubule.solutionFlow) annotation (Line(
            points={{24,56},{24,53}},
            color={0,0,127},
            smooth=Smooth.None));
        connect(flowMeasure3.q_out, distalTubule.q_in) annotation (Line(
            points={{12,-20},{12,46},{14,46}},
            color={127,127,0},
            thickness=1,
            smooth=Smooth.None));
        connect(distalTubule.q_out, CollectingDuct.Inflow) annotation (Line(
            points={{34,46},{40,46},{40,36},{30,36},{30,-12},{34,-12}},
            color={127,127,0},
            thickness=1,
            smooth=Smooth.None));
        connect(distalTubule.q_in, zeroOsmol.q_in) annotation (Line(
            points={{14,46},{-4,46},{-4,60}},
            color={127,127,0},
            thickness=1,
            smooth=Smooth.None));
        connect(ProximalTubule.Reabsorption, zeroOsmol.q_in) annotation (Line(
            points={{-8,44},{-4,44},{-4,60}},
            color={127,127,0},
            thickness=1,
            smooth=Smooth.None));
        connect(zeroOsmol.q_out, plasma) annotation (Line(
            points={{-4,80},{-4,100},{-98,100},{-98,30}},
            color={127,127,0},
            thickness=1,
            smooth=Smooth.None));
        end Kidney;

        model ZeroOsmol "Prescripted zero osmolarity"
          extends Physiolibrary.Osmotic.Interfaces.OnePort;

        equation
          q_in.o = 0;

         annotation (
            Icon(coordinateSystem(preserveAspectRatio=false,extent={{-100,
                    -100},{100,100}}),
                                graphics={
                Text(
                  extent={{-100,-80},{100,-54}},
                  textString="%name",
                  lineColor={0,0,255}),
                Rectangle(
                  extent={{-100,-50},{100,50}},
                  lineColor={127,127,0},
                  fillColor={255,255,255},
                  fillPattern=FillPattern.Solid),
                Text(
                  extent={{-100,50},{14,12}},
                  lineColor={0,0,255},
                  textString="0 Osm")}),
            Documentation(revisions="<html>
<p><i>2009-2010</i></p>
<p>Marek Matejak, Charles University, Prague, Czech Republic </p>
</html>"));
        end ZeroOsmol;
      end Kidney;

    model Peritoneum_const
    extends Physiolibrary.Icons.Peritoneum;

    Physiolibrary.Osmotic.Interfaces.OsmoticPort_a flux
        "plasma proteins concentration"
                                      annotation (Placement(transformation(
            extent={{56,30},{76,50}}), iconTransformation(extent={{-10,30},{
              10,50}})));

      parameter Physiolibrary.Types.Volume initialVolume(displayUnit="ml") = 0
        "initial water in peritoneum";

    Physiolibrary.Types.BusConnector busConnector annotation (Placement(
          transformation(extent={{-106,87},{-86,107}}), iconTransformation(
            extent={{60,60},{80,80}})));

    Physiolibrary.Types.Constants.VolumeFlowRateConst PeritoneumSpace_Change(k=0)
        "Water gain to peritoneum. "
        annotation (Placement(transformation(extent={{-66,-4},{-20,42}})));
    Physiolibrary.Types.Constants.VolumeConst
             PeritoneumSpace_Volume(k=1e-18) "Water in peritoneum. [ml]"
    annotation (Placement(transformation(extent={{-66,48},{-20,94}})));

    equation
      flux.q=0;
      connect(PeritoneumSpace_Volume.y, busConnector.PeritoneumSpace_Vol)
        annotation (Line(
          points={{-14.25,71},{26,71},{26,97},{-96,97}},
          color={0,0,127},
          smooth=Smooth.None), Text(
          string="%second",
          index=1,
          extent={{6,3},{6,3}}));
      connect(PeritoneumSpace_Change.y, busConnector.PeritoneumSpace_Change)
        annotation (Line(
          points={{-14.25,19},{26,19},{26,97},{-96,97}},
          color={0,0,127},
          smooth=Smooth.None), Text(
          string="%second",
          index=1,
          extent={{6,3},{6,3}}));
      annotation (
    Documentation(info="<HTML>
<PRE>
QHP 2008 / Peritoneum
</PRE>
</HTML>
",   revisions="<html>
<ul>
<li><i>  </i>
       </li>
<li><i> january 2009 </i><br>
       by Marek Matejak in Modelica initially implemented (consulted with Jiri Kofranek), Charles University, Prague<br>
       orginaly described by Tom Coleman in QHP 2008 beta 3, University of Mississippi Medical Center
       </li>
</ul>
</html>"),     Icon(coordinateSystem(preserveAspectRatio=true, extent={{-100,
                -100},{100,100}}), graphics={Text(
              extent={{-100,120},{100,104}},
              lineColor={0,0,255},
              textString="%name")}));
    end Peritoneum_const;

    model Bladder_steady
     // extends Library.PressureFlow.VolumeCompartement;
      extends Physiolibrary.Icons.Bladder;
    Physiolibrary.Hydraulic.Interfaces.HydraulicPort_a con annotation (
        Placement(transformation(extent={{-84,18},{-44,58}}),
          iconTransformation(extent={{-120,-20},{-80,20}})));
    Physiolibrary.Hydraulic.Sources.UnlimitedOutflowPump
                                                  bladderVoidFlow(
        useSolutionFlowInput=true)
      annotation (Placement(transformation(extent={{-58,-23},{-73,-8}})));
    Physiolibrary.Types.BusConnector busConnector annotation (Placement(
          transformation(extent={{-100,69},{-80,89}}), iconTransformation(
            extent={{-100,-100},{-80,-80}})));

    Physiolibrary.Types.Constants.VolumeConst volumeConstant(k=0.0003)
      annotation (Placement(transformation(extent={{-28,32},{-20,40}})));
    Physiolibrary.Hydraulic.Sensors.FlowMeasure flowMeasure annotation (
        Placement(transformation(
          extent={{-10,10},{10,-10}},
          rotation=270,
          origin={-38,6})));

      Physiolibrary.Hydraulic.Components.ElasticVessel elasticVesselvolumeCompartement(
        stateName="BladderVolume.Mass",
        ZeroPressureVolume(displayUnit="l") = 0.001,
        volume_start=0.0003)
        annotation (Placement(transformation(extent={{-20,54},{0,74}})));
    equation
      connect(con, flowMeasure.q_in) annotation (Line(
          points={{-64,38},{-38,38},{-38,16}},
          color={0,0,0},
          thickness=1,
          smooth=Smooth.None));
      connect(flowMeasure.volumeFlow, busConnector.BladderVoidFlow) annotation (
          Line(
          points={{-50,6},{20,6},{20,79},{-90,79}},
          color={0,0,127},
          smooth=Smooth.None), Text(
          string="%second",
          index=1,
          extent={{6,3},{6,3}}));
    connect(bladderVoidFlow.q_in, flowMeasure.q_out) annotation (Line(
        points={{-58,-15.5},{-48,-15.5},{-48,-16},{-38,-16},{-38,-4}},
        color={0,0,0},
        thickness=1,
        smooth=Smooth.None));
    connect(busConnector.CD_H2O_Outflow, bladderVoidFlow.solutionFlow)
      annotation (Line(
        points={{-90,79},{-90,8},{-66,8},{-66,-10.25},{-65.5,-10.25}},
        color={0,0,255},
        thickness=0.5,
        smooth=Smooth.None), Text(
        string="%first",
        index=-1,
        extent={{-6,3},{-6,3}}));
    connect(con, elasticVesselvolumeCompartement.q_in) annotation (Line(
        points={{-64,38},{-38,38},{-38,64},{-10,64}},
        color={0,0,0},
        thickness=1,
        smooth=Smooth.None));
    connect(elasticVesselvolumeCompartement.volume, busConnector.BladderVolume_Mass)
      annotation (Line(
        points={{-4,54},{-4,44},{20,44},{20,79},{-90,79}},
        color={0,0,127},
        smooth=Smooth.None), Text(
        string="%second",
        index=1,
        extent={{6,3},{6,3}}));
      annotation (Icon(coordinateSystem(preserveAspectRatio=true, extent={{-100,
                -100},{100,100}}), graphics={Text(
              extent={{-100,96},{100,80}},
              lineColor={0,0,255},
              textString="%name")}));
    end Bladder_steady;

    model Bladder_steady2
     // extends Library.PressureFlow.VolumeCompartement;
      extends Physiolibrary.Icons.Bladder;
    Physiolibrary.Osmotic.Interfaces.OsmoticPort_a     con annotation (
        Placement(transformation(extent={{-84,18},{-44,58}}),
          iconTransformation(extent={{-120,-20},{-80,20}})));
    Physiolibrary.Osmotic.Sources.SolventOutflux  bladderVoidFlow(
        useSolutionFlowInput=true)
      annotation (Placement(transformation(extent={{-58,-23},{-73,-8}})));
    Physiolibrary.Types.BusConnector busConnector annotation (Placement(
          transformation(extent={{-100,69},{-80,89}}), iconTransformation(
            extent={{-100,-100},{-80,-80}})));

    Physiolibrary.Osmotic.Sensors.FlowMeasure   flowMeasure annotation (
        Placement(transformation(
          extent={{-10,10},{10,-10}},
          rotation=270,
          origin={-38,6})));

      Physiolibrary.Osmotic.Components.OsmoticCell bladder(volume_start=0.0003)
        annotation (Placement(transformation(extent={{-26,28},{-6,48}})));
    equation
    connect(busConnector.CD_H2O_Outflow, bladderVoidFlow.solutionFlow)
      annotation (Line(
        points={{-90,79},{-90,8},{-66,8},{-66,-10.25},{-65.5,-10.25}},
        color={0,0,255},
        thickness=0.5,
        smooth=Smooth.None), Text(
        string="%first",
        index=-1,
        extent={{-6,3},{-6,3}}));
      connect(flowMeasure.volumeFlowRate, busConnector.BladerVoidFlow)
        annotation (Line(
          points={{-32,6},{22,6},{22,79},{-90,79}},
          color={0,0,127},
          smooth=Smooth.None), Text(
          string="%second",
          index=1,
          extent={{6,3},{6,3}}));
      connect(con, bladder.q_in[1]) annotation (Line(
          points={{-64,38},{-16,38}},
          color={127,127,0},
          thickness=1,
          smooth=Smooth.None));
      connect(flowMeasure.q_in, bladder.q_in[1]) annotation (Line(
          points={{-38,16},{-38,38},{-16,38}},
          color={127,127,0},
          thickness=1,
          smooth=Smooth.None));
      connect(flowMeasure.q_out, bladderVoidFlow.q_in) annotation (Line(
          points={{-38,-4},{-38,-15.5},{-61,-15.5}},
          color={127,127,0},
          thickness=1,
          smooth=Smooth.None));
      connect(bladder.volume, busConnector.BladderVolume_Mass) annotation (Line(
          points={{-10,28},{22,28},{22,79},{-90,79}},
          color={0,0,127},
          smooth=Smooth.None), Text(
          string="%second",
          index=1,
          extent={{6,3},{6,3}}));
      connect(flowMeasure.volumeFlowRate, busConnector.BladderVoidFlow)
        annotation (Line(
          points={{-32,6},{30,6},{30,79},{-90,79}},
          color={0,0,127},
          smooth=Smooth.None));
      annotation (Icon(coordinateSystem(preserveAspectRatio=true, extent={{-100,
                -100},{100,100}}), graphics={Text(
              extent={{-100,96},{100,80}},
              lineColor={0,0,255},
              textString="%name")}));
    end Bladder_steady2;

      model LungEdema_const
      extends Physiolibrary.Icons.Lungs;

       parameter Real initialVolume(displayUnit="ml") = 0;

      Physiolibrary.Osmotic.Interfaces.OsmoticPort_a q_in(o(final displayUnit=
              "g/ml")) annotation (Placement(transformation(extent={{-110,10},{
                -90,30}}), iconTransformation(extent={{-10,30},{10,50}})));
      Physiolibrary.Types.BusConnector busConnector annotation (Placement(
            transformation(extent={{-104,61},{-84,81}}), iconTransformation(
              extent={{60,60},{80,80}})));

      Physiolibrary.Types.Constants.VolumeConst volume(k=0)
        annotation (Placement(transformation(extent={{-66,42},{-58,50}})));
      equation
        q_in.q=0;
      connect(volume.y, busConnector.ExcessLungWater_Volume) annotation (Line(
          points={{-57,46},{-8,46},{-8,71},{-94,71}},
          color={0,0,127},
          smooth=Smooth.None), Text(
          string="%second",
          index=1,
          extent={{6,3},{6,3}}));
          annotation (
      Documentation(info="<HTML>
<PRE>
Torso water compartment.

</PRE>
</HTML>
",     revisions="<html>
<ul>
<li><i>  </i>
       </li>
<li><i> january 2009 </i><br>
       by Marek Matejak in Modelica initially implemented (consulted with Jiri Kofranek), Charles University, Prague<br>
       orginaly described by Tom Coleman in QHP 2008 beta 3, University of Mississippi Medical Center
       </li>
</ul>
</html>"), Icon(coordinateSystem(
                preserveAspectRatio=true, extent={{-100,-100},{100,100}}),
              graphics={                                   Text(
                extent={{-100,88},{100,72}},
                lineColor={0,0,255},
                textString="%name")}));
      end LungEdema_const;

      model Torsos
        import Physiomodel;
          extends Physiolibrary.Icons.Torso;

         replaceable package anatomy = Anatomies.ThreeTorsos
           constrainedby Anatomies
          "Anatomy model to divide body into parts"
          annotation (choicesAllMatching = true);

           parameter anatomy.Parameters anatomyData
           "Definition of the anatomy"
           annotation (choicesAllMatching = true);

          parameter Physiolibrary.Types.Volume InterstitialWater_start
        "Sum of volumes 2270,5670,3400 ml";
          parameter Physiolibrary.Types.Volume IntracellularWater_start
        "Sum of volumes 4980,12460,7470 ml";

          parameter Physiolibrary.Types.VolumeFlowRate NormalLymphFlow
        "Sum of lymph flows 0.4,0.8,1.3 ml/min";

          parameter Physiolibrary.Types.OsmoticPermeability CapillaryConductance
        "Capillary wall permeability for water. 0.6, 3.6, 1.3 ml/(kPa.min)";

          parameter Real[ :,3] InterstitialPressureVolumeData
        "{{600.0,-30.0,0.01},{2000.0,-4.8,0.0004},{5000.0,0.0,0.0004},{12000.0,50.0,0.01}}, {{1200.0,-30.0,0.01},{4800.0,-4.8,0.0004},{12000.0,0.0,0.0004},{24000.0,50.0,0.01}}, {{600.0,-30.0,0.02},{3000.0,-4.8,0.0004},{4000.0,-4.0,0.0004},{6000.0,50.0,0.03}}";
          parameter Physiolibrary.Types.Fraction ICFVFract
        "0.94. Ratio between non-RBC-ICFV and total ICFV, because red cells are not part of any torso ICF!";
          parameter Physiolibrary.Types.Fraction SizeFract "0.2,0.5,0.3";
          parameter Physiolibrary.Types.Fraction CalsFract "0.3,0.5,0.2";
          parameter Physiolibrary.Types.Fraction SweatFract "0.33,0.34,0.33";
          parameter Physiolibrary.Types.Fraction SkinFract "0.33,0.34,0.33";
          parameter Physiolibrary.Types.Fraction LungFract "0,1,0";

      Physiolibrary.Types.TorsoBusConnector torsoSpecific annotation (Placement(
            transformation(extent={{62,27},{80,44}}), iconTransformation(extent=
               {{30,10},{50,30}})));
      Physiolibrary.Osmotic.Interfaces.OsmoticPort_a vascularH2O
        "plasma capillary wall osmotic connector"
        annotation (Placement(transformation(extent={{-92,-42},{-72,-22}}),
            iconTransformation(extent={{-70,-10},{-50,10}})));
        Modelica.Blocks.Math.Gain calsFract(k=CalsFract) annotation (Placement(
              transformation(
              extent={{-6,-6},{6,6}},
              origin={48,-82})));

      //  Physiolibrary.Types.Volume volume;
      //  Physiolibrary.Types.VolumeFlowRate change;
      Physiolibrary.Osmotic.Sources.SolventInflux metabolicH2O(useSolutionFlowInput=true)
          annotation (Placement(transformation(extent={{68,-98},{88,-78}})));
      Physiolibrary.Osmotic.Sensors.FlowMeasure flowMeasure1 annotation (
          Placement(transformation(
            extent={{5,4},{-5,-4}},
            rotation=270,
            origin={24,45})));
      Physiolibrary.Osmotic.Sensors.FlowMeasure flowMeasure2 annotation (
          Placement(transformation(
            extent={{5,6},{-5,-6}},
            rotation=270,
            origin={8,25})));
        Physiolibrary.Osmotic.Components.Membrane capyMembrane(
          useHydraulicPressureInputs=true,
          useTemperatureInputs=false,
          cond=CapillaryConductance)
          annotation (Placement(transformation(extent={{-60,-24},{-40,-4}})));
      Physiolibrary.Osmotic.Components.SolventFlux lymph(useSolutionFlowInput=
            true) annotation (Placement(transformation(
            extent={{-10,10},{10,-10}},
            rotation=180,
            origin={-58,-70})));
      Physiolibrary.Blocks.Factors.Spline InterstitialPressureEffect(
          data={{-14.0,0.0,0.0},{-4.0,1.0,0.1},{2.0,8.0,4.0},{6.0,25.0,0.0}},
          Xscale=101325/760,
          y(unit="m3/s"))
        annotation (Placement(transformation(extent={{-48,-68},{-68,-48}})));
      Physiolibrary.Types.Constants.VolumeFlowRateConst flowConstant(k=
              NormalLymphFlow)
        annotation (Placement(transformation(extent={{-68,-50},{-60,-42}})));
        Physiolibrary.Osmotic.Components.OsmoticCell Interstitium(
            useImpermeableSolutesInput=true, volume_start=InterstitialWater_start,
          NumberOfMembraneTypes=2)
        "Iterstitium has two type of membranes: capillary membrane (index 1) and cell membrane (index 2)"
          annotation (Placement(transformation(extent={{18,-10},{-2,10}})));
        Physiolibrary.Blocks.Interpolation.Curve pressureOnVolume(
          Xscale=1e-6,
          Yscale=101325/760,
        data=InterstitialPressureVolumeData)
          annotation (Placement(transformation(extent={{4,-50},{-16,-30}})));
      Physiolibrary.Osmotic.Sources.SolventOutflux sweat(useSolutionFlowInput=
            true)
        annotation (Placement(transformation(extent={{10,10},{-10,-10}},
            rotation=270,
            origin={24,64})));
      Physiolibrary.Types.Constants.VolumeFlowRateConst Vapor(k=
            6.1666666666667e-09)
          annotation (Placement(transformation(extent={{-24,40},{-16,48}})));
      Physiolibrary.Osmotic.Sources.SolventOutflux insensibleSkinVapor(
            useSolutionFlowInput=true) annotation (Placement(transformation(
              extent={{10,10},{-10,-10}},
              rotation=270,
              origin={8,44})));
        Physiolibrary.Osmotic.Components.OsmoticCell ICF(useImpermeableSolutesInput=true,
            volume_start=IntracellularWater_start)
          annotation (Placement(transformation(extent={{94,-66},{74,-46}})));
        Physiolibrary.Osmotic.Components.Membrane cellMembrane(
          useTemperatureInputs=false,
          useHydraulicPressureInputs=false,
        cond(displayUnit="l/(kPa.min)") = 1.6666666666667e-08)
          annotation (Placement(transformation(extent={{62,-46},{82,-26}})));
      Physiolibrary.Types.BusConnector busConnector annotation (Placement(
            transformation(extent={{30,70},{50,90}}), iconTransformation(extent=
               {{30,70},{50,90}})));
        Modelica.Blocks.Math.Gain sizeFract(k=SizeFract*ICFVFract)
                                                         annotation (Placement(
              transformation(
              extent={{6,-6},{-6,6}},
              rotation=180,
              origin={90,72})));
      Modelica.Blocks.Math.Gain lungFract(k=LungFract)
        annotation (Placement(transformation(extent={{-24,22},{-16,30}})));
      Physiolibrary.Osmotic.Sources.SolventOutflux insensibleLungVapor(
          useSolutionFlowInput=true) annotation (Placement(transformation(
            extent={{-10,-10},{10,10}},
            rotation=90,
            origin={-6,26})));
      Modelica.Blocks.Math.Gain skinFract(k=SkinFract) annotation (Placement(
            transformation(
            extent={{-4,-4},{4,4}},
            origin={-6,44})));
      Modelica.Blocks.Math.Gain sweatFract(k=SweatFract) annotation (Placement(
            transformation(
            extent={{-4,-4},{4,4}},
            origin={10,64})));

        Physiolibrary.Types.VolumeFlowRate fromCapillaries, toLymph, evaporation, fromMetabolism;
      equation
        fromCapillaries = capyMembrane.q_in.q;
        toLymph = lymph.q_out.q;
        evaporation = insensibleLungVapor.q_in.q + insensibleSkinVapor.q_in.q + sweat.q_in.q;
        fromMetabolism = metabolicH2O.q_out.q;

        connect(calsFract.y, metabolicH2O.solutionFlow) annotation (Line(
            points={{54.6,-82},{78,-82},{78,-81}},
            color={0,0,127},
            smooth=Smooth.None));
      //  volume = extravascularH2O.WaterVolume;
      //  change = extravascularH2O.q_out.q;

        connect(vascularH2O, capyMembrane.q_in) annotation (Line(
            points={{-82,-32},{-82,-14},{-60,-14}},
            color={127,127,0},
            thickness=1,
            smooth=Smooth.None));
        connect(InterstitialPressureEffect.y, lymph.solutionFlow) annotation (Line(
            points={{-58,-62},{-58,-63}},
            color={0,0,127},
            smooth=Smooth.None));
        connect(flowConstant.y,InterstitialPressureEffect. yBase) annotation (
            Line(
            points={{-59,-46},{-58,-46},{-58,-56}},
            color={0,0,127},
            smooth=Smooth.None));
        connect(vascularH2O, lymph.q_out) annotation (Line(
            points={{-82,-32},{-82,-70},{-68,-70}},
            color={127,127,0},
            thickness=1,
            smooth=Smooth.None));
        connect(flowMeasure2.q_in, Interstitium.q_in[1]) annotation (Line(
            points={{8,20},{8,-0.5}},
            color={127,127,0},
            thickness=1,
            smooth=Smooth.None));
        connect(pressureOnVolume.u, Interstitium.volume) annotation (Line(
            points={{4,-40},{2,-40},{2,-10}},
            color={0,0,127},
            smooth=Smooth.None));
        connect(pressureOnVolume.val, capyMembrane.hydraulicPressureOut) annotation (
            Line(
            points={{-16,-40},{-20,-40},{-20,-6},{-42,-6}},
            color={0,0,127},
            smooth=Smooth.None));
        connect(pressureOnVolume.val, InterstitialPressureEffect.u) annotation (Line(
            points={{-16,-40},{-20,-40},{-20,-58},{-50,-58}},
            color={0,0,127},
            smooth=Smooth.None));
        connect(sweat.q_in, flowMeasure1.q_out) annotation (Line(
            points={{24,58},{24,50}},
            color={127,127,0},
            thickness=1,
            smooth=Smooth.None));
        connect(insensibleSkinVapor.q_in, flowMeasure2.q_out) annotation (Line(
            points={{8,38},{8,30}},
            color={127,127,0},
            thickness=1,
            smooth=Smooth.None));
        connect(ICF.q_in[1], cellMembrane.q_out) annotation (Line(
            points={{84,-56},{86,-56},{86,-36},{82,-36}},
            color={127,127,0},
            thickness=1,
            smooth=Smooth.None));
        connect(metabolicH2O.q_out, ICF.q_in[1]) annotation (Line(
            points={{84,-88},{96,-88},{96,-56},{84,-56}},
            color={127,127,0},
            thickness=1,
            smooth=Smooth.None));
      connect(flowMeasure1.volumeFlowRate, torsoSpecific.Sweat_H2OOutflow)
        annotation (Line(
          points={{27.2,45},{54,45},{54,35.5},{71,35.5}},
          color={215,215,215},
          smooth=Smooth.None), Text(
          string="%second",
          index=1,
          extent={{6,3},{6,3}}));
      connect(flowMeasure2.volumeFlowRate, torsoSpecific.InsensibleSkin_H2O)
        annotation (Line(
          points={{12.8,25},{54,25},{54,35.5},{71,35.5}},
          color={215,215,215},
          smooth=Smooth.None), Text(
          string="%second",
          index=1,
          extent={{6,3},{6,3}}));
        connect(Interstitium.volume, torsoSpecific.InterstitialWater_Vol) annotation (
           Line(
            points={{2,-10},{54,-10},{54,35.5},{71,35.5}},
            color={215,215,215},
            smooth=Smooth.None), Text(
            string="%second",
            index=1,
            extent={{6,3},{6,3}}));
        connect(Interstitium.impermeableSolutes[1], torsoSpecific.InterstitialProtein_Mass)
          annotation (Line(
            points={{16,5},{54,5},{54,35.5},{71,35.5}},
            color={0,0,127},
            smooth=Smooth.None), Text(
            string="%second",
            index=1,
            extent={{6,3},{6,3}}));
 